"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var disposable_1 = require("@phosphor/disposable");
var toolbar_1 = require("./toolbar");
var renderer_1 = require("./renderer");
var highlight_1 = require("./highlight");
require("../style/index.css");
/**
 * A notebook widget extension that adds a button to the toolbar.
 */
var ButtonExtension = /** @class */ (function () {
    function ButtonExtension() {
    }
    ButtonExtension.prototype.createNew = function (panel, context) {
        var viewResult = toolbar_1.register_view(panel);
        renderer_1.register_renderer(panel, viewResult.dojoView);
        highlight_1.register_highlight(panel);
        return new disposable_1.DisposableDelegate(function () {
            for (var _i = 0, _a = viewResult.group; _i < _a.length; _i++) {
                var btn = _a[_i];
                btn.toolbar.dispose();
            }
        });
    };
    return ButtonExtension;
}());
exports.ButtonExtension = ButtonExtension;
/**
 * Activate the extension.
 */
function activate(app) {
    app.docRegistry.addWidgetExtension('Notebook', new ButtonExtension());
}
;
exports.plugin = {
    activate: activate,
    id: 'jupyterlab_dojo',
    autoStart: true
};
exports.default = exports.plugin;
