"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var apputils_1 = require("@jupyterlab/apputils");
var base_1 = require("@jupyter_dojo/base");
var ExtendedBtn = /** @class */ (function (_super) {
    __extends(ExtendedBtn, _super);
    function ExtendedBtn() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExtendedBtn.prototype.initialize = function (name, icon, help, onclick) {
        this.toolbar = new apputils_1.ToolbarButton({
            className: "jupyter-dojo " + name,
            onClick: onclick,
            tooltip: help
        });
        this.name = name;
        this.button = this.toolbar.node;
        this.icon = document.createElement('i');
        this.icon.classList.add('fa', icon);
        this.button.appendChild(this.icon);
        return this;
    };
    ExtendedBtn.prototype.build = function () { };
    return ExtendedBtn;
}(base_1.ButtonIcon));
exports.ExtendedBtn = ExtendedBtn;
var ExtendedDojoView = /** @class */ (function (_super) {
    __extends(ExtendedDojoView, _super);
    function ExtendedDojoView() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExtendedDojoView.prototype.new_button = function (name, icon, help, onclick) {
        var button = new ExtendedBtn().initialize(name, icon, help, onclick);
        this.buttons.push(button);
        return button;
    };
    return ExtendedDojoView;
}(base_1.DojoView));
exports.ExtendedDojoView = ExtendedDojoView;
function register_view(panel) {
    var group;
    var dojoClock = new base_1.DojoClock();
    var dojoView = new ExtendedDojoView(dojoClock, function (buttons) {
        group = buttons;
        group.reverse();
        for (var _i = 0, group_1 = group; _i < group_1.length; _i++) {
            var btn = group_1[_i];
            panel.toolbar.insertItem(0, btn.name, btn.toolbar);
        }
    }, function (code, mode) {
        var model = panel.notebook.model;
        var cell = null;
        if (mode == "code") {
            cell = model.contentFactory.createCodeCell({});
        }
        else if (mode == "markdown") {
            cell = model.contentFactory.createMarkdownCell({});
        }
        else {
            cell = model.contentFactory.createRawCell({});
        }
        cell.value.text = code;
        model.cells.insert(panel.notebook.activeCellIndex + 1, cell);
    }, function (number) {
        panel.notebook.activeCellIndex += number;
    });
    dojoClock.interfaces.push(dojoView);
    return {
        dojoView: dojoView,
        group: group
    };
}
exports.register_view = register_view;
