"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var cells_1 = require("@jupyterlab/cells");
var codemirror_1 = require("@jupyterlab/codemirror");
function register_highlight(panel) {
    // ToDo: erase mime
    var activeCell = panel.notebook.activeCell;
    var original = {};
    var callback = function () {
        if (activeCell instanceof cells_1.CodeCell) {
            var split = activeCell.model.value.text.split(" ");
            if (split && split.length > 2 && split[0] == "%%write") {
                //activeCell.model.mimeType = split[1];
                if (!(activeCell.id in original)) {
                    original[activeCell.id] = activeCell.model.mimeType;
                }
                activeCell.model.mimeType = codemirror_1.Mode.findByName(split[1]).mime;
            }
            else {
                if (activeCell.id in original) {
                    //activeCell.model.mimeType = panel.notebook.codeMimetype;
                    activeCell.model.mimeType = original[activeCell.id];
                    delete original[activeCell.id];
                }
            }
        }
    };
    if (activeCell) {
        activeCell.model.value.changed.connect(callback);
    }
    panel.notebook.activeCellChanged.connect(function (notebook, cellview) {
        if (activeCell) {
            activeCell.model.value.changed.disconnect(callback);
        }
        activeCell = panel.notebook.activeCell;
        if (activeCell) {
            activeCell.model.value.changed.connect(callback);
        }
    });
}
exports.register_highlight = register_highlight;
