/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.pickle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb = ByteBuffer.allocate(1024);
    int loaded = 0;

    public void put(byte[] byArray) {
        if (byArray.length < this.bb.remaining()) {
            int n = this.bb.position();
            this.bb.position(this.loaded);
            this.bb.put(byArray);
            this.loaded = this.bb.position();
            this.bb.position(n);
            return;
        }
        ByteBuffer byteBuffer = this.bb;
        int n = this.loaded - this.bb.position();
        if (n + byArray.length > this.bb.capacity()) {
            this.bb = ByteBuffer.allocate(n + byArray.length);
        }
        if (n > 0) {
            this.bb.put(byteBuffer.array(), byteBuffer.position(), n);
        }
        this.bb.put(byArray);
        this.loaded = this.bb.position();
        this.bb.position(0);
    }

    @Override
    public int available() {
        int n = this.loaded - this.bb.position();
        return n;
    }

    @Override
    public int read() throws IOException {
        int n = this.loaded - this.bb.position();
        if (n > 0) {
            byte by = this.bb.get();
            return by;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.loaded - this.bb.position();
        if (byArray.length <= n) {
            this.bb.get(byArray);
            return byArray.length;
        }
        this.bb.get(byArray, 0, n);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.loaded - this.bb.position();
        if (n3 == 0) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        this.bb.get(byArray, n, n2);
        return n2;
    }
}

