/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.javadoc;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomUtilities {
    public static void traverseDFS(Node node, Consumer<Node> consumer, short s) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == 1) {
                DomUtilities.traverseDFS(node2, consumer, s);
            }
            if (node2.getNodeType() == s) {
                consumer.accept(node2);
            }
            node2 = node3;
        }
    }

    public static void traverseChildren(Node node, Consumer<Node> consumer, short s) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == s) {
                consumer.accept(node2);
            }
            node2 = node3;
        }
    }

    public static <T> void traverseDFS(Node node, BiConsumer<Node, T> biConsumer, short s, T t) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == 1) {
                DomUtilities.traverseDFS(node2, biConsumer, s, t);
            }
            if (node2.getNodeType() == s) {
                biConsumer.accept(node2, (Node)t);
            }
            node2 = node3;
        }
    }

    public static <T> void traverseChildren(Node node, BiConsumer<Node, T> biConsumer, short s, T t) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == s) {
                biConsumer.accept(node2, (Node)t);
            }
            node2 = node3;
        }
    }

    public static void clearAttributes(Node node) {
        while (node.getAttributes().getLength() > 0) {
            Node node2 = node.getAttributes().item(0);
            node.getAttributes().removeNamedItem(node2.getNodeName());
        }
    }

    public static void clearChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    public static boolean containsNL(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 3 || !node2.getNodeValue().contains("\n")) continue;
            return true;
        }
        return false;
    }

    public static void combineText(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() != 3) {
                node2 = node3;
                continue;
            }
            if (node3 != null && node3.getNodeType() == 3) {
                node2.setTextContent(node2.getNodeValue() + node3.getNodeValue());
                node2.getParentNode().removeChild(node3);
                continue;
            }
            node2 = node3;
        }
    }

    public static void mergeNode(Node node, Node node2) {
        while (node2.hasChildNodes()) {
            node.insertBefore(node2.getFirstChild(), node2);
        }
        node.removeChild(node2);
    }

    static void transferContents(Node node, Node node2) {
        while (node2.hasChildNodes()) {
            node.appendChild(node2.getFirstChild());
        }
    }

    public static void removeWhitespace(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Text text;
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3 || (string = (text = (Text)node2).getNodeValue()) == null) continue;
            string = string.replaceAll("\\s+", " ");
            text.setNodeValue(string);
        }
    }
}

