/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.html;

import java.util.LinkedList;
import org.jpype.html.HtmlHandler;
import org.jpype.html.HtmlParser;
import org.jpype.html.Parser;

public class HtmlGrammar
implements Parser.Grammar {
    static final HtmlGrammar INSTANCE = new HtmlGrammar();
    static final Parser.Rule escaped = new Escaped();
    static final Parser.Rule slash = new Cleanup();
    static final Parser.Rule mergeText = new MergeText();
    static final Parser.Rule beginElement = new BeginElement();
    static final Parser.Rule startElement = new StartElement();
    static final Parser.Rule completeElement = new CompleteElement();
    static final Parser.Rule endElement = new EndElement();
    static final Parser.Rule quote = new StartQuote();
    static final Token[] freeTokens = HtmlGrammar.tokens(Token.LT, Token.AMP, Token.SEMI, Token.TEXT);
    static final Token[] elementTokens = HtmlGrammar.tokens(Token.BANG, Token.AMP, Token.LT, Token.SEMI, Token.SLASH, Token.GT, Token.QUOTE, Token.SQUOTE, Token.TEXT);
    static final Token[] directiveTokens = HtmlGrammar.tokens(Token.DASH, Token.LSB, Token.RSB, Token.LT, Token.GT, Token.QUOTE, Token.SQUOTE, Token.TEXT);
    static final Token[] cdataTokens = HtmlGrammar.tokens(Token.LSB, Token.RSB, Token.GT, Token.TEXT);
    static final Token[] commentTokens = HtmlGrammar.tokens(Token.DASH, Token.GT, Token.TEXT);
    static final Token[] quoteTokens = HtmlGrammar.tokens(Token.QUOTE, Token.TEXT);
    static final Token[] squoteTokens = HtmlGrammar.tokens(Token.SQUOTE, Token.TEXT);
    static final Parser.Rule[] freeRules = HtmlGrammar.rules(beginElement, escaped, mergeText);
    static final Parser.Rule[] elementRules = HtmlGrammar.rules(mergeText, quote, startElement, endElement, completeElement, escaped, slash);
    static final Parser.Rule[] directiveRules = HtmlGrammar.rules(quote, new EndDirective(), mergeText);
    static final Parser.Rule[] cdataRules = HtmlGrammar.rules(new EndCData());
    static final Parser.Rule[] commentRules = HtmlGrammar.rules(new EndComment(), new StartComment());

    private HtmlGrammar() {
    }

    @Override
    public void start(Parser parser) {
        parser.state = State.FREE;
        ((HtmlParser)parser).handler.startDocument();
    }

    @Override
    public Object end(Parser parser) {
        ((HtmlParser)parser).handler.endDocument();
        return ((HtmlParser)parser).handler.getResult();
    }

    static StringBuilder promote(Parser.Entity entity) {
        if (entity.value != null && entity.value instanceof StringBuilder) {
            return (StringBuilder)entity.value;
        }
        StringBuilder stringBuilder = new StringBuilder(entity.toString());
        entity.value = stringBuilder;
        entity.token = Token.TEXT;
        return stringBuilder;
    }

    static HtmlGrammar getGrammar(Parser parser) {
        return (HtmlGrammar)parser.grammar;
    }

    static HtmlHandler getHandler(Parser parser) {
        return ((HtmlParser)parser).handler;
    }

    void flushText(Parser<?> parser) {
        if (parser.stack.isEmpty()) {
            return;
        }
        Parser.Entity entity = parser.stack.removeLast();
        StringBuilder stringBuilder = new StringBuilder();
        for (Parser.Entity entity2 : parser.stack) {
            stringBuilder.append(entity2.toString());
        }
        ((HtmlParser)parser).handler.text(stringBuilder.toString());
        parser.stack.clear();
        parser.stack.add(entity);
    }

    private static Parser.Rule[] rules(Parser.Rule ... ruleArray) {
        return ruleArray;
    }

    private static Token[] tokens(Token ... tokenArray) {
        return tokenArray;
    }

    static enum State implements Parser.State
    {
        FREE(freeTokens, freeRules),
        ELEMENT(elementTokens, elementRules),
        DIRECTIVE(directiveTokens, directiveRules),
        CDATA(cdataTokens, cdataRules),
        COMMENT(commentTokens, commentRules);

        Token[] tokens;
        Parser.Rule[] rules;

        private State(Token[] tokenArray, Parser.Rule[] ruleArray) {
            this.tokens = tokenArray;
            this.rules = ruleArray;
        }

        public Token[] getTokens() {
            return this.tokens;
        }

        @Override
        public Parser.Rule[] getRules() {
            return this.rules;
        }
    }

    static enum Token implements Parser.Token
    {
        TEXT,
        BANG("!"),
        DASH("-"),
        LT("<"),
        GT(">"),
        SLASH("/"),
        AMP("&"),
        SEMI(";"),
        LSB("["),
        RSB("]"),
        CLOSE("</"),
        QUOTE("\""),
        SQUOTE("'"),
        DECL_DIRECTIVE("<!");

        byte value;
        String text;

        private Token() {
        }

        private Token(String string2) {
            this.text = string2;
            if (string2.length() == 1) {
                this.value = (byte)string2.charAt(0);
            }
        }

        @Override
        public final boolean matches(byte by) {
            if (this.value == 0) {
                return true;
            }
            return by == this.value;
        }

        @Override
        public boolean runs() {
            return this == TEXT;
        }

        public String toString() {
            if (this.text != null) {
                return this.text;
            }
            return "TEXT";
        }
    }

    private static class Escaped
    extends Parser.MatchRule {
        public Escaped() {
            super(Token.AMP, Token.TEXT, Token.SEMI);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            Parser.Entity entity = linkedList.removeLast();
            Parser.Entity entity2 = linkedList.removeLast();
            Parser.Entity entity3 = linkedList.getLast();
            HtmlGrammar.promote(entity3).append(entity2.toString()).append(entity.toString());
        }
    }

    private static class Cleanup
    implements Parser.Rule {
        private Cleanup() {
        }

        @Override
        public boolean apply(Parser<?> parser, Parser.Entity entity) {
            if (entity.token == Token.SLASH) {
                parser.lookahead = this::next;
                return false;
            }
            if (entity.token == Token.GT && parser.stack.size() > 4) {
                for (Parser.Entity entity2 : parser.stack) {
                    System.out.print(entity2.token);
                    System.out.print("(");
                    System.out.print(entity2.value);
                    System.out.print(") ");
                }
                System.out.println();
                throw new RuntimeException("Need cleanup");
            }
            return false;
        }

        private boolean next(Parser<?> parser, Parser.Entity entity) {
            if (entity.token != Token.GT) {
                parser.stack.removeLast();
                parser.stack.removeLast();
                entity.value = "/" + entity.value;
                parser.stack.add(entity);
            }
            return false;
        }
    }

    static class MergeText
    extends Parser.MatchRule {
        public MergeText() {
            super(Token.TEXT, Token.TEXT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            Parser.Entity entity = linkedList.removeLast();
            Parser.Entity entity2 = linkedList.getLast();
            HtmlGrammar.promote(entity2).append(entity.toString());
        }
    }

    static class BeginElement
    implements Parser.Rule {
        BeginElement() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token != Token.LT) {
                return false;
            }
            HtmlGrammar.getGrammar(parser).flushText(parser);
            parser.state = State.ELEMENT;
            parser.lookahead = this::next;
            return true;
        }

        public boolean next(Parser<?> parser, Parser.Entity entity) {
            if (entity.token == Token.SLASH) {
                parser.stack.removeLast();
                parser.stack.getLast().token = Token.CLOSE;
                return true;
            }
            if (entity.token == Token.BANG) {
                parser.stack.removeLast();
                Parser.Entity entity2 = parser.stack.getLast();
                entity2.token = Token.DECL_DIRECTIVE;
                parser.lookahead = new Directive();
                parser.state = State.DIRECTIVE;
                return true;
            }
            return false;
        }
    }

    static class StartElement
    extends Parser.MatchRule {
        StartElement() {
            super(Token.LT, Token.TEXT, Token.GT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            linkedList.removeLast();
            Parser.Entity entity = linkedList.removeLast();
            linkedList.removeLast();
            String string = entity.value.toString();
            HtmlGrammar.getGrammar(parser).flushText(parser);
            String[] stringArray = string.split("\\s+", 2);
            if (stringArray.length == 1) {
                HtmlGrammar.getHandler(parser).startElement(string, null);
            } else {
                HtmlGrammar.getHandler(parser).startElement(stringArray[0], stringArray[1]);
            }
            parser.state = State.FREE;
        }
    }

    static class CompleteElement
    extends Parser.MatchRule {
        CompleteElement() {
            super(Token.LT, Token.TEXT, Token.SLASH, Token.GT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            linkedList.removeLast();
            linkedList.removeLast();
            Parser.Entity entity = linkedList.removeLast();
            linkedList.removeLast();
            String string = entity.value.toString();
            linkedList.clear();
            int n = string.indexOf(" ");
            if (n == -1) {
                HtmlGrammar.getHandler(parser).startElement(string, null);
                HtmlGrammar.getHandler(parser).endElement(string);
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n).trim();
                HtmlGrammar.getHandler(parser).startElement(string2, string3);
                HtmlGrammar.getHandler(parser).endElement(string2);
            }
            parser.state = State.FREE;
        }
    }

    static class EndElement
    extends Parser.MatchRule {
        EndElement() {
            super(Token.CLOSE, Token.TEXT, Token.GT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            Parser.Entity entity = linkedList.removeLast();
            Parser.Entity entity2 = linkedList.removeLast();
            Parser.Entity entity3 = linkedList.removeLast();
            String string = entity2.value.toString();
            HtmlGrammar.getGrammar(parser).flushText(parser);
            HtmlGrammar.getHandler(parser).endElement(string);
            parser.state = State.FREE;
        }
    }

    static class StartQuote
    implements Parser.Rule {
        StartQuote() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token == Token.QUOTE || entity.token == Token.SQUOTE) {
                parser.state = new Quoted(entity.token, parser.state);
                parser.stack.removeLast();
                parser.add(Token.TEXT, entity.toString());
                return true;
            }
            return false;
        }
    }

    static class EndDirective
    extends Parser.MatchRule {
        EndDirective() {
            super(Token.DECL_DIRECTIVE, Token.TEXT, Token.GT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            Parser.Entity entity = linkedList.removeLast();
            Parser.Entity entity2 = linkedList.removeLast();
            Parser.Entity entity3 = linkedList.removeLast();
            String string = entity2.value.toString();
            HtmlGrammar.getGrammar(parser).flushText(parser);
            HtmlGrammar.getHandler(parser).directive(string);
            parser.state = State.FREE;
        }
    }

    static class EndCData
    extends Parser.MatchRule {
        public EndCData() {
            super(Token.RSB, Token.RSB, Token.GT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            linkedList.removeLast();
            linkedList.removeLast();
            linkedList.removeLast();
            Parser.Entity entity = linkedList.removeFirst();
            StringBuilder stringBuilder = HtmlGrammar.promote(entity);
            for (Parser.Entity entity2 : linkedList) {
                stringBuilder.append(entity2.toString());
            }
            linkedList.clear();
            ((HtmlParser)parser).handler.cdata(stringBuilder.toString());
            parser.state = State.FREE;
        }
    }

    static class EndComment
    extends Parser.MatchRule {
        public EndComment() {
            super(Token.DASH, Token.DASH, Token.GT);
        }

        @Override
        public void execute(Parser parser) {
            LinkedList<Parser.Entity> linkedList = parser.stack;
            linkedList.removeLast();
            linkedList.removeLast();
            linkedList.removeLast();
            if (linkedList.isEmpty()) {
                return;
            }
            Parser.Entity entity = linkedList.removeFirst();
            StringBuilder stringBuilder = HtmlGrammar.promote(entity);
            for (Parser.Entity entity2 : linkedList) {
                stringBuilder.append(entity2.toString());
            }
            linkedList.clear();
            ((HtmlParser)parser).handler.comment(stringBuilder.toString());
            parser.state = State.FREE;
        }
    }

    static class StartComment
    extends Parser.MatchRule {
        public StartComment() {
            super(Token.LT, Token.BANG, Token.DASH, Token.DASH);
        }

        @Override
        public void execute(Parser parser) {
            parser.lookahead = this::next;
        }

        public boolean next(Parser parser, Parser.Entity entity) {
            if (entity.token == Token.GT) {
                return false;
            }
            parser.error("Comment contains <!--");
            return true;
        }
    }

    static class Quoted
    implements Parser.State,
    Parser.Rule {
        Parser.Token[] tokens;
        Parser.Rule[] rules;
        private Parser.State state;

        Quoted(Parser.Token token, Parser.State state) {
            this.tokens = new Parser.Token[]{token, Token.TEXT};
            this.rules = new Parser.Rule[]{this, mergeText};
            this.state = state;
        }

        @Override
        public Parser.Token[] getTokens() {
            return this.tokens;
        }

        @Override
        public Parser.Rule[] getRules() {
            return this.rules;
        }

        @Override
        public boolean apply(Parser<?> parser, Parser.Entity entity) {
            if (entity.token != this.tokens[0]) {
                return false;
            }
            parser.stack.removeLast();
            Parser.Entity entity2 = parser.stack.getLast();
            HtmlGrammar.promote(entity2).append('\"');
            parser.state = this.state;
            return true;
        }
    }

    static class Comment
    implements Parser.Rule {
        Comment() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token != Token.DASH) {
                parser.error("Expected -");
            }
            parser.lookahead = this::next;
            parser.stack.clear();
            parser.state = State.COMMENT;
            return true;
        }

        public boolean next(Parser parser, Parser.Entity entity) {
            if (entity.token == Token.DASH) {
                parser.error("Bad comment(-)");
            }
            if (entity.token == Token.GT) {
                parser.error("Bad comment(>)");
            }
            return false;
        }
    }

    static class CData
    implements Parser.Rule {
        CData() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token != Token.TEXT) {
                parser.error("Expected CDATA");
            }
            parser.lookahead = this::next;
            return true;
        }

        public boolean next(Parser parser, Parser.Entity entity) {
            if (entity.token != Token.LSB) {
                parser.error("Expected [");
            }
            parser.stack.clear();
            parser.state = State.CDATA;
            return true;
        }
    }

    static class Directive
    implements Parser.Rule {
        Directive() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token == Token.LSB) {
                parser.lookahead = new CData();
                return true;
            }
            if (entity.token == Token.DASH) {
                parser.lookahead = new Comment();
                return true;
            }
            return false;
        }
    }
}

