/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.html;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.ListIterator;

public class Parser<T> {
    final Grammar grammar;
    public State state = null;
    public Token last = null;
    public Rule lookahead = null;
    public LinkedList<Entity> stack = new LinkedList();

    Parser(Grammar grammar) {
        this.grammar = grammar;
    }

    public T parse(InputStream inputStream) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(1024);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        this.stack.clear();
        this.grammar.start(this);
        try {
            while (true) {
                byteBuffer.position(0);
                int n = readableByteChannel.read(byteBuffer);
                if (n < 0) break;
                int n2 = byteBuffer.position();
                byteBuffer.rewind();
                this.process(byteBuffer, byteBuffer2, n);
            }
            this.flushTokens(byteBuffer2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return (T)this.grammar.end(this);
    }

    public T parse(String string) {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(1024);
        this.stack.clear();
        this.grammar.start(this);
        this.process(byteBuffer, byteBuffer2, byArray.length);
        this.flushTokens(byteBuffer2);
        return (T)this.grammar.end(this);
    }

    private void process(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        while (byteBuffer.position() < n) {
            byte by = byteBuffer.get();
            Token token = null;
            for (Token token2 : this.state.getTokens()) {
                if (!token2.matches(by)) continue;
                token = token2;
                break;
            }
            if (token == null) {
                this.error("Unable to parse " + (char)by);
            } else if (token.runs()) {
                if (this.last != token) {
                    this.flushTokens(byteBuffer2);
                }
                if (!byteBuffer2.hasRemaining()) {
                    this.flushTokens(byteBuffer2);
                }
                byteBuffer2.put(by);
            } else {
                if (byteBuffer2.position() > 0) {
                    this.flushTokens(byteBuffer2);
                }
                this.processToken(token, null);
            }
            this.last = token;
        }
    }

    private void flushTokens(ByteBuffer byteBuffer) {
        if (byteBuffer.position() == 0) {
            return;
        }
        this.processToken(this.last, new String(byteBuffer.array(), 0, byteBuffer.position()));
        byteBuffer.rewind();
    }

    protected void processToken(Token token, String string) {
        if (token == null) {
            return;
        }
        Entity entity = this.add(token, string);
        Rule rule = this.lookahead;
        this.lookahead = null;
        if (rule != null && rule.apply(this, entity)) {
            return;
        }
        boolean bl = false;
        block0: while (!bl && !this.stack.isEmpty()) {
            bl = true;
            for (Rule rule2 : this.state.getRules()) {
                if (!rule2.apply(this, this.stack.getLast())) continue;
                bl = false;
                continue block0;
            }
        }
    }

    public Entity add(Token token, String string) {
        Entity entity = new Entity(token, string);
        this.stack.add(entity);
        return entity;
    }

    public void error(String string) {
        throw new RuntimeException("bad_token");
    }

    public static interface State {
        public Token[] getTokens();

        public Rule[] getRules();
    }

    public static interface Token {
        public int ordinal();

        public boolean matches(byte var1);

        public boolean runs();
    }

    public static interface Rule {
        public boolean apply(Parser<?> var1, Entity var2);
    }

    public static interface Grammar {
        public void start(Parser var1);

        public Object end(Parser var1);
    }

    public static class Entity {
        public Token token;
        public Object value;

        private Entity(Token token) {
            this.token = token;
        }

        private Entity(Token token, String string) {
            this.token = token;
            this.value = string;
        }

        public String toString() {
            if (this.value == null) {
                return this.token.toString();
            }
            return this.value.toString();
        }
    }

    static abstract class MatchRule
    implements Rule {
        Token[] pattern;

        MatchRule(Token ... tokenArray) {
            this.pattern = tokenArray;
        }

        public boolean apply(Parser parser, Entity entity) {
            LinkedList<Entity> linkedList = parser.stack;
            int n = linkedList.size();
            if (n < this.pattern.length) {
                return false;
            }
            ListIterator<Entity> listIterator = linkedList.listIterator(linkedList.size());
            for (int i = 0; i < this.pattern.length; ++i) {
                if (!listIterator.hasPrevious()) {
                    return false;
                }
                Entity entity2 = listIterator.previous();
                if (entity2.token == this.pattern[this.pattern.length - i - 1]) continue;
                return false;
            }
            this.execute(parser);
            return true;
        }

        public abstract void execute(Parser var1);
    }
}

