/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.jpype.JPypeContext;
import org.jpype.JPypeKeywords;
import org.jpype.classloader.DynamicClassLoader;
import org.jpype.pkg.JPypePackageManager;

public class JPypePackage {
    final String pkg;
    Map<String, URI> contents;
    int code;
    private final DynamicClassLoader classLoader;

    public JPypePackage(String string) {
        this.pkg = string;
        this.contents = JPypePackageManager.getContentMap(string);
        this.classLoader = (DynamicClassLoader)JPypeContext.getInstance().getClassLoader();
        this.code = this.classLoader.getCode();
    }

    public Object getObject(String string) {
        String string2 = this.pkg + "." + JPypeKeywords.unwrap(string);
        ClassLoader classLoader = JPypeContext.getInstance().getClassLoader();
        try {
            if (JPypePackageManager.isPackage(string2)) {
                return string2;
            }
            Class<?> clazz = Class.forName(string2, false, JPypeContext.getInstance().getClassLoader());
            if (Modifier.isPublic(clazz.getModifiers())) {
                return Class.forName(string2, true, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public String[] getContents() {
        this.checkCache();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.contents.keySet()) {
            URI uRI = this.contents.get(string);
            if (uRI == null) continue;
            Path path = JPypePackageManager.getPath(uRI);
            if (Files.isDirectory(path, new LinkOption[0])) {
                arrayList.add(string);
                continue;
            }
            if (!uRI.toString().endsWith(".class") || !JPypePackage.isPublic(path)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isPublic(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl;
            int n;
            ByteBuffer byteBuffer = ByteBuffer.allocate(3);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(10);
            inputStream.read(byteBuffer2.array());
            ((Buffer)byteBuffer2).rewind();
            int n2 = byteBuffer2.getInt();
            if (n2 != -889275714) {
                boolean bl2 = false;
                return bl2;
            }
            byteBuffer2.getShort();
            byteBuffer2.getShort();
            short s = byteBuffer2.getShort();
            block24: for (n = 0; n < s - 1; ++n) {
                inputStream.read(byteBuffer.array());
                ((Buffer)byteBuffer).rewind();
                bl = byteBuffer.get();
                switch (bl) {
                    case 1: {
                        inputStream.skip(byteBuffer.getShort());
                        continue block24;
                    }
                    case 7: 
                    case 8: 
                    case 16: 
                    case 19: 
                    case 20: {
                        continue block24;
                    }
                    case 15: {
                        inputStream.skip(1L);
                        continue block24;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: {
                        inputStream.skip(2L);
                        continue block24;
                    }
                    case 5: 
                    case 6: {
                        inputStream.skip(6L);
                        ++n;
                        continue block24;
                    }
                    default: {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            }
            inputStream.read(byteBuffer.array());
            ((Buffer)byteBuffer).rewind();
            n = byteBuffer.getShort();
            bl = (n & 1) == 1;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    void checkCache() {
        int n = this.classLoader.getCode();
        if (this.code == n) {
            return;
        }
        this.code = n;
        this.contents = JPypePackageManager.getContentMap(this.pkg);
    }
}

