/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.Buffer;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.jpype.JPypeContext;
import org.jpype.manager.ClassDescriptor;
import org.jpype.manager.MethodResolution;
import org.jpype.manager.ModifierCode;
import org.jpype.manager.TypeAudit;
import org.jpype.manager.TypeFactory;
import org.jpype.proxy.JPypeProxy;

public class TypeManager {
    public long context = 0L;
    public boolean isStarted = false;
    public boolean isShutdown = false;
    public HashMap<Class, ClassDescriptor> classMap = new HashMap();
    public TypeFactory typeFactory = null;
    public TypeAudit audit = null;
    private ClassDescriptor java_lang_Object;
    public Class<? extends Annotation> functionalAnnotation = null;
    private Destroyer destroyer = new Destroyer();
    static boolean hasCallerSensitive = false;

    public TypeManager() {
    }

    public TypeManager(long l, TypeFactory typeFactory) {
        this.context = l;
        this.typeFactory = typeFactory;
    }

    public synchronized void init() {
        try {
            Class[] classArray;
            if (this.isStarted) {
                throw new RuntimeException("Cannot be restarted");
            }
            this.isStarted = true;
            this.isShutdown = false;
            try {
                this.functionalAnnotation = Class.forName("java.lang.FunctionalInterface").asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.java_lang_Object = this.createClass(Object.class, true);
            for (Class clazz : classArray = new Class[]{Class.class, Number.class, CharSequence.class, Throwable.class, Void.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, JPypeProxy.class, Method.class, Field.class}) {
                this.createClass(clazz, true);
            }
            this.createPrimitive("void", Void.TYPE, Void.class);
            this.createPrimitive("boolean", Boolean.TYPE, Boolean.class);
            this.createPrimitive("byte", Byte.TYPE, Byte.class);
            this.createPrimitive("char", Character.TYPE, Character.class);
            this.createPrimitive("short", Short.TYPE, Short.class);
            this.createPrimitive("int", Integer.TYPE, Integer.class);
            this.createPrimitive("long", Long.TYPE, Long.class);
            this.createPrimitive("float", Float.TYPE, Float.class);
            this.createPrimitive("double", Double.TYPE, Double.class);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    public synchronized long findClass(Class<?> clazz) {
        long l;
        if (clazz == null) {
            return 0L;
        }
        if (this.isShutdown) {
            return 0L;
        }
        if (clazz.isSynthetic() && clazz.getSimpleName().contains("$Lambda$")) {
            l = this.getClass(clazz.getInterfaces()[0]).classPtr;
        } else if (clazz.isAnonymousClass()) {
            if (clazz.getInterfaces().length == 1) {
                l = this.getClass(clazz.getInterfaces()[0]).classPtr;
            } else {
                ClassDescriptor classDescriptor = this.getClass(clazz.getSuperclass());
                l = this.createAnonymous(classDescriptor);
            }
        } else {
            l = this.getClass(clazz).classPtr;
        }
        return l;
    }

    public long findClassByName(String string) {
        Class<?> clazz = this.lookupByName(string);
        if (clazz == null) {
            return 0L;
        }
        return this.findClass(clazz);
    }

    public Class<?> lookupByName(String string) {
        ClassLoader classLoader = JPypeContext.getInstance().getClassLoader();
        if (string.endsWith("[]")) {
            int n = 0;
            while (string.endsWith("[]")) {
                ++n;
                string = string.substring(0, string.length() - 2);
            }
            Class<?> clazz = this.lookupByName(string);
            if (clazz == null) {
                return null;
            }
            return Array.newInstance(clazz, new int[n]).getClass();
        }
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.contains("/")) {
                try {
                    return Class.forName(string.replaceAll("/", "."), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            if (!string.contains(".")) {
                if ("boolean".equals(string)) {
                    return Boolean.TYPE;
                }
                if ("byte".equals(string)) {
                    return Byte.TYPE;
                }
                if ("char".equals(string)) {
                    return Character.TYPE;
                }
                if ("short".equals(string)) {
                    return Short.TYPE;
                }
                if ("long".equals(string)) {
                    return Long.TYPE;
                }
                if ("int".equals(string)) {
                    return Integer.TYPE;
                }
                if ("float".equals(string)) {
                    return Float.TYPE;
                }
                if ("double".equals(string)) {
                    return Double.TYPE;
                }
            }
            String[] stringArray = string.split("\\.");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    stringBuilder.append(".");
                    stringBuilder.append(stringArray[i]);
                    Class<?> clazz = Class.forName(stringBuilder.toString());
                    for (int j = i + 1; j < stringArray.length; ++j) {
                        stringBuilder.append("$");
                        stringBuilder.append(stringArray[j]);
                    }
                    return Class.forName(stringBuilder.toString());
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    continue;
                }
            }
            return null;
        }
    }

    public synchronized void populateMethod(long l, Executable executable) {
        long[] lArray;
        if (executable == null) {
            return;
        }
        long l2 = 0L;
        if (executable instanceof Method) {
            l2 = this.getClass(((Method)executable).getReturnType()).classPtr;
        }
        Class<?>[] classArray = executable.getParameterTypes();
        int n = 0;
        if (!Modifier.isStatic(executable.getModifiers()) && !(executable instanceof Constructor)) {
            lArray = new long[classArray.length + 1];
            lArray[0] = this.getClass(executable.getDeclaringClass()).classPtr;
            ++n;
        } else {
            lArray = new long[classArray.length];
        }
        for (Class<?> clazz : classArray) {
            lArray[n] = this.getClass(clazz).classPtr;
            ++n;
        }
        try {
            this.typeFactory.populateMethod(this.context, l, l2, lArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public long findClassForObject(Object object) throws InterruptedException {
        JPypeContext.clearInterrupt(true);
        if (object == null) {
            return 0L;
        }
        Class<?> clazz = object.getClass();
        if (Proxy.isProxyClass(clazz) && Proxy.getInvocationHandler(object) instanceof JPypeProxy) {
            return this.findClass(JPypeProxy.class);
        }
        return this.findClass(clazz);
    }

    public synchronized void shutdown() {
        this.isShutdown = true;
        for (ClassDescriptor classDescriptor : this.classMap.values()) {
            this.destroyer.add(classDescriptor.constructorDispatch);
            this.destroyer.add(classDescriptor.constructors);
            this.destroyer.add(classDescriptor.methodDispatch);
            this.destroyer.add(classDescriptor.methods);
            this.destroyer.add(classDescriptor.fields);
            this.destroyer.add(classDescriptor.anonymous);
            this.destroyer.add(classDescriptor.classPtr);
            classDescriptor.constructorDispatch = 0L;
            classDescriptor.constructors = null;
            classDescriptor.methodDispatch = null;
            classDescriptor.methods = null;
            classDescriptor.fields = null;
            classDescriptor.anonymous = 0L;
            classDescriptor.classPtr = 0L;
        }
        this.destroyer.flush();
        this.classMap.clear();
    }

    private ClassDescriptor getClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.classMap.get(clazz);
        if (classDescriptor != null) {
            return classDescriptor;
        }
        return this.createClass(clazz, false);
    }

    private ClassDescriptor createClass(Class<?> clazz, boolean bl) {
        if (clazz.isArray()) {
            return this.createArrayClass(clazz);
        }
        return this.createOrdinaryClass(clazz, bl, true);
    }

    private ClassDescriptor createOrdinaryClass(Class<?> clazz, boolean bl, boolean bl2) {
        String string;
        int n;
        Class<?> clazz2 = clazz.getSuperclass();
        Class<?>[] classArray = clazz.getInterfaces();
        ClassDescriptor[] classDescriptorArray = new ClassDescriptor[classArray.length + 1];
        long[] lArray = null;
        long l = 0L;
        l = 0L;
        if (clazz2 != null) {
            classDescriptorArray[0] = this.getClass(clazz2);
            l = classDescriptorArray[0].classPtr;
        }
        if (bl2) {
            lArray = new long[classArray.length];
            for (n = 0; n < classArray.length; ++n) {
                classDescriptorArray[n + 1] = this.getClass(classArray[n]);
                lArray[n] = classDescriptorArray[n + 1].classPtr;
            }
        } else {
            lArray = new long[]{};
        }
        n = clazz.getModifiers() & 0xFFFF;
        if (bl) {
            n |= ModifierCode.SPECIAL.value;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            n |= ModifierCode.THROWABLE.value;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            n |= ModifierCode.SERIALIZABLE.value;
        }
        if (Arrays.asList(clazz.getInterfaces()).contains(Comparable.class)) {
            n |= ModifierCode.COMPARABLE.value;
        }
        if (Buffer.class.isAssignableFrom(clazz)) {
            n |= ModifierCode.BUFFER.value | ModifierCode.SPECIAL.value;
        }
        if (this.functionalAnnotation != null && clazz.getAnnotation(this.functionalAnnotation) != null) {
            n |= ModifierCode.FUNCTIONAL.value | ModifierCode.SPECIAL.value;
        }
        if ((string = clazz.getCanonicalName()) == null) {
            string = clazz.getName();
        }
        long l2 = this.typeFactory.defineObjectClass(this.context, clazz, string, l, lArray, n);
        ClassDescriptor classDescriptor = new ClassDescriptor(clazz, l2);
        this.classMap.put(clazz, classDescriptor);
        return classDescriptor;
    }

    private long createAnonymous(ClassDescriptor classDescriptor) {
        if (classDescriptor.anonymous != 0L) {
            return classDescriptor.anonymous;
        }
        classDescriptor.anonymous = this.typeFactory.defineObjectClass(this.context, classDescriptor.cls, classDescriptor.cls.getCanonicalName() + "$Anonymous", classDescriptor.classPtr, null, ModifierCode.ANONYMOUS.value);
        return classDescriptor.anonymous;
    }

    ClassDescriptor createArrayClass(Class clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        long l = this.getClass(clazz2).classPtr;
        int n = clazz.getModifiers() & 0xFFFF;
        String string = clazz.getName();
        if (!string.endsWith(";")) {
            n |= ModifierCode.PRIMITIVE_ARRAY.value;
        }
        long l2 = this.typeFactory.defineArrayClass(this.context, clazz, clazz.getCanonicalName(), this.java_lang_Object.classPtr, l, n);
        ClassDescriptor classDescriptor = new ClassDescriptor(clazz, l2);
        this.classMap.put(clazz, classDescriptor);
        return classDescriptor;
    }

    private void createPrimitive(String string, Class clazz, Class clazz2) {
        long l = this.typeFactory.definePrimitive(this.context, string, clazz, this.getClass((Class)clazz2).classPtr, clazz.getModifiers() & 0xFFFF);
        this.classMap.put(clazz, new ClassDescriptor(clazz, l));
    }

    public synchronized void populateMembers(Class clazz) {
        ClassDescriptor classDescriptor = this.classMap.get(clazz);
        if (classDescriptor == null) {
            throw new RuntimeException("Class not loaded");
        }
        if (classDescriptor.fields != null) {
            return;
        }
        try {
            this.createMembers(classDescriptor);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw exception;
        }
    }

    private void createMembers(ClassDescriptor classDescriptor) {
        this.createFields(classDescriptor);
        this.createConstructorDispatch(classDescriptor);
        this.createMethodDispatches(classDescriptor);
        if (this.audit != null) {
            this.audit.verifyMembers(classDescriptor);
        }
        this.typeFactory.assignMembers(this.context, classDescriptor.classPtr, classDescriptor.constructorDispatch, classDescriptor.methodDispatch, classDescriptor.fields);
    }

    private void createFields(ClassDescriptor classDescriptor) {
        LinkedList linkedList = TypeManager.filterPublic((Member[])classDescriptor.cls.getDeclaredFields());
        long[] lArray = new long[linkedList.size()];
        int n = 0;
        for (Field field : linkedList) {
            lArray[n++] = this.typeFactory.defineField(this.context, classDescriptor.classPtr, field.getName(), field, this.getClass(field.getType()).classPtr, field.getModifiers() & 0xFFFF);
        }
        classDescriptor.fields = lArray;
    }

    public void createConstructorDispatch(ClassDescriptor classDescriptor) {
        Class<?> clazz = classDescriptor.cls;
        LinkedList linkedList = TypeManager.filterPublic((Member[])clazz.getDeclaredConstructors());
        if (linkedList.isEmpty()) {
            return;
        }
        List<MethodResolution> list = MethodResolution.sortMethods(linkedList);
        classDescriptor.constructors = this.createConstructors(classDescriptor, list);
        classDescriptor.constructorDispatch = this.typeFactory.defineMethodDispatch(this.context, classDescriptor.classPtr, "<init>", classDescriptor.constructors, ModifierCode.PUBLIC.value | ModifierCode.CTOR.value);
    }

    private long[] createConstructors(ClassDescriptor classDescriptor, List<MethodResolution> list) {
        int n = list.size();
        long[] lArray = new long[list.size()];
        for (MethodResolution methodResolution : list) {
            Constructor constructor = (Constructor)methodResolution.executable;
            int n2 = 0;
            long[] lArray2 = new long[methodResolution.children.size()];
            for (MethodResolution methodResolution2 : methodResolution.children) {
                lArray2[n2++] = methodResolution2.ptr;
            }
            int n3 = constructor.getModifiers() & 0xFFFF;
            methodResolution.ptr = this.typeFactory.defineMethod(this.context, classDescriptor.classPtr, constructor.toString(), constructor, lArray2, n3 |= ModifierCode.CTOR.value);
            lArray[--n] = methodResolution.ptr;
        }
        return lArray;
    }

    public void createMethodDispatches(ClassDescriptor classDescriptor) {
        Class<?> clazz = classDescriptor.cls;
        LinkedList<Method> linkedList = TypeManager.filterOverridden(clazz, clazz.getMethods());
        LinkedList<Method> linkedList2 = TypeManager.filterOverridden(clazz, clazz.getDeclaredMethods());
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Method object : linkedList2) {
            treeSet.add(object.getName());
        }
        classDescriptor.methods = new long[linkedList2.size()];
        classDescriptor.methodIndex = new Method[linkedList2.size()];
        classDescriptor.methodDispatch = new long[treeSet.size()];
        int n = 0;
        for (String string : treeSet) {
            classDescriptor.methodDispatch[n++] = this.createMethodDispatch(classDescriptor, string, linkedList);
        }
    }

    private long createMethodDispatch(ClassDescriptor classDescriptor, String string, LinkedList<Method> linkedList) {
        Object object;
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Method)iterator.next();
            if (!((Method)object).getName().equals(string)) continue;
            iterator.remove();
            linkedList2.add(object);
            if (Modifier.isStatic(((Method)object).getModifiers())) {
                n |= ModifierCode.STATIC.value;
            }
            if (this.isBeanAccessor((Method)object)) {
                n |= ModifierCode.BEAN_ACCESSOR.value;
            }
            if (!this.isBeanMutator((Method)object)) continue;
            n |= ModifierCode.BEAN_MUTATOR.value;
        }
        object = MethodResolution.sortMethods(linkedList2);
        long[] lArray = this.createMethods(classDescriptor, (List<MethodResolution>)object);
        long l = this.typeFactory.defineMethodDispatch(this.context, classDescriptor.classPtr, string, lArray, n);
        return l;
    }

    private long[] createMethods(ClassDescriptor classDescriptor, List<MethodResolution> list) {
        int n = list.size();
        long[] lArray = new long[list.size()];
        for (MethodResolution methodResolution : list) {
            Method method = (Method)methodResolution.executable;
            Class<?> clazz = method.getDeclaringClass();
            if (method.getDeclaringClass() != classDescriptor.cls) {
                this.populateMembers(clazz);
                methodResolution.ptr = this.classMap.get(clazz).getMethod(method);
                if (methodResolution.ptr == 0L) {
                    if (this.audit != null) {
                        this.audit.failFindMethod(classDescriptor, method);
                    }
                    throw new RuntimeException("Fail");
                }
                lArray[--n] = methodResolution.ptr;
                continue;
            }
            int n2 = 0;
            long[] lArray2 = new long[methodResolution.children.size()];
            for (MethodResolution methodResolution2 : methodResolution.children) {
                lArray2[n2++] = methodResolution2.ptr;
            }
            int n3 = method.getModifiers() & 0xFFFF;
            if (this.isBeanMutator(method)) {
                n3 |= ModifierCode.BEAN_MUTATOR.value;
            }
            if (this.isBeanAccessor(method)) {
                n3 |= ModifierCode.BEAN_ACCESSOR.value;
            }
            if (TypeManager.isCallerSensitive(method)) {
                n3 |= ModifierCode.CALLER_SENSITIVE.value;
            }
            methodResolution.ptr = this.typeFactory.defineMethod(this.context, classDescriptor.classPtr, method.toString(), method, lArray2, n3);
            lArray[--n] = methodResolution.ptr;
            classDescriptor.methods[classDescriptor.methodCounter] = methodResolution.ptr;
            classDescriptor.methodIndex[classDescriptor.methodCounter] = method;
            ++classDescriptor.methodCounter;
        }
        return lArray;
    }

    public static boolean isCallerSensitive(Method method) {
        if (hasCallerSensitive) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!"@jdk.internal.reflect.CallerSensitive()".equals(annotation.toString())) continue;
                return true;
            }
        } else {
            Class<?> clazz = method.getDeclaringClass();
            if (clazz.equals(Class.class) || clazz.equals(ClassLoader.class) || clazz.equals(DriverManager.class)) {
                return true;
            }
        }
        return false;
    }

    public static <T extends Member> LinkedList<T> filterPublic(T[] TArray) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : TArray) {
            if (!Modifier.isPublic(t.getModifiers())) continue;
            linkedList.add(t);
        }
        return linkedList;
    }

    public static LinkedList<Method> filterOverridden(Class<?> clazz, Method[] methodArray) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray) {
            if (!Modifier.isPublic(method.getModifiers()) || TypeManager.isOverridden(clazz, method)) continue;
            linkedList.add(method);
        }
        return linkedList;
    }

    public static boolean isOverridden(Class<?> clazz, Method method) {
        try {
            return !method.equals(clazz.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return false;
        }
    }

    private boolean isBeanAccessor(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterCount() > 0) {
            return false;
        }
        if (method.getName().length() < 4) {
            return false;
        }
        return method.getName().startsWith("get");
    }

    private boolean isBeanMutator(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (method.getName().length() < 4) {
            return false;
        }
        return method.getName().startsWith("set");
    }

    static {
        try {
            Method method = Class.class.getDeclaredMethod("forName", String.class);
            for (Annotation annotation : method.getAnnotations()) {
                if (!"@jdk.internal.reflect.CallerSensitive()".equals(annotation.toString())) continue;
                hasCallerSensitive = true;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    private class Destroyer {
        final int BLOCK_SIZE = 1024;
        long[] queue = new long[1024];
        int index = 0;

        private Destroyer() {
        }

        void add(long l) {
            if (l == 0L) {
                return;
            }
            this.queue[this.index++] = l;
            if (this.index == 1024) {
                this.flush();
            }
        }

        void add(long[] lArray) {
            if (lArray == null) {
                return;
            }
            if (lArray.length > 512) {
                TypeManager.this.typeFactory.destroy(TypeManager.this.context, lArray, lArray.length);
                return;
            }
            if (this.index + lArray.length > 1024) {
                this.flush();
            }
            for (int i = 0; i < lArray.length; ++i) {
                this.queue[this.index++] = lArray[i];
            }
            if (this.index == 1024) {
                this.flush();
            }
        }

        void flush() {
            TypeManager.this.typeFactory.destroy(TypeManager.this.context, this.queue, this.index);
            this.index = 0;
        }
    }
}

