/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.classloader;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DynamicClassLoader
extends ClassLoader {
    List<URLClassLoader> loaders = new LinkedList<URLClassLoader>();
    HashMap<String, ArrayList<URL>> map = new HashMap();

    public DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public int getCode() {
        return this.loaders.hashCode();
    }

    public void addFiles(final Path path, String string) throws IOException {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(string);
        final LinkedList linkedList = new LinkedList();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                if (pathMatcher.matches(path.relativize(path2))) {
                    URL uRL = path2.toUri().toURL();
                    linkedList.add(uRL);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path2, IOException iOException) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        this.loaders.add(new URLClassLoader(linkedList.toArray(new URL[linkedList.size()])));
    }

    public void addFile(Path path) throws FileNotFoundException {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path.toString());
            }
            URL[] uRLArray = new URL[]{path.toUri().toURL()};
            this.loaders.add(new URLClassLoader(uRLArray));
            this.scanJar(path);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class findClass(String string) throws ClassNotFoundException, ClassFormatError {
        String string2 = string.replace('.', '/') + ".class";
        URL uRL = this.getResource(string2);
        if (uRL == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            try (InputStream inputStream = uRLConnection.getInputStream();){
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                Class<?> clazz = this.defineClass(string, byArray2, 0, byArray2.length);
                return clazz;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
    }

    @Override
    public URL getResource(String string) {
        URL uRL = this.getParent().getResource(string);
        if (uRL != null) {
            return uRL;
        }
        for (ClassLoader classLoader : this.loaders) {
            uRL = classLoader.getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.map.containsKey(string)) {
            return this.map.get(string).get(0);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration<URL> enumeration = this.getParent().getResources(string);
        arrayList.addAll(Collections.list(enumeration));
        for (URLClassLoader uRLClassLoader : this.loaders) {
            enumeration = uRLClassLoader.findResources(string);
            arrayList.addAll(Collections.list(enumeration));
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.map.containsKey(string)) {
            arrayList.addAll((Collection)this.map.get(string));
        }
        return Collections.enumeration(arrayList);
    }

    public void addResource(String string, URL uRL) {
        if (!this.map.containsKey(string)) {
            this.map.put(string, new ArrayList());
        }
        this.map.get(string).add(uRL);
    }

    public void scanJar(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            URI uRI = path.toAbsolutePath().toUri();
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (string.startsWith("META-INF/")) continue;
                if (jarEntry.isDirectory()) {
                    return;
                }
                int n = 0;
                while ((n = string.indexOf("/", n)) != -1) {
                    String string2 = string.substring(0, n);
                    ++n;
                    if (hashSet.contains(string2)) continue;
                    String string3 = "jar:" + uRI + "!/" + string2 + "/";
                    hashSet.add(string2);
                    this.addResource(string2, new URL(string3));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

