/*
 * Decompiled with CFR 0.152.
 */
package org.jpype;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jpype.JPypeKeywords;
import org.jpype.JPypeSignal;
import org.jpype.PyExceptionProxy;
import org.jpype.classloader.DynamicClassLoader;
import org.jpype.manager.TypeFactory;
import org.jpype.manager.TypeFactoryNative;
import org.jpype.manager.TypeManager;
import org.jpype.pkg.JPypePackage;
import org.jpype.pkg.JPypePackageManager;
import org.jpype.ref.JPypeReferenceQueue;

public class JPypeContext {
    public final String VERSION = "1.2.1";
    private static JPypeContext INSTANCE = new JPypeContext();
    private long context;
    private TypeFactory typeFactory;
    private TypeManager typeManager;
    private DynamicClassLoader classLoader;
    private final AtomicInteger shutdownFlag = new AtomicInteger();
    private final List<Thread> shutdownHooks = new ArrayList<Thread>();
    private final List<Runnable> postHooks = new ArrayList<Runnable>();

    public static JPypeContext getInstance() {
        return INSTANCE;
    }

    static JPypeContext createContext(long l, ClassLoader classLoader, String string, boolean bl) {
        if (string != null) {
            System.load(string);
        }
        JPypeContext.INSTANCE.context = l;
        JPypeContext.INSTANCE.classLoader = (DynamicClassLoader)classLoader;
        JPypeContext.INSTANCE.typeFactory = new TypeFactoryNative();
        JPypeContext.INSTANCE.typeManager = new TypeManager(l, JPypeContext.INSTANCE.typeFactory);
        INSTANCE.initialize(bl);
        JPypeContext.scanExistingJars();
        return INSTANCE;
    }

    private JPypeContext() {
    }

    void initialize(boolean bl) {
        this.typeManager.init();
        JPypeReferenceQueue.getInstance().start();
        if (!bl) {
            JPypeSignal.installHandlers();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                INSTANCE.shutdown();
            }
        }));
    }

    private void shutdown() {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    Thread.sleep(1L);
                    Thread.yield();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.shutdownHooks.isEmpty()) {
                for (Thread thread : this.shutdownHooks) {
                    thread.start();
                }
                for (Thread thread : this.shutdownHooks) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.shutdownFlag.incrementAndGet();
            Thread thread = Thread.currentThread();
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Thread thread2 : map.keySet()) {
                if (thread == thread2 || thread2.isDaemon()) continue;
                thread2.interrupt();
            }
            JPypeContext.onShutdown(this.context);
            Thread.yield();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JPypeReferenceQueue.getInstance().stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.typeManager.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Runnable runnable : this.postHooks) {
            runnable.run();
        }
    }

    static native void onShutdown(long var0);

    public void addShutdownHook(Thread thread) {
        this.shutdownHooks.add(thread);
    }

    public boolean removeShutdownHook(Thread thread) {
        if (this.shutdownHooks.contains(thread)) {
            this.shutdownHooks.remove(thread);
            return true;
        }
        return Runtime.getRuntime().removeShutdownHook(thread);
    }

    public long getContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void _addPost(Runnable runnable) {
        this.postHooks.add(runnable);
    }

    public Object callMethod(Method method, Object object, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static boolean collect(List list, Object object, int n, int[] nArray, int n2) {
        if (Array.getLength(object) != nArray[n]) {
            return false;
        }
        if (n + 1 == n2) {
            list.add(object);
            return true;
        }
        for (int i = 0; i < nArray[n]; ++i) {
            if (JPypeContext.collect(list, Array.get(object, i), n + 1, nArray, n2)) continue;
            return false;
        }
        return true;
    }

    public Object[] collectRectangular(Object object) {
        int n;
        int n2;
        if (object == null || !object.getClass().isArray()) {
            return null;
        }
        int[] nArray = new int[5];
        int n3 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = object;
        Class<?> clazz = object2.getClass();
        for (n2 = 0; n2 < 5; ++n2) {
            n = Array.getLength(object2);
            if (n == 0) {
                return null;
            }
            nArray[n3++] = n;
            if ((object2 = Array.get(object2, 0)) == null) {
                return null;
            }
            if (!(clazz = clazz.getComponentType()).isArray()) break;
        }
        if (!clazz.isPrimitive()) {
            return null;
        }
        arrayList.add(clazz);
        nArray = Arrays.copyOfRange(nArray, 0, n3);
        arrayList.add(nArray);
        n2 = 1;
        for (n = 0; n < n3 - 1; ++n) {
            n2 *= nArray[n];
        }
        arrayList.ensureCapacity(n2 + 2);
        if (n3 == 5) {
            return null;
        }
        if (!JPypeContext.collect(arrayList, object, 0, nArray, n3)) {
            return null;
        }
        return arrayList.toArray();
    }

    private Object unpack(int n, Object object) {
        Object object2 = Array.get(object, 0);
        Class<?> clazz = object2.getClass();
        int n2 = Array.getLength(object) / n;
        Object object3 = Array.newInstance(clazz, n);
        Object object4 = Array.newInstance(object3.getClass(), n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                Object object5 = Array.get(object, n3);
                Array.set(object3, n4, object5);
                ++n4;
                ++n3;
            }
            Array.set(object4, i, object3);
            if (i >= n2 - 1) continue;
            object3 = Array.newInstance(clazz, n);
        }
        return object4;
    }

    public Object assemble(int[] nArray, Object object) {
        int n = nArray.length;
        if (n == 1) {
            return Array.get(object, 0);
        }
        if (n == 2) {
            return Array.get(this.unpack(nArray[0], object), 0);
        }
        for (int i = 0; i < n - 2; ++i) {
            object = this.unpack(nArray[n - i - 2], object);
        }
        return object;
    }

    public boolean isShutdown() {
        return this.shutdownFlag.get() > 0;
    }

    public static void clearInterrupt(boolean bl) throws InterruptedException {
        block5: {
            try {
                Thread thread = Thread.currentThread();
                if (thread != JPypeSignal.main) {
                    return;
                }
                if (!bl) {
                    JPypeSignal.acknowledgePy();
                }
                if (thread.isInterrupted()) {
                    JPypeSignal.acknowledgePy();
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!bl) break block5;
                throw interruptedException;
            }
        }
    }

    public long getExcClass(Throwable throwable) {
        if (throwable instanceof PyExceptionProxy) {
            return ((PyExceptionProxy)throwable).cls;
        }
        return 0L;
    }

    public long getExcValue(Throwable throwable) {
        if (throwable instanceof PyExceptionProxy) {
            return ((PyExceptionProxy)throwable).value;
        }
        return 0L;
    }

    public Exception createException(long l, long l2) {
        return new PyExceptionProxy(l, l2);
    }

    public boolean order(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        return true;
    }

    public boolean isPackage(String string) {
        string = JPypeKeywords.safepkg(string);
        return JPypePackageManager.isPackage(string);
    }

    public JPypePackage getPackage(String string) {
        if (!JPypePackageManager.isPackage(string = JPypeKeywords.safepkg(string))) {
            return null;
        }
        return new JPypePackage(string);
    }

    public String getFunctional(Class clazz) {
        if (clazz.getDeclaredAnnotation(FunctionalInterface.class) == null) {
            return null;
        }
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            try {
                Object.class.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return method.getName();
            }
        }
        return null;
    }

    public Object[] getStackTrace(Throwable throwable, Throwable throwable2) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || throwable2 == null) {
            return this.toFrames(stackTraceElementArray);
        }
        StackTraceElement[] stackTraceElementArray2 = throwable2.getStackTrace();
        if (stackTraceElementArray2 == null) {
            return this.toFrames(stackTraceElementArray);
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!stackTraceElementArray[i].equals(stackTraceElementArray2[0])) continue;
            return this.toFrames(Arrays.copyOfRange(stackTraceElementArray, 0, i));
        }
        return this.toFrames(stackTraceElementArray);
    }

    private Object[] toFrames(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null) {
            return null;
        }
        Object[] objectArray = new Object[4 * stackTraceElementArray.length];
        int n = 0;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            objectArray[n++] = stackTraceElement.getClassName();
            objectArray[n++] = stackTraceElement.getMethodName();
            objectArray[n++] = stackTraceElement.getFileName();
            objectArray[n++] = stackTraceElement.getLineNumber();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newWrapper(long l) {
        TypeFactory typeFactory = this.typeFactory;
        synchronized (typeFactory) {
            this.typeFactory.newWrapper(this.context, l);
        }
    }

    private static void scanExistingJars() {
        String[] stringArray;
        for (String string : stringArray = System.getProperty("java.class.path").split(File.pathSeparator)) {
            JPypeContext.INSTANCE.classLoader.scanJar(Paths.get(string, new String[0]));
        }
    }
}

