/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.classloader;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;

public class DynamicClassLoader
extends ClassLoader {
    List<ClassLoader> loaders = new LinkedList<ClassLoader>();

    public DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addFiles(final Path path, String string) throws IOException {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(string);
        final LinkedList linkedList = new LinkedList();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                if (pathMatcher.matches(path.relativize(path2))) {
                    URL uRL = path2.toUri().toURL();
                    linkedList.add(uRL);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path2, IOException iOException) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        this.loaders.add(new URLClassLoader(linkedList.toArray(new URL[linkedList.size()])));
    }

    public void addFile(Path path) throws FileNotFoundException {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path.toString());
            }
            URL[] uRLArray = new URL[]{path.toUri().toURL()};
            this.loaders.add(new URLClassLoader(uRLArray));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException, ClassFormatError {
        Class<?> clazz;
        block10: {
            String string2 = string.replace('.', '/') + ".class";
            URL uRL = this.getResource(string2);
            if (uRL == null) {
                throw new ClassNotFoundException(string);
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                clazz = this.defineClass(string, byArray2, 0, byArray2.length);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException(string);
                }
            }
            inputStream.close();
        }
        return clazz;
    }

    @Override
    public URL getResource(String string) {
        for (ClassLoader classLoader : this.loaders) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }
}

