/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.pkg;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jpype.JPypeContext;
import org.jpype.JPypeKeywords;

public class JPypePackageManager {
    static final List<FileSystem> bases = new ArrayList<FileSystem>();
    static final List<ModuleDirectory> modules = JPypePackageManager.getModules();
    static final FileSystemProvider jfsp = JPypePackageManager.getFileSystemProvider("jar");
    static final Map<String, String> env = new HashMap<String, String>();
    static final LinkedList<FileSystem> fs = new LinkedList();

    public static boolean isPackage(String string) {
        return JPypePackageManager.isModulePackage(string = string.replace(".", "/")) || JPypePackageManager.isBasePackage(string) || JPypePackageManager.isJarPackage(string);
    }

    public static Map<String, URI> getContentMap(String string) {
        HashMap<String, URI> hashMap = new HashMap<String, URI>();
        string = string.replace(".", "/");
        JPypePackageManager.getJarContents(hashMap, string);
        JPypePackageManager.getBaseContents(hashMap, string);
        JPypePackageManager.getModuleContents(hashMap, string);
        return hashMap;
    }

    static Path getPath(URI uRI) {
        try {
            return Paths.get(uRI);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            if (uRI.getScheme().equals("jar")) {
                try {
                    fs.add(jfsp.newFileSystem(uRI, env));
                    if (fs.size() > 8) {
                        fs.removeFirst().close();
                    }
                    return Paths.get(uRI);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new FileSystemNotFoundException("Unknown filesystem for " + uRI);
        }
    }

    private static FileSystemProvider getFileSystemProvider(String string) {
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!fileSystemProvider.getScheme().equals(string)) continue;
            return fileSystemProvider;
        }
        throw new FileSystemNotFoundException("Unable to find filesystem for " + string);
    }

    private static void getBaseContents(Map<String, URI> map, String string) {
        for (FileSystem fileSystem : bases) {
            JPypePackageManager.collectContents(map, fileSystem.getPath(string, new String[0]));
        }
    }

    private static boolean isBasePackage(String string) {
        try {
            if (string.isEmpty()) {
                return false;
            }
            for (FileSystem fileSystem : bases) {
                if (!Files.isDirectory(fileSystem.getPath(string, new String[0]), new LinkOption[0])) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Fail checking package '" + string + "'", exception);
        }
    }

    static List<ModuleDirectory> getModules() {
        ArrayList<ModuleDirectory> arrayList = new ArrayList<ModuleDirectory>();
        try {
            FileSystem fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
            Path path = fileSystem.getPath("modules", new String[0]);
            for (Path path2 : Files.newDirectoryStream(path)) {
                arrayList.add(new ModuleDirectory(path2));
            }
        }
        catch (IOException | ProviderNotFoundException exception) {
            // empty catch block
        }
        return arrayList;
    }

    private static boolean isModulePackage(String string) {
        if (modules.isEmpty()) {
            return false;
        }
        String[] stringArray = string.split("/");
        String string2 = string;
        if (stringArray.length > 3) {
            string2 = String.join((CharSequence)"/", Arrays.copyOfRange(stringArray, 0, 3));
        }
        for (ModuleDirectory moduleDirectory : modules) {
            if (!moduleDirectory.contains(string2) || !Files.isDirectory(moduleDirectory.modulePath.resolve(string), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static void getModuleContents(Map<String, URI> map, String string) {
        if (modules.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("/");
        String string2 = string;
        if (stringArray.length > 3) {
            string2 = String.join((CharSequence)"/", Arrays.copyOfRange(stringArray, 0, 3));
        }
        for (ModuleDirectory moduleDirectory : modules) {
            Path path;
            if (!moduleDirectory.contains(string2) || !Files.isDirectory(path = moduleDirectory.modulePath.resolve(string), new LinkOption[0])) continue;
            JPypePackageManager.collectContents(map, path);
        }
    }

    private static boolean isJarPackage(String string) {
        ClassLoader classLoader = JPypeContext.getInstance().getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URI uRI = enumeration.nextElement().toURI();
                if (!Files.isDirectory(JPypePackageManager.getPath(uRI), new LinkOption[0])) continue;
                return true;
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return false;
    }

    private static void getJarContents(Map<String, URI> map, String string) {
        ClassLoader classLoader = JPypeContext.getInstance().getClassLoader();
        try {
            String string2 = string.replace('.', '/');
            Enumeration<URL> enumeration = classLoader.getResources(string2);
            while (enumeration.hasMoreElements()) {
                URI uRI = enumeration.nextElement().toURI();
                Path path = JPypePackageManager.getPath(uRI);
                JPypePackageManager.collectContents(map, path);
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private static void collectContents(Map<String, URI> map, Path path) {
        try {
            for (Path path2 : Files.newDirectoryStream(path)) {
                String string = path2.getFileName().toString();
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (string.endsWith(path2.getFileSystem().getSeparator())) {
                        string = string.substring(0, string.length() - 1);
                    }
                    map.put(JPypeKeywords.wrap(string), JPypePackageManager.toURI(path2));
                    continue;
                }
                if (string.contains("$") || !string.endsWith(".class")) continue;
                String string2 = JPypeKeywords.wrap(string.substring(0, string.length() - 6));
                map.put(string2, JPypePackageManager.toURI(path2));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static URI toURI(Path path) {
        URI uRI = path.toUri();
        if (uRI.getScheme().equals("jar") && uRI.toString().contains("%2520")) {
            uRI = URI.create("jar:" + uRI.getRawSchemeSpecificPart().replaceAll("%25", "%"));
        }
        return uRI;
    }

    static {
        env.put("create", "true");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URI uRI = null;
        try {
            FileSystem fileSystem;
            uRI = classLoader.getResource("java/lang/String.class").toURI();
            if (uRI != null && uRI.getScheme().equals("jar") && (fileSystem = jfsp.newFileSystem(uRI, env)) != null) {
                bases.add(fileSystem);
            }
            if ((uRI = classLoader.getResource("javax/crypto/Cipher.class").toURI()) != null && uRI.getScheme().equals("jar") && (fileSystem = jfsp.newFileSystem(uRI, env)) != null) {
                bases.add(fileSystem);
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private static class ModuleDirectory {
        List<String> contents = new ArrayList<String>();
        private final Path modulePath;

        ModuleDirectory(Path path) {
            this.modulePath = path;
            ModuleDirectory.listPackages(this.contents, path, path, 0);
        }

        boolean contains(String string) {
            for (String string2 : this.contents) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        private static void listPackages(List<String> list, Path path, Path path2, int n) {
            try {
                if (n >= 3) {
                    return;
                }
                for (Path path3 : Files.newDirectoryStream(path2)) {
                    if (!Files.isDirectory(path3, new LinkOption[0])) continue;
                    list.add(path.relativize(path3).toString());
                    ModuleDirectory.listPackages(list, path, path3, n + 1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

