/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.jpype.JPypeKeywords;
import org.jpype.pkg.JPypePackageManager;

public class JPypePackage {
    final String pkg;
    final Map<String, URI> contents;

    public JPypePackage(String string, Map<String, URI> map) {
        this.pkg = string;
        this.contents = map;
    }

    public Object getObject(String string) {
        URI uRI = this.contents.get(string);
        if (uRI == null) {
            return null;
        }
        Path path = JPypePackageManager.getPath(uRI);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path.toString().replace("/", ".");
        }
        if (path.toString().endsWith(".class")) {
            try {
                if (JPypePackage.isPublic(path)) {
                    return Class.forName(this.pkg + "." + JPypeKeywords.unwrap(string));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public String[] getContents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.contents.keySet()) {
            URI uRI = this.contents.get(string);
            if (uRI == null) continue;
            Path path = JPypePackageManager.getPath(uRI);
            if (Files.isDirectory(path, new LinkOption[0])) {
                arrayList.add(string);
                continue;
            }
            if (!uRI.toString().endsWith(".class") || !JPypePackage.isPublic(path)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isPublic(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl;
            int n;
            ByteBuffer byteBuffer = ByteBuffer.allocate(3);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(10);
            inputStream.read(byteBuffer2.array());
            ((Buffer)byteBuffer2).rewind();
            int n2 = byteBuffer2.getInt();
            if (n2 != -889275714) {
                boolean bl2 = false;
                return bl2;
            }
            byteBuffer2.getShort();
            byteBuffer2.getShort();
            short s = byteBuffer2.getShort();
            block16: for (n = 0; n < s - 1; ++n) {
                inputStream.read(byteBuffer.array());
                ((Buffer)byteBuffer).rewind();
                bl = byteBuffer.get();
                switch (bl) {
                    case 1: {
                        inputStream.skip(byteBuffer.getShort());
                        continue block16;
                    }
                    case 7: 
                    case 8: 
                    case 16: 
                    case 19: 
                    case 20: {
                        continue block16;
                    }
                    case 15: {
                        inputStream.skip(1L);
                        continue block16;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: {
                        inputStream.skip(2L);
                        continue block16;
                    }
                    case 5: 
                    case 6: {
                        inputStream.skip(6L);
                        ++n;
                        continue block16;
                    }
                    default: {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            }
            inputStream.read(byteBuffer.array());
            ((Buffer)byteBuffer).rewind();
            n = byteBuffer.getShort();
            bl = (n & 1) == 1;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

