class DescriptorMeta(type):
    def __new__(cls, name, parents, dct):
        def set_function(self, instance, value):
            if name.startswith("Const"):
                if self.name not in instance.__dict__:
                    self.check(value)
                    instance.__dict__[self.name] = value
                else:
                    raise AttributeError("Changing attribute not allowed.")
            else:
                self.check(value)
                instance.__dict__[self.name] = value
        dct["__set__"] = set_function
        
        return type.__new__(cls, name, parents, dct)


class Descriptor(metaclass=DescriptorMeta):
    def __init__(self, name=None, **opts):
        self.name = name
        for key, value in opts.items():
            setattr(self, key, value)

    def __delete__(self, instance):
        raise AttributeError("Deleting attribute not allowed.")
