/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.export.___Exporter;
import org.jmol.g3d.HermiteRenderer;
import org.jmol.modelset.Atom;
import org.jmol.util.Font;
import org.jmol.util.GData;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class Export3D
implements JmolRendererInterface {
    protected ___Exporter exporter;
    private double privateKey;
    private GData gdata;
    private short colix;
    private HermiteRenderer hermite3d;
    private int width;
    private int height;
    private int slab;
    private int depth;
    String exportName;
    private boolean webGL;
    private boolean isCartesian;
    private P3 ptA = new P3();
    private P3 ptB = new P3();
    private P3 ptC = new P3();
    private P3 ptD = new P3();

    @Override
    public boolean isWebGL() {
        return this.webGL;
    }

    @Override
    public Object initializeExporter(Viewer vwr, double privateKey, GData gdata, Map<String, Object> params) {
        this.exportName = (String)params.get("type");
        this.webGL = this.exportName.equals("JS");
        this.exporter = (___Exporter)Interface.getOption("export." + (this.webGL ? "" : "_") + this.exportName + "Exporter", vwr, "export");
        if (this.exporter == null) {
            return null;
        }
        this.exporter.export3D = this;
        this.isCartesian = this.exporter.exportType == 1;
        this.gdata = gdata;
        gdata.setNewWindowParametersForExport();
        this.slab = gdata.slab;
        this.width = gdata.width;
        this.height = gdata.height;
        this.privateKey = privateKey;
        return this.initializeOutput(vwr, privateKey, params) ? this.exporter : null;
    }

    @Override
    public boolean initializeOutput(Viewer vwr, double privateKey, Map<String, Object> params) {
        return this.exporter.initializeOutput(vwr, privateKey, this.gdata, params);
    }

    @Override
    public int getExportType() {
        return this.exporter.exportType;
    }

    @Override
    public String getExportName() {
        return this.exportName;
    }

    @Override
    public String finalizeOutput() {
        return this.exporter.finalizeOutput();
    }

    @Override
    public void setSlab(int slabValue) {
        this.gdata.setSlab(slabValue);
        this.slab = this.gdata.slab;
    }

    @Override
    public void setSlabAndZShade(int slabValue, int depthValue, int zSlab, int zDepth, int zPower) {
        this.gdata.setSlab(slabValue);
        this.slab = this.gdata.slab;
        this.gdata.setDepth(depthValue);
        this.depth = this.gdata.depth;
    }

    @Override
    public void renderBackground(JmolRendererInterface me) {
        if (!this.isCartesian) {
            this.gdata.renderBackground(me);
        }
    }

    @Override
    public void drawAtom(Atom atom, float radius) {
        this.exporter.drawAtom(atom, radius);
    }

    @Override
    public void drawRect(int x, int y, int z, int zSlab, int rWidth, int rHeight) {
        if (this.webGL) {
            return;
        }
        if (zSlab != 0 && this.gdata.isClippedZ(zSlab)) {
            return;
        }
        int w = rWidth - 1;
        int h = rHeight - 1;
        int xRight = x + w;
        int yBottom = y + h;
        if (y >= 0 && y < this.height) {
            this.drawHLine(x, y, z, w);
        }
        if (yBottom >= 0 && yBottom < this.height) {
            this.drawHLine(x, yBottom, z, w);
        }
        if (x >= 0 && x < this.width) {
            this.drawVLine(x, y, z, h);
        }
        if (xRight >= 0 && xRight < this.width) {
            this.drawVLine(xRight, y, z, h);
        }
    }

    private void drawHLine(int x, int y, int z, int w) {
        int argbCurrent = this.gdata.getColorArgbOrGray(this.colix);
        if (w < 0) {
            x += w;
            w = -w;
        }
        for (int i = 0; i <= w; ++i) {
            this.exporter.drawTextPixel(argbCurrent, x + i, y, z);
        }
    }

    private void drawVLine(int x, int y, int z, int h) {
        int argbCurrent = this.gdata.getColorArgbOrGray(this.colix);
        if (h < 0) {
            y += h;
            h = -h;
        }
        for (int i = 0; i <= h; ++i) {
            this.exporter.drawTextPixel(argbCurrent, x, y + i, z);
        }
    }

    @Override
    public void drawFilledCircle(short colixRing, short colixFill, int diameter, int x, int y, int z) {
        if (!this.gdata.isClippedZ(z)) {
            this.exporter.drawFilledCircle(colixRing, colixFill, diameter, x, y, z);
        }
    }

    public void drawCircle(short colix, int diameter, int x, int y, int z, boolean doFill) {
        if (!this.gdata.isClippedZ(z)) {
            this.exporter.drawCircle(x, y, z, diameter, colix, doFill);
        }
    }

    @Override
    public void fillSphereXYZ(int diameter, int x, int y, int z) {
        this.ptA.set(x, y, z);
        this.fillSphereBits(diameter, this.ptA);
    }

    @Override
    public void fillSphereI(int diameter, P3i center) {
        this.ptA.set(center.x, center.y, center.z);
        this.fillSphereBits(diameter, this.ptA);
    }

    @Override
    public void fillSphereBits(int diameter, P3 center) {
        if (diameter != 0) {
            this.exporter.fillSphere(this.colix, diameter, center);
        }
    }

    @Override
    public void fillTextRect(int x, int y, int z, int zSlab, int widthFill, int heightFill) {
        if (this.isCartesian || this.gdata.isClippedZ(zSlab)) {
            return;
        }
        z = this.exporter.fixScreenZ(z);
        this.ptA.set(x, y, z);
        this.ptB.set(x + widthFill, y, z);
        this.ptC.set(x + widthFill, y + heightFill, z);
        this.ptD.set(x, y + heightFill, z);
        this.fillQuadrilateral(this.ptA, this.ptB, this.ptC, this.ptD, false);
    }

    @Override
    public void drawString(String str, Font font3d, int xBaseline, int yBaseline, int z, int zSlab, short bgcolix) {
        if (str != null && !this.gdata.isClippedZ(zSlab)) {
            this.drawStringNoSlab(str, font3d, xBaseline, yBaseline, z, bgcolix);
        }
    }

    @Override
    public void drawStringNoSlab(String str, Font font3d, int xBaseline, int yBaseline, int z, short bgcolix) {
        if (str == null) {
            return;
        }
        z = Math.max(this.slab, z);
        if (font3d == null) {
            font3d = this.gdata.getFont3DCurrent();
        } else {
            this.gdata.setFont(font3d);
        }
        this.exporter.plotText(xBaseline, yBaseline, z, this.colix, str, font3d);
    }

    @Override
    public void drawImage(Object objImage, int x, int y, int z, int zSlab, short bgcolix, int width, int height) {
        if (this.isCartesian || objImage == null || width == 0 || height == 0 || this.gdata.isClippedZ(zSlab)) {
            return;
        }
        z = Math.max(this.slab, z);
        this.exporter.plotImage(x, y, z, objImage, bgcolix, width, height);
    }

    @Override
    public void drawPixel(int x, int y, int z) {
        this.plotPixelClipped(x, y, z);
    }

    void plotPixelClipped(int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, x, y, z, 1);
    }

    @Override
    public void plotPixelClippedP3i(P3i screen) {
        if (this.isClipped(screen.x, screen.y, screen.z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, screen.x, screen.y, screen.z, 1);
    }

    @Override
    public void drawPoints(int count, int[] coordinates, int scale) {
        int i = count * 3;
        while (i > 0) {
            int y;
            int x;
            int z = coordinates[--i];
            --i;
            if (this.isClipped(x = coordinates[--i], y = coordinates[i], z)) continue;
            this.exporter.drawPixel(this.colix, x, y, z, scale);
        }
    }

    @Override
    public void drawDashedLineBits(int run, int rise, P3 pointA, P3 pointB) {
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, pointA, pointB);
    }

    @Override
    public void drawLineXYZ(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.ptA.set(x1, y1, z1);
        this.ptB.set(x2, y2, z2);
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, this.ptA, this.ptB);
    }

    @Override
    public void drawLine(short colixA, short colixB, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.fillCylinderXYZ(colixA, colixB, (byte)2, this.exporter.lineWidthMad, xA, yA, zA, xB, yB, zB);
    }

    @Override
    public void drawLineBits(short colixA, short colixB, P3 pointA, P3 pointB) {
        this.fillCylinderBits2(colixA, colixB, (byte)2, this.exporter.lineWidthMad, pointA, pointB);
    }

    @Override
    public void drawLineAB(P3 pointA, P3 pointB) {
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, pointA, pointB);
    }

    @Override
    public void drawBond(P3 atomA, P3 atomB, short colixA, short colixB, byte endcaps, short mad, int bondOrder) {
        if (mad == 1) {
            mad = this.exporter.lineWidthMad;
        }
        this.exporter.drawCylinder(atomA, atomB, colixA, colixB, endcaps, mad, bondOrder);
    }

    @Override
    public void fillCylinderXYZ(short colixA, short colixB, byte endcaps, int mad, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.ptA.set(xA, yA, zA);
        this.ptB.set(xB, yB, zB);
        this.exporter.drawCylinder(this.ptA, this.ptB, colixA, colixB, endcaps, mad, 1);
    }

    @Override
    public void fillCylinderScreen3I(byte endcaps, int diameter, P3 pointA, P3 pointB, P3 pt0f, P3 pt1f, float radius) {
        if (diameter <= 0) {
            return;
        }
        this.exporter.fillCylinderScreen(this.colix, endcaps, diameter, pointA, pointB, pt0f, pt1f, radius);
    }

    @Override
    public void fillCylinder(byte endcaps, int diameter, P3i pointA, P3i pointB) {
        if (diameter <= 0) {
            return;
        }
        this.ptA.set(pointA.x, pointA.y, pointA.z);
        this.ptB.set(pointB.x, pointB.y, pointB.z);
        this.exporter.fillCylinderScreenMad(this.colix, endcaps, diameter, this.ptA, this.ptB);
    }

    @Override
    public void fillCylinderBits(byte endcaps, int diameter, P3 pointA, P3 pointB) {
        if (diameter <= 0) {
            return;
        }
        if (this.isCartesian) {
            this.exporter.fillCylinderScreen(this.colix, endcaps, diameter, pointA, pointB, null, null, 0.0f);
        } else {
            this.exporter.fillCylinderScreenMad(this.colix, endcaps, diameter, pointA, pointB);
        }
    }

    @Override
    public void fillConeScreen3f(byte endcap, int screenDiameter, P3 pointBase, P3 screenTip, boolean isBarb) {
        this.exporter.fillConeScreen(this.colix, endcap, screenDiameter, pointBase, screenTip, isBarb);
    }

    @Override
    public void drawHermite4(int tension, P3 s0, P3 s1, P3 s2, P3 s3) {
        this.hermite3d.renderHermiteRope(false, tension, 0, 0, 0, s0, s1, s2, s3);
    }

    @Override
    public void fillHermite(int tension, int diameterBeg, int diameterMid, int diameterEnd, P3 s0, P3 s1, P3 s2, P3 s3) {
        this.hermite3d.renderHermiteRope(true, tension, diameterBeg, diameterMid, diameterEnd, s0, s1, s2, s3);
    }

    @Override
    public void drawTriangle3C(P3i screenA, short colixA, P3i screenB, short colixB, P3i screenC, short colixC, int check) {
        if ((check & 1) == 1) {
            this.drawLine(colixA, colixB, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
        }
        if ((check & 2) == 2) {
            this.drawLine(colixB, colixC, screenB.x, screenB.y, screenB.z, screenC.x, screenC.y, screenC.z);
        }
        if ((check & 4) == 4) {
            this.drawLine(colixA, colixC, screenA.x, screenA.y, screenA.z, screenC.x, screenC.y, screenC.z);
        }
    }

    public void drawLineBits(P3 screenA, P3 screenB, short colixA, short colixB) {
        this.exporter.drawCylinder(screenA, screenB, colixA, colixB, (byte)2, this.exporter.lineWidthMad, 1);
    }

    @Override
    public void fillCylinderBits2(short colixA, short colixB, byte endcaps, int mad, P3 screenA, P3 screenB) {
        this.exporter.drawCylinder(screenA, screenB, colixA, colixB, endcaps, mad, 1);
    }

    @Override
    public void fillTriangle3CNBits(P3 pA, short colixA, short nA, P3 pB, short colixB, short nB, P3 pC, short colixC, short nC, boolean twoSided) {
        if (colixA != colixB || colixB != colixC) {
            return;
        }
        this.exporter.fillTriangle(colixA, pA, pB, pC, twoSided);
    }

    @Override
    public void fillTriangle3CN(P3i pointA, short colixA, short normixA, P3i pointB, short colixB, short normixB, P3i pointC, short colixC, short normixC) {
    }

    @Override
    public void fillTriangleTwoSided(short normix, P3 a, P3 b, P3 c) {
        this.exporter.fillTriangle(this.colix, a, b, c, true);
    }

    @Override
    public void fillTriangle3f(P3 pointA, P3 pointB, P3 pointC, boolean setNoisy) {
        this.exporter.fillTriangle(this.colix, pointA, pointB, pointC, false);
    }

    @Override
    public void fillTriangle3i(P3 screenA, P3 screenB, P3 screenC, T3 ptA0, T3 ptB0, T3 ptC0, boolean doShade) {
        this.exporter.fillTriangle(this.colix, screenA, screenB, screenC, true);
    }

    @Override
    public void fillQuadrilateral(P3 pointA, P3 pointB, P3 pointC, P3 pointD, boolean isSolid) {
        this.exporter.fillTriangle(this.colix, pointA, pointB, pointC, false);
        this.exporter.fillTriangle(this.colix, pointA, pointC, pointD, false);
    }

    @Override
    public void drawSurface(MeshSurface meshSurface, short colix) {
        this.exporter.drawSurface(meshSurface, colix);
    }

    @Override
    public void fillEllipsoid(P3 center, P3[] points, int x, int y, int z, int diameter, M3 mToEllipsoidal, double[] coef, M4 mDeriv, int selectedOctant, P3[] octantPoints) {
        this.exporter.fillEllipsoid(center, points, this.colix, x, y, z, diameter, mToEllipsoidal, coef, mDeriv, octantPoints);
    }

    @Override
    public boolean drawEllipse(P3 ptAtom, P3 ptX, P3 ptY, boolean fillArc, boolean wireframeOnly) {
        return this.exporter.drawEllipse(ptAtom, ptX, ptY, this.colix, fillArc);
    }

    @Override
    public boolean isAntialiased() {
        return false;
    }

    @Override
    public boolean checkTranslucent(boolean isAlphaTranslucent) {
        return true;
    }

    @Override
    public boolean haveTranslucentObjects() {
        return true;
    }

    @Override
    public boolean setC(short colix) {
        this.colix = colix;
        this.gdata.setC(colix);
        return true;
    }

    @Override
    public boolean isInDisplayRange(int x, int y) {
        return this.isCartesian || this.gdata.isInDisplayRange(x, y);
    }

    public int clipCode(int x, int y, int z) {
        return this.isCartesian ? this.gdata.clipCode(z) : this.gdata.clipCode3(x, y, z);
    }

    @Override
    public boolean isClippedXY(int diameter, int x, int y) {
        return !this.isCartesian && this.gdata.isClippedXY(diameter, x, y);
    }

    public boolean isClipped(int x, int y, int z) {
        return this.gdata.isClippedZ(z) || this.isClipped(x, y);
    }

    protected boolean isClipped(int x, int y) {
        return !this.isCartesian && this.gdata.isClipped(x, y);
    }

    public double getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void volumeRender4(int diam, int x, int y, int z) {
        this.fillSphereXYZ(diam, x, y, z);
    }

    @Override
    public void renderCrossHairs(int[] minMax, int screenWidth, int screenHeight, P3 navigationOffset, float navigationDepthPercent) {
    }

    @Override
    public void volumeRender(boolean TF) {
    }

    @Override
    public void addRenderer(int tok) {
        if (tok == 0x21000011) {
            this.hermite3d = (HermiteRenderer)new HermiteRenderer().set(this, this.gdata);
        }
    }

    @Override
    public void plotImagePixel(int argb, int x, int y, int z, byte shade, int bgargb, int width, int height, int[] pbuf, Object p, int transpLog) {
        if (this.webGL) {
            return;
        }
        z = Math.max(this.slab, z);
        if (shade != 0) {
            int a = shade == 8 ? 255 : (8 - shade << 4) + (8 - shade);
            argb = argb & 0xFFFFFF | a << 24;
        }
        this.exporter.drawTextPixel(argb, x, y, z);
    }

    @Override
    public void drawHermite7(boolean fill, boolean border, int tension, P3 s0, P3 s1, P3 s2, P3 s3, P3 s4, P3 s5, P3 s6, P3 s7, int aspectRatio, short colixBack) {
        if (colixBack == 0 || this.webGL) {
            this.hermite3d.renderHermiteRibbon(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio, 0);
            return;
        }
        this.hermite3d.renderHermiteRibbon(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio, 1);
        short colix = this.colix;
        this.setC(colixBack);
        this.hermite3d.renderHermiteRibbon(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio, -1);
        this.setC(colix);
    }

    @Override
    public void renderAllStrings(Object jr) {
        if (this.webGL) {
            return;
        }
        this.gdata.renderAllStrings(this);
    }
}

