/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.TempArray;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private P3[] dots;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    private AtomIndexIterator iter;
    private BS bsSurfacePoints;
    private BS bsSurfaceDone;
    private BS[] bsLocale;
    private Map<String, Edge> htEdges;
    protected Lst<Edge> vEdges;
    private Lst<Face> vFaces;
    private final P3 ptS1 = new P3();
    private final P3 ptS2 = new P3();
    protected final V3 vTemp = new V3();
    protected final P4 plane = new P4();
    protected final P3 ptTemp2 = new P3();
    protected final V3 vTemp2 = new V3();
    protected final P3 p = new P3();
    private static boolean testLinear = false;
    private BS[] bsAtomMinMax;
    private boolean isSurfacePoint;
    private int iAtomSurface;
    int nTest = 0;
    private float rAS;
    private float rBS;
    private float rAS2;
    private float rBS2;
    private float dAB;
    private float dAB2;
    private float ecosASB2;

    IsoSolventReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initADR(sg);
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.setup(isMapData);
        this.initializeVolumetricData();
        this.volumeData.setUnitVectors();
        this.vl0 = this.volumeData.volumetricVectorLengths[0];
        this.vl1 = this.volumeData.volumetricVectorLengths[1];
        this.vl2 = this.volumeData.volumetricVectorLengths[2];
        if (this.isProgressive) {
            this.volumeData.getYzCount();
            this.bsAtomMinMax = new BS[this.nPointsX];
            this.getAtomMinMax(null, this.bsAtomMinMax);
            this.voxelSource = new int[this.volumeData.nPoints];
        }
        return true;
    }

    @Override
    protected void setup(boolean isMapData) {
        this.setup2();
        if (this.contactPair == null) {
            this.cavityRadius = this.params.cavityRadius;
            this.envelopeRadius = this.params.envelopeRadius;
            this.sr = this.params.solventRadius;
            this.point = this.params.point;
            this.isCavity = this.params.isCavity && this.meshDataServer != null;
            this.isPocket = this.params.pocket != null && this.meshDataServer != null;
            this.doUseIterator = this.doCalculateTroughs = !isMapData && this.sg.atomDataServer != null && !this.isCavity && this.sr > 0.0f && (this.dataType == 1195 || this.dataType == 1203);
            this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Float.NaN, null);
            if (this.isCavity || this.isPocket) {
                this.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
            }
            this.setHeader("solvent/molecular surface", this.params.calculationType);
            if (this.havePlane || !isMapData) {
                float minPtsPerAng = 0.0f;
                this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, minPtsPerAng);
                this.volumeData.getYzCount();
                this.margin = this.volumeData.maxGrid * 2.0f;
            }
            if (this.bsNearby != null) {
                this.bsMySelected.or(this.bsNearby);
            }
        } else if (!isMapData) {
            this.setVolumeData();
        }
        if (!this.doCalculateTroughs) {
            if (isMapData) {
                this.precalculateVoxelData = false;
                this.volumeData.sr = this;
            } else if (!this.isCavity) {
                this.isXLowToHigh = true;
                this.isProgressive = true;
            }
        }
        if (this.thisAtomSet == null) {
            this.thisAtomSet = BSUtil.setAll((int)this.myAtomCount);
        }
    }

    @Override
    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        if (this.isCavity && this.dataType != 1205 && this.dataType != 1206) {
            this.params.vertexSource = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(this.cavityRadius, this.params.distance);
            this.generateSolventCavity();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, Float.NaN);
        } else {
            this.voxelSource = new int[this.volumeData.nPoints];
            this.generateSolventCube();
        }
        this.unsetVoxelData();
        Lst<Object[]> info = this.params.slabInfo;
        if (info != null) {
            for (int i = 0; i < info.size(); ++i) {
                if (!((Boolean)((Object[])info.get(i))[2]).booleanValue() || !(((Object[])info.get(i))[0] instanceof P4)) continue;
                this.volumeData.capData((P4)((Object[])info.get(i))[0], this.params.cutoff);
                info.removeItemAt(i--);
            }
        }
    }

    @Override
    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA0, int vB0, float[] fReturn, T3 ptReturn) {
        int vs;
        int vA = this.marchingCubes.getLinearOffset(x, y, z, vA0);
        int vB = this.marchingCubes.getLinearOffset(x, y, z, vB0);
        boolean bl = this.isSurfacePoint = this.bsSurfaceVoxels != null && (this.bsSurfaceVoxels.get(vA) || this.bsSurfaceVoxels.get(vB));
        if (this.voxelSource != null && (vs = Math.abs(Float.isNaN(valueB) || valueA < valueB ? this.voxelSource[vA] : this.voxelSource[vB])) > 0) {
            this.iAtomSurface = this.atomIndex[vs - 1];
        }
        if (testLinear || this.voxelSource == null || this.voxelSource[vA] == 0 || this.voxelSource[vA] != this.voxelSource[vB]) {
            return this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
        }
        float fraction = fReturn[0] = MeshSurface.getSphericalInterpolationFraction((double)(this.voxelSource[vA] < 0 ? this.sr : this.atomRadius[this.voxelSource[vA] - 1]), (double)valueA, (double)valueB, (double)edgeVector.length());
        ptReturn.scaleAdd2(fraction, (T3)edgeVector, pointA);
        float diff = valueB - valueA;
        return valueA + fraction * diff;
    }

    @Override
    public int addVertexCopy(T3 vertexXYZ, float value, int assocVertex, boolean asCopy) {
        int i = this.addVC(vertexXYZ, value, assocVertex, asCopy);
        if (i < 0) {
            return i;
        }
        if (this.isSurfacePoint) {
            this.bsSurfacePoints.set(i);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource[i] = this.iAtomSurface;
        }
        return i;
    }

    @Override
    public void selectPocket(boolean doExclude) {
        int i;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        T3[] v = this.meshData.vs;
        int nVertices = this.meshData.vc;
        float[] vv = this.meshData.vvs;
        int nDots = this.dots.length;
        for (int i2 = 0; i2 < nVertices; ++i2) {
            for (int j = 0; j < nDots; ++j) {
                if (!(this.dots[j].distance(v[i2]) < this.envelopeRadius)) continue;
                vv[i2] = Float.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        int nSets = this.meshData.nSets;
        BS pocketSet = BS.newN((int)nSets);
        block2: for (i = 0; i < nSets; ++i) {
            BS ss = this.meshData.surfaceSet[i];
            if (ss == null) continue;
            int j = ss.nextSetBit(0);
            while (j >= 0) {
                if (Float.isNaN(this.meshData.vvs[j])) {
                    pocketSet.set(i);
                    continue block2;
                }
                j = ss.nextSetBit(j + 1);
            }
        }
        for (i = 0; i < nSets; ++i) {
            if (this.meshData.surfaceSet[i] == null || pocketSet.get(i) != doExclude) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (!doExclude) {
            this.meshData.surfaceSet = null;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
            this.meshData = new MeshData();
        }
    }

    @Override
    protected void postProcessVertices() {
        this.setVertexSource();
        if (this.doCalculateTroughs && this.bsSurfacePoints != null) {
            BS bsAll = new BS();
            BS[] bsSurfaces = this.meshData.getSurfaceSet();
            BS[] bsSources = null;
            double[] volumes = (double[])(this.isPocket ? null : MeshData.calculateVolumeOrArea(this.meshData, Integer.MIN_VALUE, false, false));
            float minVolume = this.isCavity ? (float)(4.71238898038469 * Math.pow(this.sr, 3.0)) : 0.0f;
            double maxVolume = 0.0;
            boolean maxIsNegative = false;
            if (volumes != null && !this.isCavity) {
                for (int i = 0; i < this.meshData.nSets; ++i) {
                    double v = volumes[i];
                    if (!(Math.abs(v) > maxVolume)) continue;
                    maxVolume = Math.abs(v);
                    maxIsNegative = v < 0.0;
                }
            }
            double factor = maxIsNegative ? -1 : 1;
            for (int i = 0; i < this.meshData.nSets; ++i) {
                BS bss = bsSurfaces[i];
                if (bss.intersects(this.bsSurfacePoints) && (volumes == null || volumes[i] * factor > (double)minVolume) && this.params.vertexSource != null) {
                    BS bs = new BS();
                    if (bsSources == null) {
                        bsSources = new BS[bsSurfaces.length];
                    }
                    int j = bss.nextSetBit(0);
                    while (j >= 0) {
                        int iatom = this.params.vertexSource[j];
                        if (iatom >= 0) {
                            if (bsAll.get(iatom)) {
                                this.meshData.invalidateSurfaceSet(i);
                                break;
                            }
                            bs.set(iatom);
                        }
                        j = bss.nextSetBit(j + 1);
                    }
                    bsAll.or(bs);
                    continue;
                }
                this.meshData.invalidateSurfaceSet(i);
            }
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 3, null);
                this.meshData = new MeshData();
            }
        }
        if (this.params.thePlane != null && this.params.slabInfo == null) {
            this.params.addSlabInfo(TempArray.getSlabWithinRange((float)-100.0f, (float)0.0f));
        }
    }

    private void generateSolventCavity() {
        int x;
        BS bs = BS.newN((int)(this.nPointsX * this.nPointsY * this.nPointsZ));
        int i = 0;
        int nDots = this.dots.length;
        int n = 0;
        float r2 = this.envelopeRadius;
        for (x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                int z = 0;
                while (z < this.nPointsZ) {
                    block9: {
                        float f;
                        float d = this.voxelData[x][y][z];
                        if (f < Float.MAX_VALUE && d >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(x, y, z, (T3)this.ptV);
                            for (int j = 0; j < nDots; ++j) {
                                if (!(this.dots[j].distance((T3)this.ptV) < r2)) {
                                    continue;
                                }
                                break block9;
                            }
                            bs.set(i);
                            ++n;
                        }
                    }
                    ++z;
                    ++i;
                }
            }
        }
        Logger.info((String)("cavities include " + n + " voxel points"));
        this.atomRadius = new float[n];
        this.atomXyzTruncated = new P3[n];
        int ipt = 0;
        int apt = 0;
        for (x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    if (!bs.get(ipt++)) continue;
                    this.atomXyzTruncated[apt] = new P3();
                    this.volumeData.voxelPtToXYZ(x, y, z, (T3)this.atomXyzTruncated[apt]);
                    this.atomRadius[apt++] = this.voxelData[x][y][z];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n;
        this.thisAtomSet = BSUtil.setAll((int)this.myAtomCount);
        this.rs = null;
        this.setRadii();
    }

    private void generateSolventCube() {
        if (this.dataType == 1205) {
            return;
        }
        this.params.vertexSource = new int[this.volumeData.nPoints];
        this.bsSurfaceDone = new BS();
        this.bsSurfaceVoxels = new BS();
        this.bsSurfacePoints = new BS();
        if (this.doCalculateTroughs) {
            this.iter = this.sg.atomDataServer.getSelectedAtomIterator(this.bsMySelected, true, false, false);
            this.vEdges = new Lst();
            this.bsLocale = new BS[this.myAtomCount];
            this.htEdges = new Hashtable<String, Edge>();
            this.getEdges();
            Logger.info((String)(this.vEdges.size() + " edges"));
            this.vFaces = new Lst();
            this.getFaces();
            Logger.info((String)(this.vFaces.size() + " faces"));
            this.bsLocale = null;
            this.htEdges = null;
            this.iter.release();
            this.iter = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markFaceVoxels(true);
            this.markToroidVoxels();
            this.validSpheres.or(this.noFaceSpheres);
            this.vEdges = null;
            this.markFaceVoxels(false);
            this.vFaces = null;
        } else {
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
        }
        this.markSphereVoxels(0.0f, this.doCalculateTroughs ? Float.MAX_VALUE : this.params.distance);
        this.noFaceSpheres = null;
        this.validSpheres = null;
    }

    private void getEdges() {
        int iatomA;
        for (iatomA = 0; iatomA < this.myAtomCount; ++iatomA) {
            this.bsLocale[iatomA] = new BS();
        }
        for (iatomA = 0; iatomA < this.myAtomCount; ++iatomA) {
            P3 ptA = this.atomXyzTruncated[iatomA];
            float rA = this.rs[iatomA];
            this.sg.atomDataServer.setIteratorForAtom(this.iter, this.atomIndex[iatomA], rA + this.maxRS);
            while (this.iter.hasNext()) {
                int iB = this.iter.next();
                int iatomB = this.myIndex[iB];
                if (iatomA >= this.firstNearbyAtom && iatomB >= this.firstNearbyAtom) continue;
                P3 ptB = this.atomXyzTruncated[iatomB];
                float rB = this.rs[iatomB];
                float dAB = ptA.distance((T3)ptB);
                if (dAB >= rA + rB) continue;
                Edge edge = new Edge(this, iatomA, iatomB, dAB);
                this.vEdges.addLast((Object)edge);
                this.bsLocale[iatomA].set(iatomB);
                this.bsLocale[iatomB].set(iatomA);
                this.htEdges.put(edge.toString(), edge);
            }
        }
    }

    protected Edge findEdge(int i, int j) {
        return this.htEdges.get(i < j ? i + "_" + j : j + "_" + i);
    }

    private void getFaces() {
        BS bs = new BS();
        this.params.surfaceAtoms = this.validSpheres = new BS();
        this.noFaceSpheres = BSUtil.setAll((int)this.myAtomCount);
        int i = this.vEdges.size();
        while (--i >= 0) {
            Edge edge = (Edge)((Object)this.vEdges.get(i));
            int ia = edge.ia;
            int ib = edge.ib;
            bs.clearAll();
            bs.or(this.bsLocale[ia]);
            bs.and(this.bsLocale[ib]);
            int ic = bs.nextSetBit(ib + 1);
            while (ic >= 0) {
                if (this.getSolventPoints(edge, ia, ib, ic)) {
                    boolean isOK = false;
                    Face f = this.validateFace(ia, ib, ic, edge, this.ptS1);
                    if (f != null) {
                        this.vFaces.addLast((Object)f);
                        isOK = true;
                    }
                    if ((f = this.validateFace(ia, ib, ic, edge, this.ptS2)) != null) {
                        this.vFaces.addLast((Object)f);
                        isOK = true;
                    }
                    if (isOK) {
                        this.noFaceSpheres.clear(ia);
                        this.noFaceSpheres.clear(ib);
                        this.noFaceSpheres.clear(ic);
                    }
                }
                ic = bs.nextSetBit(ic + 1);
            }
        }
    }

    private Face validateFace(int ia, int ib, int ic, Edge edge, P3 ptS) {
        this.sg.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, (T3)ptS, this.maxRS);
        boolean isValid = true;
        while (this.iter.hasNext()) {
            float d;
            int iia = this.iter.next();
            int iatom = this.myIndex[iia];
            if (iatom == ia || iatom == ib || iatom == ic || !((d = this.atomData.atoms[iia].distance((T3)ptS)) < this.atomData.atomRadius[iia] + this.sr)) continue;
            isValid = false;
            break;
        }
        Edge bc = this.findEdge(ib, ic);
        Edge ca = this.findEdge(ia, ic);
        Face f = isValid ? new Face(ia, ib, ic, ptS) : null;
        edge.addFace(f);
        bc.addFace(f);
        ca.addFace(f);
        if (!isValid) {
            return null;
        }
        this.validSpheres.set(ia);
        this.validSpheres.set(ib);
        this.validSpheres.set(ic);
        return f;
    }

    private void markFaceVoxels(boolean firstPass) {
        BS bsThisPass = new BS();
        V3 v0 = this.volumetricVectors[0];
        V3 v1 = this.volumetricVectors[1];
        V3 v2 = this.volumetricVectors[2];
        int fi = this.vFaces.size();
        while (--fi >= 0) {
            Face f = (Face)this.vFaces.get(fi);
            P3 ptA = this.atomXyzTruncated[f.ia];
            P3 ptB = this.atomXyzTruncated[f.ib];
            P3 ptC = this.atomXyzTruncated[f.ic];
            P3 ptS = f.pS;
            this.setGridLimitsForAtom(ptS, this.sr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, (T3)this.ptV);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT((T3)this.ptV);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT((T3)this.ptV);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float value = this.sr - this.ptV.distance((T3)ptS);
                        float v = this.voxelData[i][j][k];
                        int ipt = this.volumeData.getPointIndex(i, j, k);
                        if (firstPass && value > 0.0f) {
                            this.bsSurfaceDone.set(ipt);
                        }
                        if (Measure.isInTetrahedron((P3)this.ptV, (P3)ptA, (P3)ptB, (P3)ptC, (P3)ptS, (P4)this.plane, (V3)this.vTemp, (V3)this.vTemp2, (boolean)false) && (!firstPass ? !this.bsSurfaceDone.get(ipt) && value < 0.0f && value > -this.volumeData.maxGrid * 1.8f && value > v == bsThisPass.get(ipt) : value > 0.0f && (v < 0.0f || v == Float.MAX_VALUE || value > v == bsThisPass.get(ipt)))) {
                            bsThisPass.set(ipt);
                            this.setVoxel(i, j, k, ipt, value);
                            if (this.voxelSource != null) {
                                this.voxelSource[ipt] = -1 - f.ia;
                            }
                            if (value > 0.0f) {
                                this.bsSurfaceVoxels.set(ipt);
                            }
                        }
                        this.ptV.add((T3)v2);
                    }
                    this.ptV.add2((T3)v1, (T3)this.ptZ0);
                }
                this.ptV.add2((T3)v0, (T3)this.ptY0);
            }
        }
    }

    private void markToroidVoxels() {
        V3 v0 = this.volumetricVectors[0];
        V3 v1 = this.volumetricVectors[1];
        V3 v2 = this.volumetricVectors[2];
        int ei = this.vEdges.size();
        while (--ei >= 0) {
            Edge edge = (Edge)((Object)this.vEdges.get(ei));
            if (!edge.isValid()) continue;
            int ia = edge.ia;
            int ib = edge.ib;
            P3 ptA = this.atomXyzTruncated[ia];
            P3 ptB = this.atomXyzTruncated[ib];
            this.rAS = this.rs[ia];
            this.rBS = this.rs[ib];
            this.rAS2 = this.rs2[ia];
            this.rBS2 = this.rs2[ib];
            this.dAB = edge.d;
            this.dAB2 = edge.d2;
            this.ecosASB2 = edge.cosASB2;
            this.setGridLimitsForAtom(edge, edge.maxr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, (T3)this.ptV);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT((T3)this.ptV);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT((T3)this.ptV);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float value;
                        float dVS = this.checkSpecialVoxel(ptA, ptB, this.ptV);
                        if (!Float.isNaN(dVS) && (value = this.sr - dVS) < this.voxelData[i][j][k]) {
                            int ipt = this.volumeData.getPointIndex(i, j, k);
                            this.setVoxel(i, j, k, ipt, value);
                            if (this.voxelSource != null) {
                                this.voxelSource[ipt] = -1 - ia;
                            }
                        }
                        this.ptV.add((T3)v2);
                    }
                    this.ptV.add2((T3)v1, (T3)this.ptZ0);
                }
                this.ptV.add2((T3)v0, (T3)this.ptY0);
            }
        }
    }

    @Override
    protected void unsetVoxelData() {
        if (!this.havePlane) {
            this.unsetVoxelData2();
            return;
        }
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] < 0.001f) continue;
                this.thisPlane[i] = 0.001f;
            }
        } else {
            for (int x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (this.voxelData[x][y][z] < 0.001f) continue;
                        this.voxelData[x][y][z] = 0.001f;
                    }
                }
            }
        }
    }

    private boolean getSolventPoints(Edge edge, int ia, int ib, int ic) {
        float rAS = this.rs[ia];
        V3 v = edge.v;
        float cosAngleBAS = (edge.d2 + this.rs2[ia] - this.rs2[ib]) / (2.0f * edge.d * rAS);
        float angleBAS = (float)Math.acos(cosAngleBAS);
        this.p.scaleAdd2(cosAngleBAS * rAS, (T3)v, (T3)this.atomXyzTruncated[ia]);
        Measure.getPlaneThroughPoint((T3)this.p, (V3)v, (P4)this.plane);
        float dPS = (float)(Math.sin(angleBAS) * (double)rAS);
        P3 ptC = this.atomXyzTruncated[ic];
        float rCS = this.rs[ic];
        float dCT = Measure.distanceToPlane((P4)this.plane, (T3)ptC);
        if (Math.abs(dCT) >= rCS * 0.9f) {
            return false;
        }
        this.ptTemp.scaleAdd2(-dCT, (T3)v, (T3)ptC);
        float dpT = this.p.distance((T3)this.ptTemp);
        float dsp2 = dPS * dPS;
        float dST2 = this.rs2[ic] - dCT * dCT;
        float cosTheta = (dsp2 + dpT * dpT - dST2) / (2.0f * dPS * dpT);
        if ((double)Math.abs(cosTheta) >= 0.99) {
            return false;
        }
        V3 vXS = this.vTemp2;
        vXS.sub2((T3)this.ptTemp, (T3)this.p);
        vXS.normalize();
        this.ptTemp.scaleAdd2(dPS * cosTheta, (T3)vXS, (T3)this.p);
        vXS.cross((T3)v, (T3)vXS);
        vXS.normalize();
        vXS.scale((float)(Math.sqrt(1.0f - cosTheta * cosTheta) * (double)dPS));
        this.ptS1.add2((T3)this.ptTemp, (T3)vXS);
        this.ptS2.sub2((T3)this.ptTemp, (T3)vXS);
        return true;
    }

    private float checkSpecialVoxel(P3 ptA, P3 ptB, P3 ptV) {
        float f;
        float dAV = ptA.distance((T3)ptV);
        float dAV2 = ptA.distanceSquared((T3)ptV);
        float f2 = this.rAS / dAV;
        if (f2 > 1.0f) {
            this.p.set(ptA.x + (ptV.x - ptA.x) * f2, ptA.y + (ptV.y - ptA.y) * f2, ptA.z + (ptV.z - ptA.z) * f2);
            return ptB.distanceSquared((T3)this.p) >= this.rBS2 ? Float.NaN : this.solventDistance(this.rAS, this.rAS2, this.rBS2, dAV, dAV2, ptB.distanceSquared((T3)ptV));
        }
        float dBV = ptB.distance((T3)ptV);
        f2 = this.rBS / dBV;
        if (f > 1.0f) {
            this.p.set(ptB.x + (ptV.x - ptB.x) * f2, ptB.y + (ptV.y - ptB.y) * f2, ptB.z + (ptV.z - ptB.z) * f2);
            return ptA.distanceSquared((T3)this.p) >= this.rAS2 ? Float.NaN : this.solventDistance(this.rBS, this.rBS2, this.rAS2, dBV, dBV * dBV, dAV2);
        }
        return Float.NaN;
    }

    private float solventDistance(float rAS, float rAS2, float rBS2, float dAV, float dAV2, float dBV2) {
        float dVS;
        float angleVAB = (float)Math.acos((dAV2 + this.dAB2 - dBV2) / (2.0f * dAV * this.dAB));
        float angleSAB = (float)Math.acos((rAS2 + this.dAB2 - rBS2) / (2.0f * rAS * this.dAB));
        float dVS2 = (float)((double)(rAS2 + dAV2) - (double)(2.0f * rAS * dAV) * Math.cos(angleSAB - angleVAB));
        return this.ecosASB2 < (rAS2 + dVS2 - dAV * dAV) / ((dVS = (float)Math.sqrt(dVS2)) * rAS) ? dVS : Float.NaN;
    }

    void dumpLine(P3 pt1, T3 pt2, String label, String color) {
        this.sg.log("draw ID \"x" + label + this.nTest++ + "\" " + P3.newP((T3)pt1) + " " + P3.newP((T3)pt2) + " color " + color);
    }

    void dumpLine2(P3 pt1, P3 pt2, String label, float d, String color1, String color2) {
        V3 pt = new V3();
        pt.setT((T3)pt2);
        pt.sub((T3)pt1);
        pt.normalize();
        pt.scale(d);
        pt.add((T3)pt1);
        this.sg.log("draw ID \"" + label + this.nTest++ + "\" " + P3.newP((T3)pt1) + " " + P3.newP((T3)pt) + " color " + color1);
        this.sg.log("draw ID \"" + label + this.nTest++ + "\"" + P3.newP((T3)pt) + " " + P3.newP((T3)pt2) + " color " + color2 + "\"" + label + "\"");
    }

    void dumpPoint(P3 pt, String label, String color) {
        this.sg.log("draw ID \"" + label + this.nTest++ + "\"" + P3.newP((T3)pt) + " color " + color);
    }

    @Override
    public float getValueAtPoint(T3 pt, boolean getSource) {
        if (this.contactPair != null) {
            return pt.distance((T3)this.contactPair.myAtoms[1]) - this.contactPair.radii[1];
        }
        float value = Float.MAX_VALUE;
        for (int iAtom = 0; iAtom < this.firstNearbyAtom; ++iAtom) {
            float r = pt.distance((T3)this.atomXyzTruncated[iAtom]) - this.rs[iAtom];
            if (!(r < value)) continue;
            value = r;
        }
        return value == Float.MAX_VALUE ? Float.NaN : value;
    }

    @Override
    void discardTempData(boolean discardAll) {
        this.rs = null;
        this.rs2 = null;
        this.discardTempDataSR(discardAll);
    }

    @Override
    public float[] getPlane(int x) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = x;
        this.thisPlane = this.yzPlanes[x % 2];
        if (this.contactPair == null) {
            this.resetPlane(Float.MAX_VALUE);
            this.thisAtomSet = this.bsAtomMinMax[x];
            this.markSphereVoxels(0.0f, this.params.distance);
            this.unsetVoxelData();
        } else {
            this.markPlaneVoxels((P3)this.contactPair.myAtoms[0], this.contactPair.radii[0]);
        }
        return this.thisPlane;
    }

    private class Face {
        int ia;
        int ib;
        int ic;
        P3 pS;

        Face(int ia, int ib, int ic, P3 pS) {
            this.ia = ia;
            this.ib = ib;
            this.ic = ic;
            this.pS = P3.newP((T3)pS);
        }

        public String toString() {
            return this.ia + "_" + this.ib + "_" + this.ic + "_" + this.pS;
        }
    }

    private class Edge
    extends P3 {
        int ia;
        int ib;
        int nFaces;
        int nInvalid;
        float d;
        float d2;
        float maxr;
        float cosASB2;
        V3 v;

        Edge(IsoSolventReader r, int ia, int ib, float d) {
            this.ia = Math.min(ia, ib);
            this.ib = Math.max(ia, ib);
            this.d = d;
            this.d2 = d * d;
            this.maxr = (float)Math.sqrt(this.d2 / 4.0f + Math.max(r.rs2[ia], r.rs2[ib]));
            this.ave((T3)r.atomXyzTruncated[ia], (T3)r.atomXyzTruncated[ib]);
            this.cosASB2 = (r.rs2[ia] + r.rs2[ib] - this.d2) / (r.rs[ib] * r.rs[ia]);
            this.v = V3.newVsub((T3)r.atomXyzTruncated[ib], (T3)r.atomXyzTruncated[ia]);
            this.v.normalize();
        }

        void addFace(Face f) {
            ++this.nFaces;
            if (f == null) {
                ++this.nInvalid;
                return;
            }
        }

        boolean isValid() {
            return this.nFaces == 0 || this.nInvalid != this.nFaces;
        }

        public String toString() {
            return this.ia + "_" + this.ib;
        }
    }
}

