/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javajs.util.CU;
import javajs.util.P3;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.webexport.JmolInstance;

class Widgets {
    Widget[] widgetList = new Widget[5];

    Widgets() {
        this.widgetList[0] = new SpinOnWidget();
        this.widgetList[1] = new BackgroundColorWidget();
        this.widgetList[2] = new StereoViewWidget();
        this.widgetList[3] = new AnimationWidget();
        this.widgetList[4] = new ConsoleWidget();
    }

    class DownLoadWidget
    extends Widget {
        DownLoadWidget() {
            this.name = GT._("Download view");
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String[] getSupportFileNames() {
            String[] fileNames = new String[]{};
            return fileNames;
        }

        @Override
        String getJavaScript(int appletID, JmolInstance instance) {
            return GT._("unimplemented");
        }
    }

    class ConsoleWidget
    extends Widget {
        ConsoleWidget() {
            this.name = GT._("Open Console Button");
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String[] getSupportFileNames() {
            String[] fileNames = new String[]{};
            return fileNames;
        }

        @Override
        String getJavaScript(int appletID, JmolInstance instance) {
            return "<button title=\"" + GT.escapeHTML(GT._("launch Jmol console")) + "\" onclick=\"Jmol.script(window['jmolApplet" + appletID + "'], 'console');\">" + GT.escapeHTML(GT._("Jmol Console")) + "</button>";
        }
    }

    class AnimationWidget
    extends Widget {
        AnimationWidget() {
            this.name = GT._("Animation Control");
        }

        @Override
        String getJavaScriptFileName() {
            return "JmolAnimationCntrl.js";
        }

        @Override
        String[] getSupportFileNames() {
            String[] fileNames = new String[9];
            String imagePath = "org/openscience/jmol/app/images/";
            fileNames[0] = imagePath + "lastButton.png";
            fileNames[1] = imagePath + "playButton.png";
            fileNames[2] = imagePath + "playLoopButton.png";
            fileNames[3] = imagePath + "playOnceButton.png";
            fileNames[4] = imagePath + "playPalindromeButton.png";
            fileNames[5] = imagePath + "prevButton.png";
            fileNames[6] = imagePath + "pauseButton.png";
            fileNames[7] = imagePath + "nextButton.png";
            fileNames[8] = imagePath + "firstButton.png";
            return fileNames;
        }

        @Override
        String getJavaScript(int appletID, JmolInstance instance) {
            String jsString = "<div class=\"AnimBox\"><div style=\"text-align:center\">" + GT.escapeHTML(GT._("Animation")) + "</div>" + "<div>" + "<button title=\"" + GT.escapeHTML(GT._("First Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], 'frame rewind'));\">" + "<img src=\"firstButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT._("Previous Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], 'frame previous'));\">" + "<img src=\"prevButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT._("Play")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], 'frame play'));\">" + "<img src=\"playButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT._("Next Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], 'frame next'));\">" + "<img src=\"nextButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT._("Pause")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], 'frame pause'));\">" + "<img src=\"pauseButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT._("Last Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], 'frame last'));\">" + "<img src=\"lastButton.png\"></button>" + "</div>" + "<div>" + "<span>" + GT.escapeHTML(GT._("Mode:")) + "</span>" + "<span id=\"jmol_loop_" + appletID + "\"><button title=\"" + GT.escapeHTML(GT._("Loop")) + "\" onclick=\"jmol_animationmode('loop'," + appletID + ");\">" + "<img src=\"playLoopButton.png\"></button></span>" + "<span id=\"jmol_palindrome_" + appletID + "\"><button title=\"" + GT.escapeHTML(GT._("Palindrome")) + "\" onclick=\"jmol_animationmode('palindrome', " + appletID + ");\">" + "<img src=\"playPalindromeButton.png\"></button></span>" + "<span class=\"jmol_playDefault\"" + " id=\"jmol_playOnce_" + appletID + "\"><button title=\"" + GT.escapeHTML(GT._("Play Once")) + "\" onclick=\"jmol_animationmode('playOnce', " + appletID + ");\">" + "<img src=\"playOnceButton.png\"></button></span>" + "</div>" + "</div>";
            return jsString;
        }
    }

    class StereoViewWidget
    extends Widget {
        StereoViewWidget() {
            this.name = GT._("Stereo Viewing");
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String[] getSupportFileNames() {
            String[] fileNames = new String[]{};
            return fileNames;
        }

        @Override
        String getJavaScript(int appletID, JmolInstance instance) {
            return "<select id=\"StereoMode" + appletID + "\" title=\"" + GT.escapeHTML(GT._("select stereo type")) + "\"" + "onchange=\"void(Jmol.scriptWait(window['jmolApplet" + appletID + "'], " + "(this.options[this.selectedIndex]).value));\">" + "\n<option selected=\"\" value=\"stereo off\">" + GT.escapeHTML(GT._("Stereo Off")) + " </option>" + "\n<option value=\"stereo REDBLUE\">" + GT.escapeHTML(GT._("Red/Blue")) + "</option>" + "\n<option value=\"stereo REDCYAN\">" + GT.escapeHTML(GT._("Red/Cyan")) + "</option>" + "\n<option value=\"stereo REDGREEN\">" + GT.escapeHTML(GT._("Red/Green")) + "</option>" + "\n</select>";
        }
    }

    class BackgroundColorWidget
    extends Widget {
        BackgroundColorWidget() {
            this.name = GT._("Background Color");
        }

        @Override
        String getJavaScriptFileName() {
            return "JmolColorPicker.js";
        }

        @Override
        String[] getSupportFileNames() {
            String[] fileNames = new String[]{};
            return fileNames;
        }

        @Override
        String getJavaScript(int appletID, JmolInstance instance) {
            P3 ptRGB = CU.colorPtFromInt(instance.bgColor, null);
            return "<table><tbody><tr><td>" + GT.escapeHTML(GT._("background color:")) + "</td><td style='min-width:70px;'><script type='text/javascript'>" + "var scriptStr = 'color background $COLOR$;';" + "jmolColorPickerBox(scriptStr, [" + (int)ptRGB.x + "," + (int)ptRGB.y + "," + (int)ptRGB.z + "], 'backbox" + appletID + "',  '" + appletID + "');" + "</script></td></tr></tbody></table>";
        }
    }

    class SpinOnWidget
    extends Widget {
        SpinOnWidget() {
            this.name = GT._("Spin on/off");
        }

        @Override
        String[] getSupportFileNames() {
            String[] fileNames = new String[]{};
            return fileNames;
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String getJavaScript(int appletID, JmolInstance instance) {
            return "<input type=\"checkbox\" id=\"JmolSpinWidget" + appletID + "\"" + (instance.spinOn ? " checked=\"\"" : "") + " onclick=\"Jmol.scriptWait(window['jmolApplet" + appletID + "'], " + "'spin ' + (this.checked ? 'on' : 'off'));\" " + "title=\"" + GT.escapeHTML(GT._("enable/disable spin")) + "\" />" + "<label for=\"JmolSpinWidget" + appletID + "\">" + GT.escapeHTML(GT._("Spin on")) + "</label>";
        }
    }

    abstract class Widget {
        String name;

        Widget() {
        }

        abstract String getJavaScript(int var1, JmolInstance var2);

        abstract String getJavaScriptFileName();

        abstract String[] getSupportFileNames();
    }
}

