/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class DelPhiBinaryReader
extends VolumeFileReader {
    private float[] data;
    private int pt;

    DelPhiBinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        String fileName = (String)((Object[])sg.getReaderData())[0];
        this.init2VFR(sg, br);
        this.binarydoc = this.newBinaryDocument();
        this.setStream(fileName, false);
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = false;
        this.isAngstroms = true;
    }

    @Override
    protected void readParameters() throws Exception {
        int nx;
        String uplbl = this.readString();
        Logger.info((String)uplbl);
        String nxttoplbl = this.readString();
        Logger.info((String)nxttoplbl);
        this.data = this.readFloatArray();
        Logger.info((String)("DelPhi data length: " + this.data.length));
        String botlbl = this.readString();
        Logger.info((String)botlbl);
        float[] scalemid = this.readFloatArray();
        float scale = scalemid[0];
        Logger.info((String)("DelPhi scale: " + scale));
        float dx = scale == 1.0f ? 0.84375f : 1.0f / scale;
        this.volumetricVectors[0] = V3.new3((float)0.0f, (float)0.0f, (float)dx);
        this.volumetricVectors[1] = V3.new3((float)0.0f, (float)dx, (float)0.0f);
        this.volumetricVectors[2] = V3.new3((float)dx, (float)0.0f, (float)0.0f);
        Logger.info((String)("DelPhi resolution (pts/angstrom) set to: " + dx));
        this.voxelCounts[1] = this.voxelCounts[2] = (nx = 65);
        this.voxelCounts[0] = this.voxelCounts[2];
        Logger.info((String)("DelPhi voxel counts: " + nx));
        this.volumetricOrigin.set(scalemid[1], scalemid[2], scalemid[3]);
        Logger.info((String)("DelPhi center " + this.volumetricOrigin));
        this.volumetricOrigin.x -= (dx *= (float)((nx - 1) / 2));
        this.volumetricOrigin.y -= dx;
        this.volumetricOrigin.z -= dx;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("DelPhi DATA ").append(nxttoplbl.replace('\n', ' ').trim()).append("\n\n");
    }

    private String readString() throws Exception {
        int n = this.binarydoc.readInt();
        byte[] buf = new byte[n];
        this.binarydoc.readByteArray(buf, 0, n);
        this.binarydoc.readInt();
        return new String(buf);
    }

    private float[] readFloatArray() throws Exception {
        int n = this.binarydoc.readInt() >> 2;
        float[] a = new float[n];
        for (int i = 0; i < n; ++i) {
            a[i] = this.binarydoc.readFloat();
        }
        this.binarydoc.readInt();
        return a;
    }

    @Override
    protected float nextVoxel() throws Exception {
        this.nBytes += 4L;
        return this.data[this.pt++];
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
        this.pt += nPoints;
    }
}

