/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public class QchemReader
extends MOReader {
    private int calculationNumber = 1;
    private boolean isFirstJob = true;
    private MOInfo[] alphas = null;
    private MOInfo[] betas = null;
    private int nBasis = 0;
    private boolean dFixed = false;
    private boolean fFixed = false;
    private static String DC_LIST = "DXX   DYY   DZZ   DXY   DXZ   DYZ";
    private static String DS_LIST = "D3    D4    D2    D5    D1";
    private static String FC_LIST = "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ";
    private static String FS_LIST = "F4    F5    F3    F6    F2    F7    F1";
    String dList = "";
    String fList = "";
    boolean dSpherical = false;
    boolean fSpherical = false;

    @Override
    protected void initializeReader() {
        this.energyUnits = "au";
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
            this.readAtoms();
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Total energy") >= 0 || this.line.indexOf("total energy") >= 0 || this.line.indexOf("Energy is") >= 0) {
            if (this.line.indexOf("Excitation") == -1) {
                this.readEnergy();
            }
            return true;
        }
        if (this.line.indexOf("Requested basis set is") >= 0) {
            this.readCalculationType();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith("Job ") || this.line.startsWith("Running Job")) {
            if (this.isFirstJob && this.line.startsWith("Running")) {
                this.calculationNumber = 0;
            }
            ++this.calculationNumber;
            this.isFirstJob = false;
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Basis set in general basis input format") >= 0) {
            if (this.moData == null) {
                this.readBasis();
            }
            return true;
        }
        if (this.moData == null) {
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.) and Symmetries") >= 0) {
            this.readESym(true);
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.)") >= 0) {
            this.readESym(false);
            return true;
        }
        if (this.line.indexOf("MOLECULAR ORBITAL COEFFICIENTS") >= 0) {
            if (this.filterMO()) {
                this.readQchemMolecularOrbitals();
            }
            return true;
        }
        return this.checkNboLine();
    }

    private void readCalculationType() {
        this.calculationType = this.line.substring(this.line.indexOf("set is") + 6).trim();
    }

    private void readAtoms() throws Exception {
        this.asc.newAtomSet();
        this.setMOData(true);
        this.fFixed = false;
        this.dFixed = false;
        this.readLines(2);
        while (this.rd() != null && !this.line.startsWith(" --")) {
            String symbol;
            String[] tokens = this.getTokens();
            if (tokens.length < 5 || JmolAdapter.getElementNumber((String)(symbol = tokens[1])) <= 0) continue;
            this.addAtomXYZSymName(tokens, 2, symbol, null);
        }
        this.asc.setAtomSetModelProperty(".PATH", "Job " + this.calculationNumber);
    }

    private void readFrequencies() throws Exception, IOException {
        while (this.rd() != null && this.line.indexOf("STANDARD") < 0) {
            if (!this.line.startsWith(" Frequency:")) {
                this.discardLinesUntilStartsWith(" Frequency:");
            }
            String[] frequencies = this.getTokens();
            int frequencyCount = frequencies.length - 1;
            boolean[] ignore = new boolean[frequencyCount];
            int ac = this.asc.getLastAtomSetAtomCount();
            int iAtom0 = this.asc.ac;
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                this.asc.cloneLastAtomSet();
                this.asc.setAtomSetFrequency(this.vibrationNumber, "Job " + this.calculationNumber, null, frequencies[i + 1], null);
            }
            this.discardLinesUntilStartsWith("               X");
            this.fillFrequencyData(iAtom0, ac, ac, ignore, true, 0, 0, null, 0, null);
            this.discardLinesUntilBlank();
        }
    }

    private void readPartialCharges() throws Exception {
        this.readLines(3);
        Atom[] atoms = this.asc.atoms;
        int ac = this.asc.getLastAtomSetAtomCount();
        for (int i = 0; i < ac && this.rd() != null; ++i) {
            atoms[i].partialCharge = this.parseFloatStr(this.getTokens()[2]);
        }
    }

    private void readEnergy() {
        int ac = this.asc.getLastAtomSetAtomCount();
        String[] tokens = this.getTokens();
        String energyKey = "E(" + tokens[0] + ")";
        String energyString = tokens[tokens.length - 1];
        this.asc.setAtomSetEnergy(energyString, this.parseFloatStr(energyString));
        this.asc.setAtomSetName(energyKey + " = " + energyString);
        this.asc.setModelInfoForSet("name", (Object)(energyKey + " " + energyString), ac);
    }

    private void readBasis() throws Exception {
        String[] tokens;
        this.moData = new Hashtable();
        int ac = 1;
        int shellCount = 0;
        int gaussianCount = 0;
        this.shells = new Lst();
        Lst gdata = new Lst();
        this.discardLinesUntilStartsWith("$basis");
        this.rd();
        while (this.rd() != null) {
            int nGaussians;
            if (this.line.startsWith("****")) {
                ++ac;
                if (this.rd() == null || !this.line.startsWith("$end")) continue;
                break;
            }
            ++shellCount;
            int[] slater = new int[4];
            tokens = this.getTokens();
            slater[0] = ac;
            slater[1] = BasisFunctionReader.getQuantumShellTagID(tokens[0]);
            slater[2] = gaussianCount + 1;
            slater[3] = nGaussians = this.parseIntStr(tokens[1]);
            this.shells.addLast((Object)slater);
            gaussianCount += nGaussians;
            for (int i = 0; i < nGaussians; ++i) {
                gdata.addLast((Object)PT.getTokens((String)this.rd()));
            }
        }
        this.gaussians = AU.newFloat2((int)gaussianCount);
        for (int i = 0; i < gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            this.gaussians[i] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                this.gaussians[i][j] = this.parseFloatStr(tokens[j]);
            }
        }
        if (this.debugging) {
            Logger.debug((String)(shellCount + " slater shells read"));
            Logger.debug((String)(gaussianCount + " gaussian primitives read"));
        }
        this.discardLinesUntilStartsWith(" There are");
        tokens = this.getTokens();
        this.nBasis = this.parseIntStr(tokens[5]);
    }

    private void readESym(boolean haveSym) throws Exception {
        this.alphas = new MOInfo[this.nBasis];
        this.betas = new MOInfo[this.nBasis];
        int ne = 0;
        boolean readBetas = false;
        this.discardLinesUntilStartsWith(" Alpha");
        String[] tokens = this.getTokens();
        MOInfo[] moInfos = this.alphas;
        block0: for (int e = 0; e < 2; ++e) {
            int nMO = 0;
            while (this.rd() != null) {
                if (this.line.startsWith(" -- ")) {
                    ne = 0;
                    if (this.line.indexOf("Vacant") < 0 && this.line.indexOf("Occupied") > 0) {
                        ne = 1;
                    }
                    this.rd();
                }
                if (this.line.startsWith(" -------")) {
                    e = 2;
                    continue block0;
                }
                int nOrbs = this.getTokens().length;
                if (nOrbs == 0 || this.line.startsWith(" Warning")) {
                    this.discardLinesUntilStartsWith(" Beta");
                    readBetas = true;
                    moInfos = this.betas;
                    continue block0;
                }
                if (haveSym) {
                    tokens = PT.getTokens((String)this.rd());
                }
                int i = 0;
                int j = 0;
                while (i < nOrbs) {
                    MOInfo info = new MOInfo();
                    info.ne = ne;
                    if (haveSym) {
                        info.moSymmetry = tokens[j] + tokens[j + 1] + " ";
                    }
                    moInfos[nMO] = info;
                    ++nMO;
                    ++i;
                    j += 2;
                }
            }
        }
        if (!readBetas) {
            this.betas = this.alphas;
        }
    }

    private void readQchemMolecularOrbitals() throws Exception {
        String orbitalType = this.getTokens()[0];
        this.alphaBeta = "A";
        this.readMOs(orbitalType.equals("RESTRICTED"), this.alphas);
        if (orbitalType.equals("ALPHA")) {
            this.discardLinesUntilContains("BETA");
            this.alphaBeta = "B";
            this.readMOs(false, this.betas);
        }
        boolean isOK = true;
        if (this.dList.length() > 0 && !(isOK = this.dSpherical ? this.getDFMap("DS", this.dList, 3, DS_LIST, 2) : this.getDFMap("DC", this.dList, 4, DC_LIST, 3))) {
            Logger.error((String)("atomic orbital order is unrecognized -- skipping reading of MOs. dList=" + this.dList));
            this.shells = null;
        }
        if (this.fList.length() > 0 && !(isOK = this.fSpherical ? this.getDFMap("FS", this.fList, 5, FS_LIST, 2) : this.getDFMap("FC", this.fList, 6, FC_LIST, 3))) {
            Logger.error((String)("atomic orbital order is unrecognized -- skipping reading of MOs. fList=" + this.fList));
            this.shells = null;
        }
        this.setMOData(this.shells == null);
        this.shells = null;
    }

    private int readMOs(boolean restricted, MOInfo[] moInfos) throws Exception {
        Map[] mos = AU.createArrayOfHashtable((int)6);
        float[][] mocoef = AU.newFloat2((int)6);
        int[] moid = new int[6];
        int nMOs = 0;
        while (this.rd().length() > 2) {
            int i;
            String[] tokens = this.getTokens();
            int nMO = tokens.length;
            String[] energy = PT.getTokens((String)this.rd().substring(13));
            for (i = 0; i < nMO; ++i) {
                moid[i] = this.parseIntStr(tokens[i]) - 1;
                mocoef[i] = new float[this.nBasis];
                mos[i] = new Hashtable();
            }
            int pt = 0;
            block11: for (i = 0; i < this.nBasis; ++i) {
                tokens = PT.getTokens((String)this.rd());
                String s = this.line.substring(12, 17).trim();
                char ch = s.charAt(0);
                switch (ch) {
                    case 'd': {
                        s = s.substring(s.length() - 3).toUpperCase();
                        if (s.startsWith("D ")) {
                            if (!this.dFixed) {
                                this.fixSlaterTypes(4, 3);
                            }
                            s = "D" + s.charAt(2);
                            this.dSpherical = true;
                        }
                        if (this.dList.indexOf(s) < 0) {
                            this.dList = this.dList + s + " ";
                        }
                        this.dFixed = true;
                        break;
                    }
                    case 'f': {
                        s = s.substring(s.length() - 3).toUpperCase();
                        if (s.startsWith("F ")) {
                            if (!this.fFixed) {
                                this.fixSlaterTypes(6, 5);
                            }
                            s = "F" + s.charAt(2);
                            this.fSpherical = true;
                        }
                        if (this.fList.indexOf(s) < 0) {
                            this.fList = this.fList + s + " ";
                        }
                        this.fFixed = true;
                        break;
                    }
                    default: {
                        if (!QS.isQuantumBasisSupported(ch)) continue block11;
                    }
                }
                int j = tokens.length - nMO;
                for (int k = 0; k < nMO; ++k) {
                    mocoef[k][pt] = this.parseFloatStr(tokens[j]);
                    ++j;
                }
                ++pt;
            }
            for (i = 0; i < nMO; ++i) {
                MOInfo moInfo = moInfos[moid[i]];
                mos[i].put("energy", Float.valueOf(energy[i]));
                mos[i].put("coefficients", mocoef[i]);
                String label = this.alphaBeta;
                int ne = moInfo.ne;
                if (restricted) {
                    ne = this.alphas[moid[i]].ne + this.betas[moid[i]].ne;
                }
                mos[i].put("occupancy", Float.valueOf(ne));
                switch (ne) {
                    case 2: {
                        label = "AB";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        label = restricted ? "V" : "V" + label;
                    }
                }
                mos[i].put("symmetry", moInfo.moSymmetry + label + "(" + (moid[i] + 1) + ")");
                this.orbitals.addLast((Object)mos[i]);
            }
            nMOs += nMO;
        }
        return nMOs;
    }

    protected class MOInfo {
        protected int ne = 0;
        protected String moSymmetry = "";

        protected MOInfo() {
        }
    }
}

