/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.enterprisedb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.dbsupport.Delimiter;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class EnterpriseDBSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Pattern KEYWORDS_BEFORE_STRING_LITERAL_REGEX = Pattern.compile("^(N|IF|ELSIF|SELECT|IMMEDIATE|RETURN|IS)('.*)");
    private static final Pattern KEYWORDS_AFTER_STRING_LITERAL_REGEX = Pattern.compile("(.*')(USING|THEN|FROM|AND|OR)(?!.)");
    static final String DOLLAR_QUOTE_REGEX = "(\\$[A-Za-z0-9_]*\\$).*";
    private static final Delimiter SPL_DELIMITER = new Delimiter("/", true);
    private String statementStart = "";

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (line.matches("DECLARE|DECLARE\\s.*") || line.matches("BEGIN|BEGIN\\s.*")) {
            return SPL_DELIMITER;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 8) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = this.statementStart.replaceAll("\\s+", " ");
        }
        if (this.statementStart.matches("CREATE( OR REPLACE)? (FUNCTION|PROCEDURE|PACKAGE|TYPE|TRIGGER).*")) {
            return SPL_DELIMITER;
        }
        return delimiter;
    }

    @Override
    protected String cleanToken(String token) {
        Matcher afterMatcher;
        if (token.startsWith("'") && token.endsWith("'")) {
            return token;
        }
        Matcher beforeMatcher = KEYWORDS_BEFORE_STRING_LITERAL_REGEX.matcher(token);
        if (beforeMatcher.find()) {
            token = beforeMatcher.group(2);
        }
        if ((afterMatcher = KEYWORDS_AFTER_STRING_LITERAL_REGEX.matcher(token)).find()) {
            token = afterMatcher.group(1);
        }
        return token;
    }

    @Override
    protected String simplifyLine(String line) {
        String simplifiedQQuotes = StringUtils.replaceAll(StringUtils.replaceAll(line, "q'(", "q'["), ")'", "]'");
        return super.simplifyLine(simplifiedQQuotes);
    }

    @Override
    protected String extractAlternateOpenQuote(String token) {
        Matcher matcher = Pattern.compile(DOLLAR_QUOTE_REGEX).matcher(token);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public boolean canDiscard() {
        return super.canDiscard() || this.statementStart.startsWith("SET DEFINE OFF");
    }
}

