/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class GeneratedScrollableResultSet
extends OracleResultSet {
    protected OracleStatement statement;
    protected int currentRow;
    protected int fetchedRowCount;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    GeneratedScrollableResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection);
        this.statement = oracleStatement;
        this.currentRow = -1;
        this.fetchedRowCount = 0;
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBigDecimal(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBigDecimal(this.currentRow, n2, n3);
        }
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBoolean");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBoolean");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBoolean");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBoolean(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getByte");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getByte");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getByte");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getByte(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBytes(this.currentRow, n2);
        }
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getDate(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getDate(this.currentRow, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDouble");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDouble");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getDouble");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getDouble(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getFloat");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getFloat");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getFloat");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getFloat(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getInt");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getInt");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getInt");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getInt(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getLong");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getLong");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getLong");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getLong(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getNClob(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getNString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getNString(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getObject(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getObject(this.currentRow, n2, map);
        }
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getShort(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getSQLXML");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getSQLXML");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getSQLXML");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getSQLXML(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getString(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTime(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTime(this.currentRow, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTimestamp(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTimestamp(this.currentRow, n2, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getURL(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getARRAY(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBFILE(this.currentRow, n2);
        }
    }

    @Override
    public BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBLOB(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getCHAR(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getCLOB(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getCursor(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getDATE(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getINTERVALDS(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getINTERVALYM(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getNUMBER(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getOPAQUE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getOPAQUE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getOPAQUE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getOPAQUE(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getOracleObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getOracleObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getOracleObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getOracleObject(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getORAData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getORAData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getORAData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getORAData(this.currentRow, n2, oRADataFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getObject(this.currentRow, n2, oracleDataFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getRAW(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getREF(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getROWID(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getSTRUCT(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTIMESTAMPLTZ(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTIMESTAMPTZ(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getTIMESTAMP(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCustomDatum");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCustomDatum");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getCustomDatum");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getCustomDatum(this.currentRow, n2, customDatumFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getAsciiStream(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getBinaryStream(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getCharacterStream(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getNCharacterStream(this.currentRow, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getUnicodeStream(this.currentRow, n2);
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

