/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.DBUtils;
import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TimeSeries {
    static Logger logger = Logger.getLogger((String)Scenario.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    protected String type = "TimeSeries";
    protected String annotation = null;
    String model = null;
    String scenario = null;
    int version = -1;
    int runId = -1;
    protected List<ChangelogEntry> changeLogList = new LinkedList<ChangelogEntry>();
    protected Map<List<Integer>, Map<Integer, Double>> tsList = new LinkedHashMap<List<Integer>, Map<Integer, Double>>();
    private Set<Integer> loadedKeys = new HashSet<Integer>();
    protected Map<List<Integer>, Map<Integer, Double>> newTsList = new LinkedHashMap<List<Integer>, Map<Integer, Double>>();
    protected Map<List<Integer>, Map<Integer, Double>> updatedTsList = new LinkedHashMap<List<Integer>, Map<Integer, Double>>();
    protected Map<Vector<Integer>, List<Integer>> removedTsList = new LinkedHashMap<Vector<Integer>, List<Integer>>();
    Platform mp = Platform.getInstance();
    DbDAO db = DbDAO.getInstance();
    protected int state = 0;

    public TimeSeries(String model, String scenario, Boolean isNew, String annotation) throws IxException {
        this.model = model;
        this.scenario = scenario;
        this.version = 0;
        this.annotation = annotation;
        this.state = -1;
    }

    public TimeSeries(int runId) throws IxException {
        this.runId = runId;
        Map<String, Object> names = this.db.getModelScenarioName(runId);
        this.model = (String)names.get("model");
        this.scenario = (String)names.get("scenario");
        this.version = (Integer)names.get("version");
        this.annotation = (String)names.get("annotation");
    }

    public TimeSeries(String model, String scenario) throws IxException {
        this.model = model;
        this.scenario = scenario;
        this.runId = this.db.getRunId(model, scenario);
        if (this.runId == -1) {
            throw new IxException("There exists no default TimeSeries '" + model + "|" + scenario + "' in the database!");
        }
        Map<String, Object> names = this.db.getModelScenarioName(this.runId);
        this.version = (Integer)names.get("version");
        this.annotation = (String)names.get("annotation");
    }

    public TimeSeries(String model, String scenario, int version) throws IxException {
        this.model = model;
        this.scenario = scenario;
        this.version = version;
        this.runId = this.db.getRunId(model, scenario, version);
    }

    public int getRunId() {
        return this.runId;
    }

    public String getModel() {
        return this.model;
    }

    public String getScenario() {
        return this.scenario;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDefault() throws IxException {
        this.assertTimeseriesIsLockedInDB();
        return this.db.isDefaultVersion(this.runId);
    }

    public Timestamp getLastUpdateTimestamp() throws IxException {
        return this.db.getLastUpdTimestamp(this.runId);
    }

    public void addTimeseries(String pNode, String pKeystring, String pTime, int pYear, double pValue, String pUnit, int pMeta) throws IxException {
        LinkedHashMap<Integer, Double> data = new LinkedHashMap<Integer, Double>();
        data.put(pYear, pValue);
        this.addTimeseries(pNode, pKeystring, pTime, data, pUnit, pMeta);
    }

    /*
     * Unable to fully structure code
     */
    public void addTimeseries(String pNode, String pKeystring, String pTime, LinkedHashMap<Integer, Double> pData, String pUnit, int pMeta) throws IxException {
        block15: {
            this.assertTimeSeriesIsEditable(true);
            nodeId = this.mp.getNodeId(pNode);
            this.mp.getUnitId(pUnit, true, this.model);
            keyId = this.mp.assignIamVariableId(pKeystring, pUnit, this.model).getId();
            time = -1;
            vecNdId = this.db.getVecNdId(nodeId, keyId, pMeta, time);
            if (this.state == -1) {
                try {
                    aTimeseries = this.tsList.get(vecNdId);
                    for (Map.Entry<Integer, Double> entry : pData.entrySet()) {
                        aTimeseries.put(entry.getKey(), entry.getValue());
                    }
                }
                catch (NullPointerException e) {
                    this.tsList.put(vecNdId, pData);
                }
            } else {
                if (!this.loadedKeys.contains(keyId)) {
                    this.db.addToTimeseriesList(this.tsList, this.runId, keyId);
                    this.loadedKeys.add(keyId);
                    TimeSeries.logger.debug((Object)("loaded all timeseries data for '" + pKeystring + "' (" + keyId + ")..."));
                }
                try {
                    aTimeseries = this.tsList.get(vecNdId);
                    newData = this.newTsList.get(vecNdId);
                    if (newData == null) {
                        newData = new LinkedHashMap<Integer, Double>();
                    }
                    if ((updatedData = this.updatedTsList.get(vecNdId)) == null) {
                        updatedData = new LinkedHashMap<Integer, Double>();
                    }
                    for (Map.Entry<Integer, Double> entry : pData.entrySet()) {
                        year = entry.getKey();
                        value = entry.getValue();
                        prevVal = aTimeseries.get(year);
                        if (prevVal == null) {
                            this.addToChangelog("add timeseries entry", pKeystring, String.valueOf(pNode) + "|" + year, value, null);
                            newData.put(year, value);
                            this.newTsList.put(vecNdId, newData);
                        } else if (prevVal != value) {
                            this.addToChangelog("update timeseries entry", pKeystring, String.valueOf(pNode) + "|" + year, value, (double)prevVal);
                            updatedData.put(year, value);
                            this.updatedTsList.put(vecNdId, updatedData);
                        }
                        aTimeseries.put(entry.getKey(), entry.getValue());
                    }
                    break block15;
                }
                catch (NullPointerException e) {
                    this.tsList.put(vecNdId, pData);
                    this.newTsList.put(vecNdId, pData);
                    ** for (aEntry : pData.entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    this.addToChangelog("add timeseries entry", pKeystring, String.valueOf(pNode) + "|" + aEntry.getKey(), aEntry.getValue(), null);
                    continue;
                }
            }
        }
    }

    public void removeTimeseries(String pNode, String pKeystring, String pTime, LinkedList<Integer> pYears, String pUnit) throws IxException {
    }

    public List<Map<String, Object>> getTimeseries() throws IxException {
        return this.getTimeseries(null, null, null, null, null);
    }

    public List<Map<String, Object>> getTimeseries(List<String> regions, List<String> variables, List<String> units, List<Integer> timeslices, List<Integer> years) throws IxException {
        if (this.state == -1) {
            throw new IxException("This " + this.type + " was not yet committed to the database!");
        }
        this.assertTimeseriesIsLockedInDB();
        List<Integer> variableUnitKeyIds = null;
        LinkedList<Integer> nodeIds = null;
        if (!DBUtils.isEmpty(regions)) {
            nodeIds = this.mp.getNodeIdList(regions);
        }
        LinkedList<Integer> runIdList = new LinkedList<Integer>();
        runIdList.add(this.runId);
        if (!(DBUtils.isEmpty(variables) && DBUtils.isEmpty(units) || (variableUnitKeyIds = this.mp.getIamVariableIds(variables, units)).size() != 0)) {
            return new LinkedList<Map<String, Object>>();
        }
        return this.db.getTimeseriesFromDB(this.mp, runIdList, nodeIds, variableUnitKeyIds, timeslices, years);
    }

    public List<IamVariable> getIamVariables() throws IxException {
        LinkedList<Integer> runIds = new LinkedList<Integer>();
        runIds.add(this.runId);
        Map<Integer, List<IamVariable>> variables = this.mp.getIamVariablesOfRuns(runIds);
        return variables.get(this.runId);
    }

    public void addToChangelog(String pOperation, String pItem, String pKey) {
        if (this.isChangeLogged().booleanValue()) {
            this.changeLogList.add(new ChangelogEntry(pOperation, pItem, pKey));
        }
    }

    public void addToChangelog(String pOperation, String pItem, String pKey, Double pNewValue, Double pPrevValue) {
        if (this.isChangeLogged().booleanValue()) {
            this.changeLogList.add(new ChangelogEntry(pOperation, pItem, pKey, pNewValue, pPrevValue));
        }
    }

    public void addToChangelog(String pOperation, String pItem, String pKey, Integer pNewValue, Integer pPrevValue) {
        if (this.isChangeLogged().booleanValue()) {
            this.changeLogList.add(new ChangelogEntry(pOperation, pItem, pKey, (double)pNewValue, (double)pPrevValue));
        }
    }

    public boolean isCheckedOut() {
        return this.state == 2;
    }

    protected void assertTimeSeriesIsEditable(boolean timeseriesOnly) throws IxException {
        if (this.state == 0) {
            throw new IxException("This " + this.type + " cannot be edited, do a checkout first!");
        }
        if (!timeseriesOnly && this.state == 1) {
            throw new IxException("Only timeseries data be edited for this " + this.type + "!");
        }
    }

    protected void assertTimeseriesIsLockedInDB() throws IxException {
        this.assertTimeSeriesIsLockedInDB(false);
    }

    protected void assertTimeSeriesIsLockedInDB(boolean allowClone) throws IxException {
        if (this.state != 0) {
            throw new IxException("This " + this.type + " must be checked in before performing this operation!");
        }
        int dbStatus = this.db.getStatus(this.runId);
        if (dbStatus == 0) {
            throw new IxException("This " + this.type + " is currently locked by another user!");
        }
        if (dbStatus == 2 && !allowClone) {
            throw new IxException("This " + this.type + " is locked and frozen in the database!");
        }
    }

    protected Boolean isChangeLogged() {
        if (this.state > 0) {
            return true;
        }
        return false;
    }

    public void checkOut(boolean timeseriesOnly) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.checkOut(osUser, timeseriesOnly);
    }

    public void checkOut(String user, boolean timeseriesOnly) throws IxException {
        if (this.state == -1) {
            throw new IxException("This " + this.type + " was not yet saved to the database - do a commit first!");
        }
        int dbStatus = this.db.getStatus(this.runId);
        if (dbStatus == 0) {
            String lockUser = (String)((HashMap)this.db.getLockInfo(this.runId)).get("lockUser");
            throw new IxException("This " + this.type + " is currently locked by user " + lockUser);
        }
        if (dbStatus == 2) {
            throw new IxException("This " + this.type + " is locked and frozen in the database!");
        }
        this.db.setStatus(user, this.runId, 0);
        this.state = timeseriesOnly ? 1 : 2;
    }

    public void commit(String commitComment) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.commit(osUser, commitComment);
    }

    public void commit(String user, String commitComment) throws IxException {
        if (this.state == 0) {
            throw new IxException("This 'TimeSeries' is not checked out, no changes to be committed!");
        }
        Connection dbConn = null;
        try {
            dbConn = this.db.getConn();
            String script = null;
            if (this.runId == -1) {
                this.runId = this.db.assignRunId(user, this.model, this.scenario, null, this.annotation);
                this.version = this.db.getVersion(this.runId);
            }
            if (this.state > 0) {
                script = "commit changes to TimeSeries";
                logger.info((Object)("committing changes of TimeSeries '" + this.model + "|" + this.scenario + "' to the database (runid: " + this.runId + ")..."));
                Map<List<Integer>, Integer> tsInfo = this.db.saveTimeseriesToDB(this.runId, this.newTsList);
                this.db.updateTimeseriesInDB(this.runId, tsInfo, this.updatedTsList);
            } else if (this.state == -1) {
                script = "save new TimeSeries";
                logger.info((Object)("saving TimeSeries '" + this.model + "|" + this.scenario + "' to the database (runid: " + this.runId + ")..."));
                this.db.saveTimeseriesToDB(this.runId, this.tsList);
            }
            this.finalizeCommit(dbConn, script, commitComment, user);
        }
        catch (Exception e) {
            logger.error((Object)"There was a problem writing data to the database", (Throwable)e);
            try {
                dbConn.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)"There was a problem rolling back changes to the database", (Throwable)e);
            }
            this.checkIn(user);
            throw new IxException("There was a problem writing to the database - no changes were saved!");
        }
    }

    protected void finalizeCommit(Connection dbConn, String script, String commitComment, String user) throws Exception {
        int annotationId = this.db.assignAnnotationId();
        this.db.writeAnnotation(this.runId, "ok", annotationId, script, commitComment);
        this.db.writeChangeLog(this.runId, annotationId, this.changeLogList);
        dbConn.commit();
        if (this.state > 0) {
            logger.info((Object)("done updating " + this.type + " '" + this.model + "|" + this.scenario + "' to the database (runid: " + this.runId + ", version: " + this.version + ")!"));
        } else if (this.state == -1) {
            logger.info((Object)("done saving " + this.type + " '" + this.model + "|" + this.scenario + "' to the database (runid: " + this.runId + ", version: " + this.version + ")!"));
        }
        this.checkIn(user);
    }

    public void setAsDefaultVersion() throws Exception {
        if (this.runId == -1) {
            throw new IxException("this " + this.type + " was not yet saved to the database - no run id assigned yet!");
        }
        if (this.state != 0) {
            throw new IxException("this " + this.type + " must be checked in before setting it as default version!");
        }
        int prevDefaultId = this.db.getRunId(this.model, this.scenario, false);
        if (prevDefaultId != this.runId) {
            int annotationId = this.db.assignAnnotationId();
            this.db.writeAnnotation(this.runId, "ok", annotationId, "set as default", "previous default: " + prevDefaultId);
            this.db.setDefaultVersion(this.model, this.scenario, this.runId);
            logger.info((Object)("assigned this " + this.type + " as default version for '" + this.model + "|" + this.scenario + "'"));
        } else {
            logger.info((Object)("this " + this.type + " is already assigned as default version for '" + this.model + "|" + this.scenario + "'"));
        }
    }

    public void discardChanges() throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.discardChanges(osUser);
    }

    public void discardChanges(String user) throws IxException {
        if (this.state < 0) {
            throw new IxException("This TimeSeries was not yet saved to the database - no changes to discard!");
        }
        if (this.state == 0) {
            throw new IxException("This TimeSeries is not checked out - no changes to discard!");
        }
        this.checkIn(user);
    }

    protected void checkIn() throws IxException {
        this.checkIn(null);
    }

    protected void checkIn(String user) throws IxException {
        this.db.setStatus(user, this.runId, 1);
        this.state = 0;
        this.changeLogList = new LinkedList<ChangelogEntry>();
        this.newTsList = new LinkedHashMap<List<Integer>, Map<Integer, Double>>();
        this.updatedTsList = new LinkedHashMap<List<Integer>, Map<Integer, Double>>();
        this.removedTsList = new LinkedHashMap<Vector<Integer>, List<Integer>>();
    }
}

