/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.exceptions.IxNotFoundException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.MsgScenario;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.objects.Variable;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSEquation;
import com.gams.api.GAMSEquationRecord;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSParameterRecord;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSVariable;
import com.gams.api.GAMSVariableRecord;
import com.gams.api.GAMSWorkspace;
import com.gams.api.GAMSWorkspaceInfo;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Scenario
extends TimeSeries {
    static Logger logger = Logger.getLogger((String)Scenario.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    protected String scheme = null;
    protected int seqItemId = 0;
    private HashMap<Integer, String> idKeyMap = new HashMap();
    private HashMap<String, Integer> keyIdMap = new HashMap();
    private HashSet<String> keyUnique = new HashSet();
    private int seqKeyId = -1;
    private HashMap<Integer, String> idCommentMap = new HashMap();
    private HashMap<String, Integer> commentIdMap = new HashMap();
    private int seqCommentId = -1;
    protected LinkedHashMap<String, Item> itemList = new LinkedHashMap();
    protected LinkedHashMap<String, IndexSet> idxsetList = new LinkedHashMap();
    protected LinkedHashMap<String, Set> setList = new LinkedHashMap();
    protected LinkedHashMap<String, Parameter> parList = new LinkedHashMap();
    protected LinkedHashMap<String, Variable> varList = new LinkedHashMap();
    protected LinkedHashMap<String, Equation> equList = new LinkedHashMap();
    private HashMap<Integer, String> newKeyList = new HashMap();
    private HashMap<Integer, String> newCommentList = new HashMap();
    protected LinkedHashSet<Item> newItemList = new LinkedHashSet();
    private LinkedHashSet<String> removedItemList = new LinkedHashSet();

    public Scenario(String model, String scenario, Boolean isNew, String scheme, String annotation) throws IxException {
        super(model, scenario, true, annotation);
        this.type = "Scenario";
        this.scheme = scheme;
        this.addKey("scalar");
    }

    public Scenario(String model, String scenario) throws IxException {
        super(model, scenario);
        this.loadScenFromDB(this.runId);
    }

    public Scenario(String model, String scenario, int version) throws IxException {
        super(model, scenario, version);
        this.loadScenFromDB(this.runId);
    }

    public Scenario(int runId) throws IxException {
        super(runId);
        this.loadScenFromDB(runId);
    }

    public Scenario(Scenario sourceScenario, String model, String scenario, String annotation) throws IxException {
        super(model, scenario, true, annotation);
        this.loadScenFromDB(sourceScenario.getRunId());
    }

    public Scenario(String user, Scenario sourceScenario, String model, String scenario, String scheme, String annotation, boolean keepSolution) throws IxException {
        super(model, scenario, true, annotation);
        this.loadScenFromDB(sourceScenario.getRunId());
        this.state = -1;
        String commit = "clone Scenario from '" + sourceScenario.getModel() + "|" + sourceScenario.getScenario() + "', version: " + sourceScenario.getVersion();
        this.commit(user, commit, sourceScenario, keepSolution, 0);
    }

    protected void loadScenFromDB(int runId) throws IxException {
        this.type = "Scenario";
        try {
            this.scheme = this.db.getScheme(runId);
            if (this.db.isDefaultVersion(runId)) {
                logger.info((Object)("loading default Scenario '" + this.model + "|" + this.scenario + "' (version: " + this.version + ", runid: " + runId + ")..."));
            } else {
                logger.info((Object)("loading Scenario '" + this.model + "|" + this.scenario + "' by version id (version: " + this.version + ", runid: " + runId + ")..."));
            }
            this.state = -1;
            this.seqItemId = this.db.getSeqItemId(runId);
            this.seqKeyId = this.db.getKeyIdList(runId, this);
            this.seqCommentId = this.db.getCommentIdList(runId, this);
            this.db.getIndexSets(this, runId);
            this.db.getItemList(this, runId, "SET");
            this.db.getItemList(this, runId, "PAR");
            this.db.getItemList(this, runId, "VAR");
            this.db.getItemList(this, runId, "EQU");
            this.state = 0;
            logger.info((Object)"done loading Scenario from the database!");
        }
        catch (Exception e) {
            String error = "There was a problem loading the Scenario from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public Boolean isScheme(String pScheme) {
        if (this.scheme != null && this.scheme.equals(pScheme)) {
            return true;
        }
        return false;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getKeyId(String key) throws IxException {
        if (this.keyIdMap.keySet().contains(key)) {
            return this.keyIdMap.get(key);
        }
        throw new IxException("The key '" + key + "' is not defined in the Scenario!");
    }

    public String getKeyIdString(Integer keyId) {
        return this.idKeyMap.get(keyId);
    }

    public int addKey(String key) throws IxException {
        if (key.contains(".")) {
            throw new IxException("The key '" + key + "' must not contain a '.'!");
        }
        if (this.keyIdMap.keySet().contains(key)) {
            return this.keyIdMap.get(key);
        }
        if (this.keyUnique.contains(key.toLowerCase())) {
            throw new IxException("A key with the same lower-case spelling already exists, please rename '" + key + "'!");
        }
        this.keyUnique.add(key.toLowerCase());
        ++this.seqKeyId;
        this.idKeyMap.put(this.seqKeyId, key);
        this.keyIdMap.put(key, this.seqKeyId);
        if (this.isChangeLogged().booleanValue()) {
            this.newKeyList.put(this.seqKeyId, key);
        }
        return this.seqKeyId;
    }

    public void addKeyFromDB(int keyId, String key) {
        this.keyUnique.add(key.toLowerCase());
        this.idKeyMap.put(keyId, key);
        this.keyIdMap.put(key, keyId);
    }

    public Vector<Integer> getKeyIdVector(String ... keys) throws IxException {
        Vector<Integer> eleVector = new Vector<Integer>(keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String aKey = stringArray[n2];
            eleVector.add(this.addKey(aKey));
            ++n2;
        }
        return eleVector;
    }

    int addComment(String comment) {
        if (this.commentIdMap.keySet().contains(comment)) {
            return this.commentIdMap.get(comment);
        }
        ++this.seqCommentId;
        this.idCommentMap.put(this.seqCommentId, comment);
        this.commentIdMap.put(comment, this.seqCommentId);
        if (this.isChangeLogged().booleanValue()) {
            this.newCommentList.put(this.seqCommentId, comment);
        }
        return this.seqCommentId;
    }

    public void addCommentFromDB(int commentId, String comment) {
        this.idCommentMap.put(commentId, comment);
        this.commentIdMap.put(comment, commentId);
    }

    String getCommentString(Integer commentId) {
        return this.idCommentMap.get(commentId);
    }

    int getNextItemId() {
        return this.seqItemId++;
    }

    void checkIndexSet(String name) throws IxException {
        if (!name.equals("*") && !this.hasIndexSet(name)) {
            throw new IxException("There exists no index set '" + name + "'!");
        }
    }

    boolean checkIndexSetEle(String setName, int keyId) throws IxException {
        if (!setName.equals("*")) {
            this.checkIndexSet(setName);
            this.getIndexSet(setName).checkIndexSetKey(keyId);
        }
        return true;
    }

    public void addCatEle(String setName, String cat, String key) throws IxException {
        throw new IxException("this function can only be used for MESSAGE-scheme scenarios!");
    }

    public String[] getCatEle(String setName, String cat) throws IxException {
        throw new IxException("this function can only be used for MESSAGE-scheme scenarios!");
    }

    public LinkedList<String> getIdxSets(String name) throws IxException {
        return this.getItem(name).getIdxSets();
    }

    public LinkedList<String> getIdxNames(String name) throws IxException {
        return this.getItem(name).getIdxNames();
    }

    public Scenario clone(String newModel, String newScenario, String annotation, boolean keepSolution, int newFirstYear) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        return this.clone(osUser, newModel, newScenario, annotation, keepSolution, newFirstYear);
    }

    public Scenario clone(String user, String newModel, String newScenario, String annotation, boolean keepSolution, int newFirstYear) throws IxException {
        this.assertTimeSeriesIsLockedInDB(true);
        if (newModel == null || newScenario == null) {
            throw new IxException("Please provide a model and scenario name for the cloned Scenario!");
        }
        if (this.isScheme("MESSAGE").booleanValue()) {
            return new MsgScenario(user, this, newModel, newScenario, annotation, keepSolution, newFirstYear);
        }
        if (newFirstYear == 0) {
            return new Scenario(user, this, newModel, newScenario, this.scheme, annotation, keepSolution);
        }
        throw new IxException("The option to shift first model period is only available for MESSAGE-scheme Scenario!");
    }

    protected void addToItemList(Item pItem) {
        this.itemList.put(pItem.name, pItem);
        if (pItem instanceof IndexSet) {
            this.idxsetList.put(pItem.name, (IndexSet)pItem);
        } else if (pItem instanceof Set) {
            this.setList.put(pItem.name, (Set)pItem);
        } else if (pItem instanceof Parameter) {
            this.parList.put(pItem.name, (Parameter)pItem);
        } else if (pItem instanceof Variable) {
            this.varList.put(pItem.name, (Variable)pItem);
        } else if (pItem instanceof Equation) {
            this.equList.put(pItem.name, (Equation)pItem);
        }
    }

    public boolean hasItem(String pName) {
        boolean retval = false;
        if (this.itemList.keySet().contains(pName)) {
            retval = true;
        }
        return retval;
    }

    public Item getItem(String pName) throws IxException {
        if (!this.hasItem(pName)) {
            throw new IxException("No item " + pName + " exists in this Scenario!");
        }
        return this.itemList.get(pName);
    }

    public LinkedList<Element> getItemElements(String pName) throws IxException {
        if (!this.hasItem(pName)) {
            throw new IxException("No item " + pName + " exists in this Scenario!");
        }
        return this.getItem(pName).getElements();
    }

    private void removeFromItemList(Item item) {
        this.itemList.remove(item.name);
        if (item instanceof IndexSet) {
            this.idxsetList.remove(item.name);
        } else if (item instanceof Set) {
            this.setList.remove(item.name);
        } else if (item instanceof Parameter) {
            this.parList.remove(item.name);
        } else if (item instanceof Variable) {
            this.varList.remove(item.name);
        } else if (item instanceof Equation) {
            this.equList.remove(item.name);
        }
    }

    public String[] getIndexSetKeys(String pName) throws IxException {
        if (!this.hasIndexSet(pName)) {
            throw new IxException("No index set " + pName + " exists in this Scenario!");
        }
        return this.getIndexSet(pName).getIndexSetKeys();
    }

    public LinkedList<Integer> getIndexSetKeyIds(String pName) throws IxException {
        if (!this.hasIndexSet(pName)) {
            throw new IxException("No index set " + pName + " exists in this Scenario!");
        }
        return this.getIndexSet(pName).getIndexSetKeyIds();
    }

    private void checkItemAsIndexSet(String pIdxSet) throws IxException {
        for (Item aItem : this.itemList.values()) {
            for (String aIdxSet : aItem.getIdxSets()) {
                if (!aIdxSet.equals(pIdxSet)) continue;
                throw new IxException("The index set '" + pIdxSet + "' is used by " + aItem.getTypeName() + ", delete this item first!");
            }
        }
    }

    void removeAllEleByIndex(String pIndexSet, int pKeyId) throws IxException {
        logger.info((Object)("cleaning all occurences of element '" + this.getKeyIdString(pKeyId) + "' in index set '" + pIndexSet + "'..."));
        for (Item aItem : this.itemList.values()) {
            if (aItem.getDim() == 0) continue;
            int idx = 0;
            int i = 0;
            HashSet<Integer> idxList = new HashSet<Integer>();
            for (String aIdxSet : aItem.getIdxSets()) {
                if (aIdxSet.equals(pIndexSet)) {
                    idxList.add(idx);
                }
                ++idx;
            }
            HashSet<Element> removedEleList = new HashSet<Element>();
            for (Element ele : aItem.getElements()) {
                Iterator iterator = idxList.iterator();
                while (iterator.hasNext()) {
                    int aIdx = (Integer)iterator.next();
                    if (!ele.checkKeyAtIndex(aIdx, (Integer)pKeyId)) continue;
                    removedEleList.add(ele);
                    ++i;
                }
            }
            if (aItem instanceof Set) {
                Set aSet = (Set)aItem;
                for (Element ele : removedEleList) {
                    aSet.removeElement(ele);
                }
            } else if (aItem instanceof Parameter) {
                Parameter aPar = (Parameter)aItem;
                for (Element ele : removedEleList) {
                    aPar.removeElement(ele);
                }
            }
            if (i == 1) {
                logger.info((Object)(" removed 1 element from " + aItem.getTypeName()));
                continue;
            }
            if (i <= true) continue;
            logger.info((Object)(" removed " + i + " elements from " + aItem.getTypeName()));
        }
    }

    public LinkedList<String> getIndexSetList() {
        LinkedList<String> setNameList = new LinkedList<String>();
        for (IndexSet aSet : this.idxsetList.values()) {
            setNameList.add(aSet.name);
        }
        return setNameList;
    }

    public LinkedList<String> getSetList() {
        LinkedList<String> setNameList = new LinkedList<String>();
        for (IndexSet indexSet : this.idxsetList.values()) {
            setNameList.add(indexSet.name);
        }
        for (Set set : this.setList.values()) {
            setNameList.add(set.name);
        }
        return setNameList;
    }

    public boolean hasIndexSet(String name) {
        boolean retval = false;
        if (this.idxsetList.keySet().contains(name)) {
            retval = true;
        }
        return retval;
    }

    public IndexSet getIndexSet(String name) throws IxException {
        if (!this.hasIndexSet(name)) {
            throw new IxException("No IndexSet '" + name + "' exists in this Scenario!");
        }
        return this.idxsetList.get(name);
    }

    public boolean hasSet(String name) {
        boolean retval = false;
        if (this.idxsetList.keySet().contains(name) || this.setList.keySet().contains(name)) {
            retval = true;
        }
        return retval;
    }

    public Set getSet(String name) throws IxException {
        if (this.hasIndexSet(name)) {
            return this.idxsetList.get(name);
        }
        if (!this.hasSet(name)) {
            throw new IxException("No Set '" + name + "' exists in this Scenario!");
        }
        Set aSet = this.setList.get(name);
        aSet.loadItemElementsFromDB();
        return aSet;
    }

    public Set initializeSet(String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        if (this.hasItem(name)) {
            throw new IxException("An Item with the name '" + name + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets == null || indexSets.isEmpty()) {
            IndexSet aSet = new IndexSet(this, name);
            if (this.isChangeLogged().booleanValue()) {
                this.newItemList.add(aSet);
                this.changeLogList.add(new ChangelogEntry("initialize index set", name));
            }
            return aSet;
        }
        this.checkIndexSetsNames(indexSets, indexNames);
        Set aSet = new Set(this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aSet);
            this.changeLogList.add(new ChangelogEntry("initialize set", name));
        }
        return aSet;
    }

    public void removeSet(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        if (this.hasIndexSet(name)) {
            IndexSet aSet = this.getIndexSet(name);
            this.checkItemAsIndexSet(aSet.name);
            if (this.isChangeLogged().booleanValue()) {
                for (Element ele : aSet.getElements()) {
                    this.addToChangelog("delete set element", name, ele.getConcatKey());
                }
                this.addToChangelog("remove index set", name, null);
            }
            this.removedItemList.add(name);
            this.removeFromItemList(aSet);
            logger.info((Object)("removed Set '" + name + "' from the Scenario"));
        } else if (this.hasSet(name)) {
            Set aItem = this.getSet(name);
            if (this.isChangeLogged().booleanValue()) {
                for (Element ele : aItem.getElements()) {
                    this.addToChangelog("delete set element", name, ele.getConcatKey());
                }
                this.addToChangelog("remove set", name, null);
            }
            this.removedItemList.add(name);
            this.removeFromItemList(aItem);
            logger.info((Object)("removed Set '" + name + "' from the Scenario"));
        } else {
            throw new IxException("There exists no Set '" + name + "'!");
        }
    }

    public LinkedList<String> getParList() {
        LinkedList<String> parNameList = new LinkedList<String>();
        for (Parameter aPar : this.parList.values()) {
            parNameList.add(aPar.name);
        }
        return parNameList;
    }

    public boolean hasPar(String name) {
        boolean retval = false;
        if (this.parList.keySet().contains(name)) {
            retval = true;
        }
        return retval;
    }

    public Parameter getPar(String name) throws IxNotFoundException, IxException {
        if (!this.hasPar(name)) {
            throw new IxNotFoundException("There is no parameter '" + name + "'!");
        }
        Parameter aPar = this.parList.get(name);
        aPar.loadItemElementsFromDB();
        return aPar;
    }

    public Parameter initializePar(String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        Parameter aPar = null;
        if (this.hasItem(name)) {
            throw new IxException("An item with the name '" + name + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets != null && indexNames != null) {
            this.checkIndexSetsNames(indexSets, indexNames);
        }
        aPar = new Parameter(this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aPar);
            this.changeLogList.add(new ChangelogEntry("initialize parameter", name));
        }
        return aPar;
    }

    public void removePar(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        Parameter aPar = this.getPar(name);
        if (this.isChangeLogged().booleanValue()) {
            if (aPar.getDim() > 0) {
                for (Element ele : aPar.getElements()) {
                    this.addToChangelog("delete parameter element", name, ele.getConcatKey(), null, ele.getValue());
                }
                this.addToChangelog("remove parameter", name, null);
            } else {
                this.addToChangelog("remove scalar", name, null, null, aPar.getScalarValue());
            }
        }
        this.removedItemList.add(name);
        this.removeFromItemList(aPar);
        logger.info((Object)("removed Parameter '" + name + "' from the Scenario"));
    }

    public LinkedList<String> getVarList() {
        LinkedList<String> varNameList = new LinkedList<String>();
        for (String aSet : this.varList.keySet()) {
            varNameList.add(aSet);
        }
        return varNameList;
    }

    public boolean hasVar(String name) {
        boolean retval = false;
        if (this.varList.keySet().contains(name)) {
            retval = true;
        }
        return retval;
    }

    public Variable getVar(String name) throws IxException {
        if (!this.hasVar(name)) {
            throw new IxException("There exists no variable '" + name + "'!");
        }
        Variable aVar = this.varList.get(name);
        aVar.loadItemElementsFromDB();
        return aVar;
    }

    public Variable initializeVar(String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        Variable aVar = null;
        if (this.hasItem(name)) {
            throw new IxException("An item with the name '" + name + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets != null && indexNames != null) {
            this.checkIndexSetsNames(indexSets, indexNames);
        }
        aVar = new Variable(this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aVar);
            this.changeLogList.add(new ChangelogEntry("initialize variable", name));
        }
        return aVar;
    }

    public void removeVar(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        Variable aVar = this.getVar(name);
        if (this.isChangeLogged().booleanValue()) {
            this.addToChangelog("remove variable", name, null);
        }
        this.removedItemList.add(name);
        this.removeFromItemList(aVar);
        logger.info((Object)("removed Variable '" + name + "' from the Scenario"));
    }

    public LinkedList<String> getEquList() {
        LinkedList<String> equNameList = new LinkedList<String>();
        for (String aSet : this.equList.keySet()) {
            equNameList.add(aSet);
        }
        return equNameList;
    }

    public boolean hasEqu(String name) {
        boolean retval = false;
        if (this.equList.keySet().contains(name)) {
            retval = true;
        }
        return retval;
    }

    public Equation getEqu(String name) throws IxException {
        if (!this.hasEqu(name)) {
            throw new IxException("There exists no equation '" + name + "'!");
        }
        Equation aEqu = this.equList.get(name);
        aEqu.loadItemElementsFromDB();
        return aEqu;
    }

    public Equation initializeEqu(String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        Equation aEqu = null;
        if (this.hasItem(name)) {
            throw new IxException("An item with the name '" + name + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets != null && indexNames != null) {
            this.checkIndexSetsNames(indexSets, indexNames);
        }
        aEqu = new Equation(this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aEqu);
            this.changeLogList.add(new ChangelogEntry("initialize equation", name));
        }
        return aEqu;
    }

    public void removeEqu(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        Equation aEqu = this.getEqu(name);
        if (this.isChangeLogged().booleanValue()) {
            this.addToChangelog("remove equation", name, null);
        }
        this.removedItemList.add(name);
        this.removeFromItemList(aEqu);
        logger.info((Object)("removed equation '" + name + "' from the Scenario"));
    }

    private void checkIndexSetsNames(LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        if (indexSets.size() != indexNames.size()) {
            throw new IxException("The dimensionality of index sets and index names doesn't match!");
        }
        for (String idxSet : indexSets) {
            this.checkIndexSet(idxSet);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (String idxName : indexNames) {
            if (nameSet.contains(idxName)) {
                throw new IxException("The index names are not unique!");
            }
            nameSet.add(idxName);
        }
    }

    public int getUnitId(String unit) throws IxException {
        return this.mp.getUnitId(unit);
    }

    public String getUnitName(int unitId) throws IxException {
        return this.mp.getUnit(unitId);
    }

    public boolean hasSolution() throws IxException {
        for (Variable aVar : this.varList.values()) {
            if (!aVar.hasElements()) continue;
            return true;
        }
        for (Equation aEqu : this.equList.values()) {
            if (!aEqu.hasElements()) continue;
            return true;
        }
        return false;
    }

    public void checkSolution() throws IxException {
        if (this.hasSolution()) {
            throw new IxException("This Scenario has elements in a variable or equation! Use 'removeSolution()' or clone(False)'before editing!");
        }
    }

    public void removeSolution() throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.removeSolution(osUser);
    }

    public void removeSolution(String user) throws IxException {
        this.assertTimeseriesIsLockedInDB();
        if (this.varList.isEmpty() && this.equList.isEmpty()) {
            logger.info((Object)"this Scenario does not have any initialized variables or equations");
        } else {
            this.checkOut(user, false, false);
            boolean hasSol = false;
            for (Variable aVar : this.varList.values()) {
                if (!aVar.removeAllElements()) continue;
                hasSol = true;
            }
            for (Equation aEqu : this.equList.values()) {
                if (!aEqu.removeAllElements()) continue;
                hasSol = true;
            }
            if (hasSol) {
                this.commit(user, "remove all solution elements");
            } else {
                logger.info((Object)"this Scenario does not contain any elements in a Variable or Equation");
                this.checkIn(user);
            }
        }
    }

    public void readSolutionFromGDX(String gamsPath, String gamsGdxFile, String comment, LinkedList<String> varList, LinkedList<String> equList, boolean checkSolution) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.readSolutionFromGDX(osUser, gamsPath, gamsGdxFile, comment, varList, equList, checkSolution);
    }

    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment) throws IxException {
        this.readSolutionFromGDX(user, gamsPath, gamsGdxFile, comment, null, null, false);
    }

    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment, LinkedList<String> varList, LinkedList<String> equList, boolean checkSolution) throws IxException {
        this.removeSolution(user);
        this.readSolFromGDX(gamsPath, gamsGdxFile, comment, varList, equList);
    }

    protected void readSolFromGDX(String gamsPath, String gamsGdxFile, String comment, LinkedList<String> importVarList, LinkedList<String> importEquList) throws IxException {
        int i;
        Vector<Integer> eleVector;
        int dim;
        GAMSVariable x;
        if (importVarList == null || importVarList.isEmpty()) {
            if (this.varList.isEmpty()) {
                throw new IxException("There are no initialized variables in this Scenario!");
            }
            importVarList = new LinkedList();
            for (String aVar : this.varList.keySet()) {
                importVarList.add(aVar);
            }
        }
        if (importEquList == null || importEquList.isEmpty()) {
            importEquList = new LinkedList();
            for (String aEqu : this.equList.keySet()) {
                importEquList.add(aEqu);
            }
        }
        this.db.setStatus(this.runId, 0);
        logger.info((Object)"importing results from gdx solution file...");
        File workingDirectory = new File(gamsPath);
        workingDirectory.mkdir();
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase gamsDB = ws.addDatabaseFromGDX(gamsGdxFile);
        for (String aName : importVarList) {
            Variable var = this.getVar(aName);
            x = null;
            try {
                x = gamsDB.getVariable(aName);
            }
            catch (Exception e) {
                logger.error((Object)("variable '" + aName + "' not found in gdx!"));
                continue;
            }
            int cnt = 0;
            for (GAMSVariableRecord rec : x) {
                dim = rec.getKeys().length;
                if (dim > 0) {
                    eleVector = new Vector<Integer>();
                    eleVector.add(this.addKey(rec.getKeys()[0]));
                    i = 1;
                    while (i < dim) {
                        eleVector.add(this.addKey(rec.getKeys()[i]));
                        ++i;
                    }
                    var.addElement(eleVector, rec.getLevel(), rec.getMarginal());
                } else {
                    var.addElement(rec.getLevel(), rec.getMarginal());
                }
                ++cnt;
            }
            if (cnt == 0) {
                logger.info((Object)("no elements for variable '" + aName + "' found in gdx"));
                continue;
            }
            if (cnt == 1) {
                logger.info((Object)("imported a scalar for variable '" + aName + "' from gdx"));
                this.changeLogList.add(new ChangelogEntry("import a scalar for variable", aName));
                continue;
            }
            logger.info((Object)("imported " + cnt + " elements for variable '" + aName + "' from gdx"));
            this.changeLogList.add(new ChangelogEntry("import " + cnt + " elements for variable", aName));
        }
        for (String aName : importEquList) {
            Equation equ = this.getEqu(aName);
            x = null;
            try {
                x = gamsDB.getEquation(aName);
            }
            catch (Exception e) {
                logger.error((Object)("equation '" + aName + "' not found in gdx!"));
                continue;
            }
            int cnt = 0;
            for (GAMSVariableRecord rec : x) {
                dim = rec.getKeys().length;
                if (dim > 0) {
                    eleVector = new Vector();
                    eleVector.add(this.addKey(rec.getKeys()[0]));
                    i = 1;
                    while (i < dim) {
                        eleVector.add(this.addKey(rec.getKeys()[i]));
                        ++i;
                    }
                    equ.addElement(eleVector, rec.getLevel(), rec.getMarginal());
                } else {
                    equ.addElement(rec.getLevel(), rec.getMarginal());
                }
                ++cnt;
            }
            if (cnt == 0) {
                logger.info((Object)("no elements for equation '" + aName + "' found in gdx"));
                continue;
            }
            if (cnt == 1) {
                logger.info((Object)("imported a scalar for equation '" + aName + "' from gdx"));
                this.changeLogList.add(new ChangelogEntry("import a scalar for equation", aName));
                continue;
            }
            logger.info((Object)("imported " + cnt + " elements for equation '" + aName + "' from gdx"));
            this.changeLogList.add(new ChangelogEntry("import " + cnt + " elements for equation", aName));
        }
        int annotationId = this.db.assignAnnotationId();
        Connection dbConn = null;
        try {
            dbConn = this.db.getConn();
            this.db.setUpdUserDate(this.runId);
            String script = "import solution from GDX";
            for (Variable var : this.varList.values()) {
                this.db.saveItemElementsToDB(this.runId, var);
            }
            for (Equation equ : this.equList.values()) {
                this.db.saveItemElementsToDB(this.runId, equ);
            }
            comment = comment == null ? "source file: '" + gamsPath + "/" + gamsGdxFile + "'" : String.valueOf(comment) + "; source file: '" + gamsPath + "/" + gamsGdxFile + "'";
            this.db.writeAnnotation(this.runId, "ok", annotationId, script, comment);
            this.db.writeChangeLog(this.runId, annotationId, this.changeLogList);
            dbConn.commit();
            logger.info((Object)("done importing solution from file '" + gamsPath + "/" + gamsGdxFile + "' to database (runid: " + this.runId + ", version: " + this.version + ")!"));
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
            try {
                dbConn.rollback();
            }
            catch (Exception e1) {
                e1.getMessage();
                e1.printStackTrace();
            }
            this.discardChanges();
            throw new IxException("There was a problem writing to the database - no changes were saved!");
        }
        for (Variable var : this.varList.values()) {
            var.clearCache();
        }
        for (Equation equ : this.equList.values()) {
            equ.clearCache();
        }
        this.db.setStatus(this.runId, 1);
        this.changeLogList = new LinkedList();
    }

    protected Vector<String> getStringVector(Vector<Integer> eleVector) {
        Vector<String> retval = new Vector<String>();
        for (Integer keyId : eleVector) {
            retval.add(this.getKeyIdString(keyId));
        }
        return retval;
    }

    protected Vector<String> getStringVector(Integer keyId) {
        Vector<String> retval = new Vector<String>();
        retval.add(this.getKeyIdString(keyId));
        return retval;
    }

    public void toGDX(String gamsPath, String gamsGdxFile) throws IxException {
        this.toGDX(gamsPath, gamsGdxFile, false);
    }

    public void toGDX(String gamsPath, String gamsGdxFile, boolean includeVarEqu) throws IxException {
        Vector<String> vd;
        this.assertTimeseriesIsLockedInDB();
        logger.info((Object)"writing data to gdx...");
        File workingDirectory = new File(gamsPath);
        workingDirectory.mkdir();
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase ixGAMSdb = ws.addDatabase();
        for (IndexSet indexSet : this.idxsetList.values()) {
            GAMSSet aGamsSet = ixGAMSdb.addSet(indexSet.name, 1);
            Iterator iterator = indexSet.getIndexSetKeyIds().iterator();
            while (iterator.hasNext()) {
                int keyId = (Integer)iterator.next();
                Vector<String> vd2 = this.getStringVector(keyId);
                try {
                    aGamsSet.addRecord(vd2);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    throw new IxException("error writing index set '" + indexSet.name + "' to gdx!");
                }
            }
        }
        for (Set set : this.setList.values()) {
            Integer dim = Math.max(1, set.idxSets.size());
            GAMSSet aGamsSet = ixGAMSdb.addSet(set.name, dim.intValue());
            for (Element ele : set.getElements()) {
                vd = this.getStringVector(ele.getVector());
                try {
                    aGamsSet.addRecord(vd);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    throw new IxException("error writing mapping set '" + set.name + "' to gdx!");
                }
            }
        }
        for (Parameter parameter : this.parList.values()) {
            boolean clearCache = parameter.loadItemElementsFromDB();
            GAMSParameter aGamsPar = ixGAMSdb.addParameter(parameter.name, parameter.dim.intValue());
            if (parameter.dim == 0) {
                try {
                    ((GAMSParameterRecord)aGamsPar.addRecord(new Vector())).setValue(parameter.getScalarValue().doubleValue());
                }
                catch (IxException e) {
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    throw new IxException("error writing scalar " + parameter.name + "' to gdx!");
                }
            } else {
                for (Element ele : parameter.getElements()) {
                    vd = this.getStringVector(ele.getVector());
                    try {
                        ((GAMSParameterRecord)aGamsPar.addRecord(vd)).setValue(ele.getValue().doubleValue());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        e.printStackTrace();
                        throw new IxException("error writing parameter '" + parameter.name + "' to gdx!");
                    }
                }
            }
            if (!clearCache) continue;
            parameter.clearCache();
        }
        if (includeVarEqu) {
            for (Variable variable : this.varList.values()) {
                boolean clearCache = variable.loadItemElementsFromDB();
                GAMSVariable aGamsVar = ixGAMSdb.addVariable(variable.name, variable.dim.intValue(), GAMSGlobals.VarType.FREE);
                if (variable.dim == 0) {
                    try {
                        GAMSVariableRecord aVarEle = (GAMSVariableRecord)aGamsVar.addRecord(new Vector());
                        aVarEle.setLevel(variable.getScalarLevel().doubleValue());
                        aVarEle.setMarginal(variable.getScalarMarginal().doubleValue());
                    }
                    catch (IxException e) {
                        logger.error((Object)("error writing variable " + variable.name + "' (as scalar) to gdx!"), (Throwable)e);
                        throw new IxException("error writing variable " + variable.name + "' (as scalar) to gdx!");
                    }
                } else {
                    for (Element ele : variable.getElements()) {
                        vd = this.getStringVector(ele.getVector());
                        try {
                            GAMSVariableRecord aVarEle = (GAMSVariableRecord)aGamsVar.addRecord(vd);
                            aVarEle.setLevel(ele.getLevel().doubleValue());
                            aVarEle.setMarginal(ele.getMarginal().doubleValue());
                        }
                        catch (Exception e) {
                            logger.error((Object)("error writing variable '" + variable.name + "' to gdx!"), (Throwable)e);
                            throw new IxException("error writing variable '" + variable.name + "' to gdx!");
                        }
                    }
                }
                if (!clearCache) continue;
                variable.clearCache();
            }
            for (Equation equation : this.equList.values()) {
                boolean clearCache = equation.loadItemElementsFromDB();
                GAMSEquation aGamsEqu = ixGAMSdb.addEquation(equation.name, equation.dim.intValue(), GAMSGlobals.EquType.E);
                if (equation.dim == 0) {
                    try {
                        GAMSEquationRecord aEquEle = (GAMSEquationRecord)aGamsEqu.addRecord(new Vector());
                        aEquEle.setLevel(equation.getScalarLevel().doubleValue());
                        aEquEle.setMarginal(equation.getScalarMarginal().doubleValue());
                    }
                    catch (IxException e) {
                        logger.error((Object)("error writing equation " + equation.name + "' (as scalar) to gdx!"), (Throwable)e);
                        throw new IxException("error writing equation " + equation.name + "' (as scalar) to gdx!");
                    }
                } else {
                    for (Element ele : equation.getElements()) {
                        vd = this.getStringVector(ele.getVector());
                        try {
                            GAMSEquationRecord aEquEle = (GAMSEquationRecord)aGamsEqu.addRecord(vd);
                            aEquEle.setLevel(ele.getLevel().doubleValue());
                            aEquEle.setMarginal(ele.getMarginal().doubleValue());
                        }
                        catch (Exception e) {
                            logger.error((Object)("error writing equation '" + equation.name + "' to gdx!"), (Throwable)e);
                            throw new IxException("error writing equation '" + equation.name + "' to gdx!");
                        }
                    }
                }
                if (!clearCache) continue;
                equation.clearCache();
            }
        }
        ixGAMSdb.export(gamsGdxFile);
        logger.info((Object)"done writing data to gdx!");
    }

    @Override
    public void checkOut(String user, boolean timeseriesOnly) throws IxException {
        this.checkOut(user, timeseriesOnly, true);
    }

    protected void checkOut(String user, boolean timeseriesOnly, boolean checkSolution) throws IxException {
        if (checkSolution && !timeseriesOnly) {
            this.checkSolution();
        }
        super.checkOut(user, timeseriesOnly);
    }

    @Override
    public void commit(String annotation) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.commit(user, annotation);
    }

    @Override
    public void commit(String user, String annotation) throws IxException {
        this.commit(user, annotation, null, true, 0);
    }

    protected void commit(String user, String annotation, Scenario sourceScen, boolean keepSolution, int newFirstYear) throws IxException {
        if (this.state == 0) {
            throw new IxException("this Scenario is not checked out, no changes to be committed!");
        }
        int sourceRunId = -1;
        if (sourceScen != null) {
            sourceRunId = sourceScen.getRunId();
        }
        Connection dbConn = null;
        try {
            dbConn = this.db.getConn();
            String script = null;
            if (this.runId == -1) {
                this.runId = this.db.assignRunId(user, this.model, this.scenario, this.scheme, annotation);
                this.version = this.db.getVersion(this.runId);
            }
            this.db.saveSeqItemId(this.runId, this.seqItemId);
            if (this.state > 0) {
                script = "commit changes to Scenario";
                logger.info((Object)("committing changes of Scenario '" + this.model + "|" + this.scenario + "' to the database (runid: " + this.runId + ")..."));
                this.db.createKeysInDB(this.runId, this.newKeyList);
                this.db.saveCommentsInDB(this.runId, this.newCommentList);
                this.db.saveIdxSetToDB(this.runId, this.idxsetList.values());
                this.db.removeItemFromDB(this.runId, this.removedItemList, "SET");
                this.db.removeItemFromDB(this.runId, this.removedItemList, "PAR");
                this.db.removeItemFromDB(this.runId, this.removedItemList, "VAR");
                this.db.removeItemFromDB(this.runId, this.removedItemList, "EQU");
                LinkedHashSet<Item> newSetList = new LinkedHashSet<Item>();
                LinkedHashSet<Item> newParList = new LinkedHashSet<Item>();
                LinkedHashSet<Item> newVarList = new LinkedHashSet<Item>();
                LinkedHashSet<Item> newEquList = new LinkedHashSet<Item>();
                for (Item aItem : this.newItemList) {
                    if (aItem instanceof IndexSet) continue;
                    if (aItem instanceof Set) {
                        newSetList.add(aItem);
                        continue;
                    }
                    if (aItem instanceof Parameter) {
                        newParList.add(aItem);
                        continue;
                    }
                    if (aItem instanceof Variable) {
                        newVarList.add(aItem);
                        continue;
                    }
                    if (!(aItem instanceof Equation)) continue;
                    newEquList.add(aItem);
                }
                this.db.createItemInDB(this.runId, newSetList, "SET");
                this.db.createItemInDB(this.runId, newParList, "PAR");
                this.db.createItemInDB(this.runId, newVarList, "VAR");
                this.db.createItemInDB(this.runId, newEquList, "EQU");
                LinkedList<IndexSet> updatedIndexSets = new LinkedList<IndexSet>();
                for (Item aItem : this.itemList.values()) {
                    if (!aItem.hasUpdatedElements() && !aItem.hasUpdatedComments()) continue;
                    if (aItem instanceof IndexSet) {
                        updatedIndexSets.add((IndexSet)aItem);
                        continue;
                    }
                    if (aItem.hasUpdatedElement) {
                        this.db.saveItemElementsToDB(this.runId, aItem);
                    }
                    if (!aItem.hasUpdatedComments()) continue;
                    this.db.saveItemCommentsToDB(this.runId, aItem);
                }
                this.db.saveIdxSetToDB(this.runId, updatedIndexSets);
                Map<List<Integer>, Integer> tsInfo = this.db.saveTimeseriesToDB(this.runId, this.newTsList);
                this.db.updateTimeseriesInDB(this.runId, tsInfo, this.updatedTsList);
            } else if (this.state == -1) {
                script = "save new Scenaio";
                logger.info((Object)("saving Scenario '" + this.model + "|" + this.scenario + "' to database (runid: " + this.runId + ")..."));
                this.db.createKeysInDB(this.runId, this.idKeyMap);
                logger.debug((Object)("run id: " + this.runId + " - saved key-id map"));
                this.db.saveCommentsInDB(this.runId, this.idCommentMap);
                logger.debug((Object)("run id: " + this.runId + " - saved comments-id map"));
                this.db.saveIdxSetToDB(this.runId, this.idxsetList.values());
                this.db.createSetInDB(this.runId, this.setList.values());
                for (Set set : this.setList.values()) {
                    if (sourceRunId != -1) {
                        this.db.cloneItemBlobInDB(this.runId, sourceRunId, set.getTypeForDB(), set.getName());
                        continue;
                    }
                    this.db.saveItemElementsToDB(this.runId, set);
                    this.db.saveItemCommentsToDB(this.runId, set);
                }
                this.db.createParInDB(this.runId, this.parList.values());
                for (Parameter par : this.parList.values()) {
                    if (sourceRunId != -1) {
                        this.db.cloneItemBlobInDB(this.runId, sourceRunId, par.getTypeForDB(), par.getName());
                        logger.debug((Object)("run id: " + this.runId + " - cloned " + par.getTypeName() + " directly in database"));
                        continue;
                    }
                    this.db.saveItemElementsToDB(this.runId, par);
                    this.db.saveItemCommentsToDB(this.runId, par);
                    logger.debug((Object)("run id: " + this.runId + " - saved " + par.getTypeName()));
                }
                this.db.createVarInDB(this.runId, this.varList.values());
                this.db.createEquInDB(this.runId, this.equList.values());
                if (keepSolution) {
                    for (Variable var : this.varList.values()) {
                        this.db.cloneItemBlobInDB(this.runId, sourceRunId, var.getTypeForDB(), var.getName());
                        logger.debug((Object)("run id: " + this.runId + " - cloned " + var.getTypeName() + " directly in IXMP database"));
                    }
                    for (Equation equ : this.equList.values()) {
                        this.db.cloneItemBlobInDB(this.runId, sourceRunId, equ.getTypeForDB(), equ.getName());
                        logger.debug((Object)("run id: " + this.runId + " - cloned " + equ.getTypeName() + " directly in IXMP database"));
                    }
                }
                if (newFirstYear > 0) {
                    this.db.cloneTimeseriesInDB(this.runId, sourceRunId, true, 0);
                    this.db.cloneTimeseriesInDB(this.runId, sourceRunId, false, newFirstYear);
                }
                this.db.saveTimeseriesToDB(this.runId, this.tsList);
            }
            this.finalizeCommit(dbConn, script, annotation, user);
        }
        catch (Exception e) {
            String error = "There was a problem writing data to the IXMP database - no changes were saved!";
            try {
                dbConn.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)error, (Throwable)e);
            }
            throw new IxException(error);
        }
    }

    @Override
    public void discardChanges(String user) throws IxException {
        if (this.state < 0) {
            throw new IxException("This Scenario was not yet saved to the database - no changes to discard!");
        }
        if (this.state == 0) {
            throw new IxException("This Scenario is not checked out - no changes to discard!");
        }
        String lockUser = (String)((HashMap)this.db.getLockInfo(this.runId)).get("lockUser");
        if (!lockUser.equals(user)) {
            throw new IxException("Unlocking is only allowed for the user who locked a Scenario (user: " + lockUser + ")");
        }
        logger.info((Object)"discarding all changes...");
        this.loadScenFromDB(this.runId);
        this.checkIn(user);
    }

    @Override
    protected void checkIn(String user) throws IxException {
        super.checkIn(user);
        this.newKeyList = new HashMap();
        this.newCommentList = new HashMap();
        this.newItemList = new LinkedHashSet();
        this.removedItemList = new LinkedHashSet();
    }
}

