/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Parameter
extends Item {
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    private Element scalarEle = null;

    Parameter(Scenario scenario, String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        this.initializeIXItem(scenario, name, "parameter");
        this.setIXitemIdDims(indexSets, indexNames);
        scenario.addToItemList(this);
    }

    Parameter(Scenario scenario, String name, LinkedList<String> indexSets, LinkedList<String> indexNames, String scheme) throws IxException {
        this.initializeIXItem(scenario, name, "parameter");
        this.setIXitemIdDims(indexSets, indexNames, scheme);
        scenario.addToItemList(this);
    }

    public Parameter(Scenario scenario, String name, int itemId, int dim) {
        this.initializeIXItem(scenario, name, "parameter", false);
        scenario.addToItemList(this);
        this.itemId = itemId;
        this.dim = dim;
    }

    @Override
    public void setElementListFromDB(List<Object> pBlob) {
        super.setElementListFromDB(pBlob);
        if (this.isScalar()) {
            this.scalarEle = (Element)this.eleList.getLast();
        }
    }

    public void addElement(String key, Double pValue, String pUnit) throws IxException {
        this.addElement(this.getKeyIdVector(key), pValue, pUnit, null);
    }

    public void addElement(String pKey, Double pValue, String pUnit, String pComment) throws IxException {
        this.addElement(this.getKeyIdVector(pKey), pValue, pUnit, pComment);
    }

    public void addElement(LinkedList<String> pKeyList, Double pValue, String pUnit) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList), pValue, pUnit, null);
    }

    public void addElement(LinkedList<String> pKeyList, Double pValue, String pUnit, String pComment) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList), pValue, pUnit, pComment);
    }

    public void addElement(Vector<Integer> pKeyVector, Double pValue, String pUnit, String pComment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (pValue == null) {
            throw new IxException("A value of NULL cannot be assigned to parameter '" + this.name + "'!");
        }
        if (pValue.isNaN()) {
            throw new IxException("A value of NaN cannot be assigned to parameter '" + this.name + "'!");
        }
        if (this.isScalar()) {
            throw new IxException("You cannot assign an element with a key to scalar '" + this.name + "'!");
        }
        int unitId = this.scenario.getUnitId(pUnit);
        Element ele = (Element)this.eleMap.get(pKeyVector);
        if (ele == null) {
            ele = new Element((Item)this, pKeyVector, pValue, unitId);
            this.addItemElement(ele, pComment);
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("add parameter element", this.name, ele.getConcatKey(), pValue, null);
            }
        } else {
            Double prevVal = ele.getValue();
            Integer prevUnitId = ele.getUnitId();
            if (prevVal != pValue) {
                this.changeValue(ele, pValue, prevVal);
            }
            if (unitId != prevUnitId) {
                this.changeUnit(ele, unitId, prevUnitId);
            }
        }
        if (pComment != null) {
            this.addItemComment(ele, pComment);
        }
    }

    public void addElement(Double pValue, String pUnit) throws IxException {
        this.addElement(pValue, pUnit, null);
    }

    public void addElement(Double pValue, String pUnit, String pComment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (pValue == null) {
            throw new IxException("A value of NULL cannot be assigned to parameter '" + this.name + "'!");
        }
        if (pValue.isNaN()) {
            throw new IxException("A value of NaN cannot be assigned to parameter '" + this.name + "'!");
        }
        if (!this.isScalar()) {
            throw new IxException("This parameter is not a scalar!");
        }
        int unitId = this.scenario.getUnitId(pUnit);
        Vector<Integer> eleVector = new Vector<Integer>();
        eleVector.add(0);
        if (!this.hasElement(eleVector)) {
            this.scalarEle = new Element((Item)this, pValue, unitId);
            this.addItemElement(this.scalarEle, pComment);
            this.hasUpdatedElement = true;
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("add scalar value", this.name, null, pValue, null);
            }
        } else {
            Element ele = (Element)this.eleMap.get(eleVector);
            Double prevVal = ele.getValue();
            Integer prevUnitId = ele.getUnitId();
            if (prevVal != pValue) {
                this.changeValue(ele, pValue, prevVal);
            }
            if (unitId != prevUnitId) {
                this.changeUnit(ele, unitId, prevUnitId);
            }
        }
    }

    public void removeElement(String pEleKey) throws IxException {
        Vector<Integer> pEleVector = this.getKeyIdVector(pEleKey);
        if (!this.hasElement(pEleVector)) {
            throw new IxException("parameter " + this.name + " does not have an element '" + pEleKey + "', cannot be removed!");
        }
        this.removeElement((Element)this.eleMap.get(pEleVector));
    }

    public void removeElement(LinkedList<String> pKeyList) throws IxException {
        this.removeElement(this.getKeyIdVector(pKeyList));
    }

    public void removeElement(Vector<Integer> pEleVector) throws IxException {
        if (!this.hasElement(pEleVector)) {
            throw new IxException("Parameter " + this.name + " does not have an element '" + this.getConcatKey(pEleVector) + "', cannot be removed!");
        }
        this.removeElement((Element)this.eleMap.get(pEleVector));
    }

    public void removeElement(Element pEle) throws IxException {
        if (this.isScalar()) {
            throw new IxException("You cannot delete a scalar while specifying an element - use 'removePar()'!");
        }
        this.scenario.assertTimeSeriesIsEditable(false);
        this.hasUpdatedElement = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            this.scenario.addToChangelog("delete parameter element", this.name, pEle.getConcatKey(), null, pEle.getValue());
        }
        super.removeItemElement(pEle);
    }

    private void changeValue(Element pEle, Double pValue, Double prevValue) throws IxException {
        pEle.setValue(pValue);
        this.hasUpdatedElement = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            this.scenario.addToChangelog("change parameter element value", this.name, pEle.getConcatKey(), pValue, prevValue);
        }
    }

    private void changeUnit(Element pEle, int pUnitID, int prevUnitId) throws IxException {
        pEle.setUnitId(pUnitID);
        this.hasUpdatedElement = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            this.scenario.addToChangelog("change parameter element unit", this.name, pEle.getConcatKey(), pUnitID, prevUnitId);
        }
    }

    public Double getEleValue(LinkedList<String> pKeyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use function 'getEleValue()'!");
        }
        return this.getElement(pKeyList).getValue();
    }

    public Double getEleValue(Vector<Integer> pKeyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use function 'getEleValue()'!");
        }
        return this.getElement(pKeyVector).getValue();
    }

    public float[] getValues(LinkedList<Element> pEleList) throws IxException {
        float[] ret = new float[pEleList.size()];
        int i = 0;
        for (Element ele : pEleList) {
            ret[i] = ele.getValue().floatValue();
            ++i;
        }
        return ret;
    }

    public String getEleUnit(LinkedList<String> pKeyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use function 'getScalarUnit()'!");
        }
        return this.getElement(pKeyList).getUnit();
    }

    public String getEleUnit(Vector<Integer> pKeyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use function 'getScalarValue()'!");
        }
        return this.getElement(pKeyVector).getUnit();
    }

    public String[] getUnits(LinkedList<Element> pEleList) throws IxException {
        Vector<String> ret = new Vector<String>(pEleList.size());
        for (Element ele : pEleList) {
            ret.add(this.scenario.getUnitName(ele.getUnitId()));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Double getScalarValue() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This parameter is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return Double.NaN;
        }
        return this.scalarEle.getValue();
    }

    public String getScalarUnit() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This parameter is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return "NaN";
        }
        return this.scalarEle.getUnit();
    }

    public LinkedList<LinkedHashMap<Object, Object>> toJsonList(HashMap<String, LinkedList<String>> eleListFilter) throws IxException {
        LinkedList<LinkedHashMap<Object, Object>> jsonList = new LinkedList<LinkedHashMap<Object, Object>>();
        for (Element ele : this.getElements(eleListFilter)) {
            LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
            jsonMap.put("model", this.scenario.getModel());
            jsonMap.put("scenario", this.scenario.getScenario());
            jsonMap.put("type", "parameter");
            jsonMap.put("name", this.name);
            if (this.dim >= 1) {
                int i = 0;
                while (i < this.dim) {
                    jsonMap.put((String)this.idxNames.get(i), ele.getKey(i));
                    ++i;
                }
            }
            jsonMap.put("unit", ele.getUnit());
            Double val = ele.getValue();
            if (!val.isInfinite()) {
                jsonMap.put("value", val);
            } else if (val.isInfinite() && val < 0.0) {
                jsonMap.put("value", "-Infinity");
            } else {
                jsonMap.put("value", "Infinity");
            }
            jsonList.add(jsonMap);
        }
        return jsonList;
    }
}

