/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.modelspecs.MESSAGEspecs;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.Variable;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSParameterRecord;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSSymbol;
import com.gams.api.GAMSWorkspace;
import com.gams.api.GAMSWorkspaceInfo;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MsgScenario
extends Scenario {
    static Logger logger = Logger.getLogger((String)Scenario.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    public TreeSet<String> nodes = null;
    public TreeSet<String> tecs = null;
    private LinkedList<Integer> years = null;
    public TreeSet<String> times = null;
    public TreeSet<String> emissions = null;
    private LinkedList<String> reqIdxSets = null;
    private LinkedList<String> reqSets = null;
    private LinkedList<String> reqPars = null;
    private LinkedList<String> reqVars = null;
    private LinkedList<String> reqEqus = null;
    private HashMap<String, LinkedList<String>> indexSetsMap = null;
    private HashMap<String, LinkedList<String>> indexNamesMap = null;
    private boolean hasMESSAGEspecs = false;
    public LinkedList<String> tecParList = new LinkedList();
    public LinkedList<String> tecActParList = new LinkedList();

    public MsgScenario(String model, String scenario, Boolean isNew, String annotation) throws IxException {
        super(model, scenario, isNew, "MESSAGE", annotation);
        this.initializeMsgSetsParameters();
        this.assignMessageSetList(false);
    }

    public MsgScenario(String model, String scenario) throws IxException {
        super(model, scenario);
        this.assignMessageSetList();
    }

    public MsgScenario(String model, String scenario, int version) throws IxException {
        super(model, scenario, version);
        this.assignMessageSetList();
    }

    public MsgScenario(int runId) throws IxException {
        super(runId);
        this.assignMessageSetList(false);
    }

    public MsgScenario(String user, Scenario sourceScenario, String model, String scenario, String annotation, boolean keepSolution, int newFirstYear) throws IxException {
        super(sourceScenario, model, scenario, annotation);
        Integer firstYear = Integer.valueOf(sourceScenario.getCatEle("year", "firstmodelyear")[0]);
        if (newFirstYear == 0) {
            newFirstYear = firstYear;
        }
        boolean keepSolForClone = keepSolution;
        if (firstYear < newFirstYear) {
            keepSolForClone = true;
            if (this.varList.isEmpty() && this.equList.isEmpty()) {
                throw new IxException("This Scenario does not have a solution, not possible to shift first model year!");
            }
        } else if (firstYear > newFirstYear) {
            throw new IxException("Shifting the first model year only works forward!");
        }
        this.state = -1;
        String cloneAnnotation = "clone Scenario from '" + sourceScenario.getModel() + "|" + sourceScenario.getScenario() + "', version: " + sourceScenario.getVersion();
        this.commit(user, cloneAnnotation, sourceScenario, keepSolForClone, newFirstYear);
        this.getMESSAGEspecs();
        if (newFirstYear != 0 && firstYear < newFirstYear) {
            this.checkOut(user, false, false);
            LinkedList<String> keyList = new LinkedList<String>();
            keyList.add(Integer.toString(newFirstYear));
            this.addCatEle("year", "firstmodelyear", keyList, true);
            LinkedList<String> yrList = new LinkedList<String>();
            this.getYearList();
            for (Integer yr : this.years) {
                if (yr < firstYear || yr >= newFirstYear) continue;
                yrList.add(yr.toString());
            }
            HashMap<String, LinkedList<String>> yrMap = new HashMap<String, LinkedList<String>>();
            yrMap.put("year", yrList);
            HashMap<Vector<Integer>, Double> extraction = this.assignVarToPar("EXT", "historical_extraction", yrMap);
            Parameter duration_period = this.getPar("duration_period");
            Parameter resource_volume = this.getPar("resource_volume");
            for (Map.Entry<Vector<Integer>, Double> extEle : extraction.entrySet()) {
                Vector<Integer> resEle = new Vector<Integer>();
                resEle.add(extEle.getKey().get(0));
                resEle.add(extEle.getKey().get(1));
                resEle.add(extEle.getKey().get(2));
                String yr = this.getKeyIdString(extEle.getKey().get(3));
                double numYrs = duration_period.getElement(yr).getValue();
                Element ele = resource_volume.getElement(resEle);
                Double val = ele.getValue();
                String unit = ele.getUnit();
                resource_volume.addElement(resEle, (Double)(val - extEle.getValue() * numYrs), unit, "updated during clone-and-shift-firstmodelyear");
            }
            HashMap<String, LinkedList<String>> capMap = new HashMap<String, LinkedList<String>>();
            capMap.put("year_vtg", yrList);
            this.assignVarToPar("CAP_NEW", "historical_new_capacity", capMap);
            HashMap<String, LinkedList<String>> actMap = new HashMap<String, LinkedList<String>>();
            actMap.put("year_act", yrList);
            this.assignVarToPar("ACT", "historical_activity", actMap);
            this.assignVarToPar("DEMAND", "demand", yrMap);
            this.assignVarToPar("LAND", "historical_land", yrMap);
            this.assignVarToPar("GDP", "historical_gdp", yrMap);
            String sliceAnnotation = "shift first model year to '" + newFirstYear + "', assign solution to historical parameters";
            if (!keepSolution) {
                for (Variable aVar : this.varList.values()) {
                    aVar.removeAllElements();
                }
                for (Equation aEqu : this.equList.values()) {
                    aEqu.removeAllElements();
                }
                sliceAnnotation = String.valueOf(sliceAnnotation) + ", remove solution";
            }
            this.commit(user, sliceAnnotation);
        }
    }

    private void getMESSAGEspecs() {
        if (!this.hasMESSAGEspecs) {
            this.reqIdxSets = MESSAGEspecs.getRequiredSetList(true);
            this.reqSets = MESSAGEspecs.getRequiredSetList();
            this.reqPars = MESSAGEspecs.getRequiredParameterList();
            this.reqVars = MESSAGEspecs.getRequiredVariableList();
            this.reqEqus = MESSAGEspecs.getRequiredEquationList();
            this.indexSetsMap = MESSAGEspecs.getIndexDimMap();
            this.indexNamesMap = MESSAGEspecs.getIndexDimMap(true);
            this.hasMESSAGEspecs = true;
        }
    }

    private boolean initializeMsgSetsParameters() throws IxException {
        this.getMESSAGEspecs();
        boolean edits = false;
        for (String aSet : this.reqSets) {
            if (this.hasSet(aSet)) continue;
            this.initializeSet(aSet);
            edits = true;
        }
        for (String aPar : this.reqPars) {
            if (this.hasPar(aPar)) continue;
            this.initializePar(aPar);
            edits = true;
        }
        edits = this.addStandardElementToSet(edits, "node", "World");
        edits = this.addStandardElementToSet(edits, "lvl_spatial", "World");
        edits = this.addStandardElementToSet(edits, "lvl_spatial", "global");
        edits = this.addStandardElementToSet(edits, "time", "year");
        edits = this.addStandardElementToSet(edits, "lvl_temporal", "year");
        edits = this.addStandardElementToSet(edits, "map_temporal_hierarchy", "year.year.year");
        edits = this.addStandardElementToPar(edits, "duration_time", "year", 1.0, "%");
        edits = this.addStandardElementToSet(edits, "type_year", "firstmodelyear");
        edits = this.addStandardElementToSet(edits, "type_year", "lastmodelyear");
        edits = this.addStandardElementToSet(edits, "type_year", "initializeyear_macro");
        edits = this.addStandardElementToSet(edits, "type_node", "economy");
        edits = this.addStandardElementToSet(edits, "type_tec", "all");
        return edits;
    }

    private boolean addStandardElementToSet(boolean edits, String name, String key) throws IxException {
        Set ixSet = this.getSet(name);
        if (ixSet.hasElement(key)) {
            return edits;
        }
        ixSet.addElement(key);
        return true;
    }

    private boolean addStandardElementToPar(boolean edits, String name, String key, double value, String unit) throws IxException {
        Parameter ixPar = this.getPar(name);
        if (ixPar.hasElement(key)) {
            return edits;
        }
        ixPar.addElement(key, (Double)value, unit);
        return true;
    }

    private void assignMessageSetList() throws IxException {
        this.assignMessageSetList(true);
    }

    private void assignMessageSetList(boolean sanityChecks) throws IxException {
        this.getMESSAGEspecs();
        this.nodes = new TreeSet();
        for (Integer eleId : this.getIndexSetKeyIds("node")) {
            this.nodes.add(this.getKeyIdString(eleId));
        }
        this.tecs = new TreeSet();
        for (Integer eleId : this.getIndexSetKeyIds("technology")) {
            this.tecs.add(this.getKeyIdString(eleId));
        }
        this.times = new TreeSet();
        for (Integer eleId : this.getIndexSetKeyIds("time")) {
            this.times.add(this.getKeyIdString(eleId));
        }
        this.emissions = new TreeSet();
        for (Integer eleId : this.getIndexSetKeyIds("emission")) {
            this.emissions.add(this.getKeyIdString(eleId));
        }
        this.tecParList = MESSAGEspecs.getTecParameterList();
        this.tecActParList = MESSAGEspecs.getTecActParameterList();
        if (sanityChecks) {
            String[] requiredSets;
            String[] stringArray = requiredSets = new String[]{"node", "technology", "year", "time"};
            int n = requiredSets.length;
            int n2 = 0;
            while (n2 < n) {
                String aSet = stringArray[n2];
                if (this.getIndexSetKeyIds(aSet).isEmpty()) {
                    throw new IxException("The required set '" + aSet + "' is empty!");
                }
                ++n2;
            }
            int currentState = this.state;
            this.state = -1;
            this.assignDisaggregationMaps();
            this.assignPeriodMaps();
            this.state = currentState;
        }
    }

    private void assignDisaggregationMaps() throws IxException {
        Vector<Integer> eleVector2;
        Vector<Integer> eleVector1;
        Vector<Integer> eleVector;
        int lvl;
        logger.info((Object)" spatial and temporal disaggregation maps assignment");
        LinkedList<Integer> lvlSet = this.getIndexSetKeyIds("lvl_spatial");
        Set map_spatial = this.getSet("map_spatial_hierarchy");
        HashMap<Integer, LinkedList<Integer>> nodeHierarchyMap = new HashMap<Integer, LinkedList<Integer>>();
        int i = lvlSet.size() - 1;
        while (i >= 0) {
            lvl = lvlSet.get(i);
            for (Element element : map_spatial.getElements()) {
                if (element.getKeyId("lvl_spatial") != lvl) continue;
                Integer nodeParent = element.getKeyId("node_parent");
                Integer nodeLocation = element.getKeyId("node");
                LinkedList<Integer> nodeList = (LinkedList<Integer>)nodeHierarchyMap.get(nodeParent);
                if (nodeList == null) {
                    nodeList = new LinkedList<Integer>();
                    nodeHierarchyMap.put(nodeParent, nodeList);
                }
                nodeList.add(nodeParent);
                nodeList.add(nodeLocation);
                LinkedList subNodeList = (LinkedList)nodeHierarchyMap.get(nodeLocation);
                if (subNodeList == null || nodeLocation == nodeParent) continue;
                for (Integer subNode : subNodeList) {
                    nodeList.add(subNode);
                }
            }
            --i;
        }
        Set nodeMapSet = this.getSet("map_node");
        for (Integer parentNode : nodeHierarchyMap.keySet()) {
            eleVector = new Vector<Integer>();
            eleVector.add(parentNode);
            eleVector.add(parentNode);
            nodeMapSet.addElement(eleVector);
            for (Integer childNode : (LinkedList)nodeHierarchyMap.get(parentNode)) {
                eleVector1 = new Vector<Integer>();
                eleVector1.add(parentNode);
                eleVector1.add(childNode);
                nodeMapSet.addElement(eleVector1);
                eleVector2 = new Vector<Integer>();
                eleVector2.add(childNode);
                eleVector2.add(childNode);
                nodeMapSet.addElement(eleVector2);
            }
        }
        lvlSet = this.getIndexSetKeyIds("lvl_temporal");
        Set mapSet = this.getSet("map_temporal_hierarchy");
        HashMap<Integer, LinkedList<Integer>> timeHierarchyMap = new HashMap<Integer, LinkedList<Integer>>();
        i = lvlSet.size() - 1;
        while (i >= 0) {
            lvl = lvlSet.get(i);
            for (Element element : mapSet.getElements()) {
                if (element.getKeyId("lvl_temporal") != lvl) continue;
                Integer timeParent = element.getKeyId("time_parent");
                Integer timeActual = element.getKeyId("time");
                LinkedList<Integer> timeList = (LinkedList<Integer>)timeHierarchyMap.get(timeParent);
                if (timeList == null) {
                    timeList = new LinkedList<Integer>();
                    timeHierarchyMap.put(timeParent, timeList);
                }
                timeList.add(timeParent);
                timeList.add(timeActual);
                LinkedList subTimeList = (LinkedList)timeHierarchyMap.get(timeActual);
                if (subTimeList == null || timeParent == timeActual) continue;
                for (Integer subTime : subTimeList) {
                    timeList.add(subTime);
                }
            }
            --i;
        }
        Set timeMapSet = this.getSet("map_time");
        for (Integer parentTime : timeHierarchyMap.keySet()) {
            eleVector = new Vector<Integer>();
            eleVector.add(parentTime);
            eleVector.add(parentTime);
            timeMapSet.addElement(eleVector);
            for (Integer childTime : (LinkedList)timeHierarchyMap.get(parentTime)) {
                eleVector1 = new Vector();
                eleVector1.add(parentTime);
                eleVector1.add(childTime);
                timeMapSet.addElement(eleVector1);
                eleVector2 = new Vector();
                eleVector2.add(childTime);
                eleVector2.add(childTime);
                timeMapSet.addElement(eleVector2);
            }
        }
    }

    private void assignPeriodMaps() throws IxException {
        logger.info((Object)" period mapping assignment");
        Set catTypeYearSet = this.getSet("type_year");
        Set aCatYearSet = this.getSet("cat_year");
        catTypeYearSet.addElement("cumulative");
        Integer fModelYear = null;
        for (Element ele : aCatYearSet.getElements()) {
            if (!ele.checkKeyAtIndex("type_year", (Integer)this.addKey("firstmodelyear"))) continue;
            fModelYear = Integer.parseInt(this.getKeyIdString(ele.getKeyId("year")));
        }
        this.getYearList();
        for (Integer aYr : this.years) {
            if (fModelYear != null && fModelYear > aYr) continue;
            catTypeYearSet.addElement("" + aYr);
            aCatYearSet.addElement("cumulative." + aYr);
            aCatYearSet.addElement(aYr + "." + aYr);
        }
        logger.info((Object)" duration period assignment");
        Parameter duration_period = this.getPar("duration_period");
        Integer dur = 1;
        int i = 1;
        while (i < this.years.size()) {
            dur = this.years.get(i) - this.years.get(i - 1);
            duration_period.addElement("" + this.years.get(i), (Double)((Object)dur), "y");
            ++i;
        }
        if (this.years.size() > 1) {
            duration_period.addElement("" + this.years.get(0), Double.valueOf(this.years.get(1) - this.years.get(0)), "y");
        } else {
            duration_period.addElement("" + this.years.get(0), (Double)1.0, "y");
        }
    }

    public LinkedList<Integer> getYearList() throws IxException {
        if (this.years == null || this.getSet((String)"year").hasUpdatedElement) {
            this.years = new LinkedList();
            for (Integer eleId : this.getIndexSetKeyIds("year")) {
                this.years.add(new Integer(this.getKeyIdString(eleId)));
            }
        }
        return this.years;
    }

    public String[] getTypeList(String name) throws IxException {
        return this.getTypeSet(name).getIndexSetKeys();
    }

    public void addCatEle(String name, String cat, LinkedList<String> keyList, boolean isUnique) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        int pCatId = this.addKey(cat);
        IndexSet typeSet = this.getTypeSet(name);
        Set catSet = this.getCatSet(name);
        if (!typeSet.hasIndexSetKey(pCatId)) {
            typeSet.addElement(pCatId);
            logger.info((Object)("added the category type '" + cat + "' for set '" + name + "'"));
        }
        if (isUnique) {
            if (cat.equals("all")) {
                throw new IxException("the category mapping 'all' cannot be a singleton!");
            }
            if (keyList.size() > 1) {
                throw new IxException("only add one element to a unique mapping!");
            }
            HashMap<Integer, LinkedList<Integer>> eleFilter = new HashMap<Integer, LinkedList<Integer>>();
            LinkedList<Integer> catIdList = new LinkedList<Integer>();
            catIdList.add(pCatId);
            eleFilter.put(0, catIdList);
            for (Element ele : catSet.filteredEleList(eleFilter)) {
                catSet.removeElement(ele);
            }
        }
        for (String aKey : keyList) {
            int pKeyId = this.getKeyId(aKey);
            this.getIndexSet(name).checkIndexSetKey(pKeyId);
            Vector<Integer> catVector = catSet.getNewVector();
            catVector.add(pCatId);
            catVector.add(pKeyId);
            catSet.addElement(catVector);
        }
    }

    @Override
    public String[] getCatEle(String name, String cat) throws IxException {
        if (cat.equals("all")) {
            return this.getIndexSet(name).getIndexSetKeys();
        }
        int pCatId = this.getKeyId(cat);
        IndexSet typeSet = this.getTypeSet(name);
        Set catSet = this.getCatSet(name);
        typeSet.checkIndexSetKey(pCatId);
        HashMap<Integer, LinkedList<Integer>> eleFilter = new HashMap<Integer, LinkedList<Integer>>();
        LinkedList<Integer> catIdList = new LinkedList<Integer>();
        catIdList.add(pCatId);
        eleFilter.put(0, catIdList);
        return catSet.getCol(1, catSet.filteredEleList(eleFilter));
    }

    private IndexSet getTypeSet(String name) throws IxException {
        if (name.equals("technology")) {
            return this.getIndexSet("type_tec");
        }
        return this.getIndexSet("type_" + name);
    }

    private Set getCatSet(String name) throws IxException {
        if (name.equals("technology")) {
            return this.getSet("cat_tec");
        }
        return this.getSet("cat_" + name);
    }

    public int[] getTecActYrs(String node, String tec, String yearVintage) throws IxException {
        Parameter duration_period = this.getPar("duration_period");
        Parameter lifetime = this.getPar("technical_lifetime");
        Double lt = lifetime.getEleValue(this.getKeyIdVector(node, tec, yearVintage));
        Double elapsedLt = 0.0;
        Integer aVtg = Integer.parseInt(yearVintage);
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (Integer aYr : this.getYearList()) {
            if (aYr < aVtg) continue;
            ret.add(aYr);
            elapsedLt = elapsedLt + duration_period.getEleValue(this.getKeyIdVector(aYr.toString()));
            if (elapsedLt >= lt) break;
        }
        return Arrays.stream(ret.toArray(new Integer[ret.size()])).mapToInt(Integer::intValue).toArray();
    }

    public Set initializeSet(String setName) throws IxException {
        Set aSet = null;
        if (this.hasItem(setName)) {
            throw new IxException("An item with the name '" + setName + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.keySet().contains(setName)) {
            throw new IxException("There are no standard MESSAGE index assignments for set '" + setName + "'!");
        }
        aSet = this.indexSetsMap.get(setName).isEmpty() ? new IndexSet(this, setName) : new Set(this, setName, this.indexSetsMap.get(setName), this.indexNamesMap.get(setName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aSet);
            this.changeLogList.add(new ChangelogEntry("initialize set", setName));
        }
        return aSet;
    }

    @Override
    public Set initializeSet(String setName, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        if (this.indexSetsMap.keySet().contains(setName)) {
            if (this.hasItem(setName)) {
                throw new IxException("An item with the name '" + setName + "' already exists!");
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException("Set '" + setName + "' can only be initialized with MESSAGE standard dimensions!");
            }
            return this.initializeSet(setName);
        }
        return super.initializeSet(setName, indexSets, indexNames);
    }

    public String[] getParList(String type, boolean excludeRelation) throws IxException {
        LinkedList<String> ret = new LinkedList<String>();
        if (type.equals("technology")) {
            for (String aPar : this.tecParList) {
                if (excludeRelation && aPar.contains("relation")) continue;
                ret.add(aPar);
            }
            for (String aPar : this.tecActParList) {
                if (excludeRelation && aPar.contains("relation")) continue;
                ret.add(aPar);
            }
        } else if (type.equals("relations")) {
            if (excludeRelation) {
                throw new IxException("Querying for relations excluding relations doesn't make sense!");
            }
            for (Parameter aPar : this.parList.values()) {
                if (!aPar.getName().contains("relation")) continue;
                ret.add(aPar.getName());
            }
        } else {
            throw new IxException("This function is currently only available for parameters pertaining to technologies and relations!");
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Parameter initializePar(String parName) throws IxException {
        Parameter aPar = null;
        if (this.hasItem(parName)) {
            throw new IxException("An item with the name '" + parName + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.keySet().contains(parName)) {
            throw new IxException("There are no standard MESSAGE index assignments for parameter '" + parName + "'!");
        }
        aPar = new Parameter(this, parName, this.indexSetsMap.get(parName), this.indexNamesMap.get(parName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aPar);
            this.changeLogList.add(new ChangelogEntry("initialize parameter", parName));
        }
        return aPar;
    }

    @Override
    public Parameter initializePar(String parName, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        if (this.indexSetsMap.keySet().contains(parName)) {
            if (this.hasItem(parName)) {
                throw new IxException("An item with the name '" + parName + "' already exists!");
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException("Parameter '" + parName + "' can only be initialized with MESSAGE standard dimensions!");
            }
            return this.initializePar(parName);
        }
        return super.initializePar(parName, indexSets, indexNames);
    }

    public Variable initializeVar(String varName) throws IxException {
        Variable aVar = null;
        if (this.hasItem(varName)) {
            throw new IxException("An item with the name '" + varName + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.keySet().contains(varName)) {
            throw new IxException("There are no standard MESSAGE index assignments for variable '" + varName + "'!");
        }
        aVar = new Variable(this, varName, this.indexSetsMap.get(varName), this.indexNamesMap.get(varName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aVar);
            this.changeLogList.add(new ChangelogEntry("initialize variable", varName));
        }
        return aVar;
    }

    @Override
    public Variable initializeVar(String varName, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        if (this.indexSetsMap.keySet().contains(varName)) {
            if (this.hasItem(varName)) {
                throw new IxException("An item with the name '" + varName + "' already exists!");
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException("Variable '" + varName + "' can only be initialized with MESSAGE standard dimensions!");
            }
            return this.initializeVar(varName);
        }
        return super.initializeVar(varName, indexSets, indexNames);
    }

    public Equation initializeEqu(String equName) throws IxException {
        Equation aEqu = null;
        if (this.hasItem(equName)) {
            throw new IxException("An item with the name '" + equName + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.keySet().contains(equName)) {
            throw new IxException("There are no standard MESSAGE index assignments for equation '" + equName + "'!");
        }
        aEqu = new Equation(this, equName, this.indexSetsMap.get(equName), this.indexNamesMap.get(equName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aEqu);
            this.changeLogList.add(new ChangelogEntry("initialize variable", equName));
        }
        return aEqu;
    }

    @Override
    public Equation initializeEqu(String equName, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        if (this.indexSetsMap.keySet().contains(equName)) {
            if (this.hasItem(equName)) {
                throw new IxException("An item with the name '" + equName + "' already exists!");
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException("Equation '" + equName + "' can only be initialized with MESSAGE standard dimensions!");
            }
            return this.initializeEqu(equName);
        }
        return super.initializeEqu(equName, indexSets, indexNames);
    }

    public HashMap<Vector<Integer>, Double> assignVarToPar(String varName, String parName, HashMap<String, LinkedList<String>> eleListFilter) throws IxException {
        Variable var = this.getVar(varName);
        var.loadItemElementsFromDB();
        LinkedList<Element> eleList = var.getElements(eleListFilter);
        Parameter par = this.getPar(parName);
        par.loadItemElementsFromDB();
        HashMap<Integer, Integer> idxMap = new HashMap<Integer, Integer>();
        int i = 0;
        for (String parIdx : par.idxNames) {
            idxMap.put((Integer)var.nameIdxMap.get(parIdx), i);
            ++i;
        }
        HashMap<Vector<Integer>, Double> newEleList = new HashMap<Vector<Integer>, Double>();
        for (Element element : eleList) {
            Vector<Integer> newEle = new Vector<Integer>();
            int j = 0;
            while (j < par.dim) {
                newEle.add(-1);
                ++j;
            }
            for (Map.Entry entry : idxMap.entrySet()) {
                newEle.set((Integer)entry.getValue(), element.getKeyId((Integer)entry.getKey()));
            }
            double val = 0.0;
            if (newEleList.containsKey(newEle)) {
                val = newEleList.get(newEle);
                val += element.getLevel().doubleValue();
            } else {
                val = element.getLevel();
            }
            newEleList.put(newEle, val);
        }
        for (Map.Entry entry : newEleList.entrySet()) {
            par.addElement((Vector)entry.getKey(), (Double)entry.getValue(), "???", null);
        }
        return newEleList;
    }

    @Override
    public void readSolutionFromGDX(String gamsPath, String gamsGdxFile, String comment, LinkedList<String> varList, LinkedList<String> equList, boolean checkSolution) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.readSolutionFromGDX(osUser, gamsPath, gamsGdxFile, comment, varList, equList, checkSolution);
    }

    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment, boolean checkSolution) throws IxException {
        this.readSolutionFromGDX(user, gamsPath, gamsGdxFile, comment, null, null, checkSolution);
    }

    @Override
    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment, LinkedList<String> varList, LinkedList<String> equList, boolean checkSolution) throws IxException {
        this.removeSolution(user);
        this.getMESSAGEspecs();
        LinkedList<String> importVarList = new LinkedList<String>();
        LinkedList<String> importEquList = new LinkedList<String>();
        this.checkOut(user, false);
        for (String aSet : this.reqIdxSets) {
            if (this.hasSet(aSet)) continue;
            this.initializeSet(aSet);
        }
        for (String aVarName : this.reqVars) {
            if (!this.hasVar(aVarName)) {
                this.initializeVar(aVarName);
            }
            importVarList.add(aVarName);
        }
        for (String aEquName : this.reqEqus) {
            if (!this.hasEqu(aEquName)) {
                this.initializeEqu(aEquName);
            }
            importEquList.add(aEquName);
        }
        if (!this.newItemList.isEmpty()) {
            this.commit(user, "initializing variables and equations required for MESSAGE scheme");
        } else {
            this.checkIn(null);
        }
        if (varList != null && !varList.isEmpty()) {
            for (String aVarName : varList) {
                if (importVarList.contains(aVarName)) continue;
                importVarList.add(aVarName);
            }
        }
        if (equList != null && !equList.isEmpty()) {
            for (String aEquName : equList) {
                if (importEquList.contains(aEquName)) continue;
                importEquList.add(aEquName);
            }
        }
        boolean solNonOpt = false;
        File workingDirectory = new File(gamsPath);
        workingDirectory.mkdir();
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase gamsDB = ws.addDatabaseFromGDX(gamsGdxFile);
        GAMSParameter status = null;
        try {
            status = gamsDB.getParameter("status");
        }
        catch (Exception e) {
            this.discardChanges();
            throw new IxException("no parameter 'status' in the gdx file, did not import the solution!");
        }
        for (GAMSParameterRecord rec : status) {
            if (rec.getKeys()[1].equals("modelstat") && rec.getValue() != 1.0) {
                solNonOpt = true;
                continue;
            }
            if (!rec.getKeys()[1].equals("solvestat") || !(rec.getValue() > 2.0) || rec.getValue() == 8.0) continue;
            solNonOpt = true;
        }
        if (solNonOpt) {
            if (checkSolution) {
                this.discardChanges();
                throw new IxException("MESSAGEix model did not solve to optimality, did not import the solution!");
            }
            logger.error((Object)"WARNING - you are importing a non-optimal solution of a MESSAGEix run!");
        }
        super.readSolFromGDX(gamsPath, gamsGdxFile, comment, importVarList, importEquList);
    }

    @Override
    public void checkOut(String user, boolean timeseriesOnly, boolean checkSolution) throws IxException {
        boolean updated;
        super.checkOut(user, timeseriesOnly, checkSolution);
        if (!timeseriesOnly && (updated = this.initializeMsgSetsParameters())) {
            this.commit("updating MsgScenario to MESSAGE specifications version " + MESSAGEspecs.getMsgVersion());
            super.checkOut(user, timeseriesOnly, checkSolution);
        }
    }

    @Override
    public void commit(String annotation) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.commit(user, annotation);
    }

    @Override
    public void commit(String user, String annotation) throws IxException {
        this.assignMessageSetList();
        super.commit(user, annotation);
    }

    @Override
    public void toGDX(String gamsPath, String gamsGdxFile) throws IxException {
        this.toGDX(gamsPath, gamsGdxFile, false);
    }

    @Override
    public void toGDX(String gamsPath, String gamsGdxFile, boolean includeVarEqu) throws IxException {
        String[] versionNumTypes;
        this.assertTimeseriesIsLockedInDB();
        this.assignMessageSetList();
        this.state = -1;
        this.initializeMsgSetsParameters();
        logger.info((Object)"writing data to gdx...");
        File workingDirectory = new File(gamsPath);
        workingDirectory.mkdir();
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase ixGAMSdb = ws.addDatabase();
        this.getMESSAGEspecs();
        HashMap<String, Integer> msgVersion = MESSAGEspecs.getMsgVersion();
        HashMap<String, Integer> msgItemDefaultDim = MESSAGEspecs.getItemDefaultDim();
        GAMSParameter ixVersion = ixGAMSdb.addParameter("MESSAGE_ix_version", 1);
        String[] stringArray = versionNumTypes = new String[]{"major", "minor"};
        int n = versionNumTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String aType = stringArray[n2];
            Vector<String> vector = new Vector<String>();
            vector.add(aType);
            ((GAMSParameterRecord)ixVersion.addRecord(vector)).setValue((double)msgVersion.get(aType).intValue());
            ++n2;
        }
        for (Set aSet : this.idxsetList.values()) {
            GAMSSet aGamsSet = ixGAMSdb.addSet(((IndexSet)aSet).name, 1);
            Iterator iterator = ((IndexSet)aSet).getIndexSetKeyIds().iterator();
            while (iterator.hasNext()) {
                int keyId = (Integer)iterator.next();
                Iterator vd2 = this.getStringVector(keyId);
                try {
                    aGamsSet.addRecord(vd2);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    throw new IxException("error writing set '" + ((IndexSet)aSet).name + "' to gdx!");
                }
            }
        }
        for (Set aSet : this.setList.values()) {
            Integer dim = Math.max(1, aSet.idxSets.size());
            GAMSSet aGamsSet = ixGAMSdb.addSet(aSet.name, dim.intValue());
            if (aSet.name.equals("cat_tec")) {
                for (String string : this.tecs) {
                    try {
                        Vector<String> vd3 = new Vector<String>();
                        vd3.add("all");
                        vd3.add(string);
                        aGamsSet.addRecord(vd3);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        throw new IxException("error writing category 'all' of set 'cat_tec' to gdx!");
                    }
                }
            } else if (aSet.name.equals("type_tec_land")) {
                try {
                    Vector<String> vector = new Vector<String>();
                    vector.add("all");
                    aGamsSet.addRecord(vector);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    throw new IxException("error writing category 'all' of set 'type_tec_land' to gdx!");
                }
            }
            for (Element element : aSet.getElements()) {
                Vector<String> vd = this.getStringVector(element.getVector());
                try {
                    aGamsSet.addRecord(vd);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    throw new IxException("error writing parameter '" + aSet.name + "' to gdx!");
                }
            }
        }
        for (String aName : this.reqSets) {
            if (this.hasSet(aName)) continue;
            ixGAMSdb.addSet(aName, msgItemDefaultDim.get(aName).intValue());
        }
        HashSet<String> resources = new HashSet<String>();
        HashSet<String> renewables = new HashSet<String>();
        HashMap<Vector<String>, LinkedList> resGradeMap = new HashMap<Vector<String>, LinkedList>();
        HashSet<String> stocks = new HashSet<String>();
        for (Element element : this.getSet("level_resource").getElements()) {
            resources.add(element.getKey(0));
        }
        for (Element element : this.getSet("level_renewable").getElements()) {
            renewables.add(element.getKey(0));
        }
        for (Element element : this.getSet("level_stocks").getElements()) {
            stocks.add(element.getKey(0));
        }
        GAMSSet gAMSSet = ixGAMSdb.addSet("map_resource", 4);
        GAMSSet map_stocks = ixGAMSdb.addSet("map_stocks", 4);
        GAMSSet map_commodity = ixGAMSdb.addSet("map_commodity", 5);
        GAMSSet map_tec = ixGAMSdb.addSet("map_tec", 3);
        GAMSSet map_tec_mode = ixGAMSdb.addSet("map_tec_mode", 4);
        GAMSSet map_tec_time = ixGAMSdb.addSet("map_tec_time", 4);
        GAMSSet map_relation = ixGAMSdb.addSet("map_relation", 3);
        GAMSSet map_land = ixGAMSdb.addSet("map_land", 3);
        GAMSSet inv_tec = ixGAMSdb.addSet("inv_tec", 1);
        GAMSSet renewable_tec = ixGAMSdb.addSet("renewable_tec", 1);
        GAMSSet is_bound_extraction_up = ixGAMSdb.addSet("is_bound_extraction_up", 4);
        GAMSSet is_bound_new_capacity_up = ixGAMSdb.addSet("is_bound_new_capacity_up", 3);
        GAMSSet is_bound_new_capacity_lo = ixGAMSdb.addSet("is_bound_new_capacity_lo", 3);
        GAMSSet is_bound_total_capacity_up = ixGAMSdb.addSet("is_bound_total_capacity_up", 3);
        GAMSSet is_bound_total_capacity_lo = ixGAMSdb.addSet("is_bound_total_capacity_lo", 3);
        GAMSSet is_bound_activity_up = ixGAMSdb.addSet("is_bound_activity_up", 5);
        GAMSSet is_dynamic_new_capacity_up = ixGAMSdb.addSet("is_dynamic_new_capacity_up", 3);
        GAMSSet is_dynamic_new_capacity_lo = ixGAMSdb.addSet("is_dynamic_new_capacity_lo", 3);
        GAMSSet is_dynamic_activity_up = ixGAMSdb.addSet("is_dynamic_activity_up", 4);
        GAMSSet is_dynamic_activity_lo = ixGAMSdb.addSet("is_dynamic_activity_lo", 4);
        GAMSSet is_bound_emission = ixGAMSdb.addSet("is_bound_emission", 4);
        GAMSSet is_dynamic_land_scen_up = ixGAMSdb.addSet("is_dynamic_land_scen_up", 3);
        GAMSSet is_dynamic_land_scen_lo = ixGAMSdb.addSet("is_dynamic_land_scen_lo", 3);
        GAMSSet is_dynamic_land_up = ixGAMSdb.addSet("is_dynamic_land_up", 3);
        GAMSSet is_dynamic_land_lo = ixGAMSdb.addSet("is_dynamic_land_lo", 3);
        GAMSSet is_relation_upper = ixGAMSdb.addSet("is_relation_upper", 3);
        GAMSSet is_relation_lower = ixGAMSdb.addSet("is_relation_lower", 3);
        GAMSSet is_fixed_extraction = ixGAMSdb.addSet("is_fixed_extraction", 4);
        GAMSSet is_fixed_stock = ixGAMSdb.addSet("is_fixed_stock", 4);
        GAMSSet is_fixed_new_capacity = ixGAMSdb.addSet("is_fixed_new_capacity", 3);
        GAMSSet is_fixed_capacity = ixGAMSdb.addSet("is_fixed_capacity", 4);
        GAMSSet is_fixed_activity = ixGAMSdb.addSet("is_fixed_activity", 6);
        GAMSSet is_fixed_land = ixGAMSdb.addSet("is_fixed_land", 3);
        for (Parameter aPar : this.parList.values()) {
            String name = aPar.name;
            GAMSParameter aGamsPar = ixGAMSdb.addParameter(name, aPar.dim.intValue());
            if (aPar.dim == 0) {
                aPar.loadItemElementsFromDB();
                ((GAMSParameterRecord)aGamsPar.addRecord(new Vector())).setValue(aPar.getScalarValue().doubleValue());
                continue;
            }
            for (Element ele : aPar.getElements()) {
                Vector<String> vd4 = this.getStringVector(ele.getVector());
                try {
                    LinkedList gradeList;
                    ((GAMSParameterRecord)aGamsPar.addRecord(vd4)).setValue(ele.getValue().doubleValue());
                    if (name.equals("demand")) {
                        this.addToMappingSet((GAMSSymbol)map_commodity, vd4);
                        continue;
                    }
                    if (name.equals("resource_volume")) {
                        Vector<String> nodeCom = this.getSubVector(vd4, 0, 1);
                        gradeList = (LinkedList)resGradeMap.get(nodeCom);
                        if (gradeList == null) {
                            gradeList = new LinkedList();
                        }
                        gradeList.add(vd4.get(2));
                        resGradeMap.put(nodeCom, gradeList);
                        continue;
                    }
                    if (name.equals("input") || name.equals("output")) {
                        this.addToMappingSet((GAMSSymbol)map_commodity, this.getSubVector(vd4, 5, 6, 7, 3, 9));
                        if (stocks.contains(vd4.get(7))) {
                            this.addToMappingSet((GAMSSymbol)map_stocks, this.getSubVector(vd4, 0, 6, 7, 3));
                        }
                        if (name.equals("input") && resources.contains(vd4.get(7))) {
                            Vector<String> resVd = this.getSubVector(vd4, 0, 6);
                            gradeList = (LinkedList)resGradeMap.get(resVd);
                            if (gradeList == null) {
                                throw new IxException(" the resource-commodity '" + vd4.get(7) + "' at node '" + vd4.get(0) + "' does not have a resource volume assigned for any grade!");
                            }
                            resVd.add((String)gradeList.getFirst());
                            resVd.add(vd4.get(3));
                            for (String aGrd : gradeList) {
                                resVd.set(2, aGrd);
                                this.addToMappingSet((GAMSSymbol)gAMSSet, resVd);
                            }
                        }
                        if (name.equals("input") && renewables.contains(vd4.get(7))) {
                            this.addToMappingSet((GAMSSymbol)renewable_tec, this.getSubVector(vd4, 1));
                        }
                        this.addToMappingSet((GAMSSymbol)map_tec, this.getSubVector(vd4, 0, 1, 3));
                        this.addToMappingSet((GAMSSymbol)map_tec_mode, this.getSubVector(vd4, 0, 1, 3, 4));
                        this.addToMappingSet((GAMSSymbol)map_tec_time, this.getSubVector(vd4, 0, 1, 3, 8));
                        continue;
                    }
                    if (name.equals("relation_new_capacity") || name.equals("relation_total_capacity")) {
                        this.addToMappingSet((GAMSSymbol)map_relation, this.getSubVector(vd4, 0, 1, 2));
                        this.addToMappingSet((GAMSSymbol)map_tec, this.getSubVector(vd4, 1, 3, 2));
                        continue;
                    }
                    if (name.equals("relation_activity")) {
                        this.addToMappingSet((GAMSSymbol)map_relation, this.getTecVector(vd4));
                        Vector<String> vdTec = this.getSubVector(vd4, 3, 4, 5);
                        this.addToMappingSet((GAMSSymbol)map_tec, vdTec);
                        vdTec.add(vd4.get(6));
                        this.addToMappingSet((GAMSSymbol)map_tec_mode, vdTec);
                        vdTec.set(3, "year");
                        this.addToMappingSet((GAMSSymbol)map_tec_time, vdTec);
                        continue;
                    }
                    if (name.equals("inv_cost")) {
                        this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd4, 1));
                        continue;
                    }
                    if (name.equals("bound_extraction_up")) {
                        is_bound_extraction_up.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("bound_new_capacity_up")) {
                        is_bound_new_capacity_up.addRecord(vd4);
                        this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd4, 1));
                        continue;
                    }
                    if (name.equals("bound_new_capacity_lo")) {
                        is_bound_new_capacity_lo.addRecord(vd4);
                        this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd4, 1));
                        continue;
                    }
                    if (name.equals("bound_total_capacity_up")) {
                        is_bound_total_capacity_up.addRecord(vd4);
                        this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd4, 1));
                        continue;
                    }
                    if (name.equals("bound_total_capacity_lo")) {
                        is_bound_total_capacity_lo.addRecord(vd4);
                        this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd4, 1));
                        continue;
                    }
                    if (name.equals("bound_activity_up")) {
                        is_bound_activity_up.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("initial_new_capacity_up")) {
                        is_dynamic_new_capacity_up.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("growth_new_capacity_up")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_new_capacity_up, vd4);
                        continue;
                    }
                    if (name.equals("initial_new_capacity_lo")) {
                        is_dynamic_new_capacity_lo.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("growth_new_capacity_lo")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_new_capacity_lo, vd4);
                        continue;
                    }
                    if (name.equals("initial_activity_up")) {
                        is_dynamic_activity_up.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("growth_activity_up")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_activity_up, vd4);
                        continue;
                    }
                    if (name.equals("initial_activity_lo")) {
                        is_dynamic_activity_lo.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("growth_activity_lo")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_activity_lo, vd4);
                        continue;
                    }
                    if (name.equals("bound_emission")) {
                        is_bound_emission.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("land_cost")) {
                        this.addToMappingSet((GAMSSymbol)map_land, vd4);
                        continue;
                    }
                    if (name.equals("land_input") || name.equals("land_output")) {
                        this.addToMappingSet((GAMSSymbol)map_land, this.getSubVector(vd4, 0, 1, 2));
                        continue;
                    }
                    if (name.equals("initial_land_scen_up")) {
                        is_dynamic_land_scen_up.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("growth_land_scen_up")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_land_scen_up, vd4);
                        continue;
                    }
                    if (name.equals("initial_land_scen_lo")) {
                        is_dynamic_land_scen_lo.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("growth_land_scen_lo")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_land_scen_lo, vd4);
                        continue;
                    }
                    if (name.equals("initial_land_up")) {
                        is_dynamic_land_up.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("dynamic_land_up")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_land_up, this.getSubVector(vd4, 0, 2, 3));
                        continue;
                    }
                    if (name.equals("growth_land_up")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_land_up, vd4);
                        continue;
                    }
                    if (name.equals("initial_land_lo")) {
                        is_dynamic_land_lo.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("dynamic_land_lo")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_land_lo, this.getSubVector(vd4, 0, 2, 3));
                        continue;
                    }
                    if (name.equals("growth_land_lo")) {
                        this.addToMappingSet((GAMSSymbol)is_dynamic_land_lo, vd4);
                        continue;
                    }
                    if (name.equals("relation_upper")) {
                        is_relation_upper.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("relation_lower")) {
                        is_relation_lower.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("fixed_extraction")) {
                        is_fixed_extraction.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("fixed_stock")) {
                        is_fixed_stock.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("fixed_new_capacity")) {
                        is_fixed_new_capacity.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("fixed_capacity")) {
                        is_fixed_capacity.addRecord(vd4);
                        continue;
                    }
                    if (name.equals("fixed_activity")) {
                        is_fixed_activity.addRecord(vd4);
                        continue;
                    }
                    if (!name.equals("fixed_land")) continue;
                    is_fixed_land.addRecord(vd4);
                    this.addToMappingSet((GAMSSymbol)map_land, vd4);
                }
                catch (Exception e) {
                    this.state = 0;
                    if (e instanceof IxException) {
                        throw e;
                    }
                    String error = "error writing parameter '" + name + "' to gdx!";
                    logger.error((Object)error, (Throwable)e);
                    throw new IxException(error);
                }
            }
        }
        ixGAMSdb.export(gamsGdxFile);
        this.loadScenFromDB(this.runId);
        this.checkIn(null);
        logger.info((Object)"done writing data to gdx!");
    }

    private void addToMappingSet(GAMSSymbol gamsItem, Vector<String> vector) {
        String[] aList = new String[vector.size()];
        int i = 0;
        for (String s : vector) {
            aList[i++] = s;
        }
        try {
            gamsItem.findRecord(aList);
        }
        catch (Exception e) {
            gamsItem.addRecord(vector);
        }
    }

    private Vector<String> getSubVector(Vector<String> vd, int ... idx) {
        Vector<String> retval = new Vector<String>();
        int[] nArray = idx;
        int n = idx.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            retval.add(vd.get(i));
            ++n2;
        }
        return retval;
    }

    private Vector<String> getTecVector(Vector<String> vd) {
        Vector<String> retval = new Vector<String>();
        int i = 0;
        while (i < 3) {
            retval.add(i, vd.get(i));
            ++i;
        }
        return retval;
    }
}

