/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.ixobjects.IXelement;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Variable;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Vector;

public class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient Item ixItem = null;
    private Integer id = null;
    private Vector<Integer> keyVector = null;
    private Double value = null;
    private Integer unitid = null;
    private Double level = null;
    private Double marginal = null;

    Element(Item pItem, Vector<Integer> pKeyVector) {
        this.ixItem = pItem;
        this.setId();
        this.keyVector = pKeyVector;
    }

    Element(Item pItem, Vector<Integer> pKeyVector, Double pValue, Integer pUnitId) {
        this.ixItem = pItem;
        this.setId();
        this.keyVector = pKeyVector;
        this.value = pValue;
        this.unitid = pUnitId;
    }

    Element(Item pItem, Double pValue, Integer pUnitId) {
        this.ixItem = pItem;
        this.setId();
        this.setScalar();
        this.value = pValue;
        this.unitid = pUnitId;
    }

    Element(Item pItem, Vector<Integer> pKeyVector, Double pLevel, Double pMarginal) {
        this.ixItem = pItem;
        this.setId();
        this.keyVector = pKeyVector;
        this.level = pLevel;
        this.marginal = pMarginal;
    }

    Element(Item pItem, Double pLevel, Double pMarginal) {
        this.ixItem = pItem;
        this.setId();
        this.setScalar();
        this.level = pLevel;
        this.marginal = pMarginal;
    }

    Element(IXelement ixElement) {
        this.id = ixElement.id;
        this.keyVector = ixElement.keyVector;
        this.value = ixElement.value;
        this.unitid = ixElement.unitid;
        this.level = ixElement.level;
        this.marginal = ixElement.marginal;
    }

    void setIXitem(Item pItem) {
        this.ixItem = pItem;
    }

    private void setScalar() {
        this.keyVector = new Vector();
        this.keyVector.add(0);
    }

    void setId() {
        this.id = this.ixItem.scenario.getNextItemId();
    }

    Integer getId() {
        return this.id;
    }

    public Vector<Integer> getVector() {
        return this.keyVector;
    }

    public Vector<Integer> getClonedVector() {
        Vector<Integer> aVector = this.ixItem.getNewVector();
        for (Integer aKey : this.keyVector) {
            aVector.add(aKey);
        }
        return aVector;
    }

    Integer getKeyId(String pIdxName) throws IxException {
        return this.keyVector.get(this.ixItem.getIdx(pIdxName));
    }

    Integer getKeyId(int pIdx) {
        return this.keyVector.get(pIdx);
    }

    public String getConcatKey() {
        return this.ixItem.getConcatKey(this.keyVector);
    }

    public String[] getKey() {
        Vector<String> ret = new Vector<String>(this.ixItem.dim);
        int i = 0;
        while (i < this.ixItem.dim) {
            ret.add(this.ixItem.scenario.getKeyIdString(this.keyVector.get(i)));
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String getKey(String pIdxName) throws IxException {
        return this.getKey(this.ixItem.getIdx(pIdxName));
    }

    public String getKey(int idx) {
        return this.ixItem.scenario.getKeyIdString(this.keyVector.get(idx));
    }

    public boolean checkKeyAtIndex(String pIdxName, String pKey) throws IxException {
        return this.checkKeyAtIndex(pIdxName, (Integer)this.ixItem.scenario.getKeyId(pKey));
    }

    public boolean checkKeyAtIndex(String pIdxName, Integer pKeyId) throws IxException {
        return this.getKeyId(pIdxName).equals(pKeyId);
    }

    protected boolean checkKeyAtIndex(int pIdx, Integer pKeyId) {
        return this.getKeyId(pIdx).equals(pKeyId);
    }

    public LinkedList<String> getEleComments() {
        return this.ixItem.getCommentsById(this.id);
    }

    public void setValue(Double pVal) throws IxException {
        if (!(this.ixItem instanceof Parameter)) {
            throw new IxException("This element does not have a value!");
        }
        this.value = pVal;
    }

    public Double getValue() throws IxException {
        if (!(this.ixItem instanceof Parameter)) {
            throw new IxException("This element does not have a value!");
        }
        return this.value;
    }

    protected void setUnitId(Integer pUnitId) throws IxException {
        if (!(this.ixItem instanceof Parameter)) {
            throw new IxException("This element does not have a unit!");
        }
        this.unitid = pUnitId;
    }

    Integer getUnitId() throws IxException {
        if (!(this.ixItem instanceof Parameter)) {
            throw new IxException("This element does not have a unit!");
        }
        return this.unitid;
    }

    public String getUnit() throws IxException {
        if (!(this.ixItem instanceof Parameter)) {
            throw new IxException("This element does not have a unit!");
        }
        return this.ixItem.scenario.getUnitName(this.unitid);
    }

    public Double getLevel() throws IxException {
        if (!(this.ixItem instanceof Variable) && !(this.ixItem instanceof Equation)) {
            throw new IxException("This element does not have a level!");
        }
        return this.level;
    }

    public Double getMarginal() throws IxException {
        if (!(this.ixItem instanceof Variable) && !(this.ixItem instanceof Equation)) {
            throw new IxException("This element does not have a marginal!");
        }
        return this.marginal;
    }
}

