/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;

public class PostgresDAO
extends DbDAO {
    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getOnlyDefault, int modelId, int scenarioId) throws IxException {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String qString = "SELECT r.id AS run_id, m.id AS model_id, s.id AS scen_id, m.name AS model, s.name AS scenario,  CAST(d.id = r.id AS BOOLEAN) AS isDefault,  CAST(r.status = 0 AS BOOLEAN) AS isLocked,  r.cre_user, r.cre_date, r.upd_user, r.upd_date, r.lock_user, r.lock_date,  r.version AS version, r.scheme, r.annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id";
        qString = getOnlyDefault ? String.valueOf(qString) + " INNER JOIN" : String.valueOf(qString) + " LEFT JOIN";
        qString = String.valueOf(qString) + " run_default d ON (d.model_id = m.id AND d.scen_id = s.id AND d.id = r.id )";
        if (modelId > -1 && scenarioId > -1) {
            qString = String.valueOf(qString) + " WHERE r.model_id = ? AND r.scen_id = ?";
        } else if (modelId > -1) {
            qString = String.valueOf(qString) + " WHERE r.model_id = ?";
        } else if (scenarioId > -1) {
            qString = String.valueOf(qString) + " WHERE d.scen_id = ?";
        }
        qString = String.valueOf(qString) + " ORDER BY model, scenario, d.id, version DESC";
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(qString);){
                if (modelId > -1 && scenarioId > -1) {
                    stmt.setInt(1, modelId);
                    stmt.setInt(2, scenarioId);
                } else if (modelId > -1) {
                    stmt.setInt(1, modelId);
                } else if (scenarioId > -1) {
                    stmt.setInt(1, scenarioId);
                }
                ResultSet results = stmt.executeQuery();
                while (results.next()) {
                    Map<String, Object> row = this.getRunResultInfo(results);
                    data.add(row);
                }
                results.close();
                stmt.close();
                return data;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the list of scenarios from the database!", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getNextSeq(String pTable) throws IxException {
        int result = 1;
        String qString = "VALUES NEXT VALUE FOR " + pTable + "_seq";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                PreparedStatement stmt = this.getConn().prepareStatement(qString);
                try {
                    try (ResultSet aRs = stmt.executeQuery();){
                        if (aRs.next()) {
                            result = aRs.getInt(1);
                        }
                    }
                    if (stmt == null) return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw this.loggedIxException("Error getting the next sequence number for table '" + pTable + "'!", e);
        }
    }

    @Override
    public void writeChangeLog(int runId, int annotationId, List<ChangelogEntry> changeLogList) throws IxException {
        String iString = "insert into CHANGE_LOG (annotationid, runid, operation, item, key, val_prev, val_new) values (?,?,?,?,?,?,?)";
        try {
            PreparedStatement stmt = this.getConn().prepareStatement(iString);
            boolean hasUpdates = false;
            for (ChangelogEntry aEntry : changeLogList) {
                stmt.setInt(1, annotationId);
                stmt.setInt(2, runId);
                stmt.setString(3, aEntry.getOperation());
                stmt.setString(4, aEntry.getItem());
                if (aEntry.getKey() != null) {
                    stmt.setString(5, aEntry.getKey());
                } else {
                    stmt.setNull(5, 12);
                }
                if (aEntry.getValPrev() != null) {
                    stmt.setDouble(6, aEntry.getValPrev());
                } else {
                    stmt.setNull(6, 8);
                }
                if (aEntry.getValNew() != null) {
                    stmt.setDouble(7, aEntry.getValNew());
                } else {
                    stmt.setNull(7, 8);
                }
                stmt.addBatch();
                hasUpdates = true;
            }
            if (hasUpdates) {
                stmt.executeBatch();
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot write change log!", e);
        }
    }

    @Override
    public Map<List<Integer>, Integer> saveTimeseriesToDB(int runId, Map<List<Integer>, Map<Integer, Double>> tsMap) throws IxException {
        Map<List<Integer>, Integer> tsInfo = this.getTsInfoFromDB(runId);
        try {
            String iStringInfo = "insert into IAMC_TSINFO (tsid, runid, node, key, meta, time) values (?,?,?,?,?,?)";
            String iStringData = "insert into IAMC_TSDATA (tsid, year, value) values (?,?,?)";
            Connection conn = this.getConn();
            PreparedStatement infoStmt = conn.prepareStatement(iStringInfo);
            PreparedStatement dataStmt = conn.prepareStatement(iStringData);
            boolean batchInfo = false;
            boolean batchData = false;
            for (Map.Entry<List<Integer>, Map<Integer, Double>> aTs : tsMap.entrySet()) {
                int tsId = -1;
                try {
                    tsId = tsInfo.get(aTs.getKey());
                }
                catch (Exception e) {
                    tsId = this.getNextSeq("IAMC_TS");
                    infoStmt.setInt(1, tsId);
                    infoStmt.setInt(2, runId);
                    infoStmt.setInt(3, aTs.getKey().get(0));
                    infoStmt.setInt(4, aTs.getKey().get(1));
                    infoStmt.setInt(5, aTs.getKey().get(2));
                    if (aTs.getKey().size() > 3) {
                        infoStmt.setInt(6, aTs.getKey().get(3));
                    } else {
                        infoStmt.setInt(6, -1);
                    }
                    infoStmt.addBatch();
                    batchInfo = true;
                    tsInfo.put(aTs.getKey(), tsId);
                }
                for (Map.Entry<Integer, Double> data : aTs.getValue().entrySet()) {
                    dataStmt.setInt(1, tsId);
                    dataStmt.setInt(2, data.getKey());
                    dataStmt.setDouble(3, data.getValue());
                    dataStmt.addBatch();
                    batchData = true;
                }
            }
            if (batchInfo) {
                infoStmt.executeBatch();
            }
            infoStmt.close();
            if (batchData) {
                dataStmt.executeBatch();
            }
            dataStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error writing the timeseries data to the IXMP database!", e);
        }
        return tsInfo;
    }

    @Override
    public void testConn() throws IxException {
        try {
            this.dbConn.createStatement().executeQuery("select 1");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.openConn();
        }
    }

    @Override
    protected boolean needsShutdown() {
        return false;
    }

    @Override
    public void closeConn() throws IxException {
        try {
            this.dbConn.rollback();
            this.dbConn.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error closing the database connection!", e);
        }
    }

    @Override
    public void getIndexSets(Scenario scen, int runId) throws IxException {
        try {
            String qString = "select name, itemid, ele_blob from IX_IDXSET where runid=? and itemid>-1 order by itemid";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                String name = results.getString(1);
                int itemId = results.getInt(2);
                Object aObject = null;
                byte[] blob = results.getBytes(3);
                if (blob != null) {
                    try {
                        ObjectInputStream oip;
                        try {
                            oip = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(blob)));
                        }
                        catch (ZipException ze) {
                            oip = new ObjectInputStream(new ByteArrayInputStream(blob));
                        }
                        try {
                            aObject = oip.readObject();
                        }
                        finally {
                            oip.close();
                        }
                    }
                    catch (Exception e) {
                        throw this.loggedIxException("There was a problem reading a blob from the database", e);
                    }
                }
                if (!(aObject instanceof List)) continue;
                List<Object> aBlob = ((List)aObject).stream().map(elt -> elt).collect(Collectors.toList());
                new IndexSet(scen, name, itemId, aBlob);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error getting index sets", null);
        }
    }

    @Override
    protected Object getBlobFromDB(int runId, Item item, String col) throws IxException {
        Object aObject = null;
        try {
            String type = item.getTypeForDB();
            String name = item.getName();
            String qString = "select " + col + "_blob from ix_" + type + "_blobstore where runid=? and name=?";
            PreparedStatement qStmt = this.getConn().prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setString(2, name);
            ResultSet aRs = qStmt.executeQuery();
            while (aRs.next()) {
                byte[] blob = aRs.getBytes(1);
                if (blob == null) continue;
                try {
                    ObjectInputStream oip;
                    try {
                        oip = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(blob)));
                    }
                    catch (ZipException ze) {
                        oip = new ObjectInputStream(new ByteArrayInputStream(blob));
                    }
                    try {
                        aObject = oip.readObject();
                    }
                    finally {
                        oip.close();
                    }
                }
                catch (Exception e) {
                    throw this.loggedIxException("There was a problem reading the blob of " + item.getTypeName() + " from the database!", e);
                }
            }
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem loading elements of " + item.getTypeName() + " from the database!", e);
        }
        return aObject;
    }
}

