/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;

public class OracleDAO
extends DbDAO {
    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getOnlyDefault, int modelId, int scenarioId) throws IxException {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String qString = "SELECT r.id run_id, m.id model_id, s.id scen_id, m.name model, s.name scenario, CASE WHEN (d.id >= 0) THEN 1 ELSE 0 END isDefault, CASE r.status WHEN 0 THEN 1 WHEN 1 THEN 0 END AS isLocked,  r.cre_user, r.cre_date, r.upd_user, r.upd_date, r.lock_user, r.lock_date,  r.version AS version, r.scheme, r.annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id";
        qString = getOnlyDefault ? String.valueOf(qString) + " INNER JOIN" : String.valueOf(qString) + " LEFT JOIN";
        qString = String.valueOf(qString) + " run_default d ON (d.model_id=m.id and d.SCEN_ID=s.id and d.ID=r.id )";
        if (modelId > -1 && scenarioId > -1) {
            qString = String.valueOf(qString) + " where r.model_id=? and r.scen_id=?";
        } else if (modelId > -1) {
            qString = String.valueOf(qString) + " where r.model_id=?";
        } else if (scenarioId > -1) {
            qString = String.valueOf(qString) + " where d.scen_id=?";
        }
        qString = String.valueOf(qString) + " ORDER BY model, scenario, d.id, version desc";
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(qString);){
                if (modelId > -1 && scenarioId > -1) {
                    stmt.setInt(1, modelId);
                    stmt.setInt(2, scenarioId);
                } else if (modelId > -1) {
                    stmt.setInt(1, modelId);
                } else if (scenarioId > -1) {
                    stmt.setInt(1, scenarioId);
                }
                ResultSet results = stmt.executeQuery();
                while (results.next()) {
                    Map<String, Object> row = this.getRunResultInfo(results);
                    data.add(row);
                }
                results.close();
                stmt.close();
                return data;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the list of scenarios from the database!", e);
        }
    }

    @Override
    protected int getNextSeq(String pTable) throws IxException {
        int retval = 1;
        try {
            Statement stmt = this.getConn().createStatement();
            String qString = "select " + pTable + "_seq.nextval from dual";
            ResultSet aRs = stmt.executeQuery(qString);
            if (aRs.next()) {
                retval = aRs.getInt(1);
            }
            aRs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error getting the next sequence number for table '" + pTable + "'!", e);
        }
        return retval;
    }

    @Override
    protected boolean needsShutdown() {
        return false;
    }

    @Override
    public void writeChangeLog(int runId, int annotationId, List<ChangelogEntry> changeLogList) throws IxException {
        String iString = "insert into CHANGE_LOG (annotationid, runid, operation, item, key, val_prev, val_new) values (?,?,?,?,?,?,?)";
        try {
            OraclePreparedStatement stmt = (OraclePreparedStatement)this.getConn().prepareStatement(iString);
            boolean hasUpdates = false;
            for (ChangelogEntry aEntry : changeLogList) {
                stmt.setInt(1, annotationId);
                stmt.setInt(2, runId);
                stmt.setString(3, aEntry.getOperation());
                stmt.setString(4, aEntry.getItem());
                if (aEntry.getKey() != null) {
                    stmt.setString(5, aEntry.getKey());
                } else {
                    stmt.setNull(5, 12);
                }
                if (aEntry.getValPrev() != null) {
                    stmt.setBinaryDouble(6, aEntry.getValPrev().doubleValue());
                } else {
                    stmt.setNull(6, 8);
                }
                if (aEntry.getValNew() != null) {
                    stmt.setBinaryDouble(7, aEntry.getValNew().doubleValue());
                } else {
                    stmt.setNull(7, 8);
                }
                stmt.addBatch();
                hasUpdates = true;
            }
            if (hasUpdates) {
                stmt.executeBatch();
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot write change log!", e);
        }
    }

    @Override
    public Map<List<Integer>, Integer> saveTimeseriesToDB(int runId, Map<List<Integer>, Map<Integer, Double>> tsMap) throws IxException {
        Map<List<Integer>, Integer> tsInfo = this.getTsInfoFromDB(runId);
        try {
            String iStringInfo = "insert into IAMC_TSINFO (tsid, runid, node, key, meta, time) values (?,?,?,?,?,?)";
            String iStringData = "insert into IAMC_TSDATA (tsid, year, value) values (?,?,?)";
            Connection conn = this.getConn();
            PreparedStatement infoStmt = conn.prepareStatement(iStringInfo);
            OraclePreparedStatement dataStmt = (OraclePreparedStatement)conn.prepareStatement(iStringData);
            boolean batchInfo = false;
            boolean batchData = false;
            for (Map.Entry<List<Integer>, Map<Integer, Double>> aTs : tsMap.entrySet()) {
                int tsId = -1;
                try {
                    tsId = tsInfo.get(aTs.getKey());
                }
                catch (Exception e) {
                    tsId = this.getNextSeq("IAMC_TS");
                    infoStmt.setInt(1, tsId);
                    infoStmt.setInt(2, runId);
                    infoStmt.setInt(3, aTs.getKey().get(0));
                    infoStmt.setInt(4, aTs.getKey().get(1));
                    infoStmt.setInt(5, aTs.getKey().get(2));
                    if (aTs.getKey().size() > 3) {
                        infoStmt.setInt(6, aTs.getKey().get(3));
                    } else {
                        infoStmt.setInt(6, -1);
                    }
                    infoStmt.addBatch();
                    batchInfo = true;
                    tsInfo.put(aTs.getKey(), tsId);
                }
                for (Map.Entry<Integer, Double> data : aTs.getValue().entrySet()) {
                    dataStmt.setInt(1, tsId);
                    dataStmt.setInt(2, data.getKey().intValue());
                    dataStmt.setBinaryDouble(3, data.getValue().doubleValue());
                    dataStmt.addBatch();
                    batchData = true;
                }
            }
            if (batchInfo) {
                infoStmt.executeBatch();
            }
            infoStmt.close();
            if (batchData) {
                dataStmt.executeBatch();
            }
            dataStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error writing the timeseries data to the IXMP database!", e);
        }
        return tsInfo;
    }

    @Override
    public void testConn() throws IxException {
        try {
            Statement qStmt = this.dbConn.createStatement();
            String qString = "select sysdate from DUAL";
            ResultSet aRs = qStmt.executeQuery(qString);
            while (aRs.next()) {
                aRs.getString(1);
            }
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.openConn();
        }
    }

    @Override
    public void closeConn() throws IxException {
        try {
            this.dbConn.rollback();
            this.dbConn.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error closing the database connection!", e);
        }
    }
}

