/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.DAO;
import at.ac.iiasa.ixmp.database.DBUtils;
import at.ac.iiasa.ixmp.database.DbConfig;
import at.ac.iiasa.ixmp.database.HsqldbDAO;
import at.ac.iiasa.ixmp.database.OracleDAO;
import at.ac.iiasa.ixmp.database.PostgresDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Variable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;

public abstract class DbDAO
implements DAO {
    static Logger logger = Logger.getLogger((String)DbDAO.class.getName());
    private static HashSet<String> TABLE_NAMES_WHITELIST = new HashSet<String>(Arrays.asList("APP_FILES", "MODEL", "SCENARIO", "IX_UNIT", "IAMC_NODES"));
    private String[] ixParTables = new String[]{"IX_PAR_BLOBSTORE", "IX_PAR_DIM", "IX_PAR"};
    private String[] ixVarTables = new String[]{"IX_VAR_BLOBSTORE", "IX_VAR_DIM", "IX_VAR"};
    private String[] ixSetTables = new String[]{"IX_SET_BLOBSTORE", "IX_SET_DIM", "IX_SET", "IX_IDXSET"};
    private String[] ixStructure = new String[]{"IX_COMMENT", "IX_KEY"};
    String[] iamcTables = new String[]{"REF_DATA"};
    private String dbInterface;
    private DbConfig dbConfig;
    protected Connection dbConn;
    private static DbDAO instance;

    public static DbDAO create(String pInterface, DbConfig pDbCfg) throws IxException {
        DbDAO dao;
        switch (pDbCfg.dbEngine()) {
            case "oracle": {
                dao = new OracleDAO();
                break;
            }
            case "postgresql": {
                dao = new PostgresDAO();
                break;
            }
            case "hsqldb": {
                dao = new HsqldbDAO();
                break;
            }
            default: {
                throw new IxException("Unsupported DB engine: " + pDbCfg.dbEngine());
            }
        }
        dao.dbInterface = pInterface;
        dao.dbConfig = pDbCfg;
        dao.openConn();
        return dao;
    }

    public static DbDAO create(DbConfig dbConfig) throws IxException {
        return DbDAO.create("Java", dbConfig);
    }

    public static DbDAO getInstance() throws IxException {
        return DbDAO.getInstance(null, null);
    }

    public static synchronized DbDAO getInstance(String pInterface, DbConfig config) throws IxException {
        if (instance == null) {
            if (config == null) {
                config = new DbConfig();
            }
            instance = DbDAO.create(pInterface, config);
        }
        return instance;
    }

    public String getInterface() {
        return this.dbInterface;
    }

    public Connection getConn() throws IxException {
        this.testConn();
        return this.dbConn;
    }

    private int getSomeId(String table, String name) throws IxException {
        if (!TABLE_NAMES_WHITELIST.contains(DBUtils.upperCase(table))) {
            throw this.loggedIxException("Not allowed to get ID from '" + table + "'", null);
        }
        int retval = -1;
        try {
            String qString = "select id from " + table + " where name = ?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setString(1, name);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt(1);
            }
            aRs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem getting '" + name + "' in table '" + table + "' from the database!", e);
        }
        if (retval == -1) {
            throw this.loggedIxException("There is no entry '" + name + "' in table '" + table + "' in the database!", null);
        }
        return retval;
    }

    Map<String, Object> getRunResultInfo(ResultSet result) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("run_id", result.getInt("run_id"));
        map.put("model_id", result.getInt("model_id"));
        map.put("scen_id", result.getInt("scen_id"));
        map.put("model", result.getString("model"));
        map.put("scenario", result.getString("scenario"));
        map.put("is_default", result.getBoolean("isDefault"));
        map.put("is_locked", result.getBoolean("isLocked"));
        map.put("cre_user", result.getString("cre_user"));
        map.put("cre_date", result.getString("cre_date"));
        map.put("upd_user", result.getString("upd_user"));
        map.put("upd_date", result.getString("upd_date"));
        map.put("lock_user", result.getString("lock_user"));
        map.put("lock_date", result.getString("lock_date"));
        map.put("version", result.getInt("version"));
        map.put("scheme", result.getString("scheme"));
        map.put("annotation", result.getString("annotation"));
        return map;
    }

    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getDefaultOnly, String model, String scenario) throws IxException {
        int modelId = -1;
        if (model != null) {
            modelId = this.getSomeId("model", model);
        }
        int scenarioId = -1;
        if (scenario != null) {
            scenarioId = this.getSomeId("scenario", scenario);
        }
        return this.getModelScenarioList(getDefaultOnly, modelId, scenarioId);
    }

    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getDefaultOnly) throws IxException {
        return this.getModelScenarioList(getDefaultOnly, -1, -1);
    }

    @Override
    public Map<String, Object> getRunInfo(int runId) throws IxException {
        Map<String, Object> run = new HashMap<String, Object>();
        String sql = "SELECT r.id AS run_id, m.id AS model_id, s.id AS scen_id, m.name AS model, s.name AS scenario, CASE WHEN (d.id >= 0) THEN 1 ELSE 0 END AS isDefault, CASE r.status WHEN 0 THEN 1 WHEN 1 THEN 0 END AS isLocked,  r.cre_user, r.cre_date, r.upd_user, r.upd_date, r.lock_user, r.lock_date,  r.version AS version, r.scheme, r.annotation FROM run r left join model m on m.id = r.model_id  left join scenario s on  s.id = r.scen_id LEFT JOIN run_default d ON (d.model_id=m.id and d.SCEN_ID=s.id and d.ID=r.id ) WHERE r.id = ?";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(sql);){
                stmt.setInt(1, runId);
                ResultSet results = stmt.executeQuery();
                if (results.next()) {
                    run = this.getRunResultInfo(results);
                }
                return run;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the run info from the database!", e);
        }
    }

    @Override
    public int getRunId(String model, String scenario) throws IxException {
        return this.getRunId(model, scenario, true);
    }

    @Override
    public int getRunId(String model, String scenario, boolean getMaxAsDefault) throws IxException {
        int retval = -1;
        int modelId = this.getSomeId("MODEL", model);
        int scenarioId = this.getSomeId("SCENARIO", scenario);
        try {
            String qString = "select ID from RUN_DEFAULT where MODEL_ID=? and SCEN_ID=?";
            Connection conn = this.getConn();
            PreparedStatement stmt = conn.prepareStatement(qString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            if (getMaxAsDefault && retval == -1) {
                Object o;
                qString = "select max(id) from run where MODEL_ID=? and SCEN_ID=? and STATUS >=0 ";
                stmt = conn.prepareStatement(qString);
                stmt.setInt(1, modelId);
                stmt.setInt(2, scenarioId);
                results = stmt.executeQuery();
                if (results.next() && (o = results.getObject(1)) != null) {
                    retval = results.getInt(1);
                }
                results.close();
            }
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem getting the run id from the database!", e);
        }
        return retval;
    }

    @Override
    public int getRunId(String model, String scenario, int version) throws IxException {
        int retval = -1;
        int modelId = this.getSomeId("MODEL", model);
        int scenarioId = this.getSomeId("SCENARIO", scenario);
        try {
            String qString = "select id from RUN where MODEL_ID=? and SCEN_ID=? and VERSION=? and STATUS>=0";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.setInt(3, version);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem getting the run id from the database!", e);
        }
        if (retval == -1) {
            throw this.loggedIxException("There exists no Scenario '" + model + "|" + scenario + "' (version: " + version + ")  in the database!", null);
        }
        return retval;
    }

    @Override
    public Map<String, Object> getModelScenarioName(int runId) throws IxException {
        boolean foundDS = false;
        HashMap<String, Object> retval = new HashMap<String, Object>();
        try {
            String qString = "SELECT m.name AS model, s.name AS scenario, r.version AS version, r.annotation AS annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id where r.id=? AND status >=0 ";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                foundDS = true;
                retval.put("model", results.getString("model"));
                retval.put("scenario", results.getString("scenario"));
                retval.put("version", results.getInt("version"));
                retval.put("annotation", results.getString("annotation"));
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem looking for scenarios in the database!", e);
        }
        if (!foundDS) {
            throw this.loggedIxException("There exists no scenario with run id " + runId + " in the database!", null);
        }
        return retval;
    }

    @Override
    public void unassignDefaultVersion(int runId) throws IxException {
        try {
            String dString = "delete from RUN_DEFAULT where ID=?";
            Connection conn = this.getConn();
            PreparedStatement stmt = conn.prepareStatement(dString);
            stmt.setInt(1, runId);
            stmt.executeUpdate();
            stmt.close();
            conn.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem unassigning the default version of a scenario in the database!", e);
        }
    }

    @Override
    public int getStatus(int runId) throws IxException {
        try {
            int retval = -1;
            String qString = "select status from RUN where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt(1);
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem retrieving the status for run id '" + runId + "'!", e);
        }
    }

    public HashMap<String, String> getLockInfo(int runId) throws IxException {
        HashMap<String, String> lockInfo = new HashMap<String, String>();
        String qString = "select LOCK_USER, LOCK_DATE from RUN where ID=" + runId;
        try {
            Statement stmt = this.getConn().createStatement();
            ResultSet result = stmt.executeQuery(qString);
            if (result.next()) {
                lockInfo.put("lockUser", result.getString(1));
                lockInfo.put("lockDate", result.getString(2));
            }
            result.close();
            stmt.close();
            return lockInfo;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem retrieving lock information", e);
        }
    }

    @Override
    public void setStatus(int runId, int status) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.setStatus(user, runId, status);
    }

    @Override
    public void setStatus(String user, int runId, int status) throws IxException {
        try {
            PreparedStatement stmt;
            Connection conn = this.getConn();
            if (status == 1 || status == -1) {
                String uString = "update RUN set STATUS=?, LOCK_USER=Null, LOCK_DATE=Null where ID=?";
                stmt = conn.prepareStatement(uString);
                stmt.setInt(1, status);
                stmt.setInt(2, runId);
            } else if (status == 0) {
                String uString = "update RUN set STATUS=0, LOCK_USER=?, LOCK_DATE=sysdate where ID=?";
                stmt = conn.prepareStatement(uString);
                stmt.setString(1, user);
                stmt.setInt(2, runId);
            } else {
                throw this.loggedIxException("Wrong status " + status + " specified for run " + runId + "!", null);
            }
            stmt.execute();
            stmt.close();
            conn.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem setting the status for run id '" + runId + "'!", e);
        }
    }

    @Override
    public String getScheme(int runId) throws IxException {
        try {
            String retval = null;
            String qString = "select scheme from RUN where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getString(1);
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the scheme for run id '" + runId + "'!", e);
        }
    }

    @Override
    public void cloneItemBlobInDB(int runId, int prevRunId, String type, String name) throws IxException {
        try {
            String cloneString = "update IX_" + type + "_BLOBSTORE set (ele_blob, com_blob) " + "= (select ele_blob, com_blob from IX_" + type + "_BLOBSTORE where runid=? and name=?) " + "where runid=? and name=?";
            PreparedStatement clonePrepStmt = this.getConn().prepareStatement(cloneString);
            clonePrepStmt.setInt(1, prevRunId);
            clonePrepStmt.setString(2, name);
            clonePrepStmt.setInt(3, runId);
            clonePrepStmt.setString(4, name);
            clonePrepStmt.executeUpdate();
            clonePrepStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error copying the blob for item '" + name + "' to the database!", e);
        }
    }

    private void removeItemElementsFromDB(int runId, String name, String type) throws IxException {
        try {
            String dString = "delete from IX_" + type + "_BLOBSTORE where runid=? and name=?";
            PreparedStatement stmt = this.getConn().prepareStatement(dString);
            stmt.setInt(1, runId);
            stmt.setString(2, name);
            int delRc = stmt.executeUpdate();
            logger.debug((Object)("removed " + type + " '" + name + "' from BLOB storage. rc=" + delRc));
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error while removing elements from DB", e);
        }
    }

    @Override
    public void removeItemFromDB(int runId, Set<String> removedItemList, String type) throws IxException {
        try {
            String dimString = "delete from IX_" + type + "_DIM where runid=? and name=?";
            String itemString = "delete from IX_" + type + " where runid=? and name=?";
            Connection conn = this.getConn();
            PreparedStatement prepDimStmt = conn.prepareStatement(dimString);
            PreparedStatement prepItemStmt = conn.prepareStatement(itemString);
            boolean batch = false;
            for (String aItem : removedItemList) {
                this.removeItemElementsFromDB(runId, aItem, type);
                prepDimStmt.setInt(1, runId);
                prepDimStmt.setString(2, aItem);
                prepDimStmt.addBatch();
                prepItemStmt.setInt(1, runId);
                prepItemStmt.setString(2, aItem);
                prepItemStmt.addBatch();
                batch = true;
            }
            if (batch) {
                prepDimStmt.executeBatch();
                prepItemStmt.executeBatch();
            }
            prepDimStmt.close();
            prepItemStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error removing an item from the database!", e);
        }
    }

    @Override
    public void writeAnnotation(int runId, String status, int annotationId, String script, String text) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.writeAnnotation(osUser, runId, status, annotationId, script, text);
    }

    private void writeAnnotation(String user, int runId, String status, int annotationId, String script, String annotation) throws IxException {
        String iString = "insert into ANNOTATION_LOG (annotationid, status, runid, interface, script, cre_user, cre_date, text) values (?,?,?,?,?,?,sysdate,?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.getConn().prepareStatement(iString);
            stmt.setInt(1, annotationId);
            stmt.setString(2, status);
            stmt.setInt(3, runId);
            stmt.setString(4, this.getInterface());
            stmt.setString(5, script);
            stmt.setString(6, user);
            stmt.setString(7, annotation);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Could not write annotation!", e);
        }
    }

    @Override
    public int assignAnnotationId() throws IxException {
        return this.getNextSeq("ANNOTATION");
    }

    abstract int getNextSeq(String var1) throws IxException;

    @Override
    @Deprecated
    public void cleanupById(int pRunid, int pAnnotationId, String pCase, String name) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        Statement stmt = null;
        Connection conn = this.getConn();
        try {
            String aTable;
            int n;
            int n2;
            String[] stringArray;
            stmt = conn.createStatement();
            String status = null;
            LinkedList<String> tables = new LinkedList<String>();
            if (pCase.equals("scenario")) {
                stringArray = this.ixParTables;
                n2 = this.ixParTables.length;
                n = 0;
                while (n < n2) {
                    aTable = stringArray[n];
                    tables.add(aTable);
                    ++n;
                }
                stringArray = this.ixVarTables;
                n2 = this.ixVarTables.length;
                n = 0;
                while (n < n2) {
                    aTable = stringArray[n];
                    tables.add(aTable);
                    ++n;
                }
                stringArray = this.ixSetTables;
                n2 = this.ixSetTables.length;
                n = 0;
                while (n < n2) {
                    aTable = stringArray[n];
                    tables.add(aTable);
                    ++n;
                }
                stringArray = this.ixStructure;
                n2 = this.ixStructure.length;
                n = 0;
                while (n < n2) {
                    aTable = stringArray[n];
                    tables.add(aTable);
                    ++n;
                }
                status = "deleted";
            } else if (pCase.equals("Var")) {
                stringArray = this.ixVarTables;
                n2 = this.ixVarTables.length;
                n = 0;
                while (n < n2) {
                    aTable = stringArray[n];
                    tables.add(aTable);
                    ++n;
                }
                status = "solution imported";
            } else if (pCase.equals("refTS")) {
                status = "deleted";
            }
            for (String table : tables) {
                String dString = "delete from " + table + " where runid=" + pRunid;
                if (name != null) {
                    dString = String.valueOf(dString) + " and name='" + name + "'";
                }
                logger.debug((Object)dString);
                int rc = stmt.executeUpdate(dString);
                logger.info((Object)("table " + table + ": " + rc + " records deleted."));
            }
            String iString = "update ANNOTATION_LOG set STATUS='" + status + " (" + pAnnotationId + ")', UPD_USER='" + osUser + "', UPD_DATE=sysdate" + " where RUNID='" + pRunid + "' and STATUS='ok'";
            stmt.executeUpdate(iString);
            stmt.close();
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            throw this.loggedIxException("The Scenario (runid " + pRunid + ") could not be deleted!'", e);
        }
    }

    @Override
    public List<Map<String, Object>> getAnnotationLog(int runId) throws Exception {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String qString = "SELECT annotationid, status, runid, script, cre_user, cre_date, upd_user, upd_date, text, interface from ANNOTATION_LOG WHERE runid=?";
        PreparedStatement stmt = this.getConn().prepareStatement(qString);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        while (results.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("annotationid", results.getInt("annotationid"));
            row.put("status", results.getString("status"));
            row.put("runid", results.getInt("runid"));
            row.put("script", results.getString("script"));
            row.put("cre_user", results.getString("cre_user"));
            row.put("cre_date", results.getDate("cre_date"));
            row.put("upd_user", results.getString("upd_user"));
            row.put("upd_date", results.getDate("upd_date"));
            row.put("text", results.getString("text"));
            row.put("interface", results.getString("interface"));
            data.add(row);
        }
        results.close();
        stmt.close();
        return data;
    }

    @Override
    public List<Map<String, Object>> getChangeLog(int annotationId) throws Exception {
        try {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            String qString = "SELECT annotationid, runid, operation, item, key, val_prev, val_new, seq from CHANGE_LOG WHERE annotationid=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, annotationId);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("annotationid", results.getInt("annotationid"));
                row.put("runid", results.getInt("runid"));
                row.put("operation", results.getString("operation"));
                row.put("item", results.getString("item"));
                row.put("key", results.getString("key"));
                row.put("val_prev", results.getDouble("val_prev"));
                row.put("val_new", results.getDouble("val_new"));
                row.put("seq", results.getInt("seq"));
                data.add(row);
            }
            results.close();
            stmt.close();
            return data;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error reading the change-log table from the IXMP database!", e);
        }
    }

    @Override
    public Map<Integer, List<Integer>> getIamVariableIdsOfRunIds(List<Integer> runIds) throws IxException {
        HashMap<Integer, List<Integer>> variableIds = new HashMap<Integer, List<Integer>>();
        String sql = "select distinct runid,key from IAMC_TSINFO WHERE runid in (" + this.concatQString(runIds) + ")";
        try {
            PreparedStatement statement = this.getConn().prepareStatement(sql);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                Integer runId = results.getInt("runid");
                Integer variableId = results.getInt("key");
                variableIds.computeIfAbsent(runId, varsOfRun -> new ArrayList()).add(variableId);
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error fetching variable ids of runs " + runIds.toString(), e);
        }
        return variableIds;
    }

    @Override
    public List<IamVariable> getIamVariables(Platform mp, List<Integer> variableIds) throws IxException {
        ArrayList<IamVariable> iamVariables = new ArrayList<IamVariable>();
        String qString = "select keyid, keystring, unitid from IAMC_KEY where keyid in (" + this.concatQString(variableIds) + ")";
        try {
            Statement statement = this.getConn().createStatement();
            ResultSet result = statement.executeQuery(qString);
            while (result.next()) {
                iamVariables.add(new IamVariable(mp, result.getString("keystring"), result.getInt("unitid"), result.getInt("keyid")));
            }
            result.close();
            statement.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error fetching IamVariables from the database!", e);
        }
        return iamVariables;
    }

    @Override
    public IamVariable getIamVariableFromDB(Platform mp, String variable, int unitId, int variableId) throws IxException {
        IamVariable retval = null;
        String qString = "SELECT keyid, keystring, unitid FROM iamc_key ";
        if (variable != null && unitId > -1) {
            qString = String.valueOf(qString) + " WHERE keystring = ? AND unitid = ?";
        } else if (variable != null) {
            qString = String.valueOf(qString) + " WHERE keystring = ?";
        } else if (variableId != -1) {
            qString = String.valueOf(qString) + " WHERE keyid = ?";
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(qString);){
                stmt.setFetchSize(1);
                if (variable != null && unitId > -1) {
                    stmt.setString(1, variable);
                    stmt.setInt(2, unitId);
                } else if (variable != null) {
                    stmt.setString(1, variable);
                } else if (variableId != -1) {
                    stmt.setInt(1, variableId);
                }
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    retval = new IamVariable(mp, rs.getString("keystring"), rs.getInt("unitid"), rs.getInt("keyid"));
                }
                return retval;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error reading an IamVariable from the database!", e);
        }
    }

    IxException loggedIxException(String message, Throwable origin) {
        logger.error((Object)message, origin);
        return new IxException(message);
    }

    @Override
    public int assignIamVariableInDB(String variable, int unitId, String scheme) throws IxException {
        int variableId = this.getNextSeq("IAMC_KEY");
        try {
            String iString = "insert into IAMC_KEY (keyid,keystring,unitid,cre_user,cre_date,scheme) values (?,?,?,?,sysdate,?)";
            PreparedStatement prepStmt = this.getConn().prepareStatement(iString);
            prepStmt.setInt(1, variableId);
            prepStmt.setString(2, variable);
            prepStmt.setInt(3, unitId);
            prepStmt.setString(4, System.getProperty("user.name", "(unknown)"));
            prepStmt.setString(5, scheme);
            prepStmt.executeUpdate();
            prepStmt.close();
            return variableId;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error assigning a new IamVariable in the database!", e);
        }
    }

    @Override
    public Map<Integer, String> getNodeFromDB(String nodeName, int id) throws IxException {
        String error;
        String sql;
        HashMap<Integer, String> retval = new HashMap<Integer, String>();
        if (nodeName != null) {
            sql = "SELECT id, name FROM iamc_nodes WHERE name = ?";
            error = "Error getting the node-id mapping for node '" + nodeName + "' from the database!";
        } else {
            sql = "SELECT id, name FROM iamc_nodes WHERE id = ?";
            error = "Error getting the node-id mapping for id '" + id + "' from the database!";
        }
        Connection conn = this.getConn();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                if (nodeName != null) {
                    stmt.setString(1, nodeName);
                } else {
                    stmt.setInt(1, id);
                }
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    retval.put(rs.getInt(1), rs.getString(2));
                }
                rs.close();
                return retval;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException(error, e);
        }
    }

    @Override
    public Map<String, Integer> getNodeSynonymsFromDB(String node) throws IxException {
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        String sql = "SELECT node_synonym, node_id FROM iamc_nodes_synonym WHERE node_synonym = ?";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(sql);){
                stmt.setString(1, node);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    retval.put(rs.getString(1), rs.getInt(2));
                }
                rs.close();
                return retval;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error getting the node-id synonym mapping for node '" + node + "' from the database!", e);
        }
    }

    private Integer getNodeIdByName(Connection conn, String name) throws IxException {
        PreparedStatement stmt;
        block15: {
            Integer n;
            block16: {
                String sql = "SELECT id FROM iamc_nodes WHERE name = ?";
                Throwable throwable = null;
                Object var5_7 = null;
                stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, name);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) break block15;
                    n = rs.getInt(1);
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw this.loggedIxException("Cannot find node with name " + name, e);
                        }
                    }
                }
                stmt.close();
            }
            return n;
        }
        if (stmt != null) {
            stmt.close();
        }
        return null;
    }

    @Override
    public Map<Integer, String> saveNode(String nodeName, String parent, String hierarchy) throws IxException {
        Integer nodeId;
        block23: {
            Connection conn = this.getConn();
            nodeId = this.getNodeIdByName(conn, nodeName);
            if (nodeId != null) {
                String update = "UPDATE iamc_nodes SET hierarchy = ?, \t   name = ?,    parent = ? WHERE id = ?";
                try {
                    Throwable throwable = null;
                    Object var8_14 = null;
                    try (PreparedStatement stmt = conn.prepareStatement(update);){
                        stmt.setString(1, hierarchy);
                        stmt.setString(2, nodeName);
                        stmt.setString(3, parent);
                        stmt.setInt(4, nodeId);
                        stmt.executeUpdate();
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot add node with name " + nodeName, e);
                }
            }
            String insert = "INSERT INTO iamc_nodes(id, hierarchy, name, parent) VALUES (?, ?, ?, ?)";
            nodeId = this.getNextSeq("iamc_nodes");
            try {
                Throwable e = null;
                Object var8_16 = null;
                try (PreparedStatement stmt = conn.prepareStatement(insert);){
                    stmt.setInt(1, nodeId);
                    stmt.setString(2, hierarchy);
                    stmt.setString(3, nodeName);
                    stmt.setString(4, parent);
                    stmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                throw this.loggedIxException("Cannot add node with name " + nodeName, e);
            }
        }
        return Collections.singletonMap(nodeId, nodeName);
    }

    @Override
    public Map<String, Integer> saveNodeSynonym(String nodeName, String synonym) throws IxException {
        Connection conn = this.getConn();
        Integer nodeId = this.getNodeIdByName(conn, nodeName);
        if (nodeId != null) {
            Integer updated;
            Throwable throwable;
            String update = "UPDATE iamc_nodes_synonym SET node_id = ? WHERE node_synonym = ?";
            try {
                Throwable throwable2 = null;
                throwable = null;
                try (PreparedStatement updateStmt = conn.prepareStatement(update);){
                    updateStmt.setInt(1, nodeId);
                    updateStmt.setString(2, synonym);
                    updated = updateStmt.executeUpdate();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw this.loggedIxException("Cannot add node synonym with name " + nodeName, e);
            }
            if (updated == 0) {
                String insert = "INSERT INTO iamc_nodes_synonym(node_id, node_synonym) VALUES (?, ?)";
                try {
                    throwable = null;
                    Object var9_13 = null;
                    try (PreparedStatement insertStmt = conn.prepareStatement(insert);){
                        insertStmt.setInt(1, nodeId);
                        insertStmt.setString(2, synonym);
                        insertStmt.executeUpdate();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot add node synonym with name " + nodeName, e);
                }
            }
            return Collections.singletonMap(synonym, nodeId);
        }
        throw new IxException("Cannot find node with name " + nodeName);
    }

    @Override
    public int addUnitToDB(String unit, String scheme) throws IxException {
        int retval = this.getNextSeq("UNIT");
        try {
            String iString = "insert into IX_UNIT (id,name,cre_user,cre_date,scheme) values (?,?,?,sysdate,?)";
            Connection conn = this.getConn();
            PreparedStatement prepStmt = conn.prepareStatement(iString);
            prepStmt.setInt(1, retval);
            prepStmt.setString(2, unit);
            prepStmt.setString(3, System.getProperty("user.name", "(unknown)"));
            prepStmt.setString(4, scheme);
            prepStmt.executeUpdate();
            prepStmt.close();
            conn.commit();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error assigning an unit-key-id mapping in the database!", e);
        }
    }

    @Override
    public Map<Integer, String> getUnitFromDB(String unit, int id) throws IxException {
        HashMap<Integer, String> retval = new HashMap<Integer, String>();
        PreparedStatement prepStmt = null;
        String error = null;
        try {
            String qString = "select id, name from IX_UNIT";
            Connection conn = this.getConn();
            if (unit != null) {
                qString = String.valueOf(qString) + " where name=?";
                prepStmt = conn.prepareStatement(qString);
                prepStmt.setString(1, this.cleanString(unit));
                error = "error getting the unit-id mapping for unit '" + unit + "' from the database!";
            } else if (id > -1) {
                qString = String.valueOf(qString) + " where id=?";
                prepStmt = conn.prepareStatement(qString);
                prepStmt.setInt(1, id);
                error = "error getting the unit-id mapping for id '" + id + "' from the database!";
            } else {
                prepStmt = conn.prepareStatement(qString);
                error = "error loading all units from the database!";
            }
            ResultSet aRs = prepStmt.executeQuery();
            while (aRs.next()) {
                int unitId = aRs.getInt(1);
                String unitString = aRs.getString(2);
                retval.put(unitId, unitString);
            }
            aRs.close();
            prepStmt.close();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException(error, e);
        }
    }

    private String cleanString(String text) {
        return text.replaceAll("'", "''");
    }

    private <T> String concatQString(List<T> pList) {
        return pList.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    @Override
    public void cloneTimeseriesInDB(int runId, int prevRunId, boolean isMeta, Integer firstYear) throws IxException {
        try {
            String queryInfo = "select tsid, node, key, meta, time from IAMC_TSINFO where runid=? and meta=?";
            String cloneInfo = "insert into IAMC_TSINFO (runid, tsid, node, key, meta, time) select ?, ?, node, key, meta, time from IAMC_TSINFO where tsid=?";
            String cloneData = "insert into IAMC_TSDATA (tsid, year, value) select ?, year, value from IAMC_TSDATA where tsid=?";
            boolean batchData = false;
            boolean isSlice = false;
            if (firstYear != null && firstYear > 0) {
                isSlice = true;
            }
            if (isSlice) {
                cloneData = String.valueOf(cloneData) + " and year<?";
            }
            Connection conn = this.getConn();
            PreparedStatement qInfoStmt = conn.prepareStatement(queryInfo);
            PreparedStatement cInfoStmt = conn.prepareStatement(cloneInfo);
            PreparedStatement cDataStmt = conn.prepareStatement(cloneData);
            qInfoStmt.setInt(1, prevRunId);
            int meta = 0;
            if (isMeta) {
                meta = 1;
            }
            qInfoStmt.setInt(2, meta);
            ResultSet aRs = qInfoStmt.executeQuery();
            while (aRs.next()) {
                int prevTsId = aRs.getInt("tsid");
                int newTsId = this.getNextSeq("IAMC_TS");
                cInfoStmt.setInt(1, runId);
                cInfoStmt.setInt(2, newTsId);
                cInfoStmt.setInt(3, prevTsId);
                cInfoStmt.addBatch();
                cDataStmt.setInt(1, newTsId);
                cDataStmt.setInt(2, prevTsId);
                if (isSlice) {
                    cDataStmt.setInt(3, firstYear);
                }
                cDataStmt.addBatch();
                batchData = true;
            }
            aRs.close();
            qInfoStmt.close();
            if (batchData) {
                cInfoStmt.executeBatch();
                cDataStmt.executeBatch();
            }
            cInfoStmt.close();
            cDataStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error cloning timeseries data in the database!", e);
        }
    }

    @Override
    public int getVersion(int runId) throws IxException {
        int retval = -1;
        try {
            String qString = "select VERSION from RUN where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem getting the version number from the database!", e);
        }
        if (retval == -1) {
            throw this.loggedIxException("There exists no Scenario with run id " + runId + " in the database!", null);
        }
        return retval;
    }

    @Override
    public int getLastVersion(int modelId, int scenarioId) throws IxException {
        int retval = -1;
        try {
            String qString = "select MAX(VERSION) from RUN where MODEL_ID=? and SCEN_ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem getting the last version number from the database!", e);
        }
        if (retval == -1) {
            throw this.loggedIxException("There exists no scenario for this model/scenario id's in the database!", null);
        }
        return retval;
    }

    private int assignSomeId(String table, String name) throws IxException {
        int retval = -1;
        try {
            String qString = "select id from " + table + " where name=?";
            Connection conn = this.getConn();
            PreparedStatement stmt = conn.prepareStatement(qString);
            stmt.setString(1, name);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt(1);
            } else {
                retval = this.getNextSeq(table);
                String iString = "insert into " + table + " (id,name) values (?,?)";
                stmt = conn.prepareStatement(iString);
                stmt.setInt(1, retval);
                stmt.setString(2, name);
                stmt.executeUpdate();
                stmt.close();
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem assigning '" + name + "' in table '" + table + "' in the database!", e);
        }
    }

    public int assignRunId(String user, String model, String scenario, String scheme, String annotation) throws IxException {
        int modelId = this.assignSomeId("MODEL", model);
        int scenarioId = this.assignSomeId("SCENARIO", scenario);
        int nextVersion = this.getLastVersion(modelId, scenarioId);
        ++nextVersion;
        int runId = this.getNextSeq("RUN");
        try {
            String pString = "insert into RUN (id, model_id, scen_id, version, scheme, annotation, cre_user, cre_date) values (?,?,?,?,?,?,?,sysdate)";
            Connection conn = this.getConn();
            PreparedStatement stmt = conn.prepareStatement(pString);
            stmt.setInt(1, runId);
            stmt.setInt(2, modelId);
            stmt.setInt(3, scenarioId);
            stmt.setInt(4, nextVersion);
            if (scheme != null) {
                stmt.setString(5, scheme);
            } else {
                stmt.setNull(5, 12);
            }
            if (annotation != null) {
                stmt.setString(6, annotation);
            } else {
                stmt.setNull(6, 12);
            }
            stmt.setString(7, user);
            stmt.executeUpdate();
            stmt.close();
            conn.commit();
            return runId;
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem assigning a new run id in the database!", e);
        }
    }

    @Override
    public void saveIdxSetToDB(int runId, Collection<IndexSet> collection) throws IxException {
        String selectString = "select runid, name from IX_IDXSET where runid=? and name =?";
        String asteriskString = "insert into IX_IDXSET (runid, name, itemid) values (?,?,?)";
        String insertString = "insert into IX_IDXSET (ele_blob, runid, name, itemid) values (?,?,?,?)";
        String updateString = "update IX_IDXSET set ele_blob=? where runid=? and name=?";
        Connection conn = this.getConn();
        try {
            PreparedStatement selectPrepStmt = conn.prepareStatement(selectString);
            selectPrepStmt.setInt(1, runId);
            selectPrepStmt.setString(2, "*");
            ResultSet aRs = selectPrepStmt.executeQuery();
            if (!aRs.next()) {
                PreparedStatement asteriskPrepStmt = conn.prepareStatement(asteriskString);
                asteriskPrepStmt.setInt(1, runId);
                asteriskPrepStmt.setString(2, "*");
                asteriskPrepStmt.setInt(3, -1);
                asteriskPrepStmt.executeUpdate();
                asteriskPrepStmt.close();
            }
            aRs.close();
            selectPrepStmt.close();
        }
        catch (Exception e) {
            String error = "Error saving the '*' index set!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        for (IndexSet aSet : collection) {
            String name = aSet.getName();
            try {
                PreparedStatement selectPrepStmt = conn.prepareStatement(selectString);
                selectPrepStmt.setInt(1, runId);
                selectPrepStmt.setString(2, name);
                ResultSet aRs = selectPrepStmt.executeQuery();
                boolean doUpdate = false;
                while (aRs.next()) {
                    doUpdate = true;
                }
                aRs.close();
                selectPrepStmt.close();
                int updateRc = -1;
                boolean doBlobNull = true;
                ByteArrayInputStream bais = null;
                int blobLength = 0;
                LinkedList<Element> aBlob = aSet.getEleBlobForDB();
                if (!aBlob.isEmpty()) {
                    doBlobNull = false;
                    byte[] itemAsBytes = this.writeInputStream(aBlob, name);
                    bais = new ByteArrayInputStream(itemAsBytes);
                    blobLength = itemAsBytes.length;
                }
                if (doUpdate) {
                    PreparedStatement updatePrepStmt = conn.prepareStatement(updateString);
                    if (doBlobNull) {
                        updatePrepStmt.setNull(1, 2004);
                    } else {
                        updatePrepStmt.setBinaryStream(1, (InputStream)bais, blobLength);
                    }
                    updatePrepStmt.setInt(2, runId);
                    updatePrepStmt.setString(3, name);
                    updateRc = updatePrepStmt.executeUpdate();
                    logger.debug((Object)("update set '" + name + "' rc=" + updateRc + " size=" + blobLength));
                    updatePrepStmt.close();
                }
                if (updateRc == 1) continue;
                PreparedStatement insertPrepStmt = conn.prepareStatement(insertString);
                if (doBlobNull) {
                    insertPrepStmt.setNull(1, 2004);
                } else {
                    insertPrepStmt.setBinaryStream(1, (InputStream)bais, blobLength);
                }
                insertPrepStmt.setInt(2, runId);
                insertPrepStmt.setString(3, name);
                insertPrepStmt.setInt(4, aSet.getItemId());
                int insertRc = insertPrepStmt.executeUpdate();
                logger.debug((Object)("insert set '" + name + "' rc=" + insertRc + " size=" + blobLength));
                insertPrepStmt.close();
            }
            catch (Exception e) {
                throw this.loggedIxException("Error saving an item-blob to database!", e);
            }
        }
    }

    private byte[] writeInputStream(Object blob, String name) throws IxException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
            oos.writeObject(blob);
            oos.flush();
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error creating a byte-array from a blob for item '" + name + "'!", e);
        }
    }

    @Override
    public void getIndexSets(Scenario scen, int runId) throws IxException {
        try {
            String qString = "select name, itemid, ele_blob from IX_IDXSET where runid=? and itemid>-1 order by itemid";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                String name = results.getString(1);
                int itemId = results.getInt(2);
                Object aObject = null;
                List aBlob = null;
                Blob blob = results.getBlob(3);
                if (blob != null) {
                    try {
                        try {
                            ObjectInputStream oip;
                            try {
                                oip = new ObjectInputStream(new GZIPInputStream(blob.getBinaryStream()));
                            }
                            catch (ZipException ze) {
                                oip = new ObjectInputStream(blob.getBinaryStream());
                            }
                            try {
                                aObject = oip.readObject();
                            }
                            finally {
                                oip.close();
                            }
                        }
                        catch (Exception e) {
                            throw this.loggedIxException("There was a problem reading a blob from the database", e);
                        }
                    }
                    finally {
                        blob.free();
                    }
                }
                if (aObject != null) {
                    aBlob = ((List)aObject).stream().map(elt -> elt).collect(Collectors.toList());
                }
                new IndexSet(scen, name, itemId, aBlob);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error getting index sets", null);
        }
    }

    @Override
    public void getItemList(Scenario scen, int runId, String type) throws IxException {
        this.initItems(scen, runId, type);
        this.setScenarioDims(scen, runId, type);
    }

    private void setScenarioDims(Scenario scen, int runId, String type) throws IxException {
        String qString = "select name, idx, idx_set, idx_name from IX_" + type + "_DIM where runid=? order by name, idx";
        try {
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            Item aItem = null;
            String name = "";
            while (results.next()) {
                if (!name.equals(results.getString(1))) {
                    name = results.getString(1);
                    aItem = scen.getItem(name);
                }
                int idx = results.getInt(2);
                String idxSet = results.getString(3);
                String idxName = results.getString(4);
                aItem.setIXitemDimsFromDB(idx, idxSet, idxName);
            }
            results.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Failed to set scenario dims", e);
        }
    }

    private void initItems(Scenario scen, int runId, String type) throws IxException {
        String qString = "select name, itemid, dim from IX_" + type + " where runid=? order by itemid";
        try {
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                String name = results.getString(1);
                int itemId = results.getInt(2);
                int dim = results.getInt(3);
                switch (type) {
                    case "SET": {
                        new at.ac.iiasa.ixmp.objects.Set(scen, name, itemId, dim);
                        break;
                    }
                    case "PAR": {
                        new Parameter(scen, name, itemId, dim);
                        break;
                    }
                    case "VAR": {
                        new Variable(scen, name, itemId, dim);
                        break;
                    }
                    case "EQU": {
                        new Equation(scen, name, itemId, dim);
                    }
                }
            }
            results.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Failed to initialize scenario items", e);
        }
    }

    @Override
    public boolean isDefaultVersion(int runId) throws IxException {
        boolean retval = false;
        try {
            String qString = "select ID from RUN_DEFAULT where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = true;
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem checking for the default version!", e);
        }
    }

    @Override
    public void setDefaultVersion(String model, String scenario, int runId) throws IxException {
        int modelId = this.getSomeId("MODEL", model);
        int scenarioId = this.getSomeId("SCENARIO", scenario);
        try {
            String dString = "delete from RUN_DEFAULT where MODEL_ID=? and SCEN_ID=?";
            Connection conn = this.getConn();
            PreparedStatement stmt = conn.prepareStatement("delete from RUN_DEFAULT where MODEL_ID=? and SCEN_ID=?");
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.executeUpdate();
            stmt.close();
            String iString = "insert into RUN_DEFAULT (model_id, scen_id, id) values (?,?,?)";
            stmt = conn.prepareStatement("insert into RUN_DEFAULT (model_id, scen_id, id) values (?,?,?)");
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.setInt(3, runId);
            stmt.executeUpdate();
            stmt.close();
            conn.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem setting the default version of a scenario in the database!", e);
        }
    }

    @Override
    public void saveSeqItemId(int runId, int seqItemId) throws IxException {
        try {
            String uString = "update RUN set SEQ_ITEM_ID=? where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(uString);
            stmt.setInt(1, seqItemId);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem saving the item sequence counter in the database!", e);
        }
    }

    @Override
    public int getSeqItemId(int runId) throws IxException {
        int retval = -1;
        try {
            String qString = "select SEQ_ITEM_ID from RUN where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt("SEQ_ITEM_ID");
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem loading the item sequence counter from the database!", e);
        }
    }

    @Override
    public void setUpdUserDate(int runId) throws IxException {
        try {
            String user = System.getProperty("user.name", "(unknown)");
            String uString = "update RUN set UPD_USER=?, UPD_DATE=sysdate where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(uString);
            stmt.setString(1, user);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem setting the user/timestamp for the update in the database!", e);
        }
    }

    @Override
    public Timestamp getLastUpdTimestamp(int runId) throws IxException {
        Timestamp retval = null;
        try {
            String qString = "select UPD_DATE, CRE_DATE from RUN where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                if (aRs.getTimestamp("UPD_DATE") != null) {
                    retval = aRs.getTimestamp("UPD_DATE");
                } else if (aRs.getTimestamp("CRE_DATE") != null) {
                    retval = aRs.getTimestamp("CRE_DATE");
                }
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the last-update timestamp for run id '" + runId + "'!", e);
        }
    }

    @Override
    public void setRunidAnnotation(int runId, String annotation) throws IxException {
        try {
            String pString = "update RUN set ANNOTATION=? where ID=?";
            PreparedStatement stmt = this.getConn().prepareStatement(pString);
            stmt.setString(1, annotation);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem updating the annotation for run id '" + runId + "'!", e);
        }
    }

    @Override
    public void createSetInDB(int runId, Collection<at.ac.iiasa.ixmp.objects.Set> setList) throws IxException {
        this.createItemInDB(runId, new LinkedHashSet<Item>(setList), "SET");
    }

    @Override
    public void createParInDB(int runId, Collection<Parameter> parList) throws IxException {
        this.createItemInDB(runId, new LinkedHashSet<Item>(parList), "PAR");
    }

    @Override
    public void createVarInDB(int runId, Collection<Variable> varList) throws IxException {
        this.createItemInDB(runId, new LinkedHashSet<Item>(varList), "VAR");
    }

    @Override
    public void createEquInDB(int runId, Collection<Equation> equList) throws IxException {
        this.createItemInDB(runId, new LinkedHashSet<Item>(equList), "EQU");
    }

    @Override
    public void createItemInDB(int runId, Set<Item> itemList, String type) throws IxException {
        String name = null;
        String itemString = "insert into IX_" + type + " (runid, name, dim, itemid) values (?,?,?,?)";
        String dimString = "insert into IX_" + type + "_DIM (runid, name, idx, idx_set, idx_name) values (?,?,?,?,?)";
        String blobString = "insert into IX_" + type + "_BLOBSTORE (runid, name) values (?,?)";
        try {
            Connection conn = this.getConn();
            PreparedStatement prepDimStmt = conn.prepareStatement(dimString);
            PreparedStatement prepItemStmt = conn.prepareStatement(itemString);
            PreparedStatement prepBlobStmt = conn.prepareStatement(blobString);
            boolean batch = false;
            boolean dimBatch = false;
            for (Item aItem : itemList) {
                name = aItem.getName();
                prepItemStmt.setInt(1, runId);
                prepItemStmt.setString(2, name);
                prepItemStmt.setInt(3, aItem.getDim());
                prepItemStmt.setInt(4, aItem.getItemId());
                prepItemStmt.addBatch();
                batch = true;
                LinkedList<String> idxSets = aItem.getIdxSets();
                LinkedList<String> idxNames = aItem.getIdxNames();
                int idx = 0;
                while (idx < aItem.getDim()) {
                    prepDimStmt.setInt(1, runId);
                    prepDimStmt.setString(2, name);
                    prepDimStmt.setInt(3, idx);
                    prepDimStmt.setString(4, (String)idxSets.get(idx));
                    prepDimStmt.setString(5, (String)idxNames.get(idx));
                    prepDimStmt.addBatch();
                    dimBatch = true;
                    ++idx;
                }
                prepBlobStmt.setInt(1, runId);
                prepBlobStmt.setString(2, aItem.getName());
                prepBlobStmt.addBatch();
            }
            if (batch) {
                prepItemStmt.executeBatch();
            }
            prepItemStmt.close();
            if (dimBatch) {
                prepDimStmt.executeBatch();
            }
            prepDimStmt.close();
            if (batch) {
                prepBlobStmt.executeBatch();
            }
            prepBlobStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error creating the " + type + " '" + name + "' in the database!", e);
        }
    }

    @Override
    public void saveItemElementsToDB(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        LinkedList<Element> aBlob = item.getEleBlobForDB();
        ByteArrayInputStream bais = null;
        int blobLength = -1;
        if (!aBlob.isEmpty()) {
            byte[] itemAsBytes = this.writeInputStream(aBlob, name);
            bais = new ByteArrayInputStream(itemAsBytes);
            blobLength = itemAsBytes.length;
        }
        this.saveBlobToDB(runId, name, type, "ele", blobLength, bais);
        item.hasUpdatedElement = false;
    }

    @Override
    public void saveItemCommentsToDB(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        ByteArrayInputStream bais = null;
        int blobLength = -1;
        Map<Integer, List<Integer>> aMap = item.getCommentMapForDB();
        if (!aMap.isEmpty()) {
            byte[] itemAsBytes = this.writeInputStream(aMap, name);
            bais = new ByteArrayInputStream(itemAsBytes);
            blobLength = itemAsBytes.length;
        }
        this.saveBlobToDB(runId, name, type, "com", blobLength, bais);
        item.hasUpdatedComment = false;
    }

    private void saveBlobToDB(int runId, String name, String type, String col, int blobLength, ByteArrayInputStream bais) throws IxException {
        try {
            String updateString = "update IX_" + type + "_BLOBSTORE set " + col + "_blob=? where runid=? and name=?";
            PreparedStatement updatePrepStmt = this.getConn().prepareStatement(updateString);
            if (blobLength == -1) {
                updatePrepStmt.setNull(1, 2004);
            } else {
                updatePrepStmt.setBinaryStream(1, (InputStream)bais, blobLength);
            }
            updatePrepStmt.setInt(2, runId);
            updatePrepStmt.setString(3, name);
            int updateRc = updatePrepStmt.executeUpdate();
            logger.debug((Object)("update " + type + " " + name + " rc=" + updateRc + " size=" + blobLength));
            updatePrepStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error saving the " + type + " blob for item '" + name + "' to the database!", e);
        }
    }

    @Override
    public boolean hasItemElementsInBlob(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        return this.hasItemBlob(runId, name, type, "ele");
    }

    private boolean hasItemBlob(int runId, String name, String type, String col) throws IxException {
        boolean retval = false;
        try {
            String qString = "SELECT " + col + "_blob " + "FROM ix_" + type + "_blobstore " + "WHERE runid=? " + "AND name = ? " + "AND " + col + "_blob IS NOT NULL";
            PreparedStatement qStmt = this.getConn().prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setString(2, name);
            ResultSet results = qStmt.executeQuery();
            if (results.next()) {
                retval = true;
            }
            results.close();
            qStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem checking for a blob of item " + name + " in the database!", e);
        }
        return retval;
    }

    @Override
    public void getItemElementsFromDB(int runId, Item item) throws IxException {
        logger.debug((Object)("loading elements for " + item.getTypeName() + " from database..."));
        Object aObject = this.getBlobFromDB(runId, item, "ele");
        if (aObject instanceof List) {
            List<Object> aBlob = ((List)aObject).stream().map(elt -> elt).collect(Collectors.toList());
            item.setElementListFromDB(aBlob);
        }
    }

    @Override
    public Map<Integer, List<Integer>> getItemCommentsFromDB(int runId, Item item) throws IxException {
        logger.debug((Object)("loading comments for " + item.getTypeName() + " from database..."));
        Object aObject = this.getBlobFromDB(runId, item, "com");
        return (Map)aObject;
    }

    protected Object getBlobFromDB(int runId, Item item, String col) throws IxException {
        Object aObject = null;
        try {
            String type = item.getTypeForDB();
            String name = item.getName();
            String qString = "select " + col + "_blob from ix_" + type + "_blobstore where runid=? and name=?";
            PreparedStatement qStmt = this.getConn().prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setString(2, name);
            ResultSet aRs = qStmt.executeQuery();
            while (aRs.next()) {
                Blob blob = aRs.getBlob(1);
                if (blob == null) continue;
                try {
                    try {
                        ObjectInputStream oip;
                        try {
                            oip = new ObjectInputStream(new GZIPInputStream(blob.getBinaryStream()));
                        }
                        catch (ZipException ze) {
                            oip = new ObjectInputStream(blob.getBinaryStream());
                        }
                        try {
                            aObject = oip.readObject();
                        }
                        finally {
                            oip.close();
                        }
                    }
                    catch (Exception e) {
                        throw this.loggedIxException("There was a problem reading the blob of " + item.getTypeName() + " from the database!", e);
                    }
                }
                finally {
                    blob.free();
                }
            }
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("There was a problem loading elements of " + item.getTypeName() + " from the database!", e);
        }
        return aObject;
    }

    @Override
    public void createKeysInDB(int runId, Map<Integer, String> idKeyMap) throws IxException {
        String iString = "insert into IX_KEY (runid, keyid, key) values (?,?,?)";
        try {
            PreparedStatement stmt = this.getConn().prepareStatement(iString);
            boolean batch = false;
            for (Map.Entry<Integer, String> entry : idKeyMap.entrySet()) {
                stmt.setInt(1, runId);
                stmt.setInt(2, entry.getKey());
                stmt.setString(3, entry.getValue());
                stmt.addBatch();
                batch = true;
            }
            if (batch) {
                stmt.executeBatch();
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot create keys in DB!", e);
        }
    }

    @Override
    public int getKeyIdList(int runId, Scenario scen) throws IxException {
        int nextId = 0;
        String qString = "select keyid, key from IX_KEY where runid=? order by keyid";
        try {
            PreparedStatement stmt = this.getConn().prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                int keyId = results.getInt(1);
                String keyString = results.getString(2);
                scen.addKeyFromDB(keyId, keyString);
                nextId = keyId;
            }
            results.close();
            stmt.close();
            return nextId;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get key id list!", e);
        }
    }

    @Override
    public void saveCommentsInDB(int runId, Map<Integer, String> idCommentMap) throws IxException {
        if (idCommentMap.isEmpty()) {
            return;
        }
        String iString = "insert into IX_COMMENT (runid, comid, comstring) values (?,?,?)";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(iString);){
                for (Map.Entry<Integer, String> entry : idCommentMap.entrySet()) {
                    stmt.setInt(1, runId);
                    stmt.setInt(2, entry.getKey());
                    stmt.setString(3, entry.getValue());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot save comments in DB!", e);
        }
    }

    @Override
    public int getCommentIdList(int runId, Scenario scenario) throws IxException {
        int nextId = 0;
        String qString = "select comid, comstring from IX_COMMENT where runid=? order by comid";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement stmt = this.getConn().prepareStatement(qString);){
                stmt.setInt(1, runId);
                ResultSet results = stmt.executeQuery();
                while (results.next()) {
                    int comId = results.getInt(1);
                    String keyString = results.getString(2);
                    scenario.addCommentFromDB(comId, keyString);
                    nextId = comId;
                }
                results.close();
                return nextId;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot save comments in DB!", e);
        }
    }

    @Override
    public void updateTimeseriesInDB(int pRunId, Map<List<Integer>, Integer> tsInfo, Map<List<Integer>, Map<Integer, Double>> tsList) throws IxException {
        try {
            String iStringInfo = "insert into IAMC_TSINFO (tsid, runid, node, key, meta, time) values (?,?,?,?,?,?)";
            String iStringData = "update IAMC_TSDATA set value=? where tsid=? and year=?";
            Connection conn = this.getConn();
            PreparedStatement infoStmt = conn.prepareStatement(iStringInfo);
            PreparedStatement dataStmt = conn.prepareStatement(iStringData);
            boolean batchInfo = false;
            boolean batchData = false;
            for (Map.Entry<List<Integer>, Map<Integer, Double>> aTs : tsList.entrySet()) {
                int tsId = -1;
                try {
                    tsId = tsInfo.get(aTs.getKey());
                }
                catch (Exception e) {
                    tsId = this.getNextSeq("IAMC_TS");
                    infoStmt.setInt(1, tsId);
                    infoStmt.setInt(2, pRunId);
                    infoStmt.setInt(3, aTs.getKey().get(0));
                    infoStmt.setInt(4, aTs.getKey().get(1));
                    infoStmt.setInt(5, aTs.getKey().get(2));
                    if (aTs.getKey().size() > 3) {
                        infoStmt.setInt(6, aTs.getKey().get(3));
                    } else {
                        infoStmt.setInt(6, -1);
                    }
                    infoStmt.addBatch();
                    batchInfo = true;
                    tsInfo.put(aTs.getKey(), tsId);
                }
                for (Map.Entry<Integer, Double> data : aTs.getValue().entrySet()) {
                    dataStmt.setDouble(1, data.getValue());
                    dataStmt.setInt(2, tsId);
                    dataStmt.setInt(3, data.getKey());
                    dataStmt.addBatch();
                    batchData = true;
                }
            }
            if (batchInfo) {
                infoStmt.executeBatch();
            }
            infoStmt.close();
            if (batchData) {
                dataStmt.executeBatch();
            }
            dataStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error writing the timeseries data to the IXMP database!", e);
        }
    }

    @Override
    public Map<List<Integer>, Integer> getTsInfoFromDB(Integer runId) throws IxException {
        HashMap<List<Integer>, Integer> tsInfo = new HashMap<List<Integer>, Integer>();
        try {
            String qString = "select node, key, meta, time, tsid from IAMC_TSINFO where runid=?";
            PreparedStatement qStmt = this.getConn().prepareStatement(qString);
            qStmt.setInt(1, runId);
            ResultSet aRs = qStmt.executeQuery();
            while (aRs.next()) {
                tsInfo.put(this.getVecNdId(aRs.getInt("node"), aRs.getInt("key"), aRs.getInt("meta"), aRs.getInt("time")), aRs.getInt("tsid"));
            }
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error loading existing timeseries-info entries from database!", e);
        }
        return tsInfo;
    }

    @Override
    public List<Integer> getVecNdId(int pNode, int pKey, int pMeta, int pTime) {
        Vector<Integer> vecNdId = new Vector<Integer>();
        vecNdId.add(pNode);
        vecNdId.add(pKey);
        vecNdId.add(pMeta);
        if (pTime != -1) {
            vecNdId.add(pTime);
        }
        return vecNdId;
    }

    @Override
    public List<Integer> getVariableUnitKeys(List<String> variableNames, List<Integer> unitIds) throws IxException {
        LinkedList<Integer> keyIds = new LinkedList<Integer>();
        String sql = "SELECT keyid FROM iamc_key WHERE 1=1 ";
        if (!DBUtils.isEmpty(unitIds)) {
            sql = String.valueOf(sql) + "AND unitid in (" + Stream.generate(() -> "?").limit(unitIds.size()).collect(Collectors.joining(",")) + ") ";
        }
        if (!DBUtils.isEmpty(variableNames)) {
            sql = String.valueOf(sql) + "AND keystring in (" + Stream.generate(() -> "?").limit(variableNames.size()).collect(Collectors.joining(",")) + ")";
        }
        try {
            PreparedStatement statement = this.getConn().prepareStatement(sql);
            int index = 1;
            if (!DBUtils.isEmpty(unitIds)) {
                for (Integer unitId : unitIds) {
                    statement.setInt(index, unitId);
                    ++index;
                }
            }
            if (!DBUtils.isEmpty(variableNames)) {
                for (String variableName : variableNames) {
                    statement.setString(index, variableName);
                    ++index;
                }
            }
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keyIds.add(resultSet.getInt("keyid"));
            }
        }
        catch (Exception e) {
            throw this.loggedIxException("error fetching keys of variable-units (table IAMC_KEY)", e);
        }
        return keyIds;
    }

    @Override
    public void addToTimeseriesList(Map<List<Integer>, Map<Integer, Double>> tsMap, Integer runId, Integer keyId) throws IxException {
        try {
            int meta;
            int time;
            int node;
            String qString = "select i.node, i.time, i.meta, d.year, d.value  from iamc_tsinfo i inner join iamc_tsdata d on (i.tsid = d.tsid) where i.runid=? and i.key=? order by node, key, time, year";
            PreparedStatement qStmt = this.getConn().prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setInt(2, keyId);
            ResultSet aRs = qStmt.executeQuery();
            List<Object> vecNdId = new Vector();
            LinkedHashMap<Integer, Double> data = new LinkedHashMap<Integer, Double>();
            int prevNode = -1;
            int prevMeta = -1;
            int prevTime = -1;
            if (aRs.isFirst()) {
                node = aRs.getInt("node");
                time = aRs.getInt("time");
                meta = aRs.getInt("meta");
                vecNdId = this.getVecNdId(node, keyId, meta, time);
                data.put(aRs.getInt("year"), aRs.getDouble("value"));
                prevNode = node;
                prevMeta = meta;
                prevTime = time;
                aRs.next();
            }
            while (aRs.next()) {
                node = aRs.getInt("node");
                time = aRs.getInt("time");
                meta = aRs.getInt("meta");
                if (node != prevNode || meta != prevMeta || time != prevTime) {
                    tsMap.put(vecNdId, data);
                    vecNdId = this.getVecNdId(node, keyId, meta, time);
                    data = new LinkedHashMap();
                    prevNode = node;
                    prevTime = time;
                }
                data.put(aRs.getInt("year"), aRs.getDouble("value"));
            }
            tsMap.put(vecNdId, data);
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error loading existing timeseries-data entries from database!", e);
        }
    }

    @Override
    public List<Map<String, Object>> getTimeseriesFromDB(Platform mp, List<Integer> runIdList, List<Integer> nodeList, List<Integer> keyList, List<Integer> timeList, List<Integer> yearList) throws IxException {
        HashMap<Integer, Map<String, Object>> runidMap = new HashMap<Integer, Map<String, Object>>();
        for (int runid : runIdList) {
            runidMap.put(runid, this.getModelScenarioName(runid));
        }
        int prevRunid = -1;
        String model = null;
        String scenario = null;
        int version = -1;
        ArrayList<Map<String, Object>> timeseries = new ArrayList<Map<String, Object>>();
        String qString = " select i.runid, i.node, i.key, i.time, d.year, d.value  from iamc_tsinfo i  inner join iamc_tsdata d on (i.tsid = d.tsid)  where runid in (" + this.concatQString(runIdList) + ")";
        if (!DBUtils.isEmpty(nodeList)) {
            qString = String.valueOf(qString) + " and node in (" + this.concatQString(nodeList) + ")";
        }
        if (!DBUtils.isEmpty(keyList)) {
            qString = String.valueOf(qString) + " and key in (" + this.concatQString(keyList) + ")";
        }
        if (!DBUtils.isEmpty(timeList)) {
            qString = String.valueOf(qString) + " and time in (" + this.concatQString(timeList) + ")";
        }
        if (!DBUtils.isEmpty(yearList)) {
            qString = String.valueOf(qString) + " and year in (" + this.concatQString(yearList) + ")";
        }
        qString = String.valueOf(qString) + " order by runid, node, key, time, year";
        try {
            Statement statement = this.getConn().createStatement();
            ResultSet resultSet = statement.executeQuery(qString);
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                if (resultSet.getInt("runid") != prevRunid) {
                    Map runidInfo = (Map)runidMap.get(resultSet.getInt("runid"));
                    model = (String)runidInfo.get("model");
                    scenario = (String)runidInfo.get("scenario");
                    version = (Integer)runidInfo.get("version");
                    prevRunid = resultSet.getInt("runid");
                }
                row.put("model", model);
                row.put("scenario", scenario);
                row.put("version", version);
                row.put("region", mp.getNodeName(resultSet.getInt("node")));
                int variableId = resultSet.getInt("key");
                IamVariable iamVar = mp.getIamVariable(variableId);
                row.put("variable", iamVar.getString());
                row.put("unit", iamVar.getUnit());
                if (timeList != null) {
                    row.put("time", resultSet.getInt("time"));
                }
                row.put("year", resultSet.getInt("year"));
                row.put("value", resultSet.getDouble("value"));
                timeseries.add(row);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception e) {
            throw this.loggedIxException("Error reading timeseries data from the IXMP database!", e);
        }
        return timeseries;
    }

    void openConn() throws IxException {
        try {
            logger.debug((Object)("URL (source):" + this.dbConfig.getDbUrl1() + "|" + this.dbConfig.getDbUsr1() + "|" + this.dbConfig.getDbPwd1()));
            Class.forName(this.dbConfig.getDbDriver1());
            this.dbConn = DriverManager.getConnection(this.dbConfig.getDbUrl1(), this.dbConfig.getDbUsr1(), this.dbConfig.getDbPwd1());
            this.dbConn.setAutoCommit(false);
            logger.debug((Object)("URL (source):" + this.dbConfig.getDbUrl1()));
        }
        catch (Exception e) {
            throw this.loggedIxException("Could not open the database connection!", e);
        }
    }

    protected abstract boolean needsShutdown();

    protected DbConfig getConfig() {
        return this.dbConfig;
    }

    public abstract void testConn() throws IxException;

    public abstract void closeConn() throws IxException;
}

