/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.exceptions.IxRestException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.glassfish.jersey.client.ClientConfig;

public class DbConfig {
    static Logger logger = Logger.getLogger((String)DbConfig.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    private static String PROPERTIES_FILENAME = "ixmp.properties";
    private static DbConfig instance = null;
    private String ConfigName = "<no config file loaded>!";
    private String DbDriver1 = "<Driver not configured>";
    private String DbDriver2 = "<Driver not configured>";
    private String DbUrl1 = "jdbc:<not configured!>";
    private String DbUrl2 = "jdbc:<not configured!>";
    private String DbUsr1 = "<not configured>";
    private String DbUsr2 = "<not configured>";
    private String DbPwd1 = "no password configured";
    private String DbPwd2 = "no password configured";

    public DbConfig() throws IxException {
        this.parsePropertiesFile();
        this.updateSchemaIfNecessary();
    }

    private void updateSchemaIfNecessary() {
        boolean doSchemaMigration = false;
        boolean ignoreFutureMigrations = true;
        Flyway flyway = new Flyway();
        String[] locations = new String[1];
        switch (this.dbEngine()) {
            case "postgresql": {
                locations[0] = "classpath:db/migration/postgresql";
                break;
            }
            case "oracle": {
                locations[0] = "classpath:db/migration/oracle";
                break;
            }
            case "hsqldb": {
                locations[0] = "classpath:db/migration/hsql";
                if (!this.DbUrl1.contains("hsqldb:file:") && !this.DbUrl1.contains("hsqldb:mem:")) break;
                doSchemaMigration = true;
                ignoreFutureMigrations = false;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported DB engine: " + this.dbEngine());
            }
        }
        flyway.setLocations(locations);
        flyway.setDataSource(this.getDbUrl1(), this.getDbUsr1(), this.getDbPwd1(), new String[0]);
        flyway.setIgnoreFutureMigrations(ignoreFutureMigrations);
        try {
            flyway.validate();
        }
        catch (FlywayException fwe) {
            logger.error((Object)(String.valueOf(this.dbEngine()) + "|" + fwe.getMessage()));
            if (doSchemaMigration) {
                flyway.setBaselineOnMigrate(false);
                flyway.migrate();
            }
            throw fwe;
        }
    }

    public DbConfig(String pPropsFile) throws IxException {
        this.parsePropertiesFile(pPropsFile);
        this.updateSchemaIfNecessary();
    }

    public DbConfig(String hsqlDbFile, String dbType) throws IxException {
        if (!"HSQLDB".equals(dbType)) {
            String errMsg = "unknown type '" + dbType + "' when loading the DbConfig class!";
            logger.error((Object)errMsg);
            throw new IxException(errMsg);
        }
        String hsqldbDriver = "org.hsqldb.jdbcDriver";
        try {
            Class.forName(hsqldbDriver);
        }
        catch (ClassNotFoundException e) {
            String errMsg = "cannot find hsqldb driver!";
            logger.error((Object)errMsg, (Throwable)e);
            throw new IxException(errMsg);
        }
        this.setDbDriver1(hsqldbDriver);
        this.setDbUrl1("jdbc:hsqldb:file:" + hsqlDbFile);
        this.setDbUsr1("ixmp");
        this.setDbPwd1("ixmp");
        this.updateSchemaIfNecessary();
        this.ConfigName = "local database at '" + hsqlDbFile + "'";
    }

    public String getConfigFileName() {
        return PROPERTIES_FILENAME;
    }

    public String getConfigName() {
        return this.ConfigName;
    }

    public void setConfigName(String pConfigName) {
        this.ConfigName = pConfigName;
    }

    public String getDbPwd1() {
        return this.DbPwd1;
    }

    public void setDbPwd1(String dbPwd1) {
        this.DbPwd1 = dbPwd1;
    }

    public String getDbPwd2() {
        return this.DbPwd2;
    }

    public void setDbPwd2(String dbPwd2) {
        this.DbPwd2 = dbPwd2;
    }

    public String getDbUsr1() {
        return this.DbUsr1;
    }

    public void setDbUsr1(String dbUsr1) {
        this.DbUsr1 = dbUsr1;
    }

    public String getDbUsr2() {
        return this.DbUsr2;
    }

    public void setDbUsr2(String dbUsr2) {
        this.DbUsr2 = dbUsr2;
    }

    void parsePropertiesFile() throws IxException {
        InputStream propIs = null;
        URL url = DbConfig.class.getClassLoader().getResource(PROPERTIES_FILENAME);
        if (url != null) {
            logger.debug((Object)(String.valueOf(PROPERTIES_FILENAME) + " found at " + url));
            try {
                propIs = url.openStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IxException("could not open " + PROPERTIES_FILENAME + "!");
            }
        }
        if (propIs == null) {
            URL[] urls;
            logger.error((Object)("cannot find '" + PROPERTIES_FILENAME + "' in class path:"));
            URL[] uRLArray = urls = ((URLClassLoader)DbConfig.class.getClassLoader()).getURLs();
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL aUrl = uRLArray[n2];
                logger.error((Object)(" " + aUrl));
                ++n2;
            }
            throw new IxException(String.valueOf(PROPERTIES_FILENAME) + " not in java class path");
        }
        this.loadProperties(propIs, PROPERTIES_FILENAME);
        try {
            propIs.close();
        }
        catch (IOException e) {
            logger.error((Object)"could not close properties file", (Throwable)e);
            throw new IxException("could not close properties file");
        }
    }

    public boolean isHsqldb() {
        return this.DbDriver1.contains("hsqldb");
    }

    public String dbEngine() {
        int start = this.DbUrl1.indexOf(":") + 1;
        int end = this.DbUrl1.indexOf(":", start);
        return this.DbUrl1.substring(start, end);
    }

    public void parsePropertiesFile(String pProps) throws IxException {
        File propsFile = new File(pProps);
        FileInputStream propIs = null;
        try {
            propIs = new FileInputStream(propsFile);
            logger.info((Object)("parsing " + pProps + "..."));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("cannot open '" + pProps + "' properties file"), (Throwable)e);
            throw new IxException("cannot open '" + pProps + "' properties file at " + propsFile.getAbsolutePath() + "!");
        }
        this.loadProperties(propIs, pProps);
        try {
            ((InputStream)propIs).close();
        }
        catch (IOException e) {
            logger.error((Object)"could not close properties file", (Throwable)e);
            throw new IxException("could not close properties file");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadProperties(InputStream pIs, String pPropsFile) throws IxException {
        configProps = new Properties();
        try {
            configProps.load(pIs);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IxException("could not load properties!");
        }
        for (Object k : configProps.keySet()) {
            DbConfig.logger.debug((Object)(k + "|" + configProps.get(k)));
        }
        required_basic = new String[][]{{"ConfigName", "config.name"}};
        required_jdbc_direct = new String[][]{{"DbDriver1", "jdbc.driver.1"}, {"DbUrl1", "jdbc.url.1"}, {"DbUsr1", "jdbc.user.1"}, {"DbPwd1", "jdbc.pwd.1"}, {"DbDriver2", "jdbc.driver.2"}, {"DbUrl2", "jdbc.url.2"}, {"DbUsr2", "jdbc.user.2"}, {"DbPwd2", "jdbc.pwd.2"}};
        required_jdbc_server = new String[][]{{"ConfigUrl", "config.server.url"}, {"ConfigConfigname", "config.server.config"}, {"ConfigUsername", "config.server.username"}, {"ConfigPassword", "config.server.password"}};
        requiredChecks = new Object[][]{{"basic", required_basic}, {"jdbc_direct", required_jdbc_direct}, {"jdbc_server", required_jdbc_server}};
        checkError = new HashMap<Object, Boolean>();
        missingMap = new TreeMap<String, HashSet<E>>();
        var13_11 = requiredChecks;
        var12_12 = requiredChecks.length;
        var11_15 = 0;
        while (var11_15 < var12_12) {
            check = var13_11[var11_15];
            checkError.put(check[0], false);
            errors = new HashSet<String>();
            missingMap.put((String)check[0], errors);
            var18_26 = (String[][])check[1];
            var17_25 = var18_26.length;
            var16_24 = 0;
            while (var16_24 < var17_25) {
                checkprop = var18_26[var16_24];
                propVal = configProps.get(checkprop[1]);
                if (propVal == null) {
                    errors.add("missing property '" + checkprop[1] + "' in " + pPropsFile);
                    checkError.put(check[0], true);
                }
                ++var16_24;
            }
            DbConfig.logger.info((Object)(check[0] + " properties set " + ((Boolean)checkError.get(check[0]) != false ? "has errors" : "OK")));
            ++var11_15;
        }
        hasError = false;
        if (Boolean.TRUE == checkError.get("basic")) {
            for (String message : (HashSet)missingMap.get("basic")) {
                DbConfig.logger.error((Object)message);
            }
            hasError = true;
        }
        if (Boolean.FALSE == checkError.get("jdbc_direct")) {
            this.loadProperties(configProps, required_jdbc_direct, pPropsFile);
        } else if (Boolean.FALSE == checkError.get("jdbc_server")) {
            try {
                configProps = this.getServerConfig(configProps);
                this.loadProperties(configProps, required_jdbc_direct, pPropsFile);
            }
            catch (IxRestException e) {
                if (!((Boolean)checkError.get("jdbc_direct")).booleanValue()) ** GOTO lbl67
                throw new IxException(e.getMessage());
            }
            catch (Exception e) {
                if (!((Boolean)checkError.get("jdbc_direct")).booleanValue()) ** GOTO lbl67
                throw new IxException(e.getMessage());
            }
        } else {
            for (String message : (HashSet)missingMap.get("jdbc_server")) {
                DbConfig.logger.error((Object)message);
            }
            hasError = true;
        }
lbl67:
        // 5 sources

        if (hasError) {
            throw new IxException(String.valueOf(pPropsFile) + " is missing required properties");
        }
    }

    Properties getServerConfig(Properties pProps) throws IxRestException {
        Properties retval = pProps;
        ClientConfig config = new ClientConfig();
        Client client = ClientBuilder.newClient((Configuration)config);
        WebTarget target = client.target(UriBuilder.fromUri((String)pProps.getProperty("config.server.url")).build(new Object[0]));
        String username = pProps.getProperty("config.server.username");
        String userpass = pProps.getProperty("config.server.password");
        String jwt = null;
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("username", username);
        jsonMap.put("password", userpass);
        logger.debug((Object)"login ...");
        Response loginResponse = target.path("login").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(jsonMap));
        int loginStatus = loginResponse.getStatus();
        if (200 != loginStatus) {
            logger.debug((Object)("loginStatus: " + loginStatus));
            logger.error((Object)"user login failed.");
            jwt = null;
            String reason = "";
            switch (loginStatus) {
                case 400: {
                    reason = "Bad Request";
                    break;
                }
                case 401: {
                    reason = "Unauthorized";
                    break;
                }
                case 403: {
                    reason = "Forbidden";
                    break;
                }
                case 404: {
                    reason = "Not Found";
                }
            }
            throw new IxRestException(loginStatus, "login failed. Server return code is " + loginStatus + " (" + reason + ").");
        }
        jwt = ((String)loginResponse.readEntity(String.class)).replaceAll("\"", "");
        logger.debug((Object)"user login successful.");
        if (jwt == null) {
            return retval;
        }
        String aConfig = pProps.getProperty("config.server.config");
        Response configResponse = target.path("config").path(aConfig).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)("Bearer " + jwt)).get();
        int configStatus = configResponse.getStatus();
        if (200 == configStatus) {
            HashMap jsonMap2 = new HashMap();
            jsonMap2 = (HashMap)configResponse.readEntity((GenericType)new GenericType<HashMap<String, Object>>(){});
            logger.debug((Object)("status(" + aConfig + "): N=" + jsonMap2.size()));
            int[] ii = new int[]{1, 2};
            String[][] mappings = new String[][]{{"driver", "driver"}, {"url", "url"}, {"username", "user"}, {"password", "pwd"}};
            int[] nArray = ii;
            int n = ii.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                String[][] stringArrayArray = mappings;
                int n3 = mappings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] mapping = stringArrayArray[n4];
                    String jsonVal = (String)jsonMap2.get(mapping[0]);
                    String propVal = retval.getProperty(mapping[1]);
                    if (jsonVal != null && propVal == null) {
                        retval.setProperty("jdbc." + mapping[1] + "." + i, jsonVal);
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            String message = "status=" + configStatus + " " + (String)configResponse.readEntity(String.class);
            logger.error((Object)("/config request failed. " + message));
            throw new IxRestException(configStatus, "/config request failed. " + message);
        }
        return retval;
    }

    void loadProperties(Properties pProps, String[][] pRequiredProperties, String pPropsFile) throws IxException {
        boolean haveError = false;
        String[][] stringArray = pRequiredProperties;
        int n = pRequiredProperties.length;
        int n2 = 0;
        while (n2 < n) {
            block34: {
                Object propVal;
                String[] requiredProperty;
                block33: {
                    requiredProperty = stringArray[n2];
                    propVal = pProps.get(requiredProperty[1]);
                    if (propVal != null) break block33;
                    logger.error((Object)("missing property '" + requiredProperty[1] + "' in " + pPropsFile));
                    haveError = true;
                    break block34;
                }
                String propStr = propVal.toString();
                switch (requiredProperty[1]) {
                    case "config.name": {
                        this.setConfigName("database '" + propStr + "'");
                        break;
                    }
                    case "jdbc.driver.1": {
                        this.setDbDriver1(propStr);
                        break;
                    }
                    case "jdbc.driver.2": {
                        this.setDbDriver2(propStr);
                        break;
                    }
                    case "jdbc.url.1": {
                        this.setDbUrl1(propStr);
                        break;
                    }
                    case "jdbc.url.2": {
                        this.setDbUrl2(propStr);
                        break;
                    }
                    case "jdbc.user.1": {
                        this.setDbUsr1(propStr);
                        break;
                    }
                    case "jdbc.user.2": {
                        this.setDbUsr2(propStr);
                        break;
                    }
                    case "jdbc.pwd.1": {
                        this.setDbPwd1(propStr);
                        break;
                    }
                    case "jdbc.pwd.2": {
                        this.setDbPwd2(propStr);
                    }
                }
            }
            ++n2;
        }
        if (haveError) {
            throw new IxException(String.valueOf(pPropsFile) + " is missing required properties");
        }
    }

    public static synchronized DbConfig getInstance() throws IxException {
        if (instance == null) {
            instance = new DbConfig();
        }
        return instance;
    }

    public static synchronized DbConfig getInstance(String pPropsFile) throws IxException {
        if (instance == null) {
            instance = new DbConfig(pPropsFile);
        }
        return instance;
    }

    public static synchronized DbConfig getInstance(String pHsqldbFile, String pAction) throws IxException {
        if (instance == null) {
            instance = new DbConfig(pHsqldbFile, pAction);
        }
        return instance;
    }

    public String getDbDriver1() {
        return this.DbDriver1;
    }

    public void setDbDriver1(String dbDriver1) {
        this.DbDriver1 = dbDriver1;
    }

    public String getDbDriver2() {
        return this.DbDriver2;
    }

    public void setDbDriver2(String dbDriver2) {
        this.DbDriver2 = dbDriver2;
    }

    public String getDbUrl1() {
        return this.DbUrl1;
    }

    public void setDbUrl1(String dbUrl1) {
        this.DbUrl1 = dbUrl1;
    }

    public String getDbUrl2() {
        return this.DbUrl2;
    }

    public void setDbUrl2(String dbUrl2) {
        this.DbUrl2 = dbUrl2;
    }
}

