/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp;

import at.ac.iiasa.ixmp.database.DbConfig;
import at.ac.iiasa.ixmp.datahandling.TxtUtils;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.modelspecs.MESSAGEspecs;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.MsgScenario;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Set;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class MsgSqlite_2_MsgDB {
    static Logger logger = Logger.getLogger((String)MsgSqlite_2_MsgDB.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    protected DbConfig dbConfig = null;
    MsgScenario sqliteData = null;
    LinkedList<String> yearColList = null;
    LinkedList<Integer> modelYearList = null;
    LinkedList<Integer> historicalYearList = null;
    Integer firstModelYear = null;
    Integer lastModelYear = null;
    HashMap<String, String> fuelCodeMap = null;
    HashMap<String, String> mTecIdMap = new HashMap();
    HashMap<String, String> mRelIdMap = new HashMap();
    HashMap<String, String> mRelRelioMap = new HashMap();
    HashSet<String> validRelations = new HashSet();
    HashSet<String> droppedRelations = new HashSet();
    HashSet<String> globalRelations = new HashSet();
    HashMap<String, String> parUnitMap = new HashMap();
    static String regSuffix = null;
    static boolean isMsgBrazil = false;
    static String GLBregion = "GLB";
    static String[][] parUnit = new String[][]{{"commodity_stock", "GWa"}, {"demand", "GWa"}, {"technical_lifetime", "y"}, {"capacity_factor", "%"}, {"operation_factor", "%"}, {"min_utilization_factor", "%"}, {"inv_cost", "USD/GWa"}, {"fix_cost", "USD/GWa"}, {"var_cost", "USD/GWa"}, {"main_output", "???"}, {"main_input", "???"}, {"output", "GWa"}, {"output", "GWa"}, {"input", "GWa"}, {"efficiency", "%"}, {"abs_cost_new_capacity_soft_up", "USD/GWa"}, {"abs_cost_new_capacity_soft_lo", "USD/GWa"}, {"level_cost_new_capacity_soft_up", "USD/GWa"}, {"level_cost_new_capacity_soft_lo", "USD/GWa"}, {"abs_cost_activity_soft_up", "USD/GWa"}, {"abs_cost_activity_soft_lo", "USD/GWa"}, {"level_cost_activity_soft_up", "USD/GWa"}, {"level_cost_activity_soft_lo", "USD/GWa"}, {"bounds_new_capacity", "GWa"}, {"bounds_total_capacity", "GWa"}, {"bounds_activity", "GWa"}, {"bound_new_capacity_up", "GWa"}, {"bound_new_capacity_lo", "GWa"}, {"bound_total_capacity_up", "GWa"}, {"bound_total_capacity_lo", "GWa"}, {"bound_activity_up", "GWa"}, {"bound_activity_lo", "GWa"}, {"market_penetration_new_capacity", "GWa"}, {"initial_new_capacity_up", "GW"}, {"growth_new_capacity_up", "%"}, {"soft_new_capacity_up", "GW"}, {"initial_new_capacity_lo", "GW"}, {"growth_new_capacity_lo", "%"}, {"soft_new_capacity_lo", "GW"}, {"market_penetration_activity", "GWa"}, {"initial_activity_up", "GWa"}, {"growth_activity_up", "%"}, {"soft_activity_up", "GWa"}, {"initial_activity_lo", "GWa"}, {"growth_activity_lo", "%"}, {"soft_activity_lo", "GWa"}, {"emission_factor", "kg/kWa"}, {"construction_time", "y"}, {"con1a", "???"}, {"con2a", "???"}, {"conca", "???"}, {"con1c", "???"}, {"con2c", "???"}, {"historical_new_capacity", "GW"}, {"historical_activity", "GWa"}, {"ref_new_capacity", "GW"}, {"ref_activity", "GWa"}, {"cost_pseudotec", "USD/GWa"}, {"upper_bound", "???"}, {"lower_bound", "???"}, {"con1a_pseudotec", "???"}, {"con2a_pseudotec", "???"}, {"righthandside", "GWa"}, {"range", "GWa"}, {"cost", "???"}, {"resource_cost", "USD/GWa"}, {"resource_remaining", "GWa"}, {"upper_limit", "USD/GWa"}, {"resource_volume", "GWa"}, {"tax", "USD/GWa"}, {"subsidy", "USD/GWa"}, {"emission_scaling", "???"}, {"bound_emission", "kg"}, {"tax_emission", "USD/kg"}, {"relation_upper", "???"}, {"relation_lower", "???"}, {"relation_cost", "???"}, {"relation_new_capacity", "???"}, {"relation_activity", "???"}, {"duration_period", "y"}, {"duration_time", "%"}, {"interestrate", "%"}};
    static HashMap<String, String> cleanNameMap = new HashMap();
    static String[][] replaceCleanNames = new String[][]{{"BCA_IndNonEnEM", "BCA_IndNonEnergyEM"}, {"CO_LandUseChangEM", "CO_LandUseChangeEM"}, {"CF4fromSemico", "CF4_Semico"}, {"CH4DomWasteWa", "CH4_DomWasteWa"}, {"CH4IndWasteWa", "CH4_IndWasteWa"}, {"CH4_LandUseChangEM", "CH4_LandUseChangeEM"}, {"HFCAerosolMDI", "HFC_AerosolMDI"}, {"HFCAerosolNonMDI", "HFC_AerosolNonMDI"}, {"NH3IndNonEnergyEM", "NH3_IndNonEnergyEM"}, {"NH3ManureEM", "NH3_ManureEM"}, {"NH3RiceEM", "NH3_RiceEM"}, {"NH3SoilEM", "NH3_SoilEM"}, {"NOxAgWasteEM", "NOx_AgWasteEM"}, {"NOxIndNonEnergyEM", "NOx_IndNonEnergyEM"}, {"NOxIntShipEM", "NOx_IntShipEM"}, {"NOxLandUseChangEM", "NOx_LandUseChangeEM"}, {"NOxSavanBurnEM", "NOx_SavanBurnEM"}, {"NOxSoilEM", "NOx_SoilEM"}, {"NOxWasteBurnEM", "NOx_WasteBurnEM"}, {"OCA_IndNonEnEM", "OCA_IndNonEnergyEM"}, {"PM2_IndNonEnEM", "PM2_IndNonEnergyEM"}, {"SO2AgWasteEM", "SO2_AgWasteEM"}, {"SO2IndNonEnergyEM", "SO2_IndNonEnergyEM"}, {"SO2IntShipEM", "SO2_IntShipEM"}, {"SO2LandUseChangEM", "SO2_LandUseChangeEM"}, {"SO2SavanBurnEM", "SO2_SavanBurnEM"}, {"SO2WasteBurnEM", "SO2_WasteBurnEM"}, {"NOxCarbonFluxLink", "NOx_CarbonFluxLink"}, {"OCACarbonFluxLink", "OCA_CarbonFluxLink"}, {"BCACarbonFluxLink", "BCA_CarbonFluxLink"}, {"CH4new_Emission", "CH4_new_Emission"}, {"NH3CarbonFluxLink", "NH3_CarbonFluxLink"}, {"SO2_emi_el", "SO2_elec"}, {"SO2_emi_in", "SO2_ind"}, {"SO2_emi_rc", "SO2_r_c"}, {"SO2CarbonFluxLink", "SO2_CarbonFluxLink"}, {"VOCCarbonFluxLink", "VOC_CarbonFluxLink"}, {"VOCIndThermLink", "VOC_IndThermLink"}, {"Feedstock_final", "feedstock_final"}, {"FuelOil_final", "fueloil_final"}, {"Kerosene_final", "kerosene_final"}, {"Light_Oil", "light_oil"}, {"Mid_Oil", "mid_oil"}, {"Coal", "coal"}};

    /*
     * WARNING - void declaration
     */
    public MsgSqlite_2_MsgDB(File sqliteFile, DbConfig dbConfig, String pModel, String pScenario, String pQuery, File solFile, File softFile, int bYear, String rRegSuffix) throws Exception {
        Parameter aPar;
        String[] relevantRel;
        String[] conXa_pseudotec;
        String[] conXaPseudotecList;
        String[] conXaList;
        String[] conXc232;
        String[] tecVector72;
        String key;
        String key2;
        Double val;
        Vector<Integer> newFacVector;
        Integer aYrKey;
        Double val2;
        Vector<Integer> tecVector;
        String[] parList;
        Iterator eleVector;
        String[] parFxClean;
        void var23_48;
        void var23_46;
        String msgname;
        String[] commId;
        ResultSet aRs;
        Statement qStmt;
        String[][] catTecConf;
        String[][] msgname2;
        String tec;
        String sqliteUrl = "jdbc:sqlite:" + sqliteFile.getAbsolutePath();
        Connection sqliteConn = null;
        Class.forName("org.sqlite.JDBC");
        sqliteConn = DriverManager.getConnection(sqliteUrl, "", "");
        regSuffix = rRegSuffix;
        logger.info((Object)("start importing dataset '" + pModel + "|" + pScenario + "' from file '" + sqliteFile + "' to database!"));
        String[][] stringArray = parUnit;
        int n = parUnit.length;
        int n2 = 0;
        while (n2 < n) {
            String[] aUnitMap = stringArray[n2];
            this.parUnitMap.put(aUnitMap[0], aUnitMap[1]);
            ++n2;
        }
        stringArray = replaceCleanNames;
        n = replaceCleanNames.length;
        n2 = 0;
        while (n2 < n) {
            String[] aCleanNameUnitMap = stringArray[n2];
            cleanNameMap.put(aCleanNameUnitMap[0], aCleanNameUnitMap[1]);
            ++n2;
        }
        this.sqliteData = new MsgScenario(pModel, pScenario, true, "imported from SQLite");
        Set aSet = this.sqliteData.getSet("year");
        this.historicalYearList = new LinkedList();
        int i = 1950;
        while (i < 2010) {
            aSet.addElement("" + i);
            this.historicalYearList.add(i);
            i += 5;
        }
        this.modelYearList = new LinkedList();
        this.yearColList = new LinkedList();
        DatabaseMetaData dbMeta = sqliteConn.getMetaData();
        ResultSet colsRs = dbMeta.getColumns(null, null, "data", null);
        while (colsRs.next()) {
            String col = colsRs.getString(4);
            if (!col.matches("v[0-9]{4}")) continue;
            this.yearColList.add(col);
            String s = col.substring(1);
            this.modelYearList.add(Integer.parseInt(s));
            if (this.firstModelYear == null) {
                this.firstModelYear = Integer.parseInt(s);
            }
            this.lastModelYear = Integer.parseInt(s);
            aSet.addElement(s);
        }
        colsRs.close();
        aSet = this.sqliteData.getSet("node");
        String aQuery2 = "select distinct subregion from data";
        Statement qStmt2 = sqliteConn.createStatement();
        ResultSet aRs2 = qStmt2.executeQuery(aQuery2);
        while (aRs2.next()) {
            String reg = MsgSqlite_2_MsgDB.msgCleanNode(aRs2.getString(1));
            aSet.addElement(reg);
        }
        aRs2.close();
        qStmt2.close();
        aSet = this.sqliteData.getSet("technology");
        String aQuery = "select distinct name from data where section = 'systems:' and name not like 'deficit_%'";
        if (pQuery != null) {
            aQuery = String.valueOf(aQuery) + " " + pQuery;
        }
        Statement qStmt3 = sqliteConn.createStatement();
        ResultSet aRs3 = qStmt3.executeQuery(aQuery);
        while (aRs3.next()) {
            tec = MsgSqlite_2_MsgDB.msgCleanName(aRs3.getString(1));
            if (tec.matches(".*[(][1-9][.][)]")) continue;
            aSet.addElement(tec);
        }
        aRs3.close();
        qStmt3.close();
        aSet.addElement("oil_st");
        aSet = this.sqliteData.initializeSet("pseudotechnology", null, null);
        aQuery = "select distinct name from data where section = 'variables:'";
        if (pQuery != null) {
            aQuery = String.valueOf(aQuery) + " " + pQuery;
        }
        qStmt3 = sqliteConn.createStatement();
        aRs3 = qStmt3.executeQuery(aQuery);
        while (aRs3.next()) {
            tec = aRs3.getString(1);
            if (tec.matches(".*[(][1-9][.][)]")) continue;
            aSet.addElement(MsgSqlite_2_MsgDB.msgCleanName(tec));
        }
        aRs3.close();
        qStmt3.close();
        aSet = this.sqliteData.getSet("emission");
        aQuery = "SELECT distinct name FROM data WHERE section='relations2:' and keywd='model' and name like '%emiss%'";
        qStmt3 = sqliteConn.createStatement();
        aRs3 = qStmt3.executeQuery(aQuery);
        while (aRs3.next()) {
            String name = MsgSqlite_2_MsgDB.msgCleanName(aRs3.getString(1));
            if ((name = name.split("_")[0]).startsWith("T") || name.equals("CH4new") || name.equals("Dummy")) continue;
            aSet.addElement(name);
        }
        aRs3.close();
        qStmt3.close();
        aSet.addElement("CO2");
        aSet.addElement("CO2_transformation");
        aSet.addElement("CO2_res_com");
        aSet.addElement("CO2_industry");
        aSet.addElement("CO2_transport");
        aSet.addElement("CH4_landuse");
        aSet.addElement("N2O_landuse");
        aSet.addElement("CO2_landuse");
        Set nodeSet = this.sqliteData.getSet("node");
        Set nodeLvlSet = this.sqliteData.getSet("lvl_spatial");
        nodeLvlSet.addElement("region");
        Set nodeMapSet = this.sqliteData.getSet("map_spatial_hierarchy");
        Set catNodeSet = this.sqliteData.getSet("cat_node");
        TreeSet<String> nodes = new TreeSet<String>();
        String[] stringArray2 = this.sqliteData.getIndexSetKeys("node");
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String aNd = stringArray2[n4];
            nodes.add(aNd);
            ++n4;
        }
        for (String aNode : nodes) {
            if (aNode.equals("World")) continue;
            nodeSet.addElement(aNode);
            nodeMapSet.addElement("region." + aNode + ".World");
            if (aNode.equals(String.valueOf(regSuffix) + "GLB")) continue;
            catNodeSet.addElement("economy." + aNode);
        }
        LinkedList<Integer> years = this.sqliteData.getYearList();
        HashMap<String, String> prevYearMap = new HashMap<String, String>();
        HashMap<Integer, Integer> prevYearMapInt = new HashMap<Integer, Integer>();
        int i2 = 1;
        while (i2 < years.size()) {
            prevYearMap.put("" + years.get(i2), "" + years.get(i2 - 1));
            prevYearMapInt.put(years.get(i2), years.get(i2 - 1));
            ++i2;
        }
        Set tecTypeSet = this.sqliteData.getSet("type_tec");
        Set tecCatSet = this.sqliteData.getSet("cat_tec");
        String aQuery3 = "select distinct id, name, subregion, chrval, section from data where section like 'relations%' and keywd = 'relio' ";
        Statement qStmt32 = sqliteConn.createStatement();
        ResultSet aRs32 = qStmt32.executeQuery(aQuery3);
        int cnt = 0;
        while (aRs32.next()) {
            String relid = aRs32.getString(1);
            msgname2 = MsgSqlite_2_MsgDB.msgConsistency(aRs32.getString(2));
            String string = MsgSqlite_2_MsgDB.msgCleanName((String)msgname2);
            String region2 = MsgSqlite_2_MsgDB.msgCleanNode(aRs32.getString(3));
            String relio = aRs32.getString(4);
            String relsection = aRs32.getString(5);
            this.mRelIdMap.put(String.valueOf(relsection) + "|" + relid + "|" + region2, string);
            this.mRelRelioMap.put(String.valueOf(string) + "|" + region2, relio);
            ++cnt;
        }
        logger.info((Object)("got " + cnt + " relations id mappings and additional info from sqlite"));
        aRs32.close();
        qStmt32.close();
        HashMap<String, Integer> firstlastYearMap = new HashMap<String, Integer>();
        msgname2 = catTecConf = new String[][]{{"investment", "electricity", "select distinct name   from data where section = 'systems:' and keywd = 'con1c' and item = 'inve'"}, {"investment", "supply", "select distinct name   from data where section = 'systems:' and keywd = 'con1c' and item = 'invs'"}, {"investment", "other", "select distinct name   from data where section = 'systems:' and keywd = 'con1c' and item = 'invo'"}, {"investment", "decentral", "select distinct name   from data where section = 'systems:' and keywd = 'con1c' and item = 'invu'"}, {"extraction", "fossil", " select distinct d1.name from data d1   where d1.keywd = 'moutp' and d1.item in ('c-a', 'o-a', 'g-a')   intersect  select distinct d1.name from data d1   where d1.keywd = 'minp' and d1.item like '%-r' order by 1 "}, {"powerplant", "fossil", " select distinct d1.name from data d1   where (name like 'coal%' or name like '%oil%' or name like 'gas%' or name like '%co2scr%')   and name not like '%mpen%' and name not like '%bio%'   and d1.keywd = 'moutp' and d1.item in ('e-x', 'd-x', 'x-x') order by 1 "}, {"powerplant", "low-carbon", " select distinct d1.name from data d1   where (name like '%geo%' or name like '%csp%' or name like '%hydro%' or name like '%nuc%'   or name like '%bio%' or name like '%solar%' or name like '%pv%' or name like '%wind%'   or name like 'stor_ppl' ) and name not like '%mpen%'   and d1.keywd = 'moutp' and d1.item in ('e-x', 'd-x', 'w-x', 'x-x') order by 1"}, {"transformation", "fossil", " select distinct d1.name from data d1   where (name like 'coal%' or name like '%oil%' or name like 'gas%' or name like '%co2scr%')   and name not like '%mpen%' and name not like '%bio%'   and d1.keywd = 'moutp' and d1.item in ('e-x', 'd-x', 'x-x')  union  select distinct d1.name from data d1   where (name like 'ref_%' or name like 'meth_%' or name like 'syn%' or name like '%_gas' or name like 'h2_coal%'   or name like 'h2_smr%' or name like 'h2_co2_scrub')   and name not like '%regas%' and name not like '%mix%' and name not like '%mpen%'   and d1.keywd = 'moutp' and d1.item in ('E-a', 'm-a', 'h-x', 'l-x', 'f-x', 'g-x', 'x-x')  order by 1 "}, {"transformation", "low-carbon", " select distinct d1.name from data d1   where (name like '%geo%' or name like '%csp%' or name like '%hydro%' or name like '%nuc%'    or name like '%bio%' or name like '%solar%' or name like '%pv%' or name like '%wind%'    or name like 'stor_ppl' ) and name not like '%mpen%'    and d1.keywd = 'moutp' and d1.item in ('e-x', 'd-x', 'w-x', 'x-x')  union  select distinct d1.name from data d1   where (name like '%bio%' or name like 'h2_elec' or name like 'h2b_co2_scrub')    and name not like '%co2scr%' and name not like '%mpen%'   and d1.keywd = 'moutp' and d1.item in ('E-a', 'm-a', 'h-x', 'l-x', 'f-x', 'g-x', 'x-x')   order by 1  "}, {"transformation", "enduse", "select distinct d1.name from data d1   where d1.name like 'useful_%'   and d1.keywd = 'moutp' and d1.item = 'x-a'   union  select distinct d1.name from data d1   where name like '%_i' and name not like 'back%'   and d1.keywd = 'moutp' and d1.item in ('b-u')  union   select distinct d1.name from data d1    where name like 'h2%' and name not like 'back%' and d1.keywd = 'minp' and d1.item in ('h-f', 'H-f')   order by 1  "}};
        int relid = catTecConf.length;
        cnt = 0;
        while (cnt < relid) {
            String[] tecCfg = msgname2[cnt];
            tecTypeSet.addElement(String.valueOf(tecCfg[0]) + "_" + tecCfg[1]);
            String string = tecCfg[2];
            qStmt = sqliteConn.createStatement();
            aRs = qStmt.executeQuery(string);
            while (aRs.next()) {
                String tec2 = aRs.getString(1);
                tecCatSet.addElement(String.valueOf(tecCfg[0]) + "_" + tecCfg[1] + "." + MsgSqlite_2_MsgDB.msgCleanName(tec2));
            }
            aRs.close();
            qStmt.close();
            ++cnt;
        }
        String[][] catTemporalAvlConf = new String[][]{{"temporal_availability", "firstyear", "select distinct section, name, subregion, intval from data where keywd = 'fyear' and name not like 'deficit_%'"}, {"temporal_availability", "lastyear", "select distinct section, name, subregion, intval from data where keywd = 'lyear' and name not like 'deficit_%'"}};
        msgname2 = catTemporalAvlConf;
        relid = catTemporalAvlConf.length;
        cnt = 0;
        while (cnt < relid) {
            void var23_39;
            String[] temporalCfg = msgname2[cnt];
            String string = temporalCfg[2];
            if (pQuery != null) {
                String string2 = String.valueOf(string) + " " + pQuery;
            }
            qStmt = sqliteConn.createStatement();
            aRs = qStmt.executeQuery((String)var23_39);
            while (aRs.next()) {
                String section = aRs.getString(1);
                String key3 = aRs.getString(2);
                String name = this.decodeTecName(key3);
                String region3 = MsgSqlite_2_MsgDB.msgCleanNode(aRs.getString(3));
                int year = Integer.parseInt(aRs.getString(4));
                if (section.equals("systems:")) {
                    String mode = this.decodeTecMode(key3);
                    firstlastYearMap.put(String.valueOf(temporalCfg[1]) + "|" + region3 + "|" + name + "|" + mode, year);
                    if (mode.matches("M1")) continue;
                    name = String.valueOf(name) + "|" + mode;
                    continue;
                }
                if (section.equals("variables:")) {
                    firstlastYearMap.put(String.valueOf(temporalCfg[1]) + "|" + region3 + "|" + name + "|P", year);
                    continue;
                }
                if (!section.startsWith("rel")) continue;
                name = this.mRelIdMap.get(String.valueOf(section) + "|" + name + "|" + region3);
            }
            aRs.close();
            qStmt.close();
            ++cnt;
        }
        Set modeSet = this.sqliteData.getSet("mode");
        modeSet.addElement("M1");
        modeSet.addElement("M2");
        modeSet.addElement("M3");
        modeSet.addElement("M4");
        modeSet.addElement("P");
        Set gradeSet = this.sqliteData.getSet("grade");
        String aQuery4 = "select distinct name from data where section='resources:'";
        Statement qStmt4 = sqliteConn.createStatement();
        ResultSet aRs4 = qStmt4.executeQuery(aQuery4);
        TreeSet<Object> grdSet = new TreeSet<Object>();
        while (aRs4.next()) {
            String string = aRs4.getString(1);
            if (!string.matches(".*[(][a-z][)]")) continue;
            String aGrade = this.decodeFuelGrade(string, "");
            grdSet.add(aGrade);
        }
        for (String string : grdSet) {
            gradeSet.addElement(string);
        }
        aRs4.close();
        qStmt4.close();
        this.fuelCodeMap = new HashMap();
        LinkedList<String> dummyList = new LinkedList<String>(Arrays.asList("Dummy", "dumren", "dummy", "biodum", "dummy_useful"));
        Set levelSet = this.sqliteData.getSet("level");
        Set commoditySet = this.sqliteData.getSet("commodity");
        String aQuery5 = "SELECT distinct subregion,name,id,item,ident FROM data WHERE section='energyforms:' and subkwd='eneunit'";
        Statement qStmt5 = sqliteConn.createStatement();
        ResultSet resultSet = qStmt5.executeQuery(aQuery5);
        while (resultSet.next()) {
            String level;
            String region = resultSet.getString(1);
            if (region.equals("Brasil")) {
                isMsgBrazil = true;
                GLBregion = region = "Brazil";
            }
            if ((level = resultSet.getString(2)).equals("resources") || level.equals("Resources")) {
                level = "resource";
            } else if (level.equals("second")) {
                level = "secondary";
            }
            String levId = resultSet.getString(3);
            String commodity = MsgSqlite_2_MsgDB.msgCleanName(resultSet.getString(4));
            commId = MsgSqlite_2_MsgDB.msgCleanName(resultSet.getString(5));
            this.fuelCodeMap.put(String.valueOf(region) + "|" + (String)commId + "-" + levId, String.valueOf(region) + "|" + commodity + "|" + level);
            if (dummyList.contains(commodity)) {
                logger.info((Object)(" drop commodity " + commodity + " during import from SQLite file"));
                continue;
            }
            levelSet.addElement(level);
            commoditySet.addElement(commodity);
        }
        resultSet.close();
        qStmt5.close();
        levelSet.addElement("stocks");
        this.sqliteData.getSet("level").addElement("resource");
        this.sqliteData.getSet("level").addElement("useful");
        if (!isMsgBrazil) {
            this.sqliteData.getSet("level_resource").addElement("resource");
            this.sqliteData.getSet("level_stocks").addElement("stocks");
        }
        HashSet<String> pseudoTecRegSet = new HashSet<String>();
        String aQuery6 = " select distinct d0.id, d0.name, d0.subregion, d1.chrval, d2.chrval, d3.chrval from (  select distinct name, id, subregion from data where section = 'variables:'  ) d0 left join (  select distinct id, name, subregion, chrval from data where section = 'variables:' and keywd = 'units'  ) d1 on d0.name=d1.name AND d0.id=d1.id AND d0.subregion=d1.subregion left join (  select distinct id, name, subregion, chrval from data where section = 'variables:' and keywd = 'for_ldr'  ) d2 on d0.name=d2.name AND d0.id=d2.id AND d0.subregion=d2.subregion left join (  select distinct id, name, subregion, chrval from data where section = 'variables:' and keywd = 'type' and chrval not null  ) d3 on d0.name=d3.name AND d0.id=d3.id AND d0.subregion=d3.subregion";
        Statement qStmt6 = sqliteConn.createStatement();
        ResultSet aRs6 = qStmt6.executeQuery(aQuery6);
        boolean bl = false;
        while (aRs6.next()) {
            String varid = aRs6.getString(1);
            msgname = aRs6.getString(2);
            String varname = MsgSqlite_2_MsgDB.msgCleanName(msgname);
            String region = MsgSqlite_2_MsgDB.msgCleanNode(aRs6.getString(3));
            this.mTecIdMap.put(String.valueOf(varid) + "|" + region, varname);
            pseudoTecRegSet.add(String.valueOf(varname) + "|" + region);
            ++var23_46;
        }
        aRs6.close();
        qStmt6.close();
        logger.info((Object)("got " + (int)var23_46 + " variable id mappings and additional info from sqlite"));
        String aQuery7 = "select d1.id, d1.name, d1.subregion, d2.dblval, d3.timeseries from ( \tselect distinct id, name, subregion from data where section='systems:' ) d1 left outer join (  select distinct id, subregion, dblval from data where section='systems:' and keywd = 'hisc' and item = 'hisact'  ) d2 on d1.id=d2.id AND d1.subregion=d2.subregion left outer join ( select distinct id, subregion, timeseries from data where section='systems:' and keywd = 'hisc' and item = 'hiscap'  ) d3 on d1.id=d3.id AND d1.subregion=d3.subregion  where d1.name not like 'deficit_%'";
        if (pQuery != null) {
            aQuery7 = String.valueOf(aQuery7) + " " + pQuery;
        }
        Statement qStmt7 = sqliteConn.createStatement();
        ResultSet aRs5 = qStmt7.executeQuery(aQuery7);
        boolean bl2 = false;
        while (aRs5.next()) {
            Object tecid = aRs5.getString(1);
            msgname = aRs5.getString(2);
            String tecname = MsgSqlite_2_MsgDB.msgCleanName(msgname);
            String region4 = MsgSqlite_2_MsgDB.msgCleanNode(aRs5.getString(3));
            if (((String)tecid).equals("f.ab") && msgname.equals("FE_bio_backstop")) {
                tecid = "f.bb";
            }
            this.mTecIdMap.put(String.valueOf(tecid) + "|" + region4, tecname);
            ++var23_48;
        }
        aRs5.close();
        qStmt7.close();
        logger.info((Object)("got " + (int)var23_48 + " technology id mappings and additional info from sqlite"));
        MESSAGEspecs msgModelSpecs = MESSAGEspecs.getInstance();
        LinkedList<String[]> parMsgDbConf = msgModelSpecs.getParamConfigs();
        HashMap<String, String[][]> parIndexMap = MESSAGEspecs.getSetParameterIndexMap();
        for (String[] stringArray3 : parMsgDbConf) {
            if (stringArray3[1] == null) {
                this.sqliteData.getPar(stringArray3[0]);
                continue;
            }
            if (stringArray3.length == 4) {
                this.parseParData(sqliteConn, stringArray3[1], stringArray3[2], stringArray3[0], parIndexMap.get(stringArray3[0]), pQuery, stringArray3[3]);
                continue;
            }
            this.parseParData(sqliteConn, stringArray3[1], stringArray3[2], stringArray3[0], parIndexMap.get(stringArray3[0]), pQuery);
        }
        logger.info((Object)"got all parameters from sqlite");
        Parameter parameter = this.sqliteData.getPar("bounds_activity");
        if (this.sqliteData.nodes.contains("cpa")) {
            String[] bdaloCheck = new String[]{"cpa.coal_extr.2020.M1.lo", "cpa.coal_extr.2030.M1.lo", "cpa.coal_extr.2040.M1.lo", "cpa.coal_extr.2050.M1.lo", "cpa.coal_extr.2060.M1.lo", "cpa.coal_extr.2070.M1.lo", "cpa.coal_extr.2080.M1.lo", "cpa.coal_extr.2090.M1.lo", "cpa.coal_extr.2100.M1.lo", "cpa.coal_extr.2110.M1.lo"};
            commId = bdaloCheck;
            int region4 = bdaloCheck.length;
            int tecname = 0;
            while (tecname < region4) {
                String ele = commId[tecname];
                parameter.addElement(ele, (Double)0.0, "GWa", "changed to zero (from negative infinity) during SQLite import");
                this.sqliteData.addToChangelog("changed during SQLite import", "systems", "lower bound of activity " + ele + " changed to zero (from negative infinity) during SQLite import");
                ++tecname;
            }
        }
        commId = parFxClean = new String[]{"bounds_new_capacity", "bounds_total_capacity", "bounds_activity"};
        int region4 = parFxClean.length;
        int tecname = 0;
        while (tecname < region4) {
            String aParName = commId[tecname];
            Parameter aPar2 = this.sqliteData.getPar(aParName);
            LinkedList<Vector<Integer>> cleanEle = new LinkedList<Vector<Integer>>();
            HashMap<Vector<Integer>, Double> cleanEleValue = new HashMap<Vector<Integer>, Double>();
            LinkedList<Element> removeEle = new LinkedList<Element>();
            for (Element element : aPar2.getElements()) {
                if (!element.getKey("dir").equals("fx")) continue;
                double valFx = element.getValue();
                Vector<Integer> eleUpVector = element.getClonedVector();
                aPar2.setKeyAtIndex(eleUpVector, "dir", "up");
                if (aPar2.hasElement(eleUpVector) && valFx < aPar2.getEleValue(eleUpVector)) {
                    cleanEle.add(eleUpVector);
                    cleanEleValue.put(eleUpVector, valFx);
                } else if (!aPar2.hasElement(eleUpVector)) {
                    cleanEle.add(eleUpVector);
                    cleanEleValue.put(eleUpVector, valFx);
                }
                Vector<Integer> eleLoVector = element.getClonedVector();
                aPar2.setKeyAtIndex(eleLoVector, "dir", "lo");
                if (aPar2.hasElement(eleLoVector) && valFx > aPar2.getEleValue(eleLoVector)) {
                    cleanEle.add(eleLoVector);
                    cleanEleValue.put(eleLoVector, valFx);
                    logger.info((Object)("replacing lower bound element for " + aPar2.getName() + ": " + element.getConcatKey()));
                } else if (!aPar2.hasElement(eleLoVector)) {
                    cleanEle.add(eleLoVector);
                    cleanEleValue.put(eleLoVector, valFx);
                    logger.info((Object)("adding lower bound element for " + aPar2.getName() + ": " + element.getConcatKey()));
                }
                removeEle.add(element);
            }
            for (Vector vector : cleanEle) {
                aPar2.addElement(vector, (Double)cleanEleValue.get(vector), "GWa", "derived from 'fx' element");
            }
            for (Element element : removeEle) {
                aPar2.removeElement(element);
            }
            ++tecname;
        }
        logger.info((Object)"replaced all fixed bounds by explicit upper and lower bound");
        Parameter bound_extraction_up = this.sqliteData.getPar("bound_extraction_up");
        LinkedList<Element> removeEle = new LinkedList<Element>();
        for (Element ele : bound_extraction_up.getElements()) {
            if (!ele.getValue().isInfinite()) continue;
            removeEle.add(ele);
        }
        for (Element rEle : removeEle) {
            bound_extraction_up.removeElement(rEle);
        }
        HashMap<Vector<Integer>, Integer> tecLifetime = new HashMap<Vector<Integer>, Integer>();
        Parameter technical_lifetime = this.sqliteData.getPar("technical_lifetime");
        for (Element ele : technical_lifetime.getElements()) {
            int val5 = ele.getValue().intValue();
            if (val5 <= 0) continue;
            tecLifetime.put(this.getTecVector(ele.getVector()), val5);
        }
        HashSet<Vector<Integer>> tecYrList = new HashSet<Vector<Integer>>();
        HashSet<Vector<Integer>> tecYrInvList = new HashSet<Vector<Integer>>();
        HashSet<Vector<Integer>> tecYrActList = new HashSet<Vector<Integer>>();
        Parameter bdc = this.sqliteData.getPar("bound_new_capacity_up");
        String aQuery72 = "select distinct subregion,name from data where section = 'systems:' and name not like 'deficit_%'";
        if (pQuery != null) {
            aQuery72 = String.valueOf(aQuery72) + " " + pQuery;
        }
        Statement qStmt72 = sqliteConn.createStatement();
        ResultSet aRs2232 = qStmt72.executeQuery(aQuery72);
        while (aRs2232.next()) {
            String string = MsgSqlite_2_MsgDB.msgCleanNode(aRs2232.getString(1));
            String string3 = aRs2232.getString(2);
            String tec3 = this.decodeTecName(string3);
            String mode = this.decodeTecMode(string3);
            int fYear = this.firstModelYear;
            int lYear = this.lastModelYear + 1;
            if (firstlastYearMap.get("firstyear|" + string + "|" + tec3 + "|" + mode) != null) {
                fYear = (Integer)firstlastYearMap.get("firstyear|" + string + "|" + tec3 + "|" + mode);
            }
            if (firstlastYearMap.get("lastyear|" + string + "|" + tec3 + "|" + mode) != null) {
                lYear = (Integer)firstlastYearMap.get("lastyear|" + string + "|" + tec3 + "|" + mode);
            }
            Iterator iterator = years.iterator();
            while (iterator.hasNext()) {
                int aVtgYr = (Integer)iterator.next();
                if (aVtgYr < this.firstModelYear || aVtgYr < fYear || aVtgYr >= lYear) continue;
                Vector<Integer> tecVector2 = this.getVector(String.valueOf(string) + "." + tec3 + "." + aVtgYr);
                tecYrInvList.add(tecVector2);
                logger.debug((Object)("tecYrInvList:" + string + "." + tec3 + "." + aVtgYr));
                Vector<Integer> vtgVector = this.getVector(String.valueOf(string) + "." + tec3 + "." + aVtgYr);
                int n5 = 1;
                if (tecLifetime.keySet().contains(vtgVector)) {
                    n5 = (Integer)tecLifetime.get(vtgVector);
                }
                Iterator iterator2 = years.iterator();
                while (iterator2.hasNext()) {
                    int aActYr = (Integer)iterator2.next();
                    if (aVtgYr > aActYr || (Integer)prevYearMapInt.get(aActYr) >= (Integer)prevYearMapInt.get(aVtgYr) + n5) continue;
                    Vector<Integer> vector = this.getVector(String.valueOf(string) + "." + tec3 + "." + aActYr);
                    tecYrList.add(vector);
                    if (aActYr >= lYear && !bdc.hasElement(vector)) {
                        bdc.addElement(vector, new Double(0.0), "GWa", "added during SQLite import to represent 'lastyear' before end of model horizon");
                    }
                    logger.debug((Object)("tecYrList:" + string + "." + tec3 + "." + aActYr));
                    Vector<Integer> tecActVector = this.getVector(String.valueOf(string) + "." + tec3 + "." + aVtgYr + "." + aActYr);
                    tecYrActList.add(tecActVector);
                    logger.debug((Object)("tecYrActList:" + string + "." + tec3 + "." + aVtgYr + "." + aActYr));
                }
            }
        }
        aRs2232.close();
        qStmt72.close();
        Parameter interestrate = this.sqliteData.getPar("interestrate");
        for (Integer aYr2 : years) {
            interestrate.addElement("" + aYr2, (Double)0.05, "%");
        }
        Set aCatYearSet = this.sqliteData.getSet("cat_year");
        aCatYearSet.addElement("firstmodelyear." + this.firstModelYear);
        aCatYearSet.addElement("lastmodelyear." + this.lastModelYear);
        logger.info((Object)"merge MESSAGE V 'Variables' into technologies");
        TreeSet<String> pseudotecs = new TreeSet<String>();
        String[] stringArray4 = this.sqliteData.getIndexSetKeys("pseudotechnology");
        int n6 = stringArray4.length;
        int aRs2232 = 0;
        while (aRs2232 < n6) {
            String key4 = stringArray4[aRs2232];
            pseudotecs.add(key4);
            ++aRs2232;
        }
        Set technology = this.sqliteData.getSet("technology");
        for (String tec4 : pseudotecs) {
            technology.addElement(tec4, "merged from pseudotechnology (variable)");
            for (String string : this.sqliteData.nodes) {
                if (!pseudoTecRegSet.contains(String.valueOf(tec4) + "|" + string)) continue;
                int fYear = (Integer)firstlastYearMap.get("firstyear|" + string + "|" + tec4 + "|P");
                int lYear = (Integer)firstlastYearMap.get("lastyear|" + string + "|" + tec4 + "|P");
                Iterator aVtgYr = years.iterator();
                while (aVtgYr.hasNext()) {
                    int aYr3 = (Integer)aVtgYr.next();
                    if (aYr3 < fYear || aYr3 >= lYear) continue;
                    tecYrList.add(this.getVector(String.valueOf(string) + "." + tec4 + "." + aYr3));
                    tecYrActList.add(this.getVector(String.valueOf(string) + "." + tec4 + "." + aYr3 + "." + aYr3));
                }
            }
        }
        Parameter var_cost = this.sqliteData.getPar("var_cost");
        Parameter cost_pseudotec = this.sqliteData.getPar("cost_pseudotec");
        for (Element element : cost_pseudotec.getElements()) {
            Vector<Integer> eleVector3 = element.getVector();
            Vector<Integer> newVector = new Vector<Integer>();
            newVector.add(eleVector3.get(0));
            newVector.add(eleVector3.get(1));
            newVector.add(eleVector3.get(2));
            if (!tecYrList.contains(newVector)) {
                this.sqliteData.addToChangelog("drop parameter value, outside of available-period range", "var_cost", var_cost.getConcatKey(eleVector3));
                logger.info((Object)("drop parameter 'var_cost' for pseudotechnology element " + var_cost.getConcatKey(newVector) + ", outside of period range!"));
                continue;
            }
            newVector.add(eleVector3.get(2));
            newVector.add(this.sqliteData.getKeyId("P"));
            newVector.add(this.sqliteData.getKeyId("year"));
            var_cost.addElement(newVector, element.getValue(), "???", "merged from 'cost' of pseudotechnology (variable)");
        }
        this.sqliteData.removePar("cost_pseudotec");
        HashMap<String, Double> outputScale = new HashMap<String, Double>();
        HashMap<String, Double> inputScale = new HashMap<String, Double>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Set set = this.sqliteData.getSet("cat_tec");
        tecTypeSet.addElement("import");
        tecTypeSet.addElement("export");
        Parameter main_output = this.sqliteData.getPar("main_output");
        Parameter output = this.sqliteData.getPar("output");
        for (Element ele : main_output.getElements()) {
            Vector<Integer> eleVector4 = ele.getVector();
            Double val6 = ele.getValue();
            Vector<Integer> outputVector = new Vector<Integer>();
            outputVector.add(eleVector4.get(0));
            outputVector.add(eleVector4.get(1));
            outputVector.add(eleVector4.get(2));
            if (!tecYrList.contains(outputVector)) continue;
            outputVector.add(eleVector4.get(2));
            outputVector.add(eleVector4.get(3));
            outputVector.add(eleVector4.get(4));
            outputVector.add(eleVector4.get(5));
            outputVector.add(eleVector4.get(6));
            outputVector.add(this.sqliteData.getKeyId("year"));
            outputVector.add(this.sqliteData.getKeyId("year"));
            if (eleVector4.get(0) != eleVector4.get(4)) {
                set.addElement("export." + this.sqliteData.getKeyIdString(eleVector4.get(1)));
            }
            output.addElement(outputVector, val6, this.parUnitMap.get("output"), null);
            if (!ele.getKey("mode").equals("M1")) continue;
            String identifier = String.valueOf(this.sqliteData.getKeyIdString(eleVector4.get(0))) + "." + this.sqliteData.getKeyIdString(eleVector4.get(1)) + "." + this.sqliteData.getKeyIdString(eleVector4.get(2));
            outputScale.put(identifier, val6);
            hashMap.put(identifier, 1.0 / val6);
        }
        Parameter main_input = this.sqliteData.getPar("main_input");
        Parameter input = this.sqliteData.getPar("input");
        for (Element ele : main_input.getElements()) {
            Vector<Integer> eleVector5 = ele.getVector();
            for (Integer aYr4 : years) {
                void var46_186;
                double val7 = ele.getValue();
                if (aYr4 < this.firstModelYear) continue;
                Vector<Integer> inputVector = new Vector<Integer>();
                inputVector.add(eleVector5.get(0));
                inputVector.add(eleVector5.get(1));
                inputVector.add(this.sqliteData.getKeyId(aYr4.toString()));
                if (!tecYrList.contains(inputVector)) {
                    logger.info((Object)("drop 'minp' parameter for " + ele.getConcatKey() + " in year '" + aYr4 + "'!"));
                    continue;
                }
                inputVector.add(this.sqliteData.getKeyId(aYr4.toString()));
                inputVector.add(eleVector5.get(2));
                inputVector.add(eleVector5.get(3));
                inputVector.add(eleVector5.get(4));
                inputVector.add(eleVector5.get(5));
                inputVector.add(this.sqliteData.getKeyId("year"));
                inputVector.add(this.sqliteData.getKeyId("year"));
                input.addElement(inputVector, (Double)val7, this.parUnitMap.get("input"), null);
                if (eleVector5.get(0) != eleVector5.get(3)) {
                    set.addElement("import." + this.sqliteData.getKeyIdString(eleVector5.get(1)));
                }
                if (!ele.getKey("mode").equals("M1")) continue;
                String identifier = String.valueOf(this.sqliteData.getKeyIdString(eleVector5.get(0))) + "." + this.sqliteData.getKeyIdString(eleVector5.get(1));
                inputScale.put(identifier, val7);
                identifier = String.valueOf(identifier) + aYr4;
                Double d = new Double(val7);
                if (outputScale.keySet().contains(identifier)) {
                    Double d2 = val7 / (Double)outputScale.get(identifier);
                }
                hashMap.put(identifier, var46_186);
            }
        }
        this.sqliteData.removePar("main_input");
        this.sqliteData.removePar("main_output");
        logger.info((Object)"merged main inputs and outputs into default input and output parameter");
        int keyM1 = this.sqliteData.getKeyId("M1");
        int keyUp = this.sqliteData.getKeyId("up");
        int keyLo = this.sqliteData.getKeyId("lo");
        int keyConst = this.sqliteData.addKey("const");
        int keyGrowth = this.sqliteData.addKey("growth");
        Parameter bounds_new_capacity = this.sqliteData.getPar("bounds_new_capacity");
        Parameter bound_new_capacity_up = this.sqliteData.getPar("bound_new_capacity_up");
        Parameter bound_new_capacity_lo = this.sqliteData.getPar("bound_new_capacity_lo");
        for (Element element : bounds_new_capacity.getElements()) {
            Vector<Integer> vector;
            Vector<Integer> bdcVector;
            Double val4 = element.getValue();
            if (val4 == 99999.0 || val4 == 999999.0 || !(val4 >= 0.0) || val4.isInfinite() || !tecYrList.contains(bdcVector = this.getTecVector(vector = element.getVector()))) continue;
            if (vector.get(3) == keyUp) {
                bound_new_capacity_up.addElement(bdcVector, val4, this.parUnitMap.get("bounds_new_capacity"), "derived from 'bdc' during import from sqlite");
                continue;
            }
            if (vector.get(3) != keyLo || !(val4 > 0.0)) continue;
            bound_new_capacity_lo.addElement(bdcVector, val4, this.parUnitMap.get("bounds_new_capacity"), "derived from 'bdc' during import from sqlite");
        }
        this.sqliteData.removePar("bounds_new_capacity");
        Parameter bounds_total_capacity = this.sqliteData.getPar("bounds_total_capacity");
        Parameter bound_total_capacity_up = this.sqliteData.getPar("bound_total_capacity_up");
        Parameter bound_total_capacity_lo = this.sqliteData.getPar("bound_total_capacity_lo");
        for (Element element : bounds_total_capacity.getElements()) {
            Vector<Integer> vector;
            Vector<Integer> bdiVector;
            Double val3 = element.getValue();
            if (val3 <= 0.0 || val3.isInfinite() || val3 == 99999.0 || val3 == 999999.0 || !tecYrList.containsAll(bdiVector = this.getTecVector(vector = element.getVector()))) continue;
            if (vector.get(3) == keyUp) {
                bound_total_capacity_up.addElement(bdiVector, val3, this.parUnitMap.get("bound_total_capacity_up"), "derived from 'bdi' during import from sqlite");
                continue;
            }
            if (!vector.get(3).equals(this.sqliteData.getKeyId("lo")) || !(val3 > 0.0)) continue;
            bound_total_capacity_lo.addElement(bdiVector, val3, this.parUnitMap.get("bound_total_capacity_lo"), "derived from 'bdi' during import from sqlite");
        }
        this.sqliteData.removePar("bounds_total_capacity");
        Parameter bound_activity_up = this.sqliteData.getPar("bound_activity_up");
        Parameter bound_activity_lo = this.sqliteData.getPar("bound_activity_lo");
        for (Element ele : parameter.getElements()) {
            Vector<Integer> vector;
            Double val3 = ele.getValue();
            if (val3 > 0.0 && val3.isInfinite() || val3 == 99999.0 || val3 == 999999.0 || !tecYrList.contains(vector = this.getTecVector((Vector<Integer>)((Object)(eleVector = ele.getVector()))))) continue;
            vector.add((Integer)((Vector)((Object)eleVector)).get(3));
            vector.add(this.sqliteData.getKeyId("year"));
            if ((Integer)((Vector)((Object)eleVector)).get(4) == keyUp && !val3.isInfinite()) {
                bound_activity_up.addElement(vector, val3, this.parUnitMap.get("bound_activity_up"), "derived from 'bda' during import from sqlite");
                logger.info((Object)("adding upper bound for activity: " + ele.getConcatKey()));
                continue;
            }
            if ((Integer)((Vector)((Object)eleVector)).get(4) != keyLo || val3 == 0.0 || this.sqliteData.getKeyIdString((Integer)((Vector)((Object)eleVector)).get(1)).startsWith("BIO0")) continue;
            if (val3.isInfinite() || val3 <= -100000.0) {
                bound_activity_lo.addElement(vector, (Double)Double.NEGATIVE_INFINITY, this.parUnitMap.get("bound_activity_lo"), "derived from bda during import from sqlite");
                logger.info((Object)("adding upper bound for activity: " + ele.getConcatKey()));
                continue;
            }
            bound_activity_lo.addElement(vector, val3, this.parUnitMap.get("bound_activity_lo"), "derived from 'bda' during import from sqlite");
            logger.info((Object)("adding upper bound for activity: " + ele.getConcatKey()));
        }
        Object var23_51 = null;
        this.sqliteData.removePar("bounds_activity");
        Parameter upper_bound = this.sqliteData.getPar("upper_bound");
        for (Element element : upper_bound.getElements()) {
            eleVector = element.getVector();
            Double d = element.getValue();
            if (d.isInfinite()) continue;
            String identifier = this.getYearMapIdentifier(element, "P");
            int fYear = (Integer)firstlastYearMap.get("firstyear|" + identifier);
            int lYear = (Integer)firstlastYearMap.get("lastyear|" + identifier);
            int aYear = Integer.parseInt(element.getKey(2));
            if (fYear > aYear || aYear >= lYear) continue;
            Vector<Integer> bdaVector = this.getTecVector((Vector<Integer>)((Object)eleVector));
            bdaVector.add(this.sqliteData.getKeyId("P"));
            bdaVector.add(this.sqliteData.getKeyId("year"));
            bound_activity_up.addElement(bdaVector, d, this.parUnitMap.get("bound_activity_up"), "merged from 'upper bound' of pseudotechnology (variable)");
        }
        upper_bound = null;
        this.sqliteData.removePar("upper_bound");
        Parameter parameter2 = this.sqliteData.getPar("lower_bound");
        for (Element ele : parameter2.getElements()) {
            Vector<Integer> vector = ele.getVector();
            Double val9 = ele.getValue();
            String identifier = this.getYearMapIdentifier(ele, "P");
            int fYear = (Integer)firstlastYearMap.get("firstyear|" + identifier);
            int lYear = (Integer)firstlastYearMap.get("lastyear|" + identifier);
            int aYear = Integer.parseInt(ele.getKey(2));
            if (fYear > aYear || aYear >= lYear) continue;
            Vector<Integer> bdaVector = this.getTecVector(vector);
            bdaVector.add(this.sqliteData.getKeyId("P"));
            bdaVector.add(this.sqliteData.getKeyId("year"));
            bound_activity_lo.addElement(bdaVector, val9, this.parUnitMap.get("bound_activity_lo"), "merged from 'lower bound' of pseudotechnology (variable)");
        }
        Object var43_140 = null;
        this.sqliteData.removePar("lower_bound");
        logger.info((Object)"cleaned all bound parameters");
        Parameter initial_new_capacity_up = this.sqliteData.getPar("initial_new_capacity_up");
        Parameter initial_new_capacity_lo = this.sqliteData.getPar("initial_new_capacity_lo");
        Parameter growth_new_capacity_up = this.sqliteData.getPar("growth_new_capacity_up");
        Parameter parameter3 = this.sqliteData.getPar("growth_new_capacity_lo");
        Parameter mpc = this.sqliteData.getPar("market_penetration_new_capacity");
        for (Element ele : mpc.getElements()) {
            Vector<Integer> eleVector6;
            Vector<Integer> mpcTecVector;
            int aYear = Integer.parseInt(ele.getKey(2));
            if (aYear == 1990 || !tecYrInvList.contains(mpcTecVector = this.getTecVector(eleVector6 = ele.getVector()))) continue;
            Double val10 = ele.getValue();
            if (eleVector6.get(3) == keyUp && eleVector6.get(4) == keyConst && val10 < 100.0) {
                initial_new_capacity_up.addElement(mpcTecVector, val10, this.parUnitMap.get("initial_new_capacity_up"), "derived from 'mpc' during import from sqlite");
                continue;
            }
            if (initial_new_capacity_up.hasElement(mpcTecVector) && eleVector6.get(3) == keyUp && eleVector6.get(4) == keyGrowth) {
                if (val10 < 100.0) {
                    val10 = val10 - 1.0;
                    growth_new_capacity_up.addElement(mpcTecVector, val10, this.parUnitMap.get("growth_new_capacity_up"), "derived from 'mpc' during import from sqlite");
                    continue;
                }
                initial_new_capacity_up.removeElement(mpcTecVector);
                continue;
            }
            if (eleVector6.get(3) == keyLo && eleVector6.get(4) == keyConst && val10 < 100.0) {
                initial_new_capacity_lo.addElement(mpcTecVector, val10, this.parUnitMap.get("initial_new_capacity_lo"), "derived from 'mpc' during import from sqlite");
                continue;
            }
            if (!initial_new_capacity_lo.hasElement(mpcTecVector) || eleVector6.get(3) != keyLo || eleVector6.get(4) != keyGrowth) continue;
            if (val10 < 100.0) {
                val10 = val10 - 1.0;
                parameter3.addElement(mpcTecVector, val10, this.parUnitMap.get("growth_new_capacity_lo"), "derived from 'mpc' during import from sqlite");
                continue;
            }
            initial_new_capacity_lo.removeElement(mpcTecVector);
        }
        mpc = null;
        this.sqliteData.removePar("market_penetration_new_capacity");
        Parameter initial_activity_up = this.sqliteData.getPar("initial_activity_up");
        Parameter initial_activity_lo = this.sqliteData.getPar("initial_activity_lo");
        Parameter growth_activity_up = this.sqliteData.getPar("growth_activity_up");
        Parameter parameter4 = this.sqliteData.getPar("growth_activity_lo");
        Parameter mpa = this.sqliteData.getPar("market_penetration_activity");
        for (Element ele : mpa.getElements()) {
            int aYear = Integer.parseInt(ele.getKey(2));
            Vector<Integer> eleVector7 = ele.getVector();
            if (aYear == 1990 || aYear == 2008 || eleVector7.get(3) != keyM1 || !tecYrList.contains(this.getTecVector(eleVector7))) continue;
            Double val11 = ele.getValue();
            Vector<Integer> mpaTecVector = this.getTecVector(eleVector7);
            mpaTecVector.add(this.sqliteData.getKeyId("year"));
            if (eleVector7.get(4) == keyUp && eleVector7.get(5) == keyConst) {
                if (val11.isInfinite()) continue;
                initial_activity_up.addElement(mpaTecVector, val11, this.parUnitMap.get("initial_activity_up"), "derived from 'mpa' during import from sqlite");
                continue;
            }
            if (initial_activity_up.hasElement(mpaTecVector) && eleVector7.get(4) == keyUp && eleVector7.get(5) == keyGrowth) {
                if (!val11.isInfinite()) {
                    val11 = val11 - 1.0;
                    growth_activity_up.addElement(mpaTecVector, val11, this.parUnitMap.get("growth_activity_up"), "derived from 'mpa' during import from sqlite");
                    continue;
                }
                initial_activity_up.removeElement(mpaTecVector);
                continue;
            }
            if (eleVector7.get(4) == keyLo && eleVector7.get(5) == keyConst) {
                if (val11.isInfinite()) continue;
                initial_activity_lo.addElement(mpaTecVector, val11, this.parUnitMap.get("initial_activity_lo"), "derived from 'mpa' during import from sqlite");
                continue;
            }
            if (!initial_activity_lo.hasElement(mpaTecVector) || eleVector7.get(4) != keyLo || eleVector7.get(5) != keyGrowth) continue;
            if (!val11.isInfinite()) {
                val11 = val11 - 1.0;
                parameter4.addElement(mpaTecVector, val11, this.parUnitMap.get("growth_activity_lo"), "derived from 'mpa' during import from sqlite");
                continue;
            }
            initial_activity_lo.removeElement(mpaTecVector);
        }
        mpa = null;
        this.sqliteData.removePar("market_penetration_activity");
        logger.info((Object)"cleaned all dynamic market penetration parameters");
        Parameter input2 = this.sqliteData.getPar("input");
        LinkedList<Element> dropInputEle = new LinkedList<Element>();
        for (Element ele : input2.getElements()) {
            Object val4 = ele.getValue();
            eleVector = ele.getVector();
            String string = String.valueOf(this.sqliteData.getKeyIdString((Integer)((Vector)((Object)eleVector)).get(0))) + "." + this.sqliteData.getKeyIdString((Integer)((Vector)((Object)eleVector)).get(1)) + "." + this.sqliteData.getKeyIdString((Integer)((Vector)((Object)eleVector)).get(2));
            if (outputScale.keySet().contains(string)) {
                val4 = (Double)val4 / (Double)outputScale.get(string);
                input2.addElement((Vector<Integer>)((Object)eleVector), (Double)val4, this.parUnitMap.get("input"), null);
            }
            if (tecYrList.contains(this.getTecVector((Vector<Integer>)((Object)eleVector)))) continue;
            dropInputEle.add(ele);
        }
        int i3 = 0;
        for (Element element : dropInputEle) {
            input2.removeElement(element);
            ++i3;
        }
        logger.info((Object)(" dropped " + i3 + " elements from parameter 'input' (outside of technology availability horizon)!"));
        HashMap<Vector<Integer>, Double> hashMap2 = new HashMap<Vector<Integer>, Double>();
        for (Element ele : input2.getElements()) {
            Vector<Integer> vector = ele.getVector();
            Vector<Integer> tecVector3 = this.getTecVector(vector);
            if (!tecLifetime.containsKey(tecVector3)) continue;
            Double val12 = ele.getValue();
            for (Integer aYr5 : years) {
                Integer aYrKey3 = this.sqliteData.getKeyId("" + aYr5);
                if (!tecYrActList.contains(this.getTecActVector(vector, aYrKey3))) continue;
                Vector<Integer> newInputVector = ele.getClonedVector();
                newInputVector.set(2, aYrKey3);
                hashMap2.put(newInputVector, val12);
            }
        }
        for (Vector eleVector8 : hashMap2.keySet()) {
            input2.addElement(eleVector8, (Double)hashMap2.get(eleVector8), this.parUnitMap.get("input"), null);
        }
        LinkedList<Element> dropOutputEle = new LinkedList<Element>();
        Parameter output2 = this.sqliteData.getPar("output");
        for (Element element : output2.getElements()) {
            Double val13 = element.getValue();
            Vector<Integer> eleVector9 = element.getVector();
            String identifier = String.valueOf(this.sqliteData.getKeyIdString(eleVector9.get(0))) + "." + this.sqliteData.getKeyIdString(eleVector9.get(1)) + "." + this.sqliteData.getKeyIdString(eleVector9.get(2));
            if (outputScale.keySet().contains(identifier)) {
                if (val13 != 0.0) {
                    val13 = val13 / (Double)outputScale.get(identifier);
                }
                output2.addElement(eleVector9, val13, this.parUnitMap.get("output"), null);
            }
            if (tecYrList.contains(this.getTecVector(eleVector9))) continue;
            dropOutputEle.add(element);
        }
        i3 = 0;
        for (Element element : dropOutputEle) {
            output2.removeElement(element);
            ++i3;
        }
        logger.info((Object)(" dropped " + i3 + " elements from parameter 'output' (outside of technology availability horizon)!"));
        HashMap<Vector<Integer>, Double> hashMap3 = new HashMap<Vector<Integer>, Double>();
        for (Element ele : output2.getElements()) {
            Vector<Integer> eleVector10 = ele.getVector();
            Vector<Integer> tecVector4 = this.getTecVector(eleVector10);
            if (!tecLifetime.containsKey(tecVector4)) continue;
            Double val22 = ele.getValue();
            for (Integer aYr6 : years) {
                Integer aYrKey2 = this.sqliteData.getKeyId("" + aYr6);
                if (!tecYrActList.contains(this.getTecActVector(eleVector10, aYrKey2))) continue;
                Vector<Integer> newOutputVector = ele.getClonedVector();
                newOutputVector.set(2, aYrKey2);
                hashMap3.put(newOutputVector, val22);
                logger.debug((Object)("extending technology output for: " + output2.getConcatKey(newOutputVector)));
            }
        }
        for (Object eleVector11 : hashMap3.keySet()) {
            output2.addElement((Vector<Integer>)eleVector11, (Double)hashMap3.get(eleVector11), this.parUnitMap.get("output"), null);
        }
        logger.info((Object)"extended input and output parameters across vintage and lifetime");
        LinkedList<Element> dropFactor = new LinkedList<Element>();
        Parameter aPar3 = this.sqliteData.getPar("min_utilization_factor");
        for (Element ele : aPar3.getElements()) {
            if (ele.getValue() != 0.0) continue;
            dropFactor.add(ele);
        }
        for (Element rEle : dropFactor) {
            aPar3.removeElement(rEle);
        }
        LinkedHashMap<Vector<Integer>, Double> newCapacityFactor = new LinkedHashMap<Vector<Integer>, Double>();
        Parameter capacity_factor = this.sqliteData.getPar("capacity_factor");
        for (Element ele : capacity_factor.getElements()) {
            Vector<Integer> tecVector5 = this.getTecVector(ele.getVector());
            if (!tecLifetime.containsKey(tecVector5)) continue;
            Double val14 = ele.getValue();
            for (Integer n7 : years) {
                Integer aYrKey4 = this.sqliteData.getKeyId("" + n7);
                if (!tecYrActList.contains(this.getTecActVector(ele.getVector(), aYrKey4))) continue;
                Vector<Integer> newCapFacVector = ele.getClonedVector();
                newCapFacVector.set(2, aYrKey4);
                newCapacityFactor.put(newCapFacVector, val14);
            }
        }
        for (Vector ele : newCapacityFactor.keySet()) {
            capacity_factor.addElement(ele, (Double)newCapacityFactor.get(ele), this.parUnitMap.get("capacity_factor"), null);
        }
        String[] stringArray5 = parList = new String[]{"operation_factor", "min_utilization_factor"};
        int val14 = parList.length;
        int tecVector5 = 0;
        while (tecVector5 < val14) {
            String string = stringArray5[tecVector5];
            LinkedHashMap<Vector<Integer>, Double> newFactor = new LinkedHashMap<Vector<Integer>, Double>();
            Parameter aPar4 = this.sqliteData.getPar(string);
            for (Element ele : aPar4.getElements()) {
                tecVector = this.getTecVector(ele.getVector());
                if (!tecLifetime.containsKey(tecVector)) continue;
                val2 = ele.getValue();
                for (Integer aYr8 : years) {
                    aYrKey = this.sqliteData.getKeyId("" + aYr8);
                    if (!tecYrActList.contains(this.getTecActVector(ele.getVector(), aYrKey))) continue;
                    newFacVector = ele.getClonedVector();
                    newFacVector.set(2, aYrKey);
                    newFactor.put(newFacVector, val2);
                }
            }
            for (Vector eleVector12 : newFactor.keySet()) {
                aPar4.addElement(eleVector12, (Double)newFactor.get(eleVector12), this.parUnitMap.get(string), null);
            }
            ++tecVector5;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Parameter fix_cost = this.sqliteData.getPar("fix_cost");
        for (Element ele : fix_cost.getElements()) {
            Vector eleVector2 = ele.getVector();
            Iterator val5 = ele.getValue();
            Vector<Integer> tecVector6 = this.getTecVector(eleVector2);
            if (!tecLifetime.containsKey(tecVector6)) continue;
            tecVector = years.iterator();
            while (tecVector.hasNext()) {
                Integer aYr9 = (Integer)tecVector.next();
                Integer aYrKey5 = this.sqliteData.getKeyId("" + aYr9);
                if (!tecYrActList.contains(this.getTecActVector(ele.getVector(), aYrKey5))) continue;
                Vector<Integer> newVector = ele.getClonedVector();
                newVector.set(2, aYrKey5);
                linkedHashMap.put(newVector, val5);
            }
        }
        for (Vector eleVector13 : linkedHashMap.keySet()) {
            fix_cost.addElement(eleVector13, (Double)linkedHashMap.get(eleVector13), this.parUnitMap.get("fix_cost"), null);
        }
        LinkedHashMap<Vector<Integer>, Double> newVarCostList = new LinkedHashMap<Vector<Integer>, Double>();
        Parameter parameter5 = this.sqliteData.getPar("var_cost");
        for (Element ele : parameter5.getElements()) {
            Vector<Integer> eleVector14 = ele.getVector();
            Double val15 = ele.getValue();
            if (val15.isInfinite()) {
                parameter5.addElement(eleVector14, new Double(9000000.0), this.parUnitMap.get("var_cost"), "scaled down during import from SQLite to avoid infinity");
            }
            if (!tecLifetime.containsKey(tecVector = this.getTecVector(eleVector14))) continue;
            for (Integer aYr : years) {
                Integer aYrKey2 = this.sqliteData.getKeyId("" + aYr);
                if (!tecYrActList.contains(this.getTecActVector(ele.getVector(), aYrKey2))) continue;
                Vector<Integer> newVector = ele.getClonedVector();
                newVector.set(2, aYrKey2);
                newVarCostList.put(newVector, val15);
            }
        }
        for (Vector eleVector2 : newVarCostList.keySet()) {
            parameter5.addElement(eleVector2, (Double)newVarCostList.get(eleVector2), this.parUnitMap.get("var_cost"), null);
        }
        logger.info((Object)"extended other technology parameters across vintage and lifetime");
        Set catTypeEmissionSet = this.sqliteData.getSet("type_emission");
        Set aSet2 = this.sqliteData.getSet("cat_emission");
        for (String em : this.sqliteData.emissions) {
            catTypeEmissionSet.addElement(em);
            aSet2.addElement(String.valueOf(em) + "." + em);
        }
        catTypeEmissionSet.addElement("totalCe");
        catTypeEmissionSet.addElement("totalCO2e");
        tecTypeSet.addElement("bunkers");
        tecTypeSet.addElement("non_energy");
        tecTypeSet.addElement("landuse");
        Parameter emission_factor = this.sqliteData.getPar("emission_factor");
        Parameter parameter6 = this.sqliteData.getPar("emission_scaling");
        Parameter con1a = this.sqliteData.getPar("con1a");
        Parameter con1a_pseudotec = this.sqliteData.getPar("con1a_pseudotec");
        Parameter parameter7 = this.sqliteData.getPar("con2a");
        Parameter con2a_pseudotec = this.sqliteData.getPar("con2a_pseudotec");
        for (Element ele : parameter7.getElements()) {
            String[] fld = ele.getKey();
            val = ele.getValue();
            if (fld[4].equals("TCE_regional") && this.sqliteData.emissions.contains(fld[1].replaceAll("_TCE", ""))) {
                for (Integer aId : this.sqliteData.getIndexSetKeyIds("emission")) {
                    Iterator aEmission = this.sqliteData.getKeyIdString(aId);
                    catTypeEmissionSet.addElement((String)((Object)aEmission));
                    aSet2.addElement("totalCe." + fld[1].replaceAll("_TCE", ""));
                    aSet2.addElement("totalCO2e." + fld[1].replaceAll("_TCE", ""));
                }
                String key22 = "totalCe." + fld[1].replaceAll("_TCE", "");
                parameter6.addElement(key22, val, this.parUnitMap.get("emission_scaling"), "derived from 'con2a' during import from sqlite");
                key22 = "totalCO2e." + fld[1].replaceAll("_TCE", "");
                double valCO2 = val / 3.667;
                parameter6.addElement(key22, (Double)valCO2, this.parUnitMap.get("emission_scaling"), "derived from 'con2a' during import from sqlite");
                continue;
            }
            if (!this.sqliteData.tecs.contains(fld[1])) continue;
            if (fld[4].endsWith("bunkers")) {
                tecCatSet.addElement("bunkers." + fld[1]);
            }
            if (fld[4].endsWith("_nonenergy")) {
                tecCatSet.addElement("non_energy." + fld[1]);
            }
            if (fld[4].endsWith("_Emission") && !fld[1].endsWith("_TCE")) {
                String em = fld[4].replaceAll("_Emission", "");
                if (this.sqliteData.emissions.contains(em)) {
                    String key5 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + "." + em;
                    emission_factor.addElement(key5, val, this.parUnitMap.get("emission_factor"), "derived from 'con2a' during import from sqlite");
                    continue;
                }
                logger.error((Object)(" drop emission factor for type " + em));
                continue;
            }
            if (fld[4].equals("CO2_r_c")) {
                key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".CO2_res_com";
                emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con2a' during import from sqlite");
                continue;
            }
            if (fld[4].equals("CO2_trp")) {
                key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".CO2_transport";
                emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con2a' during import from sqlite");
                continue;
            }
            if (fld[4].equals("CO2_cc")) {
                key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".CO2_transformation";
                emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con2a' during import from sqlite");
                continue;
            }
            if (!fld[4].equals("CO2_ind")) continue;
            key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".CO2_industry";
            emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con2a' during import from sqlite");
        }
        for (Element ele : con1a.getElements()) {
            String[] fld = ele.getKey();
            val = ele.getValue();
            if (fld[1].startsWith("BIO")) {
                tecCatSet.addElement("landuse." + fld[1]);
                if (fld[4].equals("CH4l")) {
                    val = val * 1.0 / 21.0 * 1000.0;
                    key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".CH4_landuse";
                    emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con1a' during import from sqlite");
                } else if (fld[4].equals("N2Ol")) {
                    val = val * 1.0 / 310.0 * 1000.0;
                    key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".N2O_landuse";
                    emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con1a' during import from sqlite");
                }
                if (!fld[4].equals("CO2l")) continue;
                val = val * 44.0 / 12.0;
                key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + ".CO2_landuse";
                emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con1a' during import from sqlite");
                continue;
            }
            if (!this.sqliteData.emissions.contains(fld[4]) || fld[1].endsWith("_TCE")) continue;
            key2 = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + "." + fld[3] + "." + fld[4];
            emission_factor.addElement(key2, val, this.parUnitMap.get("emission_factor"), "derived from 'con1a' during import from sqlite");
            if (!fld[4].endsWith("bunkers")) continue;
            tecCatSet.addElement("bunkers." + fld[1]);
        }
        for (Element ele : con2a_pseudotec.getElements()) {
            String[] fld = ele.getKey();
            if (!this.sqliteData.emissions.contains(fld[3]) || fld[1].endsWith("_TCE")) continue;
            key = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + ".P." + fld[3];
            emission_factor.addElement(key, ele.getValue(), this.parUnitMap.get("emission_factor"), "derived from 'con2a_pseudotec' during import from sqlite");
        }
        for (Element ele : con1a_pseudotec.getElements()) {
            String[] fld = ele.getKey();
            if (!this.sqliteData.emissions.contains(fld[3]) || fld[1].endsWith("_TCE")) continue;
            key = String.valueOf(fld[0]) + "." + fld[1] + "." + fld[2] + "." + fld[2] + ".P." + fld[3];
            emission_factor.addElement(key, ele.getValue(), this.parUnitMap.get("emission_factor"), "derived from 'con1a_pseudotec' during import from sqlite");
        }
        LinkedHashMap<Vector<Integer>, Double> newFactor = new LinkedHashMap<Vector<Integer>, Double>();
        for (Element ele : emission_factor.getElements()) {
            tecVector72 = this.getTecVector(ele.getVector());
            if (!tecLifetime.containsKey(tecVector72)) continue;
            val2 = ele.getValue();
            for (Integer aYr10 : years) {
                aYrKey = this.sqliteData.getKeyId("" + aYr10);
                if (!tecYrActList.contains(this.getTecActVector(ele.getVector(), aYrKey))) continue;
                newFacVector = ele.getClonedVector();
                newFacVector.set(2, aYrKey);
                newFactor.put(newFacVector, val2);
            }
        }
        for (Vector eleVector15 : newFactor.keySet()) {
            emission_factor.addElement(eleVector15, (Double)newFactor.get(eleVector15), "???", null);
        }
        Set relations = this.sqliteData.getSet("relation");
        Iterator relation_upper = this.sqliteData.getPar("relation_upper");
        Parameter relation_lower = this.sqliteData.getPar("relation_lower");
        Parameter parameter8 = this.sqliteData.getPar("relation_cost");
        Parameter relation_new_capacity = this.sqliteData.getPar("relation_new_capacity");
        Parameter relation_total_capacity = this.sqliteData.getPar("relation_total_capacity");
        Parameter parameter9 = this.sqliteData.getPar("relation_activity");
        String[] conXcList = new String[]{"con1c", "con2c"};
        tecVector72 = conXcList;
        int fld = conXcList.length;
        int eleVector15 = 0;
        while (eleVector15 < fld) {
            String aConXc = tecVector72[eleVector15];
            conXc232 = this.sqliteData.getPar(aConXc);
            for (Element ele : conXc232.getElements()) {
                Object val16 = ele.getValue();
                if ((Double)val16 == 0.0 || ((Double)val16).isInfinite()) continue;
                String[] fld2 = ele.getKey();
                if (!tecYrInvList.contains(this.getTecVector(ele.getVector()))) continue;
                boolean isTotalCap = false;
                if (fld2[3].contains(":tin") || fld2[3].contains(":tic")) {
                    isTotalCap = true;
                    fld2[3] = fld2[3].replaceAll("[:]tin", "");
                    fld2[3] = fld2[3].replaceAll("[:]tic", "");
                }
                if (this.mRelRelioMap.get(String.valueOf(fld2[3]) + "|" + fld2[0]).equals("i") && hashMap.keySet().contains(String.valueOf(fld2[0]) + "." + fld2[1] + "." + fld2[2])) {
                    val16 = (Double)val16 * (Double)hashMap.get(String.valueOf(fld2[0]) + "." + fld2[1] + "." + fld2[2]);
                }
                this.validRelations.add(String.valueOf(fld2[3]) + "." + fld2[0] + "." + fld2[2]);
                relations.addElement(fld2[3]);
                if (!this.mRelRelioMap.keySet().contains(String.valueOf(fld2[3]) + "|" + fld2[0]) && !this.mRelRelioMap.keySet().contains(String.valueOf(fld2[3]) + "|" + regSuffix + GLBregion)) {
                    logger.error((Object)("there is a conXc relation writing to '" + GLBregion + "': " + fld2[3] + "|" + fld2[0]));
                }
                if (isTotalCap) {
                    relation_total_capacity.addElement(String.valueOf(fld2[3]) + "." + fld2[0] + "." + fld2[2] + "." + fld2[1], (Double)val16, "???", "derived from '" + aConXc + "' element");
                    continue;
                }
                relation_new_capacity.addElement(String.valueOf(fld2[3]) + "." + fld2[0] + "." + fld2[2] + "." + fld2[1], (Double)val16, "???", "derived from '" + aConXc + "' element");
            }
            conXc232 = null;
            this.sqliteData.removePar(aConXc);
            ++eleVector15;
        }
        conXc232 = conXaList = new String[]{"con1a", "con2a"};
        int tecVector72 = conXaList.length;
        fld = 0;
        while (fld < tecVector72) {
            String aConXa = conXc232[fld];
            Parameter conXa232 = this.sqliteData.getPar(aConXa);
            for (Element ele : conXa232.getElements()) {
                Object val17 = ele.getValue();
                if ((Double)val17 == 0.0 || ((Double)val17).isInfinite()) continue;
                String[] fld3 = ele.getKey();
                if (!tecYrList.contains(this.getTecVector(ele.getVector()))) continue;
                String targetRegion = fld3[0];
                if (fld3[4].endsWith("Brasil")) {
                    targetRegion = "Brazil";
                    fld3[4] = fld3[4].substring(0, 4);
                }
                if (this.mRelRelioMap.keySet().contains(String.valueOf(fld3[4]) + "|" + fld3[0])) {
                    if (this.mRelRelioMap.get(String.valueOf(fld3[4]) + "|" + fld3[0]).equals("i") && hashMap.keySet().contains(String.valueOf(fld3[0]) + "." + fld3[1] + "." + fld3[2])) {
                        val17 = (Double)val17 * (Double)hashMap.get(String.valueOf(fld3[0]) + "." + fld3[1] + "." + fld3[2]);
                    }
                    this.validRelations.add(String.valueOf(fld3[4]) + "." + fld3[0] + "." + fld3[2]);
                    relations.addElement(fld3[4]);
                    if (fld3[4].equals("conv2PlaF1")) {
                        if (fld3[2].equals("2020") || (Integer)firstlastYearMap.get("firstyear|" + fld3[0] + "|" + fld3[1] + "|M1") == Integer.parseInt(fld3[2])) continue;
                        parameter9.addElement(String.valueOf(fld3[4]) + "." + fld3[0] + "." + fld3[2] + "." + fld3[0] + "." + fld3[1] + "." + (String)prevYearMap.get(fld3[2]) + "." + fld3[3], (Double)val17, "???", "derived from '" + aConXa + "' element");
                        continue;
                    }
                    parameter9.addElement(String.valueOf(fld3[4]) + "." + targetRegion + "." + fld3[2] + "." + fld3[0] + "." + fld3[1] + "." + fld3[2] + "." + fld3[3], (Double)val17, "???", "derived from '" + aConXa + "' element");
                    continue;
                }
                if (!this.mRelRelioMap.keySet().contains(String.valueOf(fld3[4]) + "|" + regSuffix + GLBregion)) continue;
                if (this.mRelRelioMap.get(String.valueOf(fld3[4]) + "|" + regSuffix + GLBregion).equals("i") && hashMap.keySet().contains(String.valueOf(fld3[0]) + "." + fld3[1] + "." + fld3[2])) {
                    val17 = (Double)val17 * (Double)hashMap.get(String.valueOf(fld3[0]) + "." + fld3[1] + "." + fld3[2]);
                } else if (this.mRelRelioMap.get(String.valueOf(fld3[4]) + "|" + regSuffix + GLBregion).equals("i") && hashMap.keySet().contains(String.valueOf(regSuffix) + GLBregion + "." + fld3[1] + "." + fld3[2])) {
                    val17 = (Double)val17 * (Double)hashMap.get(String.valueOf(regSuffix) + GLBregion + "." + fld3[1] + "." + fld3[2]);
                }
                this.validRelations.add(String.valueOf(fld3[4]) + "." + regSuffix + GLBregion + "." + fld3[2]);
                relations.addElement(fld3[4]);
                parameter9.addElement(String.valueOf(fld3[4]) + "." + regSuffix + GLBregion + "." + fld3[2] + "." + fld3[0] + "." + fld3[1] + "." + fld3[2] + "." + fld3[3], (Double)val17, "???", "derived from '" + aConXa + "' element");
            }
            conXa232 = null;
            this.sqliteData.removePar(aConXa);
            ++fld;
        }
        String[] conXa232 = conXaPseudotecList = new String[]{"con1a_pseudotec", "con2a_pseudotec"};
        int conXc232 = conXaPseudotecList.length;
        tecVector72 = 0;
        while (tecVector72 < conXc232) {
            String aConXaPseudo = conXa232[tecVector72];
            conXa_pseudotec = this.sqliteData.getPar(aConXaPseudo);
            for (Element ele : conXa_pseudotec.getElements()) {
                Double val18 = ele.getValue();
                if (val18 == 0.0 || val18.isInfinite()) continue;
                String[] fld4 = ele.getKey();
                if (!tecYrList.contains(this.getTecVector(ele.getVector()))) continue;
                this.validRelations.add(String.valueOf(fld4[3]) + "." + fld4[0] + "." + fld4[2]);
                relations.addElement(fld4[3]);
                parameter9.addElement(String.valueOf(fld4[3]) + "." + fld4[0] + "." + fld4[2] + "." + fld4[0] + "." + fld4[1] + "." + fld4[2] + ".P", val18, "???", "derived from '" + aConXaPseudo + "' element (in 'variables' section in MESSAGE V)");
            }
            conXa_pseudotec = null;
            this.sqliteData.removePar(aConXaPseudo);
            ++tecVector72;
        }
        conXa_pseudotec = relevantRel = new String[]{"rel1", "rel2"};
        int conXa232 = relevantRel.length;
        conXc232 = 0;
        while (conXc232 < conXa232) {
            String relCfg = conXa_pseudotec[conXc232];
            Parameter righthandside = this.sqliteData.getPar("righthandside_" + relCfg);
            for (Element ele : righthandside.getElements()) {
                Double val19 = ele.getValue();
                if (!(val19 < 100000.0)) continue;
                String[] fld5 = ele.getKey();
                String newKey = String.valueOf(fld5[1]) + "." + fld5[0] + "." + fld5[2];
                if (this.validRelations.contains(newKey)) {
                    relations.addElement(fld5[1]);
                    if (fld5[3].equals("up")) {
                        ((Parameter)((Object)relation_upper)).addElement(newKey, val19, "???", "derived from 'righthandside' element");
                        continue;
                    }
                    relation_lower.addElement(newKey, val19, "???", "derived from 'righthandside' element");
                    continue;
                }
                logger.info((Object)(" relation 'rhs' parameter dropped " + newKey + ", no multipliers found"));
                this.sqliteData.addToChangelog("dropped during SQLite import", "relations", "parameter rhs " + newKey + " dropped, no multipliers found");
            }
            Parameter range = this.sqliteData.getPar("range_" + relCfg);
            for (Element ele : range.getElements()) {
                Double val20 = ele.getValue();
                if (!(val20 < 100000.0)) continue;
                String[] fld6 = ele.getKey();
                String newKey = String.valueOf(fld6[1]) + "." + fld6[0] + "." + fld6[2];
                Double rhsUp = righthandside.getElement(String.valueOf(fld6[0]) + "." + fld6[1] + "." + fld6[2] + ".up").getValue();
                if (rhsUp.isInfinite()) {
                    logger.debug((Object)(" relation 'rng' parameter dropped for relation '" + newKey + "', righthandside is infinite"));
                    this.sqliteData.addToChangelog("dropped during SQLite import", "relations", "parameter 'rhs' for relation '" + newKey + "' dropped, righthandside is infinite");
                    continue;
                }
                if (this.validRelations.contains(newKey)) {
                    val20 = rhsUp - val20;
                    relations.addElement(fld6[1]);
                    relation_lower.addElement(newKey, val20, "???", "derived from 'range' element");
                    continue;
                }
                logger.debug((Object)(" relation 'rng' parameter dropped for relation '" + newKey + "', no multipliers found"));
                this.sqliteData.addToChangelog("dropped during SQLite import", "relations", "parameter 'rng' for relation '" + newKey + "' dropped, no multipliers found");
            }
            Parameter cost = this.sqliteData.getPar("cost_" + relCfg);
            for (Element ele : cost.getElements()) {
                Double val21 = ele.getValue();
                if (val21 == 0.0) continue;
                String[] fld7 = ele.getKey();
                String newKey = String.valueOf(fld7[1]) + "." + fld7[0] + "." + fld7[2];
                if (this.validRelations.contains(newKey)) {
                    relations.addElement(fld7[1]);
                    parameter8.addElement(newKey, val21, "???", "derived from 'cost' element (in relations)");
                    continue;
                }
                logger.debug((Object)(" relation 'cost' parameter dropped for relation '" + newKey + "', no multipliers found"));
                this.sqliteData.addToChangelog("dropped during SQLite import", "relations", "parameter 'cost'for relation '" + newKey + "' dropped, no multipliers found");
            }
            righthandside = null;
            this.sqliteData.removePar("righthandside_" + relCfg);
            range = null;
            this.sqliteData.removePar("range_" + relCfg);
            cost = null;
            this.sqliteData.removePar("cost_" + relCfg);
            ++conXc232;
        }
        logger.info((Object)"cleaned all relation-related parameters");
        for (String aName : this.sqliteData.tecParList) {
            if (aName.contains("relation")) continue;
            aPar = this.sqliteData.getPar(aName);
            LinkedList<Element> linkedList = new LinkedList<Element>();
            int i4 = 0;
            for (Element ele : aPar.getElements()) {
                if (tecYrList.contains(this.getTecVector(ele.getVector()))) continue;
                linkedList.add(ele);
                ++i4;
            }
            for (Element rEle : linkedList) {
                aPar.removeElement(rEle);
            }
            if (i4 <= 0) continue;
            logger.info((Object)(" removed " + i4 + " parameter elements from parameter " + aPar.getName() + " (outside of technology-year availability)"));
        }
        for (String aName : this.sqliteData.tecActParList) {
            aPar = this.sqliteData.getPar(aName);
            LinkedList<Element> linkedList = new LinkedList<Element>();
            int i5 = 0;
            for (Element ele : aPar.getElements()) {
                if (tecYrActList.contains(this.getTecActVector(ele.getVector()))) continue;
                linkedList.add(ele);
                ++i5;
            }
            for (Element rEle : linkedList) {
                aPar.removeElement(rEle);
            }
            if (i5 <= 0) continue;
            logger.info((Object)(" removed " + i5 + " parameter elements from parameter " + aPar.getName() + " (outside of technology-vintage-year availability)"));
        }
        logger.info((Object)"cleaned all parameter elements outside of technology-vintage availability");
        if (solFile != null) {
            logger.info((Object)"read solution from sol-file");
            HashMap<String, String> regionId = new HashMap<String, String>();
            if (this.sqliteData.nodes.contains("Brazil")) {
                regionId.put(".", "Brazil");
            } else {
                regionId.put(".", String.valueOf(regSuffix) + "GLB");
                regionId.put("a", String.valueOf(regSuffix) + "NAM");
                regionId.put("b", String.valueOf(regSuffix) + "LAM");
                regionId.put("c", String.valueOf(regSuffix) + "WEU");
                regionId.put("d", String.valueOf(regSuffix) + "EEU");
                regionId.put("e", String.valueOf(regSuffix) + "FSU");
                regionId.put("f", String.valueOf(regSuffix) + "MEA");
                regionId.put("g", String.valueOf(regSuffix) + "AFR");
                regionId.put("h", String.valueOf(regSuffix) + "CPA");
                regionId.put("i", String.valueOf(regSuffix) + "PAO");
                regionId.put("j", String.valueOf(regSuffix) + "PAS");
                regionId.put("k", String.valueOf(regSuffix) + "SAS");
            }
            Parameter ref_activity = this.sqliteData.getPar("ref_activity");
            Parameter ref_new_capacity = this.sqliteData.getPar("ref_new_capacity");
            Parameter parameter10 = this.sqliteData.getPar("ref_extraction");
            Parameter ref_relation = this.sqliteData.getPar("ref_relation");
            LinkedList solList = TxtUtils.getTextFileContent((File)solFile);
            for (String string : solList) {
                String tec2;
                String region;
                String id;
                if (string.length() > 19 && string.substring(14, 18).equals("....")) {
                    id = string.substring(10, 14);
                    String region7 = (String)regionId.get(string.substring(18, 19));
                    if (this.mTecIdMap.containsKey(String.valueOf(id) + "|" + region7)) {
                        String tec5 = this.mTecIdMap.get(String.valueOf(id) + "|" + region7);
                        Integer year = bYear + Integer.parseInt(string.substring(23, 26));
                        String key6 = String.valueOf(region7) + "." + this.decodeTecName(tec5) + "." + year + "." + this.decodeTecMode(tec5) + ".year";
                        Double val22 = Double.parseDouble(string.substring(30, 46));
                        if (outputScale.keySet().contains(String.valueOf(region7) + "." + this.decodeTecName(tec5) + "." + year)) {
                            val22 = val22 * (Double)outputScale.get(String.valueOf(region7) + "." + this.decodeTecName(tec5) + "." + year);
                        }
                        if (inputScale.keySet().contains(String.valueOf(region7) + "." + this.decodeTecName(tec5))) {
                            val22 = val22 / (Double)inputScale.get(String.valueOf(region7) + "." + this.decodeTecName(tec5));
                        }
                        ref_activity.addElement(key6, val22, "GWa", "derived from sol file");
                    }
                }
                if (string.length() > 19 && string.substring(10, 11).equals("v")) {
                    id = string.substring(11, 15);
                    id = id.replaceAll("[.]", "");
                    region = (String)regionId.get(string.substring(18, 19));
                    if (this.mTecIdMap.containsKey(String.valueOf(id) + "|" + region)) {
                        tec2 = this.mTecIdMap.get(String.valueOf(id) + "|" + region);
                        Integer year = bYear + Integer.parseInt(string.substring(23, 26));
                        String key7 = String.valueOf(region) + "." + this.decodeTecName(tec2) + "." + year + ".P.year";
                        ref_activity.addElement(key7, (Double)Double.parseDouble(string.substring(30, 46)), "GWa", "derived from sol file");
                    }
                }
                if (string.length() > 19 && string.substring(10, 11).equals("y")) {
                    id = string.substring(11, 15);
                    region = (String)regionId.get(string.substring(18, 19));
                    if (this.mTecIdMap.containsKey(String.valueOf(id) + "|" + region)) {
                        tec2 = this.mTecIdMap.get(String.valueOf(id) + "|" + region);
                        Integer year = bYear + Integer.parseInt(string.substring(23, 26));
                        String key8 = String.valueOf(region) + "." + this.decodeTecName(tec2) + "." + year;
                        ref_new_capacity.addElement(key8, (Double)Double.parseDouble(string.substring(30, 46)), "GW", "derived from sol file");
                    }
                }
                IndexSet relation = this.sqliteData.getIndexSet("relation");
                if (string.length() > 19 && (string.substring(10, 11).equals("n") || string.substring(10, 11).equals("p"))) {
                    String id2 = string.substring(11, 15);
                    String region8 = (String)regionId.get(string.substring(18, 19));
                    String relKey = null;
                    relKey = string.substring(10, 11).equals("n") ? "relations1:" : "relations2:";
                    if (this.mRelIdMap.containsKey(relKey = String.valueOf(relKey) + "|" + id2 + "|" + region8)) {
                        String relName = this.mRelIdMap.get(relKey);
                        Integer year = bYear + Integer.parseInt(string.substring(23, 26));
                        if (relation.hasElement(relName)) {
                            String key9 = String.valueOf(relName) + "." + region8 + "." + year;
                            ref_relation.addElement(key9, (Double)Double.parseDouble(string.substring(30, 46)), "???", "derived from sol file");
                        } else {
                            logger.info((Object)(" relations '" + relName + "' missing, entry '" + region8 + "|" + year + "':" + Double.parseDouble(string.substring(30, 46)) + " dropped!"));
                        }
                    } else {
                        logger.info((Object)(" no name for relations key '" + relKey + "', entry dropped!"));
                    }
                }
                if (string.length() <= 19 || !string.substring(10, 12).equals("rr") || string.substring(12, 13).equals(".") || !string.substring(14, 15).equals(".")) continue;
                String commId2 = string.substring(12, 13);
                String grade = string.substring(13, 14);
                String region9 = (String)regionId.get(string.substring(18, 19));
                Integer year = bYear + Integer.parseInt(string.substring(23, 26));
                if (this.fuelCodeMap.containsKey(String.valueOf(region9) + "|" + commId2 + "-r")) {
                    String fuel = this.fuelCodeMap.get(String.valueOf(region9) + "|" + commId2 + "-r").split("[|]")[1];
                    Double val23 = Double.parseDouble(string.substring(30, 46));
                    parameter10.addElement(String.valueOf(region9) + "." + fuel + "." + grade + "." + year, val23, "GWa", "derived from sol file");
                    continue;
                }
                logger.info((Object)(" drop extraction of fuel '" + commId2 + "-r' from sol file! |" + string));
            }
        }
        if (softFile != null) {
            for (String aLine : TxtUtils.getTextFileContent((File)softFile)) {
                String[] fld8 = aLine.split("\\s+");
                String string = "";
                String time = "";
                if (fld8[0].equals("mpc")) {
                    String string4 = "new_capacity";
                } else if (fld8[0].equals("mpa")) {
                    String string5 = "activity";
                    time = ".year";
                } else {
                    logger.error((Object)(" wrong type of constraint: " + fld8[0] + "!"));
                    continue;
                }
                for (String region10 : this.sqliteData.nodes) {
                    if (region10.equals("World")) continue;
                    if (!this.mTecIdMap.keySet().contains(String.valueOf(fld8[1]) + "|" + region10)) {
                        logger.error((Object)(" no technology with identifier " + fld8[1] + " in region " + region10 + "!"));
                        continue;
                    }
                    String aTec = this.mTecIdMap.get(String.valueOf(fld8[1]) + "|" + region10);
                    Iterator iterator = years.iterator();
                    while (iterator.hasNext()) {
                        void var43_167;
                        int aYr11 = (Integer)iterator.next();
                        if (aYr11 < 2011) continue;
                        Double valSoft = new Double(fld8[4]) / 100.0;
                        String dir = "";
                        if (fld8[2].equals("UP")) {
                            dir = "_up";
                        } else if (fld8[2].equals("LO")) {
                            dir = "_lo";
                            valSoft = -valSoft.doubleValue();
                        }
                        Parameter aPar5 = this.sqliteData.getPar("soft_" + (String)var43_167 + dir);
                        aPar5.addElement(String.valueOf(region10) + "." + aTec + "." + aYr11 + time, valSoft, "???");
                        String id = "";
                        Double valCost = Double.parseDouble(fld8[5]);
                        if (fld8[3].equals("abs")) {
                            id = "abs_cost_";
                        } else if (fld8[3].equals("lev")) {
                            id = "level_cost_";
                            valCost = valCost / 100.0;
                        }
                        Parameter aCostPar = this.sqliteData.getPar(String.valueOf(id) + (String)var43_167 + "_soft" + dir);
                        aCostPar.addElement(String.valueOf(region10) + "." + aTec + "." + aYr11 + time, valCost, "???");
                    }
                }
            }
        }
        this.sqliteData.removeSet("pseudotechnology");
        logger.info((Object)"drop all intermediate mappings and lists");
        outputScale = null;
        Object var33_89 = null;
        this.fuelCodeMap = null;
        this.mTecIdMap = null;
        this.mRelIdMap = null;
        this.mRelRelioMap = null;
        this.validRelations = null;
        this.droppedRelations = null;
        this.globalRelations = null;
        tecLifetime = null;
        tecYrInvList = null;
        tecYrActList = null;
        String appUser = System.getProperty("user.name", "(unknown)");
        this.sqliteData.commit(appUser, "import from file '" + sqliteFile + "'");
        this.sqliteData.setAsDefaultVersion();
        logger.info((Object)("done importing dataset '" + pModel + "|" + pScenario + "' from file '" + sqliteFile + "' to database!"));
        String dburl = dbConfig.getDbUrl1();
        if (dburl.contains("hsqldb:file:")) {
            Connection dbConn = DriverManager.getConnection(dbConfig.getDbUrl1(), dbConfig.getDbUsr1(), dbConfig.getDbPwd1());
            logger.info((Object)("hsqldb SHUTDOWN called (url:" + dburl + ")"));
            dbConn.close();
        }
    }

    void parseParData(Connection pConn, String pSection, String pKeywd, String pParname, String[][] pCfg, String pQuery) throws Exception {
        this.parseParData(pConn, pSection, pKeywd, pParname, pCfg, pQuery, null);
    }

    void parseParData(Connection pConn, String pSection, String pKeywd, String pParname, String[][] pCfg, String pQuery, String pAddClause) throws Exception {
        Parameter retval = null;
        retval = this.sqliteData.hasPar(pParname) ? this.sqliteData.getPar(pParname) : this.sqliteData.initializePar(pParname, null, null);
        LinkedList<String> qColList = new LinkedList<String>();
        HashSet<String> qColHash = new HashSet<String>();
        HashMap<String, String> qKeyColHash = new HashMap<String, String>();
        String[][] stringArray = pCfg;
        int n = pCfg.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            String qCol = p[2];
            if (qCol.matches("decode.*[(].+[)]")) {
                String[] fld = qCol.split("[(,)]{1}");
                qCol = fld[1];
                qKeyColHash.put(p[0], qCol);
                if (!qColHash.contains(qCol)) {
                    qColList.add(qCol);
                    qColHash.add(qCol);
                }
            } else if (!qCol.startsWith("put")) {
                if (qCol.equals("yearColumn")) {
                    for (String aCol : this.yearColList) {
                        qColList.add(aCol);
                        qColHash.add(aCol);
                    }
                } else if (!(qCol.equals("time") || qCol.equals("yearDuplicate") || qColHash.contains(qCol))) {
                    qColList.add(qCol);
                    qColHash.add(qCol);
                }
            }
            ++n2;
        }
        String qCols = StringUtils.join(qColList, (String)", ");
        String aQuery = "select " + qCols + " from data where section = '" + pSection + "'";
        if (pKeywd != null) {
            aQuery = String.valueOf(aQuery) + " and keywd = '" + pKeywd + "'";
        }
        if (pAddClause != null) {
            aQuery = String.valueOf(aQuery) + " " + pAddClause;
        }
        if (pQuery != null) {
            aQuery = String.valueOf(aQuery) + " " + pQuery;
        }
        logger.info((Object)(" query for parameter " + pParname + ": " + aQuery));
        Statement qStmt = pConn.createStatement();
        logger.debug((Object)aQuery);
        ResultSet aRs = qStmt.executeQuery(aQuery);
        int cnt = 0;
        while (aRs.next()) {
            boolean gotIllegalRelation = false;
            boolean gotYearColumn = false;
            boolean gotIntvalColumn = false;
            boolean gotDblvalColumn = false;
            LinkedList<String> preValueKeyList = new LinkedList<String>();
            LinkedList<String> postValueKeyList = new LinkedList<String>();
            String region = null;
            String[][] stringArray2 = pCfg;
            int n3 = pCfg.length;
            int n4 = 0;
            while (n4 < n3) {
                String key;
                String rsCol;
                String[] p = stringArray2[n4];
                String qCol = p[2];
                if (qCol.equals("subregion")) {
                    region = MsgSqlite_2_MsgDB.msgCleanNode(aRs.getString("subregion"));
                }
                if (qCol.matches("decode.*[(].+[)]")) {
                    String[] fld = qCol.split("[(,)]{1}");
                    String fun = fld[0];
                    String key2 = null;
                    String keyAdder = null;
                    if (fun.equals("decodeTecName")) {
                        key2 = this.decodeTecName(aRs.getString((String)qKeyColHash.get(p[0])));
                    } else if (fun.equals("decodeTecMode")) {
                        key2 = this.decodeTecMode(aRs.getString((String)qKeyColHash.get(p[0])));
                    } else if (fun.equals("decodeFuel")) {
                        if (fld[2].equals("1")) {
                            key2 = this.decodeFuelCommodity(aRs.getString((String)qKeyColHash.get(p[0])), region);
                        } else if (fld[2].equals("2")) {
                            key2 = this.decodeFuelLevel(aRs.getString((String)qKeyColHash.get(p[0])), region);
                        } else if (fld[2].equals("grade")) {
                            key2 = this.decodeFuelGrade(aRs.getString((String)qKeyColHash.get(p[0])), "a");
                        } else if (fld[2].equals("3")) {
                            key2 = MsgSqlite_2_MsgDB.msgCleanNode(this.decodeFuelRegion(aRs.getString((String)qKeyColHash.get(p[0])), aRs.getString(fld[3])));
                        }
                    } else if (fun.equals("decodeRelationId")) {
                        if (aRs.getString((String)qKeyColHash.get(p[0])).length() <= 4) {
                            key2 = aRs.getString((String)qKeyColHash.get(p[0]));
                        } else {
                            key2 = aRs.getString((String)qKeyColHash.get(p[0])).substring(0, 4);
                            keyAdder = aRs.getString((String)qKeyColHash.get(p[0])).substring(4);
                        }
                        String relSection = "";
                        if (pParname.startsWith("con1a") || pParname.equals("con1c")) {
                            relSection = "relations1:";
                        } else if (pParname.startsWith("con2a") || pParname.equals("con2c")) {
                            relSection = "relations2:";
                        } else if (pParname.equals("conca")) {
                            relSection = "relationsc:";
                        }
                        if (this.mRelIdMap.keySet().contains(String.valueOf(relSection) + "|" + key2 + "|" + region)) {
                            key2 = this.mRelIdMap.get(String.valueOf(relSection) + "|" + key2 + "|" + region);
                            if (keyAdder != null) {
                                key2 = String.valueOf(key2) + keyAdder;
                            }
                        } else if (this.mRelIdMap.keySet().contains(String.valueOf(relSection) + "|" + key2 + "|" + regSuffix + GLBregion)) {
                            if (!this.globalRelations.contains(String.valueOf(relSection) + "|" + key2 + "|" + regSuffix + GLBregion)) {
                                this.globalRelations.add(String.valueOf(relSection) + "|" + key2 + "|" + regSuffix + GLBregion);
                                logger.info((Object)(" relation identifier " + relSection + "|" + key2 + "|" + region + " writing to 'glb' region"));
                                this.sqliteData.addToChangelog("warning during SQLite import", "relations", "id " + relSection + "|" + key2 + "|" + region + " writing to glb region");
                            }
                            key2 = this.mRelIdMap.get(String.valueOf(relSection) + "|" + key2 + "|" + regSuffix + GLBregion);
                            if (keyAdder != null) {
                                key2 = String.valueOf(key2) + keyAdder;
                            }
                        } else {
                            if (!this.droppedRelations.contains(String.valueOf(relSection) + "|" + key2 + "|" + region)) {
                                this.droppedRelations.add(String.valueOf(relSection) + "|" + key2 + "|" + region);
                                logger.info((Object)(" unknown relation identifier " + relSection + "|" + key2 + "|" + region + " dropped, first seen in entry '" + StringUtils.join(preValueKeyList, (String)".") + "'"));
                                this.sqliteData.addToChangelog("dropped during SQLite import", "relations", "id " + relSection + "|" + key2 + "|" + region + " dropped, first seen in entry " + StringUtils.join(preValueKeyList, (String)"."));
                            }
                            gotIllegalRelation = true;
                        }
                    }
                    if (!gotYearColumn) {
                        preValueKeyList.add(key2);
                    } else {
                        postValueKeyList.add(key2);
                    }
                } else if (qCol.startsWith("put")) {
                    preValueKeyList.add(qCol.split("[\\(\\)]")[1]);
                } else if (qCol.equals("yearColumn")) {
                    gotYearColumn = true;
                } else if (qCol.equals("yearDuplicate")) {
                    preValueKeyList.add("yearDuplicate");
                } else if (qCol.equals("time")) {
                    postValueKeyList.add("year");
                } else if (qCol.equals("dblval")) {
                    gotDblvalColumn = true;
                } else if (qCol.equals("intval")) {
                    gotIntvalColumn = true;
                } else if (qCol.equals("subregion")) {
                    rsCol = p[2];
                    key = MsgSqlite_2_MsgDB.msgCleanNode(aRs.getString(rsCol));
                    preValueKeyList.add(key);
                } else {
                    rsCol = p[2];
                    key = aRs.getString(rsCol);
                    logger.debug((Object)(String.valueOf(rsCol) + "|" + key + "(" + p[0] + "|" + qCol + "|" + p[2] + ")"));
                    if (!gotYearColumn) {
                        preValueKeyList.add(key);
                    } else {
                        postValueKeyList.add(key);
                    }
                }
                ++n4;
            }
            if (gotIllegalRelation) continue;
            String preValuekey = StringUtils.join(preValueKeyList, (String)".");
            String postValuekey = "";
            if (postValueKeyList.size() > 0) {
                postValuekey = "." + StringUtils.join(postValueKeyList, (String)".");
            }
            String val = null;
            try {
                if (gotYearColumn) {
                    for (String aCol : this.yearColList) {
                        val = aRs.getString(aCol);
                        String newPreValuekey = preValuekey.replace("yearDuplicate", aCol.substring(1));
                        retval = this.addCleanParElement(retval, String.valueOf(newPreValuekey) + "." + aCol.substring(1) + postValuekey, val);
                    }
                } else if (gotIntvalColumn) {
                    retval = this.addCleanParElement(retval, preValuekey, aRs.getString("intval"));
                } else if (gotDblvalColumn) {
                    retval = this.addCleanParElement(retval, preValuekey, aRs.getString("dblval"));
                }
                ++cnt;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("parameter " + pSection + "|" + pParname + ": " + cnt + " records found"));
    }

    Parameter addCleanParElement(Parameter pPar, String key, String val) throws Exception {
        Double dVal = Double.parseDouble(val);
        if (pPar.getName().startsWith("market_penetration") && !key.contains("BIO0") && dVal > 99.0) {
            dVal = Double.POSITIVE_INFINITY;
            this.sqliteData.addToChangelog("replaced with positive infinity during import from Sqlite", pPar.getName(), key);
        } else if (dVal > 9900000.0) {
            dVal = Double.POSITIVE_INFINITY;
            this.sqliteData.addToChangelog("replaced with positive infinity during import from Sqlite", pPar.getName(), key);
        } else if (dVal < -9900000.0) {
            dVal = Double.NEGATIVE_INFINITY;
            this.sqliteData.addToChangelog("replaced with negative infinity during import from Sqlite", pPar.getName(), key);
        }
        String parUnit = "???";
        if (this.parUnitMap.keySet().contains(pPar.getName())) {
            parUnit = this.parUnitMap.get(pPar.getName());
        }
        try {
            pPar.addElement(key, dVal, parUnit, null);
        }
        catch (IxException e) {
            logger.info((Object)(" dropped element '" + key + "' for parameter " + pPar.getName() + ", no index set"));
        }
        return pPar;
    }

    String getYearMapIdentifier(Element pEle, String pMode) throws IxException {
        return String.valueOf(pEle.getKey(0)) + "|" + pEle.getKey(1) + "|" + pMode;
    }

    Vector<Integer> getTecLifetimeIdentifier(Element pEle, int pYear) throws IxException {
        return this.getVector(String.valueOf(pEle.getKey(0)) + "." + pEle.getKey(1) + "." + pYear);
    }

    String decodeTecName(String key) {
        if (key.contains("(")) {
            int i1 = key.indexOf("(");
            key = key.substring(0, i1);
        }
        return MsgSqlite_2_MsgDB.msgCleanName(key);
    }

    String decodeTecMode(String key) {
        if (key.contains("(")) {
            int i1 = key.indexOf("(");
            return "M" + key.substring(i1 + 1, i1 + 2);
        }
        return "M1";
    }

    String decodeFuelCommodity(String pCode, String pRegion) {
        String[] fld = pCode.split("[-]");
        if (fld.length > 2) {
            pRegion = fld[2];
        }
        if (pRegion.equals("Brasil")) {
            pRegion = "Brazil";
        }
        if (fld.length > 1 && fld[0].length() == 1 && this.fuelCodeMap.keySet().contains(String.valueOf(pRegion) + "|" + fld[0] + "-" + fld[1])) {
            fld = this.fuelCodeMap.get(String.valueOf(pRegion) + "|" + fld[0] + "-" + fld[1]).split("[|]");
            return fld[1];
        }
        return pCode;
    }

    String decodeFuelLevel(String pCode, String pRegion) {
        String[] fld = pCode.split("[-]");
        if (fld.length > 2) {
            pRegion = fld[2];
        }
        if (pRegion.equals("Brasil")) {
            pRegion = "Brazil";
        }
        if (fld.length > 1 && fld[0].length() == 1) {
            fld = this.fuelCodeMap.get(String.valueOf(pRegion) + "|" + fld[0] + "-" + fld[1]).split("[|]");
            return fld[2];
        }
        return "useful";
    }

    String decodeFuelRegion(String pCode, String pDefault) {
        String[] fld = pCode.split("[-]");
        if (fld.length > 2) {
            if (fld[2].equals("Brasil")) {
                return "Brazil";
            }
            return fld[2];
        }
        return pDefault;
    }

    String decodeFuelGrade(String pCode, String pDefault) {
        String[] fld = pCode.split("[(]");
        if (fld.length > 1) {
            return fld[1].substring(0, 1);
        }
        return pDefault;
    }

    public static String msgCleanNode(String pNode) {
        String retval = pNode;
        if (retval.equals("Brasil")) {
            retval = "Brazil";
        } else if (regSuffix != null) {
            retval = String.valueOf(regSuffix) + pNode.toUpperCase();
        }
        return retval;
    }

    public static String msgCleanName(String pName) {
        String retval = pName;
        if (retval == null) {
            return retval;
        }
        if (retval.contains("/")) {
            retval = retval.replaceAll("/", "_");
        }
        if (retval.contains("%")) {
            retval = retval.replaceAll("%", "p");
        }
        if (retval.startsWith("NOX")) {
            retval = retval.replaceAll("NOX", "NOx");
        }
        if (retval.contains("back_I")) {
            retval = retval.replaceAll("back_I", "back_i2");
        } else if (retval.contains("back_RC")) {
            retval = retval.replaceAll("back_RC", "back_rc2");
        } else if (retval.contains("Puq")) {
            retval = retval.replaceAll("Puq", "puq2");
        } else if (retval.equals("CH4G_TCE")) {
            retval = retval.replaceAll("CH4G_TCE", "CH4g2_TCE");
        } else if (retval.equals("Igdp")) {
            retval = retval.replaceAll("Igdp", "Igdp2");
        } else if (retval.contains("CH4NewEmissions")) {
            retval = "CH4new_Emission";
        } else if (retval.contains("_emissions")) {
            retval = retval.replaceAll("_emissions", "_Emission");
        } else if (retval.contains("_emission")) {
            retval = retval.replaceAll("_emission", "_Emission");
        } else if (retval.contains("_Emissions")) {
            retval = retval.replaceAll("_Emissions", "_Emission");
        } else if (retval.contains("_emiss")) {
            retval = retval.replaceAll("_emiss", "_Emission");
        } else if (retval.contains("ELEC_")) {
            retval = retval.replaceAll("ELEC_", "elec_relations2_");
        } else if (retval.equals("ch4r")) {
            retval = retval.replaceAll("ch4r", "ch4r2");
        } else if (retval.equals("n2oc")) {
            retval = retval.replaceAll("n2oc", "n2oc2");
        } else if (retval.equals("ch4a")) {
            retval = retval.replaceAll("ch4a", "ch4a2");
        } else if (retval.equals("Demc")) {
            retval = retval.replaceAll("Demc", "Demc2");
        } else if (retval.equals("Deml")) {
            retval = retval.replaceAll("Deml", "Deml2");
        }
        retval = MsgSqlite_2_MsgDB.msgConsistency(retval);
        return retval;
    }

    public static String msgConsistency(String pName) {
        String retval = pName;
        if (retval == null) {
            return retval;
        }
        if (pName.equals("ele_coal")) {
            retval = "elec_coal";
        } else if (pName.equals("ele_gas")) {
            retval = "elec_gas";
        } else if (pName.equals("ele_hydr")) {
            retval = "elec_hydro";
        } else if (pName.equals("elec_hyd")) {
            retval = "elec_hydro";
        } else if (pName.equals("elec_hydr")) {
            retval = "elec_hydro";
        } else if (cleanNameMap.keySet().contains(pName)) {
            retval = cleanNameMap.get(pName);
        }
        return retval;
    }

    private Vector<Integer> getTecVector(Vector<Integer> eleVector) {
        Vector<Integer> tecVector = new Vector<Integer>(3);
        tecVector.add(eleVector.get(0));
        tecVector.add(eleVector.get(1));
        tecVector.add(eleVector.get(2));
        return tecVector;
    }

    private Vector<Integer> getTecActVector(Vector<Integer> eleVector) {
        Vector<Integer> tecVector = new Vector<Integer>(4);
        tecVector.add(eleVector.get(0));
        tecVector.add(eleVector.get(1));
        tecVector.add(eleVector.get(2));
        tecVector.add(eleVector.get(3));
        return tecVector;
    }

    private Vector<Integer> getTecActVector(Vector<Integer> eleVector, Integer pVtgYrKey) throws IxException {
        Vector<Integer> tecVector = new Vector<Integer>(4);
        tecVector.add(eleVector.get(0));
        tecVector.add(eleVector.get(1));
        tecVector.add(pVtgYrKey);
        tecVector.add(eleVector.get(3));
        return tecVector;
    }

    private Vector<Integer> getVector(String pKeyString) throws IxException {
        LinkedList<String> pKeyList = new LinkedList<String>(Arrays.asList(pKeyString.split("[.]")));
        Vector<Integer> tecVector = new Vector<Integer>(pKeyList.size());
        for (String aKey : pKeyList) {
            tecVector.add(this.sqliteData.addKey(aKey));
        }
        return tecVector;
    }

    public static void main(String[] args) throws Exception {
        boolean doSSPModel;
        int n;
        boolean doBrazilModel;
        boolean doEneIxmp;
        boolean doSetNav;
        File logFile = new File("MsgSqlite_2_MsgDB.log");
        if (logFile.exists()) {
            logFile.delete();
        }
        baselogger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%d{ISO8601} %5p %c:%L - %m%n"), logFile.getName()));
        baselogger.setLevel(Level.INFO);
        DbConfig dbConfig = new DbConfig();
        dbConfig.setDbDriver2("org.sqlite.JDBC");
        dbConfig.setDbUrl2("jdbc:sqlite:D:/checks/glb_ref_inp.db");
        dbConfig.setDbUsr2("");
        dbConfig.setDbPwd2("");
        boolean tryHsqldb = false;
        if (tryHsqldb) {
            dbConfig.setDbDriver1("org.hsqldb.jdbcDriver");
            dbConfig.setDbUrl1("jdbc:hsqldb:file:D:/checks/hsqldb-2.3.4/data/ixmptest");
            dbConfig.setDbUrl1("jdbc:hsqldb:hsql://pca148.iiasa.ac.at/ixmp");
            dbConfig.setDbUrl1("jdbc:hsqldb:hsql://pcb097.iiasa.ac.at/ixmptest");
            dbConfig.setDbUrl1("jdbc:hsqldb:file:D:/checks/hsqldb-2.3.4/data/ixmptest2;shutdown=true");
            dbConfig.setDbUrl1("jdbc:hsqldb:file:D:/checks/hsqldb-2.3.4/data/ixmptest3;shutdown=true");
            dbConfig.setDbUsr1("ixmp");
            dbConfig.setDbPwd1("ixmp");
        }
        if (doSetNav = false) {
            dbConfig.setDbUrl1("jdbc:oracle:thin:@gp3.iiasa.ac.at:1521:GP3");
            dbConfig.setDbUsr1("setnav");
            dbConfig.setDbPwd1("setnav");
        }
        if (doEneIxmp = true) {
            dbConfig.setDbUrl1("jdbc:oracle:thin:@gp3.iiasa.ac.at:1521:GP3");
            dbConfig.setDbUsr1("ENE_IXMP");
            dbConfig.setDbPwd1("ENE_IXMP");
        }
        if (doBrazilModel = true) {
            String[][] stringArrayArray = new String[1][];
            String[] stringArray = new String[4];
            stringArray[0] = "MESSAGE Brazil";
            stringArray[1] = "SQLite import (BLUES)";
            stringArray[2] = "Brasil_BLUES_adb_inp.db";
            stringArrayArray[0] = stringArray;
            String[][] cases = stringArrayArray;
            File impDir = new File("C:/Users/huppmann/Documents/MESSAGE_SQLite/");
            String[][] stringArrayArray2 = cases;
            n = cases.length;
            int n2 = 0;
            while (n2 < n) {
                String[] aCase = stringArrayArray2[n2];
                File dbFile = new File(impDir, aCase[2]);
                File solFile = null;
                if (aCase[3] != null) {
                    solFile = new File(impDir, aCase[3]);
                }
                logger.debug((Object)("file: " + dbFile.getAbsolutePath()));
                new MsgSqlite_2_MsgDB(dbFile, dbConfig, aCase[0], aCase[1], null, solFile, null, 2000, null);
                ++n2;
            }
        }
        if (doSSPModel = false) {
            String[][] stringArrayArray = new String[3][];
            String[] stringArray = new String[6];
            stringArray[0] = "ssp1_ref_0_Ref2_00_0";
            stringArray[1] = "MESSAGEix-GLOBIOM SSP1";
            stringArray[2] = "baseline 1990 (SQLite import)";
            stringArray[3] = "glb_ssp1_ref_0_Ref2_00_0_lin";
            stringArray[4] = "easemps3";
            stringArrayArray[0] = stringArray;
            String[] stringArray2 = new String[6];
            stringArray2[0] = "ssp2_ref_0_Ref2_00_0";
            stringArray2[1] = "MESSAGEix-GLOBIOM SSP2";
            stringArray2[2] = "baseline 1990 (SQLite import)";
            stringArray2[3] = "glb_ssp2_ref_0_Ref2_00_0_lin";
            stringArray2[4] = "easemps3";
            stringArrayArray[1] = stringArray2;
            String[] stringArray3 = new String[6];
            stringArray3[0] = "ssp3_ref_0_Ref2_00_0";
            stringArray3[1] = "MESSAGEix-GLOBIOM SSP3";
            stringArray3[2] = "baseline 1990 (SQLite import)";
            stringArray3[3] = "glb_ssp3_ref_0_Ref2_00_0_lin";
            stringArray3[4] = "easemps3";
            stringArrayArray[2] = stringArray3;
            String[][] cases = stringArrayArray;
            File impDir = new File("C:/Users/huppmann/Documents/MESSAGE_SSP_SQLite/");
            String[][] stringArrayArray3 = cases;
            int n3 = cases.length;
            n = 0;
            while (n < n3) {
                String[] aCase = stringArrayArray3[n];
                File dbFile = new File(impDir, String.valueOf(aCase[0]) + ".db");
                File solFile = new File(impDir, String.valueOf(aCase[3]) + ".sol");
                File softFile = new File(impDir, String.valueOf(aCase[4]) + ".free");
                logger.debug((Object)("file: " + dbFile.getAbsolutePath()));
                new MsgSqlite_2_MsgDB(dbFile, dbConfig, aCase[1], aCase[2], aCase[5], solFile, softFile, 1900, "R11_");
                ++n;
            }
        }
    }
}

