/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp;

import at.ac.iiasa.ixmp.exceptions.IxConfigException;
import at.ac.iiasa.ixmp.exceptions.IxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Config {
    private static Config instance = null;
    private static Logger logger = Logger.getLogger((String)"Config");
    private static String PROPERTIES_FILENAME = "ixmp.properties";
    private static String[] requiredProperties = new String[]{"config.name", "gams.dir"};
    private static String[] requiredRestProperties = new String[]{"gams.modeldir", "tmp.dir", "upload.dir"};
    private HashMap<String, String> config = new HashMap();
    private static Path rootPath;

    private Config() throws IxException, IOException, IxConfigException, URISyntaxException {
        InputStream stream = null;
        URL url = Config.class.getClassLoader().getResource(PROPERTIES_FILENAME);
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IxException("could not open " + PROPERTIES_FILENAME + "!");
        }
        Properties configProps = new Properties();
        configProps.load(stream);
        stream.close();
        logger.info((Object)("Entries of " + PROPERTIES_FILENAME));
        for (Map.Entry<Object, Object> e : configProps.entrySet()) {
            this.config.put((String)e.getKey(), (String)e.getValue());
            logger.info((Object)(e.getKey() + ": " + e.getValue()));
        }
        this.checkRequiredProperties(requiredProperties);
        this.createDirectories();
    }

    public void verifyRestSettings() throws IxException {
        this.checkRequiredProperties(requiredRestProperties);
    }

    private void checkRequiredProperties(String[] properties) throws IxException {
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            String propVal = this.config.get(property);
            if (propVal == null) {
                String message = "missing property '" + property + "' in " + PROPERTIES_FILENAME;
                logger.error((Object)message);
                throw new IxException(message);
            }
            ++n2;
        }
    }

    public static Config getInstance() throws IxException, IOException, IxConfigException, URISyntaxException {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static Object get(String key) throws IxException, IOException, IxConfigException, URISyntaxException {
        Config instance = Config.getInstance();
        return instance.config.get(key);
    }

    public static Object get(String key, Object defaultValue) throws IxException, IOException, IxConfigException, URISyntaxException {
        Config instance = Config.getInstance();
        Object value = instance.config.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Path getAbsolutePath(String key) throws IxException, IOException, IxConfigException, URISyntaxException {
        Config instance = Config.getInstance();
        Path root = Config.getRootPath();
        Path path = Paths.get(root.toString(), instance.config.get(key));
        return path;
    }

    private void createIfNotExists(Path path) throws IxConfigException {
        File directory = path.toFile();
        if (!directory.isDirectory() && !directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            throw new IxConfigException("Path " + path.toString() + " is not a directory");
        }
    }

    private void createDirectoryIfNotExists(String dirName) throws IxConfigException, URISyntaxException {
        if (dirName == null) {
            throw new IllegalArgumentException("dirName has to be a valid String, not null");
        }
        Path path = Paths.get(Config.getRootPath().toString(), dirName);
        this.createIfNotExists(path);
    }

    private static Path getRootPath() throws URISyntaxException {
        if (rootPath == null) {
            URL rootUrl = Config.class.getProtectionDomain().getCodeSource().getLocation();
            rootPath = Paths.get(rootUrl.toURI()).getParent().getParent();
        }
        return rootPath;
    }

    private void createDirectories() throws IOException, IxConfigException, URISyntaxException {
        this.createDirectoryIfNotExists(this.config.get("upload.dir"));
        this.createDirectoryIfNotExists(this.config.get("tmp.dir"));
        this.createDirectoryIfNotExists(this.config.get("gams.dir"));
    }
}

