/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Set
extends Item {
    transient Logger logger = Logger.getLogger((String)this.getClass().getName());

    Set(Scenario scenario, String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        this.initializeIXItem(scenario, name, "set");
        this.setIXitemIdDims(indexSets, indexNames);
        scenario.addToItemList(this);
    }

    Set(Scenario scenario, String name, LinkedList<String> indexSets, LinkedList<String> indexNames, String scheme) throws IxException {
        this.initializeIXItem(scenario, name, "set");
        this.setIXitemIdDims(indexSets, indexNames, scheme);
        scenario.addToItemList(this);
    }

    Set(Scenario scenario, String name, int itemId, int dim) {
        this.initializeIXItem(scenario, name, "set", false);
        scenario.addToItemList(this);
        this.itemId = itemId;
        this.dim = dim;
    }

    protected Set() throws IxException {
    }

    public void addElement(String key) throws IxException {
        this.addElement(this.getKeyIdVector(key), null);
    }

    public void addElement(String key, String comment) throws IxException {
        this.addElement(this.getKeyIdVector(key), comment);
    }

    public void addElement(LinkedList<String> pKeyList) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList));
    }

    public void addElement(LinkedList<String> pKeyList, String pComment) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList), pComment);
    }

    public void addElement(Vector<Integer> pEleVector) throws IxException {
        this.addElement(pEleVector, null);
    }

    public void addElement(Vector<Integer> keyVector, String comment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        Element ele = (Element)this.eleMap.get(keyVector);
        if (ele == null) {
            ele = new Element(this, keyVector);
            this.addItemElement(ele, comment);
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("add set element", this.name, ele.getConcatKey());
            }
        }
        if (comment != null) {
            this.addItemComment(ele, comment);
        }
    }

    public void removeElement(String pEleKey) throws IxException {
        this.removeElement(this.getKeyIdVector(pEleKey));
    }

    public void removeElement(LinkedList<String> pKeyList) throws IxException {
        this.removeElement(this.getKeyIdVector(pKeyList));
    }

    public void removeElement(Vector<Integer> pEleVector) throws IxException {
        if (!this.hasElement(pEleVector)) {
            throw new IxException("The set '" + this.name + "' does not have an element '" + this.getConcatKey(pEleVector) + "', cannot be removed!");
        }
        this.removeElement((Element)this.eleMap.get(pEleVector));
    }

    public void removeElement(Element pEle) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (this.hasElement(pEle.getVector())) {
            this.hasUpdatedElement = true;
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("delete set element", this.name, pEle.getConcatKey());
            }
            super.removeItemElement(pEle);
        }
    }

    public boolean isIndexSet() {
        return this.dim == 0;
    }

    LinkedList<LinkedHashMap<Object, Object>> toJsonList(HashMap<String, LinkedList<String>> eleListFilter) throws IxException {
        LinkedList<LinkedHashMap<Object, Object>> jsonList = new LinkedList<LinkedHashMap<Object, Object>>();
        for (Element ele : this.getElements(eleListFilter)) {
            LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
            jsonMap.put("model", this.scenario.getModel());
            jsonMap.put("scenario", this.scenario.getScenario());
            jsonMap.put("type", "set");
            jsonMap.put("name", this.name);
            if (this.dim >= 1) {
                for (int i = 0; i < this.dim; ++i) {
                    jsonMap.put((String)this.idxNames.get(i), ele.getKey(i));
                }
            }
            jsonList.add(jsonMap);
        }
        return jsonList;
    }
}

