/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.ixobjects.IXelement;
import at.ac.iiasa.ixmp.objects.DatabaseQueries;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Item {
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    protected Scenario scenario = null;
    protected String name = null;
    protected String type = "item";
    protected int itemId = -1;
    protected Integer dim = 0;
    protected LinkedList<String> idxSets = new LinkedList();
    protected LinkedList<String> idxNames = new LinkedList();
    protected HashMap<String, Integer> nameIdxMap = new HashMap();
    protected boolean eleLoadedFromDB = false;
    protected boolean hasUpdatedElement = false;
    protected LinkedList<Element> eleList = new LinkedList();
    protected HashMap<Vector<Integer>, Element> eleMap = new HashMap();
    protected boolean commentsLoadedFromDB = true;
    protected boolean hasUpdatedComment = false;
    private HashMap<Integer, LinkedList<Integer>> itemCommentMap = new HashMap();

    protected void initializeIXItem(Scenario scenario, String name, String type) {
        this.initializeIXItem(scenario, name, type, true);
    }

    protected void initializeIXItem(Scenario scenario, String name, String type, boolean fromDB) {
        this.scenario = scenario;
        this.name = name;
        this.type = type;
        this.eleLoadedFromDB = fromDB;
        this.itemId = this.scenario.getNextItemId();
    }

    protected void setIXitemIdDims(LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        this.setIXitemIdDims(indexSets, indexNames, null);
    }

    protected void setIXitemIdDims(LinkedList<String> indexSets, LinkedList<String> indexNames, String scheme) throws IxException {
        if (indexSets != null && !indexSets.isEmpty()) {
            this.idxSets = indexSets;
            this.idxNames = indexNames;
            if (scheme != null) {
                this.logger.debug((Object)(" initialize " + this.getTypeName() + " with index dimensions defined by '" + scheme + "' scheme"));
            } else {
                this.logger.debug((Object)(" initialize " + this.getTypeName() + " with explicitly stated index dimensions"));
            }
        } else {
            this.logger.debug((Object)(" initialize " + this.getTypeName() + " as scalar"));
        }
        int i = 0;
        for (String name : this.idxNames) {
            this.nameIdxMap.put(name, i++);
        }
        this.dim = this.idxSets.size();
    }

    public void setIXitemDimsFromDB(int idx, String indexSet, String indexName) {
        this.idxSets.add(indexSet);
        this.idxNames.add(indexName);
        this.nameIdxMap.put(indexName, idx);
    }

    boolean isLoadedFromDB() {
        return this.eleLoadedFromDB;
    }

    protected boolean isScalar() {
        return this.dim == 0;
    }

    public boolean hasElements() throws IxException {
        boolean retval = false;
        if (this.isLoadedFromDB()) {
            if (!this.eleList.isEmpty()) {
                retval = true;
            }
        } else {
            DatabaseQueries ixDB = DatabaseQueries.getInstance();
            retval = ixDB.hasItemElementsInBlob(this.scenario.getRunId(), this);
        }
        return retval;
    }

    boolean loadItemElementsFromDB() throws IxException {
        if (!this.isLoadedFromDB()) {
            DatabaseQueries ixDB = DatabaseQueries.getInstance();
            ixDB.getItemElementsFromDB(this.scenario.getRunId(), this);
            this.eleLoadedFromDB = true;
            return true;
        }
        return false;
    }

    void setElementListFromDB(LinkedList<Object> blob) {
        for (Object e : blob) {
            Element ele = null;
            ele = e instanceof IXelement ? new Element((IXelement)e) : (Element)e;
            ele.setIXitem(this);
            this.eleList.add(ele);
            this.eleMap.put(ele.getVector(), ele);
        }
    }

    void loadItemCommentsFromDB() throws IxException {
        if (!this.commentsLoadedFromDB) {
            DatabaseQueries ixDB = DatabaseQueries.getInstance();
            ixDB.getItemCommentsFromDB(this.scenario.getRunId(), this);
            this.commentsLoadedFromDB = true;
        }
    }

    Scenario getParentScenario() {
        return this.scenario;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.type + " '" + this.name + "'";
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getDim() {
        return this.dim;
    }

    public LinkedList<String> getIdxSets() {
        return this.idxSets;
    }

    public String getIdxSet(int idx) {
        return this.idxSets.get(idx);
    }

    public LinkedList<String> getIdxNames() {
        return this.idxNames;
    }

    public String getIdxName(int idx) {
        return this.idxNames.get(idx);
    }

    protected Integer getIdx(String pIdxName) throws IxException {
        Integer idx = this.nameIdxMap.get(pIdxName);
        if (idx == null) {
            throw new IxException("The " + this.getTypeName() + " does not have an index '" + pIdxName + "'!");
        }
        return idx;
    }

    public boolean hasElement(String pKey) throws IxException {
        return this.hasElement(this.getKeyIdVector(pKey));
    }

    public boolean hasElement(LinkedList<String> pKeyList) throws IxException {
        return this.hasElement(this.getKeyIdVector(pKeyList));
    }

    public boolean hasElement(Vector<Integer> pEleVector) throws IxException {
        this.loadItemElementsFromDB();
        return this.eleMap.keySet().contains(pEleVector);
    }

    public void checkElement(String pKey) throws IxException {
        this.checkElement(this.getKeyIdVector(pKey));
    }

    public void checkElement(LinkedList<String> pKeyList) throws IxException {
        this.checkElement(this.getKeyIdVector(pKeyList));
    }

    public void checkElement(Vector<Integer> pEleVector) throws IxException {
        if (!this.hasElement(pEleVector)) {
            throw new IxException("The " + this.getTypeName() + " does not have an element " + this.getConcatKey(pEleVector) + "!");
        }
    }

    public LinkedList<Element> getElements() throws IxException {
        this.loadItemElementsFromDB();
        return this.eleList;
    }

    public LinkedList<Element> getElements(HashMap<String, LinkedList<String>> eleListFilter) throws IxException {
        if (eleListFilter == null) {
            this.loadItemElementsFromDB();
            return this.eleList;
        }
        HashMap<Integer, LinkedList<Integer>> eleFilter = new HashMap<Integer, LinkedList<Integer>>();
        for (String idxName : eleListFilter.keySet()) {
            if (this.nameIdxMap.get(idxName) == null) {
                throw new IxException("the " + this.getTypeName() + " does not have an index '" + idxName + "'!");
            }
            int idx = this.nameIdxMap.get(idxName);
            IndexSet idxSet = null;
            if (!this.idxSets.get(idx).equals("*")) {
                idxSet = this.scenario.getIndexSet(this.idxSets.get(idx));
            }
            LinkedList<Integer> filterKeyIdList = new LinkedList<Integer>();
            for (String aKey : eleListFilter.get(idxName)) {
                int aKeyId = this.scenario.addKey(aKey);
                if (idxSet != null) {
                    idxSet.checkIndexSetKey(aKeyId);
                }
                filterKeyIdList.add(aKeyId);
            }
            eleFilter.put(idx, filterKeyIdList);
        }
        return this.filteredEleList(eleFilter);
    }

    protected LinkedList<Element> filteredEleList(HashMap<Integer, LinkedList<Integer>> eleFilter) throws IxException {
        this.loadItemElementsFromDB();
        LinkedList<Element> filteredEleList = new LinkedList<Element>();
        for (Element ele : this.eleList) {
            try {
                for (Map.Entry<Integer, LinkedList<Integer>> aIdx : eleFilter.entrySet()) {
                    if (aIdx.getValue().contains(ele.getKeyId(aIdx.getKey()))) continue;
                    throw new IxException("...do not add this element - silent exception");
                }
                filteredEleList.add(ele);
            }
            catch (IxException ixException) {}
        }
        return filteredEleList;
    }

    public String[] getCol(int pIdx, LinkedList<Element> pEleList) throws IxException {
        if (!this.isScalar() && pIdx >= this.dim) {
            throw new IxException("Index higher than dimension of " + this.getTypeName() + "!");
        }
        Vector<String> ret = new Vector<String>(pEleList.size());
        for (Element ele : pEleList) {
            ret.add(ele.getKey(pIdx));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Element getElement(String pKey) throws IxException {
        return this.getElement(this.getKeyIdVector(pKey));
    }

    public Element getElement(LinkedList<String> pKeyList) throws IxException {
        return this.getElement(this.getKeyIdVector(pKeyList));
    }

    public Element getElement(Vector<Integer> pKeyVector) throws IxException {
        this.loadItemElementsFromDB();
        Element retEle = this.eleMap.get(pKeyVector);
        if (retEle == null) {
            throw new IxException("The " + this.getTypeName() + " does not contain an element '" + this.getConcatKey(pKeyVector) + "'!");
        }
        return retEle;
    }

    protected void clearCache() throws IxException {
        if (this.hasUpdatedElement || this.hasUpdatedComment) {
            throw new IxException("The " + this.getTypeName() + " has updated elements, the cache cannot be cleared!");
        }
        this.eleLoadedFromDB = false;
        this.commentsLoadedFromDB = false;
        this.eleList = new LinkedList();
        this.eleMap = new HashMap();
        this.itemCommentMap = new HashMap();
    }

    protected void addItemElement(Element ele, String comment) throws IxException {
        Vector<Integer> keyVector = ele.getVector();
        this.checkSanity(keyVector);
        this.hasUpdatedElement = true;
        this.eleList.add(ele);
        this.eleMap.put(keyVector, ele);
    }

    protected void removeItemElement(Element pEle) throws IxException {
        int eleId = pEle.getId();
        Vector<Integer> eleVector = pEle.getVector();
        this.eleList.remove(pEle);
        this.eleMap.remove(eleVector);
        this.removeItemCommentsById(eleId);
    }

    private void checkSanity(Vector<Integer> pEleVector) throws IxException {
        if (pEleVector.size() != Math.max(this.dim, 1)) {
            throw new IxException("The element " + this.getConcatKey(pEleVector) + " has the wrong number of dimensions for " + this.getTypeName() + " (" + this.dim + ")!");
        }
        for (int i = 0; i < this.dim; ++i) {
            this.scenario.checkIndexSetEle(this.getIdxSet(i), pEleVector.get(i));
        }
    }

    protected void addItemComment(Element pEle, String pComment) throws IxException {
        this.loadItemCommentsFromDB();
        int eleId = pEle.getId();
        int comId = this.scenario.addComment(pComment);
        LinkedList<Integer> itemCommentList = this.itemCommentMap.get(eleId);
        if (itemCommentList != null && !itemCommentList.contains(comId)) {
            itemCommentList.add(comId);
            this.hasUpdatedComment = true;
        } else {
            itemCommentList = new LinkedList();
            itemCommentList.add(comId);
            this.itemCommentMap.put(eleId, itemCommentList);
            this.hasUpdatedComment = true;
        }
        if (this.scenario.isChangeLogged().booleanValue()) {
            // empty if block
        }
    }

    public LinkedList<String> getItemComments() throws IxException {
        return this.getCommentsById(this.getItemId());
    }

    protected LinkedList<String> getCommentsById(int id) {
        LinkedList<String> itemCommentList = new LinkedList<String>();
        if (this.itemCommentMap.keySet().contains(id)) {
            LinkedList<Integer> itemCommentIdList = this.itemCommentMap.get(id);
            for (Integer aComId : itemCommentIdList) {
                itemCommentList.add(this.scenario.getCommentString(aComId));
            }
        }
        return itemCommentList;
    }

    protected void removeItemCommentsById(int id) throws IxException {
        this.loadItemCommentsFromDB();
        this.hasUpdatedComment = true;
        if (this.itemCommentMap.keySet().contains(id)) {
            this.itemCommentMap.remove(id);
        }
    }

    public String getConcatKey(Vector<Integer> pKeyVector) {
        String keyString = this.scenario.getKeyIdString(pKeyVector.get(0));
        for (int i = 1; i < pKeyVector.size(); ++i) {
            keyString = keyString + "." + this.scenario.getKeyIdString(pKeyVector.get(i));
        }
        return keyString;
    }

    public Vector<Integer> getKeyIdVector(String pKeyString) throws IxException {
        return this.getKeyIdVector(new LinkedList<String>(Arrays.asList(pKeyString.split("[.]"))));
    }

    protected Vector<Integer> getKeyIdVector(LinkedList<String> pKeyList) throws IxException {
        if (pKeyList.size() != Math.max(this.dim, 1)) {
            throw new IxException("The element has the wrong number of index dimensions for " + this.getTypeName() + " (dim=" + this.dim + ") !");
        }
        Vector<Integer> eleVector = new Vector<Integer>(pKeyList.size());
        for (String aKey : pKeyList) {
            eleVector.add(this.scenario.addKey(aKey));
        }
        return eleVector;
    }

    protected Vector<Integer> getNewVector() {
        Vector<Integer> retVector = new Vector<Integer>(Math.max(this.dim, 1));
        return retVector;
    }

    public Vector<Integer> setKeyAtIndex(Vector<Integer> pEleVector, String idxName, String pKey) throws IxException {
        return this.setKeyAtIndex(pEleVector, (int)this.nameIdxMap.get(idxName), this.scenario.addKey(pKey));
    }

    public Vector<Integer> setKeyAtIndex(Vector<Integer> pEleVector, int idx, String pKey) throws IxException {
        return this.setKeyAtIndex(pEleVector, idx, this.scenario.addKey(pKey));
    }

    public Vector<Integer> setKeyAtIndex(Vector<Integer> pEleVector, int idx, Integer pKeyId) {
        pEleVector.set(idx, pKeyId);
        return pEleVector;
    }

    public String getTypeForDB() throws IxException {
        if (this instanceof IndexSet) {
            throw new IxException("The function 'getTypeForDB()' is not applicable for index sets!");
        }
        if (this instanceof Set) {
            return "SET";
        }
        if (this instanceof Parameter) {
            return "PAR";
        }
        if (this instanceof Variable) {
            return "VAR";
        }
        if (this instanceof Equation) {
            return "EQU";
        }
        throw new IxException("Unknown type of Item!");
    }

    boolean hasUpdatedElements() {
        return this.hasUpdatedElement;
    }

    boolean hasUpdatedComments() {
        return this.hasUpdatedComment;
    }

    LinkedList<Element> getEleBlobForDB() throws IxException {
        return this.eleList;
    }

    HashMap<Integer, LinkedList<Integer>> getCommentMapForDB() {
        return this.itemCommentMap;
    }
}

