/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.DbConfig;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.Variable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import oracle.jdbc.OraclePreparedStatement;
import org.apache.log4j.Logger;

public class DatabaseQueries {
    static Logger logger = Logger.getLogger((String)DatabaseQueries.class.getName());
    private static DatabaseQueries instance = null;
    private static String dbInterface = null;
    private DbConfig dbConfig = null;
    private Connection dbConn = null;
    String[] ixParTables = new String[]{"IX_PAR_BLOBSTORE", "IX_PAR_DIM", "IX_PAR"};
    String[] ixVarTables = new String[]{"IX_VAR_BLOBSTORE", "IX_VAR_DIM", "IX_VAR"};
    String[] ixSetTables = new String[]{"IX_SET_BLOBSTORE", "IX_SET_DIM", "IX_SET", "IX_IDXSET"};
    String[] ixStructure = new String[]{"IX_COMMENT", "IX_KEY"};
    String[] iamcTables = new String[]{"REF_DATA"};
    private Connection sourceConn = null;

    public DatabaseQueries(DbConfig dbConfig) throws IxException {
        this("Java", dbConfig);
    }

    public DatabaseQueries(String pInterface, DbConfig pDbCfg) throws IxException {
        dbInterface = pInterface;
        this.dbConfig = pDbCfg;
        this.openConn();
        instance = this;
    }

    public Connection getConn() throws IxException {
        this.testConn();
        return this.dbConn;
    }

    public Connection getSourceConn() {
        return this.sourceConn;
    }

    public static synchronized DatabaseQueries getInstance() throws IxException {
        if (instance == null) {
            DbConfig dbCfg = new DbConfig();
            instance = new DatabaseQueries(dbCfg);
        }
        return instance;
    }

    public List<Map<String, Object>> getModelScenarioList(boolean getDefaultOnly) throws Exception {
        return this.getModelScenarioList(getDefaultOnly, -1, -1);
    }

    public List<Map<String, Object>> getModelScenarioList(boolean getDefaultOnly, String model, String scenario) throws IxException {
        int modelId = -1;
        if (model != null) {
            modelId = this.getSomeId("model", model);
        }
        int scenarioId = -1;
        if (scenario != null) {
            scenarioId = this.getSomeId("scenario", scenario);
        }
        return this.getModelScenarioList(getDefaultOnly, modelId, scenarioId);
    }

    public List<Map<String, Object>> getModelScenarioList(boolean getOnlyDefault, int modelId, int scenarioId) throws IxException {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String qString = "SELECT r.id run_id, m.id model_id, s.id scen_id, m.name model, s.name scenario, CASE WHEN (d.id >= 0) THEN 1 ELSE 0 END isDefault, CASE r.status WHEN 0 THEN 1 WHEN 1 THEN 0 END AS isLocked,  r.cre_user, r.cre_date, r.upd_user, r.upd_date, r.lock_user, r.lock_date,  r.version version, r.scheme, r.annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id";
        if (this.isHsqldb()) {
            qString = "SELECT r.id run_id, m.id model_id, s.id scen_id, m.name model, s.name scenario,  cast(d.id = r.id as BOOLEAN) isDefault,  cast(r.status = 0 as BOOLEAN) isLocked,  r.cre_user, r.cre_date, r.upd_user, r.upd_date, r.lock_user, r.lock_date,  r.version version, r.scheme, r.annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id";
        }
        qString = getOnlyDefault ? qString + " INNER JOIN" : qString + " LEFT JOIN";
        qString = qString + " run_default d ON (d.model_id=m.id and d.SCEN_ID=s.id and d.ID=r.id )";
        if (modelId > -1 && scenarioId > -1) {
            qString = qString + " where r.model_id=? and r.scen_id=?";
        } else if (modelId > -1) {
            qString = qString + " where r.model_id=?";
        } else if (scenarioId > -1) {
            qString = qString + " where d.scen_id=?";
        }
        qString = qString + " ORDER BY model, scenario, d.id, version desc";
        try {
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            if (modelId > -1 && scenarioId > -1) {
                stmt.setInt(1, modelId);
                stmt.setInt(2, scenarioId);
            } else if (modelId > -1) {
                stmt.setInt(1, modelId);
            } else if (scenarioId > -1) {
                stmt.setInt(1, scenarioId);
            }
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                Map<String, Object> row = this.getRunResultInfo(results);
                data.add(row);
            }
            results.close();
            stmt.close();
            return data;
        }
        catch (SQLException e) {
            String error = "There was a problem getting the list of scenarios from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public Map<String, Object> getModelScenarioName(int runId) throws IxException {
        boolean foundDS = false;
        HashMap<String, Object> retval = new HashMap<String, Object>();
        try {
            String qString = "SELECT m.name model, s.name scenario, r.version version, r.annotation annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id where r.id=? AND status >=0 ";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                foundDS = true;
                retval.put("model", results.getString("model"));
                retval.put("scenario", results.getString("scenario"));
                retval.put("version", results.getInt("version"));
                retval.put("annotation", results.getString("annotation"));
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem looking for scenarios in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        if (!foundDS) {
            String error = "There exists no scenario with run id " + runId + " in the database!";
            throw new IxException(error);
        }
        return retval;
    }

    public Map<String, Object> getRunInfo(int runId) throws IxException, SQLException {
        Map<String, Object> run = new HashMap<String, Object>();
        String sql = "SELECT r.id run_id, m.id model_id, s.id scen_id, m.name model, s.name scenario, CASE WHEN (d.id >= 0) THEN 1 ELSE 0 END isDefault, CASE r.status WHEN 0 THEN 1 WHEN 1 THEN 0 END AS isLocked,  r.cre_user, r.cre_date, r.upd_user, r.upd_date, r.lock_user, r.lock_date,  r.version version, r.scheme, r.annotation FROM run r left join model m on m.id = r.model_id  left join scenario s on  s.id = r.scen_id LEFT JOIN run_default d ON (d.model_id=m.id and d.SCEN_ID=s.id and d.ID=r.id ) WHERE r.id = ?";
        PreparedStatement stmt = this.dbConn.prepareStatement(sql);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        if (results.next()) {
            run = this.getRunResultInfo(results);
        }
        return run;
    }

    private Map<String, Object> getRunResultInfo(ResultSet result) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("run_id", result.getInt("run_id"));
        map.put("model_id", result.getInt("model_id"));
        map.put("scen_id", result.getInt("scen_id"));
        map.put("model", result.getString("model"));
        map.put("scenario", result.getString("scenario"));
        map.put("is_default", result.getBoolean("isDefault"));
        map.put("is_locked", result.getBoolean("isLocked"));
        map.put("cre_user", result.getString("cre_user"));
        map.put("cre_date", result.getString("cre_date"));
        map.put("upd_user", result.getString("upd_user"));
        map.put("upd_date", result.getString("upd_date"));
        map.put("lock_user", result.getString("lock_user"));
        map.put("lock_date", result.getString("lock_date"));
        map.put("version", result.getInt("version"));
        map.put("scheme", result.getString("scheme"));
        map.put("annotation", result.getString("annotation"));
        return map;
    }

    public int getRunId(String model, String scenario) throws IxException {
        return this.getRunId(model, scenario, true);
    }

    public int getRunId(String model, String scenario, boolean getMaxAsDefault) throws IxException {
        int retval = -1;
        int modelId = this.getSomeId("MODEL", model);
        int scenarioId = this.getSomeId("SCENARIO", scenario);
        try {
            String qString = "select ID from RUN_DEFAULT where MODEL_ID=? and SCEN_ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            if (getMaxAsDefault && retval == -1) {
                Object o;
                qString = "select max(id) from run where MODEL_ID=? and SCEN_ID=? and STATUS >=0 ";
                stmt = this.dbConn.prepareStatement(qString);
                stmt.setInt(1, modelId);
                stmt.setInt(2, scenarioId);
                results = stmt.executeQuery();
                if (results.next() && (o = results.getObject(1)) != null) {
                    retval = results.getInt(1);
                }
                results.close();
            }
            stmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem getting the run id from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return retval;
    }

    public int getRunId(String model, String scenario, int version) throws IxException {
        int retval = -1;
        int modelId = this.getSomeId("MODEL", model);
        int scenarioId = this.getSomeId("SCENARIO", scenario);
        try {
            String qString = "select id from RUN where MODEL_ID=? and SCEN_ID=? and VERSION=? and STATUS>=0";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.setInt(3, version);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem getting the run id from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        if (retval == -1) {
            String error = "There exists no Scenario '" + model + "|" + scenario + "' (version: " + version + ")  in the database!";
            throw new IxException(error);
        }
        return retval;
    }

    protected int getVersion(int runId) throws IxException {
        int retval = -1;
        try {
            String qString = "select VERSION from RUN where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem getting the version number from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        if (retval == -1) {
            String error = "There exists no Scenario with run id " + runId + " in the database!";
            throw new IxException(error);
        }
        return retval;
    }

    private int getLastVersion(int modelId, int scenarioId) throws IxException {
        int retval = -1;
        try {
            String qString = "select MAX(VERSION) from RUN where MODEL_ID=? and SCEN_ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                retval = results.getInt(1);
            }
            results.close();
            stmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem getting the last version number from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        if (retval == -1) {
            String error = "There exists no scenario for this model/scenario id's in the database!";
            throw new IxException(error);
        }
        return retval;
    }

    protected int assignRunId(String user, String model, String scenario, String scheme, String annotation) throws IxException {
        int modelId = this.assignSomeId("MODEL", model);
        int scenarioId = this.assignSomeId("SCENARIO", scenario);
        int nextVersion = this.getLastVersion(modelId, scenarioId);
        ++nextVersion;
        int runId = this.getNextSeq("RUN");
        try {
            String pString = "insert into RUN (id, model_id, scen_id, version, scheme, annotation, cre_user, cre_date) values (?,?,?,?,?,?,?,sysdate)";
            PreparedStatement stmt = this.dbConn.prepareStatement(pString);
            stmt.setInt(1, runId);
            stmt.setInt(2, modelId);
            stmt.setInt(3, scenarioId);
            stmt.setInt(4, nextVersion);
            if (scheme != null) {
                stmt.setString(5, scheme);
            } else {
                stmt.setNull(5, 12);
            }
            if (annotation != null) {
                stmt.setString(6, annotation);
            } else {
                stmt.setNull(6, 12);
            }
            stmt.setString(7, user);
            stmt.executeUpdate();
            stmt.close();
            this.dbConn.commit();
            return runId;
        }
        catch (Exception e) {
            String error = "There was a problem assigning a new run id in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected boolean isDefaultVersion(int runId) throws IxException {
        boolean retval = false;
        try {
            String qString = "select ID from RUN_DEFAULT where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = true;
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            String error = "There was a problem checking for the default version!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected void setDefaultVersion(String model, String scenario, int runId) throws IxException {
        int modelId = this.getSomeId("MODEL", model);
        int scenarioId = this.getSomeId("SCENARIO", scenario);
        try {
            String dString = "delete from RUN_DEFAULT where MODEL_ID=? and SCEN_ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(dString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.executeUpdate();
            stmt.close();
            String iString = "insert into RUN_DEFAULT (model_id, scen_id, id) values (?,?,?)";
            stmt = this.dbConn.prepareStatement(iString);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.setInt(3, runId);
            stmt.executeUpdate();
            stmt.close();
            this.dbConn.commit();
        }
        catch (SQLException e) {
            String error = "There was a problem setting the default version of a scenario in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public void unassignDefaultVersion(int runId) throws IxException {
        try {
            String dString = "delete from RUN_DEFAULT where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(dString);
            stmt.setInt(1, runId);
            stmt.executeUpdate();
            stmt.close();
            this.dbConn.commit();
        }
        catch (SQLException e) {
            String error = "There was a problem unassigning the default version of a scenario in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected void saveSeqItemId(int runId, int seqItemId) throws IxException {
        try {
            String uString = "update RUN set SEQ_ITEM_ID=? where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(uString);
            stmt.setInt(1, seqItemId);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            String error = "There was a problem saving the item sequence counter in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected int getSeqItemId(int runId) throws IxException {
        int retval = -1;
        try {
            String qString = "select SEQ_ITEM_ID from RUN where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt("SEQ_ITEM_ID");
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            String error = "There was a problem loading the item sequence counter from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected void setUpdUserDate(int runId) throws IxException {
        try {
            String user = System.getProperty("user.name", "(unknown)");
            String uString = "update RUN set UPD_USER=?, UPD_DATE=sysdate where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(uString);
            stmt.setString(1, user);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            String error = "There was a problem setting the user/timestamp for the update in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected Timestamp getLastUpdTimestamp(int runId) throws IxException {
        Timestamp retval = null;
        try {
            String qString = "select UPD_DATE, CRE_DATE from RUN where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                if (aRs.getTimestamp("UPD_DATE") != null) {
                    retval = aRs.getTimestamp("UPD_DATE");
                } else if (aRs.getTimestamp("CRE_DATE") != null) {
                    retval = aRs.getTimestamp("CRE_DATE");
                }
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            String error = "There was a problem getting the last-update timestamp for run id '" + runId + "'!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public int getStatus(int runId) throws IxException {
        try {
            int retval = -1;
            String qString = "select status from RUN where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt(1);
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            String error = "There was a problem retrieving the status for run id '" + runId + "'!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public HashMap<String, String> getLockInfo(int runId) throws IxException {
        HashMap<String, String> lockInfo = new HashMap<String, String>();
        String qString = "select LOCK_USER, LOCK_DATE from RUN where ID=" + runId;
        try {
            Statement stmt = this.dbConn.createStatement();
            ResultSet result = stmt.executeQuery(qString);
            if (result.next()) {
                lockInfo.put("lockUser", result.getString(1));
                lockInfo.put("lockDate", result.getString(2));
            }
            result.close();
            stmt.close();
            return lockInfo;
        }
        catch (SQLException e) {
            String error = "There was a problem retrieving lock information";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public void setStatus(int runId, int status) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.setStatus(user, runId, status);
    }

    public void setStatus(String user, int runId, int status) throws IxException {
        try {
            PreparedStatement stmt = null;
            if (status == 1 || status == -1) {
                String uString = "update RUN set STATUS=?, LOCK_USER=Null, LOCK_DATE=Null where ID=?";
                stmt = this.dbConn.prepareStatement(uString);
                stmt.setInt(1, status);
                stmt.setInt(2, runId);
            } else if (status == 0) {
                String uString = "update RUN set STATUS=0, LOCK_USER=?, LOCK_DATE=sysdate where ID=?";
                stmt = this.dbConn.prepareStatement(uString);
                stmt.setString(1, user);
                stmt.setInt(2, runId);
            }
            stmt.execute();
            stmt.close();
            this.dbConn.commit();
        }
        catch (SQLException e) {
            String error = "There was a problem setting the status for run id '" + runId + "'!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public String getScheme(int runId) throws IxException {
        try {
            String retval = null;
            String qString = "select scheme from RUN where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, runId);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getString(1);
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            String error = "There was a problem getting the scheme for run id '" + runId + "'!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected void setRunidAnnotation(int runId, String annotation) throws IxException {
        try {
            String pString = "update RUN set ANNOTATION=? where ID=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(pString);
            stmt.setString(1, annotation);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            String error = "There was a problem updating the annotation for run id '" + runId + "'!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    private int assignSomeId(String table, String name) throws IxException {
        int retval = -1;
        try {
            String qString = "select id from " + table + " where name=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setString(1, name);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt(1);
            } else {
                retval = this.getNextSeq(table);
                String iString = "insert into " + table + " (id,name) values (?,?)";
                stmt = this.dbConn.prepareStatement(iString);
                stmt.setInt(1, retval);
                stmt.setString(2, name);
                stmt.executeUpdate();
                stmt.close();
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (Exception e) {
            String error = "There was a problem assigning '" + name + "' in table '" + table + "' in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    private int getSomeId(String table, String name) throws IxException {
        int retval = -1;
        try {
            String qString = "select id from " + table + " where name=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setString(1, name);
            ResultSet aRs = stmt.executeQuery();
            if (aRs.next()) {
                retval = aRs.getInt(1);
            }
            aRs.close();
            stmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem getting '" + name + "' in table '" + table + "' from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        if (retval == -1) {
            String error = "There is no entry '" + name + "' in table '" + table + "' in the database!";
            throw new IxException(error);
        }
        return retval;
    }

    protected void writeChangeLog(int runId, int annotationId, LinkedList<ChangelogEntry> changeLogList) throws Exception {
        String iString = "insert into CHANGE_LOG (annotationid, runid, operation, item, key, val_prev, val_new) values (?,?,?,?,?,?,?)";
        OraclePreparedStatement oraPrepStmt = null;
        PreparedStatement stmt = null;
        boolean isOraclePrepStmt = false;
        if (this.isHsqldb()) {
            stmt = this.dbConn.prepareStatement(iString);
        } else {
            stmt = this.dbConn.prepareStatement(iString);
            oraPrepStmt = (OraclePreparedStatement)stmt;
            isOraclePrepStmt = true;
        }
        boolean hasUpdates = false;
        for (ChangelogEntry aEntry : changeLogList) {
            stmt.setInt(1, annotationId);
            stmt.setInt(2, runId);
            stmt.setString(3, aEntry.getOperation());
            stmt.setString(4, aEntry.getItem());
            if (aEntry.getKey() != null) {
                stmt.setString(5, aEntry.getKey());
            } else {
                stmt.setNull(5, 12);
            }
            if (aEntry.getValPrev() != null) {
                if (isOraclePrepStmt) {
                    oraPrepStmt.setBinaryDouble(6, aEntry.getValPrev().doubleValue());
                } else {
                    stmt.setDouble(6, aEntry.getValPrev());
                }
            } else {
                stmt.setNull(6, 8);
            }
            if (aEntry.getValNew() != null) {
                if (isOraclePrepStmt) {
                    oraPrepStmt.setBinaryDouble(7, aEntry.getValNew().doubleValue());
                } else {
                    stmt.setDouble(7, aEntry.getValNew());
                }
            } else {
                stmt.setNull(7, 8);
            }
            stmt.addBatch();
            hasUpdates = true;
        }
        if (hasUpdates) {
            stmt.executeBatch();
        }
        stmt.close();
    }

    protected void saveIdxSetToDB(int runId, Collection<IndexSet> collection) throws IxException {
        String selectString = "select runid, name from IX_IDXSET where runid=? and name =?";
        String asteriskString = "insert into IX_IDXSET (runid, name, itemid) values (?,?,?)";
        String insertString = "insert into IX_IDXSET (ele_blob, runid, name, itemid) values (?,?,?,?)";
        String updateString = "update IX_IDXSET set ele_blob=? where runid=? and name=?";
        try {
            PreparedStatement selectPrepStmt = this.dbConn.prepareStatement(selectString);
            selectPrepStmt.setInt(1, runId);
            selectPrepStmt.setString(2, "*");
            ResultSet aRs = selectPrepStmt.executeQuery();
            if (!aRs.next()) {
                PreparedStatement asteriskPrepStmt = this.dbConn.prepareStatement(asteriskString);
                asteriskPrepStmt.setInt(1, runId);
                asteriskPrepStmt.setString(2, "*");
                asteriskPrepStmt.setInt(3, -1);
                asteriskPrepStmt.executeUpdate();
                asteriskPrepStmt.close();
            }
            aRs.close();
            selectPrepStmt.close();
        }
        catch (Exception e) {
            String error = "Error saving the '*' index set!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        for (IndexSet aSet : collection) {
            String name = aSet.getName();
            try {
                PreparedStatement selectPrepStmt = this.dbConn.prepareStatement(selectString);
                selectPrepStmt.setInt(1, runId);
                selectPrepStmt.setString(2, name);
                ResultSet aRs = selectPrepStmt.executeQuery();
                boolean doUpdate = false;
                while (aRs.next()) {
                    doUpdate = true;
                }
                aRs.close();
                selectPrepStmt.close();
                int updateRc = -1;
                int insertRc = -1;
                boolean doBlobNull = true;
                ByteArrayInputStream bais = null;
                int blobLength = 0;
                LinkedList<Element> aBlob = aSet.getEleBlobForDB();
                if (!aBlob.isEmpty()) {
                    doBlobNull = false;
                    byte[] itemAsBytes = this.writeInputStream(aBlob, name);
                    bais = new ByteArrayInputStream(itemAsBytes);
                    blobLength = itemAsBytes.length;
                }
                if (doUpdate) {
                    PreparedStatement updatePrepStmt = this.dbConn.prepareStatement(updateString);
                    if (doBlobNull) {
                        updatePrepStmt.setNull(1, 2004);
                    } else {
                        updatePrepStmt.setBinaryStream(1, (InputStream)bais, blobLength);
                    }
                    updatePrepStmt.setInt(2, runId);
                    updatePrepStmt.setString(3, name);
                    updateRc = updatePrepStmt.executeUpdate();
                    logger.debug((Object)("update set '" + name + "' rc=" + updateRc + " size=" + blobLength));
                    updatePrepStmt.close();
                }
                if (updateRc == 1) continue;
                PreparedStatement insertPrepStmt = this.dbConn.prepareStatement(insertString);
                if (doBlobNull) {
                    insertPrepStmt.setNull(1, 2004);
                } else {
                    insertPrepStmt.setBinaryStream(1, (InputStream)bais, blobLength);
                }
                insertPrepStmt.setInt(2, runId);
                insertPrepStmt.setString(3, name);
                insertPrepStmt.setInt(4, aSet.getItemId());
                insertRc = insertPrepStmt.executeUpdate();
                logger.debug((Object)("insert set '" + name + "' rc=" + insertRc + " size=" + blobLength));
                insertPrepStmt.close();
            }
            catch (Exception e) {
                String error = "Error saving an item-blob to database!";
                logger.error((Object)error, (Throwable)e);
                throw new IxException(error);
            }
        }
    }

    protected void createSetInDB(int runId, Collection<Set> setList) throws IxException {
        LinkedHashSet<Item> aList = new LinkedHashSet<Item>();
        for (Set aSet : setList) {
            aList.add(aSet);
        }
        this.createItemInDB(runId, aList, "SET");
    }

    protected void createParInDB(int runId, Collection<Parameter> parList) throws IxException {
        LinkedHashSet<Item> aList = new LinkedHashSet<Item>();
        for (Parameter aPar : parList) {
            aList.add(aPar);
        }
        this.createItemInDB(runId, aList, "PAR");
    }

    protected void createVarInDB(int runId, Collection<Variable> varList) throws IxException {
        LinkedHashSet<Item> aList = new LinkedHashSet<Item>();
        for (Variable aVar : varList) {
            aList.add(aVar);
        }
        this.createItemInDB(runId, aList, "VAR");
    }

    protected void createEquInDB(int runId, Collection<Equation> equList) throws IxException {
        LinkedHashSet<Item> aList = new LinkedHashSet<Item>();
        for (Equation aEqu : equList) {
            aList.add(aEqu);
        }
        this.createItemInDB(runId, aList, "EQU");
    }

    protected void createItemInDB(int runId, LinkedHashSet<Item> itemList, String type) throws IxException {
        String name = null;
        String itemString = "insert into IX_" + type + " (runid, name, dim, itemid) values (?,?,?,?)";
        String dimString = "insert into IX_" + type + "_DIM (runid, name, idx, idx_set, idx_name) values (?,?,?,?,?)";
        String blobString = "insert into IX_" + type + "_BLOBSTORE (runid, name) values (?,?)";
        try {
            PreparedStatement prepDimStmt = this.dbConn.prepareStatement(dimString);
            PreparedStatement prepItemStmt = this.dbConn.prepareStatement(itemString);
            PreparedStatement prepBlobStmt = this.dbConn.prepareStatement(blobString);
            boolean batch = false;
            boolean dimBatch = false;
            for (Item aItem : itemList) {
                name = aItem.getName();
                prepItemStmt.setInt(1, runId);
                prepItemStmt.setString(2, name);
                prepItemStmt.setInt(3, aItem.getDim());
                prepItemStmt.setInt(4, aItem.getItemId());
                prepItemStmt.addBatch();
                batch = true;
                LinkedList<String> idxSets = aItem.getIdxSets();
                LinkedList<String> idxNames = aItem.getIdxNames();
                for (int idx = 0; idx < aItem.getDim(); ++idx) {
                    prepDimStmt.setInt(1, runId);
                    prepDimStmt.setString(2, name);
                    prepDimStmt.setInt(3, idx);
                    prepDimStmt.setString(4, idxSets.get(idx));
                    prepDimStmt.setString(5, idxNames.get(idx));
                    prepDimStmt.addBatch();
                    dimBatch = true;
                }
                prepBlobStmt.setInt(1, runId);
                prepBlobStmt.setString(2, aItem.getName());
                prepBlobStmt.addBatch();
            }
            if (batch) {
                prepItemStmt.executeBatch();
            }
            prepItemStmt.close();
            if (dimBatch) {
                prepDimStmt.executeBatch();
            }
            prepDimStmt.close();
            if (batch) {
                prepBlobStmt.executeBatch();
            }
            prepBlobStmt.close();
        }
        catch (Exception e) {
            String error = "Error creating the " + type + " '" + name + "' in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected void saveItemElementsToDB(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        LinkedList<Element> aBlob = item.getEleBlobForDB();
        ByteArrayInputStream bais = null;
        int blobLength = -1;
        if (!aBlob.isEmpty()) {
            byte[] itemAsBytes = this.writeInputStream(aBlob, name);
            bais = new ByteArrayInputStream(itemAsBytes);
            blobLength = itemAsBytes.length;
        }
        this.saveBlobToDB(runId, name, type, "ele", blobLength, bais);
        item.hasUpdatedElement = false;
    }

    protected void saveItemCommentsToDB(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        ByteArrayInputStream bais = null;
        int blobLength = -1;
        HashMap<Integer, LinkedList<Integer>> aMap = item.getCommentMapForDB();
        if (!aMap.isEmpty()) {
            byte[] itemAsBytes = this.writeInputStream(aMap, name);
            bais = new ByteArrayInputStream(itemAsBytes);
            blobLength = itemAsBytes.length;
        }
        this.saveBlobToDB(runId, name, type, "com", blobLength, bais);
        item.hasUpdatedComment = false;
    }

    private void saveBlobToDB(int runId, String name, String type, String col, int blobLength, ByteArrayInputStream bais) throws IxException {
        try {
            String updateString = "update IX_" + type + "_BLOBSTORE set " + col + "_blob=? where runid=? and name=?";
            PreparedStatement updatePrepStmt = this.dbConn.prepareStatement(updateString);
            if (blobLength == -1) {
                updatePrepStmt.setNull(1, 2004);
            } else {
                updatePrepStmt.setBinaryStream(1, (InputStream)bais, blobLength);
            }
            updatePrepStmt.setInt(2, runId);
            updatePrepStmt.setString(3, name);
            int updateRc = updatePrepStmt.executeUpdate();
            logger.debug((Object)("update " + type + " " + name + " rc=" + updateRc + " size=" + blobLength));
            updatePrepStmt.close();
        }
        catch (Exception e) {
            String error = "Error saving the " + type + " blob for item '" + name + "' to the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public void cloneItemBlobInDB(int runId, int prevRunId, String type, String name) throws IxException {
        try {
            String cloneString = "update IX_" + type + "_BLOBSTORE set (ele_blob, com_blob) " + "= (select ele_blob, com_blob from IX_" + type + "_BLOBSTORE where runid=? and name=?) " + "where runid=? and name=?";
            PreparedStatement clonePrepStmt = this.dbConn.prepareStatement(cloneString);
            clonePrepStmt.setInt(1, prevRunId);
            clonePrepStmt.setString(2, name);
            clonePrepStmt.setInt(3, runId);
            clonePrepStmt.setString(4, name);
            clonePrepStmt.executeUpdate();
            clonePrepStmt.close();
        }
        catch (Exception e) {
            String error = "Error copying the blob for item '" + name + "' to the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public void removeItemFromDB(int runId, LinkedHashSet<String> removedItemList, String type) throws IxException {
        try {
            String dimString = "delete from IX_" + type + "_DIM where runid=? and name=?";
            String itemString = "delete from IX_" + type + " where runid=? and name=?";
            PreparedStatement prepDimStmt = this.dbConn.prepareStatement(dimString);
            PreparedStatement prepItemStmt = this.dbConn.prepareStatement(itemString);
            boolean batch = false;
            for (String aItem : removedItemList) {
                this.removeItemElementsFromDB(runId, aItem, type);
                prepDimStmt.setInt(1, runId);
                prepDimStmt.setString(2, aItem);
                prepDimStmt.addBatch();
                prepItemStmt.setInt(1, runId);
                prepItemStmt.setString(2, aItem);
                prepItemStmt.addBatch();
                batch = true;
            }
            if (batch) {
                prepDimStmt.executeBatch();
                prepItemStmt.executeBatch();
            }
            prepDimStmt.close();
            prepItemStmt.close();
        }
        catch (Exception e) {
            String error = "Error removing an item from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    private void removeItemElementsFromDB(int runId, String name, String type) throws Exception {
        String dString = "delete from IX_" + type + "_BLOBSTORE where runid=? and name=?";
        PreparedStatement stmt = this.dbConn.prepareStatement(dString);
        stmt.setInt(1, runId);
        stmt.setString(2, name);
        int delRc = stmt.executeUpdate();
        logger.debug((Object)("removed " + type + " '" + name + "' from BLOB storage. rc=" + delRc));
        stmt.close();
    }

    private byte[] writeInputStream(Object blob, String name) throws IxException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
            oos.writeObject(blob);
            oos.flush();
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            String error = "Error creating a byte-array from a blob for item '" + name + "'!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    void getIndexSets(Scenario scen, int runId) throws Exception {
        String qString = "select name, itemid, ele_blob from IX_IDXSET where runid=? and itemid>-1 order by itemid";
        PreparedStatement stmt = this.dbConn.prepareStatement(qString);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        while (results.next()) {
            String name = results.getString(1);
            int itemId = results.getInt(2);
            Object aObject = null;
            InputStream is = null;
            LinkedList aBlob = null;
            if (results.getBlob(3) != null) {
                try {
                    ObjectInputStream oip = null;
                    try {
                        is = results.getBlob(3).getBinaryStream();
                        oip = new ObjectInputStream(new GZIPInputStream(is));
                    }
                    catch (ZipException ze) {
                        is = results.getBlob(3).getBinaryStream();
                        oip = new ObjectInputStream(is);
                    }
                    aObject = oip.readObject();
                    oip.close();
                }
                catch (Exception e) {
                    String error = "There was a problem reading a blob from the database";
                    logger.error((Object)error, (Throwable)e);
                    throw new IxException(error);
                }
                is.close();
            }
            aBlob = (LinkedList)aObject;
            new IndexSet(scen, name, itemId, aBlob);
        }
        results.close();
        stmt.close();
    }

    void getItemList(Scenario scen, int runId, String type) throws Exception {
        String qString = "select name, itemid, dim from IX_" + type + " where runid=? order by itemid";
        PreparedStatement stmt = this.dbConn.prepareStatement(qString);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        while (results.next()) {
            String name = results.getString(1);
            int itemId = results.getInt(2);
            int dim = results.getInt(3);
            if (type.equals("SET")) {
                new Set(scen, name, itemId, dim);
                continue;
            }
            if (type.equals("PAR")) {
                new Parameter(scen, name, itemId, dim);
                continue;
            }
            if (type.equals("VAR")) {
                new Variable(scen, name, itemId, dim);
                continue;
            }
            if (!type.equals("EQU")) continue;
            new Equation(scen, name, itemId, dim);
        }
        results.close();
        stmt.close();
        qString = "select name, idx, idx_set, idx_name from IX_" + type + "_DIM where runid=? order by name, idx";
        stmt = this.dbConn.prepareStatement(qString);
        stmt.setInt(1, runId);
        results = stmt.executeQuery();
        Item aItem = null;
        String name = "";
        while (results.next()) {
            if (!name.equals(results.getString(1))) {
                name = results.getString(1);
                aItem = scen.getItem(name);
            }
            int idx = results.getInt(2);
            String idxSet = results.getString(3);
            String idxName = results.getString(4);
            aItem.setIXitemDimsFromDB(idx, idxSet, idxName);
        }
        results.close();
        stmt.close();
    }

    boolean hasItemElementsInBlob(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        return this.hasItemBlob(runId, name, type, "ele");
    }

    private boolean hasItemBlob(int runId, String name, String type, String col) throws IxException {
        boolean retval = false;
        try {
            String qString = "select " + col + "_blob from ix_" + type + "_blobstore where runid=? and name=? and " + col + "_blob is not null";
            PreparedStatement qStmt = this.dbConn.prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setString(2, name);
            ResultSet results = qStmt.executeQuery();
            if (results.next()) {
                retval = true;
            }
            results.close();
            qStmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem checking for a blob of item " + name + " in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return retval;
    }

    protected void getItemElementsFromDB(int runId, Item item) throws IxException {
        logger.debug((Object)("loading elements for " + item.getTypeName() + " from database..."));
        Object aObject = this.getBlobFromDB(runId, item, "ele");
        if (aObject != null) {
            LinkedList aBlob = (LinkedList)aObject;
            if (item instanceof Set) {
                item.setElementListFromDB(aBlob);
            } else if (item instanceof Parameter) {
                ((Parameter)item).setElementListFromDB(aBlob);
            } else if (item instanceof Variable) {
                ((Variable)item).setElementListFromDB(aBlob);
            } else if (item instanceof Equation) {
                ((Equation)item).setElementListFromDB(aBlob);
            }
        }
    }

    protected HashMap<Integer, LinkedList<Integer>> getItemCommentsFromDB(int runId, Item item) throws IxException {
        logger.debug((Object)("loading comments for " + item.getTypeName() + " from database..."));
        Object aObject = this.getBlobFromDB(runId, item, "com");
        return (HashMap)aObject;
    }

    private Object getBlobFromDB(int runId, Item item, String col) throws IxException {
        Object aObject = null;
        try {
            String type = item.getTypeForDB();
            String name = item.getName();
            String qString = "select " + col + "_blob from ix_" + type + "_blobstore where runid=? and name=?";
            PreparedStatement qStmt = this.dbConn.prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setString(2, name);
            ResultSet aRs = qStmt.executeQuery();
            while (aRs.next()) {
                if (aRs.getBlob(1) == null) continue;
                InputStream is = null;
                try {
                    ObjectInputStream oip = null;
                    try {
                        is = aRs.getBlob(1).getBinaryStream();
                        oip = new ObjectInputStream(new GZIPInputStream(is));
                    }
                    catch (ZipException ze) {
                        is = aRs.getBlob(1).getBinaryStream();
                        oip = new ObjectInputStream(is);
                    }
                    aObject = oip.readObject();
                    oip.close();
                }
                catch (Exception e) {
                    String error = "There was a problem reading the blob of " + item.getTypeName() + " from the database!";
                    logger.error((Object)error, (Throwable)e);
                    throw new IxException(error);
                }
                is.close();
            }
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            String error = "There was a problem loading elements of " + item.getTypeName() + " from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return aObject;
    }

    public void writeAnnotation(int runId, String status, int annotationId, String script, String text) throws Exception {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.writeAnnotation(osUser, runId, status, annotationId, script, text);
    }

    protected void writeAnnotation(String user, int runId, String status, int annotationId, String script, String annotation) throws Exception {
        String iString = "insert into ANNOTATION_LOG (annotationid, status, runid, interface, script, cre_user, cre_date, text) values (?,?,?,?,?,?,sysdate,?)";
        PreparedStatement stmt = this.dbConn.prepareStatement(iString);
        stmt.setInt(1, annotationId);
        stmt.setString(2, status);
        stmt.setInt(3, runId);
        stmt.setString(4, dbInterface);
        stmt.setString(5, script);
        stmt.setString(6, user);
        stmt.setString(7, annotation);
        stmt.executeUpdate();
        stmt.close();
    }

    public int assignAnnotationId() throws IxException {
        return this.getNextSeq("ANNOTATION");
    }

    protected void createKeysInDB(int runId, HashMap<Integer, String> idKeyMap) throws SQLException {
        String iString = "insert into IX_KEY (runid, keyid, key) values (?,?,?)";
        PreparedStatement stmt = this.dbConn.prepareStatement(iString);
        boolean batch = false;
        for (Map.Entry<Integer, String> entry : idKeyMap.entrySet()) {
            stmt.setInt(1, runId);
            stmt.setInt(2, entry.getKey());
            stmt.setString(3, entry.getValue());
            stmt.addBatch();
            batch = true;
        }
        if (batch) {
            stmt.executeBatch();
        }
        stmt.close();
    }

    protected int getKeyIdList(int runId, Scenario scen) throws SQLException {
        int nextId = 0;
        String qString = "select keyid, key from IX_KEY where runid=? order by keyid";
        PreparedStatement stmt = this.dbConn.prepareStatement(qString);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        while (results.next()) {
            int keyId = results.getInt(1);
            String keyString = results.getString(2);
            scen.addKeyFromDB(keyId, keyString);
            nextId = keyId;
        }
        results.close();
        stmt.close();
        return nextId;
    }

    protected void saveCommentsInDB(int runId, HashMap<Integer, String> idCommentMap) throws SQLException {
        String iString = "insert into IX_COMMENT (runid, comid, comstring) values (?,?,?)";
        PreparedStatement stmt = this.dbConn.prepareStatement(iString);
        boolean batch = false;
        for (Map.Entry<Integer, String> entry : idCommentMap.entrySet()) {
            stmt.setInt(1, runId);
            stmt.setInt(2, entry.getKey());
            stmt.setString(3, entry.getValue());
            stmt.addBatch();
            batch = true;
        }
        if (batch) {
            stmt.executeBatch();
        }
        stmt.close();
    }

    protected int getCommentIdList(int runId, Scenario scenario) throws SQLException {
        int nextId = 0;
        String qString = "select comid, comstring from IX_COMMENT where runid=? order by comid";
        PreparedStatement stmt = this.dbConn.prepareStatement(qString);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        while (results.next()) {
            int comId = results.getInt(1);
            String keyString = results.getString(2);
            scenario.addCommentFromDB(comId, keyString);
            nextId = comId;
        }
        results.close();
        stmt.close();
        return nextId;
    }

    public List<Map<String, Object>> getAnnotationLog(int runId) throws Exception {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String qString = "SELECT annotationid, status, runid, script, cre_user, cre_date, upd_user, upd_date, text, interface from ANNOTATION_LOG WHERE runid=?";
        PreparedStatement stmt = this.dbConn.prepareStatement(qString);
        stmt.setInt(1, runId);
        ResultSet results = stmt.executeQuery();
        while (results.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("annotationid", results.getInt("annotationid"));
            row.put("status", results.getString("status"));
            row.put("runid", results.getInt("runid"));
            row.put("script", results.getString("script"));
            row.put("cre_user", results.getString("cre_user"));
            row.put("cre_date", results.getDate("cre_date"));
            row.put("upd_user", results.getString("upd_user"));
            row.put("upd_date", results.getDate("upd_date"));
            row.put("text", results.getString("text"));
            row.put("interface", results.getString("interface"));
            data.add(row);
        }
        results.close();
        stmt.close();
        return data;
    }

    public List<Map<String, Object>> getChangeLog(int annotationId) throws Exception {
        try {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            String qString = "SELECT annotationid, runid, operation, item, key, val_prev, val_new, seq from CHANGE_LOG WHERE annotationid=?";
            PreparedStatement stmt = this.dbConn.prepareStatement(qString);
            stmt.setInt(1, annotationId);
            ResultSet results = stmt.executeQuery();
            while (results.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("annotationid", results.getInt("annotationid"));
                row.put("runid", results.getInt("runid"));
                row.put("operation", results.getString("operation"));
                row.put("item", results.getString("item"));
                row.put("key", results.getString("key"));
                row.put("val_prev", results.getDouble("val_prev"));
                row.put("val_new", results.getDouble("val_new"));
                row.put("seq", results.getInt("seq"));
                data.add(row);
            }
            results.close();
            stmt.close();
            return data;
        }
        catch (SQLException e) {
            String error = "Error reading the change-log table from the IXMP database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public HashMap<Integer, ArrayList<Integer>> getIamVariableIdsOfRunIds(List<Integer> runIds) throws IxException {
        HashMap<Integer, ArrayList<Integer>> variableIds = new HashMap<Integer, ArrayList<Integer>>();
        String sql = "select runid,key from IAMC_TSINFO WHERE runid in (" + this.concatQString(runIds) + ")";
        try {
            PreparedStatement statement = this.dbConn.prepareStatement(sql);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                Integer runId = results.getInt("runid");
                Integer variableId = results.getInt("key");
                variableIds.computeIfAbsent(runId, varsOfRun -> new ArrayList()).add(variableId);
            }
        }
        catch (SQLException e) {
            String error = "error fetching variable ids of runs " + runIds.toString();
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return variableIds;
    }

    public ArrayList<IamVariable> getIamVariables(Platform mp, List<Integer> variableIds) throws IxException {
        ArrayList<IamVariable> iamVariables = new ArrayList<IamVariable>();
        String qString = "select keyid, keystring, unitid from IAMC_KEY where keyid in (" + this.concatQString(variableIds) + ")";
        try {
            Statement statement = this.dbConn.createStatement();
            ResultSet result = statement.executeQuery(qString);
            while (result.next()) {
                iamVariables.add(new IamVariable(mp, result.getString("keystring"), result.getInt("unitid"), result.getInt("keyid")));
            }
            result.close();
            statement.close();
        }
        catch (SQLException e) {
            String error = "error fetching IamVariables from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return iamVariables;
    }

    public IamVariable getIamVariableFromDB(Platform mp, String variable, int unitId, int variableId) throws IxException {
        IamVariable retval = null;
        try {
            Statement stmt = this.dbConn.createStatement();
            String qString = "select keyid, keystring, unitid from IAMC_KEY";
            if (variable != null && unitId > -1) {
                qString = qString + " where keystring='" + variable + "' and unitid=" + unitId;
            } else if (variable != null) {
                qString = qString + " where keystring='" + variable + "'";
            } else if (variableId != -1) {
                qString = qString + " where keyid='" + variableId + "'";
            }
            ResultSet aRs = stmt.executeQuery(qString);
            while (aRs.next()) {
                retval = new IamVariable(mp, aRs.getString(2), aRs.getInt(3), aRs.getInt(1));
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            String error = "error reading an IamVariable from the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public int assignIamVariableInDB(String variable, int unitId, String scheme) throws IxException {
        int variableId = this.getNextSeq("IAMC_KEY");
        try {
            String iString = "insert into IAMC_KEY (keyid,keystring,unitid,cre_user,cre_date,scheme) values (?,?,?,?,sysdate,?)";
            PreparedStatement prepStmt = this.dbConn.prepareStatement(iString);
            prepStmt.setInt(1, variableId);
            prepStmt.setString(2, variable);
            prepStmt.setInt(3, unitId);
            prepStmt.setString(4, System.getProperty("user.name", "(unknown)"));
            prepStmt.setString(5, scheme);
            prepStmt.executeUpdate();
            prepStmt.close();
            return variableId;
        }
        catch (SQLException e) {
            String error = "Error assigning a new IamVariable in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public HashMap<Integer, String> getNodeFromDB(String node, int id) throws IxException {
        HashMap<Integer, String> retval = new HashMap<Integer, String>();
        PreparedStatement prepStmt = null;
        String error = null;
        try {
            String qString = "select id, name from IAMC_NODES";
            if (node != null) {
                qString = qString + " where name=?";
                prepStmt = this.dbConn.prepareStatement(qString);
                prepStmt.setString(1, this.cleanString(node));
                error = "error getting the node-id mapping for node '" + node + "' from the database!";
            } else {
                qString = qString + " where id=?";
                prepStmt = this.dbConn.prepareStatement(qString);
                prepStmt.setInt(1, id);
                error = "error getting the node-id mapping for id '" + id + "' from the database!";
            }
            ResultSet aRs = prepStmt.executeQuery();
            while (aRs.next()) {
                retval.put(aRs.getInt(1), aRs.getString(2));
            }
            aRs.close();
            prepStmt.close();
            return retval;
        }
        catch (SQLException e) {
            logger.error(error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public HashMap<String, Integer> getNodeSynonymsFromDB(String pNode) throws IxException {
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        try {
            Statement stmt = this.dbConn.createStatement();
            String qString = "select node_synonym, node_id from IAMC_NODES_SYNONYM where node_synonym='" + this.cleanString(pNode) + "'";
            ResultSet aRs = stmt.executeQuery(qString);
            while (aRs.next()) {
                retval.put(aRs.getString(1), aRs.getInt(2));
            }
            aRs.close();
            stmt.close();
            return retval;
        }
        catch (SQLException e) {
            logger.error((Object)("error getting the node-id synonym mapping for node '" + pNode + "' from the database!"), (Throwable)e);
            throw new IxException("error getting the node-id synonym mapping for node '" + pNode + "' from the database!");
        }
    }

    public int addUnitToDB(String pUnit, String pScheme) throws IxException {
        int retval = this.getNextSeq("UNIT");
        try {
            String iString = "insert into IX_UNIT (id,name,cre_user,cre_date,scheme) values (?,?,?,sysdate,?)";
            PreparedStatement prepStmt = this.dbConn.prepareStatement(iString);
            prepStmt.setInt(1, retval);
            prepStmt.setString(2, pUnit);
            prepStmt.setString(3, System.getProperty("user.name", "(unknown)"));
            prepStmt.setString(4, pScheme);
            prepStmt.executeUpdate();
            prepStmt.close();
            this.dbConn.commit();
            return retval;
        }
        catch (SQLException e) {
            String error = "Error assigning an unit-key-id mapping in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException("error assigning a new unit in the database!");
        }
    }

    public HashMap<Integer, String> getUnitFromDB(String unit, int id) throws IxException {
        HashMap<Integer, String> retval = new HashMap<Integer, String>();
        PreparedStatement prepStmt = null;
        String error = null;
        try {
            String qString = "select id, name from IX_UNIT";
            if (unit != null) {
                qString = qString + " where name=?";
                prepStmt = this.dbConn.prepareStatement(qString);
                prepStmt.setString(1, this.cleanString(unit));
                error = "error getting the unit-id mapping for unit '" + unit + "' from the database!";
            } else if (id > -1) {
                qString = qString + " where id=?";
                prepStmt = this.dbConn.prepareStatement(qString);
                prepStmt.setInt(1, id);
                error = "error getting the unit-id mapping for id '" + id + "' from the database!";
            } else {
                prepStmt = this.dbConn.prepareStatement(qString);
                error = "error loading all units from the database!";
            }
            ResultSet aRs = prepStmt.executeQuery();
            while (aRs.next()) {
                int unitId = aRs.getInt(1);
                String unitString = aRs.getString(2);
                retval.put(unitId, unitString);
            }
            aRs.close();
            prepStmt.close();
            return retval;
        }
        catch (SQLException e) {
            logger.error(error, (Throwable)e);
            throw new IxException(error);
        }
    }

    protected HashMap<Vector<Integer>, Integer> saveTimeseriesToDB(int pRunId, LinkedHashMap<Vector<Integer>, LinkedHashMap<Integer, Double>> tsList) throws Exception {
        HashMap<Vector<Integer>, Integer> tsInfo = this.getTsInfoFromDB(pRunId);
        try {
            String iStringInfo = "insert into IAMC_TSINFO (tsid, runid, node, key, meta, time) values (?,?,?,?,?,?)";
            String iStringData = "insert into IAMC_TSDATA (tsid, year, value) values (?,?,?)";
            PreparedStatement infoStmt = this.dbConn.prepareStatement(iStringInfo);
            PreparedStatement dataStmt = this.dbConn.prepareStatement(iStringData);
            OraclePreparedStatement oraDataStmt = null;
            boolean isOraclePrepStmt = false;
            if (!this.isHsqldb()) {
                oraDataStmt = (OraclePreparedStatement)dataStmt;
                isOraclePrepStmt = true;
            }
            boolean batchInfo = false;
            boolean batchData = false;
            for (Map.Entry<Vector<Integer>, LinkedHashMap<Integer, Double>> aTs : tsList.entrySet()) {
                int tsId = -1;
                try {
                    tsId = tsInfo.get(aTs.getKey());
                }
                catch (Exception e) {
                    tsId = this.getNextSeq("IAMC_TS");
                    infoStmt.setInt(1, tsId);
                    infoStmt.setInt(2, pRunId);
                    infoStmt.setInt(3, aTs.getKey().get(0));
                    infoStmt.setInt(4, aTs.getKey().get(1));
                    infoStmt.setInt(5, aTs.getKey().get(2));
                    if (aTs.getKey().size() > 3) {
                        infoStmt.setInt(6, aTs.getKey().get(3));
                    } else {
                        infoStmt.setInt(6, -1);
                    }
                    infoStmt.addBatch();
                    batchInfo = true;
                    tsInfo.put(aTs.getKey(), tsId);
                }
                for (Map.Entry<Integer, Double> data : aTs.getValue().entrySet()) {
                    dataStmt.setInt(1, tsId);
                    dataStmt.setInt(2, data.getKey());
                    if (isOraclePrepStmt) {
                        oraDataStmt.setBinaryDouble(3, data.getValue().doubleValue());
                    } else {
                        dataStmt.setDouble(3, data.getValue());
                    }
                    dataStmt.addBatch();
                    batchData = true;
                }
            }
            if (batchInfo) {
                infoStmt.executeBatch();
            }
            infoStmt.close();
            if (batchData) {
                dataStmt.executeBatch();
            }
            dataStmt.close();
        }
        catch (Exception e) {
            String error = "Error writing the timeseries data to the IXMP database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return tsInfo;
    }

    protected void updateTimeseriesInDB(int pRunId, HashMap<Vector<Integer>, Integer> tsInfo, LinkedHashMap<Vector<Integer>, LinkedHashMap<Integer, Double>> tsList) throws Exception {
        try {
            String iStringInfo = "insert into IAMC_TSINFO (tsid, runid, node, key, meta, time) values (?,?,?,?,?,?)";
            String iStringData = "update IAMC_TSDATA set value=? where tsid=? and year=?";
            PreparedStatement infoStmt = this.dbConn.prepareStatement(iStringInfo);
            PreparedStatement dataStmt = this.dbConn.prepareStatement(iStringData);
            boolean batchInfo = false;
            boolean batchData = false;
            for (Map.Entry<Vector<Integer>, LinkedHashMap<Integer, Double>> aTs : tsList.entrySet()) {
                int tsId = -1;
                try {
                    tsId = tsInfo.get(aTs.getKey());
                }
                catch (Exception e) {
                    tsId = this.getNextSeq("IAMC_TS");
                    infoStmt.setInt(1, tsId);
                    infoStmt.setInt(2, pRunId);
                    infoStmt.setInt(3, aTs.getKey().get(0));
                    infoStmt.setInt(4, aTs.getKey().get(1));
                    infoStmt.setInt(5, aTs.getKey().get(2));
                    if (aTs.getKey().size() > 3) {
                        infoStmt.setInt(6, aTs.getKey().get(3));
                    } else {
                        infoStmt.setInt(6, -1);
                    }
                    infoStmt.addBatch();
                    batchInfo = true;
                    tsInfo.put(aTs.getKey(), tsId);
                }
                for (Map.Entry<Integer, Double> data : aTs.getValue().entrySet()) {
                    dataStmt.setDouble(1, data.getValue());
                    dataStmt.setInt(2, tsId);
                    dataStmt.setInt(3, data.getKey());
                    dataStmt.addBatch();
                    batchData = true;
                }
            }
            if (batchInfo) {
                infoStmt.executeBatch();
            }
            infoStmt.close();
            if (batchData) {
                dataStmt.executeBatch();
            }
            dataStmt.close();
        }
        catch (Exception e) {
            String error = "Error writing the timeseries data to the IXMP database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public void cloneTimeseriesInDB(int runId, int prevRunId, boolean isMeta, Integer firstYear) throws IxException {
        try {
            String queryInfo = "select tsid, node, key, meta, time from IAMC_TSINFO where runid=? and meta=?";
            String cloneInfo = "insert into IAMC_TSINFO (runid, tsid, node, key, meta, time) select ?, ?, node, key, meta, time from IAMC_TSINFO where tsid=?";
            String cloneData = "insert into IAMC_TSDATA (tsid, year, value) select ?, year, value from IAMC_TSDATA where tsid=?";
            boolean batchData = false;
            boolean isSlice = false;
            if (firstYear != null && firstYear > 0) {
                isSlice = true;
            }
            if (isSlice) {
                cloneData = cloneData + " and year<?";
            }
            PreparedStatement qInfoStmt = this.dbConn.prepareStatement(queryInfo);
            PreparedStatement cInfoStmt = this.dbConn.prepareStatement(cloneInfo);
            PreparedStatement cDataStmt = this.dbConn.prepareStatement(cloneData);
            qInfoStmt.setInt(1, prevRunId);
            int meta = 0;
            if (isMeta) {
                meta = 1;
            }
            qInfoStmt.setInt(2, meta);
            ResultSet aRs = qInfoStmt.executeQuery();
            while (aRs.next()) {
                int prevTsId = aRs.getInt("tsid");
                int newTsId = this.getNextSeq("IAMC_TS");
                cInfoStmt.setInt(1, runId);
                cInfoStmt.setInt(2, newTsId);
                cInfoStmt.setInt(3, prevTsId);
                cInfoStmt.addBatch();
                cDataStmt.setInt(1, newTsId);
                cDataStmt.setInt(2, prevTsId);
                if (isSlice) {
                    cDataStmt.setInt(3, firstYear);
                }
                cDataStmt.addBatch();
                batchData = true;
            }
            aRs.close();
            qInfoStmt.close();
            if (batchData) {
                cInfoStmt.executeBatch();
                cDataStmt.executeBatch();
            }
            cInfoStmt.close();
            cDataStmt.close();
        }
        catch (Exception e) {
            String error = "Error cloning timeseries data in the database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    private HashMap<Vector<Integer>, Integer> getTsInfoFromDB(Integer runId) throws IxException {
        HashMap<Vector<Integer>, Integer> tsInfo = new HashMap<Vector<Integer>, Integer>();
        try {
            String qString = "select node, key, meta, time, tsid from IAMC_TSINFO where runid=?";
            PreparedStatement qStmt = this.dbConn.prepareStatement(qString);
            qStmt.setInt(1, runId);
            ResultSet aRs = qStmt.executeQuery();
            while (aRs.next()) {
                tsInfo.put(this.getVecNdId(aRs.getInt("node"), aRs.getInt("key"), aRs.getInt("meta"), aRs.getInt("time")), aRs.getInt("tsid"));
            }
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            String error = "Error loading existing timeseries-info entries from database!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return tsInfo;
    }

    public List<Integer> getVariableUnitKeys(List<String> variableNames, List<Integer> unitIds) throws IxException {
        LinkedList<Integer> keyIds = new LinkedList<Integer>();
        String sql = " select keyid from iamc_key ";
        Boolean sqlContainsUnits = false;
        if (!DatabaseQueries.isEmpty(unitIds)) {
            sql = sql + " where unitid in (" + this.concatQString(unitIds) + ")";
            sqlContainsUnits = true;
        }
        if (!DatabaseQueries.isEmpty(variableNames)) {
            sql = sqlContainsUnits != false ? sql + " and " : sql + " where ";
            sql = sql + "keystring in (" + this.joinStrings(variableNames) + ")";
        }
        try {
            PreparedStatement statement = this.dbConn.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keyIds.add(resultSet.getInt("keyid"));
            }
        }
        catch (Exception e) {
            String error = "error fetching keys of variable-units (table IAMC_KEY)";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
        return keyIds;
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    protected void addToTimeseriesList(LinkedHashMap<Vector<Integer>, LinkedHashMap<Integer, Double>> pTsList, Integer runId, Integer pKeyId) throws IxException {
        try {
            int meta;
            int time;
            int node;
            String qString = "select i.node, i.time, i.meta, d.year, d.value  from iamc_tsinfo i inner join iamc_tsdata d on (i.tsid = d.tsid) where i.runid=? and i.key=? order by node, key, time, year";
            PreparedStatement qStmt = this.dbConn.prepareStatement(qString);
            qStmt.setInt(1, runId);
            qStmt.setInt(2, pKeyId);
            ResultSet aRs = qStmt.executeQuery();
            Vector<Object> vecNdId = new Vector();
            LinkedHashMap<Integer, Double> data = new LinkedHashMap<Integer, Double>();
            int prevNode = -1;
            int prevMeta = -1;
            int prevTime = -1;
            if (aRs.isFirst()) {
                node = aRs.getInt("node");
                time = aRs.getInt("time");
                meta = aRs.getInt("meta");
                vecNdId = this.getVecNdId(node, pKeyId, meta, time);
                data.put(aRs.getInt("year"), aRs.getDouble("value"));
                prevNode = node;
                prevMeta = meta;
                prevTime = time;
                aRs.next();
            }
            while (aRs.next()) {
                node = aRs.getInt("node");
                time = aRs.getInt("time");
                meta = aRs.getInt("meta");
                if (node != prevNode || meta != prevMeta || time != prevTime) {
                    pTsList.put(vecNdId, data);
                    vecNdId = this.getVecNdId(node, pKeyId, meta, time);
                    data = new LinkedHashMap();
                    prevNode = node;
                    prevTime = time;
                }
                data.put(aRs.getInt("year"), aRs.getDouble("value"));
            }
            pTsList.put(vecNdId, data);
            aRs.close();
            qStmt.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IxException("Error loading existing timeseries-data entries from database!");
        }
    }

    protected List<Map<String, Object>> getTimeseriesFromDB(Platform mp, List<Integer> runIdList, List<Integer> nodeList, List<Integer> keyList, List<Integer> timeList, List<Integer> yearList) throws IxException {
        HashMap<Integer, Map<String, Object>> runidMap = new HashMap<Integer, Map<String, Object>>();
        for (int runid : runIdList) {
            runidMap.put(runid, this.getModelScenarioName(runid));
        }
        int prevRunid = -1;
        String model = null;
        String scenario = null;
        int version = -1;
        ArrayList<Map<String, Object>> timeseries = new ArrayList<Map<String, Object>>();
        String qString = " select i.runid, i.node, i.key, i.time, d.year, d.value  from iamc_tsinfo i  inner join iamc_tsdata d on (i.tsid = d.tsid)  where runid in (" + this.concatQString(runIdList) + ")";
        if (!DatabaseQueries.isEmpty(nodeList)) {
            qString = qString + " and node in (" + this.concatQString(nodeList) + ")";
        }
        if (!DatabaseQueries.isEmpty(keyList)) {
            qString = qString + " and key in (" + this.concatQString(keyList) + ")";
        }
        if (!DatabaseQueries.isEmpty(timeList)) {
            qString = qString + " and time in (" + this.concatQString(timeList) + ")";
        }
        if (!DatabaseQueries.isEmpty(yearList)) {
            qString = qString + " and year in (" + this.concatQString(yearList) + ")";
        }
        qString = qString + " order by runid, node, key, time, year";
        try {
            Statement statement = this.dbConn.createStatement();
            ResultSet resultSet = statement.executeQuery(qString);
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                if (resultSet.getInt("runid") != prevRunid) {
                    Map runidInfo = (Map)runidMap.get(resultSet.getInt("runid"));
                    model = (String)runidInfo.get("model");
                    scenario = (String)runidInfo.get("scenario");
                    version = (Integer)runidInfo.get("version");
                    prevRunid = resultSet.getInt("runid");
                }
                row.put("model", model);
                row.put("scenario", scenario);
                row.put("version", version);
                row.put("region", mp.getNodeName(resultSet.getInt("node")));
                int variableId = resultSet.getInt("key");
                IamVariable iamVar = mp.getIamVariable(variableId);
                row.put("variable", iamVar.getString());
                row.put("unit", iamVar.getUnit());
                if (timeList != null) {
                    row.put("time", resultSet.getInt("time"));
                }
                row.put("year", resultSet.getInt("year"));
                row.put("value", resultSet.getDouble("value"));
                timeseries.add(row);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IxException("error reading timeseries data from the IXMP database!");
        }
        return timeseries;
    }

    private int getNextSeq(String pTable) throws IxException {
        int retval = 1;
        try {
            ResultSet aRs;
            Statement stmt = this.dbConn.createStatement();
            String qString = "select " + pTable + "_seq.nextval from dual";
            if (this.isHsqldb()) {
                qString = "VALUES NEXT VALUE FOR " + pTable + "_seq";
            }
            if ((aRs = stmt.executeQuery(qString)).next()) {
                retval = aRs.getInt(1);
            }
            aRs.close();
            stmt.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IxException("error getting the next sequence number for table '" + pTable + "'!");
        }
        return retval;
    }

    protected Vector<Integer> getVecNdId(int pNode, int pKey, int pMeta, int pTime) {
        Vector<Integer> vecNdId = new Vector<Integer>();
        vecNdId.add(pNode);
        vecNdId.add(pKey);
        vecNdId.add(pMeta);
        if (pTime != -1) {
            vecNdId.add(pTime);
        }
        return vecNdId;
    }

    private String concatQString(List<Integer> pList) {
        StringBuilder strbul = new StringBuilder();
        Iterator<Integer> iter = pList.iterator();
        while (iter.hasNext()) {
            strbul.append(iter.next());
            if (!iter.hasNext()) continue;
            strbul.append(",");
        }
        return strbul.toString();
    }

    private String joinStrings(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("'");
            builder.append(string);
            builder.append("'");
        }
        return builder.toString();
    }

    public String cleanString(String text) {
        return text.replaceAll("'", "''");
    }

    @Deprecated
    public void cleanupById(int pRunid, int pAnnotationId, String pCase, String name) throws IxException, SQLException {
        String osUser = System.getProperty("user.name", "(unknown)");
        Statement stmt = null;
        try {
            stmt = this.dbConn.createStatement();
            String status = null;
            LinkedList<Object> tables = new LinkedList<Object>();
            if (pCase.equals("scenario")) {
                for (String string : this.ixParTables) {
                    tables.add(string);
                }
                for (String string : this.ixVarTables) {
                    tables.add(string);
                }
                for (String string : this.ixSetTables) {
                    tables.add(string);
                }
                for (String string : this.ixStructure) {
                    tables.add(string);
                }
                status = "deleted";
            } else if (pCase.equals("Var")) {
                for (String string : this.ixVarTables) {
                    tables.add(string);
                }
                status = "solution imported";
            } else if (pCase.equals("refTS")) {
                status = "deleted";
            }
            for (String string : tables) {
                String dString = "delete from " + string + " where runid=" + pRunid;
                if (name != null) {
                    dString = dString + " and name='" + name + "'";
                }
                logger.debug((Object)dString);
                int n = stmt.executeUpdate(dString);
                logger.info((Object)("table " + string + ": " + n + " records deleted."));
            }
            String iString = "update ANNOTATION_LOG set STATUS='" + status + " (" + pAnnotationId + ")', UPD_USER='" + osUser + "', UPD_DATE=sysdate" + " where RUNID='" + pRunid + "' and STATUS='ok'";
            stmt.executeUpdate(iString);
        }
        catch (Exception e) {
            this.dbConn.rollback();
            throw new IxException("The Scenario (runid " + pRunid + ") could not be deleted!'");
        }
        stmt.close();
        this.dbConn.commit();
    }

    public void openSourceConnection() throws Exception {
        logger.info((Object)("URL (source):" + this.dbConfig.getDbUrl1() + "|" + this.dbConfig.getDbUsr1() + "|" + this.dbConfig.getDbPwd1()));
        Class.forName(this.dbConfig.getDbDriver1());
        this.sourceConn = DriverManager.getConnection(this.dbConfig.getDbUrl1(), this.dbConfig.getDbUsr1(), this.dbConfig.getDbPwd1());
        this.sourceConn.setAutoCommit(false);
        logger.info((Object)("URL (source):" + this.dbConfig.getDbUrl1()));
    }

    protected void openConn() throws IxException {
        try {
            logger.debug((Object)("URL (source):" + this.dbConfig.getDbUrl1() + "|" + this.dbConfig.getDbUsr1() + "|" + this.dbConfig.getDbPwd1()));
            Class.forName(this.dbConfig.getDbDriver1());
            this.dbConn = DriverManager.getConnection(this.dbConfig.getDbUrl1(), this.dbConfig.getDbUsr1(), this.dbConfig.getDbPwd1());
            this.dbConn.setAutoCommit(false);
            logger.debug((Object)("URL (source):" + this.dbConfig.getDbUrl1()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IxException("could not open the database connection!");
        }
    }

    public void testConn() throws IxException {
        try {
            if (this.isHsqldb()) {
                this.dbConn.createStatement().executeQuery("select 1 from model");
            } else {
                Statement qStmt = this.dbConn.createStatement();
                String qString = "select sysdate from DUAL";
                ResultSet aRs = qStmt.executeQuery(qString);
                while (aRs.next()) {
                    aRs.getString(1);
                }
                aRs.close();
                qStmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.openConn();
        }
    }

    public void closeConn() throws IxException {
        try {
            this.dbConn.rollback();
            if (this.isHsqldb() && this.dbConfig.getDbUrl1().indexOf(":file") > -1) {
                this.dbConn.createStatement().execute("SHUTDOWN");
            } else {
                this.dbConn.close();
            }
        }
        catch (SQLException e) {
            String error = "error closing the database connection!";
            logger.error((Object)error, (Throwable)e);
            throw new IxException(error);
        }
    }

    private boolean isHsqldb() {
        return this.dbConfig.isHsqldb();
    }

    public class WatchDog
    implements Runnable {
        DatabaseQueries db = null;

        public WatchDog(DatabaseQueries pSoi) {
            this.db = pSoi;
        }

        private synchronized void testConnection() throws Exception {
            this.db.testConn();
            logger.info((Object)"connection is alive");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(400000L);
                    this.testConnection();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
    }
}

