/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.greenplum;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.greenplum.GreenPlumDbSupport;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLDbSupport;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLSchema;

public class GreenPlumSQLSchema
extends PostgreSQLSchema {
    public GreenPlumSQLSchema(JdbcTemplate jdbcTemplate, GreenPlumDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", this.name);
        return objectCount == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((PostgreSQLDbSupport)this.dbSupport).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((PostgreSQLDbSupport)this.dbSupport).quote(this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (Table table : this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    protected List<String> generateDropStatementsForViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t WHERE table_schema=? AND table_type = 'VIEW'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP VIEW " + ((PostgreSQLDbSupport)this.dbSupport).quote(this.name, viewName) + " CASCADE");
        }
        return statements;
    }
}

