/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Variable
extends Item {
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    private Element scalarEle = null;

    Variable(Scenario scenario, String name, LinkedList<String> indexSets, LinkedList<String> indexNames) throws IxException {
        this.initializeIXItem(scenario, name, "variable");
        this.setIXitemIdDims(indexSets, indexNames);
        scenario.addToItemList(this);
    }

    Variable(Scenario scenario, String name, LinkedList<String> indexSets, LinkedList<String> indexNames, String scheme) throws IxException {
        this.initializeIXItem(scenario, name, "variable");
        this.setIXitemIdDims(indexSets, indexNames, scheme);
        scenario.addToItemList(this);
    }

    Variable(Scenario scenario, String name, int itemId, int dim) {
        this.initializeIXItem(scenario, name, "variable", false);
        scenario.addToItemList(this);
        this.itemId = itemId;
        this.dim = dim;
    }

    @Override
    void setElementListFromDB(LinkedList<Object> blob) {
        super.setElementListFromDB(blob);
        if (this.isScalar()) {
            this.scalarEle = (Element)this.eleList.getLast();
        }
    }

    boolean removeAllElements() throws IxException {
        boolean retval = false;
        if (this.hasElements()) {
            this.eleList = new LinkedList();
            this.eleMap = new HashMap();
            this.scalarEle = null;
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.logger.info((Object)("dropped all elements for " + this.getTypeName() + "!"));
                this.scenario.changeLogList.add(new ChangelogEntry("dropped all elements for variable", this.name));
            }
            retval = true;
            this.hasUpdatedElement = true;
        }
        this.eleLoadedFromDB = true;
        return retval;
    }

    void addElement(Vector<Integer> keyVector, Double level, Double marginal) throws IxException {
        if (level == null || marginal == null) {
            throw new IxException("A value of NULL cannot be assigned to " + this.getTypeName() + "!");
        }
        if (level.isNaN() || marginal.isNaN()) {
            throw new IxException("A value of NaN cannot be assigned to " + this.getTypeName() + "!");
        }
        if (this.isScalar()) {
            throw new IxException("You cannot assign an element with a key to scalar " + this.getTypeName() + "!");
        }
        this.addItemElement(new Element((Item)this, keyVector, level, marginal), null);
    }

    void addElement(Double level, Double marginal) throws IxException {
        if (level == null || marginal == null) {
            throw new IxException("A value of NULL cannot be assigned to " + this.getTypeName() + "!");
        }
        if (level.isNaN() || marginal.isNaN()) {
            throw new IxException("A value of NaN cannot be assigned to " + this.getTypeName() + "!");
        }
        if (!this.isScalar()) {
            throw new IxException("This variable is not a scalar!");
        }
        this.scalarEle = new Element((Item)this, level, marginal);
        this.addItemElement(this.scalarEle, null);
    }

    public Double getEleLevel(LinkedList<String> keyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use 'getElementLevel()'!");
        }
        return this.getElement(keyList).getLevel();
    }

    public Double getEleLevel(Vector<Integer> keyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use 'getElementLevel()'!");
        }
        return this.getElement(keyVector).getLevel();
    }

    public float[] getLevels(LinkedList<Element> eleList) throws IxException {
        float[] ret = new float[eleList.size()];
        int i = 0;
        for (Element ele : eleList) {
            ret[i] = ele.getLevel().floatValue();
            ++i;
        }
        return ret;
    }

    public Double getEleMarginal(LinkedList<String> keyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use 'getScalarMarginal()'!");
        }
        return this.getElement(keyList).getMarginal();
    }

    public Double getEleMarginal(Vector<Integer> pKeyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use 'getScalarMarginal()'!");
        }
        return this.getElement(pKeyVector).getMarginal();
    }

    public float[] getMarginals(LinkedList<Element> eleList) throws IxException {
        float[] ret = new float[eleList.size()];
        int i = 0;
        for (Element ele : eleList) {
            ret[i] = ele.getMarginal().floatValue();
            ++i;
        }
        return ret;
    }

    public Double getScalarLevel() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return Double.NaN;
        }
        return this.scalarEle.getLevel();
    }

    public Double getScalarMarginal() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return Double.NaN;
        }
        return this.scalarEle.getMarginal();
    }

    public LinkedList<LinkedHashMap<Object, Object>> toJsonList(HashMap<String, LinkedList<String>> eleListFilter) throws IxException {
        LinkedList<LinkedHashMap<Object, Object>> jsonList = new LinkedList<LinkedHashMap<Object, Object>>();
        for (Element ele : this.getElements(eleListFilter)) {
            Double val;
            LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
            jsonMap.put("model", this.scenario.getModel());
            jsonMap.put("scenario", this.scenario.getScenario());
            jsonMap.put("type", "variable");
            jsonMap.put("name", this.name);
            if (this.dim >= 1) {
                for (int i = 0; i < this.dim; ++i) {
                    jsonMap.put((String)this.idxNames.get(i), ele.getKey(i));
                }
            }
            if (!(val = ele.getLevel()).isInfinite()) {
                jsonMap.put("level", val);
            } else if (val.isInfinite() && val < 0.0) {
                jsonMap.put("level", "-Infinity");
            } else {
                jsonMap.put("level", "Infinity");
            }
            Double mrg = ele.getMarginal();
            if (!mrg.isInfinite()) {
                jsonMap.put("marginal", mrg);
            } else if (val.isInfinite() && mrg < 0.0) {
                jsonMap.put("marginal", "-Infinity");
            } else {
                jsonMap.put("marginal", "Infinity");
            }
            jsonList.add(jsonMap);
        }
        return jsonList;
    }
}

