/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Set;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;

public class IndexSet
extends Set {
    private LinkedList<Integer> indexSetKeys = new LinkedList();

    IndexSet(Scenario scenario, String name) throws IxException {
        this.initializeIXItem(scenario, name, "index set");
        scenario.addToItemList(this);
        this.logger.debug((Object)(" initialize " + this.getTypeName()));
    }

    IndexSet(Scenario scenario, String name, int itemId, LinkedList<Object> blob) throws IxException {
        this.initializeIXItem(scenario, name, "index set");
        scenario.addToItemList(this);
        this.itemId = itemId;
        if (blob != null) {
            this.setElementListFromDB(blob);
            for (Element ele : this.eleList) {
                this.indexSetKeys.add(ele.getKeyId(0));
            }
        }
    }

    @Override
    public void addElement(String key) throws IxException {
        this.addElement(key, null);
    }

    @Override
    public void addElement(String key, String comment) throws IxException {
        if (key.contains(".")) {
            throw new IxException("An element with '.' cannot be added to an index set!");
        }
        this.addElement(this.getKeyIdVector(key), comment);
    }

    void addElement(Integer keyId) throws IxException {
        Vector<Integer> eleVector = new Vector<Integer>(1);
        eleVector.add(keyId);
        this.addElement(eleVector, null);
    }

    @Override
    public void addElement(Vector<Integer> keyVector, String comment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (keyVector.size() != 1) {
            throw new IxException("only single keys can be added to an index set!");
        }
        Element ele = (Element)this.eleMap.get(keyVector);
        if (ele == null) {
            ele = new Element(this, keyVector);
            this.addItemElement(ele, comment);
            this.indexSetKeys.add(keyVector.get(0));
            this.scenario.addToChangelog("add index set element", this.name, this.getConcatKey(keyVector));
        }
        if (comment != null) {
            this.addItemComment(ele, comment);
        }
    }

    @Override
    public void removeElement(Element pEle) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        Vector<Integer> eleVector = pEle.getVector();
        if (this.hasElement(eleVector)) {
            this.hasUpdatedElement = true;
            int keyId = eleVector.get(0);
            this.indexSetKeys.remove((Object)keyId);
            this.scenario.removeAllEleByIndex(this.name, keyId);
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("delete set element", this.name, this.scenario.getKeyIdString(keyId));
            }
            super.removeItemElement(pEle);
        }
    }

    public String[] getIndexSetKeys() throws IxException {
        Vector<String> ret = new Vector<String>(this.indexSetKeys.size());
        Iterator iterator = this.indexSetKeys.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            ret.add(this.scenario.getKeyIdString(id));
        }
        return ret.toArray(new String[ret.size()]);
    }

    LinkedList<Integer> getIndexSetKeyIds() throws IxException {
        return this.indexSetKeys;
    }

    boolean hasIndexSetKey(int pKeyId) throws IxException {
        return this.indexSetKeys.contains(pKeyId);
    }

    void checkIndexSetKey(int pKeyId) throws IxException {
        if (!this.hasIndexSetKey(pKeyId)) {
            throw new IxException("The index set '" + this.name + "' does not have an element '" + this.scenario.getKeyIdString(pKeyId) + "'!");
        }
    }

    @Override
    LinkedList<LinkedHashMap<Object, Object>> toJsonList(HashMap<String, LinkedList<String>> eleListFilter) throws IxException {
        LinkedList<LinkedHashMap<Object, Object>> jsonList = new LinkedList<LinkedHashMap<Object, Object>>();
        for (Integer key : this.indexSetKeys) {
            LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
            jsonMap.put("model", this.scenario.getModel());
            jsonMap.put("scenario", this.scenario.getScenario());
            jsonMap.put("type", "index set");
            jsonMap.put("name", this.name);
            jsonMap.put("key", this.scenario.getKeyIdString(key));
            jsonList.add(jsonMap);
        }
        return jsonList;
    }
}

