/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.exceptions.IxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.glassfish.jersey.client.ClientConfig;

public class DbConfig {
    static Logger logger = Logger.getLogger((String)DbConfig.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    private static String PROPERTIES_FILENAME = "ixmp.properties";
    private static DbConfig instance = null;
    private String ConfigName = "<no config file loaded>!";
    private String DbDriver1 = "<Driver not configured>";
    private String DbDriver2 = "<Driver not configured>";
    private String DbUrl1 = "jdbc:<not configured!>";
    private String DbUrl2 = "jdbc:<not configured!>";
    private String DbUsr1 = "<not configured>";
    private String DbUsr2 = "<not configured>";
    private String DbPwd1 = "no password configured";
    private String DbPwd2 = "no password configured";

    public DbConfig() throws IxException {
        this.parsePropertiesFile();
        this.updateSchemaIfNecessary();
    }

    private void updateSchemaIfNecessary() {
        Flyway flyway = new Flyway();
        String[] locations = new String[]{this.isHsqldb() ? "classpath:db/migration/hsql" : "classpath:db/migration/oracle"};
        flyway.setLocations(locations);
        flyway.setIgnoreFutureMigrations(false);
        flyway.setDataSource(this.getDbUrl1(), this.getDbUsr1(), this.getDbPwd1(), new String[0]);
        flyway.setBaselineOnMigrate(true);
        flyway.migrate();
    }

    public DbConfig(String pPropsFile) throws IxException {
        this.parsePropertiesFile(pPropsFile);
        this.updateSchemaIfNecessary();
    }

    public DbConfig(String hsqlDbFile, String dbType) throws IxException {
        if (!"HSQLDB".equals(dbType)) {
            String errMsg = "unknown type '" + dbType + "' when loading the DbConfig class!";
            logger.error((Object)errMsg);
            throw new IxException(errMsg);
        }
        String hsqldbDriver = "org.hsqldb.jdbcDriver";
        try {
            Class.forName(hsqldbDriver);
        }
        catch (ClassNotFoundException e) {
            String errMsg = "cannot find hsqldb driver!";
            logger.error((Object)errMsg, (Throwable)e);
            throw new IxException(errMsg);
        }
        this.setDbDriver1(hsqldbDriver);
        this.setDbUrl1("jdbc:hsqldb:file:" + hsqlDbFile);
        this.setDbUsr1("ixmp");
        this.setDbPwd1("ixmp");
        this.updateSchemaIfNecessary();
        this.ConfigName = "local database at '" + hsqlDbFile + "'";
    }

    public String getConfigFileName() {
        return PROPERTIES_FILENAME;
    }

    public String getConfigName() {
        return this.ConfigName;
    }

    public void setConfigName(String pConfigName) {
        this.ConfigName = pConfigName;
    }

    public String getDbPwd1() {
        return this.DbPwd1;
    }

    public void setDbPwd1(String dbPwd1) {
        this.DbPwd1 = dbPwd1;
    }

    public String getDbPwd2() {
        return this.DbPwd2;
    }

    public void setDbPwd2(String dbPwd2) {
        this.DbPwd2 = dbPwd2;
    }

    public String getDbUsr1() {
        return this.DbUsr1;
    }

    public void setDbUsr1(String dbUsr1) {
        this.DbUsr1 = dbUsr1;
    }

    public String getDbUsr2() {
        return this.DbUsr2;
    }

    public void setDbUsr2(String dbUsr2) {
        this.DbUsr2 = dbUsr2;
    }

    void parsePropertiesFile() throws IxException {
        InputStream propIs = null;
        URL url = DbConfig.class.getClassLoader().getResource(PROPERTIES_FILENAME);
        if (url != null) {
            logger.debug((Object)(PROPERTIES_FILENAME + " found at " + url));
            try {
                propIs = url.openStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IxException("could not open " + PROPERTIES_FILENAME + "!");
            }
        }
        if (propIs == null) {
            URL[] urls;
            logger.error((Object)("cannot find '" + PROPERTIES_FILENAME + "' in class path:"));
            for (URL aUrl : urls = ((URLClassLoader)DbConfig.class.getClassLoader()).getURLs()) {
                logger.error((Object)(" " + aUrl));
            }
            throw new IxException(PROPERTIES_FILENAME + " not in java class path");
        }
        this.loadProperties(propIs, PROPERTIES_FILENAME);
        try {
            propIs.close();
        }
        catch (IOException e) {
            logger.error((Object)"could not close properties file", (Throwable)e);
            throw new IxException("could not close properties file");
        }
    }

    public boolean isHsqldb() {
        return this.DbDriver1.indexOf("hsqldb") > -1;
    }

    public void parsePropertiesFile(String pProps) throws IxException {
        File propsFile = new File(pProps);
        FileInputStream propIs = null;
        try {
            propIs = new FileInputStream(propsFile);
            logger.info((Object)("parsing " + pProps + "..."));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("cannot open '" + pProps + "' properties file"), (Throwable)e);
            throw new IxException("cannot open '" + pProps + "' properties file at " + propsFile.getAbsolutePath() + "!");
        }
        this.loadProperties(propIs, pProps);
        try {
            ((InputStream)propIs).close();
        }
        catch (IOException e) {
            logger.error((Object)"could not close properties file", (Throwable)e);
            throw new IxException("could not close properties file");
        }
    }

    private void loadProperties(InputStream pIs, String pPropsFile) throws IxException {
        Properties configProps = new Properties();
        try {
            configProps.load(pIs);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IxException("could not load properties!");
        }
        for (Object k : configProps.keySet()) {
            logger.debug((Object)(k + "|" + configProps.get(k)));
        }
        String[][] required_basic = new String[][]{{"ConfigName", "config.name"}};
        String[][] required_jdbc_direct = new String[][]{{"DbDriver1", "jdbc.driver.1"}, {"DbUrl1", "jdbc.url.1"}, {"DbUsr1", "jdbc.user.1"}, {"DbPwd1", "jdbc.pwd.1"}, {"DbDriver2", "jdbc.driver.2"}, {"DbUrl2", "jdbc.url.2"}, {"DbUsr2", "jdbc.user.2"}, {"DbPwd2", "jdbc.pwd.2"}};
        String[][] required_jdbc_server = new String[][]{{"ConfigUrl", "config.server.url"}, {"ConfigConfigname", "config.server.config"}, {"ConfigUsername", "config.server.username"}, {"ConfigPassword", "config.server.password"}};
        Object[][] requiredChecks = new Object[][]{{"basic", required_basic}, {"jdbc_direct", required_jdbc_direct}, {"jdbc_server", required_jdbc_server}};
        HashMap<Object, Boolean> hasError = new HashMap<Object, Boolean>();
        TreeMap missingMap = new TreeMap();
        for (Object[] cfg : requiredChecks) {
            hasError.put(cfg[0], false);
            HashSet<String> errors = new HashSet<String>();
            missingMap.put((String)cfg[0], errors);
            for (String[] pp : (String[][])cfg[1]) {
                Object propVal = configProps.get(pp[1]);
                if (propVal != null) continue;
                errors.add("missing property '" + pp[1] + "' in " + pPropsFile);
                hasError.put(cfg[0], true);
            }
            logger.info((Object)(cfg[0] + " properties set " + ((Boolean)hasError.get(cfg[0]) != false ? "has errors" : "OK")));
        }
        boolean haveError = false;
        if (Boolean.TRUE == hasError.get("basic")) {
            for (String message : (HashSet)missingMap.get("basic")) {
                logger.error((Object)message);
            }
            haveError = true;
        }
        if (Boolean.FALSE == hasError.get("jdbc_direct")) {
            this.loadProperties(configProps, required_jdbc_direct, pPropsFile);
        } else if (Boolean.FALSE == hasError.get("jdbc_server")) {
            configProps = this.getServerConfig(configProps);
            this.loadProperties(configProps, required_jdbc_direct, pPropsFile);
        } else {
            for (String message : (HashSet)missingMap.get("jdbc_server")) {
                logger.error((Object)message);
            }
            haveError = true;
        }
        if (haveError) {
            throw new IxException(pPropsFile + " is missing required properties");
        }
    }

    Properties getServerConfig(Properties pProps) throws IxException {
        Properties retval = pProps;
        ClientConfig config = new ClientConfig();
        Client client = ClientBuilder.newClient((Configuration)config);
        WebTarget target = client.target(UriBuilder.fromUri((String)pProps.getProperty("config.server.url")).build(new Object[0]));
        String username = pProps.getProperty("config.server.username");
        String userpass = pProps.getProperty("config.server.password");
        String jwt = null;
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("username", username);
        jsonMap.put("password", userpass);
        logger.info((Object)"login ...");
        Response response = target.path("login").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(jsonMap));
        int status = response.getStatus();
        if (200 == status) {
            jwt = ((String)response.readEntity(String.class)).replaceAll("\"", "");
            logger.info((Object)("user " + username + " logged in successfully."));
        } else {
            logger.info((Object)("user " + username + " login failed."));
            jwt = null;
        }
        logger.debug((Object)("Bearer " + jwt));
        if (jwt == null) {
            return retval;
        }
        String aConfig = pProps.getProperty("config.server.config");
        Response response2 = target.path("config").path(aConfig).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)("Bearer " + jwt)).get();
        int status2 = response2.getStatus();
        if (200 == status2) {
            HashMap jsonMap2 = new HashMap();
            jsonMap2 = (HashMap)response2.readEntity((GenericType)new GenericType<HashMap<String, Object>>(){});
            logger.debug((Object)("status(" + aConfig + "): N=" + jsonMap2.size()));
            for (String k : jsonMap2.keySet()) {
                logger.debug((Object)(k + "=" + jsonMap2.get(k)));
            }
            int[] ii = new int[]{1, 2};
            String[][] mappings = new String[][]{{"driver", "driver"}, {"url", "url"}, {"username", "user"}, {"password", "pwd"}};
            for (int i : ii) {
                for (String[] m : mappings) {
                    String jsonVal = (String)jsonMap2.get(m[0]);
                    String propVal = retval.getProperty(m[1]);
                    if (jsonVal == null || propVal != null) continue;
                    retval.setProperty("jdbc." + m[1] + "." + i, jsonVal);
                }
            }
        } else {
            logger.info((Object)("/config request failed. status=" + status2 + "|" + (String)response2.readEntity(String.class)));
        }
        return retval;
    }

    void loadProperties(Properties pProps, String[][] pConfig, String pPropsFile) throws IxException {
        boolean haveError = false;
        block22: for (String[] pp : pConfig) {
            Object propVal = pProps.get(pp[1]);
            if (propVal == null) {
                logger.error((Object)("missing property '" + pp[1] + "' in " + pPropsFile));
                haveError = true;
                continue;
            }
            String propStr = propVal.toString();
            switch (pp[1]) {
                case "config.name": {
                    this.setConfigName("database '" + propStr + "'");
                    continue block22;
                }
                case "jdbc.driver.1": {
                    this.setDbDriver1(propStr);
                    continue block22;
                }
                case "jdbc.driver.2": {
                    this.setDbDriver2(propStr);
                    continue block22;
                }
                case "jdbc.url.1": {
                    this.setDbUrl1(propStr);
                    continue block22;
                }
                case "jdbc.url.2": {
                    this.setDbUrl2(propStr);
                    continue block22;
                }
                case "jdbc.user.1": {
                    this.setDbUsr1(propStr);
                    continue block22;
                }
                case "jdbc.user.2": {
                    this.setDbUsr2(propStr);
                    continue block22;
                }
                case "jdbc.pwd.1": {
                    this.setDbPwd1(propStr);
                    continue block22;
                }
                case "jdbc.pwd.2": {
                    this.setDbPwd2(propStr);
                }
            }
        }
        if (haveError) {
            throw new IxException(pPropsFile + " is missing required properties");
        }
    }

    public static synchronized DbConfig getInstance() throws IxException {
        if (instance == null) {
            instance = new DbConfig();
        }
        return instance;
    }

    public static synchronized DbConfig getInstance(String pPropsFile) throws IxException {
        if (instance == null) {
            instance = new DbConfig(pPropsFile);
        }
        return instance;
    }

    public static synchronized DbConfig getInstance(String pHsqldbFile, String pAction) throws IxException {
        if (instance == null) {
            instance = new DbConfig(pHsqldbFile, pAction);
        }
        return instance;
    }

    public String getDbDriver1() {
        return this.DbDriver1;
    }

    public void setDbDriver1(String dbDriver1) {
        this.DbDriver1 = dbDriver1;
    }

    public String getDbDriver2() {
        return this.DbDriver2;
    }

    public void setDbDriver2(String dbDriver2) {
        this.DbDriver2 = dbDriver2;
    }

    public String getDbUrl1() {
        return this.DbUrl1;
    }

    public void setDbUrl1(String dbUrl1) {
        this.DbUrl1 = dbUrl1;
    }

    public String getDbUrl2() {
        return this.DbUrl2;
    }

    public void setDbUrl2(String dbUrl2) {
        this.DbUrl2 = dbUrl2;
    }
}

