/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSEquation;
import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSModelInstance;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSSymbol;
import com.gams.api.GAMSVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAMSModifier {
    GAMSSymbol<?> mGamsSymbol;
    GAMSGlobals.UpdateAction mUpdateAction;
    GAMSParameter mDataSymbol;
    GAMSModelInstance.SymbolUpdateType mUpdateType;

    public GAMSModifier(GAMSSymbol<?> gAMSSymbol, GAMSGlobals.UpdateAction updateAction, GAMSParameter gAMSParameter) {
        this(gAMSSymbol, updateAction, gAMSParameter, GAMSModelInstance.SymbolUpdateType.INHERIT);
    }

    public GAMSModifier(GAMSSymbol<?> gAMSSymbol, GAMSGlobals.UpdateAction updateAction, GAMSParameter gAMSParameter, GAMSModelInstance.SymbolUpdateType symbolUpdateType) {
        if (gAMSSymbol.getDimension() != gAMSParameter.getDimension()) {
            throw new GAMSException("GAMSSymbol [dim=" + gAMSSymbol.getDimension() + "] and dataSymbol [dim=" + gAMSParameter.getDimension() + "] must have same dimension");
        }
        if (gAMSSymbol.symDatabase != gAMSParameter.symDatabase) {
            throw new GAMSException("GAMSSymbol and dataSymbol must belong to the same GAMSDatabase");
        }
        switch (updateAction) {
            case UPPER: 
            case LOWER: 
            case FIXED: {
                if (gAMSSymbol instanceof GAMSVariable) break;
                throw new GAMSException("GAMSSymbol must be a GAMSVariable object for " + (Object)((Object)updateAction));
            }
            case PRIMAL: 
            case DUAL: {
                if (gAMSSymbol instanceof GAMSVariable || gAMSSymbol instanceof GAMSEquation) break;
                throw new GAMSException("GAMSSymbol must be a GAMSVariable or GAMSEquation object for " + (Object)((Object)updateAction));
            }
        }
        this.mGamsSymbol = gAMSSymbol;
        this.mUpdateAction = updateAction;
        this.mDataSymbol = gAMSParameter;
        this.mUpdateType = symbolUpdateType;
    }

    public GAMSModifier(GAMSParameter gAMSParameter) {
        this(gAMSParameter, GAMSModelInstance.SymbolUpdateType.INHERIT);
    }

    public GAMSModifier(GAMSParameter gAMSParameter, GAMSModelInstance.SymbolUpdateType symbolUpdateType) {
        this.mGamsSymbol = gAMSParameter;
        this.mDataSymbol = null;
        this.mUpdateType = symbolUpdateType;
    }

    public GAMSSymbol<?> getGamsSymbol() {
        return this.mGamsSymbol;
    }

    public GAMSGlobals.UpdateAction getUpdAction() {
        return this.mUpdateAction;
    }

    public GAMSParameter getDataSymbol() {
        return this.mDataSymbol;
    }

    public GAMSModelInstance.SymbolUpdateType getUpdateType() {
        return this.mUpdateType;
    }
}

