/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSCheckpoint;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSException;
import com.gams.api.GAMSExecutionException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSOptions;
import com.gams.api.GAMSWorkspace;
import com.gams.api.signal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GAMSJob {
    private GAMSWorkspace jWorkspace = null;
    private String jFileName = null;
    private String jJobName = null;
    private GAMSCheckpoint jCheckpointStart = null;
    private GAMSDatabase jOutDB = null;
    private String currentPID = null;

    private GAMSJob(GAMSWorkspace gAMSWorkspace, String string, String string2, GAMSCheckpoint gAMSCheckpoint) {
        assert (gAMSWorkspace != null);
        gAMSWorkspace.debugMessage("--- Entering GAMSJob constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        this.jWorkspace = gAMSWorkspace;
        this.jJobName = string2;
        this.jFileName = string;
        this.jCheckpointStart = gAMSCheckpoint;
        this.jOutDB = null;
        this.currentPID = null;
    }

    static GAMSJob fromFile(GAMSWorkspace gAMSWorkspace, String string, String string2) {
        GAMSJob gAMSJob = GAMSJob.fromFile(gAMSWorkspace, string, string2, null);
        return gAMSJob;
    }

    static GAMSJob fromFile(GAMSWorkspace gAMSWorkspace, String string, String string2, GAMSCheckpoint gAMSCheckpoint) {
        File file;
        if (gAMSWorkspace == null) {
            throw new GAMSException("could not create a GAMSJob instance from empty GAMSWorkspace reference");
        }
        GAMSJob gAMSJob = new GAMSJob(gAMSWorkspace, string, string2, gAMSCheckpoint);
        gAMSJob.jJobName = gAMSWorkspace.verifyJobName(string2);
        if (gAMSJob.jFileName == null) {
            gAMSJob.jFileName = gAMSWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + gAMSJob.jJobName + ".gms";
        }
        if (!gAMSJob.jFileName.endsWith(".gms")) {
            gAMSJob.jFileName = gAMSJob.jFileName + ".gms";
        }
        if ((file = new File(gAMSJob.jFileName)).getParent() == null) {
            file = new File(gAMSWorkspace.workingDirectory(), gAMSJob.jFileName);
        }
        if (!file.exists()) {
            throw new GAMSException("Could not create GAMSJob instance from non-existing file [" + gAMSJob.jFileName + "]");
        }
        gAMSJob.jFileName = file.getAbsolutePath();
        if (gAMSCheckpoint != null) {
            file = new File(gAMSCheckpoint.cpFileName());
            if (file.getParent() == null) {
                file = new File(gAMSWorkspace.workingDirectory(), gAMSCheckpoint.cpFileName());
            }
            if (!file.exists()) {
                throw new GAMSException("GAMSCheckpoint file [" + gAMSCheckpoint.cpFileName() + "] does not exists!");
            }
        }
        return gAMSJob;
    }

    static GAMSJob fromString(GAMSWorkspace gAMSWorkspace, String string, GAMSCheckpoint gAMSCheckpoint) {
        return GAMSJob.fromString(gAMSWorkspace, string, gAMSCheckpoint, null);
    }

    static GAMSJob fromString(GAMSWorkspace gAMSWorkspace, String string, GAMSCheckpoint gAMSCheckpoint, String string2) {
        Object object;
        File file;
        if (gAMSWorkspace == null) {
            throw new GAMSException("could not create a GAMSJob instance from empty GAMSWorkspace reference");
        }
        GAMSJob gAMSJob = new GAMSJob(gAMSWorkspace, null, string2, gAMSCheckpoint);
        gAMSJob.jJobName = gAMSWorkspace.verifyJobName(string2);
        if (gAMSJob.jFileName == null) {
            gAMSJob.jFileName = gAMSWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + gAMSJob.jJobName + ".gms";
        }
        if ((file = new File(gAMSJob.jFileName)).getParent() == null) {
            file = new File(gAMSWorkspace.workingDirectory(), gAMSJob.jFileName);
        }
        gAMSJob.jFileName = file.getAbsolutePath();
        try {
            object = new BufferedWriter(new FileWriter(gAMSJob.jFileName));
            ((Writer)object).write(string);
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            throw (GAMSException)new GAMSException("Could not write the string to file [" + gAMSJob.jFileName + "]").initCause(iOException);
        }
        if (gAMSCheckpoint != null) {
            object = new File(gAMSCheckpoint.cpFileName());
            if (((File)object).getParent() == null) {
                object = new File(gAMSWorkspace.workingDirectory(), gAMSCheckpoint.cpFileName());
            }
            if (!((File)object).exists()) {
                throw new GAMSException("GAMSCheckpoint file [" + gAMSCheckpoint.cpFileName() + "] does not exists!");
            }
        }
        return gAMSJob;
    }

    public GAMSDatabase OutDB() {
        return this.jOutDB;
    }

    public String getJobName() {
        return this.jJobName;
    }

    public String getFileName() {
        return this.jFileName;
    }

    public void run() {
        this.run(null, null, null, true, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions) {
        this.run(gAMSOptions, null, null, true, (GAMSDatabase[])null);
    }

    public void run(GAMSCheckpoint gAMSCheckpoint) {
        this.run(null, gAMSCheckpoint, null, true, (GAMSDatabase[])null);
    }

    public void run(PrintStream printStream) {
        this.run(null, null, printStream, true, (GAMSDatabase[])null);
    }

    public void run(boolean bl) {
        this.run(null, null, null, bl, (GAMSDatabase[])null);
    }

    public void run(GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, null, null, true, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint) {
        this.run(gAMSOptions, gAMSCheckpoint, null, true, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, PrintStream printStream) {
        this.run(gAMSOptions, null, printStream, true, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, boolean bl) {
        this.run(gAMSOptions, null, null, bl, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, null, null, true, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, PrintStream printStream) {
        this.run(gAMSOptions, gAMSCheckpoint, printStream, true, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, boolean bl) {
        this.run(gAMSOptions, gAMSCheckpoint, null, bl, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, gAMSCheckpoint, null, true, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, PrintStream printStream, boolean bl) {
        this.run(gAMSOptions, null, printStream, bl, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, PrintStream printStream, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, null, printStream, true, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, null, null, bl, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, PrintStream printStream, boolean bl) {
        this.run(gAMSOptions, gAMSCheckpoint, printStream, bl, (GAMSDatabase[])null);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, gAMSCheckpoint, null, bl, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, PrintStream printStream, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, null, printStream, bl, gAMSDatabaseArray);
    }

    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, PrintStream printStream, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(gAMSOptions, gAMSCheckpoint, printStream, true, gAMSDatabaseArray);
    }

    /*
     * WARNING - void declaration
     */
    public void run(GAMSOptions gAMSOptions, GAMSCheckpoint gAMSCheckpoint, PrintStream printStream, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        Object object;
        Object object2;
        String string;
        int n;
        Object object3;
        Object object4;
        Object object5;
        int n2;
        GAMSOptions gAMSOptions2;
        GAMSCheckpoint gAMSCheckpoint2 = null;
        GAMSOptions gAMSOptions3 = gAMSOptions2 = gAMSOptions == null ? new GAMSOptions(this.jWorkspace) : new GAMSOptions(this.jWorkspace, gAMSOptions, null);
        if (this.jCheckpointStart != null) {
            gAMSOptions2.setRestart(this.jCheckpointStart.cpFileName);
        }
        if (gAMSCheckpoint != null) {
            if (this.jCheckpointStart == gAMSCheckpoint) {
                gAMSCheckpoint2 = new GAMSCheckpoint(this.jWorkspace);
                gAMSOptions2.setSave(gAMSCheckpoint2.cpFileName);
            } else {
                gAMSOptions2.setSave(gAMSCheckpoint.cpFileName);
            }
        }
        if (!this.jWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.SHOW_LOG)) {
            gAMSOptions2.setLogOption(3);
        } else if (gAMSOptions2.getLogOption() != 2) {
            if (printStream == null) {
                gAMSOptions2.setLogOption(0);
            } else {
                gAMSOptions2.setLogOption(3);
            }
        }
        if (gAMSDatabaseArray != null) {
            GAMSDatabase[] gAMSDatabaseArray2 = gAMSDatabaseArray;
            int n3 = gAMSDatabaseArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object5 = gAMSDatabaseArray2[n2];
                ((GAMSDatabase)object5).export();
            }
        }
        if (!gAMSOptions2.isDefinitionEmpty()) {
            int n4 = gAMSOptions2.OPT.EOLOnlySet(0);
            String string2 = GAMSGlobals.EMPTY_STRING;
            Map<String, String> map = gAMSOptions2.getDefinitions();
            object5 = map.keySet();
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                string2 = "--" + (String)object3 + "=" + map.get(object3);
                gAMSOptions2.readFromStr(string2);
            }
            gAMSOptions2.OPT.EOLOnlySet(n4);
        }
        if ((n = gAMSOptions2.getInputDirectories().size()) > 0) {
            if (n > 40) {
                throw new GAMSException("Could not handle more than 40 Input Directories");
            }
            Class<?> clazz = gAMSOptions2.getClass();
            for (n2 = 0; n2 < n; ++n2) {
                object5 = Integer.toString(n2 + 1);
                try {
                    object4 = clazz.getDeclaredMethod("setInputDir" + (String)object5, String.class);
                    ((Method)object4).invoke((Object)gAMSOptions2, gAMSOptions2.IDir.get(n2));
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new GAMSException("opt could not set [InputDir" + (String)object5 + "] to [" + gAMSOptions2.IDir.get(n2) + "]");
                }
                catch (SecurityException securityException) {
                    throw new GAMSException("opt could not set [InputDir" + (String)object5 + "] to [" + gAMSOptions2.IDir.get(n2) + "]");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new GAMSException("opt could not set [InputDir" + (String)object5 + "] to [" + gAMSOptions2.IDir.get(n2) + "]");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new GAMSException("opt could not set [InputDir" + (String)object5 + "] to [" + gAMSOptions2.IDir.get(n2) + "]");
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GAMSException("opt could not set [InputDir" + (String)object5 + "] to [" + gAMSOptions2.IDir.get(n2) + "]");
                }
            }
        }
        gAMSOptions2.setModelTypesForSolvers();
        if (bl && (string = gAMSOptions2.getGDX()).length() == 0) {
            gAMSOptions2.setGDX(this.jWorkspace.verifyDatabaseName(null, false));
        }
        gAMSOptions2.setCurDir(this.jWorkspace.workingDirectory());
        gAMSOptions2.setOutput(this.jJobName + ".lst");
        gAMSOptions2.setInput(this.jFileName);
        if (gAMSOptions2.getLogFile().length() == 0) {
            gAMSOptions2.setLogFile(this.jJobName + ".log");
        }
        String string3 = new File(this.jJobName + ".pf").getParent();
        String string4 = this.jJobName + ".pf";
        object5 = string3 == null ? this.jWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + string4 : string4;
        int n5 = gAMSOptions2.writeParameterFile((String)object5);
        if (n5 != 0) {
            throw new GAMSException("Could not write parameter file [" + (String)object5 + "] for GAMSJob [" + this.jJobName + "]");
        }
        object3 = new ArrayList();
        object3.add(this.jWorkspace.systemDirectory() + GAMSGlobals.FILE_SEPARATOR + "gams");
        object3.add("dummy");
        object3.add("pid2error=1");
        object3.add("pf=" + string4);
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)object3);
        processBuilder.directory(new File(this.jWorkspace.workingDirectory()));
        try {
            try {
                Object object7;
                object2 = processBuilder.start();
                object = new BufferedReader(new InputStreamReader(((Process)object2).getErrorStream()));
                String string5 = ((BufferedReader)object).readLine();
                if (string5 != null) {
                    object7 = ": ";
                    if (string5.contains((CharSequence)object7)) {
                        String[] object62 = string5.split(": ");
                        if (object62.length <= 1) {
                            throw new GAMSException("Could not retrieve GAMS Process Identifier");
                        }
                        this.currentPID = object62[1];
                    } else {
                        throw new GAMSException("Could not retrieve GAMS Process Identifier");
                    }
                }
                ((BufferedReader)object).close();
                if (!this.jWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.SHOW_LOG)) {
                    String string2;
                    System.out.print("JavaAPI executing:: ");
                    for (String string6 : processBuilder.command()) {
                        System.out.print(string6 + " ");
                    }
                    System.out.println();
                    object7 = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                    Object var19_41 = null;
                    System.out.println("JavaAPI Standard Output::");
                    while ((string2 = ((BufferedReader)object7).readLine()) != null) {
                        System.out.println(string2);
                    }
                    System.out.println();
                    ((BufferedReader)object7).close();
                } else if (printStream != null) {
                    String string7;
                    object7 = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                    Object var19_44 = null;
                    while ((string7 = ((BufferedReader)object7).readLine()) != null) {
                        printStream.println(string7);
                    }
                    printStream.println();
                    ((BufferedReader)object7).close();
                }
                int n6 = ((Process)object2).waitFor();
                this.currentPID = null;
                ((Process)object2).destroy();
                if (n6 != 0) {
                    void var19_50;
                    if (this.jWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.KEEP_FILES) && this.jWorkspace.isUsingTmpWorkingDirectory()) {
                        throw new GAMSExecutionException(n6, "For a more-detailed listing file, either set a workingDirectory of GAMSWorkspace or set debug level of GAMSWorkspace to DebugLevel.KEEP_FILES (or higher) before running GAMSJob again");
                    }
                    String string8 = this.jWorkspace.workingDirectory();
                    if (!string8.endsWith(GAMSGlobals.FILE_SEPARATOR)) {
                        String string9 = string8 + GAMSGlobals.FILE_SEPARATOR;
                    }
                    throw new GAMSExecutionException(n6, "Check [" + (gAMSOptions2.getOutput().startsWith((String)var19_50) ? gAMSOptions2.getOutput() : (String)var19_50 + gAMSOptions2.getOutput()) + "] for more details");
                }
                Object var21_51 = null;
                if (bl) {
                    String string10 = gAMSOptions2.getGDX();
                    if (new File(string10).getParent() == null) {
                        string10 = this.jWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + string10;
                    }
                    File file = new File(string10);
                    int n3 = file.getName().lastIndexOf(".");
                    if (file.exists()) {
                        this.jOutDB = this.jWorkspace.addDatabaseFromForcedNameGDX(string10, n3 > 0 ? file.getName().substring(0, n3) : file.getName());
                    }
                }
            }
            catch (IOException iOException) {
                throw (GAMSException)new GAMSException("Could not successfully run [gams]").initCause(iOException);
            }
            catch (InterruptedException interruptedException) {
                throw (GAMSException)new GAMSException("Could not wait until [gams] finishes execution").initCause(interruptedException);
            }
        }
        catch (Throwable throwable) {
            Object var21_52 = null;
            if (bl) {
                String string11 = gAMSOptions2.getGDX();
                if (new File(string11).getParent() == null) {
                    string11 = this.jWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + string11;
                }
                File file = new File(string11);
                int n4 = file.getName().lastIndexOf(".");
                if (file.exists()) {
                    this.jOutDB = this.jWorkspace.addDatabaseFromForcedNameGDX(string11, n4 > 0 ? file.getName().substring(0, n4) : file.getName());
                }
            }
            throw throwable;
        }
        if (gAMSCheckpoint2 != null) {
            object2 = new File(gAMSCheckpoint.cpFileName);
            if (((File)object2).exists()) {
                try {
                    ((File)object2).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!((File)(object = new File(gAMSCheckpoint2.cpFileName))).renameTo((File)object2)) {
                throw new GAMSException("could not move [" + gAMSCheckpoint.cpFileName + "] to [" + gAMSCheckpoint2.cpFileName + "]");
            }
        }
        gAMSOptions2.dispose();
        if (this.jWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.KEEP_FILES)) {
            try {
                object2 = new File(string4);
                ((File)object2).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run(GAMSCheckpoint gAMSCheckpoint, PrintStream printStream) {
        this.run(null, gAMSCheckpoint, printStream, true, (GAMSDatabase[])null);
    }

    public void run(GAMSCheckpoint gAMSCheckpoint, boolean bl) {
        this.run(null, gAMSCheckpoint, null, bl, (GAMSDatabase[])null);
    }

    public void run(GAMSCheckpoint gAMSCheckpoint, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, gAMSCheckpoint, null, true, gAMSDatabaseArray);
    }

    public void run(GAMSCheckpoint gAMSCheckpoint, PrintStream printStream, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, gAMSCheckpoint, printStream, true, gAMSDatabaseArray);
    }

    public void run(GAMSCheckpoint gAMSCheckpoint, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, gAMSCheckpoint, null, bl, gAMSDatabaseArray);
    }

    public void run(GAMSCheckpoint gAMSCheckpoint, PrintStream printStream, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, gAMSCheckpoint, printStream, bl, gAMSDatabaseArray);
    }

    public void run(PrintStream printStream, boolean bl) {
        this.run(null, null, printStream, bl, (GAMSDatabase[])null);
    }

    public void run(PrintStream printStream, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, null, printStream, true, gAMSDatabaseArray);
    }

    public void run(PrintStream printStream, boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, null, printStream, bl, gAMSDatabaseArray);
    }

    public void run(boolean bl, GAMSDatabase ... gAMSDatabaseArray) {
        this.run(null, null, null, bl, gAMSDatabaseArray);
    }

    public boolean interrupt() {
        boolean bl = false;
        if (this.currentPID != null) {
            bl = signal.sendInterruptMessage(this.currentPID);
        }
        return bl;
    }
}

