/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp;

import at.ac.iiasa.ixmp.database.DbConfig;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.DatabaseQueries;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.MsgScenario;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Platform {
    static Logger logger = Logger.getLogger((String)Platform.class.getName());
    static Logger baselogger = Logger.getRootLogger();
    private static Platform instance = null;
    private DbConfig dbConfig = null;
    private DatabaseQueries db = null;
    private HashMap<Integer, IamVariable> idIamVariableMap = new HashMap();
    private HashMap<Integer, String> idNodeMap = new HashMap();
    private HashMap<String, Integer> nodeIdMap = new HashMap();
    private HashMap<Integer, String> idUnitMap = new HashMap();
    private HashMap<String, Integer> unitIdMap = new HashMap();

    public Platform(String api) throws IxException {
        this.dbConfig = new DbConfig();
        this.initPlatform(api);
    }

    public Platform(String api, String propsFile) throws IxException {
        this.dbConfig = new DbConfig(propsFile);
        this.initPlatform(api);
    }

    public Platform(String api, String dbFile, String dbType) throws IxException {
        if (dbFile == null) {
            throw new IxException("Please specify a local database file!");
        }
        this.dbConfig = new DbConfig(dbFile, dbType);
        this.initPlatform(api);
    }

    private void initPlatform(String api) throws IxException {
        this.db = new DatabaseQueries(api, this.dbConfig);
        instance = this;
        logger.info((Object)"Welcome to the IX modeling platform!");
        logger.info((Object)(" connected to " + this.dbConfig.getConfigName() + "..."));
    }

    public static synchronized Platform getInstance() throws IxException {
        if (instance == null) {
            instance = new Platform("Java");
        }
        return instance;
    }

    public void openDB() throws IxException {
        this.db.testConn();
        logger.info((Object)("connected to " + this.dbConfig.getConfigName() + "..."));
    }

    public void closeDB() throws IxException {
        this.db.closeConn();
        logger.info((Object)("closed the connection to " + this.dbConfig.getConfigName() + ""));
    }

    public List<Map<String, Object>> getScenarioList(boolean defaultOnly, String model, String senario) throws IxException {
        return this.db.getModelScenarioList(defaultOnly, model, senario);
    }

    public void unlockRunid(int runId) throws IxException {
        this.db.setStatus(runId, 1);
    }

    public void removeRunid(int runId) throws IxException {
        this.db.unassignDefaultVersion(runId);
        this.db.setStatus(runId, -1);
    }

    public Scenario newScenario(String model, String scenario, String annotation) throws IxException {
        return this.newScenario(model, scenario, null, annotation);
    }

    public Scenario newScenario(String model, String scenario, String scheme, String annotation) throws IxException {
        if (scheme != null && scheme.equals("MESSAGE")) {
            return new MsgScenario(model, scenario, true, annotation);
        }
        return new Scenario(model, scenario, true, scheme, annotation);
    }

    public Scenario getScenario(String model, String scenario) throws IxException {
        Integer runid = this.db.getRunId(model, scenario);
        if (runid == -1) {
            throw new IxException("There exists no default Scenario '" + model + "|" + scenario + "' in the database!");
        }
        String scheme = this.db.getScheme(runid);
        if (scheme != null && scheme.equals("MESSAGE")) {
            return new MsgScenario(model, scenario);
        }
        return new Scenario(model, scenario);
    }

    public Scenario getScenario(String model, String scenario, int version) throws IxException {
        Integer runId;
        DatabaseQueries db = DatabaseQueries.getInstance();
        String scheme = db.getScheme(runId = Integer.valueOf(db.getRunId(model, scenario, version)));
        if (scheme != null && scheme.equals("MESSAGE")) {
            return new MsgScenario(model, scenario, version);
        }
        return new Scenario(model, scenario, version);
    }

    public TimeSeries newTimeSeries(String model, String scenario, String annotation) throws IxException {
        return new TimeSeries(model, scenario, true, annotation);
    }

    public TimeSeries getTimeSeries(String model, String scenario) throws IxException {
        return new TimeSeries(model, scenario);
    }

    public TimeSeries getTimeSeries(String model, String scenario, int version) throws IxException {
        return new TimeSeries(model, scenario, version);
    }

    public IamVariable getIamVariable(int id) throws IxException {
        IamVariable iamVar = this.idIamVariableMap.get(id);
        if (iamVar == null) {
            iamVar = this.db.getIamVariableFromDB(this, null, -1, id);
            if (iamVar == null) {
                throw new IxException("The IamVariable id '" + id + "' does not exist in the database!'");
            }
            this.idIamVariableMap.put(iamVar.getId(), iamVar);
        }
        return iamVar;
    }

    public IamVariable assignIamVariableId(String variable, String unit, String scheme) throws IxException {
        int variableId = this.loadIamVariable(variable, unit);
        if (variableId != -1) {
            return this.idIamVariableMap.get(variableId);
        }
        int unitId = this.getUnitId(unit);
        variableId = this.db.assignIamVariableInDB(variable, unitId, scheme);
        IamVariable iamVar = new IamVariable(this, variable, unitId, variableId);
        this.idIamVariableMap.put(variableId, iamVar);
        return iamVar;
    }

    public IamVariable getIamVariable(String variable, String unit) throws IxException {
        int variableId = this.loadIamVariable(variable, unit);
        if (variableId == -1) {
            throw new IxException("The IamVariable '" + variable + "|" + unit + "' was not initialized in the database!");
        }
        return this.idIamVariableMap.get(variableId);
    }

    public List<Integer> getIamVariableIds(List<String> variables, List<String> units) throws IxException {
        if (DatabaseQueries.isEmpty(variables) && DatabaseQueries.isEmpty(units)) {
            throw new IxException("Please provide either variables or units");
        }
        LinkedList<Integer> unitIds = new LinkedList<Integer>();
        if (!DatabaseQueries.isEmpty(units)) {
            for (String unit : units) {
                unitIds.add(this.getUnitId(unit));
            }
        }
        return this.db.getVariableUnitKeys(variables, unitIds);
    }

    public HashMap<Integer, ArrayList<IamVariable>> getIamVariablesOfRuns(List<Integer> runIds) throws IxException {
        HashMap<Integer, ArrayList<IamVariable>> variables = new HashMap<Integer, ArrayList<IamVariable>>();
        HashMap<Integer, ArrayList<Integer>> variableIds = this.db.getIamVariableIdsOfRunIds(runIds);
        LinkedList<Integer> missingIds = new LinkedList<Integer>();
        for (Map.Entry<Integer, ArrayList<Integer>> entry : variableIds.entrySet()) {
            for (Integer variableId : entry.getValue()) {
                if (this.idIamVariableMap.containsKey(variableId)) continue;
                missingIds.add(variableId);
            }
        }
        if (missingIds.size() > 0) {
            ArrayList<IamVariable> missingVariables = this.db.getIamVariables(this, missingIds);
            for (IamVariable variable : missingVariables) {
                this.idIamVariableMap.putIfAbsent(variable.getId(), variable);
            }
        }
        for (Map.Entry<Integer, ArrayList<Integer>> entry : variableIds.entrySet()) {
            Integer runId = entry.getKey();
            for (Integer variableId : entry.getValue()) {
                variables.computeIfAbsent(runId, varsOfRun -> new ArrayList()).add(this.idIamVariableMap.get(variableId));
            }
        }
        return variables;
    }

    private int loadIamVariable(String variable, String unit) throws IxException {
        int unitId = this.getUnitId(unit);
        for (Map.Entry<Integer, IamVariable> entry : this.idIamVariableMap.entrySet()) {
            if (!entry.getValue().equals(variable, unitId)) continue;
            return entry.getKey();
        }
        IamVariable loadedIamVariable = this.db.getIamVariableFromDB(this, variable, unitId, -1);
        if (loadedIamVariable != null) {
            int iamVariableId = loadedIamVariable.getId();
            this.idIamVariableMap.put(iamVariableId, loadedIamVariable);
            return iamVariableId;
        }
        return -1;
    }

    public String getNodeName(int nodeId) throws IxException {
        String retval = this.idNodeMap.get(nodeId);
        if (retval == null) {
            this.loadNodeFromDB(null, nodeId);
            retval = this.idNodeMap.get(nodeId);
            if (retval == null) {
                throw new IxException("The node id '" + nodeId + "' does not exist in the database!'");
            }
        }
        return retval;
    }

    public int getNodeId(String node) throws IxException {
        try {
            return this.nodeIdMap.get(node);
        }
        catch (NullPointerException e) {
            this.loadNodeFromDB(node, -1);
            try {
                return this.nodeIdMap.get(node);
            }
            catch (NullPointerException e2) {
                throw new IxException("The node '" + node + "' does not exist in the database!'");
            }
        }
    }

    public LinkedList<Integer> getNodeIdList(List<String> nodeStrings) throws IxException {
        LinkedList<Integer> nodeIds = null;
        if (nodeStrings != null) {
            nodeIds = new LinkedList<Integer>();
            for (String node : nodeStrings) {
                nodeIds.add(this.getNodeId(node));
            }
        }
        return nodeIds;
    }

    public void addNode(String pNode) throws IxException {
    }

    public void addNodeSynonym(String pNode, String pSynonym) throws IxException {
    }

    private void loadNodeFromDB(String node, int id) throws IxException {
        HashMap<Integer, String> newNode = this.db.getNodeFromDB(node, id);
        for (Map.Entry<Integer, String> entry : newNode.entrySet()) {
            this.nodeIdMap.put(entry.getValue(), entry.getKey());
            this.idNodeMap.put(entry.getKey(), entry.getValue());
        }
        if (node != null) {
            HashMap<String, Integer> newNodeSynonym = this.db.getNodeSynonymsFromDB(node);
            for (Map.Entry<String, Integer> entry : newNodeSynonym.entrySet()) {
                this.nodeIdMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String[] getUnitList() throws IxException {
        this.loadUnitFromDB(null, -1);
        return this.unitIdMap.keySet().toArray(new String[this.unitIdMap.size()]);
    }

    public String getUnit(int id) throws IxException {
        String retval = this.idUnitMap.get(id);
        if (retval == null) {
            this.loadUnitFromDB(null, id);
            retval = this.idUnitMap.get(id);
            if (retval == null) {
                throw new IxException("The unit id '" + id + "' does not exist in the database!'");
            }
        }
        return retval;
    }

    public int getUnitId(String unit) throws IxException {
        return this.getUnitId(unit, false, null);
    }

    public int getUnitId(String unit, boolean addUnitToDb, String scheme) throws IxException {
        try {
            return this.unitIdMap.get(unit);
        }
        catch (NullPointerException e) {
            this.loadUnitFromDB(unit, -1);
            try {
                return this.unitIdMap.get(unit);
            }
            catch (NullPointerException e2) {
                if (addUnitToDb) {
                    return this.addUnitToDB(unit, scheme);
                }
                throw new IxException("The unit '" + unit + "' does not exist in the database!");
            }
        }
    }

    public int addUnitToDB(String unit, String scheme) throws IxException {
        int id = this.db.addUnitToDB(unit, scheme);
        this.unitIdMap.put(unit, id);
        this.idUnitMap.put(id, unit);
        return id;
    }

    private void loadUnitFromDB(String unit, int id) throws IxException {
        HashMap<Integer, String> newUnit = this.db.getUnitFromDB(unit, id);
        for (Map.Entry<Integer, String> entry : newUnit.entrySet()) {
            this.unitIdMap.put(entry.getValue(), entry.getKey());
            this.idUnitMap.put(entry.getKey(), entry.getValue());
        }
    }

    public static void main(String[] args) throws Exception {
        File logFile = new File("Platform.log");
        if (logFile.exists()) {
            logFile.delete();
        }
        baselogger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%d{ISO8601} %c:%L - %m%n"), logFile.getName()));
        new Platform("Java");
    }
}

