/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.PhysicalConnection;

public class NTFJMSConnectionGroup {
    ArrayList<NTFJMSConnection> jmsListenerConnections = new ArrayList();
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
    private int noOfRegistrationsInThisGroup = 0;
    String uniqueIdentifier;
    private static final int MAX_NTF_CONNECTIONS = 16;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    NTFJMSConnectionGroup(String string) {
        this.uniqueIdentifier = string;
    }

    synchronized void checkForActiveRegistrations() {
        if (this.noOfRegistrationsInThisGroup == 0) {
            if (!this.jmsListenerConnections.isEmpty()) {
                for (NTFJMSConnection nTFJMSConnection : this.jmsListenerConnections) {
                    if (nTFJMSConnection == null) continue;
                    nTFJMSConnection.closeThisListener();
                    nTFJMSConnection.interrupt();
                }
                this.jmsListenerConnections.clear();
            }
            PhysicalConnection.ntfManager.removeJMSConnectionGroup(this.uniqueIdentifier);
        }
    }

    synchronized void startJMSListenerConnection(String string, String string2, String string3, String string4, ArrayList<String> arrayList, String string5, int n2) {
        assert (string5 != null) : "jmsConnectionId is null";
        String string6 = "notify" + string5;
        NTFJMSConnection nTFJMSConnection = new NTFJMSConnection(string5, arrayList, string, string2, string3, string4, string6, n2);
        this.jmsListenerConnections.add(nTFJMSConnection);
        nTFJMSConnection.setDaemon(true);
        nTFJMSConnection.start();
    }

    synchronized void decrementNumberOfRegistrations() {
        --this.noOfRegistrationsInThisGroup;
    }

    synchronized NTFJMSConnection getNTFJMSConnection(int n2) {
        this.noOfRegistrationsInThisGroup += n2;
        if (this.noOfRegistrationsInThisGroup >= 16) {
            int n3 = this.noOfRegistrationsInThisGroup;
            NTFJMSConnection nTFJMSConnection = this.jmsListenerConnections.get(0);
            for (NTFJMSConnection nTFJMSConnection2 : this.jmsListenerConnections) {
                int n4 = nTFJMSConnection2.getNumberOfRegistrations();
                if (n4 >= n3) continue;
                nTFJMSConnection = nTFJMSConnection2;
                n3 = n4;
            }
            nTFJMSConnection.incrementNumberOfRegistrations(n2);
            return nTFJMSConnection;
        }
        return null;
    }

    synchronized void resetRegistrationNumbers(int n2, NTFJMSConnection nTFJMSConnection) {
        this.noOfRegistrationsInThisGroup -= n2;
        if (nTFJMSConnection != null) {
            nTFJMSConnection.decrementNumberOfRegistrations(n2);
        }
    }
}

