# AUTOMATICALLY GENERATED by gen_wrap.py -- do not edit

from __future__ import print_function

import six
import sys
import logging
import threading


_PY3 = sys.version_info >= (3,)

is_win = sys.platform.startswith('win32')

from islpy._isl_cffi import ffi

if is_win:
    lib = ffi.dlopen('_isl_cffi.cp35-win_amd64.pyd')
else:
    lib = ffi.dlopen(None)

from cffi import FFI
libc_ffi = FFI()

cdef_string = '''
    char *strdup(const char *s);
    void free(void *ptr);
    '''

if is_win:
    cdef_string = cdef_string.replace('strdup', '_strdup')

libc_ffi.cdef(cdef_string)

if is_win and sys.version_info >= (3,5):
    libc = libc_ffi.dlopen('ucrtbase')
else:
    libc = libc_ffi.dlopen(None)


class Error(Exception):
    pass


class IslTypeError(Error, TypeError):
    pass

_context_use_map = {}

def _deref_ctx(ctx_data, ctx_iptr):
    _context_use_map[ctx_iptr] -= 1
    if _context_use_map[ctx_iptr] == 0:
        del _context_use_map[ctx_iptr]
        lib.isl_ctx_free(ctx_data)


def _get_last_error_str(ctx_data):
    code = lib.isl_ctx_last_error(ctx_data)
    for name in dir(error):
        if name.startswith("_"):
            continue
        if getattr(error, name) == code:
            return "isl_error_"+name

    return "(unknown error)"


class _ISLObjectBase(object):
    def __init__(self, _data):
        self._setup(_data)

    def _setup(self, data):
        assert not hasattr(self, "data")
        assert isinstance(data, ffi.CData)
        self.data =  data

        self._set_ctx_data()
        iptr = self._ctx_iptr
        _context_use_map[iptr] = _context_use_map.get(iptr, 0) + 1

    def _reset(self, data):
        assert self.data is not None
        assert isinstance(data, ffi.CData)

        _deref_ctx(self._ctx_data, self._ctx_iptr)
        self.data = data

        self._set_ctx_data()
        iptr = self._ctx_iptr
        _context_use_map[iptr] = _context_use_map.get(iptr, 0) + 1

    def _set_ctx_data(self):
        self._ctx_data = self._get_ctx_data()
        self._ctx_iptr = int(ffi.cast("intptr_t", self._get_ctx_data()))

    def _release(self):
        if self.data is None:
            raise Error("cannot release already-released object")

        data = self.data
        if _deref_ctx is not None:
            _deref_ctx(self._ctx_data, self._ctx_iptr)
        else:
            # This can happen if we're called super-late in cleanup.
            # Since everything else is already mopped up, we really
            # can't do what it takes to mop up this context.
            # So we leak it (i.e. leave it for the OS to clean up.)
            pass

        self.data = None
        return data

    def __eq__(self, other):
        return (type(self) == type(other) and self.data == other.data)

    def __ne__(self, other):
        return not self.__eq__(other)


class _EnumBase(object):
    @classmethod
    def find_value(cls, v):
        for name in dir(cls):
            if getattr(cls, name) == v:
                return name

        raise ValueError("Value '%s' not found in enum" % v)


class _ManagedCString(object):
    def __init__(self, cdata):
        if is_win:
            self.data = libc._strdup(cdata)
        else:
            self.data = libc.strdup(cdata)
        if self.data == libc_ffi.NULL:
            raise Error("strdup() failed")

    def release(self):
        if self.data is None:
            raise Error("cannot release already-released object")

        data = self.data
        self.data = None
        return data

    def __del__(self):
        libc.free(self.data)


if _PY3:
    class DelayedKeyboardInterrupt(object):
        def __enter__(self):
            self.previous_switch_interval = sys.getswitchinterval()
            sys.setswitchinterval(10000000)

        def __exit__(self, type, value, traceback):
            sys.setswitchinterval(self.previous_switch_interval)
else:
    class DelayedKeyboardInterrupt(object):
        def __enter__(self):
            self.previous_check_interval = sys.getcheckinterval()
            sys.setcheckinterval(100000000)

        def __exit__(self, type, value, traceback):
            sys.setcheckinterval(self.previous_check_interval)


# {{{ enums

class error(_EnumBase):
    none = lib.isl_error_none
    abort = lib.isl_error_abort
    alloc = lib.isl_error_alloc
    unknown = lib.isl_error_unknown
    internal = lib.isl_error_internal
    invalid = lib.isl_error_invalid
    quota = lib.isl_error_quota
    unsupported = lib.isl_error_unsupported

class schedule_node_type(_EnumBase):
    error = lib.isl_schedule_node_error
    band = lib.isl_schedule_node_band
    context = lib.isl_schedule_node_context
    domain = lib.isl_schedule_node_domain
    expansion = lib.isl_schedule_node_expansion
    extension = lib.isl_schedule_node_extension
    filter = lib.isl_schedule_node_filter
    leaf = lib.isl_schedule_node_leaf
    guard = lib.isl_schedule_node_guard
    mark = lib.isl_schedule_node_mark
    sequence = lib.isl_schedule_node_sequence
    set = lib.isl_schedule_node_set

class bound(_EnumBase):
    BERNSTEIN = lib.ISL_BOUND_BERNSTEIN
    RANGE = lib.ISL_BOUND_RANGE

class dim_type(_EnumBase):
    cst = lib.isl_dim_cst
    param = lib.isl_dim_param
    in_ = lib.isl_dim_in
    out = lib.isl_dim_out
    set = lib.isl_dim_set
    div = lib.isl_dim_div
    all = lib.isl_dim_all

class ast_node_type(_EnumBase):
    error = lib.isl_ast_node_error
    for_ = lib.isl_ast_node_for
    if_ = lib.isl_ast_node_if
    block = lib.isl_ast_node_block
    mark = lib.isl_ast_node_mark
    user = lib.isl_ast_node_user

class on_error(_EnumBase):
    WARN = lib.ISL_ON_ERROR_WARN
    CONTINUE = lib.ISL_ON_ERROR_CONTINUE
    ABORT = lib.ISL_ON_ERROR_ABORT

class fold(_EnumBase):
    min = lib.isl_fold_min
    max = lib.isl_fold_max
    list = lib.isl_fold_list

class ast_expr_type(_EnumBase):
    error = lib.isl_ast_expr_error
    op = lib.isl_ast_expr_op
    id = lib.isl_ast_expr_id
    int = lib.isl_ast_expr_int

class schedule_algorithm(_EnumBase):
    ISL = lib.ISL_SCHEDULE_ALGORITHM_ISL
    FEAUTRIER = lib.ISL_SCHEDULE_ALGORITHM_FEAUTRIER

class ast_op_type(_EnumBase):
    error = lib.isl_ast_op_error
    and_ = lib.isl_ast_op_and
    and_then = lib.isl_ast_op_and_then
    or_ = lib.isl_ast_op_or
    or_else = lib.isl_ast_op_or_else
    max = lib.isl_ast_op_max
    min = lib.isl_ast_op_min
    minus = lib.isl_ast_op_minus
    add = lib.isl_ast_op_add
    sub = lib.isl_ast_op_sub
    mul = lib.isl_ast_op_mul
    div = lib.isl_ast_op_div
    fdiv_q = lib.isl_ast_op_fdiv_q
    pdiv_q = lib.isl_ast_op_pdiv_q
    pdiv_r = lib.isl_ast_op_pdiv_r
    zdiv_r = lib.isl_ast_op_zdiv_r
    cond = lib.isl_ast_op_cond
    select = lib.isl_ast_op_select
    eq = lib.isl_ast_op_eq
    le = lib.isl_ast_op_le
    lt = lib.isl_ast_op_lt
    ge = lib.isl_ast_op_ge
    gt = lib.isl_ast_op_gt
    call = lib.isl_ast_op_call
    access = lib.isl_ast_op_access
    member = lib.isl_ast_op_member
    address_of = lib.isl_ast_op_address_of

class stat(_EnumBase):
    error = lib.isl_stat_error
    ok = lib.isl_stat_ok

class yaml_style(_EnumBase):
    BLOCK = lib.ISL_YAML_STYLE_BLOCK
    FLOW = lib.ISL_YAML_STYLE_FLOW

class ast_loop_type(_EnumBase):
    error = lib.isl_ast_loop_error
    default = lib.isl_ast_loop_default
    atomic = lib.isl_ast_loop_atomic
    unroll = lib.isl_ast_loop_unroll
    separate = lib.isl_ast_loop_separate

class format(_EnumBase):
    ISL = lib.ISL_FORMAT_ISL
    POLYLIB = lib.ISL_FORMAT_POLYLIB
    POLYLIB_CONSTRAINTS = lib.ISL_FORMAT_POLYLIB_CONSTRAINTS
    OMEGA = lib.ISL_FORMAT_OMEGA
    C = lib.ISL_FORMAT_C
    LATEX = lib.ISL_FORMAT_LATEX
    EXT_POLYLIB = lib.ISL_FORMAT_EXT_POLYLIB

# }}}
# {{{ declare classes

class Context(_ISLObjectBase):
    _base_name = 'ctx'

    def _get_ctx_data(self):
        return self.data
    
    def __del__(self):
        if self.data is not None:
            self._release()

class IdList(_ISLObjectBase):
    _base_name = 'id_list'

    def _get_ctx_data(self):
        return lib.isl_id_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_id_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_id_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of IdList")
    
        return IdList(_data=data)

class ValList(_ISLObjectBase):
    _base_name = 'val_list'

    def _get_ctx_data(self):
        return lib.isl_val_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_val_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_val_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of ValList")
    
        return ValList(_data=data)

class BasicSetList(_ISLObjectBase):
    _base_name = 'basic_set_list'

    def _get_ctx_data(self):
        return lib.isl_basic_set_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_basic_set_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_basic_set_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of BasicSetList")
    
        return BasicSetList(_data=data)

class BasicMapList(_ISLObjectBase):
    _base_name = 'basic_map_list'

    def _get_ctx_data(self):
        return lib.isl_basic_map_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_basic_map_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_basic_map_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of BasicMapList")
    
        return BasicMapList(_data=data)

class SetList(_ISLObjectBase):
    _base_name = 'set_list'

    def _get_ctx_data(self):
        return lib.isl_set_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_set_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_set_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of SetList")
    
        return SetList(_data=data)

class MapList(_ISLObjectBase):
    _base_name = 'map_list'

    def _get_ctx_data(self):
        return lib.isl_map_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_map_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_map_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of MapList")
    
        return MapList(_data=data)

class UnionSetList(_ISLObjectBase):
    _base_name = 'union_set_list'

    def _get_ctx_data(self):
        return lib.isl_union_set_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_set_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_set_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionSetList")
    
        return UnionSetList(_data=data)

class ConstraintList(_ISLObjectBase):
    _base_name = 'constraint_list'

    def _get_ctx_data(self):
        return lib.isl_constraint_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_constraint_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_constraint_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of ConstraintList")
    
        return ConstraintList(_data=data)

class AffList(_ISLObjectBase):
    _base_name = 'aff_list'

    def _get_ctx_data(self):
        return lib.isl_aff_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_aff_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_aff_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AffList")
    
        return AffList(_data=data)

class PwAffList(_ISLObjectBase):
    _base_name = 'pw_aff_list'

    def _get_ctx_data(self):
        return lib.isl_pw_aff_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_aff_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_aff_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwAffList")
    
        return PwAffList(_data=data)

class PwMultiAffList(_ISLObjectBase):
    _base_name = 'pw_multi_aff_list'

    def _get_ctx_data(self):
        return lib.isl_pw_multi_aff_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_multi_aff_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_multi_aff_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwMultiAffList")
    
        return PwMultiAffList(_data=data)

class AstExprList(_ISLObjectBase):
    _base_name = 'ast_expr_list'

    def _get_ctx_data(self):
        return lib.isl_ast_expr_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_ast_expr_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_ast_expr_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AstExprList")
    
        return AstExprList(_data=data)

class AstNodeList(_ISLObjectBase):
    _base_name = 'ast_node_list'

    def _get_ctx_data(self):
        return lib.isl_ast_node_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_ast_node_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_ast_node_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AstNodeList")
    
        return AstNodeList(_data=data)

class PwQPolynomialList(_ISLObjectBase):
    _base_name = 'pw_qpolynomial_list'

    def _get_ctx_data(self):
        return lib.isl_pw_qpolynomial_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_qpolynomial_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_qpolynomial_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwQPolynomialList")
    
        return PwQPolynomialList(_data=data)

class PwQPolynomialFoldList(_ISLObjectBase):
    _base_name = 'pw_qpolynomial_fold_list'

    def _get_ctx_data(self):
        return lib.isl_pw_qpolynomial_fold_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_qpolynomial_fold_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_qpolynomial_fold_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwQPolynomialFoldList")
    
        return PwQPolynomialFoldList(_data=data)

class IdToAstExpr(_ISLObjectBase):
    _base_name = 'id_to_ast_expr'

    def _get_ctx_data(self):
        return lib.isl_id_to_ast_expr_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_id_to_ast_expr_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_id_to_ast_expr_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of IdToAstExpr")
    
        return IdToAstExpr(_data=data)

class Printer(_ISLObjectBase):
    _base_name = 'printer'

    def _get_ctx_data(self):
        return lib.isl_printer_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_printer_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

class Val(_ISLObjectBase):
    _base_name = 'val'

    def _get_ctx_data(self):
        return lib.isl_val_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_val_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_val_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Val")
    
        return Val(_data=data)

class MultiVal(_ISLObjectBase):
    _base_name = 'multi_val'

    def _get_ctx_data(self):
        return lib.isl_multi_val_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_multi_val_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_multi_val_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of MultiVal")
    
        return MultiVal(_data=data)

class Vec(_ISLObjectBase):
    _base_name = 'vec'

    def _get_ctx_data(self):
        return lib.isl_vec_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_vec_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_vec_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Vec")
    
        return Vec(_data=data)

class Mat(_ISLObjectBase):
    _base_name = 'mat'

    def _get_ctx_data(self):
        return lib.isl_mat_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_mat_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_mat_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Mat")
    
        return Mat(_data=data)

class FixedBox(_ISLObjectBase):
    _base_name = 'fixed_box'

    def _get_ctx_data(self):
        return lib.isl_fixed_box_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_fixed_box_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_fixed_box_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of FixedBox")
    
        return FixedBox(_data=data)

class Aff(_ISLObjectBase):
    _base_name = 'aff'

    def _get_ctx_data(self):
        return lib.isl_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Aff")
    
        return Aff(_data=data)

class PwAff(_ISLObjectBase):
    _base_name = 'pw_aff'

    def _get_ctx_data(self):
        return lib.isl_pw_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwAff")
    
        return PwAff(_data=data)

class UnionPwAff(_ISLObjectBase):
    _base_name = 'union_pw_aff'

    def _get_ctx_data(self):
        return lib.isl_union_pw_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_pw_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_pw_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionPwAff")
    
        return UnionPwAff(_data=data)

class MultiAff(_ISLObjectBase):
    _base_name = 'multi_aff'

    def _get_ctx_data(self):
        return lib.isl_multi_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_multi_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_multi_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of MultiAff")
    
        return MultiAff(_data=data)

class MultiPwAff(_ISLObjectBase):
    _base_name = 'multi_pw_aff'

    def _get_ctx_data(self):
        return lib.isl_multi_pw_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_multi_pw_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_multi_pw_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of MultiPwAff")
    
        return MultiPwAff(_data=data)

class PwMultiAff(_ISLObjectBase):
    _base_name = 'pw_multi_aff'

    def _get_ctx_data(self):
        return lib.isl_pw_multi_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_multi_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_multi_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwMultiAff")
    
        return PwMultiAff(_data=data)

class UnionPwMultiAff(_ISLObjectBase):
    _base_name = 'union_pw_multi_aff'

    def _get_ctx_data(self):
        return lib.isl_union_pw_multi_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_pw_multi_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_pw_multi_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionPwMultiAff")
    
        return UnionPwMultiAff(_data=data)

class UnionPwAffList(_ISLObjectBase):
    _base_name = 'union_pw_aff_list'

    def _get_ctx_data(self):
        return lib.isl_union_pw_aff_list_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_pw_aff_list_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_pw_aff_list_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionPwAffList")
    
        return UnionPwAffList(_data=data)

class MultiUnionPwAff(_ISLObjectBase):
    _base_name = 'multi_union_pw_aff'

    def _get_ctx_data(self):
        return lib.isl_multi_union_pw_aff_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_multi_union_pw_aff_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_multi_union_pw_aff_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of MultiUnionPwAff")
    
        return MultiUnionPwAff(_data=data)

class Id(_ISLObjectBase):
    _base_name = 'id'

    def _get_ctx_data(self):
        return lib.isl_id_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_id_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_id_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Id")
    
        return Id(_data=data)

class Constraint(_ISLObjectBase):
    _base_name = 'constraint'

    def _get_ctx_data(self):
        return lib.isl_constraint_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_constraint_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_constraint_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Constraint")
    
        return Constraint(_data=data)

class Space(_ISLObjectBase):
    _base_name = 'space'

    def _get_ctx_data(self):
        return lib.isl_space_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_space_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_space_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Space")
    
        return Space(_data=data)

class LocalSpace(_ISLObjectBase):
    _base_name = 'local_space'

    def _get_ctx_data(self):
        return lib.isl_local_space_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_local_space_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_local_space_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of LocalSpace")
    
        return LocalSpace(_data=data)

class BasicSet(_ISLObjectBase):
    _base_name = 'basic_set'

    def _get_ctx_data(self):
        return lib.isl_basic_set_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_basic_set_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_basic_set_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of BasicSet")
    
        return BasicSet(_data=data)

class BasicMap(_ISLObjectBase):
    _base_name = 'basic_map'

    def _get_ctx_data(self):
        return lib.isl_basic_map_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_basic_map_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_basic_map_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of BasicMap")
    
        return BasicMap(_data=data)

class Set(_ISLObjectBase):
    _base_name = 'set'

    def _get_ctx_data(self):
        return lib.isl_set_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_set_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_set_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Set")
    
        return Set(_data=data)

class Map(_ISLObjectBase):
    _base_name = 'map'

    def _get_ctx_data(self):
        return lib.isl_map_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_map_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_map_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Map")
    
        return Map(_data=data)

class UnionMap(_ISLObjectBase):
    _base_name = 'union_map'

    def _get_ctx_data(self):
        return lib.isl_union_map_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_map_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_map_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionMap")
    
        return UnionMap(_data=data)

class UnionSet(_ISLObjectBase):
    _base_name = 'union_set'

    def _get_ctx_data(self):
        return lib.isl_union_set_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_set_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_set_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionSet")
    
        return UnionSet(_data=data)

class Point(_ISLObjectBase):
    _base_name = 'point'

    def _get_ctx_data(self):
        return lib.isl_point_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_point_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_point_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Point")
    
        return Point(_data=data)

class Vertex(_ISLObjectBase):
    _base_name = 'vertex'

    def _get_ctx_data(self):
        return lib.isl_vertex_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_vertex_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_vertex_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Vertex")
    
        return Vertex(_data=data)

class Cell(_ISLObjectBase):
    _base_name = 'cell'

    def _get_ctx_data(self):
        return lib.isl_cell_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_cell_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_cell_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Cell")
    
        return Cell(_data=data)

class Vertices(_ISLObjectBase):
    _base_name = 'vertices'

    def _get_ctx_data(self):
        return lib.isl_vertices_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_vertices_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_vertices_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Vertices")
    
        return Vertices(_data=data)

class StrideInfo(_ISLObjectBase):
    _base_name = 'stride_info'

    def _get_ctx_data(self):
        return lib.isl_stride_info_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_stride_info_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_stride_info_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of StrideInfo")
    
        return StrideInfo(_data=data)

class QPolynomialFold(_ISLObjectBase):
    _base_name = 'qpolynomial_fold'

    def _get_ctx_data(self):
        return lib.isl_qpolynomial_fold_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_qpolynomial_fold_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_qpolynomial_fold_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of QPolynomialFold")
    
        return QPolynomialFold(_data=data)

class PwQPolynomialFold(_ISLObjectBase):
    _base_name = 'pw_qpolynomial_fold'

    def _get_ctx_data(self):
        return lib.isl_pw_qpolynomial_fold_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_qpolynomial_fold_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_qpolynomial_fold_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwQPolynomialFold")
    
        return PwQPolynomialFold(_data=data)

class UnionPwQPolynomialFold(_ISLObjectBase):
    _base_name = 'union_pw_qpolynomial_fold'

    def _get_ctx_data(self):
        return lib.isl_union_pw_qpolynomial_fold_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_pw_qpolynomial_fold_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_pw_qpolynomial_fold_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionPwQPolynomialFold")
    
        return UnionPwQPolynomialFold(_data=data)

class UnionPwQPolynomial(_ISLObjectBase):
    _base_name = 'union_pw_qpolynomial'

    def _get_ctx_data(self):
        return lib.isl_union_pw_qpolynomial_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_pw_qpolynomial_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_pw_qpolynomial_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionPwQPolynomial")
    
        return UnionPwQPolynomial(_data=data)

class QPolynomial(_ISLObjectBase):
    _base_name = 'qpolynomial'

    def _get_ctx_data(self):
        return lib.isl_qpolynomial_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_qpolynomial_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_qpolynomial_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of QPolynomial")
    
        return QPolynomial(_data=data)

class PwQPolynomial(_ISLObjectBase):
    _base_name = 'pw_qpolynomial'

    def _get_ctx_data(self):
        return lib.isl_pw_qpolynomial_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_pw_qpolynomial_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_pw_qpolynomial_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of PwQPolynomial")
    
        return PwQPolynomial(_data=data)

class Term(_ISLObjectBase):
    _base_name = 'term'

    def _get_ctx_data(self):
        return lib.isl_term_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_term_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_term_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Term")
    
        return Term(_data=data)

class Band(_ISLObjectBase):
    _base_name = 'band'

    def _get_ctx_data(self):
        return lib.isl_band_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_band_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_band_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Band")
    
        return Band(_data=data)

class ScheduleConstraints(_ISLObjectBase):
    _base_name = 'schedule_constraints'

    def _get_ctx_data(self):
        return lib.isl_schedule_constraints_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_schedule_constraints_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_schedule_constraints_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of ScheduleConstraints")
    
        return ScheduleConstraints(_data=data)

class ScheduleNode(_ISLObjectBase):
    _base_name = 'schedule_node'

    def _get_ctx_data(self):
        return lib.isl_schedule_node_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_schedule_node_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_schedule_node_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of ScheduleNode")
    
        return ScheduleNode(_data=data)

class Schedule(_ISLObjectBase):
    _base_name = 'schedule'

    def _get_ctx_data(self):
        return lib.isl_schedule_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_schedule_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_schedule_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Schedule")
    
        return Schedule(_data=data)

class AccessInfo(_ISLObjectBase):
    _base_name = 'access_info'

    def _get_ctx_data(self):
        return lib.isl_access_info_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_access_info_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

class Flow(_ISLObjectBase):
    _base_name = 'flow'

    def _get_ctx_data(self):
        return lib.isl_flow_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_flow_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_flow_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Flow")
    
        return Flow(_data=data)

class Restriction(_ISLObjectBase):
    _base_name = 'restriction'

    def _get_ctx_data(self):
        return lib.isl_restriction_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_restriction_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_restriction_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of Restriction")
    
        return Restriction(_data=data)

class UnionAccessInfo(_ISLObjectBase):
    _base_name = 'union_access_info'

    def _get_ctx_data(self):
        return lib.isl_union_access_info_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_access_info_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_access_info_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionAccessInfo")
    
        return UnionAccessInfo(_data=data)

class UnionFlow(_ISLObjectBase):
    _base_name = 'union_flow'

    def _get_ctx_data(self):
        return lib.isl_union_flow_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_union_flow_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_union_flow_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of UnionFlow")
    
        return UnionFlow(_data=data)

class AstExpr(_ISLObjectBase):
    _base_name = 'ast_expr'

    def _get_ctx_data(self):
        return lib.isl_ast_expr_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_ast_expr_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_ast_expr_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AstExpr")
    
        return AstExpr(_data=data)

class AstNode(_ISLObjectBase):
    _base_name = 'ast_node'

    def _get_ctx_data(self):
        return lib.isl_ast_node_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_ast_node_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_ast_node_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AstNode")
    
        return AstNode(_data=data)

class AstPrintOptions(_ISLObjectBase):
    _base_name = 'ast_print_options'

    def _get_ctx_data(self):
        return lib.isl_ast_print_options_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_ast_print_options_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_ast_print_options_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AstPrintOptions")
    
        return AstPrintOptions(_data=data)

class AstBuild(_ISLObjectBase):
    _base_name = 'ast_build'

    def _get_ctx_data(self):
        return lib.isl_ast_build_get_ctx(self.data)
    
    def __del__(self):
        if self.data is not None:
            lib.isl_ast_build_free(self.data)
            _deref_ctx(self._ctx_data, self._ctx_iptr)

    def _copy(self):
        assert self.data is not None
    
        data = lib.isl_ast_build_copy(self.data)
        if data == ffi.NULL:
            raise Error("failed to copy instance of AstBuild")
    
        return AstBuild(_data=data)


# }}}


# {{{ wrappers

def _add_methods():
    # {{{ ctx

    def alloc():
        'alloc()\n\n:return: :class:`Context`'


        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_alloc()
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ctx_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Context.alloc = staticmethod(alloc)

    Context._alloc_is_static = True

    def ref(self):
        'ref(self)\n\n:param self: :class:`Context`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_ref(self.data)
        finally:
            pass
        

    Context.ref = ref

    def deref(self):
        'deref(self)\n\n:param self: :class:`Context`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_deref(self.data)
        finally:
            pass
        

    Context.deref = deref

    def abort(self):
        'abort(self)\n\n:param self: :class:`Context`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_abort(self.data)
        finally:
            pass
        

    Context.abort = abort

    def resume(self):
        'resume(self)\n\n:param self: :class:`Context`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_resume(self.data)
        finally:
            pass
        

    Context.resume = resume

    def aborted(self):
        'aborted(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_aborted(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.aborted = aborted

    def set_max_operations(self, max_operations):
        'set_max_operations(self, max_operations)\n\n:param self: :class:`Context`\n:param max_operations: :class:`long`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for max_operations
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_set_max_operations(self.data, max_operations)
        finally:
            pass
        

    Context.set_max_operations = set_max_operations

    def get_max_operations(self):
        'get_max_operations(self)\n\n:param self: :class:`Context`\n:return: unsigned long'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_get_max_operations(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_max_operations = get_max_operations

    def reset_operations(self):
        'reset_operations(self)\n\n:param self: :class:`Context`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_reset_operations(self.data)
        finally:
            pass
        

    Context.reset_operations = reset_operations

    def last_error(self):
        'last_error(self)\n\n:param self: :class:`Context`\n:return: isl_error'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_last_error(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.last_error = last_error

    def last_error_msg(self):
        'last_error_msg(self)\n\n:param self: :class:`Context`\n:return: string'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_last_error_msg(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Context.last_error_msg = last_error_msg

    def last_error_file(self):
        'last_error_file(self)\n\n:param self: :class:`Context`\n:return: string'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_last_error_file(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Context.last_error_file = last_error_file

    def last_error_line(self):
        'last_error_line(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_last_error_line(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.last_error_line = last_error_line

    def reset_error(self):
        'reset_error(self)\n\n:param self: :class:`Context`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_reset_error(self.data)
        finally:
            pass
        

    Context.reset_error = reset_error

    def set_error(self, error):
        'set_error(self, error)\n\n:param self: :class:`Context`\n:param error: :class:`error`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for error
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ctx_set_error(self.data, error)
        finally:
            pass
        

    Context.set_error = set_error

    def set_schedule_max_coefficient(self, val):
        'set_schedule_max_coefficient(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_max_coefficient(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_max_coefficient\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_max_coefficient = set_schedule_max_coefficient

    def get_schedule_max_coefficient(self):
        'get_schedule_max_coefficient(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_max_coefficient(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_max_coefficient = get_schedule_max_coefficient

    def set_schedule_max_constant_term(self, val):
        'set_schedule_max_constant_term(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_max_constant_term(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_max_constant_term\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_max_constant_term = set_schedule_max_constant_term

    def get_schedule_max_constant_term(self):
        'get_schedule_max_constant_term(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_max_constant_term(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_max_constant_term = get_schedule_max_constant_term

    def set_schedule_maximize_band_depth(self, val):
        'set_schedule_maximize_band_depth(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_maximize_band_depth(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_maximize_band_depth\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_maximize_band_depth = set_schedule_maximize_band_depth

    def get_schedule_maximize_band_depth(self):
        'get_schedule_maximize_band_depth(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_maximize_band_depth(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_maximize_band_depth = get_schedule_maximize_band_depth

    def set_schedule_maximize_coincidence(self, val):
        'set_schedule_maximize_coincidence(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_maximize_coincidence(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_maximize_coincidence\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_maximize_coincidence = set_schedule_maximize_coincidence

    def get_schedule_maximize_coincidence(self):
        'get_schedule_maximize_coincidence(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_maximize_coincidence(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_maximize_coincidence = get_schedule_maximize_coincidence

    def set_schedule_outer_coincidence(self, val):
        'set_schedule_outer_coincidence(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_outer_coincidence(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_outer_coincidence\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_outer_coincidence = set_schedule_outer_coincidence

    def get_schedule_outer_coincidence(self):
        'get_schedule_outer_coincidence(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_outer_coincidence(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_outer_coincidence = get_schedule_outer_coincidence

    def set_schedule_split_scaled(self, val):
        'set_schedule_split_scaled(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_split_scaled(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_split_scaled\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_split_scaled = set_schedule_split_scaled

    def get_schedule_split_scaled(self):
        'get_schedule_split_scaled(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_split_scaled(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_split_scaled = get_schedule_split_scaled

    def set_schedule_treat_coalescing(self, val):
        'set_schedule_treat_coalescing(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_treat_coalescing(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_treat_coalescing\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_treat_coalescing = set_schedule_treat_coalescing

    def get_schedule_treat_coalescing(self):
        'get_schedule_treat_coalescing(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_treat_coalescing(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_treat_coalescing = get_schedule_treat_coalescing

    def set_schedule_separate_components(self, val):
        'set_schedule_separate_components(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_separate_components(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_separate_components\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_separate_components = set_schedule_separate_components

    def get_schedule_separate_components(self):
        'get_schedule_separate_components(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_separate_components(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_separate_components = get_schedule_separate_components

    def set_schedule_serialize_sccs(self, val):
        'set_schedule_serialize_sccs(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_serialize_sccs(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_serialize_sccs\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_serialize_sccs = set_schedule_serialize_sccs

    def get_schedule_serialize_sccs(self):
        'get_schedule_serialize_sccs(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_serialize_sccs(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_serialize_sccs = get_schedule_serialize_sccs

    def set_schedule_whole_component(self, val):
        'set_schedule_whole_component(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_whole_component(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_whole_component\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_whole_component = set_schedule_whole_component

    def get_schedule_whole_component(self):
        'get_schedule_whole_component(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_whole_component(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_whole_component = get_schedule_whole_component

    def set_schedule_carry_self_first(self, val):
        'set_schedule_carry_self_first(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_carry_self_first(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_carry_self_first\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_carry_self_first = set_schedule_carry_self_first

    def get_schedule_carry_self_first(self):
        'get_schedule_carry_self_first(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_carry_self_first(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_carry_self_first = get_schedule_carry_self_first

    def set_tile_scale_tile_loops(self, val):
        'set_tile_scale_tile_loops(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_tile_scale_tile_loops(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_tile_scale_tile_loops\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_tile_scale_tile_loops = set_tile_scale_tile_loops

    def get_tile_scale_tile_loops(self):
        'get_tile_scale_tile_loops(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_tile_scale_tile_loops(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_tile_scale_tile_loops = get_tile_scale_tile_loops

    def set_tile_shift_point_loops(self, val):
        'set_tile_shift_point_loops(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_tile_shift_point_loops(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_tile_shift_point_loops\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_tile_shift_point_loops = set_tile_shift_point_loops

    def get_tile_shift_point_loops(self):
        'get_tile_shift_point_loops(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_tile_shift_point_loops(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_tile_shift_point_loops = get_tile_shift_point_loops

    def set_bound(self, val):
        'set_bound(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_bound(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_bound\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_bound = set_bound

    def get_bound(self):
        'get_bound(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_bound(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_bound = get_bound

    def set_on_error(self, val):
        'set_on_error(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_on_error(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_on_error\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_on_error = set_on_error

    def get_on_error(self):
        'get_on_error(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_on_error(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_on_error = get_on_error

    def set_gbr_only_first(self, val):
        'set_gbr_only_first(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_gbr_only_first(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_gbr_only_first\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_gbr_only_first = set_gbr_only_first

    def get_gbr_only_first(self):
        'get_gbr_only_first(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_gbr_only_first(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_gbr_only_first = get_gbr_only_first

    def set_schedule_algorithm(self, val):
        'set_schedule_algorithm(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_schedule_algorithm(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_schedule_algorithm\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_schedule_algorithm = set_schedule_algorithm

    def get_schedule_algorithm(self):
        'get_schedule_algorithm(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_schedule_algorithm(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_schedule_algorithm = get_schedule_algorithm

    def set_pip_symmetry(self, val):
        'set_pip_symmetry(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_pip_symmetry(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_pip_symmetry\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_pip_symmetry = set_pip_symmetry

    def get_pip_symmetry(self):
        'get_pip_symmetry(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_pip_symmetry(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_pip_symmetry = get_pip_symmetry

    def set_coalesce_bounded_wrapping(self, val):
        'set_coalesce_bounded_wrapping(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_coalesce_bounded_wrapping(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_coalesce_bounded_wrapping\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_coalesce_bounded_wrapping = set_coalesce_bounded_wrapping

    def get_coalesce_bounded_wrapping(self):
        'get_coalesce_bounded_wrapping(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_coalesce_bounded_wrapping(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_coalesce_bounded_wrapping = get_coalesce_bounded_wrapping

    def set_ast_iterator_type(self, val):
        'set_ast_iterator_type(self, val)\n\n:param self: :class:`Context`\n:param val: string\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        _cstr_val = ffi.new("char[]", val.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_iterator_type(self.data, _cstr_val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_iterator_type\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_iterator_type = set_ast_iterator_type

    def get_ast_iterator_type(self):
        'get_ast_iterator_type(self)\n\n:param self: :class:`Context`\n:return: string'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_iterator_type(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Context.get_ast_iterator_type = get_ast_iterator_type

    def set_ast_always_print_block(self, val):
        'set_ast_always_print_block(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_always_print_block(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_always_print_block\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_always_print_block = set_ast_always_print_block

    def get_ast_always_print_block(self):
        'get_ast_always_print_block(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_always_print_block(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_always_print_block = get_ast_always_print_block

    def set_ast_print_macro_once(self, val):
        'set_ast_print_macro_once(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_print_macro_once(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_print_macro_once\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_print_macro_once = set_ast_print_macro_once

    def get_ast_print_macro_once(self):
        'get_ast_print_macro_once(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_print_macro_once(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_print_macro_once = get_ast_print_macro_once

    def set_ast_build_atomic_upper_bound(self, val):
        'set_ast_build_atomic_upper_bound(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_atomic_upper_bound(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_atomic_upper_bound\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_atomic_upper_bound = set_ast_build_atomic_upper_bound

    def get_ast_build_atomic_upper_bound(self):
        'get_ast_build_atomic_upper_bound(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_atomic_upper_bound(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_atomic_upper_bound = get_ast_build_atomic_upper_bound

    def set_ast_build_prefer_pdiv(self, val):
        'set_ast_build_prefer_pdiv(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_prefer_pdiv(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_prefer_pdiv\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_prefer_pdiv = set_ast_build_prefer_pdiv

    def get_ast_build_prefer_pdiv(self):
        'get_ast_build_prefer_pdiv(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_prefer_pdiv(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_prefer_pdiv = get_ast_build_prefer_pdiv

    def set_ast_build_detect_min_max(self, val):
        'set_ast_build_detect_min_max(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_detect_min_max(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_detect_min_max\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_detect_min_max = set_ast_build_detect_min_max

    def get_ast_build_detect_min_max(self):
        'get_ast_build_detect_min_max(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_detect_min_max(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_detect_min_max = get_ast_build_detect_min_max

    def set_ast_build_exploit_nested_bounds(self, val):
        'set_ast_build_exploit_nested_bounds(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_exploit_nested_bounds(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_exploit_nested_bounds\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_exploit_nested_bounds = set_ast_build_exploit_nested_bounds

    def get_ast_build_exploit_nested_bounds(self):
        'get_ast_build_exploit_nested_bounds(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_exploit_nested_bounds(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_exploit_nested_bounds = get_ast_build_exploit_nested_bounds

    def set_ast_build_group_coscheduled(self, val):
        'set_ast_build_group_coscheduled(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_group_coscheduled(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_group_coscheduled\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_group_coscheduled = set_ast_build_group_coscheduled

    def get_ast_build_group_coscheduled(self):
        'get_ast_build_group_coscheduled(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_group_coscheduled(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_group_coscheduled = get_ast_build_group_coscheduled

    def set_ast_build_separation_bounds(self, val):
        'set_ast_build_separation_bounds(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_separation_bounds(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_separation_bounds\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_separation_bounds = set_ast_build_separation_bounds

    def get_ast_build_separation_bounds(self):
        'get_ast_build_separation_bounds(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_separation_bounds(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_separation_bounds = get_ast_build_separation_bounds

    def set_ast_build_scale_strides(self, val):
        'set_ast_build_scale_strides(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_scale_strides(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_scale_strides\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_scale_strides = set_ast_build_scale_strides

    def get_ast_build_scale_strides(self):
        'get_ast_build_scale_strides(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_scale_strides(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_scale_strides = get_ast_build_scale_strides

    def set_ast_build_allow_else(self, val):
        'set_ast_build_allow_else(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_allow_else(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_allow_else\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_allow_else = set_ast_build_allow_else

    def get_ast_build_allow_else(self):
        'get_ast_build_allow_else(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_allow_else(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_allow_else = get_ast_build_allow_else

    def set_ast_build_allow_or(self, val):
        'set_ast_build_allow_or(self, val)\n\n:param self: :class:`Context`\n:param val: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        
        # no argument processing for val
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_set_ast_build_allow_or(self.data, val)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_options_set_ast_build_allow_or\" failed: %s" % _get_last_error_str(_ctx_data))
        

    Context.set_ast_build_allow_or = set_ast_build_allow_or

    def get_ast_build_allow_or(self):
        'get_ast_build_allow_or(self)\n\n:param self: :class:`Context`\n:return: int'

        if not isinstance(self, Context):
            raise IslTypeError("self is not a Context")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_options_get_ast_build_allow_or(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Context.get_ast_build_allow_or = get_ast_build_allow_or

    # }}}

    # {{{ id_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`IdList`\n:return: :class:`Context`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.get_ctx = get_ctx

    def from_id(el):
        'from_id(el)\n\n:param el: :class:`Id`\n:return: :class:`IdList`'

        if not isinstance(el, Id):
            raise IslTypeError("el is not a Id")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_from_id(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_from_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.from_id = staticmethod(from_id)

    IdList._from_id_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`IdList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.alloc = staticmethod(alloc)

    IdList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`IdList`\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`IdList`\n:param el: :class:`Id`\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, Id):
            raise IslTypeError("el is not a Id")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`IdList`\n:param pos: :class:`unsigned`\n:param el: :class:`Id`\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, Id):
            raise IslTypeError("el is not a Id")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`IdList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`IdList`\n:param list2: :class:`IdList`\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, IdList):
            raise IslTypeError("list2 is not a IdList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.concat = concat

    def n_id(self):
        'n_id(self)\n\n:param self: :class:`IdList`\n:return: int'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_n_id(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    IdList.n_id = n_id

    def get_id(self, index):
        'get_id(self, index)\n\n:param self: :class:`IdList`\n:param index: :class:`int`\n:return: :class:`Id`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_get_id(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Id(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_get_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.get_id = get_id

    def set_id(self, index, el):
        'set_id(self, index, el)\n\n:param self: :class:`IdList`\n:param index: :class:`int`\n:param el: :class:`Id`\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, Id):
            raise IslTypeError("el is not a Id")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_set_id(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_set_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.set_id = set_id

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`IdList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Id(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_id *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_id_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    IdList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`IdList`\n:param fn: callback(el) -> isl_id\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Id(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, Id):
                    raise IslTypeError("return value is not a Id")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_id *(*fn)( isl_id *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`IdList`\n:param cmp: callback(a, b) -> int\n:return: :class:`IdList`'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = Id(_data=a)
                _py_b = Id(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_id *a, struct isl_id *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else IdList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_id_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    IdList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`IdList`\n:return: (nothing)'

        if not isinstance(self, IdList):
            raise IslTypeError("self is not a IdList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_id_list_dump(self.data)
        finally:
            pass
        

    IdList.dump = dump

    # }}}

    # {{{ val_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`ValList`\n:return: :class:`Context`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.get_ctx = get_ctx

    def from_val(el):
        'from_val(el)\n\n:param el: :class:`Val`\n:return: :class:`ValList`'

        if not isinstance(el, Val):
            raise IslTypeError("el is not a Val")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_from_val(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_from_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.from_val = staticmethod(from_val)

    ValList._from_val_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`ValList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.alloc = staticmethod(alloc)

    ValList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`ValList`\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`ValList`\n:param el: :class:`Val`\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(el, Val):
            if _ctx_data != el._ctx_data:
                raise Error("mismatched context in el")
            _val_el = el._copy()
        elif isinstance(el, six.integer_types):
            _cdata_el = lib.isl_val_int_from_si(
                self._get_ctx_data(), el)
        
            if _cdata_el == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_el = Val(_data=_cdata_el)
        
        else:
            raise IslTypeError("el is a %s and cannot "
                "be cast to a Val" % type(el))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_add(_copy_self._release(), _val_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`ValList`\n:param pos: :class:`unsigned`\n:param el: :class:`Val`\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(el, Val):
            if _ctx_data != el._ctx_data:
                raise Error("mismatched context in el")
            _val_el = el._copy()
        elif isinstance(el, six.integer_types):
            _cdata_el = lib.isl_val_int_from_si(
                self._get_ctx_data(), el)
        
            if _cdata_el == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_el = Val(_data=_cdata_el)
        
        else:
            raise IslTypeError("el is a %s and cannot "
                "be cast to a Val" % type(el))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_insert(_copy_self._release(), pos, _val_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`ValList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`ValList`\n:param list2: :class:`ValList`\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, ValList):
            raise IslTypeError("list2 is not a ValList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.concat = concat

    def n_val(self):
        'n_val(self)\n\n:param self: :class:`ValList`\n:return: int'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_n_val(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    ValList.n_val = n_val

    def get_val(self, index):
        'get_val(self, index)\n\n:param self: :class:`ValList`\n:param index: :class:`int`\n:return: :class:`Val`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_get_val(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_get_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.get_val = get_val

    def set_val(self, index, el):
        'set_val(self, index, el)\n\n:param self: :class:`ValList`\n:param index: :class:`int`\n:param el: :class:`Val`\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if isinstance(el, Val):
            if _ctx_data != el._ctx_data:
                raise Error("mismatched context in el")
            _val_el = el._copy()
        elif isinstance(el, six.integer_types):
            _cdata_el = lib.isl_val_int_from_si(
                self._get_ctx_data(), el)
        
            if _cdata_el == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_el = Val(_data=_cdata_el)
        
        else:
            raise IslTypeError("el is a %s and cannot "
                "be cast to a Val" % type(el))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_set_val(_copy_self._release(), index, _val_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_set_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.set_val = set_val

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`ValList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Val(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_val *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_val_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    ValList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`ValList`\n:param fn: callback(el) -> isl_val\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Val(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, Val):
                    raise IslTypeError("return value is not a Val")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_val *(*fn)( isl_val *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`ValList`\n:param cmp: callback(a, b) -> int\n:return: :class:`ValList`'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = Val(_data=a)
                _py_b = Val(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_val *a, struct isl_val *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ValList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ValList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`ValList`\n:return: (nothing)'

        if not isinstance(self, ValList):
            raise IslTypeError("self is not a ValList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_list_dump(self.data)
        finally:
            pass
        

    ValList.dump = dump

    # }}}

    # {{{ basic_set_list

    def intersect(self):
        'intersect(self)\n\n:param self: :class:`BasicSetList`\n:return: :class:`BasicSet`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_intersect(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_intersect failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.intersect = intersect

    def coefficients(self):
        'coefficients(self)\n\n:param self: :class:`BasicSetList`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_coefficients(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_coefficients failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.coefficients = coefficients

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`BasicSetList`\n:return: :class:`Context`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.get_ctx = get_ctx

    def from_basic_set(el):
        'from_basic_set(el)\n\n:param el: :class:`BasicSet`\n:return: :class:`BasicSetList`'

        if not isinstance(el, BasicSet):
            raise IslTypeError("el is not a BasicSet")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_from_basic_set(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_from_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.from_basic_set = staticmethod(from_basic_set)

    BasicSetList._from_basic_set_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`BasicSetList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.alloc = staticmethod(alloc)

    BasicSetList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`BasicSetList`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`BasicSetList`\n:param el: :class:`BasicSet`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, BasicSet):
            raise IslTypeError("el is not a BasicSet")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`BasicSetList`\n:param pos: :class:`unsigned`\n:param el: :class:`BasicSet`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, BasicSet):
            raise IslTypeError("el is not a BasicSet")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`BasicSetList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`BasicSetList`\n:param list2: :class:`BasicSetList`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, BasicSetList):
            raise IslTypeError("list2 is not a BasicSetList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.concat = concat

    def n_basic_set(self):
        'n_basic_set(self)\n\n:param self: :class:`BasicSetList`\n:return: int'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_n_basic_set(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    BasicSetList.n_basic_set = n_basic_set

    def get_basic_set(self, index):
        'get_basic_set(self, index)\n\n:param self: :class:`BasicSetList`\n:param index: :class:`int`\n:return: :class:`BasicSet`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_get_basic_set(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_get_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.get_basic_set = get_basic_set

    def set_basic_set(self, index, el):
        'set_basic_set(self, index, el)\n\n:param self: :class:`BasicSetList`\n:param index: :class:`int`\n:param el: :class:`BasicSet`\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, BasicSet):
            raise IslTypeError("el is not a BasicSet")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_set_basic_set(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_set_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.set_basic_set = set_basic_set

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`BasicSetList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = BasicSet(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_basic_set *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_basic_set_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    BasicSetList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`BasicSetList`\n:param fn: callback(el) -> isl_basic_set\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = BasicSet(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, BasicSet):
                    raise IslTypeError("return value is not a BasicSet")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_basic_set *(*fn)( isl_basic_set *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`BasicSetList`\n:param cmp: callback(a, b) -> int\n:return: :class:`BasicSetList`'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = BasicSet(_data=a)
                _py_b = BasicSet(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_basic_set *a, struct isl_basic_set *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_set_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicSetList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`BasicSetList`\n:return: (nothing)'

        if not isinstance(self, BasicSetList):
            raise IslTypeError("self is not a BasicSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_set_list_dump(self.data)
        finally:
            pass
        

    BasicSetList.dump = dump

    # }}}

    # {{{ basic_map_list

    def intersect(self):
        'intersect(self)\n\n:param self: :class:`BasicMapList`\n:return: :class:`BasicMap`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_intersect(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMap(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_intersect failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.intersect = intersect

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`BasicMapList`\n:return: :class:`Context`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.get_ctx = get_ctx

    def from_basic_map(el):
        'from_basic_map(el)\n\n:param el: :class:`BasicMap`\n:return: :class:`BasicMapList`'

        if not isinstance(el, BasicMap):
            raise IslTypeError("el is not a BasicMap")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_from_basic_map(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_from_basic_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.from_basic_map = staticmethod(from_basic_map)

    BasicMapList._from_basic_map_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`BasicMapList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.alloc = staticmethod(alloc)

    BasicMapList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`BasicMapList`\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`BasicMapList`\n:param el: :class:`BasicMap`\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, BasicMap):
            raise IslTypeError("el is not a BasicMap")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`BasicMapList`\n:param pos: :class:`unsigned`\n:param el: :class:`BasicMap`\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, BasicMap):
            raise IslTypeError("el is not a BasicMap")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`BasicMapList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`BasicMapList`\n:param list2: :class:`BasicMapList`\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, BasicMapList):
            raise IslTypeError("list2 is not a BasicMapList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.concat = concat

    def n_basic_map(self):
        'n_basic_map(self)\n\n:param self: :class:`BasicMapList`\n:return: int'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_n_basic_map(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    BasicMapList.n_basic_map = n_basic_map

    def get_basic_map(self, index):
        'get_basic_map(self, index)\n\n:param self: :class:`BasicMapList`\n:param index: :class:`int`\n:return: :class:`BasicMap`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_get_basic_map(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMap(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_get_basic_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.get_basic_map = get_basic_map

    def set_basic_map(self, index, el):
        'set_basic_map(self, index, el)\n\n:param self: :class:`BasicMapList`\n:param index: :class:`int`\n:param el: :class:`BasicMap`\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, BasicMap):
            raise IslTypeError("el is not a BasicMap")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_set_basic_map(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_set_basic_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.set_basic_map = set_basic_map

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`BasicMapList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = BasicMap(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_basic_map *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_basic_map_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    BasicMapList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`BasicMapList`\n:param fn: callback(el) -> isl_basic_map\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = BasicMap(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, BasicMap):
                    raise IslTypeError("return value is not a BasicMap")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_basic_map *(*fn)( isl_basic_map *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`BasicMapList`\n:param cmp: callback(a, b) -> int\n:return: :class:`BasicMapList`'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = BasicMap(_data=a)
                _py_b = BasicMap(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_basic_map *a, struct isl_basic_map *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicMapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_basic_map_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    BasicMapList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`BasicMapList`\n:return: (nothing)'

        if not isinstance(self, BasicMapList):
            raise IslTypeError("self is not a BasicMapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_basic_map_list_dump(self.data)
        finally:
            pass
        

    BasicMapList.dump = dump

    # }}}

    # {{{ set_list

    def union(self):
        'union(self)\n\n:param self: :class:`SetList`\n:return: :class:`Set`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_union(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_union failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.union = union

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`SetList`\n:return: :class:`Context`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.get_ctx = get_ctx

    def from_set(el):
        'from_set(el)\n\n:param el: :class:`Set`\n:return: :class:`SetList`'

        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if not isinstance(el, Set):
            raise IslTypeError("el is not a Set")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_from_set(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_from_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.from_set = staticmethod(from_set)

    SetList._from_set_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`SetList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.alloc = staticmethod(alloc)

    SetList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`SetList`\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`SetList`\n:param el: :class:`Set`\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if not isinstance(el, Set):
            raise IslTypeError("el is not a Set")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`SetList`\n:param pos: :class:`unsigned`\n:param el: :class:`Set`\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if not isinstance(el, Set):
            raise IslTypeError("el is not a Set")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`SetList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`SetList`\n:param list2: :class:`SetList`\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, SetList):
            raise IslTypeError("list2 is not a SetList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.concat = concat

    def n_set(self):
        'n_set(self)\n\n:param self: :class:`SetList`\n:return: int'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_n_set(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    SetList.n_set = n_set

    def get_set(self, index):
        'get_set(self, index)\n\n:param self: :class:`SetList`\n:param index: :class:`int`\n:return: :class:`Set`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_get_set(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_get_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.get_set = get_set

    def set_set(self, index, el):
        'set_set(self, index, el)\n\n:param self: :class:`SetList`\n:param index: :class:`int`\n:param el: :class:`Set`\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if not isinstance(el, Set):
            raise IslTypeError("el is not a Set")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_set_set(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_set_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.set_set = set_set

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`SetList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Set(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_set *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_set_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    SetList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`SetList`\n:param fn: callback(el) -> isl_set\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Set(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, Set):
                    raise IslTypeError("return value is not a Set")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_set *(*fn)( isl_set *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`SetList`\n:param cmp: callback(a, b) -> int\n:return: :class:`SetList`'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = Set(_data=a)
                _py_b = Set(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_set *a, struct isl_set *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else SetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_set_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    SetList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`SetList`\n:return: (nothing)'

        if not isinstance(self, SetList):
            raise IslTypeError("self is not a SetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_set_list_dump(self.data)
        finally:
            pass
        

    SetList.dump = dump

    # }}}

    # {{{ map_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`MapList`\n:return: :class:`Context`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.get_ctx = get_ctx

    def from_map(el):
        'from_map(el)\n\n:param el: :class:`Map`\n:return: :class:`MapList`'

        if isinstance(el, BasicMap):
            el = Map.from_basic_map(el)
        if not isinstance(el, Map):
            raise IslTypeError("el is not a Map")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_from_map(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_from_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.from_map = staticmethod(from_map)

    MapList._from_map_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`MapList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.alloc = staticmethod(alloc)

    MapList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`MapList`\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`MapList`\n:param el: :class:`Map`\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(el, BasicMap):
            el = Map.from_basic_map(el)
        if not isinstance(el, Map):
            raise IslTypeError("el is not a Map")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`MapList`\n:param pos: :class:`unsigned`\n:param el: :class:`Map`\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(el, BasicMap):
            el = Map.from_basic_map(el)
        if not isinstance(el, Map):
            raise IslTypeError("el is not a Map")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`MapList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`MapList`\n:param list2: :class:`MapList`\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, MapList):
            raise IslTypeError("list2 is not a MapList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.concat = concat

    def n_map(self):
        'n_map(self)\n\n:param self: :class:`MapList`\n:return: int'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_n_map(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    MapList.n_map = n_map

    def get_map(self, index):
        'get_map(self, index)\n\n:param self: :class:`MapList`\n:param index: :class:`int`\n:return: :class:`Map`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_get_map(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Map(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_get_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.get_map = get_map

    def set_map(self, index, el):
        'set_map(self, index, el)\n\n:param self: :class:`MapList`\n:param index: :class:`int`\n:param el: :class:`Map`\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if isinstance(el, BasicMap):
            el = Map.from_basic_map(el)
        if not isinstance(el, Map):
            raise IslTypeError("el is not a Map")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_set_map(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_set_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.set_map = set_map

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`MapList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Map(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_map *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_map_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    MapList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`MapList`\n:param fn: callback(el) -> isl_map\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Map(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, Map):
                    raise IslTypeError("return value is not a Map")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_map *(*fn)( isl_map *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`MapList`\n:param cmp: callback(a, b) -> int\n:return: :class:`MapList`'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = Map(_data=a)
                _py_b = Map(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_map *a, struct isl_map *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MapList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_map_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MapList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`MapList`\n:return: (nothing)'

        if not isinstance(self, MapList):
            raise IslTypeError("self is not a MapList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_map_list_dump(self.data)
        finally:
            pass
        

    MapList.dump = dump

    # }}}

    # {{{ union_set_list

    def union(self):
        'union(self)\n\n:param self: :class:`UnionSetList`\n:return: :class:`UnionSet`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_union(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_union failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.union = union

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`UnionSetList`\n:return: :class:`Context`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.get_ctx = get_ctx

    def from_union_set(el):
        'from_union_set(el)\n\n:param el: :class:`UnionSet`\n:return: :class:`UnionSetList`'

        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if isinstance(el, Set):
            el = UnionSet.from_set(el)
        if not isinstance(el, UnionSet):
            raise IslTypeError("el is not a UnionSet")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_from_union_set(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_from_union_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.from_union_set = staticmethod(from_union_set)

    UnionSetList._from_union_set_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`UnionSetList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.alloc = staticmethod(alloc)

    UnionSetList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`UnionSetList`\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`UnionSetList`\n:param el: :class:`UnionSet`\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if isinstance(el, Set):
            el = UnionSet.from_set(el)
        if not isinstance(el, UnionSet):
            raise IslTypeError("el is not a UnionSet")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`UnionSetList`\n:param pos: :class:`unsigned`\n:param el: :class:`UnionSet`\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if isinstance(el, Set):
            el = UnionSet.from_set(el)
        if not isinstance(el, UnionSet):
            raise IslTypeError("el is not a UnionSet")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`UnionSetList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`UnionSetList`\n:param list2: :class:`UnionSetList`\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, UnionSetList):
            raise IslTypeError("list2 is not a UnionSetList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.concat = concat

    def n_union_set(self):
        'n_union_set(self)\n\n:param self: :class:`UnionSetList`\n:return: int'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_n_union_set(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    UnionSetList.n_union_set = n_union_set

    def get_union_set(self, index):
        'get_union_set(self, index)\n\n:param self: :class:`UnionSetList`\n:param index: :class:`int`\n:return: :class:`UnionSet`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_get_union_set(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_get_union_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.get_union_set = get_union_set

    def set_union_set(self, index, el):
        'set_union_set(self, index, el)\n\n:param self: :class:`UnionSetList`\n:param index: :class:`int`\n:param el: :class:`UnionSet`\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if isinstance(el, BasicSet):
            el = Set.from_basic_set(el)
        if isinstance(el, Set):
            el = UnionSet.from_set(el)
        if not isinstance(el, UnionSet):
            raise IslTypeError("el is not a UnionSet")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_set_union_set(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_set_union_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.set_union_set = set_union_set

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`UnionSetList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = UnionSet(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_union_set *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_union_set_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    UnionSetList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`UnionSetList`\n:param fn: callback(el) -> isl_union_set\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = UnionSet(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, UnionSet):
                    raise IslTypeError("return value is not a UnionSet")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_union_set *(*fn)( isl_union_set *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`UnionSetList`\n:param cmp: callback(a, b) -> int\n:return: :class:`UnionSetList`'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = UnionSet(_data=a)
                _py_b = UnionSet(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_union_set *a, struct isl_union_set *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionSetList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_set_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionSetList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`UnionSetList`\n:return: (nothing)'

        if not isinstance(self, UnionSetList):
            raise IslTypeError("self is not a UnionSetList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_set_list_dump(self.data)
        finally:
            pass
        

    UnionSetList.dump = dump

    # }}}

    # {{{ constraint_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`ConstraintList`\n:return: :class:`Context`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.get_ctx = get_ctx

    def from_constraint(el):
        'from_constraint(el)\n\n:param el: :class:`Constraint`\n:return: :class:`ConstraintList`'

        if not isinstance(el, Constraint):
            raise IslTypeError("el is not a Constraint")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_from_constraint(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_from_constraint failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.from_constraint = staticmethod(from_constraint)

    ConstraintList._from_constraint_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`ConstraintList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.alloc = staticmethod(alloc)

    ConstraintList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`ConstraintList`\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`ConstraintList`\n:param el: :class:`Constraint`\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, Constraint):
            raise IslTypeError("el is not a Constraint")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`ConstraintList`\n:param pos: :class:`unsigned`\n:param el: :class:`Constraint`\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, Constraint):
            raise IslTypeError("el is not a Constraint")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`ConstraintList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`ConstraintList`\n:param list2: :class:`ConstraintList`\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, ConstraintList):
            raise IslTypeError("list2 is not a ConstraintList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.concat = concat

    def n_constraint(self):
        'n_constraint(self)\n\n:param self: :class:`ConstraintList`\n:return: int'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_n_constraint(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    ConstraintList.n_constraint = n_constraint

    def get_constraint(self, index):
        'get_constraint(self, index)\n\n:param self: :class:`ConstraintList`\n:param index: :class:`int`\n:return: :class:`Constraint`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_get_constraint(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Constraint(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_get_constraint failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.get_constraint = get_constraint

    def set_constraint(self, index, el):
        'set_constraint(self, index, el)\n\n:param self: :class:`ConstraintList`\n:param index: :class:`int`\n:param el: :class:`Constraint`\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, Constraint):
            raise IslTypeError("el is not a Constraint")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_set_constraint(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_set_constraint failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.set_constraint = set_constraint

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`ConstraintList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Constraint(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_constraint *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_constraint_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    ConstraintList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`ConstraintList`\n:param fn: callback(el) -> isl_constraint\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Constraint(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, Constraint):
                    raise IslTypeError("return value is not a Constraint")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_constraint *(*fn)( isl_constraint *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`ConstraintList`\n:param cmp: callback(a, b) -> int\n:return: :class:`ConstraintList`'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = Constraint(_data=a)
                _py_b = Constraint(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_constraint *a, struct isl_constraint *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else ConstraintList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_constraint_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    ConstraintList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`ConstraintList`\n:return: (nothing)'

        if not isinstance(self, ConstraintList):
            raise IslTypeError("self is not a ConstraintList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_constraint_list_dump(self.data)
        finally:
            pass
        

    ConstraintList.dump = dump

    # }}}

    # {{{ aff_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`AffList`\n:return: :class:`Context`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.get_ctx = get_ctx

    def from_aff(el):
        'from_aff(el)\n\n:param el: :class:`Aff`\n:return: :class:`AffList`'

        if not isinstance(el, Aff):
            raise IslTypeError("el is not a Aff")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_from_aff(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_from_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.from_aff = staticmethod(from_aff)

    AffList._from_aff_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`AffList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.alloc = staticmethod(alloc)

    AffList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`AffList`\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`AffList`\n:param el: :class:`Aff`\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, Aff):
            raise IslTypeError("el is not a Aff")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`AffList`\n:param pos: :class:`unsigned`\n:param el: :class:`Aff`\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, Aff):
            raise IslTypeError("el is not a Aff")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`AffList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`AffList`\n:param list2: :class:`AffList`\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, AffList):
            raise IslTypeError("list2 is not a AffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.concat = concat

    def n_aff(self):
        'n_aff(self)\n\n:param self: :class:`AffList`\n:return: int'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_n_aff(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    AffList.n_aff = n_aff

    def get_aff(self, index):
        'get_aff(self, index)\n\n:param self: :class:`AffList`\n:param index: :class:`int`\n:return: :class:`Aff`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_get_aff(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_get_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.get_aff = get_aff

    def set_aff(self, index, el):
        'set_aff(self, index, el)\n\n:param self: :class:`AffList`\n:param index: :class:`int`\n:param el: :class:`Aff`\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, Aff):
            raise IslTypeError("el is not a Aff")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_set_aff(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_set_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.set_aff = set_aff

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`AffList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Aff(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_aff *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_aff_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    AffList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`AffList`\n:param fn: callback(el) -> isl_aff\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = Aff(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, Aff):
                    raise IslTypeError("return value is not a Aff")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_aff *(*fn)( isl_aff *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`AffList`\n:param cmp: callback(a, b) -> int\n:return: :class:`AffList`'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = Aff(_data=a)
                _py_b = Aff(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_aff *a, struct isl_aff *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AffList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`AffList`\n:return: (nothing)'

        if not isinstance(self, AffList):
            raise IslTypeError("self is not a AffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_list_dump(self.data)
        finally:
            pass
        

    AffList.dump = dump

    # }}}

    # {{{ pw_aff_list

    def min(self):
        'min(self)\n\n:param self: :class:`PwAffList`\n:return: :class:`PwAff`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_min(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_min failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.min = min

    def max(self):
        'max(self)\n\n:param self: :class:`PwAffList`\n:return: :class:`PwAff`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_max(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_max failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.max = max

    def eq_set(self, list2):
        'eq_set(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`Set`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_eq_set(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_eq_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.eq_set = eq_set

    def ne_set(self, list2):
        'ne_set(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`Set`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_ne_set(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_ne_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.ne_set = ne_set

    def le_set(self, list2):
        'le_set(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`Set`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_le_set(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_le_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.le_set = le_set

    def lt_set(self, list2):
        'lt_set(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`Set`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_lt_set(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_lt_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.lt_set = lt_set

    def ge_set(self, list2):
        'ge_set(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`Set`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_ge_set(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_ge_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.ge_set = ge_set

    def gt_set(self, list2):
        'gt_set(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`Set`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_gt_set(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_gt_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.gt_set = gt_set

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`PwAffList`\n:return: :class:`Context`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.get_ctx = get_ctx

    def from_pw_aff(el):
        'from_pw_aff(el)\n\n:param el: :class:`PwAff`\n:return: :class:`PwAffList`'

        if isinstance(el, Aff):
            el = PwAff.from_aff(el)
        if not isinstance(el, PwAff):
            raise IslTypeError("el is not a PwAff")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_from_pw_aff(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_from_pw_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.from_pw_aff = staticmethod(from_pw_aff)

    PwAffList._from_pw_aff_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`PwAffList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.alloc = staticmethod(alloc)

    PwAffList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`PwAffList`\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`PwAffList`\n:param el: :class:`PwAff`\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(el, Aff):
            el = PwAff.from_aff(el)
        if not isinstance(el, PwAff):
            raise IslTypeError("el is not a PwAff")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`PwAffList`\n:param pos: :class:`unsigned`\n:param el: :class:`PwAff`\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(el, Aff):
            el = PwAff.from_aff(el)
        if not isinstance(el, PwAff):
            raise IslTypeError("el is not a PwAff")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`PwAffList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`PwAffList`\n:param list2: :class:`PwAffList`\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, PwAffList):
            raise IslTypeError("list2 is not a PwAffList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.concat = concat

    def n_pw_aff(self):
        'n_pw_aff(self)\n\n:param self: :class:`PwAffList`\n:return: int'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_n_pw_aff(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    PwAffList.n_pw_aff = n_pw_aff

    def get_pw_aff(self, index):
        'get_pw_aff(self, index)\n\n:param self: :class:`PwAffList`\n:param index: :class:`int`\n:return: :class:`PwAff`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_get_pw_aff(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_get_pw_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.get_pw_aff = get_pw_aff

    def set_pw_aff(self, index, el):
        'set_pw_aff(self, index, el)\n\n:param self: :class:`PwAffList`\n:param index: :class:`int`\n:param el: :class:`PwAff`\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if isinstance(el, Aff):
            el = PwAff.from_aff(el)
        if not isinstance(el, PwAff):
            raise IslTypeError("el is not a PwAff")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_set_pw_aff(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_set_pw_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.set_pw_aff = set_pw_aff

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`PwAffList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = PwAff(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_pw_aff *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_pw_aff_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    PwAffList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`PwAffList`\n:param fn: callback(el) -> isl_pw_aff\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = PwAff(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, PwAff):
                    raise IslTypeError("return value is not a PwAff")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_pw_aff *(*fn)( isl_pw_aff *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`PwAffList`\n:param cmp: callback(a, b) -> int\n:return: :class:`PwAffList`'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = PwAff(_data=a)
                _py_b = PwAff(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_pw_aff *a, struct isl_pw_aff *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAffList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`PwAffList`\n:return: (nothing)'

        if not isinstance(self, PwAffList):
            raise IslTypeError("self is not a PwAffList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_list_dump(self.data)
        finally:
            pass
        

    PwAffList.dump = dump

    # }}}

    # {{{ pw_multi_aff_list

    # }}}

    # {{{ ast_expr_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`AstExprList`\n:return: :class:`Context`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.get_ctx = get_ctx

    def from_ast_expr(el):
        'from_ast_expr(el)\n\n:param el: :class:`AstExpr`\n:return: :class:`AstExprList`'

        if not isinstance(el, AstExpr):
            raise IslTypeError("el is not a AstExpr")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_from_ast_expr(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_from_ast_expr failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.from_ast_expr = staticmethod(from_ast_expr)

    AstExprList._from_ast_expr_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`AstExprList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.alloc = staticmethod(alloc)

    AstExprList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`AstExprList`\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`AstExprList`\n:param el: :class:`AstExpr`\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, AstExpr):
            raise IslTypeError("el is not a AstExpr")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`AstExprList`\n:param pos: :class:`unsigned`\n:param el: :class:`AstExpr`\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, AstExpr):
            raise IslTypeError("el is not a AstExpr")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`AstExprList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`AstExprList`\n:param list2: :class:`AstExprList`\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, AstExprList):
            raise IslTypeError("list2 is not a AstExprList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.concat = concat

    def n_ast_expr(self):
        'n_ast_expr(self)\n\n:param self: :class:`AstExprList`\n:return: int'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_n_ast_expr(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    AstExprList.n_ast_expr = n_ast_expr

    def get_ast_expr(self, index):
        'get_ast_expr(self, index)\n\n:param self: :class:`AstExprList`\n:param index: :class:`int`\n:return: :class:`AstExpr`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_get_ast_expr(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExpr(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_get_ast_expr failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.get_ast_expr = get_ast_expr

    def set_ast_expr(self, index, el):
        'set_ast_expr(self, index, el)\n\n:param self: :class:`AstExprList`\n:param index: :class:`int`\n:param el: :class:`AstExpr`\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, AstExpr):
            raise IslTypeError("el is not a AstExpr")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_set_ast_expr(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_set_ast_expr failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.set_ast_expr = set_ast_expr

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`AstExprList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = AstExpr(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_ast_expr *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_ast_expr_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    AstExprList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`AstExprList`\n:param fn: callback(el) -> isl_ast_expr\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = AstExpr(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, AstExpr):
                    raise IslTypeError("return value is not a AstExpr")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_ast_expr *(*fn)( isl_ast_expr *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`AstExprList`\n:param cmp: callback(a, b) -> int\n:return: :class:`AstExprList`'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = AstExpr(_data=a)
                _py_b = AstExpr(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_ast_expr *a, struct isl_ast_expr *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstExprList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_expr_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstExprList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`AstExprList`\n:return: (nothing)'

        if not isinstance(self, AstExprList):
            raise IslTypeError("self is not a AstExprList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_expr_list_dump(self.data)
        finally:
            pass
        

    AstExprList.dump = dump

    # }}}

    # {{{ ast_node_list

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`AstNodeList`\n:return: :class:`Context`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.get_ctx = get_ctx

    def from_ast_node(el):
        'from_ast_node(el)\n\n:param el: :class:`AstNode`\n:return: :class:`AstNodeList`'

        if not isinstance(el, AstNode):
            raise IslTypeError("el is not a AstNode")
        _ctx_data = el._ctx_data
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_from_ast_node(_copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_from_ast_node failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.from_ast_node = staticmethod(from_ast_node)

    AstNodeList._from_ast_node_is_static = True

    def alloc(ctx, n):
        'alloc(ctx, n)\n\n:param ctx: :class:`Context`\n:param n: :class:`int`\n:return: :class:`AstNodeList`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_alloc(ctx.data, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.alloc = staticmethod(alloc)

    AstNodeList._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`AstNodeList`\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.copy = copy

    def add(self, el):
        'add(self, el)\n\n:param self: :class:`AstNodeList`\n:param el: :class:`AstNode`\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(el, AstNode):
            raise IslTypeError("el is not a AstNode")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_add(_copy_self._release(), _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.add = add

    def insert(self, pos, el):
        'insert(self, pos, el)\n\n:param self: :class:`AstNodeList`\n:param pos: :class:`unsigned`\n:param el: :class:`AstNode`\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(el, AstNode):
            raise IslTypeError("el is not a AstNode")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_insert(_copy_self._release(), pos, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_insert failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.insert = insert

    def drop(self, first, n):
        'drop(self, first, n)\n\n:param self: :class:`AstNodeList`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_drop(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_drop failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.drop = drop

    def concat(self, list2):
        'concat(self, list2)\n\n:param self: :class:`AstNodeList`\n:param list2: :class:`AstNodeList`\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(list2, AstNodeList):
            raise IslTypeError("list2 is not a AstNodeList")
        if _ctx_data != list2._ctx_data:
            raise Error("mismatched context in list2")
        _copy_list2 = list2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_concat(_copy_self._release(), _copy_list2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.concat = concat

    def n_ast_node(self):
        'n_ast_node(self)\n\n:param self: :class:`AstNodeList`\n:return: int'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_n_ast_node(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    AstNodeList.n_ast_node = n_ast_node

    def get_ast_node(self, index):
        'get_ast_node(self, index)\n\n:param self: :class:`AstNodeList`\n:param index: :class:`int`\n:return: :class:`AstNode`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        
        # no argument processing for index
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_get_ast_node(self.data, index)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNode(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_get_ast_node failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.get_ast_node = get_ast_node

    def set_ast_node(self, index, el):
        'set_ast_node(self, index, el)\n\n:param self: :class:`AstNodeList`\n:param index: :class:`int`\n:param el: :class:`AstNode`\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for index
        
        if not isinstance(el, AstNode):
            raise IslTypeError("el is not a AstNode")
        if _ctx_data != el._ctx_data:
            raise Error("mismatched context in el")
        _copy_el = el._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_set_ast_node(_copy_self._release(), index, _copy_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_set_ast_node failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.set_ast_node = set_ast_node

    def foreach(self, fn):
        'foreach(self, fn)\n\n:param self: :class:`AstNodeList`\n:param fn: callback(el) -> isl_stat\n:return: (nothing)'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = AstNode(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)(struct isl_ast_node *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_foreach(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_ast_node_list_foreach\" failed: %s" % _get_last_error_str(_ctx_data))
        

    AstNodeList.foreach = foreach

    def map(self, fn):
        'map(self, fn)\n\n:param self: :class:`AstNodeList`\n:param fn: callback(el) -> isl_ast_node\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_fn(el, user):
            try:
                _py_el = AstNode(_data=el)
                _result = fn(_py_el)
                if _result is None:
                    _result = ffi.NULL
                elif not isinstance(_result, AstNode):
                    raise IslTypeError("return value is not a AstNode")
                else:
                    _result = _result._release()
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return ffi.NULL
        
        _cb_fn = ffi.callback(" isl_ast_node *(*fn)( isl_ast_node *el,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_map(_copy_self._release(), _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.map = map

    def sort(self, cmp):
        'sort(self, cmp)\n\n:param self: :class:`AstNodeList`\n:param cmp: callback(a, b) -> int\n:return: :class:`AstNodeList`'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        def _cb_wrapper_cmp(a, b, user):
            try:
                _py_a = AstNode(_data=a)
                _py_b = AstNode(_data=b)
                _result = cmp(_py_a, _py_b)
                _py_a._release()
                _py_b._release()
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_cmp = ffi.callback(" int (*cmp)(struct isl_ast_node *a, struct isl_ast_node *b,  void *user)")(_cb_wrapper_cmp)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_sort(_copy_self._release(), _cb_cmp, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else AstNodeList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_ast_node_list_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    AstNodeList.sort = sort

    def dump(self):
        'dump(self)\n\n:param self: :class:`AstNodeList`\n:return: (nothing)'

        if not isinstance(self, AstNodeList):
            raise IslTypeError("self is not a AstNodeList")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_node_list_dump(self.data)
        finally:
            pass
        

    AstNodeList.dump = dump

    # }}}

    # {{{ pw_qpolynomial_list

    # }}}

    # {{{ pw_qpolynomial_fold_list

    # }}}

    # {{{ id_to_ast_expr

    # }}}

    # {{{ printer

    def print_id(self, id):
        'print_id(self, id)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param id: :class:`Id`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_id(self.data, id.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_id = print_id

    def print_space(self, dim):
        'print_space(self, dim)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param dim: :class:`Space`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(dim, Space):
            raise IslTypeError("dim is not a Space")
        if _ctx_data != dim._ctx_data:
            raise Error("mismatched context in dim")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_space(self.data, dim.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_space = print_space

    def print_basic_set(self, bset):
        'print_basic_set(self, bset)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param bset: :class:`BasicSet`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(bset, BasicSet):
            raise IslTypeError("bset is not a BasicSet")
        if _ctx_data != bset._ctx_data:
            raise Error("mismatched context in bset")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_basic_set(self.data, bset.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_basic_set = print_basic_set

    def print_set(self, map):
        'print_set(self, map)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param map: :class:`Set`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(map, BasicSet):
            map = Set.from_basic_set(map)
        if not isinstance(map, Set):
            raise IslTypeError("map is not a Set")
        if _ctx_data != map._ctx_data:
            raise Error("mismatched context in map")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_set(self.data, map.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_set = print_set

    def print_basic_map(self, bmap):
        'print_basic_map(self, bmap)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param bmap: :class:`BasicMap`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(bmap, BasicMap):
            raise IslTypeError("bmap is not a BasicMap")
        if _ctx_data != bmap._ctx_data:
            raise Error("mismatched context in bmap")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_basic_map(self.data, bmap.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_basic_map = print_basic_map

    def print_map(self, map):
        'print_map(self, map)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param map: :class:`Map`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(map, BasicMap):
            map = Map.from_basic_map(map)
        if not isinstance(map, Map):
            raise IslTypeError("map is not a Map")
        if _ctx_data != map._ctx_data:
            raise Error("mismatched context in map")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_map(self.data, map.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_map = print_map

    def print_local_space(self, ls):
        'print_local_space(self, ls)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param ls: :class:`LocalSpace`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        if _ctx_data != ls._ctx_data:
            raise Error("mismatched context in ls")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_local_space(self.data, ls.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_local_space = print_local_space

    def print_aff(self, aff):
        'print_aff(self, aff)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param aff: :class:`Aff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(aff, Aff):
            raise IslTypeError("aff is not a Aff")
        if _ctx_data != aff._ctx_data:
            raise Error("mismatched context in aff")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_aff(self.data, aff.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_aff = print_aff

    def print_pw_aff(self, pwaff):
        'print_pw_aff(self, pwaff)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param pwaff: :class:`PwAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(pwaff, Aff):
            pwaff = PwAff.from_aff(pwaff)
        if not isinstance(pwaff, PwAff):
            raise IslTypeError("pwaff is not a PwAff")
        if _ctx_data != pwaff._ctx_data:
            raise Error("mismatched context in pwaff")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_pw_aff(self.data, pwaff.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_pw_aff = print_pw_aff

    def print_multi_aff(self, maff):
        'print_multi_aff(self, maff)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param maff: :class:`MultiAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(maff, MultiAff):
            raise IslTypeError("maff is not a MultiAff")
        if _ctx_data != maff._ctx_data:
            raise Error("mismatched context in maff")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_multi_aff(self.data, maff.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_multi_aff = print_multi_aff

    def print_pw_multi_aff(self, pma):
        'print_pw_multi_aff(self, pma)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param pma: :class:`PwMultiAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(pma, PwMultiAff):
            raise IslTypeError("pma is not a PwMultiAff")
        if _ctx_data != pma._ctx_data:
            raise Error("mismatched context in pma")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_pw_multi_aff(self.data, pma.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_pw_multi_aff = print_pw_multi_aff

    def print_union_pw_multi_aff(self, upma):
        'print_union_pw_multi_aff(self, upma)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param upma: :class:`UnionPwMultiAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(upma, UnionPwMultiAff):
            raise IslTypeError("upma is not a UnionPwMultiAff")
        if _ctx_data != upma._ctx_data:
            raise Error("mismatched context in upma")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_pw_multi_aff(self.data, upma.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_pw_multi_aff = print_union_pw_multi_aff

    def print_multi_pw_aff(self, mpa):
        'print_multi_pw_aff(self, mpa)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param mpa: :class:`MultiPwAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(mpa, MultiPwAff):
            raise IslTypeError("mpa is not a MultiPwAff")
        if _ctx_data != mpa._ctx_data:
            raise Error("mismatched context in mpa")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_multi_pw_aff(self.data, mpa.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_multi_pw_aff = print_multi_pw_aff

    def print_union_pw_aff(self, upa):
        'print_union_pw_aff(self, upa)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param upa: :class:`UnionPwAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(upa, UnionPwAff):
            raise IslTypeError("upa is not a UnionPwAff")
        if _ctx_data != upa._ctx_data:
            raise Error("mismatched context in upa")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_pw_aff(self.data, upa.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_pw_aff = print_union_pw_aff

    def print_multi_union_pw_aff(self, mupa):
        'print_multi_union_pw_aff(self, mupa)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param mupa: :class:`MultiUnionPwAff`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(mupa, MultiUnionPwAff):
            raise IslTypeError("mupa is not a MultiUnionPwAff")
        if _ctx_data != mupa._ctx_data:
            raise Error("mismatched context in mupa")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_multi_union_pw_aff(self.data, mupa.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_multi_union_pw_aff = print_multi_union_pw_aff

    def print_qpolynomial(self, qp):
        'print_qpolynomial(self, qp)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param qp: :class:`QPolynomial`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(qp, QPolynomial):
            raise IslTypeError("qp is not a QPolynomial")
        if _ctx_data != qp._ctx_data:
            raise Error("mismatched context in qp")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_qpolynomial(self.data, qp.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_qpolynomial = print_qpolynomial

    def print_pw_qpolynomial(self, pwqp):
        'print_pw_qpolynomial(self, pwqp)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param pwqp: :class:`PwQPolynomial`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(pwqp, PwQPolynomial):
            raise IslTypeError("pwqp is not a PwQPolynomial")
        if _ctx_data != pwqp._ctx_data:
            raise Error("mismatched context in pwqp")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_pw_qpolynomial(self.data, pwqp.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_pw_qpolynomial = print_pw_qpolynomial

    def print_qpolynomial_fold(self, fold):
        'print_qpolynomial_fold(self, fold)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param fold: :class:`QPolynomialFold`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(fold, QPolynomialFold):
            raise IslTypeError("fold is not a QPolynomialFold")
        if _ctx_data != fold._ctx_data:
            raise Error("mismatched context in fold")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_qpolynomial_fold(self.data, fold.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_qpolynomial_fold = print_qpolynomial_fold

    def print_pw_qpolynomial_fold(self, pwf):
        'print_pw_qpolynomial_fold(self, pwf)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param pwf: :class:`PwQPolynomialFold`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(pwf, PwQPolynomialFold):
            raise IslTypeError("pwf is not a PwQPolynomialFold")
        if _ctx_data != pwf._ctx_data:
            raise Error("mismatched context in pwf")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_pw_qpolynomial_fold(self.data, pwf.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_pw_qpolynomial_fold = print_pw_qpolynomial_fold

    def print_union_pw_qpolynomial(self, upwqp):
        'print_union_pw_qpolynomial(self, upwqp)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param upwqp: :class:`UnionPwQPolynomial`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(upwqp, UnionPwQPolynomial):
            raise IslTypeError("upwqp is not a UnionPwQPolynomial")
        if _ctx_data != upwqp._ctx_data:
            raise Error("mismatched context in upwqp")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_pw_qpolynomial(self.data, upwqp.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_pw_qpolynomial = print_union_pw_qpolynomial

    def print_union_pw_qpolynomial_fold(self, upwf):
        'print_union_pw_qpolynomial_fold(self, upwf)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param upwf: :class:`UnionPwQPolynomialFold`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(upwf, UnionPwQPolynomialFold):
            raise IslTypeError("upwf is not a UnionPwQPolynomialFold")
        if _ctx_data != upwf._ctx_data:
            raise Error("mismatched context in upwf")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_pw_qpolynomial_fold(self.data, upwf.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_pw_qpolynomial_fold = print_union_pw_qpolynomial_fold

    def print_union_map(self, umap):
        'print_union_map(self, umap)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param umap: :class:`UnionMap`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(umap, BasicMap):
            umap = Map.from_basic_map(umap)
        if isinstance(umap, Map):
            umap = UnionMap.from_map(umap)
        if not isinstance(umap, UnionMap):
            raise IslTypeError("umap is not a UnionMap")
        if _ctx_data != umap._ctx_data:
            raise Error("mismatched context in umap")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_map(self.data, umap.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_map = print_union_map

    def print_union_set(self, uset):
        'print_union_set(self, uset)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param uset: :class:`UnionSet`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(uset, BasicSet):
            uset = Set.from_basic_set(uset)
        if isinstance(uset, Set):
            uset = UnionSet.from_set(uset)
        if not isinstance(uset, UnionSet):
            raise IslTypeError("uset is not a UnionSet")
        if _ctx_data != uset._ctx_data:
            raise Error("mismatched context in uset")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_set(self.data, uset.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_set = print_union_set

    def to_str(ctx):
        'to_str(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Printer`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_to_str(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Printer(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_printer_to_str failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Printer.to_str = staticmethod(to_str)

    Printer._to_str_is_static = True

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`Printer`\n:return: :class:`Context`'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_printer_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Printer.get_ctx = get_ctx

    def get_str(self):
        'get_str(self)\n\n:param self: :class:`Printer`\n:return: string'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_get_str(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            libc.free(_result)
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Printer.get_str = get_str

    def set_indent(self, indent):
        'set_indent(self, indent)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param indent: :class:`int`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for indent
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_indent(self.data, indent)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_indent = set_indent

    def indent(self, indent):
        'indent(self, indent)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param indent: :class:`int`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for indent
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_indent(self.data, indent)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.indent = indent

    def set_output_format(self, output_format):
        'set_output_format(self, output_format)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param output_format: :class:`int`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for output_format
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_output_format(self.data, output_format)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_output_format = set_output_format

    def get_output_format(self):
        'get_output_format(self)\n\n:param self: :class:`Printer`\n:return: int'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_get_output_format(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Printer.get_output_format = get_output_format

    def set_yaml_style(self, yaml_style):
        'set_yaml_style(self, yaml_style)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param yaml_style: :class:`int`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for yaml_style
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_yaml_style(self.data, yaml_style)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_yaml_style = set_yaml_style

    def get_yaml_style(self):
        'get_yaml_style(self)\n\n:param self: :class:`Printer`\n:return: int'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_get_yaml_style(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Printer.get_yaml_style = get_yaml_style

    def set_indent_prefix(self, prefix):
        'set_indent_prefix(self, prefix)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param prefix: string\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        _cstr_prefix = ffi.new("char[]", prefix.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_indent_prefix(self.data, _cstr_prefix)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_indent_prefix = set_indent_prefix

    def set_prefix(self, prefix):
        'set_prefix(self, prefix)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param prefix: string\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        _cstr_prefix = ffi.new("char[]", prefix.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_prefix(self.data, _cstr_prefix)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_prefix = set_prefix

    def set_suffix(self, suffix):
        'set_suffix(self, suffix)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param suffix: string\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        _cstr_suffix = ffi.new("char[]", suffix.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_suffix(self.data, _cstr_suffix)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_suffix = set_suffix

    def set_isl_int_width(self, width):
        'set_isl_int_width(self, width)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param width: :class:`int`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for width
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_isl_int_width(self.data, width)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_isl_int_width = set_isl_int_width

    def has_note(self, id):
        'has_note(self, id)\n\n:param self: :class:`Printer`\n:param id: :class:`Id`\n:return: bool'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_has_note(self.data, id.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_printer_has_note\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Printer.has_note = has_note

    def get_note(self, id):
        'get_note(self, id)\n\n:param self: :class:`Printer`\n:param id: :class:`Id`\n:return: :class:`Id`'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_get_note(self.data, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Id(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_printer_get_note failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Printer.get_note = get_note

    def set_note(self, id, note):
        'set_note(self, id, note)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param id: :class:`Id`\n:param note: :class:`Id`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        
        if not isinstance(note, Id):
            raise IslTypeError("note is not a Id")
        if _ctx_data != note._ctx_data:
            raise Error("mismatched context in note")
        _copy_note = note._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_set_note(self.data, _copy_id._release(), _copy_note._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.set_note = set_note

    def start_line(self):
        'start_line(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_start_line(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.start_line = start_line

    def end_line(self):
        'end_line(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_end_line(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.end_line = end_line

    def print_double(self, d):
        'print_double(self, d)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param d: :class:`double`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for d
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_double(self.data, d)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_double = print_double

    def print_int(self, i):
        'print_int(self, i)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param i: :class:`int`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for i
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_int(self.data, i)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_int = print_int

    def print_str(self, s):
        'print_str(self, s)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param s: string\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        _cstr_s = ffi.new("char[]", s.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_str(self.data, _cstr_s)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_str = print_str

    def yaml_start_mapping(self):
        'yaml_start_mapping(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_yaml_start_mapping(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.yaml_start_mapping = yaml_start_mapping

    def yaml_end_mapping(self):
        'yaml_end_mapping(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_yaml_end_mapping(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.yaml_end_mapping = yaml_end_mapping

    def yaml_start_sequence(self):
        'yaml_start_sequence(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_yaml_start_sequence(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.yaml_start_sequence = yaml_start_sequence

    def yaml_end_sequence(self):
        'yaml_end_sequence(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_yaml_end_sequence(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.yaml_end_sequence = yaml_end_sequence

    def yaml_next(self):
        'yaml_next(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_yaml_next(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.yaml_next = yaml_next

    def flush(self):
        'flush(self)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_flush(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.flush = flush

    def print_point(self, pnt):
        'print_point(self, pnt)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param pnt: :class:`Point`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(pnt, Point):
            raise IslTypeError("pnt is not a Point")
        if _ctx_data != pnt._ctx_data:
            raise Error("mismatched context in pnt")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_point(self.data, pnt.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_point = print_point

    def print_constraint(self, c):
        'print_constraint(self, c)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param c: :class:`Constraint`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(c, Constraint):
            raise IslTypeError("c is not a Constraint")
        if _ctx_data != c._ctx_data:
            raise Error("mismatched context in c")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_constraint(self.data, c.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_constraint = print_constraint

    def print_val(self, v):
        'print_val(self, v)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param v: :class:`Val`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_val(self.data, _val_v.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_val = print_val

    def print_multi_val(self, mv):
        'print_multi_val(self, mv)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param mv: :class:`MultiVal`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(mv, MultiVal):
            raise IslTypeError("mv is not a MultiVal")
        if _ctx_data != mv._ctx_data:
            raise Error("mismatched context in mv")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_multi_val(self.data, mv.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_multi_val = print_multi_val

    def print_vec(self, vec):
        'print_vec(self, vec)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param vec: :class:`Vec`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(vec, Vec):
            raise IslTypeError("vec is not a Vec")
        if _ctx_data != vec._ctx_data:
            raise Error("mismatched context in vec")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_vec(self.data, vec.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_vec = print_vec

    def print_schedule_constraints(self, sc):
        'print_schedule_constraints(self, sc)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param sc: :class:`ScheduleConstraints`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(sc, ScheduleConstraints):
            raise IslTypeError("sc is not a ScheduleConstraints")
        if _ctx_data != sc._ctx_data:
            raise Error("mismatched context in sc")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_schedule_constraints(self.data, sc.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_schedule_constraints = print_schedule_constraints

    def print_schedule(self, schedule):
        'print_schedule(self, schedule)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param schedule: :class:`Schedule`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(schedule, Schedule):
            raise IslTypeError("schedule is not a Schedule")
        if _ctx_data != schedule._ctx_data:
            raise Error("mismatched context in schedule")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_schedule(self.data, schedule.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_schedule = print_schedule

    def print_schedule_node(self, node):
        'print_schedule_node(self, node)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param node: :class:`ScheduleNode`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(node, ScheduleNode):
            raise IslTypeError("node is not a ScheduleNode")
        if _ctx_data != node._ctx_data:
            raise Error("mismatched context in node")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_schedule_node(self.data, node.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_schedule_node = print_schedule_node

    def print_union_access_info(self, access):
        'print_union_access_info(self, access)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param access: :class:`UnionAccessInfo`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(access, UnionAccessInfo):
            raise IslTypeError("access is not a UnionAccessInfo")
        if _ctx_data != access._ctx_data:
            raise Error("mismatched context in access")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_access_info(self.data, access.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_access_info = print_union_access_info

    def print_union_flow(self, flow):
        'print_union_flow(self, flow)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param flow: :class:`UnionFlow`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(flow, UnionFlow):
            raise IslTypeError("flow is not a UnionFlow")
        if _ctx_data != flow._ctx_data:
            raise Error("mismatched context in flow")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_flow(self.data, flow.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_flow = print_union_flow

    def print_ast_expr(self, expr):
        'print_ast_expr(self, expr)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param expr: :class:`AstExpr`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(expr, AstExpr):
            raise IslTypeError("expr is not a AstExpr")
        if _ctx_data != expr._ctx_data:
            raise Error("mismatched context in expr")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_ast_expr(self.data, expr.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_ast_expr = print_ast_expr

    def print_ast_node(self, node):
        'print_ast_node(self, node)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param node: :class:`AstNode`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(node, AstNode):
            raise IslTypeError("node is not a AstNode")
        if _ctx_data != node._ctx_data:
            raise Error("mismatched context in node")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_ast_node(self.data, node.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_ast_node = print_ast_node

    def ast_op_type_set_print_name(self, type, name):
        'ast_op_type_set_print_name(self, type, name)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param type: :class:`ast_op_type`\n:param name: string\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        _cstr_name = ffi.new("char[]", name.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_ast_op_type_set_print_name(self.data, type, _cstr_name)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.ast_op_type_set_print_name = ast_op_type_set_print_name

    def print_id_list(self, list):
        'print_id_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`IdList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, IdList):
            raise IslTypeError("list is not a IdList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_id_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_id_list = print_id_list

    def print_val_list(self, list):
        'print_val_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`ValList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, ValList):
            raise IslTypeError("list is not a ValList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_val_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_val_list = print_val_list

    def print_aff_list(self, list):
        'print_aff_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`AffList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, AffList):
            raise IslTypeError("list is not a AffList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_aff_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_aff_list = print_aff_list

    def print_pw_aff_list(self, list):
        'print_pw_aff_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`PwAffList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, PwAffList):
            raise IslTypeError("list is not a PwAffList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_pw_aff_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_pw_aff_list = print_pw_aff_list

    def print_constraint_list(self, list):
        'print_constraint_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`ConstraintList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, ConstraintList):
            raise IslTypeError("list is not a ConstraintList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_constraint_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_constraint_list = print_constraint_list

    def print_basic_set_list(self, list):
        'print_basic_set_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`BasicSetList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, BasicSetList):
            raise IslTypeError("list is not a BasicSetList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_basic_set_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_basic_set_list = print_basic_set_list

    def print_basic_map_list(self, list):
        'print_basic_map_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`BasicMapList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, BasicMapList):
            raise IslTypeError("list is not a BasicMapList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_basic_map_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_basic_map_list = print_basic_map_list

    def print_set_list(self, list):
        'print_set_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`SetList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, SetList):
            raise IslTypeError("list is not a SetList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_set_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_set_list = print_set_list

    def print_map_list(self, list):
        'print_map_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`MapList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, MapList):
            raise IslTypeError("list is not a MapList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_map_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_map_list = print_map_list

    def print_union_set_list(self, list):
        'print_union_set_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`UnionSetList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, UnionSetList):
            raise IslTypeError("list is not a UnionSetList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_union_set_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_union_set_list = print_union_set_list

    def print_ast_expr_list(self, list):
        'print_ast_expr_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`AstExprList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, AstExprList):
            raise IslTypeError("list is not a AstExprList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_ast_expr_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_ast_expr_list = print_ast_expr_list

    def print_ast_node_list(self, list):
        'print_ast_node_list(self, list)\n\n:param self: :class:`Printer` (:ref:`becomes invalid <auto-invalidation>`)\n:param list: :class:`AstNodeList`\n:return: :class:`Printer` (self)'

        if not isinstance(self, Printer):
            raise IslTypeError("self is not a Printer")
        _ctx_data = self._ctx_data
        
        if not isinstance(list, AstNodeList):
            raise IslTypeError("list is not a AstNodeList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_printer_print_ast_node_list(self.data, list.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            self._reset(_result)
            pass
        
        return self

    Printer.print_ast_node_list = print_ast_node_list

    # }}}

    # {{{ val

    def zero(ctx):
        'zero(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_zero(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_zero failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.zero = staticmethod(zero)

    Val._zero_is_static = True

    def one(ctx):
        'one(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_one(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_one failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.one = staticmethod(one)

    Val._one_is_static = True

    def negone(ctx):
        'negone(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_negone(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_negone failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.negone = staticmethod(negone)

    Val._negone_is_static = True

    def nan(ctx):
        'nan(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_nan(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_nan failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.nan = staticmethod(nan)

    Val._nan_is_static = True

    def infty(ctx):
        'infty(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_infty(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_infty failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.infty = staticmethod(infty)

    Val._infty_is_static = True

    def neginfty(ctx):
        'neginfty(ctx)\n\n:param ctx: :class:`Context`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_neginfty(ctx.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_neginfty failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.neginfty = staticmethod(neginfty)

    Val._neginfty_is_static = True

    def int_from_si(ctx, i):
        'int_from_si(ctx, i)\n\n:param ctx: :class:`Context`\n:param i: :class:`long`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for i
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_int_from_si(ctx.data, i)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_int_from_si failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.int_from_si = staticmethod(int_from_si)

    Val._int_from_si_is_static = True

    def int_from_ui(ctx, u):
        'int_from_ui(ctx, u)\n\n:param ctx: :class:`Context`\n:param u: :class:`long`\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for u
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_int_from_ui(ctx.data, u)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_int_from_ui failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.int_from_ui = staticmethod(int_from_ui)

    Val._int_from_ui_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.copy = copy

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`Val`\n:return: :class:`Context`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.get_ctx = get_ctx

    def get_hash(self):
        'get_hash(self)\n\n:param self: :class:`Val`\n:return: uint32_t'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_get_hash(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Val.get_hash = get_hash

    def get_num_si(self):
        'get_num_si(self)\n\n:param self: :class:`Val`\n:return: long'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_get_num_si(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Val.get_num_si = get_num_si

    def get_den_val(self):
        'get_den_val(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_get_den_val(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_get_den_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.get_den_val = get_den_val

    def get_d(self):
        'get_d(self)\n\n:param self: :class:`Val`\n:return: double'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_get_d(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Val.get_d = get_d

    def n_abs_num_chunks(self, size):
        'n_abs_num_chunks(self, size)\n\n:param self: :class:`Val`\n:param size: :class:`size_t`\n:return: size_t'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        # no argument processing for size
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_n_abs_num_chunks(self.data, size)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Val.n_abs_num_chunks = n_abs_num_chunks

    def set_si(self, i):
        'set_si(self, i)\n\n:param self: :class:`Val`\n:param i: :class:`long`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for i
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_set_si(_copy_self._release(), i)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_set_si failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.set_si = set_si

    def abs(self):
        'abs(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_abs(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_abs failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.abs = abs

    def neg(self):
        'neg(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_neg(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_neg failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.neg = neg

    def inv(self):
        'inv(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_inv(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_inv failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.inv = inv

    def floor(self):
        'floor(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_floor(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_floor failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.floor = floor

    def ceil(self):
        'ceil(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_ceil(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_ceil failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.ceil = ceil

    def trunc(self):
        'trunc(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_trunc(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_trunc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.trunc = trunc

    def two_exp(self):
        'two_exp(self)\n\n:param self: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_2exp(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_2exp failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.two_exp = two_exp

    def min(self, v2):
        'min(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_min(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_min failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.min = min

    def max(self, v2):
        'max(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_max(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_max failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.max = max

    def add(self, v2):
        'add(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_add(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.add = add

    def sub(self, v2):
        'sub(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_sub(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_sub failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.sub = sub

    def mul(self, v2):
        'mul(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_mul(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_mul failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.mul = mul

    def div(self, v2):
        'div(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_div(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_div failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.div = div

    def mod(self, v2):
        'mod(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_mod(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_mod failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.mod = mod

    def gcd(self, v2):
        'gcd(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: :class:`Val`'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_gcd(_copy_self._release(), _val_v2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_gcd failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.gcd = gcd

    def gcdext(self, v2):
        'gcdext(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: (:class:`Val`, x (:class:`Val`), y (:class:`Val`))'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        
        _retptr_x = ffi.new("isl_val **")
        
        _retptr_y = ffi.new("isl_val **")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_gcdext(_copy_self._release(), _val_v2._release(), _retptr_x, _retptr_y)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _retptr_x == ffi.NULL:
                _ret_x = None
            else:
                _ret_x = Val(_data=_retptr_x[0])
            if _retptr_y == ffi.NULL:
                _ret_y = None
            else:
                _ret_y = Val(_data=_retptr_y[0])
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_gcdext failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result, _ret_x, _ret_y

    Val.gcdext = gcdext

    def sgn(self):
        'sgn(self)\n\n:param self: :class:`Val`\n:return: int'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_sgn(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Val.sgn = sgn

    def is_zero(self):
        'is_zero(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_zero(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_zero\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_zero = is_zero

    def is_one(self):
        'is_one(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_one(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_one\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_one = is_one

    def is_negone(self):
        'is_negone(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_negone(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_negone\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_negone = is_negone

    def is_nonneg(self):
        'is_nonneg(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_nonneg(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_nonneg\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_nonneg = is_nonneg

    def is_nonpos(self):
        'is_nonpos(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_nonpos(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_nonpos\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_nonpos = is_nonpos

    def is_pos(self):
        'is_pos(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_pos(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_pos\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_pos = is_pos

    def is_neg(self):
        'is_neg(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_neg(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_neg\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_neg = is_neg

    def is_int(self):
        'is_int(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_int(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_int\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_int = is_int

    def is_rat(self):
        'is_rat(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_rat(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_rat\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_rat = is_rat

    def is_nan(self):
        'is_nan(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_nan(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_nan\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_nan = is_nan

    def is_infty(self):
        'is_infty(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_infty(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_infty\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_infty = is_infty

    def is_neginfty(self):
        'is_neginfty(self)\n\n:param self: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_neginfty(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_neginfty\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_neginfty = is_neginfty

    def cmp_si(self, i):
        'cmp_si(self, i)\n\n:param self: :class:`Val`\n:param i: :class:`long`\n:return: int'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        # no argument processing for i
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_cmp_si(self.data, i)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Val.cmp_si = cmp_si

    def lt(self, v2):
        'lt(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_lt(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_lt\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.lt = lt

    def le(self, v2):
        'le(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_le(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_le\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.le = le

    def gt(self, v2):
        'gt(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_gt(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_gt\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.gt = gt

    def ge(self, v2):
        'ge(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_ge(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_ge\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.ge = ge

    def eq(self, v2):
        'eq(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_eq(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_eq\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.eq = eq

    def ne(self, v2):
        'ne(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_ne(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_ne\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.ne = ne

    def abs_eq(self, v2):
        'abs_eq(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_abs_eq(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_abs_eq\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.abs_eq = abs_eq

    def is_divisible_by(self, v2):
        'is_divisible_by(self, v2)\n\n:param self: :class:`Val`\n:param v2: :class:`Val`\n:return: bool'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        
        if isinstance(v2, Val):
            if _ctx_data != v2._ctx_data:
                raise Error("mismatched context in v2")
            _val_v2 = v2._copy()
        elif isinstance(v2, six.integer_types):
            _cdata_v2 = lib.isl_val_int_from_si(
                self._get_ctx_data(), v2)
        
            if _cdata_v2 == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v2 = Val(_data=_cdata_v2)
        
        else:
            raise IslTypeError("v2 is a %s and cannot "
                "be cast to a Val" % type(v2))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_is_divisible_by(self.data, _val_v2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_val_is_divisible_by\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Val.is_divisible_by = is_divisible_by

    def read_from_str(ctx, str):
        'read_from_str(ctx, str)\n\n:param ctx: :class:`Context`\n:param str: string\n:return: :class:`Val`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        _cstr_str = ffi.new("char[]", str.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_read_from_str(ctx.data, _cstr_str)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_val_read_from_str failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Val.read_from_str = staticmethod(read_from_str)

    Val._read_from_str_is_static = True

    def dump(self):
        'dump(self)\n\n:param self: :class:`Val`\n:return: (nothing)'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_dump(self.data)
        finally:
            pass
        

    Val.dump = dump

    def to_str(self):
        'to_str(self)\n\n:param self: :class:`Val`\n:return: string'

        if not isinstance(self, Val):
            raise IslTypeError("self is not a Val")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_val_to_str(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            libc.free(_result)
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Val.to_str = to_str

    # }}}

    # {{{ multi_val

    def add_val(self, v):
        'add_val(self, v)\n\n:param self: :class:`MultiVal`\n:param v: :class:`Val`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_add_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_add_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.add_val = add_val

    def mod_val(self, v):
        'mod_val(self, v)\n\n:param self: :class:`MultiVal`\n:param v: :class:`Val`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_mod_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_mod_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.mod_val = mod_val

    def read_from_str(ctx, str):
        'read_from_str(ctx, str)\n\n:param ctx: :class:`Context`\n:param str: string\n:return: :class:`MultiVal`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        _cstr_str = ffi.new("char[]", str.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_read_from_str(ctx.data, _cstr_str)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_read_from_str failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.read_from_str = staticmethod(read_from_str)

    MultiVal._read_from_str_is_static = True

    def dump(self):
        'dump(self)\n\n:param self: :class:`MultiVal`\n:return: (nothing)'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_dump(self.data)
        finally:
            pass
        

    MultiVal.dump = dump

    def to_str(self):
        'to_str(self)\n\n:param self: :class:`MultiVal`\n:return: string'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_to_str(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            libc.free(_result)
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    MultiVal.to_str = to_str

    def dim(self, type):
        'dim(self, type)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:return: unsigned'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_dim(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    MultiVal.dim = dim

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`Context`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.get_ctx = get_ctx

    def get_space(self):
        'get_space(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`Space`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_get_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.get_space = get_space

    def get_domain_space(self):
        'get_domain_space(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`Space`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_domain_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_get_domain_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.get_domain_space = get_domain_space

    def find_dim_by_name(self, type, name):
        'find_dim_by_name(self, type, name)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param name: string\n:return: int'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        _cstr_name = ffi.new("char[]", name.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_find_dim_by_name(self.data, type, _cstr_name)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    MultiVal.find_dim_by_name = find_dim_by_name

    def from_val_list(space, list):
        'from_val_list(space, list)\n\n:param space: :class:`Space`\n:param list: :class:`ValList`\n:return: :class:`MultiVal`'

        if not isinstance(space, Space):
            raise IslTypeError("space is not a Space")
        _ctx_data = space._ctx_data
        _copy_space = space._copy()
        
        if not isinstance(list, ValList):
            raise IslTypeError("list is not a ValList")
        if _ctx_data != list._ctx_data:
            raise Error("mismatched context in list")
        _copy_list = list._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_from_val_list(_copy_space._release(), _copy_list._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_from_val_list failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.from_val_list = staticmethod(from_val_list)

    MultiVal._from_val_list_is_static = True

    def zero(space):
        'zero(space)\n\n:param space: :class:`Space`\n:return: :class:`MultiVal`'

        if not isinstance(space, Space):
            raise IslTypeError("space is not a Space")
        _ctx_data = space._ctx_data
        _copy_space = space._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_zero(_copy_space._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_zero failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.zero = staticmethod(zero)

    MultiVal._zero_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.copy = copy

    def plain_is_equal(self, multi2):
        'plain_is_equal(self, multi2)\n\n:param self: :class:`MultiVal`\n:param multi2: :class:`MultiVal`\n:return: bool'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        if not isinstance(multi2, MultiVal):
            raise IslTypeError("multi2 is not a MultiVal")
        if _ctx_data != multi2._ctx_data:
            raise Error("mismatched context in multi2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_plain_is_equal(self.data, multi2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_multi_val_plain_is_equal\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    MultiVal.plain_is_equal = plain_is_equal

    def involves_nan(self):
        'involves_nan(self)\n\n:param self: :class:`MultiVal`\n:return: bool'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_involves_nan(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_multi_val_involves_nan\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    MultiVal.involves_nan = involves_nan

    def find_dim_by_id(self, type, id):
        'find_dim_by_id(self, type, id)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param id: :class:`Id`\n:return: int'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_find_dim_by_id(self.data, type, id.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    MultiVal.find_dim_by_id = find_dim_by_id

    def get_dim_id(self, type, pos):
        'get_dim_id(self, type, pos)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: :class:`Id`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_dim_id(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Id(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_get_dim_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.get_dim_id = get_dim_id

    def set_dim_name(self, type, pos, s):
        'set_dim_name(self, type, pos, s)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:param s: string\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        _cstr_s = ffi.new("char[]", s.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_set_dim_name(_copy_self._release(), type, pos, _cstr_s)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_set_dim_name failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.set_dim_name = set_dim_name

    def set_dim_id(self, type, pos, id):
        'set_dim_id(self, type, pos, id)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:param id: :class:`Id`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_set_dim_id(_copy_self._release(), type, pos, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_set_dim_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.set_dim_id = set_dim_id

    def get_tuple_name(self, type):
        'get_tuple_name(self, type)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:return: string'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_tuple_name(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    MultiVal.get_tuple_name = get_tuple_name

    def has_tuple_id(self, type):
        'has_tuple_id(self, type)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:return: bool'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_has_tuple_id(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_multi_val_has_tuple_id\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    MultiVal.has_tuple_id = has_tuple_id

    def get_tuple_id(self, type):
        'get_tuple_id(self, type)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:return: :class:`Id`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_tuple_id(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Id(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_get_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.get_tuple_id = get_tuple_id

    def set_tuple_name(self, type, s):
        'set_tuple_name(self, type, s)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param s: string\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        _cstr_s = ffi.new("char[]", s.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_set_tuple_name(_copy_self._release(), type, _cstr_s)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_set_tuple_name failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.set_tuple_name = set_tuple_name

    def set_tuple_id(self, type, id):
        'set_tuple_id(self, type, id)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param id: :class:`Id`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_set_tuple_id(_copy_self._release(), type, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_set_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.set_tuple_id = set_tuple_id

    def reset_tuple_id(self, type):
        'reset_tuple_id(self, type)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_reset_tuple_id(_copy_self._release(), type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_reset_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.reset_tuple_id = reset_tuple_id

    def reset_user(self):
        'reset_user(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_reset_user(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_reset_user failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.reset_user = reset_user

    def drop_dims(self, type, first, n):
        'drop_dims(self, type, first, n)\n\n:param self: :class:`MultiVal`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_drop_dims(_copy_self._release(), type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_drop_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.drop_dims = drop_dims

    def get_val(self, pos):
        'get_val(self, pos)\n\n:param self: :class:`MultiVal`\n:param pos: :class:`int`\n:return: :class:`Val`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_get_val(self.data, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_get_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.get_val = get_val

    def set_val(self, pos, el):
        'set_val(self, pos, el)\n\n:param self: :class:`MultiVal`\n:param pos: :class:`int`\n:param el: :class:`Val`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(el, Val):
            if _ctx_data != el._ctx_data:
                raise Error("mismatched context in el")
            _val_el = el._copy()
        elif isinstance(el, six.integer_types):
            _cdata_el = lib.isl_val_int_from_si(
                self._get_ctx_data(), el)
        
            if _cdata_el == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_el = Val(_data=_cdata_el)
        
        else:
            raise IslTypeError("el is a %s and cannot "
                "be cast to a Val" % type(el))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_set_val(_copy_self._release(), pos, _val_el._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_set_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.set_val = set_val

    def range_splice(self, pos, multi2):
        'range_splice(self, pos, multi2)\n\n:param self: :class:`MultiVal`\n:param pos: :class:`unsigned`\n:param multi2: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if not isinstance(multi2, MultiVal):
            raise IslTypeError("multi2 is not a MultiVal")
        if _ctx_data != multi2._ctx_data:
            raise Error("mismatched context in multi2")
        _copy_multi2 = multi2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_range_splice(_copy_self._release(), pos, _copy_multi2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_range_splice failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.range_splice = range_splice

    def flatten_range(self):
        'flatten_range(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_flatten_range(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_flatten_range failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.flatten_range = flatten_range

    def flat_range_product(self, multi2):
        'flat_range_product(self, multi2)\n\n:param self: :class:`MultiVal`\n:param multi2: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(multi2, MultiVal):
            raise IslTypeError("multi2 is not a MultiVal")
        if _ctx_data != multi2._ctx_data:
            raise Error("mismatched context in multi2")
        _copy_multi2 = multi2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_flat_range_product(_copy_self._release(), _copy_multi2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_flat_range_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.flat_range_product = flat_range_product

    def range_product(self, multi2):
        'range_product(self, multi2)\n\n:param self: :class:`MultiVal`\n:param multi2: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(multi2, MultiVal):
            raise IslTypeError("multi2 is not a MultiVal")
        if _ctx_data != multi2._ctx_data:
            raise Error("mismatched context in multi2")
        _copy_multi2 = multi2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_range_product(_copy_self._release(), _copy_multi2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_range_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.range_product = range_product

    def factor_range(self):
        'factor_range(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_factor_range(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_factor_range failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.factor_range = factor_range

    def range_is_wrapping(self):
        'range_is_wrapping(self)\n\n:param self: :class:`MultiVal`\n:return: bool'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_range_is_wrapping(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_multi_val_range_is_wrapping\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    MultiVal.range_is_wrapping = range_is_wrapping

    def range_factor_domain(self):
        'range_factor_domain(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_range_factor_domain(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_range_factor_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.range_factor_domain = range_factor_domain

    def range_factor_range(self):
        'range_factor_range(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_range_factor_range(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_range_factor_range failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.range_factor_range = range_factor_range

    def scale_val(self, v):
        'scale_val(self, v)\n\n:param self: :class:`MultiVal`\n:param v: :class:`Val`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_scale_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_scale_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.scale_val = scale_val

    def scale_down_val(self, v):
        'scale_down_val(self, v)\n\n:param self: :class:`MultiVal`\n:param v: :class:`Val`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_scale_down_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_scale_down_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.scale_down_val = scale_down_val

    def scale_multi_val(self, mv):
        'scale_multi_val(self, mv)\n\n:param self: :class:`MultiVal`\n:param mv: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mv, MultiVal):
            raise IslTypeError("mv is not a MultiVal")
        if _ctx_data != mv._ctx_data:
            raise Error("mismatched context in mv")
        _copy_mv = mv._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_scale_multi_val(_copy_self._release(), _copy_mv._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_scale_multi_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.scale_multi_val = scale_multi_val

    def scale_down_multi_val(self, mv):
        'scale_down_multi_val(self, mv)\n\n:param self: :class:`MultiVal`\n:param mv: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mv, MultiVal):
            raise IslTypeError("mv is not a MultiVal")
        if _ctx_data != mv._ctx_data:
            raise Error("mismatched context in mv")
        _copy_mv = mv._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_scale_down_multi_val(_copy_self._release(), _copy_mv._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_scale_down_multi_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.scale_down_multi_val = scale_down_multi_val

    def mod_multi_val(self, mv):
        'mod_multi_val(self, mv)\n\n:param self: :class:`MultiVal`\n:param mv: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mv, MultiVal):
            raise IslTypeError("mv is not a MultiVal")
        if _ctx_data != mv._ctx_data:
            raise Error("mismatched context in mv")
        _copy_mv = mv._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_mod_multi_val(_copy_self._release(), _copy_mv._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_mod_multi_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.mod_multi_val = mod_multi_val

    def add(self, multi2):
        'add(self, multi2)\n\n:param self: :class:`MultiVal`\n:param multi2: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(multi2, MultiVal):
            raise IslTypeError("multi2 is not a MultiVal")
        if _ctx_data != multi2._ctx_data:
            raise Error("mismatched context in multi2")
        _copy_multi2 = multi2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_add(_copy_self._release(), _copy_multi2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.add = add

    def sub(self, multi2):
        'sub(self, multi2)\n\n:param self: :class:`MultiVal`\n:param multi2: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(multi2, MultiVal):
            raise IslTypeError("multi2 is not a MultiVal")
        if _ctx_data != multi2._ctx_data:
            raise Error("mismatched context in multi2")
        _copy_multi2 = multi2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_sub(_copy_self._release(), _copy_multi2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_sub failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.sub = sub

    def align_params(self, model):
        'align_params(self, model)\n\n:param self: :class:`MultiVal`\n:param model: :class:`Space`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(model, Space):
            raise IslTypeError("model is not a Space")
        if _ctx_data != model._ctx_data:
            raise Error("mismatched context in model")
        _copy_model = model._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_align_params(_copy_self._release(), _copy_model._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_align_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.align_params = align_params

    def from_range(self):
        'from_range(self)\n\n:param self: :class:`MultiVal`\n:return: :class:`MultiVal`'

        if not isinstance(self, MultiVal):
            raise IslTypeError("self is not a MultiVal")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_multi_val_from_range(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else MultiVal(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_multi_val_from_range failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    MultiVal.from_range = from_range

    # }}}

    # {{{ vec

    def alloc(ctx, size):
        'alloc(ctx, size)\n\n:param ctx: :class:`Context`\n:param size: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for size
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_alloc(ctx.data, size)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.alloc = staticmethod(alloc)

    Vec._alloc_is_static = True

    def zero(ctx, size):
        'zero(ctx, size)\n\n:param ctx: :class:`Context`\n:param size: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for size
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_zero(ctx.data, size)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_zero failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.zero = staticmethod(zero)

    Vec._zero_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.copy = copy

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`Vec`\n:return: :class:`Context`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.get_ctx = get_ctx

    def size(self):
        'size(self)\n\n:param self: :class:`Vec`\n:return: int'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_size(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Vec.__len__ = size

    def get_element_val(self, pos):
        'get_element_val(self, pos)\n\n:param self: :class:`Vec`\n:param pos: :class:`int`\n:return: :class:`Val`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_get_element_val(self.data, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_get_element_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.get_element_val = get_element_val

    def set_element_val(self, pos, v):
        'set_element_val(self, pos, v)\n\n:param self: :class:`Vec`\n:param pos: :class:`int`\n:param v: :class:`Val`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_set_element_val(_copy_self._release(), pos, _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_set_element_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.set_element_val = set_element_val

    def is_equal(self, vec2):
        'is_equal(self, vec2)\n\n:param self: :class:`Vec`\n:param vec2: :class:`Vec`\n:return: bool'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        
        if not isinstance(vec2, Vec):
            raise IslTypeError("vec2 is not a Vec")
        if _ctx_data != vec2._ctx_data:
            raise Error("mismatched context in vec2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_is_equal(self.data, vec2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_vec_is_equal\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Vec.is_equal = is_equal

    def cmp_element(self, vec2, pos):
        'cmp_element(self, vec2, pos)\n\n:param self: :class:`Vec`\n:param vec2: :class:`Vec`\n:param pos: :class:`int`\n:return: int'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        
        if not isinstance(vec2, Vec):
            raise IslTypeError("vec2 is not a Vec")
        if _ctx_data != vec2._ctx_data:
            raise Error("mismatched context in vec2")
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_cmp_element(self.data, vec2.data, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Vec.cmp_element = cmp_element

    def dump(self):
        'dump(self)\n\n:param self: :class:`Vec`\n:return: (nothing)'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_dump(self.data)
        finally:
            pass
        

    Vec.dump = dump

    def ceil(self):
        'ceil(self)\n\n:param self: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_ceil(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_ceil failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.ceil = ceil

    def set_val(self, v):
        'set_val(self, v)\n\n:param self: :class:`Vec`\n:param v: :class:`Val`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_set_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_set_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.set_val = set_val

    def clr(self):
        'clr(self)\n\n:param self: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_clr(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_clr failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.clr = clr

    def neg(self):
        'neg(self)\n\n:param self: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_neg(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_neg failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.neg = neg

    def add(self, vec2):
        'add(self, vec2)\n\n:param self: :class:`Vec`\n:param vec2: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(vec2, Vec):
            raise IslTypeError("vec2 is not a Vec")
        if _ctx_data != vec2._ctx_data:
            raise Error("mismatched context in vec2")
        _copy_vec2 = vec2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_add(_copy_self._release(), _copy_vec2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.add = add

    def extend(self, size):
        'extend(self, size)\n\n:param self: :class:`Vec`\n:param size: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for size
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_extend(_copy_self._release(), size)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_extend failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.extend = extend

    def zero_extend(self, size):
        'zero_extend(self, size)\n\n:param self: :class:`Vec`\n:param size: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for size
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_zero_extend(_copy_self._release(), size)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_zero_extend failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.zero_extend = zero_extend

    def concat(self, vec2):
        'concat(self, vec2)\n\n:param self: :class:`Vec`\n:param vec2: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(vec2, Vec):
            raise IslTypeError("vec2 is not a Vec")
        if _ctx_data != vec2._ctx_data:
            raise Error("mismatched context in vec2")
        _copy_vec2 = vec2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_concat(_copy_self._release(), _copy_vec2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.concat = concat

    def sort(self):
        'sort(self)\n\n:param self: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_sort(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_sort failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.sort = sort

    def drop_els(self, pos, n):
        'drop_els(self, pos, n)\n\n:param self: :class:`Vec`\n:param pos: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_drop_els(_copy_self._release(), pos, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_drop_els failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.drop_els = drop_els

    def add_els(self, n):
        'add_els(self, n)\n\n:param self: :class:`Vec`\n:param n: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_add_els(_copy_self._release(), n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_add_els failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.add_els = add_els

    def insert_els(self, pos, n):
        'insert_els(self, pos, n)\n\n:param self: :class:`Vec`\n:param pos: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_insert_els(_copy_self._release(), pos, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_insert_els failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.insert_els = insert_els

    def insert_zero_els(self, pos, n):
        'insert_zero_els(self, pos, n)\n\n:param self: :class:`Vec`\n:param pos: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for pos
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_insert_zero_els(_copy_self._release(), pos, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_insert_zero_els failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.insert_zero_els = insert_zero_els

    def move_els(self, dst_col, src_col, n):
        'move_els(self, dst_col, src_col, n)\n\n:param self: :class:`Vec`\n:param dst_col: :class:`unsigned`\n:param src_col: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for dst_col
        
        # no argument processing for src_col
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_move_els(_copy_self._release(), dst_col, src_col, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_move_els failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.move_els = move_els

    def mat_product(self, mat):
        'mat_product(self, mat)\n\n:param self: :class:`Vec`\n:param mat: :class:`Mat`\n:return: :class:`Vec`'

        if not isinstance(self, Vec):
            raise IslTypeError("self is not a Vec")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mat, Mat):
            raise IslTypeError("mat is not a Mat")
        if _ctx_data != mat._ctx_data:
            raise Error("mismatched context in mat")
        _copy_mat = mat._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_vec_mat_product(_copy_self._release(), _copy_mat._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_vec_mat_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Vec.mat_product = mat_product

    # }}}

    # {{{ mat

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`Mat`\n:return: :class:`Context`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.get_ctx = get_ctx

    def alloc(ctx, n_row, n_col):
        'alloc(ctx, n_row, n_col)\n\n:param ctx: :class:`Context`\n:param n_row: :class:`unsigned`\n:param n_col: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        # no argument processing for n_row
        
        # no argument processing for n_col
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_alloc(ctx.data, n_row, n_col)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.alloc = staticmethod(alloc)

    Mat._alloc_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.copy = copy

    def rows(self):
        'rows(self)\n\n:param self: :class:`Mat`\n:return: int'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_rows(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Mat.rows = rows

    def cols(self):
        'cols(self)\n\n:param self: :class:`Mat`\n:return: int'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_cols(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Mat.cols = cols

    def get_element_val(self, row, col):
        'get_element_val(self, row, col)\n\n:param self: :class:`Mat`\n:param row: :class:`int`\n:param col: :class:`int`\n:return: :class:`Val`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        
        # no argument processing for row
        
        # no argument processing for col
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_get_element_val(self.data, row, col)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_get_element_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.get_element_val = get_element_val

    def set_element_val(self, row, col, v):
        'set_element_val(self, row, col, v)\n\n:param self: :class:`Mat`\n:param row: :class:`int`\n:param col: :class:`int`\n:param v: :class:`Val`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for row
        
        # no argument processing for col
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_set_element_val(_copy_self._release(), row, col, _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_set_element_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.set_element_val = set_element_val

    def swap_cols(self, i, j):
        'swap_cols(self, i, j)\n\n:param self: :class:`Mat`\n:param i: :class:`unsigned`\n:param j: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for i
        
        # no argument processing for j
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_swap_cols(_copy_self._release(), i, j)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_swap_cols failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.swap_cols = swap_cols

    def swap_rows(self, i, j):
        'swap_rows(self, i, j)\n\n:param self: :class:`Mat`\n:param i: :class:`unsigned`\n:param j: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for i
        
        # no argument processing for j
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_swap_rows(_copy_self._release(), i, j)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_swap_rows failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.swap_rows = swap_rows

    def vec_product(self, vec):
        'vec_product(self, vec)\n\n:param self: :class:`Mat`\n:param vec: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(vec, Vec):
            raise IslTypeError("vec is not a Vec")
        if _ctx_data != vec._ctx_data:
            raise Error("mismatched context in vec")
        _copy_vec = vec._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_vec_product(_copy_self._release(), _copy_vec._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_vec_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.vec_product = vec_product

    def vec_inverse_product(self, vec):
        'vec_inverse_product(self, vec)\n\n:param self: :class:`Mat`\n:param vec: :class:`Vec`\n:return: :class:`Vec`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(vec, Vec):
            raise IslTypeError("vec is not a Vec")
        if _ctx_data != vec._ctx_data:
            raise Error("mismatched context in vec")
        _copy_vec = vec._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_vec_inverse_product(_copy_self._release(), _copy_vec._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Vec(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_vec_inverse_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.vec_inverse_product = vec_inverse_product

    def aff_direct_sum(self, right):
        'aff_direct_sum(self, right)\n\n:param self: :class:`Mat`\n:param right: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(right, Mat):
            raise IslTypeError("right is not a Mat")
        if _ctx_data != right._ctx_data:
            raise Error("mismatched context in right")
        _copy_right = right._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_aff_direct_sum(_copy_self._release(), _copy_right._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_aff_direct_sum failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.aff_direct_sum = aff_direct_sum

    def diagonal(self, mat2):
        'diagonal(self, mat2)\n\n:param self: :class:`Mat`\n:param mat2: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mat2, Mat):
            raise IslTypeError("mat2 is not a Mat")
        if _ctx_data != mat2._ctx_data:
            raise Error("mismatched context in mat2")
        _copy_mat2 = mat2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_diagonal(_copy_self._release(), _copy_mat2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_diagonal failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.diagonal = diagonal

    def left_hermite(self, neg):
        'left_hermite(self, neg)\n\n:param self: :class:`Mat`\n:param neg: :class:`int`\n:return: (:class:`Mat`, U (:class:`Mat`), Q (:class:`Mat`))'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for neg
        
        _retptr_U = ffi.new("isl_mat **")
        
        _retptr_Q = ffi.new("isl_mat **")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_left_hermite(_copy_self._release(), neg, _retptr_U, _retptr_Q)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _retptr_U == ffi.NULL:
                _ret_U = None
            else:
                _ret_U = Mat(_data=_retptr_U[0])
            if _retptr_Q == ffi.NULL:
                _ret_Q = None
            else:
                _ret_Q = Mat(_data=_retptr_Q[0])
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_left_hermite failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result, _ret_U, _ret_Q

    Mat.left_hermite = left_hermite

    def lin_to_aff(self):
        'lin_to_aff(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_lin_to_aff(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_lin_to_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.lin_to_aff = lin_to_aff

    def inverse_product(self, right):
        'inverse_product(self, right)\n\n:param self: :class:`Mat`\n:param right: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(right, Mat):
            raise IslTypeError("right is not a Mat")
        if _ctx_data != right._ctx_data:
            raise Error("mismatched context in right")
        _copy_right = right._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_inverse_product(_copy_self._release(), _copy_right._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_inverse_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.inverse_product = inverse_product

    def product(self, right):
        'product(self, right)\n\n:param self: :class:`Mat`\n:param right: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(right, Mat):
            raise IslTypeError("right is not a Mat")
        if _ctx_data != right._ctx_data:
            raise Error("mismatched context in right")
        _copy_right = right._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_product(_copy_self._release(), _copy_right._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_product failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.product = product

    def transpose(self):
        'transpose(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_transpose(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_transpose failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.transpose = transpose

    def right_inverse(self):
        'right_inverse(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_right_inverse(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_right_inverse failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.right_inverse = right_inverse

    def right_kernel(self):
        'right_kernel(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_right_kernel(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_right_kernel failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.right_kernel = right_kernel

    def normalize(self):
        'normalize(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_normalize(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_normalize failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.normalize = normalize

    def normalize_row(self, row):
        'normalize_row(self, row)\n\n:param self: :class:`Mat`\n:param row: :class:`int`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for row
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_normalize_row(_copy_self._release(), row)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_normalize_row failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.normalize_row = normalize_row

    def drop_cols(self, col, n):
        'drop_cols(self, col, n)\n\n:param self: :class:`Mat`\n:param col: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for col
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_drop_cols(_copy_self._release(), col, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_drop_cols failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.drop_cols = drop_cols

    def drop_rows(self, row, n):
        'drop_rows(self, row, n)\n\n:param self: :class:`Mat`\n:param row: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for row
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_drop_rows(_copy_self._release(), row, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_drop_rows failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.drop_rows = drop_rows

    def insert_cols(self, col, n):
        'insert_cols(self, col, n)\n\n:param self: :class:`Mat`\n:param col: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for col
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_insert_cols(_copy_self._release(), col, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_insert_cols failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.insert_cols = insert_cols

    def insert_rows(self, row, n):
        'insert_rows(self, row, n)\n\n:param self: :class:`Mat`\n:param row: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for row
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_insert_rows(_copy_self._release(), row, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_insert_rows failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.insert_rows = insert_rows

    def move_cols(self, dst_col, src_col, n):
        'move_cols(self, dst_col, src_col, n)\n\n:param self: :class:`Mat`\n:param dst_col: :class:`unsigned`\n:param src_col: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for dst_col
        
        # no argument processing for src_col
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_move_cols(_copy_self._release(), dst_col, src_col, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_move_cols failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.move_cols = move_cols

    def add_rows(self, n):
        'add_rows(self, n)\n\n:param self: :class:`Mat`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_add_rows(_copy_self._release(), n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_add_rows failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.add_rows = add_rows

    def insert_zero_cols(self, first, n):
        'insert_zero_cols(self, first, n)\n\n:param self: :class:`Mat`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_insert_zero_cols(_copy_self._release(), first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_insert_zero_cols failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.insert_zero_cols = insert_zero_cols

    def add_zero_cols(self, n):
        'add_zero_cols(self, n)\n\n:param self: :class:`Mat`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_add_zero_cols(_copy_self._release(), n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_add_zero_cols failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.add_zero_cols = add_zero_cols

    def insert_zero_rows(self, row, n):
        'insert_zero_rows(self, row, n)\n\n:param self: :class:`Mat`\n:param row: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for row
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_insert_zero_rows(_copy_self._release(), row, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_insert_zero_rows failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.insert_zero_rows = insert_zero_rows

    def add_zero_rows(self, n):
        'add_zero_rows(self, n)\n\n:param self: :class:`Mat`\n:param n: :class:`unsigned`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_add_zero_rows(_copy_self._release(), n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_add_zero_rows failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.add_zero_rows = add_zero_rows

    def col_add(self, dst_col, src_col):
        'col_add(self, dst_col, src_col)\n\n:param self: :class:`Mat`\n:param dst_col: :class:`int`\n:param src_col: :class:`int`\n:return: (nothing)'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        
        # no argument processing for dst_col
        
        # no argument processing for src_col
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_col_add(self.data, dst_col, src_col)
        finally:
            pass
        

    Mat.col_add = col_add

    def unimodular_complete(self, row):
        'unimodular_complete(self, row)\n\n:param self: :class:`Mat`\n:param row: :class:`int`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for row
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_unimodular_complete(_copy_self._release(), row)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_unimodular_complete failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.unimodular_complete = unimodular_complete

    def row_basis(self):
        'row_basis(self)\n\n:param self: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_row_basis(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_row_basis failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.row_basis = row_basis

    def row_basis_extension(self, mat2):
        'row_basis_extension(self, mat2)\n\n:param self: :class:`Mat`\n:param mat2: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mat2, Mat):
            raise IslTypeError("mat2 is not a Mat")
        if _ctx_data != mat2._ctx_data:
            raise Error("mismatched context in mat2")
        _copy_mat2 = mat2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_row_basis_extension(_copy_self._release(), _copy_mat2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_row_basis_extension failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.row_basis_extension = row_basis_extension

    def from_row_vec(vec):
        'from_row_vec(vec)\n\n:param vec: :class:`Vec`\n:return: :class:`Mat`'

        if not isinstance(vec, Vec):
            raise IslTypeError("vec is not a Vec")
        _ctx_data = vec._ctx_data
        _copy_vec = vec._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_from_row_vec(_copy_vec._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_from_row_vec failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.from_row_vec = staticmethod(from_row_vec)

    Mat._from_row_vec_is_static = True

    def concat(self, bot):
        'concat(self, bot)\n\n:param self: :class:`Mat`\n:param bot: :class:`Mat`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(bot, Mat):
            raise IslTypeError("bot is not a Mat")
        if _ctx_data != bot._ctx_data:
            raise Error("mismatched context in bot")
        _copy_bot = bot._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_concat(_copy_self._release(), _copy_bot._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.concat = concat

    def vec_concat(self, bot):
        'vec_concat(self, bot)\n\n:param self: :class:`Mat`\n:param bot: :class:`Vec`\n:return: :class:`Mat`'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(bot, Vec):
            raise IslTypeError("bot is not a Vec")
        if _ctx_data != bot._ctx_data:
            raise Error("mismatched context in bot")
        _copy_bot = bot._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_vec_concat(_copy_self._release(), _copy_bot._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Mat(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_mat_vec_concat failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Mat.vec_concat = vec_concat

    def is_equal(self, mat2):
        'is_equal(self, mat2)\n\n:param self: :class:`Mat`\n:param mat2: :class:`Mat`\n:return: bool'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        
        if not isinstance(mat2, Mat):
            raise IslTypeError("mat2 is not a Mat")
        if _ctx_data != mat2._ctx_data:
            raise Error("mismatched context in mat2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_is_equal(self.data, mat2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_mat_is_equal\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Mat.is_equal = is_equal

    def has_linearly_independent_rows(self, mat2):
        'has_linearly_independent_rows(self, mat2)\n\n:param self: :class:`Mat`\n:param mat2: :class:`Mat`\n:return: bool'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        
        if not isinstance(mat2, Mat):
            raise IslTypeError("mat2 is not a Mat")
        if _ctx_data != mat2._ctx_data:
            raise Error("mismatched context in mat2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_has_linearly_independent_rows(self.data, mat2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_mat_has_linearly_independent_rows\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Mat.has_linearly_independent_rows = has_linearly_independent_rows

    def rank(self):
        'rank(self)\n\n:param self: :class:`Mat`\n:return: int'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_rank(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Mat.rank = rank

    def initial_non_zero_cols(self):
        'initial_non_zero_cols(self)\n\n:param self: :class:`Mat`\n:return: int'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_initial_non_zero_cols(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Mat.initial_non_zero_cols = initial_non_zero_cols

    def dump(self):
        'dump(self)\n\n:param self: :class:`Mat`\n:return: (nothing)'

        if not isinstance(self, Mat):
            raise IslTypeError("self is not a Mat")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_mat_dump(self.data)
        finally:
            pass
        

    Mat.dump = dump

    # }}}

    # {{{ fixed_box

    # }}}

    # {{{ aff

    def zero_on_domain(ls):
        'zero_on_domain(ls)\n\n:param ls: :class:`LocalSpace`\n:return: :class:`Aff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_zero_on_domain(_copy_ls._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_zero_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.zero_on_domain = staticmethod(zero_on_domain)

    Aff._zero_on_domain_is_static = True

    def val_on_domain(ls, val):
        'val_on_domain(ls, val)\n\n:param ls: :class:`LocalSpace`\n:param val: :class:`Val`\n:return: :class:`Aff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        
        if isinstance(val, Val):
            if _ctx_data != val._ctx_data:
                raise Error("mismatched context in val")
            _val_val = val._copy()
        elif isinstance(val, six.integer_types):
            _cdata_val = lib.isl_val_int_from_si(
                ls._get_ctx_data(), val)
        
            if _cdata_val == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_val = Val(_data=_cdata_val)
        
        else:
            raise IslTypeError("val is a %s and cannot "
                "be cast to a Val" % type(val))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_val_on_domain(_copy_ls._release(), _val_val._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_val_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.val_on_domain = staticmethod(val_on_domain)

    Aff._val_on_domain_is_static = True

    def var_on_domain(ls, type, pos):
        'var_on_domain(ls, type, pos)\n\n:param ls: :class:`LocalSpace`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: :class:`Aff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_var_on_domain(_copy_ls._release(), type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_var_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.var_on_domain = staticmethod(var_on_domain)

    Aff._var_on_domain_is_static = True

    def nan_on_domain(ls):
        'nan_on_domain(ls)\n\n:param ls: :class:`LocalSpace`\n:return: :class:`Aff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_nan_on_domain(_copy_ls._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_nan_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.nan_on_domain = staticmethod(nan_on_domain)

    Aff._nan_on_domain_is_static = True

    def param_on_domain_space_id(space, id):
        'param_on_domain_space_id(space, id)\n\n:param space: :class:`Space`\n:param id: :class:`Id`\n:return: :class:`Aff`'

        if not isinstance(space, Space):
            raise IslTypeError("space is not a Space")
        _ctx_data = space._ctx_data
        _copy_space = space._copy()
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_param_on_domain_space_id(_copy_space._release(), _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_param_on_domain_space_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.param_on_domain_space_id = staticmethod(param_on_domain_space_id)

    Aff._param_on_domain_space_id_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.copy = copy

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`Aff`\n:return: :class:`Context`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_ctx = get_ctx

    def get_hash(self):
        'get_hash(self)\n\n:param self: :class:`Aff`\n:return: uint32_t'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_hash(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Aff.get_hash = get_hash

    def dim(self, type):
        'dim(self, type)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:return: int'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_dim(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Aff.dim = dim

    def involves_dims(self, type, first, n):
        'involves_dims(self, type, first, n)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: bool'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_involves_dims(self.data, type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_aff_involves_dims\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Aff.involves_dims = involves_dims

    def get_domain_space(self):
        'get_domain_space(self)\n\n:param self: :class:`Aff`\n:return: :class:`Space`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_domain_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_domain_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_domain_space = get_domain_space

    def get_space(self):
        'get_space(self)\n\n:param self: :class:`Aff`\n:return: :class:`Space`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_space = get_space

    def get_domain_local_space(self):
        'get_domain_local_space(self)\n\n:param self: :class:`Aff`\n:return: :class:`LocalSpace`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_domain_local_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else LocalSpace(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_domain_local_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_domain_local_space = get_domain_local_space

    def get_local_space(self):
        'get_local_space(self)\n\n:param self: :class:`Aff`\n:return: :class:`LocalSpace`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_local_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else LocalSpace(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_local_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_local_space = get_local_space

    def get_dim_name(self, type, pos):
        'get_dim_name(self, type, pos)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: string'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_dim_name(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Aff.get_dim_name = get_dim_name

    def get_constant_val(self):
        'get_constant_val(self)\n\n:param self: :class:`Aff`\n:return: :class:`Val`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_constant_val(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_constant_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_constant_val = get_constant_val

    def get_coefficient_val(self, type, pos):
        'get_coefficient_val(self, type, pos)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`int`\n:return: :class:`Val`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_coefficient_val(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_coefficient_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_coefficient_val = get_coefficient_val

    def coefficient_sgn(self, type, pos):
        'coefficient_sgn(self, type, pos)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`int`\n:return: int'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_coefficient_sgn(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Aff.coefficient_sgn = coefficient_sgn

    def get_denominator_val(self):
        'get_denominator_val(self)\n\n:param self: :class:`Aff`\n:return: :class:`Val`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_denominator_val(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_denominator_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_denominator_val = get_denominator_val

    def set_constant_val(self, v):
        'set_constant_val(self, v)\n\n:param self: :class:`Aff`\n:param v: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_set_constant_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_set_constant_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.set_constant_val = set_constant_val

    def set_coefficient_val(self, type, pos, v):
        'set_coefficient_val(self, type, pos, v)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`int`\n:param v: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_set_coefficient_val(_copy_self._release(), type, pos, _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_set_coefficient_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.set_coefficient_val = set_coefficient_val

    def add_constant_val(self, v):
        'add_constant_val(self, v)\n\n:param self: :class:`Aff`\n:param v: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_add_constant_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_add_constant_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.add_constant_val = add_constant_val

    def add_constant_num_si(self, v):
        'add_constant_num_si(self, v)\n\n:param self: :class:`Aff`\n:param v: :class:`int`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for v
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_add_constant_num_si(_copy_self._release(), v)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_add_constant_num_si failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.add_constant_num_si = add_constant_num_si

    def add_coefficient_val(self, type, pos, v):
        'add_coefficient_val(self, type, pos, v)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`int`\n:param v: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_add_coefficient_val(_copy_self._release(), type, pos, _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_add_coefficient_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.add_coefficient_val = add_coefficient_val

    def is_cst(self):
        'is_cst(self)\n\n:param self: :class:`Aff`\n:return: bool'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_is_cst(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_aff_is_cst\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Aff.is_cst = is_cst

    def set_tuple_id(self, type, id):
        'set_tuple_id(self, type, id)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param id: :class:`Id`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_set_tuple_id(_copy_self._release(), type, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_set_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.set_tuple_id = set_tuple_id

    def set_dim_name(self, type, pos, s):
        'set_dim_name(self, type, pos, s)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:param s: string\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        _cstr_s = ffi.new("char[]", s.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_set_dim_name(_copy_self._release(), type, pos, _cstr_s)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_set_dim_name failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.set_dim_name = set_dim_name

    def set_dim_id(self, type, pos, id):
        'set_dim_id(self, type, pos, id)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:param id: :class:`Id`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_set_dim_id(_copy_self._release(), type, pos, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_set_dim_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.set_dim_id = set_dim_id

    def find_dim_by_name(self, type, name):
        'find_dim_by_name(self, type, name)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param name: string\n:return: int'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        _cstr_name = ffi.new("char[]", name.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_find_dim_by_name(self.data, type, _cstr_name)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    Aff.find_dim_by_name = find_dim_by_name

    def plain_is_equal(self, aff2):
        'plain_is_equal(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: bool'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_plain_is_equal(self.data, aff2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_aff_plain_is_equal\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Aff.plain_is_equal = plain_is_equal

    def plain_is_zero(self):
        'plain_is_zero(self)\n\n:param self: :class:`Aff`\n:return: bool'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_plain_is_zero(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_aff_plain_is_zero\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Aff.plain_is_zero = plain_is_zero

    def is_nan(self):
        'is_nan(self)\n\n:param self: :class:`Aff`\n:return: bool'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_is_nan(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_aff_is_nan\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    Aff.is_nan = is_nan

    def get_div(self, pos):
        'get_div(self, pos)\n\n:param self: :class:`Aff`\n:param pos: :class:`int`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_get_div(self.data, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_get_div failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.get_div = get_div

    def from_range(self):
        'from_range(self)\n\n:param self: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_from_range(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_from_range failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.from_range = from_range

    def neg(self):
        'neg(self)\n\n:param self: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_neg(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_neg failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.neg = neg

    def ceil(self):
        'ceil(self)\n\n:param self: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_ceil(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_ceil failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.ceil = ceil

    def floor(self):
        'floor(self)\n\n:param self: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_floor(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_floor failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.floor = floor

    def mod_val(self, mod):
        'mod_val(self, mod)\n\n:param self: :class:`Aff`\n:param mod: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(mod, Val):
            if _ctx_data != mod._ctx_data:
                raise Error("mismatched context in mod")
            _val_mod = mod._copy()
        elif isinstance(mod, six.integer_types):
            _cdata_mod = lib.isl_val_int_from_si(
                self._get_ctx_data(), mod)
        
            if _cdata_mod == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_mod = Val(_data=_cdata_mod)
        
        else:
            raise IslTypeError("mod is a %s and cannot "
                "be cast to a Val" % type(mod))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_mod_val(_copy_self._release(), _val_mod._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_mod_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.mod_val = mod_val

    def mul(self, aff2):
        'mul(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_mul(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_mul failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.mul = mul

    def div(self, aff2):
        'div(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_div(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_div failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.div = div

    def add(self, aff2):
        'add(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_add(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.add = add

    def sub(self, aff2):
        'sub(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_sub(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_sub failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.sub = sub

    def scale_val(self, v):
        'scale_val(self, v)\n\n:param self: :class:`Aff`\n:param v: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_scale_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_scale_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.scale_val = scale_val

    def scale_down_val(self, v):
        'scale_down_val(self, v)\n\n:param self: :class:`Aff`\n:param v: :class:`Val`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_scale_down_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_scale_down_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.scale_down_val = scale_down_val

    def insert_dims(self, type, first, n):
        'insert_dims(self, type, first, n)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_insert_dims(_copy_self._release(), type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_insert_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.insert_dims = insert_dims

    def add_dims(self, type, n):
        'add_dims(self, type, n)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param n: :class:`unsigned`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_add_dims(_copy_self._release(), type, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_add_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.add_dims = add_dims

    def move_dims(self, dst_type, dst_pos, src_type, src_pos, n):
        'move_dims(self, dst_type, dst_pos, src_type, src_pos, n)\n\n:param self: :class:`Aff`\n:param dst_type: :class:`dim_type`\n:param dst_pos: :class:`unsigned`\n:param src_type: :class:`dim_type`\n:param src_pos: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for dst_type
        
        # no argument processing for dst_pos
        
        # no argument processing for src_type
        
        # no argument processing for src_pos
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_move_dims(_copy_self._release(), dst_type, dst_pos, src_type, src_pos, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_move_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.move_dims = move_dims

    def drop_dims(self, type, first, n):
        'drop_dims(self, type, first, n)\n\n:param self: :class:`Aff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_drop_dims(_copy_self._release(), type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_drop_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.drop_dims = drop_dims

    def project_domain_on_params(self):
        'project_domain_on_params(self)\n\n:param self: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_project_domain_on_params(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_project_domain_on_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.project_domain_on_params = project_domain_on_params

    def align_params(self, model):
        'align_params(self, model)\n\n:param self: :class:`Aff`\n:param model: :class:`Space`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(model, Space):
            raise IslTypeError("model is not a Space")
        if _ctx_data != model._ctx_data:
            raise Error("mismatched context in model")
        _copy_model = model._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_align_params(_copy_self._release(), _copy_model._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_align_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.align_params = align_params

    def gist(self, context):
        'gist(self, context)\n\n:param self: :class:`Aff`\n:param context: :class:`Set`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(context, BasicSet):
            context = Set.from_basic_set(context)
        if not isinstance(context, Set):
            raise IslTypeError("context is not a Set")
        if _ctx_data != context._ctx_data:
            raise Error("mismatched context in context")
        _copy_context = context._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_gist(_copy_self._release(), _copy_context._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_gist failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.gist = gist

    def gist_params(self, context):
        'gist_params(self, context)\n\n:param self: :class:`Aff`\n:param context: :class:`Set`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(context, BasicSet):
            context = Set.from_basic_set(context)
        if not isinstance(context, Set):
            raise IslTypeError("context is not a Set")
        if _ctx_data != context._ctx_data:
            raise Error("mismatched context in context")
        _copy_context = context._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_gist_params(_copy_self._release(), _copy_context._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_gist_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.gist_params = gist_params

    def eval(self, pnt):
        'eval(self, pnt)\n\n:param self: :class:`Aff`\n:param pnt: :class:`Point`\n:return: :class:`Val`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(pnt, Point):
            raise IslTypeError("pnt is not a Point")
        if _ctx_data != pnt._ctx_data:
            raise Error("mismatched context in pnt")
        _copy_pnt = pnt._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_eval(_copy_self._release(), _copy_pnt._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_eval failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.eval = eval

    def pullback_aff(self, aff2):
        'pullback_aff(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_pullback_aff(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_pullback_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.pullback_aff = pullback_aff

    def pullback_multi_aff(self, ma):
        'pullback_multi_aff(self, ma)\n\n:param self: :class:`Aff`\n:param ma: :class:`MultiAff`\n:return: :class:`Aff`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(ma, MultiAff):
            raise IslTypeError("ma is not a MultiAff")
        if _ctx_data != ma._ctx_data:
            raise Error("mismatched context in ma")
        _copy_ma = ma._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_pullback_multi_aff(_copy_self._release(), _copy_ma._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_pullback_multi_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.pullback_multi_aff = pullback_multi_aff

    def zero_basic_set(self):
        'zero_basic_set(self)\n\n:param self: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_zero_basic_set(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_zero_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.zero_basic_set = zero_basic_set

    def neg_basic_set(self):
        'neg_basic_set(self)\n\n:param self: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_neg_basic_set(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_neg_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.neg_basic_set = neg_basic_set

    def eq_basic_set(self, aff2):
        'eq_basic_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_eq_basic_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_eq_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.eq_basic_set = eq_basic_set

    def eq_set(self, aff2):
        'eq_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Set`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_eq_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_eq_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.eq_set = eq_set

    def ne_set(self, aff2):
        'ne_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Set`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_ne_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_ne_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.ne_set = ne_set

    def le_basic_set(self, aff2):
        'le_basic_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_le_basic_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_le_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.le_basic_set = le_basic_set

    def le_set(self, aff2):
        'le_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Set`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_le_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_le_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.le_set = le_set

    def lt_basic_set(self, aff2):
        'lt_basic_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_lt_basic_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_lt_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.lt_basic_set = lt_basic_set

    def lt_set(self, aff2):
        'lt_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Set`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_lt_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_lt_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.lt_set = lt_set

    def ge_basic_set(self, aff2):
        'ge_basic_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_ge_basic_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_ge_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.ge_basic_set = ge_basic_set

    def ge_set(self, aff2):
        'ge_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Set`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_ge_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_ge_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.ge_set = ge_set

    def gt_basic_set(self, aff2):
        'gt_basic_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`BasicSet`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_gt_basic_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else BasicSet(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_gt_basic_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.gt_basic_set = gt_basic_set

    def gt_set(self, aff2):
        'gt_set(self, aff2)\n\n:param self: :class:`Aff`\n:param aff2: :class:`Aff`\n:return: :class:`Set`'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(aff2, Aff):
            raise IslTypeError("aff2 is not a Aff")
        if _ctx_data != aff2._ctx_data:
            raise Error("mismatched context in aff2")
        _copy_aff2 = aff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_gt_set(_copy_self._release(), _copy_aff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_gt_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.gt_set = gt_set

    def read_from_str(ctx, str):
        'read_from_str(ctx, str)\n\n:param ctx: :class:`Context`\n:param str: string\n:return: :class:`Aff`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        _cstr_str = ffi.new("char[]", str.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_read_from_str(ctx.data, _cstr_str)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Aff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_aff_read_from_str failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    Aff.read_from_str = staticmethod(read_from_str)

    Aff._read_from_str_is_static = True

    def to_str(self):
        'to_str(self)\n\n:param self: :class:`Aff`\n:return: string'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_to_str(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            libc.free(_result)
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    Aff.to_str = to_str

    def dump(self):
        'dump(self)\n\n:param self: :class:`Aff`\n:return: (nothing)'

        if not isinstance(self, Aff):
            raise IslTypeError("self is not a Aff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_aff_dump(self.data)
        finally:
            pass
        

    Aff.dump = dump

    # }}}

    # {{{ pw_aff

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Context`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.get_ctx = get_ctx

    def get_hash(self):
        'get_hash(self)\n\n:param self: :class:`PwAff`\n:return: uint32_t'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_hash(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    PwAff.get_hash = get_hash

    def get_domain_space(self):
        'get_domain_space(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Space`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_domain_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_get_domain_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.get_domain_space = get_domain_space

    def get_space(self):
        'get_space(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Space`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_get_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.get_space = get_space

    def from_aff(aff):
        'from_aff(aff)\n\n:param aff: :class:`Aff`\n:return: :class:`PwAff`'

        if not isinstance(aff, Aff):
            raise IslTypeError("aff is not a Aff")
        _ctx_data = aff._ctx_data
        _copy_aff = aff._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_from_aff(_copy_aff._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_from_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.from_aff = staticmethod(from_aff)

    PwAff._from_aff_is_static = True

    def empty(dim):
        'empty(dim)\n\n:param dim: :class:`Space`\n:return: :class:`PwAff`'

        if not isinstance(dim, Space):
            raise IslTypeError("dim is not a Space")
        _ctx_data = dim._ctx_data
        _copy_dim = dim._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_empty(_copy_dim._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_empty failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.empty = staticmethod(empty)

    PwAff._empty_is_static = True

    def alloc(set, aff):
        'alloc(set, aff)\n\n:param set: :class:`Set`\n:param aff: :class:`Aff`\n:return: :class:`PwAff`'

        if isinstance(set, BasicSet):
            set = Set.from_basic_set(set)
        if not isinstance(set, Set):
            raise IslTypeError("set is not a Set")
        _ctx_data = set._ctx_data
        _copy_set = set._copy()
        
        if not isinstance(aff, Aff):
            raise IslTypeError("aff is not a Aff")
        if _ctx_data != aff._ctx_data:
            raise Error("mismatched context in aff")
        _copy_aff = aff._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_alloc(_copy_set._release(), _copy_aff._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_alloc failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.alloc = staticmethod(alloc)

    PwAff._alloc_is_static = True

    def zero_on_domain(ls):
        'zero_on_domain(ls)\n\n:param ls: :class:`LocalSpace`\n:return: :class:`PwAff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_zero_on_domain(_copy_ls._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_zero_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.zero_on_domain = staticmethod(zero_on_domain)

    PwAff._zero_on_domain_is_static = True

    def var_on_domain(ls, type, pos):
        'var_on_domain(ls, type, pos)\n\n:param ls: :class:`LocalSpace`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: :class:`PwAff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_var_on_domain(_copy_ls._release(), type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_var_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.var_on_domain = staticmethod(var_on_domain)

    PwAff._var_on_domain_is_static = True

    def nan_on_domain(ls):
        'nan_on_domain(ls)\n\n:param ls: :class:`LocalSpace`\n:return: :class:`PwAff`'

        if isinstance(ls, Space):
            ls = LocalSpace.from_space(ls)
        if not isinstance(ls, LocalSpace):
            raise IslTypeError("ls is not a LocalSpace")
        _ctx_data = ls._ctx_data
        _copy_ls = ls._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_nan_on_domain(_copy_ls._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_nan_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.nan_on_domain = staticmethod(nan_on_domain)

    PwAff._nan_on_domain_is_static = True

    def val_on_domain(domain, v):
        'val_on_domain(domain, v)\n\n:param domain: :class:`Set`\n:param v: :class:`Val`\n:return: :class:`PwAff`'

        if isinstance(domain, BasicSet):
            domain = Set.from_basic_set(domain)
        if not isinstance(domain, Set):
            raise IslTypeError("domain is not a Set")
        _ctx_data = domain._ctx_data
        _copy_domain = domain._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                domain._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_val_on_domain(_copy_domain._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_val_on_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.val_on_domain = staticmethod(val_on_domain)

    PwAff._val_on_domain_is_static = True

    def get_dim_name(self, type, pos):
        'get_dim_name(self, type, pos)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: string'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_dim_name(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    PwAff.get_dim_name = get_dim_name

    def has_dim_id(self, type, pos):
        'has_dim_id(self, type, pos)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_has_dim_id(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_has_dim_id\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.has_dim_id = has_dim_id

    def get_dim_id(self, type, pos):
        'get_dim_id(self, type, pos)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:return: :class:`Id`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for pos
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_dim_id(self.data, type, pos)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Id(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_get_dim_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.get_dim_id = get_dim_id

    def set_dim_id(self, type, pos, id):
        'set_dim_id(self, type, pos, id)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:param id: :class:`Id`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_set_dim_id(_copy_self._release(), type, pos, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_set_dim_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.set_dim_id = set_dim_id

    def find_dim_by_name(self, type, name):
        'find_dim_by_name(self, type, name)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param name: string\n:return: int'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        _cstr_name = ffi.new("char[]", name.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_find_dim_by_name(self.data, type, _cstr_name)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    PwAff.find_dim_by_name = find_dim_by_name

    def is_empty(self):
        'is_empty(self)\n\n:param self: :class:`PwAff`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_is_empty(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_is_empty\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.is_empty = is_empty

    def involves_nan(self):
        'involves_nan(self)\n\n:param self: :class:`PwAff`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_involves_nan(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_involves_nan\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.involves_nan = involves_nan

    def plain_cmp(self, pa2):
        'plain_cmp(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: int'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_plain_cmp(self.data, pa2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    PwAff.plain_cmp = plain_cmp

    def plain_is_equal(self, pwaff2):
        'plain_is_equal(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_plain_is_equal(self.data, pwaff2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_plain_is_equal\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.plain_is_equal = plain_is_equal

    def is_equal(self, pa2):
        'is_equal(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_is_equal(self.data, pa2.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_is_equal\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.is_equal = is_equal

    def union_min(self, pwaff2):
        'union_min(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_union_min(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_union_min failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.union_min = union_min

    def union_max(self, pwaff2):
        'union_max(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_union_max(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_union_max failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.union_max = union_max

    def union_add(self, pwaff2):
        'union_add(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_union_add(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_union_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.union_add = union_add

    def copy(self):
        'copy(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.copy = copy

    def dim(self, type):
        'dim(self, type)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:return: unsigned'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_dim(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    PwAff.dim = dim

    def involves_dims(self, type, first, n):
        'involves_dims(self, type, first, n)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_involves_dims(self.data, type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_involves_dims\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.involves_dims = involves_dims

    def is_cst(self):
        'is_cst(self)\n\n:param self: :class:`PwAff`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_is_cst(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_is_cst\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.is_cst = is_cst

    def project_domain_on_params(self):
        'project_domain_on_params(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_project_domain_on_params(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_project_domain_on_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.project_domain_on_params = project_domain_on_params

    def align_params(self, model):
        'align_params(self, model)\n\n:param self: :class:`PwAff`\n:param model: :class:`Space`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(model, Space):
            raise IslTypeError("model is not a Space")
        if _ctx_data != model._ctx_data:
            raise Error("mismatched context in model")
        _copy_model = model._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_align_params(_copy_self._release(), _copy_model._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_align_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.align_params = align_params

    def drop_unused_params(self):
        'drop_unused_params(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_drop_unused_params(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_drop_unused_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.drop_unused_params = drop_unused_params

    def has_tuple_id(self, type):
        'has_tuple_id(self, type)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:return: bool'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_has_tuple_id(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_bool_error:
            raise Error("call to \"isl_pw_aff_has_tuple_id\" failed: %s" % _get_last_error_str(_ctx_data))
        
        return _result == lib.isl_bool_true

    PwAff.has_tuple_id = has_tuple_id

    def get_tuple_id(self, type):
        'get_tuple_id(self, type)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:return: :class:`Id`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_get_tuple_id(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Id(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_get_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.get_tuple_id = get_tuple_id

    def set_tuple_id(self, type, id):
        'set_tuple_id(self, type, id)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param id: :class:`Id`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_set_tuple_id(_copy_self._release(), type, _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_set_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.set_tuple_id = set_tuple_id

    def reset_tuple_id(self, type):
        'reset_tuple_id(self, type)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_reset_tuple_id(_copy_self._release(), type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_reset_tuple_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.reset_tuple_id = reset_tuple_id

    def reset_user(self):
        'reset_user(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_reset_user(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_reset_user failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.reset_user = reset_user

    def params(self):
        'params(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_params(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.params = params

    def domain(self):
        'domain(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_domain(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.domain = domain

    def from_range(self):
        'from_range(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_from_range(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_from_range failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.from_range = from_range

    def min(self, pwaff2):
        'min(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_min(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_min failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.min = min

    def max(self, pwaff2):
        'max(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_max(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_max failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.max = max

    def mul(self, pwaff2):
        'mul(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_mul(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_mul failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.mul = mul

    def div(self, pa2):
        'div(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        _copy_pa2 = pa2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_div(_copy_self._release(), _copy_pa2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_div failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.div = div

    def add(self, pwaff2):
        'add(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_add(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_add failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.add = add

    def sub(self, pwaff2):
        'sub(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_sub(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_sub failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.sub = sub

    def neg(self):
        'neg(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_neg(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_neg failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.neg = neg

    def ceil(self):
        'ceil(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_ceil(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_ceil failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.ceil = ceil

    def floor(self):
        'floor(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_floor(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_floor failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.floor = floor

    def mod_val(self, mod):
        'mod_val(self, mod)\n\n:param self: :class:`PwAff`\n:param mod: :class:`Val`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(mod, Val):
            if _ctx_data != mod._ctx_data:
                raise Error("mismatched context in mod")
            _val_mod = mod._copy()
        elif isinstance(mod, six.integer_types):
            _cdata_mod = lib.isl_val_int_from_si(
                self._get_ctx_data(), mod)
        
            if _cdata_mod == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_mod = Val(_data=_cdata_mod)
        
        else:
            raise IslTypeError("mod is a %s and cannot "
                "be cast to a Val" % type(mod))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_mod_val(_copy_self._release(), _val_mod._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_mod_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.mod_val = mod_val

    def tdiv_q(self, pa2):
        'tdiv_q(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        _copy_pa2 = pa2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_tdiv_q(_copy_self._release(), _copy_pa2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_tdiv_q failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.tdiv_q = tdiv_q

    def tdiv_r(self, pa2):
        'tdiv_r(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        _copy_pa2 = pa2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_tdiv_r(_copy_self._release(), _copy_pa2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_tdiv_r failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.tdiv_r = tdiv_r

    def intersect_params(self, set):
        'intersect_params(self, set)\n\n:param self: :class:`PwAff`\n:param set: :class:`Set`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(set, BasicSet):
            set = Set.from_basic_set(set)
        if not isinstance(set, Set):
            raise IslTypeError("set is not a Set")
        if _ctx_data != set._ctx_data:
            raise Error("mismatched context in set")
        _copy_set = set._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_intersect_params(_copy_self._release(), _copy_set._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_intersect_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.intersect_params = intersect_params

    def intersect_domain(self, set):
        'intersect_domain(self, set)\n\n:param self: :class:`PwAff`\n:param set: :class:`Set`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(set, BasicSet):
            set = Set.from_basic_set(set)
        if not isinstance(set, Set):
            raise IslTypeError("set is not a Set")
        if _ctx_data != set._ctx_data:
            raise Error("mismatched context in set")
        _copy_set = set._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_intersect_domain(_copy_self._release(), _copy_set._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_intersect_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.intersect_domain = intersect_domain

    def subtract_domain(self, set):
        'subtract_domain(self, set)\n\n:param self: :class:`PwAff`\n:param set: :class:`Set`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(set, BasicSet):
            set = Set.from_basic_set(set)
        if not isinstance(set, Set):
            raise IslTypeError("set is not a Set")
        if _ctx_data != set._ctx_data:
            raise Error("mismatched context in set")
        _copy_set = set._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_subtract_domain(_copy_self._release(), _copy_set._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_subtract_domain failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.subtract_domain = subtract_domain

    def cond(self, pwaff_true, pwaff_false):
        'cond(self, pwaff_true, pwaff_false)\n\n:param self: :class:`PwAff`\n:param pwaff_true: :class:`PwAff`\n:param pwaff_false: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff_true, Aff):
            pwaff_true = PwAff.from_aff(pwaff_true)
        if not isinstance(pwaff_true, PwAff):
            raise IslTypeError("pwaff_true is not a PwAff")
        if _ctx_data != pwaff_true._ctx_data:
            raise Error("mismatched context in pwaff_true")
        _copy_pwaff_true = pwaff_true._copy()
        
        if isinstance(pwaff_false, Aff):
            pwaff_false = PwAff.from_aff(pwaff_false)
        if not isinstance(pwaff_false, PwAff):
            raise IslTypeError("pwaff_false is not a PwAff")
        if _ctx_data != pwaff_false._ctx_data:
            raise Error("mismatched context in pwaff_false")
        _copy_pwaff_false = pwaff_false._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_cond(_copy_self._release(), _copy_pwaff_true._release(), _copy_pwaff_false._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_cond failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.cond = cond

    def scale_val(self, v):
        'scale_val(self, v)\n\n:param self: :class:`PwAff`\n:param v: :class:`Val`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(v, Val):
            if _ctx_data != v._ctx_data:
                raise Error("mismatched context in v")
            _val_v = v._copy()
        elif isinstance(v, six.integer_types):
            _cdata_v = lib.isl_val_int_from_si(
                self._get_ctx_data(), v)
        
            if _cdata_v == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_v = Val(_data=_cdata_v)
        
        else:
            raise IslTypeError("v is a %s and cannot "
                "be cast to a Val" % type(v))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_scale_val(_copy_self._release(), _val_v._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_scale_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.scale_val = scale_val

    def scale_down_val(self, f):
        'scale_down_val(self, f)\n\n:param self: :class:`PwAff`\n:param f: :class:`Val`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(f, Val):
            if _ctx_data != f._ctx_data:
                raise Error("mismatched context in f")
            _val_f = f._copy()
        elif isinstance(f, six.integer_types):
            _cdata_f = lib.isl_val_int_from_si(
                self._get_ctx_data(), f)
        
            if _cdata_f == ffi.NULL:
                raise Error("isl_val_int_from_si failed")
        
            _val_f = Val(_data=_cdata_f)
        
        else:
            raise IslTypeError("f is a %s and cannot "
                "be cast to a Val" % type(f))
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_scale_down_val(_copy_self._release(), _val_f._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_scale_down_val failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.scale_down_val = scale_down_val

    def insert_dims(self, type, first, n):
        'insert_dims(self, type, first, n)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_insert_dims(_copy_self._release(), type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_insert_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.insert_dims = insert_dims

    def add_dims(self, type, n):
        'add_dims(self, type, n)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param n: :class:`unsigned`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_add_dims(_copy_self._release(), type, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_add_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.add_dims = add_dims

    def move_dims(self, dst_type, dst_pos, src_type, src_pos, n):
        'move_dims(self, dst_type, dst_pos, src_type, src_pos, n)\n\n:param self: :class:`PwAff`\n:param dst_type: :class:`dim_type`\n:param dst_pos: :class:`unsigned`\n:param src_type: :class:`dim_type`\n:param src_pos: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for dst_type
        
        # no argument processing for dst_pos
        
        # no argument processing for src_type
        
        # no argument processing for src_pos
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_move_dims(_copy_self._release(), dst_type, dst_pos, src_type, src_pos, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_move_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.move_dims = move_dims

    def drop_dims(self, type, first, n):
        'drop_dims(self, type, first, n)\n\n:param self: :class:`PwAff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_drop_dims(_copy_self._release(), type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_drop_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.drop_dims = drop_dims

    def coalesce(self):
        'coalesce(self)\n\n:param self: :class:`PwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_coalesce(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_coalesce failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.coalesce = coalesce

    def gist(self, context):
        'gist(self, context)\n\n:param self: :class:`PwAff`\n:param context: :class:`Set`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(context, BasicSet):
            context = Set.from_basic_set(context)
        if not isinstance(context, Set):
            raise IslTypeError("context is not a Set")
        if _ctx_data != context._ctx_data:
            raise Error("mismatched context in context")
        _copy_context = context._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_gist(_copy_self._release(), _copy_context._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_gist failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.gist = gist

    def gist_params(self, context):
        'gist_params(self, context)\n\n:param self: :class:`PwAff`\n:param context: :class:`Set`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(context, BasicSet):
            context = Set.from_basic_set(context)
        if not isinstance(context, Set):
            raise IslTypeError("context is not a Set")
        if _ctx_data != context._ctx_data:
            raise Error("mismatched context in context")
        _copy_context = context._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_gist_params(_copy_self._release(), _copy_context._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_gist_params failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.gist_params = gist_params

    def eval(self, pnt):
        'eval(self, pnt)\n\n:param self: :class:`PwAff`\n:param pnt: :class:`Point`\n:return: :class:`Val`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(pnt, Point):
            raise IslTypeError("pnt is not a Point")
        if _ctx_data != pnt._ctx_data:
            raise Error("mismatched context in pnt")
        _copy_pnt = pnt._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_eval(_copy_self._release(), _copy_pnt._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Val(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_eval failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.eval = eval

    def pullback_multi_aff(self, ma):
        'pullback_multi_aff(self, ma)\n\n:param self: :class:`PwAff`\n:param ma: :class:`MultiAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(ma, MultiAff):
            raise IslTypeError("ma is not a MultiAff")
        if _ctx_data != ma._ctx_data:
            raise Error("mismatched context in ma")
        _copy_ma = ma._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_pullback_multi_aff(_copy_self._release(), _copy_ma._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_pullback_multi_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.pullback_multi_aff = pullback_multi_aff

    def pullback_pw_multi_aff(self, pma):
        'pullback_pw_multi_aff(self, pma)\n\n:param self: :class:`PwAff`\n:param pma: :class:`PwMultiAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(pma, PwMultiAff):
            raise IslTypeError("pma is not a PwMultiAff")
        if _ctx_data != pma._ctx_data:
            raise Error("mismatched context in pma")
        _copy_pma = pma._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_pullback_pw_multi_aff(_copy_self._release(), _copy_pma._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_pullback_pw_multi_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.pullback_pw_multi_aff = pullback_pw_multi_aff

    def pullback_multi_pw_aff(self, mpa):
        'pullback_multi_pw_aff(self, mpa)\n\n:param self: :class:`PwAff`\n:param mpa: :class:`MultiPwAff`\n:return: :class:`PwAff`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if not isinstance(mpa, MultiPwAff):
            raise IslTypeError("mpa is not a MultiPwAff")
        if _ctx_data != mpa._ctx_data:
            raise Error("mismatched context in mpa")
        _copy_mpa = mpa._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_pullback_multi_pw_aff(_copy_self._release(), _copy_mpa._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_pullback_multi_pw_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.pullback_multi_pw_aff = pullback_multi_pw_aff

    def n_piece(self):
        'n_piece(self)\n\n:param self: :class:`PwAff`\n:return: int'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_n_piece(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    PwAff.n_piece = n_piece

    def foreach_piece(self, fn):
        'foreach_piece(self, fn)\n\n:param self: :class:`PwAff`\n:param fn: callback(set, aff) -> isl_stat\n:return: (nothing)'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        
        def _cb_wrapper_fn(set, aff, user):
            try:
                _py_set = Set(_data=set)
                _py_aff = Aff(_data=aff)
                _result = fn(_py_set, _py_aff)
                if _result is None:
                    _result = lib.isl_stat_ok
                return _result
            except Exception as e:
                import sys
                sys.stderr.write("[WARNING] An exception occurred "
                    "in a callback function."
                    "This exception was ignored.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_exc()
            
                return lib.isl_stat_error
        
        _cb_fn = ffi.callback(" isl_stat (*fn)( isl_set *set,  isl_aff *aff,  void *user)")(_cb_wrapper_fn)
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_foreach_piece(self.data, _cb_fn, ffi.NULL)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        if _result == lib.isl_stat_error:
            raise Error("call to \"isl_pw_aff_foreach_piece\" failed: %s" % _get_last_error_str(_ctx_data))
        

    PwAff.foreach_piece = foreach_piece

    def pos_set(self):
        'pos_set(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_pos_set(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_pos_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.pos_set = pos_set

    def nonneg_set(self):
        'nonneg_set(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_nonneg_set(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_nonneg_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.nonneg_set = nonneg_set

    def zero_set(self):
        'zero_set(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_zero_set(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_zero_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.zero_set = zero_set

    def non_zero_set(self):
        'non_zero_set(self)\n\n:param self: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_non_zero_set(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_non_zero_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.non_zero_set = non_zero_set

    def eq_set(self, pwaff2):
        'eq_set(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_eq_set(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_eq_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.eq_set = eq_set

    def ne_set(self, pwaff2):
        'ne_set(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_ne_set(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_ne_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.ne_set = ne_set

    def le_set(self, pwaff2):
        'le_set(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_le_set(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_le_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.le_set = le_set

    def lt_set(self, pwaff2):
        'lt_set(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_lt_set(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_lt_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.lt_set = lt_set

    def ge_set(self, pwaff2):
        'ge_set(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_ge_set(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_ge_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.ge_set = ge_set

    def gt_set(self, pwaff2):
        'gt_set(self, pwaff2)\n\n:param self: :class:`PwAff`\n:param pwaff2: :class:`PwAff`\n:return: :class:`Set`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pwaff2, Aff):
            pwaff2 = PwAff.from_aff(pwaff2)
        if not isinstance(pwaff2, PwAff):
            raise IslTypeError("pwaff2 is not a PwAff")
        if _ctx_data != pwaff2._ctx_data:
            raise Error("mismatched context in pwaff2")
        _copy_pwaff2 = pwaff2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_gt_set(_copy_self._release(), _copy_pwaff2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Set(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_gt_set failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.gt_set = gt_set

    def eq_map(self, pa2):
        'eq_map(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: :class:`Map`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        _copy_pa2 = pa2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_eq_map(_copy_self._release(), _copy_pa2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Map(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_eq_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.eq_map = eq_map

    def lt_map(self, pa2):
        'lt_map(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: :class:`Map`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        _copy_pa2 = pa2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_lt_map(_copy_self._release(), _copy_pa2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Map(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_lt_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.lt_map = lt_map

    def gt_map(self, pa2):
        'gt_map(self, pa2)\n\n:param self: :class:`PwAff`\n:param pa2: :class:`PwAff`\n:return: :class:`Map`'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        if isinstance(pa2, Aff):
            pa2 = PwAff.from_aff(pa2)
        if not isinstance(pa2, PwAff):
            raise IslTypeError("pa2 is not a PwAff")
        if _ctx_data != pa2._ctx_data:
            raise Error("mismatched context in pa2")
        _copy_pa2 = pa2._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_gt_map(_copy_self._release(), _copy_pa2._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Map(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_gt_map failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.gt_map = gt_map

    def read_from_str(ctx, str):
        'read_from_str(ctx, str)\n\n:param ctx: :class:`Context`\n:param str: string\n:return: :class:`PwAff`'

        if not isinstance(ctx, Context):
            raise IslTypeError("ctx is not a Context")
        _ctx_data = ctx._ctx_data
        
        _cstr_str = ffi.new("char[]", str.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_read_from_str(ctx.data, _cstr_str)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_pw_aff_read_from_str failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    PwAff.read_from_str = staticmethod(read_from_str)

    PwAff._read_from_str_is_static = True

    def to_str(self):
        'to_str(self)\n\n:param self: :class:`PwAff`\n:return: string'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_to_str(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            if _result != ffi.NULL:
                _str_ret = ffi.string(_result)
            else:
                _str_ret = None
            libc.free(_result)
            pass
        if _PY3 and _str_ret is not None:
            _str_ret = _str_ret.decode()
        
        return _str_ret

    PwAff.to_str = to_str

    def dump(self):
        'dump(self)\n\n:param self: :class:`PwAff`\n:return: (nothing)'

        if isinstance(self, Aff):
            self = PwAff.from_aff(self)
        if not isinstance(self, PwAff):
            raise IslTypeError("self is not a PwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_pw_aff_dump(self.data)
        finally:
            pass
        

    PwAff.dump = dump

    # }}}

    # {{{ union_pw_aff

    def param_on_domain_id(domain, id):
        'param_on_domain_id(domain, id)\n\n:param domain: :class:`UnionSet`\n:param id: :class:`Id`\n:return: :class:`UnionPwAff`'

        if isinstance(domain, BasicSet):
            domain = Set.from_basic_set(domain)
        if isinstance(domain, Set):
            domain = UnionSet.from_set(domain)
        if not isinstance(domain, UnionSet):
            raise IslTypeError("domain is not a UnionSet")
        _ctx_data = domain._ctx_data
        _copy_domain = domain._copy()
        
        if not isinstance(id, Id):
            raise IslTypeError("id is not a Id")
        if _ctx_data != id._ctx_data:
            raise Error("mismatched context in id")
        _copy_id = id._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_param_on_domain_id(_copy_domain._release(), _copy_id._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_param_on_domain_id failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.param_on_domain_id = staticmethod(param_on_domain_id)

    UnionPwAff._param_on_domain_id_is_static = True

    def copy(self):
        'copy(self)\n\n:param self: :class:`UnionPwAff`\n:return: :class:`UnionPwAff`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_copy(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_copy failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.copy = copy

    def get_ctx(self):
        'get_ctx(self)\n\n:param self: :class:`UnionPwAff`\n:return: :class:`Context`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_get_ctx(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Context(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_get_ctx failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.get_ctx = get_ctx

    def get_space(self):
        'get_space(self)\n\n:param self: :class:`UnionPwAff`\n:return: :class:`Space`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_get_space(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else Space(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_get_space failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.get_space = get_space

    def get_pw_aff_list(self):
        'get_pw_aff_list(self)\n\n:param self: :class:`UnionPwAff`\n:return: :class:`PwAffList`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_get_pw_aff_list(self.data)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else PwAffList(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_get_pw_aff_list failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.get_pw_aff_list = get_pw_aff_list

    def dim(self, type):
        'dim(self, type)\n\n:param self: :class:`UnionPwAff`\n:param type: :class:`dim_type`\n:return: unsigned'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_dim(self.data, type)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    UnionPwAff.dim = dim

    def set_dim_name(self, type, pos, s):
        'set_dim_name(self, type, pos, s)\n\n:param self: :class:`UnionPwAff`\n:param type: :class:`dim_type`\n:param pos: :class:`unsigned`\n:param s: string\n:return: :class:`UnionPwAff`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for pos
        
        _cstr_s = ffi.new("char[]", s.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_set_dim_name(_copy_self._release(), type, pos, _cstr_s)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_set_dim_name failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.set_dim_name = set_dim_name

    def find_dim_by_name(self, type, name):
        'find_dim_by_name(self, type, name)\n\n:param self: :class:`UnionPwAff`\n:param type: :class:`dim_type`\n:param name: string\n:return: int'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        
        # no argument processing for type
        
        _cstr_name = ffi.new("char[]", name.encode())
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_find_dim_by_name(self.data, type, _cstr_name)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            pass
        
        return _result

    UnionPwAff.find_dim_by_name = find_dim_by_name

    def drop_dims(self, type, first, n):
        'drop_dims(self, type, first, n)\n\n:param self: :class:`UnionPwAff`\n:param type: :class:`dim_type`\n:param first: :class:`unsigned`\n:param n: :class:`unsigned`\n:return: :class:`UnionPwAff`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        
        # no argument processing for type
        
        # no argument processing for first
        
        # no argument processing for n
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_drop_dims(_copy_self._release(), type, first, n)
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_drop_dims failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.drop_dims = drop_dims

    def reset_user(self):
        'reset_user(self)\n\n:param self: :class:`UnionPwAff`\n:return: :class:`UnionPwAff`'

        if not isinstance(self, UnionPwAff):
            raise IslTypeError("self is not a UnionPwAff")
        _ctx_data = self._ctx_data
        _copy_self = self._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_reset_user(_copy_self._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_reset_user failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.reset_user = reset_user

    def empty(space):
        'empty(space)\n\n:param space: :class:`Space`\n:return: :class:`UnionPwAff`'

        if not isinstance(space, Space):
            raise IslTypeError("space is not a Space")
        _ctx_data = space._ctx_data
        _copy_space = space._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_empty(_copy_space._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_empty failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.empty = staticmethod(empty)

    UnionPwAff._empty_is_static = True

    def from_pw_aff(pa):
        'from_pw_aff(pa)\n\n:param pa: :class:`PwAff`\n:return: :class:`UnionPwAff`'

        if isinstance(pa, Aff):
            pa = PwAff.from_aff(pa)
        if not isinstance(pa, PwAff):
            raise IslTypeError("pa is not a PwAff")
        _ctx_data = pa._ctx_data
        _copy_pa = pa._copy()
        

        try:
            _result = None
            with DelayedKeyboardInterrupt():
                _result = lib.isl_union_pw_aff_from_pw_aff(_copy_pa._release())
        finally:
            if _result is None:
                # This should never happen.
                sys.stderr.write("*** islpy was interrupted while collecting "
                    "a result. "
                    "System state is inconsistent as a result, will print "
                    "traceback and abort.\n")
                sys.stderr.flush()
                import traceback
                traceback.print_stack()
                import os
                os._exit(-1)
            _result = None if (_result == ffi.NULL or _result is None) else UnionPwAff(_data=_result)
            pass
        if _result is None:
            raise Error("call to isl_union_pw_aff_from_pw_aff failed: %s"
                % _get_last_error_str(_ctx_data))
        
        return _result

    UnionPwAff.from_pw_aff = staticmethod(from_pw_aff)

    UnionPwAff._from