define(["@jupyter-widgets/base"], function(__WEBPACK_EXTERNAL_MODULE_2__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	// Entry point for the notebook bundle containing custom model definitions.
	//
	// Setup notebook base URL
	//
	// Some static assets may be required by the custom widget javascript. The base
	// url for the notebook is not known at build time and is therefore computed
	// dynamically.
	__webpack_require__.p = document.querySelector('body').getAttribute('data-base-url') + 'nbextensions/jupyter-webrtc/';
	
	// Export widget models and views, and the npm package version number.
	module.exports = __webpack_require__(1);
	module.exports['version'] = __webpack_require__(79).version;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	widgets = __webpack_require__(2)
	_ = __webpack_require__(3)
	__webpack_require__(4)
	mqtt = __webpack_require__(16)
	var semver_range = '~' + __webpack_require__(79).version;
	
	// for dev, when it slows down the browser
	var media_cleanup_callbacks = []
	var add_media_cleanup = function(callback, context) {
	    media_cleanup_callbacks.push(_.bind(callback, context))
	}
	window.media_cleanup = function() {
	    _.each(media_cleanup_callbacks, function(callback) {
	        callback()
	    })
	    media_cleanup_callbacks = []
	}
	var MediaStreamModel = widgets.DOMWidgetModel.extend({
	    defaults: function() {
	        return _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
	            _model_name: 'MediaStreamModel',
	            _view_name: 'MediaStreamView',
	            _model_module: 'jupyter-webrtc',
	            _view_module: 'jupyter-webrtc',
	            _model_module_version: semver_range,
	             _view_module_version: semver_range,
	         })
	    },
	    initialize: function() {
	        MediaStreamModel.__super__.initialize.apply(this, arguments);
	        // we don't have any stream
	        //this.stream = Promise.resolve(null)
	        this.stream = new Promise((resolve, reject) => {
	            this.stream_resolved = resolve;
	        })
	    }
	});
	
	var MediaStreamView = widgets.DOMWidgetView.extend({
	
	    initialize: function() {
	        var el = document.createElement('video')
	        el.setAttribute('autoplay', '')
	        window.last_media_view = this;
	        this.setElement(el);
	        MediaStreamView.__super__.initialize.apply(this, arguments);
	    },
	
	    render: function() {
	        var that = this;
	        that.model.stream.then(function(stream) {
	            that.el.srcObject = stream;
	            that.el.play()
	        })
	    }
	
	});
	
	var CameraStreamModel = MediaStreamModel.extend({
	    defaults: function() {
	        return _.extend(MediaStreamModel.prototype.defaults(), {
	            _model_name: 'CameraStreamModel',
	            audio: true,
	            video: true
	        })
	    },
	    initialize: function() {
	        CameraStreamModel.__super__.initialize.apply(this, arguments);
	        this.stream = navigator.mediaDevices.getUserMedia({audio: this.get('audio'), video: this.get('video')});
	        window.last_camera_stream = this;
	        this.on('msg:custom', _.bind(this.custom_msg, this));
	    },
	    custom_msg: function(content) {
	        if(content.msg == 'close') {
	            this.close()
	        }
	    },
	    close: function() {
	        return this.stream.then((stream) => {
	            stream.getTracks().forEach((track) => {
	                track.stop()
	            })
	        })
	    }
	});
	
	var VideoStreamModel = MediaStreamModel.extend({
	    defaults: function() {
	        return _.extend(MediaStreamModel.prototype.defaults(), {
	            _model_name: 'VideoStreamModel',
	            //_view_name: 'VideoView',
	            url: 'https://webrtc.github.io/samples/src/video/chrome.mp4',
	            //controls: true,
	            play: true,
	            loop: true,
	            data: null
	        })
	    },
	    initialize: function() {
	        // Get the camera permissions
	        VideoStreamModel.__super__.initialize.apply(this, arguments);
	        window.last_video = this
	        this.video = document.createElement('video')
	        this.source = document.createElement('source')
	        if(this.get('url')) {
	            this.source.setAttribute('src', this.get('url'))
	            this.video.appendChild(this.source)
	        }
	        if(this.get('data')) {
	            var ar = new Uint8Array(last_video.get('data').buffer)
	            this.video.src = window.URL.createObjectURL(new Blob([ar]));
	        }
	        var that = this
	        this.stream = new Promise((resolve, reject) => {
	            that.stream_resolved = resolve;
	        })
	        this.capture_stream()
	        this.on('change:play', this.update_play, this)
	        this.on('change:loop', this.update_loop, this)
	        add_media_cleanup(function() {
	            this.set('play', false)
	            console.log('cleanup: stopped video')
	            this.stream.then((stream) => {
	                stream.getTracks().forEach((track) => track.stop())
	            })
	        }, this)
	    },
	    capture_stream: function() {
	        if(this.video.captureStream || this.video.mozCaptureStream) {
	            // following https://github.com/webrtc/samples/blob/gh-pages/src/content/capture/video-pc/js/main.js
	            var make_stream = _.once(_.bind(function() {
	                if(this.video.captureStream) {
	                    console.info('normal captureStream')
	                    this.stream_resolved(this.video.captureStream())
	                } else if(this.video.mozCaptureStream) {
	                    console.info('falling back to mozCaptureStream')
	                    this.stream_resolved(this.video.mozCaptureStream())
	                }
	            }, this))
	            // see https://github.com/webrtc/samples/pull/853
	            this.video.oncanplay = make_stream
	            //this.video.onplay = make_stream
	            if(this.video.readyState >= 3) {
	                make_stream()
	            }
	            //this.stream = Promise.resolve(this.video.captureStream())
	            this.update_play()
	            this.update_loop()
	        } else {
	            console.log('captureStream not supported for this browser')
	        }
	    },
	    update_play: function() {
	        if(this.get('play'))
	            this.video.play()
	        else
	            this.video.pause()
	        console.log('play/pause', this.get('play'))
	    },
	    update_loop: function() {
	        this.video.loop = this.get('loop')
	        console.log('loop', this.get('loop'))
	    }
	});
	
	var WebRTCRoomModel = widgets.DOMWidgetModel.extend({
	    defaults: function() {
	        return _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
	            _model_name: 'WebRTCRoomModel',
	            //_view_name: 'WebRTCRoomView',
	            _model_module: 'jupyter-webrtc',
	            //_view_module: 'jupyter-webrtc',
	            _model_module_version: semver_range,
	            _view_module_version: semver_range,
	            room: 'room',
	            stream: null,
	            id: widgets.uuid(),
	            nickname: 'anonymous',
	            peers: [],
	            streams: []
	        })
	    },
	    log: function() {
	        var args = [this.get('nickname') + ' ' +this.get('id') +': ']
	        args = args.concat(Array.prototype.slice.call(arguments))
	        console.log.apply(null, args);
	    },
	    initialize: function() {
	        WebRTCRoomModel.__super__.initialize.apply(this, arguments);
	        this.set('id',  widgets.uuid())
	        this.id = this.get('id')
	        this.room = this.get('room')
	        this.peers = {} // id (string) to WebRTCPeerModel
	        window['last_webrtc_room_' + this.id] = this
	        var stream = this.get('stream')
	        if(stream) {
	            this.set('streams', [stream])
	        }
	        this.save_changes()
	        this.on('msg:custom', _.bind(this.custom_msg, this));
	    },
	    custom_msg: function(content) {
	        if(content.msg == 'close') {
	            this.close()
	        }
	    },
	    close: function() {
	        this.get('peers').forEach((peer) => peer.close())
	    },
	    create_peer: function(from_id) {
	        return this.widget_manager.new_widget({
	                model_name: 'WebRTCPeerModel',
	                model_module: 'jupyter-webrtc',
	                model_module_version: semver_range,
	                view_name: 'WebRTCPeerView',
	                view_module: 'jupyter-webrtc',
	                view_module_version: semver_range,
	                widget_class: 'webrtc.WebRTCPeerModel', // ipywidgets6
	            }, {
	                stream_local: this.get('stream'),
	                id_local: this.get('id'),
	                id_remote: from_id
	        }).then(_.bind(function(peer) {
	            peer.peer_msg_send = _.bind(function(msg) {
	                msg.id = this.get('id')
	                msg.to = from_id
	                this.log('send to peer', msg)
	                //console.log('sending to room', msg, from_id)
	                peer.save_changes()
	                this.room_msg_send(msg)
	            }, this)
	            return peer
	        }, this))
	    },
	    listen_to_remote_stream: function(peer) {
	        peer.on('change:stream_remote', _.once(_.bind(function(){
	            this.log('add remote stream')
	            var streams = this.get('streams').slice()
	            var stream = peer.get('stream_remote')
	            streams.push(stream)
	            this.set('streams', streams)
	            this.save_changes()
	        }, this)))
	        peer.on('change:connected', _.bind(function() {
	            var connected = peer.get('connected')
	            this.log('changed connected status for ', peer.get('id_remote'), 'to', connected)
	            if(!connected) {
	                var streams = this.get('streams').slice()
	                var stream = peer.get('stream_remote')
	                streams = _.without(streams, stream)
	                this.set('streams', streams)
	
	                var peers = this.get('peers').slice()
	                peers = _.without(peers, peer)
	                this.set('peers', peers)
	
	                delete this.peers[peer.get('id_remote')]
	                this.save_changes()
	            }
	        }, this))
	    },
	    on_room_msg: function(msg) {
	        var from_id = msg.id;
	        if(msg.id == this.id)
	            return; // skip my own msg'es
	        if(msg.type == 'join') {
	            this.log('join from', msg.id)
	            this.peers[from_id] = this.create_peer(from_id).then(_.bind(function(peer) {
	                this.listen_to_remote_stream(peer)
	                peer.join().then(_.bind(function() {
	                    var peers = this.get('peers').slice()
	                    peers.push(peer)
	                    this.set('peers', peers)
	                    this.save_changes()
	                }, this))
	                return peer
	            }, this))
	            this.log(': added peer', from_id)
	            return peer;
	        } else if(msg.id) {
	            if(msg.to != this.id) {
	                return
	            }
	            if(!this.peers[msg.id]) {
	                this.peers[from_id] = this.create_peer(from_id).then(_.bind(function(peer) {
	                    this.listen_to_remote_stream(peer)
	                    var peers = this.get('peers').slice()
	                    peers.push(peer)
	                    this.set('peers', peers)
	                    this.save_changes()
	                    return peer
	                }, this))
	                this.log('added peer', from_id)
	            }
	            var peer = this.peers[msg.id]
	            if(peer) {
	                //console.log(this.id, ': peer', msg.id, peer, this, this.cid)
	                peer.then(_.bind(function(peer) {
	                    this.log('sending from', msg.id, ' to', msg.to, msg)
	                    peer.on_peer_msg(msg)
	                }, this))
	            } else {
	                console.error('sending to unknown peer', msg.id)
	            }
	        } else {
	            console.error('expected a to id to be present')
	        }
	    }
	}, {
	serializers: _.extend({
	    stream: { deserialize: widgets.unpack_models },
	    peers: { deserialize: widgets.unpack_models },
	    }, widgets.DOMWidgetModel.serializers)
	});
	
	var global_rooms = {}
	
	var WebRTCRoomLocalModel = WebRTCRoomModel.extend({
	    defaults: function() {
	        return _.extend(WebRTCRoomModel.prototype.defaults(), {
	            _model_name: 'WebRTCRoomLocalModel',
	        })
	    },
	    initialize: function() {
	        WebRTCRoomLocalModel.__super__.initialize.apply(this, arguments);
	        this.join()
	    },
	    join: function() {
	        var room = this.get('room');
	        console.log('joining room', room)
	        var callbacks = global_rooms[room] || []
	        callbacks.push(_.bind(this.on_room_msg, this))
	        global_rooms[room] = callbacks
	        this.room_msg_send({type: 'join', id: this.get('id')})
	
	    },
	    room_msg_send: function(msg) {
	        var room = this.get('room');
	        console.log('send to room', room, msg, global_rooms[room])
	        _.each(global_rooms[room], function(callback) {
	            callback(msg)
	        })
	
	    },
	});
	
	var WebRTCRoomMqttModel = WebRTCRoomModel.extend({
	    defaults: function() {
	        return _.extend(WebRTCRoomModel.prototype.defaults(), {
	            _model_name: 'WebRTCRoomMqttModel',
	            server: 'wss://iot.eclipse.org:443/ws'
	        })
	    },
	    initialize: function() {
	        WebRTCRoomMqttModel.__super__.initialize.apply(this, arguments);
	        console.log('connecting to', this.get('server'))
	        this.mqtt_client = mqtt.connect(this.get('server'))
	        var client = this.mqtt_client
	        this.topic_join = 'jupyter-webrtc/' + this.get('room') +'/join'
	        //this.topic_present = 'jupyter-webrtc/' +this.room +'/present'
	        this.mqtt_client.on('connect', _.bind(function () {
	          client.subscribe(this.topic_join)
	          //client.subscribe(this.topic_present)
	          //client.publish('jupyter-webrtc/room-a/present', 'you|me', {retain:true})
	          //client.publish('jupyter-webrtc/room-a/join', 'Hello mqtt')
	        }, this))
	        client.on('message', _.bind(function (topic, message) {
	            var msg = JSON.parse(message)
	            console.log('msg received', message, msg)
	            if(topic == this.topic_join) {
	                this.on_room_msg(msg)
	            }
	        }, this))
	        this.join()
	    },
	    join: function() {
	        this.room_msg_send({type: 'join', id: this.get('id')})
	
	    },
	    room_msg_send: function(msg) {
	        var text = JSON.stringify(msg)
	        console.log('send to mqtt channel', msg)
	        this.mqtt_client.publish(this.topic_join, text)
	    }
	});
	
	var WebRTCPeerModel = widgets.DOMWidgetModel.extend({
	    defaults: function() {
	        return _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
	            _model_name: 'WebRTCPeerModel',
	            _view_name: 'WebRTCPeerView',
	            _model_module: 'jupyter-webrtc',
	            _view_module: 'jupyter-webrtc',
	            _model_module_version: semver_range,
	            _view_module_version: semver_range
	        })
	    },
	    log: function() {
	        var args = [this.get('id') +': ']
	        args = args.concat(Array.prototype.slice.call(arguments))
	        console.log.apply(null, args);
	    },
	    on_peer_msg: function(msg) {
	        var info = msg;
	        var that = this;
	        this.log('peer msg', info)
	        if(info.sdp) {
	            // the other party send us the sdp
	            this.log(name, 'got sdp')
	            var sdp_remote = new RTCSessionDescription(info.sdp)
	            var remote_description_set = this.pc.setRemoteDescription(sdp_remote)
	            if(!this.initiator) {
	                console.log(this.get('id_local'), 'did not initiate, reply with answer')
	                // if we didn't initiate, we should respond with an answer
	                // now we create an answer, and send a sdp back
	                Promise.all([remote_description_set, this.tracks_added])
	                .then(() => this.pc.createAnswer())
	                .then((sdp) => {
	                    console.log('sending sdp', this.id)
	                    that.send_sdp(sdp)
	                    that.pc.setLocalDescription(sdp)
	                })
	            }
	        } else if (info.candidate) {
	            var c = new RTCIceCandidate(info.candidate);
	            this.pc.addIceCandidate(c)
	        }
	    },
	    initialize: function() {
	        WebRTCPeerModel.__super__.initialize.apply(this, arguments);
	
	        var that = this;
	        var id = this.id = this.get('id_local')
	        this.initiator = false
	
	        var pc_config = {"iceServers": [{"urls": ["stun:stun.l.google.com:19302", 'stun:stun1.l.google.com:19302', 'stun:stun2.l.google.com:19302']}]};
	        //var pc_config = null;
	        this.pc = new RTCPeerConnection(pc_config);
	
	        window['last_webrtc_'+id] = this
	        //this.other = null
	
	        if(this.get('stream_local')) {
	            this.tracks_added = new Promise((resolve, reject) => {
	                that.get('stream_local').stream.then((stream) => {
	                    console.log('add stream', stream)
	                    //this.pc.addStream(stream) (this crashes/hangs chrome)
	                    // so we use the addTrack api
	                    stream.getTracks().forEach(
	                        function(track) {
	                          that.pc.addTrack(
	                            track,
	                            stream
	                          );
	                        }
	                    );
	                    resolve()
	                }) // TODO: catch/reject?
	            })
	        } else {
	            console.log('no stream')
	            this.tracks_added = Promise.resolve()
	        }
	        this.tracks_added.then(() => console.log('tracks added'))
	        this.pc.onicecandidate = _.bind(function(event) {
	            console.log(this.id, 'onicecandidate', event.candidate)
	            this.event_candidate = event
	            this.send_ice_candidate(event.candidate)
	        }, this)
	        this.pc.onopen = _.bind(function() {
	            console.log('onopen', name)
	        }, this)
	        this.pc.onaddstream = _.bind(function(evt) {
	            console.log('onaddstream', name)
	            this.widget_manager.new_widget({
	                    model_name: 'MediaStreamModel',
	                    model_module: 'jupyter-webrtc',
	                    model_module_version: semver_range,
	                    view_name: 'MediaStreamView',
	                    view_module: 'jupyter-webrtc',
	                    view_module_version: semver_range,
	                    widget_class: 'webrtc.MediaStreamModel', // ipywidgets6
	                }).then(function(model) {
	                    model.stream = Promise.resolve(evt.stream); // TODO: not nice to just set the promise...
	                    that.set('stream_remote', model)
	                    //mo
	                    that.save_changes()
	                    console.log(that.id, ': added stream_remote')
	                    return model;
	                });
	        }, this)
	        this.pc.onconnecting = _.bind(function() {
	            console.log('onconnecting', name)
	        }, this)
	        this.pc.oniceconnectionstatechange = _.bind(function() {
	            console.log(this.id, 'ICE connection state', this.pc.iceConnectionState);
	            if(this.pc.iceConnectionState == 'disconnected') {
	                this.set('connected', false)
	                this.save_changes()
	            }
	            if(this.pc.iceConnectionState == 'connected') {
	                this.set('connected', true)
	                this.save_changes()
	            }
	            // TODO: can we recover from this?
	            if(this.pc.iceConnectionState == 'failed') {
	                this.set('connected', false)
	                this.save_changes()
	            }
	        }, this)
	        /*
	        this doesn't seem to exist in chrome at least, lets rely on ice state change above
	        this.pc.onconnectionstatechange = _.bind(function() {
	            console.log(this.id, 'connection state', this.pc.connectionState);
	            if(this.pc.connectionState == 'disconnected') {
	                this.set('connected', false)
	                this.save_changes()
	            }
	            if(this.pc.connectionState == 'connected') {
	                this.set('connected', true)
	                this.save_changes()
	            }
	        }, this)
	        */
	        this.on('msg:custom', _.bind(this.custom_msg, this));
	        //this.disconnect = _.once(_.bind(this.disconnect, this))
	        window.addEventListener('beforeunload', function () {
	            that.close()
	        }, false);
	    },
	    custom_msg: function(content) {
	        console.log('custom msg', content)
	        if(content.msg == 'connect') {
	            this.connect()
	        } else if(content.msg == 'close') {
	            this.close()
	        } else {
	            this.disconnect()
	        }
	    },
	    close: function() {
	        //console.log('disconnect')
	        this.pc.close() // does not trigger ice conncection status changes
	        this.set('connected', false)
	        this.save_changes()
	    },
	    join: function() {
	        this.initiator = true
	        var that = this;
	        var after_stream
	        return this.tracks_added.then(() => {
	            return new Promise((resolve, reject) => {
	                var id = that.get('id')
	                var offer = {
	                  offerToReceiveAudio: 1,
	                  offerToReceiveVideo: 1
	                };
	
	                this.pc.createOffer(offer)
	                .then((sdp)  => {
	                    console.log('set local desc');
	                    that.pc.setLocalDescription(sdp)
	                    console.log(that.id, 'send sdp')
	                    that.send_sdp(sdp)
	                    resolve()
	                })
	                .catch(e => {
	                    console.error(e)
	                    reject(e)
	                });
	                return that
	            })
	        })
	    },
	    send_sdp: function(sdp) {
	        this.broadcast({sdp:sdp})
	    },
	    send_ice_candidate: function(candidate) {
	        this.broadcast({candidate:candidate})
	    },
	    broadcast: function(msg) {
	        this.peer_msg_send(msg)
	
	    },
	}, {
	serializers: _.extend({
	    stream: { deserialize: widgets.unpack_models },
	    peers: { deserialize: widgets.unpack_models },
	    }, widgets.DOMWidgetModel.serializers)
	});
	
	var WebRTCPeerView = widgets.DOMWidgetView.extend({
	
	    initialize: function() {
	        var el = document.createElement('video')
	        window.last_media_view = this;
	        this.setElement(el);
	        WebRTCPeerView.__super__.initialize.apply(this, arguments);
	    },
	
	    render: function() {
	        var that = this;
	        that.model.stream.then(function(stream) {
	            that.el.srcObject = stream;
	            that.el.play()
	        })
	    }
	
	});
	
	var MediaRecorderModel = widgets.DOMWidgetModel.extend({
	    defaults: function() {
	        return _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
	            _model_name: 'MediaRecorderModel',
	            //_view_name: 'MediaStreamView',
	            _model_module: 'jupyter-webrtc',
	            //_view_module: 'jupyter-webrtc',
	            _model_module_version: semver_range,
	            //_view_module_version: semver_range,
	            record: false,
	            mime_type: 'video/webm'
	         })
	    },
	    initialize: function() {
	        MediaRecorderModel.__super__.initialize.apply(this, arguments);
	        window.last_media_recorder = this
	        var change_record = () => {
	            if(this.get('record')) {
	                this.record()
	            } else {
	                this.stop()
	            }
	        }
	        this.recorder = null;
	        this.chunks = []
	        this.on('change:record', change_record)
	    },
	    record: function() {
	        console.log('start recording')
	        var streamModel = this.get('stream');
	        if(!streamModel) {
	            console.error('no stream')
	            return
	        }
	        streamModel.stream.then((stream) => {
	            console.log('got stream, firing up recorder')
	            this.recorder = new MediaRecorder(stream, {
	              audioBitsPerSecond : 128000,
	              videoBitsPerSecond : 2500000,
	              mimeType : this.get('mime_type')
	            })
	            this.recorder.start()
	            this.recorder.ondataavailable = (e) => {
	                this.chunks.push(e.data);
	               console.log('got chunk of length', e.data.size)
	            }
	        })
	    },
	    stop: function() {
	        console.log('stopping recorder')
	        this.recorder.onstop = (e) => {
	            var recorder = this.recorder; // keep a local reference
	            var chunks = this.chunks; // and a (shallow) copy of the array of chunks
	            this.recorder = null; // before we set it to null
	            this.chunks = []
	            console.log('assembling blob')
	            var blob = new Blob(chunks, { 'type' : this.get('mime_type') });
	            //var audioURL = window.URL.createObjectURL(blob);
	            //  audio.src = audioURL;
	            window.last_blob = blob;
	            var reader = new FileReader()
	            reader.readAsArrayBuffer(blob)
	            reader.onloadend = () => {
	                window.last_result = reader.result
	                window.last_reader = reader
	                var bytes = new Uint8Array(reader.result)
	                console.log('assembled ', reader.result, reader.result.byteLength, chunks, this.chunks)
	                this.set('data', bytes)
	                this.save_changes()
	            }
	        }
	        this.recorder.stop() 
	    }
	}, {
	serializers: _.extend({
	    stream: { deserialize: widgets.unpack_models },
	    // serialise should be define, otherwise it takes the JSON path
	    data: { deserialize: (v) => v, serialize: (v) => v} ,
	    }, widgets.DOMWidgetModel.serializers)
	});
	
	module.exports = {
	    MediaStreamModel: MediaStreamModel,
	    MediaStreamView: MediaStreamView,
	    CameraStreamModel: CameraStreamModel,
	    VideoStreamModel:VideoStreamModel,
	    WebRTCPeerModel: WebRTCPeerModel,
	    WebRTCPeerView: WebRTCPeerView,
	    WebRTCRoomModel: WebRTCRoomModel,
	    WebRTCRoomLocalModel: WebRTCRoomLocalModel,
	    WebRTCRoomMqttModel: WebRTCRoomMqttModel,
	    MediaRecorderModel:MediaRecorderModel
	}


/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;//     Underscore.js 1.8.3
	//     http://underscorejs.org
	//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	//     Underscore may be freely distributed under the MIT license.
	
	(function() {
	
	  // Baseline setup
	  // --------------
	
	  // Establish the root object, `window` in the browser, or `exports` on the server.
	  var root = this;
	
	  // Save the previous value of the `_` variable.
	  var previousUnderscore = root._;
	
	  // Save bytes in the minified (but not gzipped) version:
	  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;
	
	  // Create quick reference variables for speed access to core prototypes.
	  var
	    push             = ArrayProto.push,
	    slice            = ArrayProto.slice,
	    toString         = ObjProto.toString,
	    hasOwnProperty   = ObjProto.hasOwnProperty;
	
	  // All **ECMAScript 5** native function implementations that we hope to use
	  // are declared here.
	  var
	    nativeIsArray      = Array.isArray,
	    nativeKeys         = Object.keys,
	    nativeBind         = FuncProto.bind,
	    nativeCreate       = Object.create;
	
	  // Naked function reference for surrogate-prototype-swapping.
	  var Ctor = function(){};
	
	  // Create a safe reference to the Underscore object for use below.
	  var _ = function(obj) {
	    if (obj instanceof _) return obj;
	    if (!(this instanceof _)) return new _(obj);
	    this._wrapped = obj;
	  };
	
	  // Export the Underscore object for **Node.js**, with
	  // backwards-compatibility for the old `require()` API. If we're in
	  // the browser, add `_` as a global object.
	  if (true) {
	    if (typeof module !== 'undefined' && module.exports) {
	      exports = module.exports = _;
	    }
	    exports._ = _;
	  } else {
	    root._ = _;
	  }
	
	  // Current version.
	  _.VERSION = '1.8.3';
	
	  // Internal function that returns an efficient (for current engines) version
	  // of the passed-in callback, to be repeatedly applied in other Underscore
	  // functions.
	  var optimizeCb = function(func, context, argCount) {
	    if (context === void 0) return func;
	    switch (argCount == null ? 3 : argCount) {
	      case 1: return function(value) {
	        return func.call(context, value);
	      };
	      case 2: return function(value, other) {
	        return func.call(context, value, other);
	      };
	      case 3: return function(value, index, collection) {
	        return func.call(context, value, index, collection);
	      };
	      case 4: return function(accumulator, value, index, collection) {
	        return func.call(context, accumulator, value, index, collection);
	      };
	    }
	    return function() {
	      return func.apply(context, arguments);
	    };
	  };
	
	  // A mostly-internal function to generate callbacks that can be applied
	  // to each element in a collection, returning the desired result — either
	  // identity, an arbitrary callback, a property matcher, or a property accessor.
	  var cb = function(value, context, argCount) {
	    if (value == null) return _.identity;
	    if (_.isFunction(value)) return optimizeCb(value, context, argCount);
	    if (_.isObject(value)) return _.matcher(value);
	    return _.property(value);
	  };
	  _.iteratee = function(value, context) {
	    return cb(value, context, Infinity);
	  };
	
	  // An internal function for creating assigner functions.
	  var createAssigner = function(keysFunc, undefinedOnly) {
	    return function(obj) {
	      var length = arguments.length;
	      if (length < 2 || obj == null) return obj;
	      for (var index = 1; index < length; index++) {
	        var source = arguments[index],
	            keys = keysFunc(source),
	            l = keys.length;
	        for (var i = 0; i < l; i++) {
	          var key = keys[i];
	          if (!undefinedOnly || obj[key] === void 0) obj[key] = source[key];
	        }
	      }
	      return obj;
	    };
	  };
	
	  // An internal function for creating a new object that inherits from another.
	  var baseCreate = function(prototype) {
	    if (!_.isObject(prototype)) return {};
	    if (nativeCreate) return nativeCreate(prototype);
	    Ctor.prototype = prototype;
	    var result = new Ctor;
	    Ctor.prototype = null;
	    return result;
	  };
	
	  var property = function(key) {
	    return function(obj) {
	      return obj == null ? void 0 : obj[key];
	    };
	  };
	
	  // Helper for collection methods to determine whether a collection
	  // should be iterated as an array or as an object
	  // Related: http://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength
	  // Avoids a very nasty iOS 8 JIT bug on ARM-64. #2094
	  var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;
	  var getLength = property('length');
	  var isArrayLike = function(collection) {
	    var length = getLength(collection);
	    return typeof length == 'number' && length >= 0 && length <= MAX_ARRAY_INDEX;
	  };
	
	  // Collection Functions
	  // --------------------
	
	  // The cornerstone, an `each` implementation, aka `forEach`.
	  // Handles raw objects in addition to array-likes. Treats all
	  // sparse array-likes as if they were dense.
	  _.each = _.forEach = function(obj, iteratee, context) {
	    iteratee = optimizeCb(iteratee, context);
	    var i, length;
	    if (isArrayLike(obj)) {
	      for (i = 0, length = obj.length; i < length; i++) {
	        iteratee(obj[i], i, obj);
	      }
	    } else {
	      var keys = _.keys(obj);
	      for (i = 0, length = keys.length; i < length; i++) {
	        iteratee(obj[keys[i]], keys[i], obj);
	      }
	    }
	    return obj;
	  };
	
	  // Return the results of applying the iteratee to each element.
	  _.map = _.collect = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length,
	        results = Array(length);
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      results[index] = iteratee(obj[currentKey], currentKey, obj);
	    }
	    return results;
	  };
	
	  // Create a reducing function iterating left or right.
	  function createReduce(dir) {
	    // Optimized iterator function as using arguments.length
	    // in the main function will deoptimize the, see #1991.
	    function iterator(obj, iteratee, memo, keys, index, length) {
	      for (; index >= 0 && index < length; index += dir) {
	        var currentKey = keys ? keys[index] : index;
	        memo = iteratee(memo, obj[currentKey], currentKey, obj);
	      }
	      return memo;
	    }
	
	    return function(obj, iteratee, memo, context) {
	      iteratee = optimizeCb(iteratee, context, 4);
	      var keys = !isArrayLike(obj) && _.keys(obj),
	          length = (keys || obj).length,
	          index = dir > 0 ? 0 : length - 1;
	      // Determine the initial value if none is provided.
	      if (arguments.length < 3) {
	        memo = obj[keys ? keys[index] : index];
	        index += dir;
	      }
	      return iterator(obj, iteratee, memo, keys, index, length);
	    };
	  }
	
	  // **Reduce** builds up a single result from a list of values, aka `inject`,
	  // or `foldl`.
	  _.reduce = _.foldl = _.inject = createReduce(1);
	
	  // The right-associative version of reduce, also known as `foldr`.
	  _.reduceRight = _.foldr = createReduce(-1);
	
	  // Return the first value which passes a truth test. Aliased as `detect`.
	  _.find = _.detect = function(obj, predicate, context) {
	    var key;
	    if (isArrayLike(obj)) {
	      key = _.findIndex(obj, predicate, context);
	    } else {
	      key = _.findKey(obj, predicate, context);
	    }
	    if (key !== void 0 && key !== -1) return obj[key];
	  };
	
	  // Return all the elements that pass a truth test.
	  // Aliased as `select`.
	  _.filter = _.select = function(obj, predicate, context) {
	    var results = [];
	    predicate = cb(predicate, context);
	    _.each(obj, function(value, index, list) {
	      if (predicate(value, index, list)) results.push(value);
	    });
	    return results;
	  };
	
	  // Return all the elements for which a truth test fails.
	  _.reject = function(obj, predicate, context) {
	    return _.filter(obj, _.negate(cb(predicate)), context);
	  };
	
	  // Determine whether all of the elements match a truth test.
	  // Aliased as `all`.
	  _.every = _.all = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length;
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      if (!predicate(obj[currentKey], currentKey, obj)) return false;
	    }
	    return true;
	  };
	
	  // Determine if at least one element in the object matches a truth test.
	  // Aliased as `any`.
	  _.some = _.any = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length;
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      if (predicate(obj[currentKey], currentKey, obj)) return true;
	    }
	    return false;
	  };
	
	  // Determine if the array or object contains a given item (using `===`).
	  // Aliased as `includes` and `include`.
	  _.contains = _.includes = _.include = function(obj, item, fromIndex, guard) {
	    if (!isArrayLike(obj)) obj = _.values(obj);
	    if (typeof fromIndex != 'number' || guard) fromIndex = 0;
	    return _.indexOf(obj, item, fromIndex) >= 0;
	  };
	
	  // Invoke a method (with arguments) on every item in a collection.
	  _.invoke = function(obj, method) {
	    var args = slice.call(arguments, 2);
	    var isFunc = _.isFunction(method);
	    return _.map(obj, function(value) {
	      var func = isFunc ? method : value[method];
	      return func == null ? func : func.apply(value, args);
	    });
	  };
	
	  // Convenience version of a common use case of `map`: fetching a property.
	  _.pluck = function(obj, key) {
	    return _.map(obj, _.property(key));
	  };
	
	  // Convenience version of a common use case of `filter`: selecting only objects
	  // containing specific `key:value` pairs.
	  _.where = function(obj, attrs) {
	    return _.filter(obj, _.matcher(attrs));
	  };
	
	  // Convenience version of a common use case of `find`: getting the first object
	  // containing specific `key:value` pairs.
	  _.findWhere = function(obj, attrs) {
	    return _.find(obj, _.matcher(attrs));
	  };
	
	  // Return the maximum element (or element-based computation).
	  _.max = function(obj, iteratee, context) {
	    var result = -Infinity, lastComputed = -Infinity,
	        value, computed;
	    if (iteratee == null && obj != null) {
	      obj = isArrayLike(obj) ? obj : _.values(obj);
	      for (var i = 0, length = obj.length; i < length; i++) {
	        value = obj[i];
	        if (value > result) {
	          result = value;
	        }
	      }
	    } else {
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index, list) {
	        computed = iteratee(value, index, list);
	        if (computed > lastComputed || computed === -Infinity && result === -Infinity) {
	          result = value;
	          lastComputed = computed;
	        }
	      });
	    }
	    return result;
	  };
	
	  // Return the minimum element (or element-based computation).
	  _.min = function(obj, iteratee, context) {
	    var result = Infinity, lastComputed = Infinity,
	        value, computed;
	    if (iteratee == null && obj != null) {
	      obj = isArrayLike(obj) ? obj : _.values(obj);
	      for (var i = 0, length = obj.length; i < length; i++) {
	        value = obj[i];
	        if (value < result) {
	          result = value;
	        }
	      }
	    } else {
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index, list) {
	        computed = iteratee(value, index, list);
	        if (computed < lastComputed || computed === Infinity && result === Infinity) {
	          result = value;
	          lastComputed = computed;
	        }
	      });
	    }
	    return result;
	  };
	
	  // Shuffle a collection, using the modern version of the
	  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
	  _.shuffle = function(obj) {
	    var set = isArrayLike(obj) ? obj : _.values(obj);
	    var length = set.length;
	    var shuffled = Array(length);
	    for (var index = 0, rand; index < length; index++) {
	      rand = _.random(0, index);
	      if (rand !== index) shuffled[index] = shuffled[rand];
	      shuffled[rand] = set[index];
	    }
	    return shuffled;
	  };
	
	  // Sample **n** random values from a collection.
	  // If **n** is not specified, returns a single random element.
	  // The internal `guard` argument allows it to work with `map`.
	  _.sample = function(obj, n, guard) {
	    if (n == null || guard) {
	      if (!isArrayLike(obj)) obj = _.values(obj);
	      return obj[_.random(obj.length - 1)];
	    }
	    return _.shuffle(obj).slice(0, Math.max(0, n));
	  };
	
	  // Sort the object's values by a criterion produced by an iteratee.
	  _.sortBy = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    return _.pluck(_.map(obj, function(value, index, list) {
	      return {
	        value: value,
	        index: index,
	        criteria: iteratee(value, index, list)
	      };
	    }).sort(function(left, right) {
	      var a = left.criteria;
	      var b = right.criteria;
	      if (a !== b) {
	        if (a > b || a === void 0) return 1;
	        if (a < b || b === void 0) return -1;
	      }
	      return left.index - right.index;
	    }), 'value');
	  };
	
	  // An internal function used for aggregate "group by" operations.
	  var group = function(behavior) {
	    return function(obj, iteratee, context) {
	      var result = {};
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index) {
	        var key = iteratee(value, index, obj);
	        behavior(result, value, key);
	      });
	      return result;
	    };
	  };
	
	  // Groups the object's values by a criterion. Pass either a string attribute
	  // to group by, or a function that returns the criterion.
	  _.groupBy = group(function(result, value, key) {
	    if (_.has(result, key)) result[key].push(value); else result[key] = [value];
	  });
	
	  // Indexes the object's values by a criterion, similar to `groupBy`, but for
	  // when you know that your index values will be unique.
	  _.indexBy = group(function(result, value, key) {
	    result[key] = value;
	  });
	
	  // Counts instances of an object that group by a certain criterion. Pass
	  // either a string attribute to count by, or a function that returns the
	  // criterion.
	  _.countBy = group(function(result, value, key) {
	    if (_.has(result, key)) result[key]++; else result[key] = 1;
	  });
	
	  // Safely create a real, live array from anything iterable.
	  _.toArray = function(obj) {
	    if (!obj) return [];
	    if (_.isArray(obj)) return slice.call(obj);
	    if (isArrayLike(obj)) return _.map(obj, _.identity);
	    return _.values(obj);
	  };
	
	  // Return the number of elements in an object.
	  _.size = function(obj) {
	    if (obj == null) return 0;
	    return isArrayLike(obj) ? obj.length : _.keys(obj).length;
	  };
	
	  // Split a collection into two arrays: one whose elements all satisfy the given
	  // predicate, and one whose elements all do not satisfy the predicate.
	  _.partition = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var pass = [], fail = [];
	    _.each(obj, function(value, key, obj) {
	      (predicate(value, key, obj) ? pass : fail).push(value);
	    });
	    return [pass, fail];
	  };
	
	  // Array Functions
	  // ---------------
	
	  // Get the first element of an array. Passing **n** will return the first N
	  // values in the array. Aliased as `head` and `take`. The **guard** check
	  // allows it to work with `_.map`.
	  _.first = _.head = _.take = function(array, n, guard) {
	    if (array == null) return void 0;
	    if (n == null || guard) return array[0];
	    return _.initial(array, array.length - n);
	  };
	
	  // Returns everything but the last entry of the array. Especially useful on
	  // the arguments object. Passing **n** will return all the values in
	  // the array, excluding the last N.
	  _.initial = function(array, n, guard) {
	    return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));
	  };
	
	  // Get the last element of an array. Passing **n** will return the last N
	  // values in the array.
	  _.last = function(array, n, guard) {
	    if (array == null) return void 0;
	    if (n == null || guard) return array[array.length - 1];
	    return _.rest(array, Math.max(0, array.length - n));
	  };
	
	  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
	  // Especially useful on the arguments object. Passing an **n** will return
	  // the rest N values in the array.
	  _.rest = _.tail = _.drop = function(array, n, guard) {
	    return slice.call(array, n == null || guard ? 1 : n);
	  };
	
	  // Trim out all falsy values from an array.
	  _.compact = function(array) {
	    return _.filter(array, _.identity);
	  };
	
	  // Internal implementation of a recursive `flatten` function.
	  var flatten = function(input, shallow, strict, startIndex) {
	    var output = [], idx = 0;
	    for (var i = startIndex || 0, length = getLength(input); i < length; i++) {
	      var value = input[i];
	      if (isArrayLike(value) && (_.isArray(value) || _.isArguments(value))) {
	        //flatten current level of array or arguments object
	        if (!shallow) value = flatten(value, shallow, strict);
	        var j = 0, len = value.length;
	        output.length += len;
	        while (j < len) {
	          output[idx++] = value[j++];
	        }
	      } else if (!strict) {
	        output[idx++] = value;
	      }
	    }
	    return output;
	  };
	
	  // Flatten out an array, either recursively (by default), or just one level.
	  _.flatten = function(array, shallow) {
	    return flatten(array, shallow, false);
	  };
	
	  // Return a version of the array that does not contain the specified value(s).
	  _.without = function(array) {
	    return _.difference(array, slice.call(arguments, 1));
	  };
	
	  // Produce a duplicate-free version of the array. If the array has already
	  // been sorted, you have the option of using a faster algorithm.
	  // Aliased as `unique`.
	  _.uniq = _.unique = function(array, isSorted, iteratee, context) {
	    if (!_.isBoolean(isSorted)) {
	      context = iteratee;
	      iteratee = isSorted;
	      isSorted = false;
	    }
	    if (iteratee != null) iteratee = cb(iteratee, context);
	    var result = [];
	    var seen = [];
	    for (var i = 0, length = getLength(array); i < length; i++) {
	      var value = array[i],
	          computed = iteratee ? iteratee(value, i, array) : value;
	      if (isSorted) {
	        if (!i || seen !== computed) result.push(value);
	        seen = computed;
	      } else if (iteratee) {
	        if (!_.contains(seen, computed)) {
	          seen.push(computed);
	          result.push(value);
	        }
	      } else if (!_.contains(result, value)) {
	        result.push(value);
	      }
	    }
	    return result;
	  };
	
	  // Produce an array that contains the union: each distinct element from all of
	  // the passed-in arrays.
	  _.union = function() {
	    return _.uniq(flatten(arguments, true, true));
	  };
	
	  // Produce an array that contains every item shared between all the
	  // passed-in arrays.
	  _.intersection = function(array) {
	    var result = [];
	    var argsLength = arguments.length;
	    for (var i = 0, length = getLength(array); i < length; i++) {
	      var item = array[i];
	      if (_.contains(result, item)) continue;
	      for (var j = 1; j < argsLength; j++) {
	        if (!_.contains(arguments[j], item)) break;
	      }
	      if (j === argsLength) result.push(item);
	    }
	    return result;
	  };
	
	  // Take the difference between one array and a number of other arrays.
	  // Only the elements present in just the first array will remain.
	  _.difference = function(array) {
	    var rest = flatten(arguments, true, true, 1);
	    return _.filter(array, function(value){
	      return !_.contains(rest, value);
	    });
	  };
	
	  // Zip together multiple lists into a single array -- elements that share
	  // an index go together.
	  _.zip = function() {
	    return _.unzip(arguments);
	  };
	
	  // Complement of _.zip. Unzip accepts an array of arrays and groups
	  // each array's elements on shared indices
	  _.unzip = function(array) {
	    var length = array && _.max(array, getLength).length || 0;
	    var result = Array(length);
	
	    for (var index = 0; index < length; index++) {
	      result[index] = _.pluck(array, index);
	    }
	    return result;
	  };
	
	  // Converts lists into objects. Pass either a single array of `[key, value]`
	  // pairs, or two parallel arrays of the same length -- one of keys, and one of
	  // the corresponding values.
	  _.object = function(list, values) {
	    var result = {};
	    for (var i = 0, length = getLength(list); i < length; i++) {
	      if (values) {
	        result[list[i]] = values[i];
	      } else {
	        result[list[i][0]] = list[i][1];
	      }
	    }
	    return result;
	  };
	
	  // Generator function to create the findIndex and findLastIndex functions
	  function createPredicateIndexFinder(dir) {
	    return function(array, predicate, context) {
	      predicate = cb(predicate, context);
	      var length = getLength(array);
	      var index = dir > 0 ? 0 : length - 1;
	      for (; index >= 0 && index < length; index += dir) {
	        if (predicate(array[index], index, array)) return index;
	      }
	      return -1;
	    };
	  }
	
	  // Returns the first index on an array-like that passes a predicate test
	  _.findIndex = createPredicateIndexFinder(1);
	  _.findLastIndex = createPredicateIndexFinder(-1);
	
	  // Use a comparator function to figure out the smallest index at which
	  // an object should be inserted so as to maintain order. Uses binary search.
	  _.sortedIndex = function(array, obj, iteratee, context) {
	    iteratee = cb(iteratee, context, 1);
	    var value = iteratee(obj);
	    var low = 0, high = getLength(array);
	    while (low < high) {
	      var mid = Math.floor((low + high) / 2);
	      if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;
	    }
	    return low;
	  };
	
	  // Generator function to create the indexOf and lastIndexOf functions
	  function createIndexFinder(dir, predicateFind, sortedIndex) {
	    return function(array, item, idx) {
	      var i = 0, length = getLength(array);
	      if (typeof idx == 'number') {
	        if (dir > 0) {
	            i = idx >= 0 ? idx : Math.max(idx + length, i);
	        } else {
	            length = idx >= 0 ? Math.min(idx + 1, length) : idx + length + 1;
	        }
	      } else if (sortedIndex && idx && length) {
	        idx = sortedIndex(array, item);
	        return array[idx] === item ? idx : -1;
	      }
	      if (item !== item) {
	        idx = predicateFind(slice.call(array, i, length), _.isNaN);
	        return idx >= 0 ? idx + i : -1;
	      }
	      for (idx = dir > 0 ? i : length - 1; idx >= 0 && idx < length; idx += dir) {
	        if (array[idx] === item) return idx;
	      }
	      return -1;
	    };
	  }
	
	  // Return the position of the first occurrence of an item in an array,
	  // or -1 if the item is not included in the array.
	  // If the array is large and already in sort order, pass `true`
	  // for **isSorted** to use binary search.
	  _.indexOf = createIndexFinder(1, _.findIndex, _.sortedIndex);
	  _.lastIndexOf = createIndexFinder(-1, _.findLastIndex);
	
	  // Generate an integer Array containing an arithmetic progression. A port of
	  // the native Python `range()` function. See
	  // [the Python documentation](http://docs.python.org/library/functions.html#range).
	  _.range = function(start, stop, step) {
	    if (stop == null) {
	      stop = start || 0;
	      start = 0;
	    }
	    step = step || 1;
	
	    var length = Math.max(Math.ceil((stop - start) / step), 0);
	    var range = Array(length);
	
	    for (var idx = 0; idx < length; idx++, start += step) {
	      range[idx] = start;
	    }
	
	    return range;
	  };
	
	  // Function (ahem) Functions
	  // ------------------
	
	  // Determines whether to execute a function as a constructor
	  // or a normal function with the provided arguments
	  var executeBound = function(sourceFunc, boundFunc, context, callingContext, args) {
	    if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);
	    var self = baseCreate(sourceFunc.prototype);
	    var result = sourceFunc.apply(self, args);
	    if (_.isObject(result)) return result;
	    return self;
	  };
	
	  // Create a function bound to a given object (assigning `this`, and arguments,
	  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
	  // available.
	  _.bind = function(func, context) {
	    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
	    if (!_.isFunction(func)) throw new TypeError('Bind must be called on a function');
	    var args = slice.call(arguments, 2);
	    var bound = function() {
	      return executeBound(func, bound, context, this, args.concat(slice.call(arguments)));
	    };
	    return bound;
	  };
	
	  // Partially apply a function by creating a version that has had some of its
	  // arguments pre-filled, without changing its dynamic `this` context. _ acts
	  // as a placeholder, allowing any combination of arguments to be pre-filled.
	  _.partial = function(func) {
	    var boundArgs = slice.call(arguments, 1);
	    var bound = function() {
	      var position = 0, length = boundArgs.length;
	      var args = Array(length);
	      for (var i = 0; i < length; i++) {
	        args[i] = boundArgs[i] === _ ? arguments[position++] : boundArgs[i];
	      }
	      while (position < arguments.length) args.push(arguments[position++]);
	      return executeBound(func, bound, this, this, args);
	    };
	    return bound;
	  };
	
	  // Bind a number of an object's methods to that object. Remaining arguments
	  // are the method names to be bound. Useful for ensuring that all callbacks
	  // defined on an object belong to it.
	  _.bindAll = function(obj) {
	    var i, length = arguments.length, key;
	    if (length <= 1) throw new Error('bindAll must be passed function names');
	    for (i = 1; i < length; i++) {
	      key = arguments[i];
	      obj[key] = _.bind(obj[key], obj);
	    }
	    return obj;
	  };
	
	  // Memoize an expensive function by storing its results.
	  _.memoize = function(func, hasher) {
	    var memoize = function(key) {
	      var cache = memoize.cache;
	      var address = '' + (hasher ? hasher.apply(this, arguments) : key);
	      if (!_.has(cache, address)) cache[address] = func.apply(this, arguments);
	      return cache[address];
	    };
	    memoize.cache = {};
	    return memoize;
	  };
	
	  // Delays a function for the given number of milliseconds, and then calls
	  // it with the arguments supplied.
	  _.delay = function(func, wait) {
	    var args = slice.call(arguments, 2);
	    return setTimeout(function(){
	      return func.apply(null, args);
	    }, wait);
	  };
	
	  // Defers a function, scheduling it to run after the current call stack has
	  // cleared.
	  _.defer = _.partial(_.delay, _, 1);
	
	  // Returns a function, that, when invoked, will only be triggered at most once
	  // during a given window of time. Normally, the throttled function will run
	  // as much as it can, without ever going more than once per `wait` duration;
	  // but if you'd like to disable the execution on the leading edge, pass
	  // `{leading: false}`. To disable execution on the trailing edge, ditto.
	  _.throttle = function(func, wait, options) {
	    var context, args, result;
	    var timeout = null;
	    var previous = 0;
	    if (!options) options = {};
	    var later = function() {
	      previous = options.leading === false ? 0 : _.now();
	      timeout = null;
	      result = func.apply(context, args);
	      if (!timeout) context = args = null;
	    };
	    return function() {
	      var now = _.now();
	      if (!previous && options.leading === false) previous = now;
	      var remaining = wait - (now - previous);
	      context = this;
	      args = arguments;
	      if (remaining <= 0 || remaining > wait) {
	        if (timeout) {
	          clearTimeout(timeout);
	          timeout = null;
	        }
	        previous = now;
	        result = func.apply(context, args);
	        if (!timeout) context = args = null;
	      } else if (!timeout && options.trailing !== false) {
	        timeout = setTimeout(later, remaining);
	      }
	      return result;
	    };
	  };
	
	  // Returns a function, that, as long as it continues to be invoked, will not
	  // be triggered. The function will be called after it stops being called for
	  // N milliseconds. If `immediate` is passed, trigger the function on the
	  // leading edge, instead of the trailing.
	  _.debounce = function(func, wait, immediate) {
	    var timeout, args, context, timestamp, result;
	
	    var later = function() {
	      var last = _.now() - timestamp;
	
	      if (last < wait && last >= 0) {
	        timeout = setTimeout(later, wait - last);
	      } else {
	        timeout = null;
	        if (!immediate) {
	          result = func.apply(context, args);
	          if (!timeout) context = args = null;
	        }
	      }
	    };
	
	    return function() {
	      context = this;
	      args = arguments;
	      timestamp = _.now();
	      var callNow = immediate && !timeout;
	      if (!timeout) timeout = setTimeout(later, wait);
	      if (callNow) {
	        result = func.apply(context, args);
	        context = args = null;
	      }
	
	      return result;
	    };
	  };
	
	  // Returns the first function passed as an argument to the second,
	  // allowing you to adjust arguments, run code before and after, and
	  // conditionally execute the original function.
	  _.wrap = function(func, wrapper) {
	    return _.partial(wrapper, func);
	  };
	
	  // Returns a negated version of the passed-in predicate.
	  _.negate = function(predicate) {
	    return function() {
	      return !predicate.apply(this, arguments);
	    };
	  };
	
	  // Returns a function that is the composition of a list of functions, each
	  // consuming the return value of the function that follows.
	  _.compose = function() {
	    var args = arguments;
	    var start = args.length - 1;
	    return function() {
	      var i = start;
	      var result = args[start].apply(this, arguments);
	      while (i--) result = args[i].call(this, result);
	      return result;
	    };
	  };
	
	  // Returns a function that will only be executed on and after the Nth call.
	  _.after = function(times, func) {
	    return function() {
	      if (--times < 1) {
	        return func.apply(this, arguments);
	      }
	    };
	  };
	
	  // Returns a function that will only be executed up to (but not including) the Nth call.
	  _.before = function(times, func) {
	    var memo;
	    return function() {
	      if (--times > 0) {
	        memo = func.apply(this, arguments);
	      }
	      if (times <= 1) func = null;
	      return memo;
	    };
	  };
	
	  // Returns a function that will be executed at most one time, no matter how
	  // often you call it. Useful for lazy initialization.
	  _.once = _.partial(_.before, 2);
	
	  // Object Functions
	  // ----------------
	
	  // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.
	  var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');
	  var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',
	                      'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];
	
	  function collectNonEnumProps(obj, keys) {
	    var nonEnumIdx = nonEnumerableProps.length;
	    var constructor = obj.constructor;
	    var proto = (_.isFunction(constructor) && constructor.prototype) || ObjProto;
	
	    // Constructor is a special case.
	    var prop = 'constructor';
	    if (_.has(obj, prop) && !_.contains(keys, prop)) keys.push(prop);
	
	    while (nonEnumIdx--) {
	      prop = nonEnumerableProps[nonEnumIdx];
	      if (prop in obj && obj[prop] !== proto[prop] && !_.contains(keys, prop)) {
	        keys.push(prop);
	      }
	    }
	  }
	
	  // Retrieve the names of an object's own properties.
	  // Delegates to **ECMAScript 5**'s native `Object.keys`
	  _.keys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    if (nativeKeys) return nativeKeys(obj);
	    var keys = [];
	    for (var key in obj) if (_.has(obj, key)) keys.push(key);
	    // Ahem, IE < 9.
	    if (hasEnumBug) collectNonEnumProps(obj, keys);
	    return keys;
	  };
	
	  // Retrieve all the property names of an object.
	  _.allKeys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    var keys = [];
	    for (var key in obj) keys.push(key);
	    // Ahem, IE < 9.
	    if (hasEnumBug) collectNonEnumProps(obj, keys);
	    return keys;
	  };
	
	  // Retrieve the values of an object's properties.
	  _.values = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var values = Array(length);
	    for (var i = 0; i < length; i++) {
	      values[i] = obj[keys[i]];
	    }
	    return values;
	  };
	
	  // Returns the results of applying the iteratee to each element of the object
	  // In contrast to _.map it returns an object
	  _.mapObject = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    var keys =  _.keys(obj),
	          length = keys.length,
	          results = {},
	          currentKey;
	      for (var index = 0; index < length; index++) {
	        currentKey = keys[index];
	        results[currentKey] = iteratee(obj[currentKey], currentKey, obj);
	      }
	      return results;
	  };
	
	  // Convert an object into a list of `[key, value]` pairs.
	  _.pairs = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var pairs = Array(length);
	    for (var i = 0; i < length; i++) {
	      pairs[i] = [keys[i], obj[keys[i]]];
	    }
	    return pairs;
	  };
	
	  // Invert the keys and values of an object. The values must be serializable.
	  _.invert = function(obj) {
	    var result = {};
	    var keys = _.keys(obj);
	    for (var i = 0, length = keys.length; i < length; i++) {
	      result[obj[keys[i]]] = keys[i];
	    }
	    return result;
	  };
	
	  // Return a sorted list of the function names available on the object.
	  // Aliased as `methods`
	  _.functions = _.methods = function(obj) {
	    var names = [];
	    for (var key in obj) {
	      if (_.isFunction(obj[key])) names.push(key);
	    }
	    return names.sort();
	  };
	
	  // Extend a given object with all the properties in passed-in object(s).
	  _.extend = createAssigner(_.allKeys);
	
	  // Assigns a given object with all the own properties in the passed-in object(s)
	  // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)
	  _.extendOwn = _.assign = createAssigner(_.keys);
	
	  // Returns the first key on an object that passes a predicate test
	  _.findKey = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = _.keys(obj), key;
	    for (var i = 0, length = keys.length; i < length; i++) {
	      key = keys[i];
	      if (predicate(obj[key], key, obj)) return key;
	    }
	  };
	
	  // Return a copy of the object only containing the whitelisted properties.
	  _.pick = function(object, oiteratee, context) {
	    var result = {}, obj = object, iteratee, keys;
	    if (obj == null) return result;
	    if (_.isFunction(oiteratee)) {
	      keys = _.allKeys(obj);
	      iteratee = optimizeCb(oiteratee, context);
	    } else {
	      keys = flatten(arguments, false, false, 1);
	      iteratee = function(value, key, obj) { return key in obj; };
	      obj = Object(obj);
	    }
	    for (var i = 0, length = keys.length; i < length; i++) {
	      var key = keys[i];
	      var value = obj[key];
	      if (iteratee(value, key, obj)) result[key] = value;
	    }
	    return result;
	  };
	
	   // Return a copy of the object without the blacklisted properties.
	  _.omit = function(obj, iteratee, context) {
	    if (_.isFunction(iteratee)) {
	      iteratee = _.negate(iteratee);
	    } else {
	      var keys = _.map(flatten(arguments, false, false, 1), String);
	      iteratee = function(value, key) {
	        return !_.contains(keys, key);
	      };
	    }
	    return _.pick(obj, iteratee, context);
	  };
	
	  // Fill in a given object with default properties.
	  _.defaults = createAssigner(_.allKeys, true);
	
	  // Creates an object that inherits from the given prototype object.
	  // If additional properties are provided then they will be added to the
	  // created object.
	  _.create = function(prototype, props) {
	    var result = baseCreate(prototype);
	    if (props) _.extendOwn(result, props);
	    return result;
	  };
	
	  // Create a (shallow-cloned) duplicate of an object.
	  _.clone = function(obj) {
	    if (!_.isObject(obj)) return obj;
	    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
	  };
	
	  // Invokes interceptor with the obj, and then returns obj.
	  // The primary purpose of this method is to "tap into" a method chain, in
	  // order to perform operations on intermediate results within the chain.
	  _.tap = function(obj, interceptor) {
	    interceptor(obj);
	    return obj;
	  };
	
	  // Returns whether an object has a given set of `key:value` pairs.
	  _.isMatch = function(object, attrs) {
	    var keys = _.keys(attrs), length = keys.length;
	    if (object == null) return !length;
	    var obj = Object(object);
	    for (var i = 0; i < length; i++) {
	      var key = keys[i];
	      if (attrs[key] !== obj[key] || !(key in obj)) return false;
	    }
	    return true;
	  };
	
	
	  // Internal recursive comparison function for `isEqual`.
	  var eq = function(a, b, aStack, bStack) {
	    // Identical objects are equal. `0 === -0`, but they aren't identical.
	    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
	    if (a === b) return a !== 0 || 1 / a === 1 / b;
	    // A strict comparison is necessary because `null == undefined`.
	    if (a == null || b == null) return a === b;
	    // Unwrap any wrapped objects.
	    if (a instanceof _) a = a._wrapped;
	    if (b instanceof _) b = b._wrapped;
	    // Compare `[[Class]]` names.
	    var className = toString.call(a);
	    if (className !== toString.call(b)) return false;
	    switch (className) {
	      // Strings, numbers, regular expressions, dates, and booleans are compared by value.
	      case '[object RegExp]':
	      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
	      case '[object String]':
	        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
	        // equivalent to `new String("5")`.
	        return '' + a === '' + b;
	      case '[object Number]':
	        // `NaN`s are equivalent, but non-reflexive.
	        // Object(NaN) is equivalent to NaN
	        if (+a !== +a) return +b !== +b;
	        // An `egal` comparison is performed for other numeric values.
	        return +a === 0 ? 1 / +a === 1 / b : +a === +b;
	      case '[object Date]':
	      case '[object Boolean]':
	        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
	        // millisecond representations. Note that invalid dates with millisecond representations
	        // of `NaN` are not equivalent.
	        return +a === +b;
	    }
	
	    var areArrays = className === '[object Array]';
	    if (!areArrays) {
	      if (typeof a != 'object' || typeof b != 'object') return false;
	
	      // Objects with different constructors are not equivalent, but `Object`s or `Array`s
	      // from different frames are.
	      var aCtor = a.constructor, bCtor = b.constructor;
	      if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor &&
	                               _.isFunction(bCtor) && bCtor instanceof bCtor)
	                          && ('constructor' in a && 'constructor' in b)) {
	        return false;
	      }
	    }
	    // Assume equality for cyclic structures. The algorithm for detecting cyclic
	    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
	
	    // Initializing stack of traversed objects.
	    // It's done here since we only need them for objects and arrays comparison.
	    aStack = aStack || [];
	    bStack = bStack || [];
	    var length = aStack.length;
	    while (length--) {
	      // Linear search. Performance is inversely proportional to the number of
	      // unique nested structures.
	      if (aStack[length] === a) return bStack[length] === b;
	    }
	
	    // Add the first object to the stack of traversed objects.
	    aStack.push(a);
	    bStack.push(b);
	
	    // Recursively compare objects and arrays.
	    if (areArrays) {
	      // Compare array lengths to determine if a deep comparison is necessary.
	      length = a.length;
	      if (length !== b.length) return false;
	      // Deep compare the contents, ignoring non-numeric properties.
	      while (length--) {
	        if (!eq(a[length], b[length], aStack, bStack)) return false;
	      }
	    } else {
	      // Deep compare objects.
	      var keys = _.keys(a), key;
	      length = keys.length;
	      // Ensure that both objects contain the same number of properties before comparing deep equality.
	      if (_.keys(b).length !== length) return false;
	      while (length--) {
	        // Deep compare each member
	        key = keys[length];
	        if (!(_.has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;
	      }
	    }
	    // Remove the first object from the stack of traversed objects.
	    aStack.pop();
	    bStack.pop();
	    return true;
	  };
	
	  // Perform a deep comparison to check if two objects are equal.
	  _.isEqual = function(a, b) {
	    return eq(a, b);
	  };
	
	  // Is a given array, string, or object empty?
	  // An "empty" object has no enumerable own-properties.
	  _.isEmpty = function(obj) {
	    if (obj == null) return true;
	    if (isArrayLike(obj) && (_.isArray(obj) || _.isString(obj) || _.isArguments(obj))) return obj.length === 0;
	    return _.keys(obj).length === 0;
	  };
	
	  // Is a given value a DOM element?
	  _.isElement = function(obj) {
	    return !!(obj && obj.nodeType === 1);
	  };
	
	  // Is a given value an array?
	  // Delegates to ECMA5's native Array.isArray
	  _.isArray = nativeIsArray || function(obj) {
	    return toString.call(obj) === '[object Array]';
	  };
	
	  // Is a given variable an object?
	  _.isObject = function(obj) {
	    var type = typeof obj;
	    return type === 'function' || type === 'object' && !!obj;
	  };
	
	  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp, isError.
	  _.each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp', 'Error'], function(name) {
	    _['is' + name] = function(obj) {
	      return toString.call(obj) === '[object ' + name + ']';
	    };
	  });
	
	  // Define a fallback version of the method in browsers (ahem, IE < 9), where
	  // there isn't any inspectable "Arguments" type.
	  if (!_.isArguments(arguments)) {
	    _.isArguments = function(obj) {
	      return _.has(obj, 'callee');
	    };
	  }
	
	  // Optimize `isFunction` if appropriate. Work around some typeof bugs in old v8,
	  // IE 11 (#1621), and in Safari 8 (#1929).
	  if (typeof /./ != 'function' && typeof Int8Array != 'object') {
	    _.isFunction = function(obj) {
	      return typeof obj == 'function' || false;
	    };
	  }
	
	  // Is a given object a finite number?
	  _.isFinite = function(obj) {
	    return isFinite(obj) && !isNaN(parseFloat(obj));
	  };
	
	  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
	  _.isNaN = function(obj) {
	    return _.isNumber(obj) && obj !== +obj;
	  };
	
	  // Is a given value a boolean?
	  _.isBoolean = function(obj) {
	    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
	  };
	
	  // Is a given value equal to null?
	  _.isNull = function(obj) {
	    return obj === null;
	  };
	
	  // Is a given variable undefined?
	  _.isUndefined = function(obj) {
	    return obj === void 0;
	  };
	
	  // Shortcut function for checking if an object has a given property directly
	  // on itself (in other words, not on a prototype).
	  _.has = function(obj, key) {
	    return obj != null && hasOwnProperty.call(obj, key);
	  };
	
	  // Utility Functions
	  // -----------------
	
	  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
	  // previous owner. Returns a reference to the Underscore object.
	  _.noConflict = function() {
	    root._ = previousUnderscore;
	    return this;
	  };
	
	  // Keep the identity function around for default iteratees.
	  _.identity = function(value) {
	    return value;
	  };
	
	  // Predicate-generating functions. Often useful outside of Underscore.
	  _.constant = function(value) {
	    return function() {
	      return value;
	    };
	  };
	
	  _.noop = function(){};
	
	  _.property = property;
	
	  // Generates a function for a given object that returns a given property.
	  _.propertyOf = function(obj) {
	    return obj == null ? function(){} : function(key) {
	      return obj[key];
	    };
	  };
	
	  // Returns a predicate for checking whether an object has a given set of
	  // `key:value` pairs.
	  _.matcher = _.matches = function(attrs) {
	    attrs = _.extendOwn({}, attrs);
	    return function(obj) {
	      return _.isMatch(obj, attrs);
	    };
	  };
	
	  // Run a function **n** times.
	  _.times = function(n, iteratee, context) {
	    var accum = Array(Math.max(0, n));
	    iteratee = optimizeCb(iteratee, context, 1);
	    for (var i = 0; i < n; i++) accum[i] = iteratee(i);
	    return accum;
	  };
	
	  // Return a random integer between min and max (inclusive).
	  _.random = function(min, max) {
	    if (max == null) {
	      max = min;
	      min = 0;
	    }
	    return min + Math.floor(Math.random() * (max - min + 1));
	  };
	
	  // A (possibly faster) way to get the current timestamp as an integer.
	  _.now = Date.now || function() {
	    return new Date().getTime();
	  };
	
	   // List of HTML entities for escaping.
	  var escapeMap = {
	    '&': '&amp;',
	    '<': '&lt;',
	    '>': '&gt;',
	    '"': '&quot;',
	    "'": '&#x27;',
	    '`': '&#x60;'
	  };
	  var unescapeMap = _.invert(escapeMap);
	
	  // Functions for escaping and unescaping strings to/from HTML interpolation.
	  var createEscaper = function(map) {
	    var escaper = function(match) {
	      return map[match];
	    };
	    // Regexes for identifying a key that needs to be escaped
	    var source = '(?:' + _.keys(map).join('|') + ')';
	    var testRegexp = RegExp(source);
	    var replaceRegexp = RegExp(source, 'g');
	    return function(string) {
	      string = string == null ? '' : '' + string;
	      return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;
	    };
	  };
	  _.escape = createEscaper(escapeMap);
	  _.unescape = createEscaper(unescapeMap);
	
	  // If the value of the named `property` is a function then invoke it with the
	  // `object` as context; otherwise, return it.
	  _.result = function(object, property, fallback) {
	    var value = object == null ? void 0 : object[property];
	    if (value === void 0) {
	      value = fallback;
	    }
	    return _.isFunction(value) ? value.call(object) : value;
	  };
	
	  // Generate a unique integer id (unique within the entire client session).
	  // Useful for temporary DOM ids.
	  var idCounter = 0;
	  _.uniqueId = function(prefix) {
	    var id = ++idCounter + '';
	    return prefix ? prefix + id : id;
	  };
	
	  // By default, Underscore uses ERB-style template delimiters, change the
	  // following template settings to use alternative delimiters.
	  _.templateSettings = {
	    evaluate    : /<%([\s\S]+?)%>/g,
	    interpolate : /<%=([\s\S]+?)%>/g,
	    escape      : /<%-([\s\S]+?)%>/g
	  };
	
	  // When customizing `templateSettings`, if you don't want to define an
	  // interpolation, evaluation or escaping regex, we need one that is
	  // guaranteed not to match.
	  var noMatch = /(.)^/;
	
	  // Certain characters need to be escaped so that they can be put into a
	  // string literal.
	  var escapes = {
	    "'":      "'",
	    '\\':     '\\',
	    '\r':     'r',
	    '\n':     'n',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };
	
	  var escaper = /\\|'|\r|\n|\u2028|\u2029/g;
	
	  var escapeChar = function(match) {
	    return '\\' + escapes[match];
	  };
	
	  // JavaScript micro-templating, similar to John Resig's implementation.
	  // Underscore templating handles arbitrary delimiters, preserves whitespace,
	  // and correctly escapes quotes within interpolated code.
	  // NB: `oldSettings` only exists for backwards compatibility.
	  _.template = function(text, settings, oldSettings) {
	    if (!settings && oldSettings) settings = oldSettings;
	    settings = _.defaults({}, settings, _.templateSettings);
	
	    // Combine delimiters into one regular expression via alternation.
	    var matcher = RegExp([
	      (settings.escape || noMatch).source,
	      (settings.interpolate || noMatch).source,
	      (settings.evaluate || noMatch).source
	    ].join('|') + '|$', 'g');
	
	    // Compile the template source, escaping string literals appropriately.
	    var index = 0;
	    var source = "__p+='";
	    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
	      source += text.slice(index, offset).replace(escaper, escapeChar);
	      index = offset + match.length;
	
	      if (escape) {
	        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
	      } else if (interpolate) {
	        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
	      } else if (evaluate) {
	        source += "';\n" + evaluate + "\n__p+='";
	      }
	
	      // Adobe VMs need the match returned to produce the correct offest.
	      return match;
	    });
	    source += "';\n";
	
	    // If a variable is not specified, place data values in local scope.
	    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';
	
	    source = "var __t,__p='',__j=Array.prototype.join," +
	      "print=function(){__p+=__j.call(arguments,'');};\n" +
	      source + 'return __p;\n';
	
	    try {
	      var render = new Function(settings.variable || 'obj', '_', source);
	    } catch (e) {
	      e.source = source;
	      throw e;
	    }
	
	    var template = function(data) {
	      return render.call(this, data, _);
	    };
	
	    // Provide the compiled source as a convenience for precompilation.
	    var argument = settings.variable || 'obj';
	    template.source = 'function(' + argument + '){\n' + source + '}';
	
	    return template;
	  };
	
	  // Add a "chain" function. Start chaining a wrapped Underscore object.
	  _.chain = function(obj) {
	    var instance = _(obj);
	    instance._chain = true;
	    return instance;
	  };
	
	  // OOP
	  // ---------------
	  // If Underscore is called as a function, it returns a wrapped object that
	  // can be used OO-style. This wrapper holds altered versions of all the
	  // underscore functions. Wrapped objects may be chained.
	
	  // Helper function to continue chaining intermediate results.
	  var result = function(instance, obj) {
	    return instance._chain ? _(obj).chain() : obj;
	  };
	
	  // Add your own custom functions to the Underscore object.
	  _.mixin = function(obj) {
	    _.each(_.functions(obj), function(name) {
	      var func = _[name] = obj[name];
	      _.prototype[name] = function() {
	        var args = [this._wrapped];
	        push.apply(args, arguments);
	        return result(this, func.apply(_, args));
	      };
	    });
	  };
	
	  // Add all of the Underscore functions to the wrapper object.
	  _.mixin(_);
	
	  // Add all mutator Array functions to the wrapper.
	  _.each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      var obj = this._wrapped;
	      method.apply(obj, arguments);
	      if ((name === 'shift' || name === 'splice') && obj.length === 0) delete obj[0];
	      return result(this, obj);
	    };
	  });
	
	  // Add all accessor Array functions to the wrapper.
	  _.each(['concat', 'join', 'slice'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      return result(this, method.apply(this._wrapped, arguments));
	    };
	  });
	
	  // Extracts the result from a wrapped and chained object.
	  _.prototype.value = function() {
	    return this._wrapped;
	  };
	
	  // Provide unwrapping proxy for some methods used in engine operations
	  // such as arithmetic and JSON stringification.
	  _.prototype.valueOf = _.prototype.toJSON = _.prototype.value;
	
	  _.prototype.toString = function() {
	    return '' + this._wrapped;
	  };
	
	  // AMD registration happens at the end for compatibility with AMD loaders
	  // that may not enforce next-turn semantics on modules. Even though general
	  // practice for AMD registration is to be anonymous, underscore registers
	  // as a named module because, like jQuery, it is a base library that is
	  // popular enough to be bundled in a third party lib, but not be part of
	  // an AMD load request. Those cases could generate an error when an
	  // anonymous define() is called outside of a loader request.
	  if (true) {
	    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function() {
	      return _;
	    }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	}.call(this));


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	
	'use strict';
	
	var adapterFactory = __webpack_require__(5);
	module.exports = adapterFactory({window: global.window});
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	
	'use strict';
	
	// Shimming starts here.
	module.exports = function(dependencies, opts) {
	  var window = dependencies && dependencies.window;
	
	  var options = {
	    shimChrome: true,
	    shimFirefox: true,
	    shimEdge: true,
	    shimSafari: true,
	  };
	
	  for (var key in opts) {
	    if (hasOwnProperty.call(opts, key)) {
	      options[key] = opts[key];
	    }
	  }
	
	  // Utils.
	  var utils = __webpack_require__(6);
	  var logging = utils.log;
	  var browserDetails = utils.detectBrowser(window);
	
	  // Export to the adapter global object visible in the browser.
	  var adapter = {
	    browserDetails: browserDetails,
	    extractVersion: utils.extractVersion,
	    disableLog: utils.disableLog,
	    disableWarnings: utils.disableWarnings
	  };
	
	  // Uncomment the line below if you want logging to occur, including logging
	  // for the switch statement below. Can also be turned on in the browser via
	  // adapter.disableLog(false), but then logging from the switch statement below
	  // will not appear.
	  // require('./utils').disableLog(false);
	
	  // Browser shims.
	  var chromeShim = __webpack_require__(7) || null;
	  var edgeShim = __webpack_require__(9) || null;
	  var firefoxShim = __webpack_require__(13) || null;
	  var safariShim = __webpack_require__(15) || null;
	
	  // Shim browser if found.
	  switch (browserDetails.browser) {
	    case 'chrome':
	      if (!chromeShim || !chromeShim.shimPeerConnection ||
	          !options.shimChrome) {
	        logging('Chrome shim is not included in this adapter release.');
	        return adapter;
	      }
	      logging('adapter.js shimming chrome.');
	      // Export to the adapter global object visible in the browser.
	      adapter.browserShim = chromeShim;
	
	      chromeShim.shimGetUserMedia(window);
	      chromeShim.shimMediaStream(window);
	      utils.shimCreateObjectURL(window);
	      chromeShim.shimSourceObject(window);
	      chromeShim.shimPeerConnection(window);
	      chromeShim.shimOnTrack(window);
	      chromeShim.shimAddTrackRemoveTrack(window);
	      chromeShim.shimGetSendersWithDtmf(window);
	      break;
	    case 'firefox':
	      if (!firefoxShim || !firefoxShim.shimPeerConnection ||
	          !options.shimFirefox) {
	        logging('Firefox shim is not included in this adapter release.');
	        return adapter;
	      }
	      logging('adapter.js shimming firefox.');
	      // Export to the adapter global object visible in the browser.
	      adapter.browserShim = firefoxShim;
	
	      firefoxShim.shimGetUserMedia(window);
	      utils.shimCreateObjectURL(window);
	      firefoxShim.shimSourceObject(window);
	      firefoxShim.shimPeerConnection(window);
	      firefoxShim.shimOnTrack(window);
	      break;
	    case 'edge':
	      if (!edgeShim || !edgeShim.shimPeerConnection || !options.shimEdge) {
	        logging('MS edge shim is not included in this adapter release.');
	        return adapter;
	      }
	      logging('adapter.js shimming edge.');
	      // Export to the adapter global object visible in the browser.
	      adapter.browserShim = edgeShim;
	
	      edgeShim.shimGetUserMedia(window);
	      utils.shimCreateObjectURL(window);
	      edgeShim.shimPeerConnection(window);
	      edgeShim.shimReplaceTrack(window);
	      break;
	    case 'safari':
	      if (!safariShim || !options.shimSafari) {
	        logging('Safari shim is not included in this adapter release.');
	        return adapter;
	      }
	      logging('adapter.js shimming safari.');
	      // Export to the adapter global object visible in the browser.
	      adapter.browserShim = safariShim;
	      // shim window.URL.createObjectURL Safari (technical preview)
	      utils.shimCreateObjectURL(window);
	      safariShim.shimRTCIceServerUrls(window);
	      safariShim.shimCallbacksAPI(window);
	      safariShim.shimLocalStreamsAPI(window);
	      safariShim.shimRemoteStreamsAPI(window);
	      safariShim.shimGetUserMedia(window);
	      break;
	    default:
	      logging('Unsupported browser!');
	      break;
	  }
	
	  return adapter;
	};


/***/ }),
/* 6 */
/***/ (function(module, exports) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	
	var logDisabled_ = true;
	var deprecationWarnings_ = true;
	
	// Utility methods.
	var utils = {
	  disableLog: function(bool) {
	    if (typeof bool !== 'boolean') {
	      return new Error('Argument type: ' + typeof bool +
	          '. Please use a boolean.');
	    }
	    logDisabled_ = bool;
	    return (bool) ? 'adapter.js logging disabled' :
	        'adapter.js logging enabled';
	  },
	
	  /**
	   * Disable or enable deprecation warnings
	   * @param {!boolean} bool set to true to disable warnings.
	   */
	  disableWarnings: function(bool) {
	    if (typeof bool !== 'boolean') {
	      return new Error('Argument type: ' + typeof bool +
	          '. Please use a boolean.');
	    }
	    deprecationWarnings_ = !bool;
	    return 'adapter.js deprecation warnings ' + (bool ? 'disabled' : 'enabled');
	  },
	
	  log: function() {
	    if (typeof window === 'object') {
	      if (logDisabled_) {
	        return;
	      }
	      if (typeof console !== 'undefined' && typeof console.log === 'function') {
	        console.log.apply(console, arguments);
	      }
	    }
	  },
	
	  /**
	   * Shows a deprecation warning suggesting the modern and spec-compatible API.
	   */
	  deprecated: function(oldMethod, newMethod) {
	    if (!deprecationWarnings_) {
	      return;
	    }
	    console.warn(oldMethod + ' is deprecated, please use ' + newMethod +
	        ' instead.');
	  },
	
	  /**
	   * Extract browser version out of the provided user agent string.
	   *
	   * @param {!string} uastring userAgent string.
	   * @param {!string} expr Regular expression used as match criteria.
	   * @param {!number} pos position in the version string to be returned.
	   * @return {!number} browser version.
	   */
	  extractVersion: function(uastring, expr, pos) {
	    var match = uastring.match(expr);
	    return match && match.length >= pos && parseInt(match[pos], 10);
	  },
	
	  /**
	   * Browser detector.
	   *
	   * @return {object} result containing browser and version
	   *     properties.
	   */
	  detectBrowser: function(window) {
	    var navigator = window && window.navigator;
	
	    // Returned result object.
	    var result = {};
	    result.browser = null;
	    result.version = null;
	
	    // Fail early if it's not a browser
	    if (typeof window === 'undefined' || !window.navigator) {
	      result.browser = 'Not a browser.';
	      return result;
	    }
	
	    // Firefox.
	    if (navigator.mozGetUserMedia) {
	      result.browser = 'firefox';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Firefox\/(\d+)\./, 1);
	    } else if (navigator.webkitGetUserMedia) {
	      // Chrome, Chromium, Webview, Opera, all use the chrome shim for now
	      if (window.webkitRTCPeerConnection) {
	        result.browser = 'chrome';
	        result.version = this.extractVersion(navigator.userAgent,
	          /Chrom(e|ium)\/(\d+)\./, 2);
	      } else { // Safari (in an unpublished version) or unknown webkit-based.
	        if (navigator.userAgent.match(/Version\/(\d+).(\d+)/)) {
	          result.browser = 'safari';
	          result.version = this.extractVersion(navigator.userAgent,
	            /AppleWebKit\/(\d+)\./, 1);
	        } else { // unknown webkit-based browser.
	          result.browser = 'Unsupported webkit-based browser ' +
	              'with GUM support but no WebRTC support.';
	          return result;
	        }
	      }
	    } else if (navigator.mediaDevices &&
	        navigator.userAgent.match(/Edge\/(\d+).(\d+)$/)) { // Edge.
	      result.browser = 'edge';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Edge\/(\d+).(\d+)$/, 2);
	    } else if (navigator.mediaDevices &&
	        navigator.userAgent.match(/AppleWebKit\/(\d+)\./)) {
	        // Safari, with webkitGetUserMedia removed.
	      result.browser = 'safari';
	      result.version = this.extractVersion(navigator.userAgent,
	          /AppleWebKit\/(\d+)\./, 1);
	    } else { // Default fallthrough: not supported.
	      result.browser = 'Not a supported browser.';
	      return result;
	    }
	
	    return result;
	  },
	
	  // shimCreateObjectURL must be called before shimSourceObject to avoid loop.
	
	  shimCreateObjectURL: function(window) {
	    var URL = window && window.URL;
	
	    if (!(typeof window === 'object' && window.HTMLMediaElement &&
	          'srcObject' in window.HTMLMediaElement.prototype)) {
	      // Only shim CreateObjectURL using srcObject if srcObject exists.
	      return undefined;
	    }
	
	    var nativeCreateObjectURL = URL.createObjectURL.bind(URL);
	    var nativeRevokeObjectURL = URL.revokeObjectURL.bind(URL);
	    var streams = new Map(), newId = 0;
	
	    URL.createObjectURL = function(stream) {
	      if ('getTracks' in stream) {
	        var url = 'polyblob:' + (++newId);
	        streams.set(url, stream);
	        utils.deprecated('URL.createObjectURL(stream)',
	            'elem.srcObject = stream');
	        return url;
	      }
	      return nativeCreateObjectURL(stream);
	    };
	    URL.revokeObjectURL = function(url) {
	      nativeRevokeObjectURL(url);
	      streams.delete(url);
	    };
	
	    var dsc = Object.getOwnPropertyDescriptor(window.HTMLMediaElement.prototype,
	                                              'src');
	    Object.defineProperty(window.HTMLMediaElement.prototype, 'src', {
	      get: function() {
	        return dsc.get.apply(this);
	      },
	      set: function(url) {
	        this.srcObject = streams.get(url) || null;
	        return dsc.set.apply(this, [url]);
	      }
	    });
	
	    var nativeSetAttribute = window.HTMLMediaElement.prototype.setAttribute;
	    window.HTMLMediaElement.prototype.setAttribute = function() {
	      if (arguments.length === 2 &&
	          ('' + arguments[0]).toLowerCase() === 'src') {
	        this.srcObject = streams.get(arguments[1]) || null;
	      }
	      return nativeSetAttribute.apply(this, arguments);
	    };
	  }
	};
	
	// Export.
	module.exports = {
	  log: utils.log,
	  deprecated: utils.deprecated,
	  disableLog: utils.disableLog,
	  disableWarnings: utils.disableWarnings,
	  extractVersion: utils.extractVersion,
	  shimCreateObjectURL: utils.shimCreateObjectURL,
	  detectBrowser: utils.detectBrowser.bind(utils)
	};


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	
	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	var utils = __webpack_require__(6);
	var logging = utils.log;
	
	var chromeShim = {
	  shimMediaStream: function(window) {
	    window.MediaStream = window.MediaStream || window.webkitMediaStream;
	  },
	
	  shimOnTrack: function(window) {
	    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
	        window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
	        get: function() {
	          return this._ontrack;
	        },
	        set: function(f) {
	          if (this._ontrack) {
	            this.removeEventListener('track', this._ontrack);
	          }
	          this.addEventListener('track', this._ontrack = f);
	        }
	      });
	      var origSetRemoteDescription =
	          window.RTCPeerConnection.prototype.setRemoteDescription;
	      window.RTCPeerConnection.prototype.setRemoteDescription = function() {
	        var pc = this;
	        if (!pc._ontrackpoly) {
	          pc._ontrackpoly = function(e) {
	            // onaddstream does not fire when a track is added to an existing
	            // stream. But stream.onaddtrack is implemented so we use that.
	            e.stream.addEventListener('addtrack', function(te) {
	              var receiver;
	              if (window.RTCPeerConnection.prototype.getReceivers) {
	                receiver = pc.getReceivers().find(function(r) {
	                  return r.track && r.track.id === te.track.id;
	                });
	              } else {
	                receiver = {track: te.track};
	              }
	
	              var event = new Event('track');
	              event.track = te.track;
	              event.receiver = receiver;
	              event.streams = [e.stream];
	              pc.dispatchEvent(event);
	            });
	            e.stream.getTracks().forEach(function(track) {
	              var receiver;
	              if (window.RTCPeerConnection.prototype.getReceivers) {
	                receiver = pc.getReceivers().find(function(r) {
	                  return r.track && r.track.id === track.id;
	                });
	              } else {
	                receiver = {track: track};
	              }
	              var event = new Event('track');
	              event.track = track;
	              event.receiver = receiver;
	              event.streams = [e.stream];
	              pc.dispatchEvent(event);
	            });
	          };
	          pc.addEventListener('addstream', pc._ontrackpoly);
	        }
	        return origSetRemoteDescription.apply(pc, arguments);
	      };
	    }
	  },
	
	  shimGetSendersWithDtmf: function(window) {
	    // Overrides addTrack/removeTrack, depends on shimAddTrackRemoveTrack.
	    if (typeof window === 'object' && window.RTCPeerConnection &&
	        !('getSenders' in window.RTCPeerConnection.prototype) &&
	        'createDTMFSender' in window.RTCPeerConnection.prototype) {
	      var shimSenderWithDtmf = function(pc, track) {
	        return {
	          track: track,
	          get dtmf() {
	            if (this._dtmf === undefined) {
	              if (track.kind === 'audio') {
	                this._dtmf = pc.createDTMFSender(track);
	              } else {
	                this._dtmf = null;
	              }
	            }
	            return this._dtmf;
	          },
	          _pc: pc
	        };
	      };
	
	      // augment addTrack when getSenders is not available.
	      if (!window.RTCPeerConnection.prototype.getSenders) {
	        window.RTCPeerConnection.prototype.getSenders = function() {
	          this._senders = this._senders || [];
	          return this._senders.slice(); // return a copy of the internal state.
	        };
	        var origAddTrack = window.RTCPeerConnection.prototype.addTrack;
	        window.RTCPeerConnection.prototype.addTrack = function(track, stream) {
	          var pc = this;
	          var sender = origAddTrack.apply(pc, arguments);
	          if (!sender) {
	            sender = shimSenderWithDtmf(pc, track);
	            pc._senders.push(sender);
	          }
	          return sender;
	        };
	
	        var origRemoveTrack = window.RTCPeerConnection.prototype.removeTrack;
	        window.RTCPeerConnection.prototype.removeTrack = function(sender) {
	          var pc = this;
	          origRemoveTrack.apply(pc, arguments);
	          var idx = pc._senders.indexOf(sender);
	          if (idx !== -1) {
	            pc._senders.splice(idx, 1);
	          }
	        };
	      }
	      var origAddStream = window.RTCPeerConnection.prototype.addStream;
	      window.RTCPeerConnection.prototype.addStream = function(stream) {
	        var pc = this;
	        pc._senders = pc._senders || [];
	        origAddStream.apply(pc, [stream]);
	        stream.getTracks().forEach(function(track) {
	          pc._senders.push(shimSenderWithDtmf(pc, track));
	        });
	      };
	
	      var origRemoveStream = window.RTCPeerConnection.prototype.removeStream;
	      window.RTCPeerConnection.prototype.removeStream = function(stream) {
	        var pc = this;
	        pc._senders = pc._senders || [];
	        origRemoveStream.apply(pc, [(pc._streams[stream.id] || stream)]);
	
	        stream.getTracks().forEach(function(track) {
	          var sender = pc._senders.find(function(s) {
	            return s.track === track;
	          });
	          if (sender) {
	            pc._senders.splice(pc._senders.indexOf(sender), 1); // remove sender
	          }
	        });
	      };
	    } else if (typeof window === 'object' && window.RTCPeerConnection &&
	               'getSenders' in window.RTCPeerConnection.prototype &&
	               'createDTMFSender' in window.RTCPeerConnection.prototype &&
	               window.RTCRtpSender &&
	               !('dtmf' in window.RTCRtpSender.prototype)) {
	      var origGetSenders = window.RTCPeerConnection.prototype.getSenders;
	      window.RTCPeerConnection.prototype.getSenders = function() {
	        var pc = this;
	        var senders = origGetSenders.apply(pc, []);
	        senders.forEach(function(sender) {
	          sender._pc = pc;
	        });
	        return senders;
	      };
	
	      Object.defineProperty(window.RTCRtpSender.prototype, 'dtmf', {
	        get: function() {
	          if (this._dtmf === undefined) {
	            if (this.track.kind === 'audio') {
	              this._dtmf = this._pc.createDTMFSender(this.track);
	            } else {
	              this._dtmf = null;
	            }
	          }
	          return this._dtmf;
	        }
	      });
	    }
	  },
	
	  shimSourceObject: function(window) {
	    var URL = window && window.URL;
	
	    if (typeof window === 'object') {
	      if (window.HTMLMediaElement &&
	        !('srcObject' in window.HTMLMediaElement.prototype)) {
	        // Shim the srcObject property, once, when HTMLMediaElement is found.
	        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
	          get: function() {
	            return this._srcObject;
	          },
	          set: function(stream) {
	            var self = this;
	            // Use _srcObject as a private property for this shim
	            this._srcObject = stream;
	            if (this.src) {
	              URL.revokeObjectURL(this.src);
	            }
	
	            if (!stream) {
	              this.src = '';
	              return undefined;
	            }
	            this.src = URL.createObjectURL(stream);
	            // We need to recreate the blob url when a track is added or
	            // removed. Doing it manually since we want to avoid a recursion.
	            stream.addEventListener('addtrack', function() {
	              if (self.src) {
	                URL.revokeObjectURL(self.src);
	              }
	              self.src = URL.createObjectURL(stream);
	            });
	            stream.addEventListener('removetrack', function() {
	              if (self.src) {
	                URL.revokeObjectURL(self.src);
	              }
	              self.src = URL.createObjectURL(stream);
	            });
	          }
	        });
	      }
	    }
	  },
	
	  shimAddTrackRemoveTrack: function(window) {
	    // shim addTrack and removeTrack.
	    if (window.RTCPeerConnection.prototype.addTrack) {
	      return;
	    }
	
	    // also shim pc.getLocalStreams when addTrack is shimmed
	    // to return the original streams.
	    var origGetLocalStreams = window.RTCPeerConnection.prototype
	        .getLocalStreams;
	    window.RTCPeerConnection.prototype.getLocalStreams = function() {
	      var self = this;
	      var nativeStreams = origGetLocalStreams.apply(this);
	      self._reverseStreams = self._reverseStreams || {};
	      return nativeStreams.map(function(stream) {
	        return self._reverseStreams[stream.id];
	      });
	    };
	
	    var origAddStream = window.RTCPeerConnection.prototype.addStream;
	    window.RTCPeerConnection.prototype.addStream = function(stream) {
	      var pc = this;
	      pc._streams = pc._streams || {};
	      pc._reverseStreams = pc._reverseStreams || {};
	
	      stream.getTracks().forEach(function(track) {
	        var alreadyExists = pc.getSenders().find(function(s) {
	          return s.track === track;
	        });
	        if (alreadyExists) {
	          throw new DOMException('Track already exists.',
	              'InvalidAccessError');
	        }
	      });
	      // Add identity mapping for consistency with addTrack.
	      // Unless this is being used with a stream from addTrack.
	      if (!pc._reverseStreams[stream.id]) {
	        var newStream = new window.MediaStream(stream.getTracks());
	        pc._streams[stream.id] = newStream;
	        pc._reverseStreams[newStream.id] = stream;
	        stream = newStream;
	      }
	      origAddStream.apply(pc, [stream]);
	    };
	
	    var origRemoveStream = window.RTCPeerConnection.prototype.removeStream;
	    window.RTCPeerConnection.prototype.removeStream = function(stream) {
	      var pc = this;
	      pc._streams = pc._streams || {};
	      pc._reverseStreams = pc._reverseStreams || {};
	
	      origRemoveStream.apply(pc, [(pc._streams[stream.id] || stream)]);
	      delete pc._reverseStreams[(pc._streams[stream.id] ?
	          pc._streams[stream.id].id : stream.id)];
	      delete pc._streams[stream.id];
	    };
	
	    window.RTCPeerConnection.prototype.addTrack = function(track, stream) {
	      var pc = this;
	      if (pc.signalingState === 'closed') {
	        throw new DOMException(
	          'The RTCPeerConnection\'s signalingState is \'closed\'.',
	          'InvalidStateError');
	      }
	      var streams = [].slice.call(arguments, 1);
	      if (streams.length !== 1 ||
	          !streams[0].getTracks().find(function(t) {
	            return t === track;
	          })) {
	        // this is not fully correct but all we can manage without
	        // [[associated MediaStreams]] internal slot.
	        throw new DOMException(
	          'The adapter.js addTrack polyfill only supports a single ' +
	          ' stream which is associated with the specified track.',
	          'NotSupportedError');
	      }
	
	      var alreadyExists = pc.getSenders().find(function(s) {
	        return s.track === track;
	      });
	      if (alreadyExists) {
	        throw new DOMException('Track already exists.',
	            'InvalidAccessError');
	      }
	
	      pc._streams = pc._streams || {};
	      pc._reverseStreams = pc._reverseStreams || {};
	      var oldStream = pc._streams[stream.id];
	      if (oldStream) {
	        // this is using odd Chrome behaviour, use with caution:
	        // https://bugs.chromium.org/p/webrtc/issues/detail?id=7815
	        // Note: we rely on the high-level addTrack/dtmf shim to
	        // create the sender with a dtmf sender.
	        oldStream.addTrack(track);
	        pc.dispatchEvent(new Event('negotiationneeded'));
	      } else {
	        var newStream = new window.MediaStream([track]);
	        pc._streams[stream.id] = newStream;
	        pc._reverseStreams[newStream.id] = stream;
	        pc.addStream(newStream);
	      }
	      return pc.getSenders().find(function(s) {
	        return s.track === track;
	      });
	    };
	
	    window.RTCPeerConnection.prototype.removeTrack = function(sender) {
	      var pc = this;
	      if (pc.signalingState === 'closed') {
	        throw new DOMException(
	          'The RTCPeerConnection\'s signalingState is \'closed\'.',
	          'InvalidStateError');
	      }
	      // We can not yet check for sender instanceof RTCRtpSender
	      // since we shim RTPSender. So we check if sender._pc is set.
	      if (!sender._pc) {
	        throw new DOMException('Argument 1 of RTCPeerConnection.removeTrack ' +
	            'does not implement interface RTCRtpSender.', 'TypeError');
	      }
	      var isLocal = sender._pc === pc;
	      if (!isLocal) {
	        throw new DOMException('Sender was not created by this connection.',
	            'InvalidAccessError');
	      }
	
	      // Search for the native stream the senders track belongs to.
	      pc._streams = pc._streams || {};
	      var stream;
	      Object.keys(pc._streams).forEach(function(streamid) {
	        var hasTrack = pc._streams[streamid].getTracks().find(function(track) {
	          return sender.track === track;
	        });
	        if (hasTrack) {
	          stream = pc._streams[streamid];
	        }
	      });
	
	      if (stream) {
	        if (stream.getTracks().length === 1) {
	          // if this is the last track of the stream, remove the stream. This
	          // takes care of any shimmed _senders.
	          pc.removeStream(stream);
	        } else {
	          // relying on the same odd chrome behaviour as above.
	          stream.removeTrack(sender.track);
	        }
	        pc.dispatchEvent(new Event('negotiationneeded'));
	      }
	    };
	  },
	
	  shimPeerConnection: function(window) {
	    var browserDetails = utils.detectBrowser(window);
	
	    // The RTCPeerConnection object.
	    if (!window.RTCPeerConnection) {
	      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	        // Translate iceTransportPolicy to iceTransports,
	        // see https://code.google.com/p/webrtc/issues/detail?id=4869
	        // this was fixed in M56 along with unprefixing RTCPeerConnection.
	        logging('PeerConnection');
	        if (pcConfig && pcConfig.iceTransportPolicy) {
	          pcConfig.iceTransports = pcConfig.iceTransportPolicy;
	        }
	
	        return new window.webkitRTCPeerConnection(pcConfig, pcConstraints);
	      };
	      window.RTCPeerConnection.prototype =
	          window.webkitRTCPeerConnection.prototype;
	      // wrap static methods. Currently just generateCertificate.
	      if (window.webkitRTCPeerConnection.generateCertificate) {
	        Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	          get: function() {
	            return window.webkitRTCPeerConnection.generateCertificate;
	          }
	        });
	      }
	    } else {
	      // migrate from non-spec RTCIceServer.url to RTCIceServer.urls
	      var OrigPeerConnection = window.RTCPeerConnection;
	      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	        if (pcConfig && pcConfig.iceServers) {
	          var newIceServers = [];
	          for (var i = 0; i < pcConfig.iceServers.length; i++) {
	            var server = pcConfig.iceServers[i];
	            if (!server.hasOwnProperty('urls') &&
	                server.hasOwnProperty('url')) {
	              utils.deprecated('RTCIceServer.url', 'RTCIceServer.urls');
	              server = JSON.parse(JSON.stringify(server));
	              server.urls = server.url;
	              newIceServers.push(server);
	            } else {
	              newIceServers.push(pcConfig.iceServers[i]);
	            }
	          }
	          pcConfig.iceServers = newIceServers;
	        }
	        return new OrigPeerConnection(pcConfig, pcConstraints);
	      };
	      window.RTCPeerConnection.prototype = OrigPeerConnection.prototype;
	      // wrap static methods. Currently just generateCertificate.
	      Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	        get: function() {
	          return OrigPeerConnection.generateCertificate;
	        }
	      });
	    }
	
	    var origGetStats = window.RTCPeerConnection.prototype.getStats;
	    window.RTCPeerConnection.prototype.getStats = function(selector,
	        successCallback, errorCallback) {
	      var self = this;
	      var args = arguments;
	
	      // If selector is a function then we are in the old style stats so just
	      // pass back the original getStats format to avoid breaking old users.
	      if (arguments.length > 0 && typeof selector === 'function') {
	        return origGetStats.apply(this, arguments);
	      }
	
	      // When spec-style getStats is supported, return those when called with
	      // either no arguments or the selector argument is null.
	      if (origGetStats.length === 0 && (arguments.length === 0 ||
	          typeof arguments[0] !== 'function')) {
	        return origGetStats.apply(this, []);
	      }
	
	      var fixChromeStats_ = function(response) {
	        var standardReport = {};
	        var reports = response.result();
	        reports.forEach(function(report) {
	          var standardStats = {
	            id: report.id,
	            timestamp: report.timestamp,
	            type: {
	              localcandidate: 'local-candidate',
	              remotecandidate: 'remote-candidate'
	            }[report.type] || report.type
	          };
	          report.names().forEach(function(name) {
	            standardStats[name] = report.stat(name);
	          });
	          standardReport[standardStats.id] = standardStats;
	        });
	
	        return standardReport;
	      };
	
	      // shim getStats with maplike support
	      var makeMapStats = function(stats) {
	        return new Map(Object.keys(stats).map(function(key) {
	          return [key, stats[key]];
	        }));
	      };
	
	      if (arguments.length >= 2) {
	        var successCallbackWrapper_ = function(response) {
	          args[1](makeMapStats(fixChromeStats_(response)));
	        };
	
	        return origGetStats.apply(this, [successCallbackWrapper_,
	          arguments[0]]);
	      }
	
	      // promise-support
	      return new Promise(function(resolve, reject) {
	        origGetStats.apply(self, [
	          function(response) {
	            resolve(makeMapStats(fixChromeStats_(response)));
	          }, reject]);
	      }).then(successCallback, errorCallback);
	    };
	
	    // add promise support -- natively available in Chrome 51
	    if (browserDetails.version < 51) {
	      ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
	          .forEach(function(method) {
	            var nativeMethod = window.RTCPeerConnection.prototype[method];
	            window.RTCPeerConnection.prototype[method] = function() {
	              var args = arguments;
	              var self = this;
	              var promise = new Promise(function(resolve, reject) {
	                nativeMethod.apply(self, [args[0], resolve, reject]);
	              });
	              if (args.length < 2) {
	                return promise;
	              }
	              return promise.then(function() {
	                args[1].apply(null, []);
	              },
	              function(err) {
	                if (args.length >= 3) {
	                  args[2].apply(null, [err]);
	                }
	              });
	            };
	          });
	    }
	
	    // promise support for createOffer and createAnswer. Available (without
	    // bugs) since M52: crbug/619289
	    if (browserDetails.version < 52) {
	      ['createOffer', 'createAnswer'].forEach(function(method) {
	        var nativeMethod = window.RTCPeerConnection.prototype[method];
	        window.RTCPeerConnection.prototype[method] = function() {
	          var self = this;
	          if (arguments.length < 1 || (arguments.length === 1 &&
	              typeof arguments[0] === 'object')) {
	            var opts = arguments.length === 1 ? arguments[0] : undefined;
	            return new Promise(function(resolve, reject) {
	              nativeMethod.apply(self, [resolve, reject, opts]);
	            });
	          }
	          return nativeMethod.apply(this, arguments);
	        };
	      });
	    }
	
	    // shim implicit creation of RTCSessionDescription/RTCIceCandidate
	    ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
	        .forEach(function(method) {
	          var nativeMethod = window.RTCPeerConnection.prototype[method];
	          window.RTCPeerConnection.prototype[method] = function() {
	            arguments[0] = new ((method === 'addIceCandidate') ?
	                window.RTCIceCandidate :
	                window.RTCSessionDescription)(arguments[0]);
	            return nativeMethod.apply(this, arguments);
	          };
	        });
	
	    // support for addIceCandidate(null or undefined)
	    var nativeAddIceCandidate =
	        window.RTCPeerConnection.prototype.addIceCandidate;
	    window.RTCPeerConnection.prototype.addIceCandidate = function() {
	      if (!arguments[0]) {
	        if (arguments[1]) {
	          arguments[1].apply(null);
	        }
	        return Promise.resolve();
	      }
	      return nativeAddIceCandidate.apply(this, arguments);
	    };
	  }
	};
	
	
	// Expose public methods.
	module.exports = {
	  shimMediaStream: chromeShim.shimMediaStream,
	  shimOnTrack: chromeShim.shimOnTrack,
	  shimAddTrackRemoveTrack: chromeShim.shimAddTrackRemoveTrack,
	  shimGetSendersWithDtmf: chromeShim.shimGetSendersWithDtmf,
	  shimSourceObject: chromeShim.shimSourceObject,
	  shimPeerConnection: chromeShim.shimPeerConnection,
	  shimGetUserMedia: __webpack_require__(8)
	};


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	var utils = __webpack_require__(6);
	var logging = utils.log;
	
	// Expose public methods.
	module.exports = function(window) {
	  var browserDetails = utils.detectBrowser(window);
	  var navigator = window && window.navigator;
	
	  var constraintsToChrome_ = function(c) {
	    if (typeof c !== 'object' || c.mandatory || c.optional) {
	      return c;
	    }
	    var cc = {};
	    Object.keys(c).forEach(function(key) {
	      if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	        return;
	      }
	      var r = (typeof c[key] === 'object') ? c[key] : {ideal: c[key]};
	      if (r.exact !== undefined && typeof r.exact === 'number') {
	        r.min = r.max = r.exact;
	      }
	      var oldname_ = function(prefix, name) {
	        if (prefix) {
	          return prefix + name.charAt(0).toUpperCase() + name.slice(1);
	        }
	        return (name === 'deviceId') ? 'sourceId' : name;
	      };
	      if (r.ideal !== undefined) {
	        cc.optional = cc.optional || [];
	        var oc = {};
	        if (typeof r.ideal === 'number') {
	          oc[oldname_('min', key)] = r.ideal;
	          cc.optional.push(oc);
	          oc = {};
	          oc[oldname_('max', key)] = r.ideal;
	          cc.optional.push(oc);
	        } else {
	          oc[oldname_('', key)] = r.ideal;
	          cc.optional.push(oc);
	        }
	      }
	      if (r.exact !== undefined && typeof r.exact !== 'number') {
	        cc.mandatory = cc.mandatory || {};
	        cc.mandatory[oldname_('', key)] = r.exact;
	      } else {
	        ['min', 'max'].forEach(function(mix) {
	          if (r[mix] !== undefined) {
	            cc.mandatory = cc.mandatory || {};
	            cc.mandatory[oldname_(mix, key)] = r[mix];
	          }
	        });
	      }
	    });
	    if (c.advanced) {
	      cc.optional = (cc.optional || []).concat(c.advanced);
	    }
	    return cc;
	  };
	
	  var shimConstraints_ = function(constraints, func) {
	    constraints = JSON.parse(JSON.stringify(constraints));
	    if (constraints && typeof constraints.audio === 'object') {
	      var remap = function(obj, a, b) {
	        if (a in obj && !(b in obj)) {
	          obj[b] = obj[a];
	          delete obj[a];
	        }
	      };
	      constraints = JSON.parse(JSON.stringify(constraints));
	      remap(constraints.audio, 'autoGainControl', 'googAutoGainControl');
	      remap(constraints.audio, 'noiseSuppression', 'googNoiseSuppression');
	      constraints.audio = constraintsToChrome_(constraints.audio);
	    }
	    if (constraints && typeof constraints.video === 'object') {
	      // Shim facingMode for mobile & surface pro.
	      var face = constraints.video.facingMode;
	      face = face && ((typeof face === 'object') ? face : {ideal: face});
	      var getSupportedFacingModeLies = browserDetails.version < 61;
	
	      if ((face && (face.exact === 'user' || face.exact === 'environment' ||
	                    face.ideal === 'user' || face.ideal === 'environment')) &&
	          !(navigator.mediaDevices.getSupportedConstraints &&
	            navigator.mediaDevices.getSupportedConstraints().facingMode &&
	            !getSupportedFacingModeLies)) {
	        delete constraints.video.facingMode;
	        var matches;
	        if (face.exact === 'environment' || face.ideal === 'environment') {
	          matches = ['back', 'rear'];
	        } else if (face.exact === 'user' || face.ideal === 'user') {
	          matches = ['front'];
	        }
	        if (matches) {
	          // Look for matches in label, or use last cam for back (typical).
	          return navigator.mediaDevices.enumerateDevices()
	          .then(function(devices) {
	            devices = devices.filter(function(d) {
	              return d.kind === 'videoinput';
	            });
	            var dev = devices.find(function(d) {
	              return matches.some(function(match) {
	                return d.label.toLowerCase().indexOf(match) !== -1;
	              });
	            });
	            if (!dev && devices.length && matches.indexOf('back') !== -1) {
	              dev = devices[devices.length - 1]; // more likely the back cam
	            }
	            if (dev) {
	              constraints.video.deviceId = face.exact ? {exact: dev.deviceId} :
	                                                        {ideal: dev.deviceId};
	            }
	            constraints.video = constraintsToChrome_(constraints.video);
	            logging('chrome: ' + JSON.stringify(constraints));
	            return func(constraints);
	          });
	        }
	      }
	      constraints.video = constraintsToChrome_(constraints.video);
	    }
	    logging('chrome: ' + JSON.stringify(constraints));
	    return func(constraints);
	  };
	
	  var shimError_ = function(e) {
	    return {
	      name: {
	        PermissionDeniedError: 'NotAllowedError',
	        InvalidStateError: 'NotReadableError',
	        DevicesNotFoundError: 'NotFoundError',
	        ConstraintNotSatisfiedError: 'OverconstrainedError',
	        TrackStartError: 'NotReadableError',
	        MediaDeviceFailedDueToShutdown: 'NotReadableError',
	        MediaDeviceKillSwitchOn: 'NotReadableError'
	      }[e.name] || e.name,
	      message: e.message,
	      constraint: e.constraintName,
	      toString: function() {
	        return this.name + (this.message && ': ') + this.message;
	      }
	    };
	  };
	
	  var getUserMedia_ = function(constraints, onSuccess, onError) {
	    shimConstraints_(constraints, function(c) {
	      navigator.webkitGetUserMedia(c, onSuccess, function(e) {
	        onError(shimError_(e));
	      });
	    });
	  };
	
	  navigator.getUserMedia = getUserMedia_;
	
	  // Returns the result of getUserMedia as a Promise.
	  var getUserMediaPromise_ = function(constraints) {
	    return new Promise(function(resolve, reject) {
	      navigator.getUserMedia(constraints, resolve, reject);
	    });
	  };
	
	  if (!navigator.mediaDevices) {
	    navigator.mediaDevices = {
	      getUserMedia: getUserMediaPromise_,
	      enumerateDevices: function() {
	        return new Promise(function(resolve) {
	          var kinds = {audio: 'audioinput', video: 'videoinput'};
	          return window.MediaStreamTrack.getSources(function(devices) {
	            resolve(devices.map(function(device) {
	              return {label: device.label,
	                kind: kinds[device.kind],
	                deviceId: device.id,
	                groupId: ''};
	            }));
	          });
	        });
	      },
	      getSupportedConstraints: function() {
	        return {
	          deviceId: true, echoCancellation: true, facingMode: true,
	          frameRate: true, height: true, width: true
	        };
	      }
	    };
	  }
	
	  // A shim for getUserMedia method on the mediaDevices object.
	  // TODO(KaptenJansson) remove once implemented in Chrome stable.
	  if (!navigator.mediaDevices.getUserMedia) {
	    navigator.mediaDevices.getUserMedia = function(constraints) {
	      return getUserMediaPromise_(constraints);
	    };
	  } else {
	    // Even though Chrome 45 has navigator.mediaDevices and a getUserMedia
	    // function which returns a Promise, it does not accept spec-style
	    // constraints.
	    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
	        bind(navigator.mediaDevices);
	    navigator.mediaDevices.getUserMedia = function(cs) {
	      return shimConstraints_(cs, function(c) {
	        return origGetUserMedia(c).then(function(stream) {
	          if (c.audio && !stream.getAudioTracks().length ||
	              c.video && !stream.getVideoTracks().length) {
	            stream.getTracks().forEach(function(track) {
	              track.stop();
	            });
	            throw new DOMException('', 'NotFoundError');
	          }
	          return stream;
	        }, function(e) {
	          return Promise.reject(shimError_(e));
	        });
	      });
	    };
	  }
	
	  // Dummy devicechange event methods.
	  // TODO(KaptenJansson) remove once implemented in Chrome stable.
	  if (typeof navigator.mediaDevices.addEventListener === 'undefined') {
	    navigator.mediaDevices.addEventListener = function() {
	      logging('Dummy mediaDevices.addEventListener called.');
	    };
	  }
	  if (typeof navigator.mediaDevices.removeEventListener === 'undefined') {
	    navigator.mediaDevices.removeEventListener = function() {
	      logging('Dummy mediaDevices.removeEventListener called.');
	    };
	  }
	};


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	
	var utils = __webpack_require__(6);
	var shimRTCPeerConnection = __webpack_require__(10);
	
	module.exports = {
	  shimGetUserMedia: __webpack_require__(12),
	  shimPeerConnection: function(window) {
	    var browserDetails = utils.detectBrowser(window);
	
	    if (window.RTCIceGatherer) {
	      // ORTC defines an RTCIceCandidate object but no constructor.
	      // Not implemented in Edge.
	      if (!window.RTCIceCandidate) {
	        window.RTCIceCandidate = function(args) {
	          return args;
	        };
	      }
	      // ORTC does not have a session description object but
	      // other browsers (i.e. Chrome) that will support both PC and ORTC
	      // in the future might have this defined already.
	      if (!window.RTCSessionDescription) {
	        window.RTCSessionDescription = function(args) {
	          return args;
	        };
	      }
	      // this adds an additional event listener to MediaStrackTrack that signals
	      // when a tracks enabled property was changed. Workaround for a bug in
	      // addStream, see below. No longer required in 15025+
	      if (browserDetails.version < 15025) {
	        var origMSTEnabled = Object.getOwnPropertyDescriptor(
	            window.MediaStreamTrack.prototype, 'enabled');
	        Object.defineProperty(window.MediaStreamTrack.prototype, 'enabled', {
	          set: function(value) {
	            origMSTEnabled.set.call(this, value);
	            var ev = new Event('enabled');
	            ev.enabled = value;
	            this.dispatchEvent(ev);
	          }
	        });
	      }
	    }
	
	    // ORTC defines the DTMF sender a bit different.
	    // https://github.com/w3c/ortc/issues/714
	    if (window.RTCRtpSender && !('dtmf' in window.RTCRtpSender.prototype)) {
	      Object.defineProperty(window.RTCRtpSender.prototype, 'dtmf', {
	        get: function() {
	          if (this._dtmf === undefined) {
	            if (this.track.kind === 'audio') {
	              this._dtmf = new window.RTCDtmfSender(this);
	            } else if (this.track.kind === 'video') {
	              this._dtmf = null;
	            }
	          }
	          return this._dtmf;
	        }
	      });
	    }
	
	    window.RTCPeerConnection =
	        shimRTCPeerConnection(window, browserDetails.version);
	  },
	  shimReplaceTrack: function(window) {
	    // ORTC has replaceTrack -- https://github.com/w3c/ortc/issues/614
	    if (window.RTCRtpSender &&
	        !('replaceTrack' in window.RTCRtpSender.prototype)) {
	      window.RTCRtpSender.prototype.replaceTrack =
	          window.RTCRtpSender.prototype.setTrack;
	    }
	  }
	};


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2017 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	
	var SDPUtils = __webpack_require__(11);
	
	// sort tracks such that they follow an a-v-a-v...
	// pattern.
	function sortTracks(tracks) {
	  var audioTracks = tracks.filter(function(track) {
	    return track.kind === 'audio';
	  });
	  var videoTracks = tracks.filter(function(track) {
	    return track.kind === 'video';
	  });
	  tracks = [];
	  while (audioTracks.length || videoTracks.length) {
	    if (audioTracks.length) {
	      tracks.push(audioTracks.shift());
	    }
	    if (videoTracks.length) {
	      tracks.push(videoTracks.shift());
	    }
	  }
	  return tracks;
	}
	
	// Edge does not like
	// 1) stun:
	// 2) turn: that does not have all of turn:host:port?transport=udp
	// 3) turn: with ipv6 addresses
	// 4) turn: occurring muliple times
	function filterIceServers(iceServers, edgeVersion) {
	  var hasTurn = false;
	  iceServers = JSON.parse(JSON.stringify(iceServers));
	  return iceServers.filter(function(server) {
	    if (server && (server.urls || server.url)) {
	      var urls = server.urls || server.url;
	      if (server.url && !server.urls) {
	        console.warn('RTCIceServer.url is deprecated! Use urls instead.');
	      }
	      var isString = typeof urls === 'string';
	      if (isString) {
	        urls = [urls];
	      }
	      urls = urls.filter(function(url) {
	        var validTurn = url.indexOf('turn:') === 0 &&
	            url.indexOf('transport=udp') !== -1 &&
	            url.indexOf('turn:[') === -1 &&
	            !hasTurn;
	
	        if (validTurn) {
	          hasTurn = true;
	          return true;
	        }
	        return url.indexOf('stun:') === 0 && edgeVersion >= 14393;
	      });
	
	      delete server.url;
	      server.urls = isString ? urls[0] : urls;
	      return !!urls.length;
	    }
	    return false;
	  });
	}
	
	// Determines the intersection of local and remote capabilities.
	function getCommonCapabilities(localCapabilities, remoteCapabilities) {
	  var commonCapabilities = {
	    codecs: [],
	    headerExtensions: [],
	    fecMechanisms: []
	  };
	
	  var findCodecByPayloadType = function(pt, codecs) {
	    pt = parseInt(pt, 10);
	    for (var i = 0; i < codecs.length; i++) {
	      if (codecs[i].payloadType === pt ||
	          codecs[i].preferredPayloadType === pt) {
	        return codecs[i];
	      }
	    }
	  };
	
	  var rtxCapabilityMatches = function(lRtx, rRtx, lCodecs, rCodecs) {
	    var lCodec = findCodecByPayloadType(lRtx.parameters.apt, lCodecs);
	    var rCodec = findCodecByPayloadType(rRtx.parameters.apt, rCodecs);
	    return lCodec && rCodec &&
	        lCodec.name.toLowerCase() === rCodec.name.toLowerCase();
	  };
	
	  localCapabilities.codecs.forEach(function(lCodec) {
	    for (var i = 0; i < remoteCapabilities.codecs.length; i++) {
	      var rCodec = remoteCapabilities.codecs[i];
	      if (lCodec.name.toLowerCase() === rCodec.name.toLowerCase() &&
	          lCodec.clockRate === rCodec.clockRate) {
	        if (lCodec.name.toLowerCase() === 'rtx' &&
	            lCodec.parameters && rCodec.parameters.apt) {
	          // for RTX we need to find the local rtx that has a apt
	          // which points to the same local codec as the remote one.
	          if (!rtxCapabilityMatches(lCodec, rCodec,
	              localCapabilities.codecs, remoteCapabilities.codecs)) {
	            continue;
	          }
	        }
	        rCodec = JSON.parse(JSON.stringify(rCodec)); // deepcopy
	        // number of channels is the highest common number of channels
	        rCodec.numChannels = Math.min(lCodec.numChannels,
	            rCodec.numChannels);
	        // push rCodec so we reply with offerer payload type
	        commonCapabilities.codecs.push(rCodec);
	
	        // determine common feedback mechanisms
	        rCodec.rtcpFeedback = rCodec.rtcpFeedback.filter(function(fb) {
	          for (var j = 0; j < lCodec.rtcpFeedback.length; j++) {
	            if (lCodec.rtcpFeedback[j].type === fb.type &&
	                lCodec.rtcpFeedback[j].parameter === fb.parameter) {
	              return true;
	            }
	          }
	          return false;
	        });
	        // FIXME: also need to determine .parameters
	        //  see https://github.com/openpeer/ortc/issues/569
	        break;
	      }
	    }
	  });
	
	  localCapabilities.headerExtensions.forEach(function(lHeaderExtension) {
	    for (var i = 0; i < remoteCapabilities.headerExtensions.length;
	         i++) {
	      var rHeaderExtension = remoteCapabilities.headerExtensions[i];
	      if (lHeaderExtension.uri === rHeaderExtension.uri) {
	        commonCapabilities.headerExtensions.push(rHeaderExtension);
	        break;
	      }
	    }
	  });
	
	  // FIXME: fecMechanisms
	  return commonCapabilities;
	}
	
	// is action=setLocalDescription with type allowed in signalingState
	function isActionAllowedInSignalingState(action, type, signalingState) {
	  return {
	    offer: {
	      setLocalDescription: ['stable', 'have-local-offer'],
	      setRemoteDescription: ['stable', 'have-remote-offer']
	    },
	    answer: {
	      setLocalDescription: ['have-remote-offer', 'have-local-pranswer'],
	      setRemoteDescription: ['have-local-offer', 'have-remote-pranswer']
	    }
	  }[type][action].indexOf(signalingState) !== -1;
	}
	
	module.exports = function(window, edgeVersion) {
	  var RTCPeerConnection = function(config) {
	    var self = this;
	
	    var _eventTarget = document.createDocumentFragment();
	    ['addEventListener', 'removeEventListener', 'dispatchEvent']
	        .forEach(function(method) {
	          self[method] = _eventTarget[method].bind(_eventTarget);
	        });
	
	    this.needNegotiation = false;
	
	    this.onicecandidate = null;
	    this.onaddstream = null;
	    this.ontrack = null;
	    this.onremovestream = null;
	    this.onsignalingstatechange = null;
	    this.oniceconnectionstatechange = null;
	    this.onicegatheringstatechange = null;
	    this.onnegotiationneeded = null;
	    this.ondatachannel = null;
	    this.canTrickleIceCandidates = null;
	
	    this.localStreams = [];
	    this.remoteStreams = [];
	    this.getLocalStreams = function() {
	      return self.localStreams;
	    };
	    this.getRemoteStreams = function() {
	      return self.remoteStreams;
	    };
	
	    this.localDescription = new window.RTCSessionDescription({
	      type: '',
	      sdp: ''
	    });
	    this.remoteDescription = new window.RTCSessionDescription({
	      type: '',
	      sdp: ''
	    });
	    this.signalingState = 'stable';
	    this.iceConnectionState = 'new';
	    this.iceGatheringState = 'new';
	
	    this.iceOptions = {
	      gatherPolicy: 'all',
	      iceServers: []
	    };
	    if (config && config.iceTransportPolicy) {
	      switch (config.iceTransportPolicy) {
	        case 'all':
	        case 'relay':
	          this.iceOptions.gatherPolicy = config.iceTransportPolicy;
	          break;
	        default:
	          // don't set iceTransportPolicy.
	          break;
	      }
	    }
	    this.usingBundle = config && config.bundlePolicy === 'max-bundle';
	
	    if (config && config.iceServers) {
	      this.iceOptions.iceServers = filterIceServers(config.iceServers,
	          edgeVersion);
	    }
	    this._config = config || {};
	
	    // per-track iceGathers, iceTransports, dtlsTransports, rtpSenders, ...
	    // everything that is needed to describe a SDP m-line.
	    this.transceivers = [];
	
	    // since the iceGatherer is currently created in createOffer but we
	    // must not emit candidates until after setLocalDescription we buffer
	    // them in this array.
	    this._localIceCandidatesBuffer = [];
	
	    this._sdpSessionId = SDPUtils.generateSessionId();
	  };
	
	  RTCPeerConnection.prototype._emitGatheringStateChange = function() {
	    var event = new Event('icegatheringstatechange');
	    this.dispatchEvent(event);
	    if (this.onicegatheringstatechange !== null) {
	      this.onicegatheringstatechange(event);
	    }
	  };
	
	  RTCPeerConnection.prototype._emitBufferedCandidates = function() {
	    var self = this;
	    var sections = SDPUtils.splitSections(self.localDescription.sdp);
	    // FIXME: need to apply ice candidates in a way which is async but
	    // in-order
	    this._localIceCandidatesBuffer.forEach(function(event) {
	      var end = !event.candidate || Object.keys(event.candidate).length === 0;
	      if (end) {
	        for (var j = 1; j < sections.length; j++) {
	          if (sections[j].indexOf('\r\na=end-of-candidates\r\n') === -1) {
	            sections[j] += 'a=end-of-candidates\r\n';
	          }
	        }
	      } else {
	        sections[event.candidate.sdpMLineIndex + 1] +=
	            'a=' + event.candidate.candidate + '\r\n';
	      }
	      self.localDescription.sdp = sections.join('');
	      self.dispatchEvent(event);
	      if (self.onicecandidate !== null) {
	        self.onicecandidate(event);
	      }
	      if (!event.candidate && self.iceGatheringState !== 'complete') {
	        var complete = self.transceivers.every(function(transceiver) {
	          return transceiver.iceGatherer &&
	              transceiver.iceGatherer.state === 'completed';
	        });
	        if (complete && self.iceGatheringStateChange !== 'complete') {
	          self.iceGatheringState = 'complete';
	          self._emitGatheringStateChange();
	        }
	      }
	    });
	    this._localIceCandidatesBuffer = [];
	  };
	
	  RTCPeerConnection.prototype.getConfiguration = function() {
	    return this._config;
	  };
	
	  // internal helper to create a transceiver object.
	  // (whih is not yet the same as the WebRTC 1.0 transceiver)
	  RTCPeerConnection.prototype._createTransceiver = function(kind) {
	    var hasBundleTransport = this.transceivers.length > 0;
	    var transceiver = {
	      track: null,
	      iceGatherer: null,
	      iceTransport: null,
	      dtlsTransport: null,
	      localCapabilities: null,
	      remoteCapabilities: null,
	      rtpSender: null,
	      rtpReceiver: null,
	      kind: kind,
	      mid: null,
	      sendEncodingParameters: null,
	      recvEncodingParameters: null,
	      stream: null,
	      wantReceive: true
	    };
	    if (this.usingBundle && hasBundleTransport) {
	      transceiver.iceTransport = this.transceivers[0].iceTransport;
	      transceiver.dtlsTransport = this.transceivers[0].dtlsTransport;
	    } else {
	      var transports = this._createIceAndDtlsTransports();
	      transceiver.iceTransport = transports.iceTransport;
	      transceiver.dtlsTransport = transports.dtlsTransport;
	    }
	    this.transceivers.push(transceiver);
	    return transceiver;
	  };
	
	  RTCPeerConnection.prototype.addTrack = function(track, stream) {
	    var transceiver;
	    for (var i = 0; i < this.transceivers.length; i++) {
	      if (!this.transceivers[i].track &&
	          this.transceivers[i].kind === track.kind) {
	        transceiver = this.transceivers[i];
	      }
	    }
	    if (!transceiver) {
	      transceiver = this._createTransceiver(track.kind);
	    }
	
	    transceiver.track = track;
	    transceiver.stream = stream;
	    transceiver.rtpSender = new window.RTCRtpSender(track,
	        transceiver.dtlsTransport);
	
	    this._maybeFireNegotiationNeeded();
	    return transceiver.rtpSender;
	  };
	
	  RTCPeerConnection.prototype.addStream = function(stream) {
	    var self = this;
	    if (edgeVersion >= 15025) {
	      this.localStreams.push(stream);
	      stream.getTracks().forEach(function(track) {
	        self.addTrack(track, stream);
	      });
	    } else {
	      // Clone is necessary for local demos mostly, attaching directly
	      // to two different senders does not work (build 10547).
	      // Fixed in 15025 (or earlier)
	      var clonedStream = stream.clone();
	      stream.getTracks().forEach(function(track, idx) {
	        var clonedTrack = clonedStream.getTracks()[idx];
	        track.addEventListener('enabled', function(event) {
	          clonedTrack.enabled = event.enabled;
	        });
	      });
	      clonedStream.getTracks().forEach(function(track) {
	        self.addTrack(track, clonedStream);
	      });
	      this.localStreams.push(clonedStream);
	    }
	    this._maybeFireNegotiationNeeded();
	  };
	
	  RTCPeerConnection.prototype.removeStream = function(stream) {
	    var idx = this.localStreams.indexOf(stream);
	    if (idx > -1) {
	      this.localStreams.splice(idx, 1);
	      this._maybeFireNegotiationNeeded();
	    }
	  };
	
	  RTCPeerConnection.prototype.getSenders = function() {
	    return this.transceivers.filter(function(transceiver) {
	      return !!transceiver.rtpSender;
	    })
	    .map(function(transceiver) {
	      return transceiver.rtpSender;
	    });
	  };
	
	  RTCPeerConnection.prototype.getReceivers = function() {
	    return this.transceivers.filter(function(transceiver) {
	      return !!transceiver.rtpReceiver;
	    })
	    .map(function(transceiver) {
	      return transceiver.rtpReceiver;
	    });
	  };
	
	  // Create ICE gatherer and hook it up.
	  RTCPeerConnection.prototype._createIceGatherer = function(mid,
	      sdpMLineIndex) {
	    var self = this;
	    var iceGatherer = new window.RTCIceGatherer(self.iceOptions);
	    iceGatherer.onlocalcandidate = function(evt) {
	      var event = new Event('icecandidate');
	      event.candidate = {sdpMid: mid, sdpMLineIndex: sdpMLineIndex};
	
	      var cand = evt.candidate;
	      var end = !cand || Object.keys(cand).length === 0;
	      // Edge emits an empty object for RTCIceCandidateComplete‥
	      if (end) {
	        // polyfill since RTCIceGatherer.state is not implemented in
	        // Edge 10547 yet.
	        if (iceGatherer.state === undefined) {
	          iceGatherer.state = 'completed';
	        }
	      } else {
	        // RTCIceCandidate doesn't have a component, needs to be added
	        cand.component = 1;
	        event.candidate.candidate = SDPUtils.writeCandidate(cand);
	      }
	
	      // update local description.
	      var sections = SDPUtils.splitSections(self.localDescription.sdp);
	      if (!end) {
	        sections[event.candidate.sdpMLineIndex + 1] +=
	            'a=' + event.candidate.candidate + '\r\n';
	      } else {
	        sections[event.candidate.sdpMLineIndex + 1] +=
	            'a=end-of-candidates\r\n';
	      }
	      self.localDescription.sdp = sections.join('');
	      var transceivers = self._pendingOffer ? self._pendingOffer :
	          self.transceivers;
	      var complete = transceivers.every(function(transceiver) {
	        return transceiver.iceGatherer &&
	            transceiver.iceGatherer.state === 'completed';
	      });
	
	      // Emit candidate if localDescription is set.
	      // Also emits null candidate when all gatherers are complete.
	      switch (self.iceGatheringState) {
	        case 'new':
	          if (!end) {
	            self._localIceCandidatesBuffer.push(event);
	          }
	          if (end && complete) {
	            self._localIceCandidatesBuffer.push(
	                new Event('icecandidate'));
	          }
	          break;
	        case 'gathering':
	          self._emitBufferedCandidates();
	          if (!end) {
	            self.dispatchEvent(event);
	            if (self.onicecandidate !== null) {
	              self.onicecandidate(event);
	            }
	          }
	          if (complete) {
	            self.dispatchEvent(new Event('icecandidate'));
	            if (self.onicecandidate !== null) {
	              self.onicecandidate(new Event('icecandidate'));
	            }
	            self.iceGatheringState = 'complete';
	            self._emitGatheringStateChange();
	          }
	          break;
	        case 'complete':
	          // should not happen... currently!
	          break;
	        default: // no-op.
	          break;
	      }
	    };
	    return iceGatherer;
	  };
	
	  // Create ICE transport and DTLS transport.
	  RTCPeerConnection.prototype._createIceAndDtlsTransports = function() {
	    var self = this;
	    var iceTransport = new window.RTCIceTransport(null);
	    iceTransport.onicestatechange = function() {
	      self._updateConnectionState();
	    };
	
	    var dtlsTransport = new window.RTCDtlsTransport(iceTransport);
	    dtlsTransport.ondtlsstatechange = function() {
	      self._updateConnectionState();
	    };
	    dtlsTransport.onerror = function() {
	      // onerror does not set state to failed by itself.
	      Object.defineProperty(dtlsTransport, 'state',
	          {value: 'failed', writable: true});
	      self._updateConnectionState();
	    };
	
	    return {
	      iceTransport: iceTransport,
	      dtlsTransport: dtlsTransport
	    };
	  };
	
	  // Destroy ICE gatherer, ICE transport and DTLS transport.
	  // Without triggering the callbacks.
	  RTCPeerConnection.prototype._disposeIceAndDtlsTransports = function(
	      sdpMLineIndex) {
	    var iceGatherer = this.transceivers[sdpMLineIndex].iceGatherer;
	    if (iceGatherer) {
	      delete iceGatherer.onlocalcandidate;
	      delete this.transceivers[sdpMLineIndex].iceGatherer;
	    }
	    var iceTransport = this.transceivers[sdpMLineIndex].iceTransport;
	    if (iceTransport) {
	      delete iceTransport.onicestatechange;
	      delete this.transceivers[sdpMLineIndex].iceTransport;
	    }
	    var dtlsTransport = this.transceivers[sdpMLineIndex].dtlsTransport;
	    if (dtlsTransport) {
	      delete dtlsTransport.ondtlsstatechange;
	      delete dtlsTransport.onerror;
	      delete this.transceivers[sdpMLineIndex].dtlsTransport;
	    }
	  };
	
	  // Start the RTP Sender and Receiver for a transceiver.
	  RTCPeerConnection.prototype._transceive = function(transceiver,
	      send, recv) {
	    var params = getCommonCapabilities(transceiver.localCapabilities,
	        transceiver.remoteCapabilities);
	    if (send && transceiver.rtpSender) {
	      params.encodings = transceiver.sendEncodingParameters;
	      params.rtcp = {
	        cname: SDPUtils.localCName,
	        compound: transceiver.rtcpParameters.compound
	      };
	      if (transceiver.recvEncodingParameters.length) {
	        params.rtcp.ssrc = transceiver.recvEncodingParameters[0].ssrc;
	      }
	      transceiver.rtpSender.send(params);
	    }
	    if (recv && transceiver.rtpReceiver) {
	      // remove RTX field in Edge 14942
	      if (transceiver.kind === 'video'
	          && transceiver.recvEncodingParameters
	          && edgeVersion < 15019) {
	        transceiver.recvEncodingParameters.forEach(function(p) {
	          delete p.rtx;
	        });
	      }
	      params.encodings = transceiver.recvEncodingParameters;
	      params.rtcp = {
	        cname: transceiver.rtcpParameters.cname,
	        compound: transceiver.rtcpParameters.compound
	      };
	      if (transceiver.sendEncodingParameters.length) {
	        params.rtcp.ssrc = transceiver.sendEncodingParameters[0].ssrc;
	      }
	      transceiver.rtpReceiver.receive(params);
	    }
	  };
	
	  RTCPeerConnection.prototype.setLocalDescription = function(description) {
	    var self = this;
	
	    if (!isActionAllowedInSignalingState('setLocalDescription',
	        description.type, this.signalingState)) {
	      var e = new Error('Can not set local ' + description.type +
	          ' in state ' + this.signalingState);
	      e.name = 'InvalidStateError';
	      if (arguments.length > 2 && typeof arguments[2] === 'function') {
	        window.setTimeout(arguments[2], 0, e);
	      }
	      return Promise.reject(e);
	    }
	
	    var sections;
	    var sessionpart;
	    if (description.type === 'offer') {
	      // FIXME: What was the purpose of this empty if statement?
	      // if (!this._pendingOffer) {
	      // } else {
	      if (this._pendingOffer) {
	        // VERY limited support for SDP munging. Limited to:
	        // * changing the order of codecs
	        sections = SDPUtils.splitSections(description.sdp);
	        sessionpart = sections.shift();
	        sections.forEach(function(mediaSection, sdpMLineIndex) {
	          var caps = SDPUtils.parseRtpParameters(mediaSection);
	          self._pendingOffer[sdpMLineIndex].localCapabilities = caps;
	        });
	        this.transceivers = this._pendingOffer;
	        delete this._pendingOffer;
	      }
	    } else if (description.type === 'answer') {
	      sections = SDPUtils.splitSections(self.remoteDescription.sdp);
	      sessionpart = sections.shift();
	      var isIceLite = SDPUtils.matchPrefix(sessionpart,
	          'a=ice-lite').length > 0;
	      sections.forEach(function(mediaSection, sdpMLineIndex) {
	        var transceiver = self.transceivers[sdpMLineIndex];
	        var iceGatherer = transceiver.iceGatherer;
	        var iceTransport = transceiver.iceTransport;
	        var dtlsTransport = transceiver.dtlsTransport;
	        var localCapabilities = transceiver.localCapabilities;
	        var remoteCapabilities = transceiver.remoteCapabilities;
	
	        var rejected = SDPUtils.isRejected(mediaSection);
	
	        if (!rejected && !transceiver.isDatachannel) {
	          var remoteIceParameters = SDPUtils.getIceParameters(
	              mediaSection, sessionpart);
	          var remoteDtlsParameters = SDPUtils.getDtlsParameters(
	              mediaSection, sessionpart);
	          if (isIceLite) {
	            remoteDtlsParameters.role = 'server';
	          }
	
	          if (!self.usingBundle || sdpMLineIndex === 0) {
	            iceTransport.start(iceGatherer, remoteIceParameters,
	                isIceLite ? 'controlling' : 'controlled');
	            dtlsTransport.start(remoteDtlsParameters);
	          }
	
	          // Calculate intersection of capabilities.
	          var params = getCommonCapabilities(localCapabilities,
	              remoteCapabilities);
	
	          // Start the RTCRtpSender. The RTCRtpReceiver for this
	          // transceiver has already been started in setRemoteDescription.
	          self._transceive(transceiver,
	              params.codecs.length > 0,
	              false);
	        }
	      });
	    }
	
	    this.localDescription = {
	      type: description.type,
	      sdp: description.sdp
	    };
	    switch (description.type) {
	      case 'offer':
	        this._updateSignalingState('have-local-offer');
	        break;
	      case 'answer':
	        this._updateSignalingState('stable');
	        break;
	      default:
	        throw new TypeError('unsupported type "' + description.type +
	            '"');
	    }
	
	    // If a success callback was provided, emit ICE candidates after it
	    // has been executed. Otherwise, emit callback after the Promise is
	    // resolved.
	    var hasCallback = arguments.length > 1 &&
	      typeof arguments[1] === 'function';
	    if (hasCallback) {
	      var cb = arguments[1];
	      window.setTimeout(function() {
	        cb();
	        if (self.iceGatheringState === 'new') {
	          self.iceGatheringState = 'gathering';
	          self._emitGatheringStateChange();
	        }
	        self._emitBufferedCandidates();
	      }, 0);
	    }
	    var p = Promise.resolve();
	    p.then(function() {
	      if (!hasCallback) {
	        if (self.iceGatheringState === 'new') {
	          self.iceGatheringState = 'gathering';
	          self._emitGatheringStateChange();
	        }
	        // Usually candidates will be emitted earlier.
	        window.setTimeout(self._emitBufferedCandidates.bind(self), 500);
	      }
	    });
	    return p;
	  };
	
	  RTCPeerConnection.prototype.setRemoteDescription = function(description) {
	    var self = this;
	
	    if (!isActionAllowedInSignalingState('setRemoteDescription',
	        description.type, this.signalingState)) {
	      var e = new Error('Can not set remote ' + description.type +
	          ' in state ' + this.signalingState);
	      e.name = 'InvalidStateError';
	      if (arguments.length > 2 && typeof arguments[2] === 'function') {
	        window.setTimeout(arguments[2], 0, e);
	      }
	      return Promise.reject(e);
	    }
	
	    var streams = {};
	    var receiverList = [];
	    var sections = SDPUtils.splitSections(description.sdp);
	    var sessionpart = sections.shift();
	    var isIceLite = SDPUtils.matchPrefix(sessionpart,
	        'a=ice-lite').length > 0;
	    var usingBundle = SDPUtils.matchPrefix(sessionpart,
	        'a=group:BUNDLE ').length > 0;
	    this.usingBundle = usingBundle;
	    var iceOptions = SDPUtils.matchPrefix(sessionpart,
	        'a=ice-options:')[0];
	    if (iceOptions) {
	      this.canTrickleIceCandidates = iceOptions.substr(14).split(' ')
	          .indexOf('trickle') >= 0;
	    } else {
	      this.canTrickleIceCandidates = false;
	    }
	
	    sections.forEach(function(mediaSection, sdpMLineIndex) {
	      var lines = SDPUtils.splitLines(mediaSection);
	      var kind = SDPUtils.getKind(mediaSection);
	      var rejected = SDPUtils.isRejected(mediaSection);
	      var protocol = lines[0].substr(2).split(' ')[2];
	
	      var direction = SDPUtils.getDirection(mediaSection, sessionpart);
	      var remoteMsid = SDPUtils.parseMsid(mediaSection);
	
	      var mid = SDPUtils.getMid(mediaSection) || SDPUtils.generateIdentifier();
	
	      // Reject datachannels which are not implemented yet.
	      if (kind === 'application' && protocol === 'DTLS/SCTP') {
	        self.transceivers[sdpMLineIndex] = {
	          mid: mid,
	          isDatachannel: true
	        };
	        return;
	      }
	
	      var transceiver;
	      var iceGatherer;
	      var iceTransport;
	      var dtlsTransport;
	      var rtpReceiver;
	      var sendEncodingParameters;
	      var recvEncodingParameters;
	      var localCapabilities;
	
	      var track;
	      // FIXME: ensure the mediaSection has rtcp-mux set.
	      var remoteCapabilities = SDPUtils.parseRtpParameters(mediaSection);
	      var remoteIceParameters;
	      var remoteDtlsParameters;
	      if (!rejected) {
	        remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
	            sessionpart);
	        remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
	            sessionpart);
	        remoteDtlsParameters.role = 'client';
	      }
	      recvEncodingParameters =
	          SDPUtils.parseRtpEncodingParameters(mediaSection);
	
	      var rtcpParameters = SDPUtils.parseRtcpParameters(mediaSection);
	
	      var isComplete = SDPUtils.matchPrefix(mediaSection,
	          'a=end-of-candidates', sessionpart).length > 0;
	      var cands = SDPUtils.matchPrefix(mediaSection, 'a=candidate:')
	          .map(function(cand) {
	            return SDPUtils.parseCandidate(cand);
	          })
	          .filter(function(cand) {
	            return cand.component === '1' || cand.component === 1;
	          });
	
	      // Check if we can use BUNDLE and dispose transports.
	      if ((description.type === 'offer' || description.type === 'answer') &&
	          !rejected && usingBundle && sdpMLineIndex > 0 &&
	          self.transceivers[sdpMLineIndex]) {
	        self._disposeIceAndDtlsTransports(sdpMLineIndex);
	        self.transceivers[sdpMLineIndex].iceGatherer =
	            self.transceivers[0].iceGatherer;
	        self.transceivers[sdpMLineIndex].iceTransport =
	            self.transceivers[0].iceTransport;
	        self.transceivers[sdpMLineIndex].dtlsTransport =
	            self.transceivers[0].dtlsTransport;
	        if (self.transceivers[sdpMLineIndex].rtpSender) {
	          self.transceivers[sdpMLineIndex].rtpSender.setTransport(
	              self.transceivers[0].dtlsTransport);
	        }
	        if (self.transceivers[sdpMLineIndex].rtpReceiver) {
	          self.transceivers[sdpMLineIndex].rtpReceiver.setTransport(
	              self.transceivers[0].dtlsTransport);
	        }
	      }
	      if (description.type === 'offer' && !rejected) {
	        transceiver = self.transceivers[sdpMLineIndex] ||
	            self._createTransceiver(kind);
	        transceiver.mid = mid;
	
	        if (!transceiver.iceGatherer) {
	          transceiver.iceGatherer = usingBundle && sdpMLineIndex > 0 ?
	              self.transceivers[0].iceGatherer :
	              self._createIceGatherer(mid, sdpMLineIndex);
	        }
	
	        if (isComplete && cands.length &&
	            (!usingBundle || sdpMLineIndex === 0)) {
	          transceiver.iceTransport.setRemoteCandidates(cands);
	        }
	
	        localCapabilities = window.RTCRtpReceiver.getCapabilities(kind);
	
	        // filter RTX until additional stuff needed for RTX is implemented
	        // in adapter.js
	        if (edgeVersion < 15019) {
	          localCapabilities.codecs = localCapabilities.codecs.filter(
	              function(codec) {
	                return codec.name !== 'rtx';
	              });
	        }
	
	        sendEncodingParameters = [{
	          ssrc: (2 * sdpMLineIndex + 2) * 1001
	        }];
	
	        if (direction === 'sendrecv' || direction === 'sendonly') {
	          rtpReceiver = new window.RTCRtpReceiver(transceiver.dtlsTransport,
	              kind);
	
	          track = rtpReceiver.track;
	          // FIXME: does not work with Plan B.
	          if (remoteMsid) {
	            if (!streams[remoteMsid.stream]) {
	              streams[remoteMsid.stream] = new window.MediaStream();
	              Object.defineProperty(streams[remoteMsid.stream], 'id', {
	                get: function() {
	                  return remoteMsid.stream;
	                }
	              });
	            }
	            Object.defineProperty(track, 'id', {
	              get: function() {
	                return remoteMsid.track;
	              }
	            });
	            streams[remoteMsid.stream].addTrack(track);
	            receiverList.push([track, rtpReceiver,
	              streams[remoteMsid.stream]]);
	          } else {
	            if (!streams.default) {
	              streams.default = new window.MediaStream();
	            }
	            streams.default.addTrack(track);
	            receiverList.push([track, rtpReceiver, streams.default]);
	          }
	        }
	
	        transceiver.localCapabilities = localCapabilities;
	        transceiver.remoteCapabilities = remoteCapabilities;
	        transceiver.rtpReceiver = rtpReceiver;
	        transceiver.rtcpParameters = rtcpParameters;
	        transceiver.sendEncodingParameters = sendEncodingParameters;
	        transceiver.recvEncodingParameters = recvEncodingParameters;
	
	        // Start the RTCRtpReceiver now. The RTPSender is started in
	        // setLocalDescription.
	        self._transceive(self.transceivers[sdpMLineIndex],
	            false,
	            direction === 'sendrecv' || direction === 'sendonly');
	      } else if (description.type === 'answer' && !rejected) {
	        transceiver = self.transceivers[sdpMLineIndex];
	        iceGatherer = transceiver.iceGatherer;
	        iceTransport = transceiver.iceTransport;
	        dtlsTransport = transceiver.dtlsTransport;
	        rtpReceiver = transceiver.rtpReceiver;
	        sendEncodingParameters = transceiver.sendEncodingParameters;
	        localCapabilities = transceiver.localCapabilities;
	
	        self.transceivers[sdpMLineIndex].recvEncodingParameters =
	            recvEncodingParameters;
	        self.transceivers[sdpMLineIndex].remoteCapabilities =
	            remoteCapabilities;
	        self.transceivers[sdpMLineIndex].rtcpParameters = rtcpParameters;
	
	        if (!usingBundle || sdpMLineIndex === 0) {
	          if ((isIceLite || isComplete) && cands.length) {
	            iceTransport.setRemoteCandidates(cands);
	          }
	          iceTransport.start(iceGatherer, remoteIceParameters,
	              'controlling');
	          dtlsTransport.start(remoteDtlsParameters);
	        }
	
	        self._transceive(transceiver,
	            direction === 'sendrecv' || direction === 'recvonly',
	            direction === 'sendrecv' || direction === 'sendonly');
	
	        if (rtpReceiver &&
	            (direction === 'sendrecv' || direction === 'sendonly')) {
	          track = rtpReceiver.track;
	          if (remoteMsid) {
	            if (!streams[remoteMsid.stream]) {
	              streams[remoteMsid.stream] = new window.MediaStream();
	            }
	            streams[remoteMsid.stream].addTrack(track);
	            receiverList.push([track, rtpReceiver, streams[remoteMsid.stream]]);
	          } else {
	            if (!streams.default) {
	              streams.default = new window.MediaStream();
	            }
	            streams.default.addTrack(track);
	            receiverList.push([track, rtpReceiver, streams.default]);
	          }
	        } else {
	          // FIXME: actually the receiver should be created later.
	          delete transceiver.rtpReceiver;
	        }
	      }
	    });
	
	    this.remoteDescription = {
	      type: description.type,
	      sdp: description.sdp
	    };
	    switch (description.type) {
	      case 'offer':
	        this._updateSignalingState('have-remote-offer');
	        break;
	      case 'answer':
	        this._updateSignalingState('stable');
	        break;
	      default:
	        throw new TypeError('unsupported type "' + description.type +
	            '"');
	    }
	    Object.keys(streams).forEach(function(sid) {
	      var stream = streams[sid];
	      if (stream.getTracks().length) {
	        self.remoteStreams.push(stream);
	        var event = new Event('addstream');
	        event.stream = stream;
	        self.dispatchEvent(event);
	        if (self.onaddstream !== null) {
	          window.setTimeout(function() {
	            self.onaddstream(event);
	          }, 0);
	        }
	
	        receiverList.forEach(function(item) {
	          var track = item[0];
	          var receiver = item[1];
	          if (stream.id !== item[2].id) {
	            return;
	          }
	          var trackEvent = new Event('track');
	          trackEvent.track = track;
	          trackEvent.receiver = receiver;
	          trackEvent.streams = [stream];
	          self.dispatchEvent(trackEvent);
	          if (self.ontrack !== null) {
	            window.setTimeout(function() {
	              self.ontrack(trackEvent);
	            }, 0);
	          }
	        });
	      }
	    });
	
	    // check whether addIceCandidate({}) was called within four seconds after
	    // setRemoteDescription.
	    window.setTimeout(function() {
	      if (!(self && self.transceivers)) {
	        return;
	      }
	      self.transceivers.forEach(function(transceiver) {
	        if (transceiver.iceTransport &&
	            transceiver.iceTransport.state === 'new' &&
	            transceiver.iceTransport.getRemoteCandidates().length > 0) {
	          console.warn('Timeout for addRemoteCandidate. Consider sending ' +
	              'an end-of-candidates notification');
	          transceiver.iceTransport.addRemoteCandidate({});
	        }
	      });
	    }, 4000);
	
	    if (arguments.length > 1 && typeof arguments[1] === 'function') {
	      window.setTimeout(arguments[1], 0);
	    }
	    return Promise.resolve();
	  };
	
	  RTCPeerConnection.prototype.close = function() {
	    this.transceivers.forEach(function(transceiver) {
	      /* not yet
	      if (transceiver.iceGatherer) {
	        transceiver.iceGatherer.close();
	      }
	      */
	      if (transceiver.iceTransport) {
	        transceiver.iceTransport.stop();
	      }
	      if (transceiver.dtlsTransport) {
	        transceiver.dtlsTransport.stop();
	      }
	      if (transceiver.rtpSender) {
	        transceiver.rtpSender.stop();
	      }
	      if (transceiver.rtpReceiver) {
	        transceiver.rtpReceiver.stop();
	      }
	    });
	    // FIXME: clean up tracks, local streams, remote streams, etc
	    this._updateSignalingState('closed');
	  };
	
	  // Update the signaling state.
	  RTCPeerConnection.prototype._updateSignalingState = function(newState) {
	    this.signalingState = newState;
	    var event = new Event('signalingstatechange');
	    this.dispatchEvent(event);
	    if (this.onsignalingstatechange !== null) {
	      this.onsignalingstatechange(event);
	    }
	  };
	
	  // Determine whether to fire the negotiationneeded event.
	  RTCPeerConnection.prototype._maybeFireNegotiationNeeded = function() {
	    var self = this;
	    if (this.signalingState !== 'stable' || this.needNegotiation === true) {
	      return;
	    }
	    this.needNegotiation = true;
	    window.setTimeout(function() {
	      if (self.needNegotiation === false) {
	        return;
	      }
	      self.needNegotiation = false;
	      var event = new Event('negotiationneeded');
	      self.dispatchEvent(event);
	      if (self.onnegotiationneeded !== null) {
	        self.onnegotiationneeded(event);
	      }
	    }, 0);
	  };
	
	  // Update the connection state.
	  RTCPeerConnection.prototype._updateConnectionState = function() {
	    var self = this;
	    var newState;
	    var states = {
	      'new': 0,
	      closed: 0,
	      connecting: 0,
	      checking: 0,
	      connected: 0,
	      completed: 0,
	      disconnected: 0,
	      failed: 0
	    };
	    this.transceivers.forEach(function(transceiver) {
	      states[transceiver.iceTransport.state]++;
	      states[transceiver.dtlsTransport.state]++;
	    });
	    // ICETransport.completed and connected are the same for this purpose.
	    states.connected += states.completed;
	
	    newState = 'new';
	    if (states.failed > 0) {
	      newState = 'failed';
	    } else if (states.connecting > 0 || states.checking > 0) {
	      newState = 'connecting';
	    } else if (states.disconnected > 0) {
	      newState = 'disconnected';
	    } else if (states.new > 0) {
	      newState = 'new';
	    } else if (states.connected > 0 || states.completed > 0) {
	      newState = 'connected';
	    }
	
	    if (newState !== self.iceConnectionState) {
	      self.iceConnectionState = newState;
	      var event = new Event('iceconnectionstatechange');
	      this.dispatchEvent(event);
	      if (this.oniceconnectionstatechange !== null) {
	        this.oniceconnectionstatechange(event);
	      }
	    }
	  };
	
	  RTCPeerConnection.prototype.createOffer = function() {
	    var self = this;
	    if (this._pendingOffer) {
	      throw new Error('createOffer called while there is a pending offer.');
	    }
	    var offerOptions;
	    if (arguments.length === 1 && typeof arguments[0] !== 'function') {
	      offerOptions = arguments[0];
	    } else if (arguments.length === 3) {
	      offerOptions = arguments[2];
	    }
	
	    var numAudioTracks = this.transceivers.filter(function(t) {
	      return t.kind === 'audio';
	    }).length;
	    var numVideoTracks = this.transceivers.filter(function(t) {
	      return t.kind === 'video';
	    }).length;
	
	    // Determine number of audio and video tracks we need to send/recv.
	    if (offerOptions) {
	      // Reject Chrome legacy constraints.
	      if (offerOptions.mandatory || offerOptions.optional) {
	        throw new TypeError(
	            'Legacy mandatory/optional constraints not supported.');
	      }
	      if (offerOptions.offerToReceiveAudio !== undefined) {
	        if (offerOptions.offerToReceiveAudio === true) {
	          numAudioTracks = 1;
	        } else if (offerOptions.offerToReceiveAudio === false) {
	          numAudioTracks = 0;
	        } else {
	          numAudioTracks = offerOptions.offerToReceiveAudio;
	        }
	      }
	      if (offerOptions.offerToReceiveVideo !== undefined) {
	        if (offerOptions.offerToReceiveVideo === true) {
	          numVideoTracks = 1;
	        } else if (offerOptions.offerToReceiveVideo === false) {
	          numVideoTracks = 0;
	        } else {
	          numVideoTracks = offerOptions.offerToReceiveVideo;
	        }
	      }
	    }
	
	    this.transceivers.forEach(function(transceiver) {
	      if (transceiver.kind === 'audio') {
	        numAudioTracks--;
	        if (numAudioTracks < 0) {
	          transceiver.wantReceive = false;
	        }
	      } else if (transceiver.kind === 'video') {
	        numVideoTracks--;
	        if (numVideoTracks < 0) {
	          transceiver.wantReceive = false;
	        }
	      }
	    });
	
	    // Create M-lines for recvonly streams.
	    while (numAudioTracks > 0 || numVideoTracks > 0) {
	      if (numAudioTracks > 0) {
	        this._createTransceiver('audio');
	        numAudioTracks--;
	      }
	      if (numVideoTracks > 0) {
	        this._createTransceiver('video');
	        numVideoTracks--;
	      }
	    }
	    // reorder tracks
	    var transceivers = sortTracks(this.transceivers);
	
	    var sdp = SDPUtils.writeSessionBoilerplate(this._sdpSessionId);
	    transceivers.forEach(function(transceiver, sdpMLineIndex) {
	      // For each track, create an ice gatherer, ice transport,
	      // dtls transport, potentially rtpsender and rtpreceiver.
	      var track = transceiver.track;
	      var kind = transceiver.kind;
	      var mid = SDPUtils.generateIdentifier();
	      transceiver.mid = mid;
	
	      if (!transceiver.iceGatherer) {
	        transceiver.iceGatherer = self.usingBundle && sdpMLineIndex > 0 ?
	            transceivers[0].iceGatherer :
	            self._createIceGatherer(mid, sdpMLineIndex);
	      }
	
	      var localCapabilities = window.RTCRtpSender.getCapabilities(kind);
	      // filter RTX until additional stuff needed for RTX is implemented
	      // in adapter.js
	      if (edgeVersion < 15019) {
	        localCapabilities.codecs = localCapabilities.codecs.filter(
	            function(codec) {
	              return codec.name !== 'rtx';
	            });
	      }
	      localCapabilities.codecs.forEach(function(codec) {
	        // work around https://bugs.chromium.org/p/webrtc/issues/detail?id=6552
	        // by adding level-asymmetry-allowed=1
	        if (codec.name === 'H264' &&
	            codec.parameters['level-asymmetry-allowed'] === undefined) {
	          codec.parameters['level-asymmetry-allowed'] = '1';
	        }
	      });
	
	      // generate an ssrc now, to be used later in rtpSender.send
	      var sendEncodingParameters = [{
	        ssrc: (2 * sdpMLineIndex + 1) * 1001
	      }];
	      if (track) {
	        // add RTX
	        if (edgeVersion >= 15019 && kind === 'video') {
	          sendEncodingParameters[0].rtx = {
	            ssrc: (2 * sdpMLineIndex + 1) * 1001 + 1
	          };
	        }
	      }
	
	      if (transceiver.wantReceive) {
	        transceiver.rtpReceiver = new window.RTCRtpReceiver(
	          transceiver.dtlsTransport,
	          kind
	        );
	      }
	
	      transceiver.localCapabilities = localCapabilities;
	      transceiver.sendEncodingParameters = sendEncodingParameters;
	    });
	
	    // always offer BUNDLE and dispose on return if not supported.
	    if (this._config.bundlePolicy !== 'max-compat') {
	      sdp += 'a=group:BUNDLE ' + transceivers.map(function(t) {
	        return t.mid;
	      }).join(' ') + '\r\n';
	    }
	    sdp += 'a=ice-options:trickle\r\n';
	
	    transceivers.forEach(function(transceiver, sdpMLineIndex) {
	      sdp += SDPUtils.writeMediaSection(transceiver,
	          transceiver.localCapabilities, 'offer', transceiver.stream);
	      sdp += 'a=rtcp-rsize\r\n';
	    });
	
	    this._pendingOffer = transceivers;
	    var desc = new window.RTCSessionDescription({
	      type: 'offer',
	      sdp: sdp
	    });
	    if (arguments.length && typeof arguments[0] === 'function') {
	      window.setTimeout(arguments[0], 0, desc);
	    }
	    return Promise.resolve(desc);
	  };
	
	  RTCPeerConnection.prototype.createAnswer = function() {
	    var sdp = SDPUtils.writeSessionBoilerplate(this._sdpSessionId);
	    if (this.usingBundle) {
	      sdp += 'a=group:BUNDLE ' + this.transceivers.map(function(t) {
	        return t.mid;
	      }).join(' ') + '\r\n';
	    }
	    this.transceivers.forEach(function(transceiver, sdpMLineIndex) {
	      if (transceiver.isDatachannel) {
	        sdp += 'm=application 0 DTLS/SCTP 5000\r\n' +
	            'c=IN IP4 0.0.0.0\r\n' +
	            'a=mid:' + transceiver.mid + '\r\n';
	        return;
	      }
	
	      // FIXME: look at direction.
	      if (transceiver.stream) {
	        var localTrack;
	        if (transceiver.kind === 'audio') {
	          localTrack = transceiver.stream.getAudioTracks()[0];
	        } else if (transceiver.kind === 'video') {
	          localTrack = transceiver.stream.getVideoTracks()[0];
	        }
	        if (localTrack) {
	          // add RTX
	          if (edgeVersion >= 15019 && transceiver.kind === 'video') {
	            transceiver.sendEncodingParameters[0].rtx = {
	              ssrc: (2 * sdpMLineIndex + 2) * 1001 + 1
	            };
	          }
	        }
	      }
	
	      // Calculate intersection of capabilities.
	      var commonCapabilities = getCommonCapabilities(
	          transceiver.localCapabilities,
	          transceiver.remoteCapabilities);
	
	      var hasRtx = commonCapabilities.codecs.filter(function(c) {
	        return c.name.toLowerCase() === 'rtx';
	      }).length;
	      if (!hasRtx && transceiver.sendEncodingParameters[0].rtx) {
	        delete transceiver.sendEncodingParameters[0].rtx;
	      }
	
	      sdp += SDPUtils.writeMediaSection(transceiver, commonCapabilities,
	          'answer', transceiver.stream);
	      if (transceiver.rtcpParameters &&
	          transceiver.rtcpParameters.reducedSize) {
	        sdp += 'a=rtcp-rsize\r\n';
	      }
	    });
	
	    var desc = new window.RTCSessionDescription({
	      type: 'answer',
	      sdp: sdp
	    });
	    if (arguments.length && typeof arguments[0] === 'function') {
	      window.setTimeout(arguments[0], 0, desc);
	    }
	    return Promise.resolve(desc);
	  };
	
	  RTCPeerConnection.prototype.addIceCandidate = function(candidate) {
	    if (!candidate) {
	      for (var j = 0; j < this.transceivers.length; j++) {
	        this.transceivers[j].iceTransport.addRemoteCandidate({});
	        if (this.usingBundle) {
	          return Promise.resolve();
	        }
	      }
	    } else {
	      var mLineIndex = candidate.sdpMLineIndex;
	      if (candidate.sdpMid) {
	        for (var i = 0; i < this.transceivers.length; i++) {
	          if (this.transceivers[i].mid === candidate.sdpMid) {
	            mLineIndex = i;
	            break;
	          }
	        }
	      }
	      var transceiver = this.transceivers[mLineIndex];
	      if (transceiver) {
	        var cand = Object.keys(candidate.candidate).length > 0 ?
	            SDPUtils.parseCandidate(candidate.candidate) : {};
	        // Ignore Chrome's invalid candidates since Edge does not like them.
	        if (cand.protocol === 'tcp' && (cand.port === 0 || cand.port === 9)) {
	          return Promise.resolve();
	        }
	        // Ignore RTCP candidates, we assume RTCP-MUX.
	        if (cand.component &&
	            !(cand.component === '1' || cand.component === 1)) {
	          return Promise.resolve();
	        }
	        transceiver.iceTransport.addRemoteCandidate(cand);
	
	        // update the remoteDescription.
	        var sections = SDPUtils.splitSections(this.remoteDescription.sdp);
	        sections[mLineIndex + 1] += (cand.type ? candidate.candidate.trim()
	            : 'a=end-of-candidates') + '\r\n';
	        this.remoteDescription.sdp = sections.join('');
	      }
	    }
	    if (arguments.length > 1 && typeof arguments[1] === 'function') {
	      window.setTimeout(arguments[1], 0);
	    }
	    return Promise.resolve();
	  };
	
	  RTCPeerConnection.prototype.getStats = function() {
	    var promises = [];
	    this.transceivers.forEach(function(transceiver) {
	      ['rtpSender', 'rtpReceiver', 'iceGatherer', 'iceTransport',
	        'dtlsTransport'].forEach(function(method) {
	          if (transceiver[method]) {
	            promises.push(transceiver[method].getStats());
	          }
	        });
	    });
	    var cb = arguments.length > 1 && typeof arguments[1] === 'function' &&
	        arguments[1];
	    var fixStatsType = function(stat) {
	      return {
	        inboundrtp: 'inbound-rtp',
	        outboundrtp: 'outbound-rtp',
	        candidatepair: 'candidate-pair',
	        localcandidate: 'local-candidate',
	        remotecandidate: 'remote-candidate'
	      }[stat.type] || stat.type;
	    };
	    return new Promise(function(resolve) {
	      // shim getStats with maplike support
	      var results = new Map();
	      Promise.all(promises).then(function(res) {
	        res.forEach(function(result) {
	          Object.keys(result).forEach(function(id) {
	            result[id].type = fixStatsType(result[id]);
	            results.set(id, result[id]);
	          });
	        });
	        if (cb) {
	          window.setTimeout(cb, 0, results);
	        }
	        resolve(results);
	      });
	    });
	  };
	  return RTCPeerConnection;
	};


/***/ }),
/* 11 */
/***/ (function(module, exports) {

	 /* eslint-env node */
	'use strict';
	
	// SDP helpers.
	var SDPUtils = {};
	
	// Generate an alphanumeric identifier for cname or mids.
	// TODO: use UUIDs instead? https://gist.github.com/jed/982883
	SDPUtils.generateIdentifier = function() {
	  return Math.random().toString(36).substr(2, 10);
	};
	
	// The RTCP CNAME used by all peerconnections from the same JS.
	SDPUtils.localCName = SDPUtils.generateIdentifier();
	
	// Splits SDP into lines, dealing with both CRLF and LF.
	SDPUtils.splitLines = function(blob) {
	  return blob.trim().split('\n').map(function(line) {
	    return line.trim();
	  });
	};
	// Splits SDP into sessionpart and mediasections. Ensures CRLF.
	SDPUtils.splitSections = function(blob) {
	  var parts = blob.split('\nm=');
	  return parts.map(function(part, index) {
	    return (index > 0 ? 'm=' + part : part).trim() + '\r\n';
	  });
	};
	
	// Returns lines that start with a certain prefix.
	SDPUtils.matchPrefix = function(blob, prefix) {
	  return SDPUtils.splitLines(blob).filter(function(line) {
	    return line.indexOf(prefix) === 0;
	  });
	};
	
	// Parses an ICE candidate line. Sample input:
	// candidate:702786350 2 udp 41819902 8.8.8.8 60769 typ relay raddr 8.8.8.8
	// rport 55996"
	SDPUtils.parseCandidate = function(line) {
	  var parts;
	  // Parse both variants.
	  if (line.indexOf('a=candidate:') === 0) {
	    parts = line.substring(12).split(' ');
	  } else {
	    parts = line.substring(10).split(' ');
	  }
	
	  var candidate = {
	    foundation: parts[0],
	    component: parseInt(parts[1], 10),
	    protocol: parts[2].toLowerCase(),
	    priority: parseInt(parts[3], 10),
	    ip: parts[4],
	    port: parseInt(parts[5], 10),
	    // skip parts[6] == 'typ'
	    type: parts[7]
	  };
	
	  for (var i = 8; i < parts.length; i += 2) {
	    switch (parts[i]) {
	      case 'raddr':
	        candidate.relatedAddress = parts[i + 1];
	        break;
	      case 'rport':
	        candidate.relatedPort = parseInt(parts[i + 1], 10);
	        break;
	      case 'tcptype':
	        candidate.tcpType = parts[i + 1];
	        break;
	      default: // extension handling, in particular ufrag
	        candidate[parts[i]] = parts[i + 1];
	        break;
	    }
	  }
	  return candidate;
	};
	
	// Translates a candidate object into SDP candidate attribute.
	SDPUtils.writeCandidate = function(candidate) {
	  var sdp = [];
	  sdp.push(candidate.foundation);
	  sdp.push(candidate.component);
	  sdp.push(candidate.protocol.toUpperCase());
	  sdp.push(candidate.priority);
	  sdp.push(candidate.ip);
	  sdp.push(candidate.port);
	
	  var type = candidate.type;
	  sdp.push('typ');
	  sdp.push(type);
	  if (type !== 'host' && candidate.relatedAddress &&
	      candidate.relatedPort) {
	    sdp.push('raddr');
	    sdp.push(candidate.relatedAddress); // was: relAddr
	    sdp.push('rport');
	    sdp.push(candidate.relatedPort); // was: relPort
	  }
	  if (candidate.tcpType && candidate.protocol.toLowerCase() === 'tcp') {
	    sdp.push('tcptype');
	    sdp.push(candidate.tcpType);
	  }
	  if (candidate.ufrag) {
	    sdp.push('ufrag');
	    sdp.push(candidate.ufrag);
	  }
	  return 'candidate:' + sdp.join(' ');
	};
	
	// Parses an ice-options line, returns an array of option tags.
	// a=ice-options:foo bar
	SDPUtils.parseIceOptions = function(line) {
	  return line.substr(14).split(' ');
	}
	
	// Parses an rtpmap line, returns RTCRtpCoddecParameters. Sample input:
	// a=rtpmap:111 opus/48000/2
	SDPUtils.parseRtpMap = function(line) {
	  var parts = line.substr(9).split(' ');
	  var parsed = {
	    payloadType: parseInt(parts.shift(), 10) // was: id
	  };
	
	  parts = parts[0].split('/');
	
	  parsed.name = parts[0];
	  parsed.clockRate = parseInt(parts[1], 10); // was: clockrate
	  // was: channels
	  parsed.numChannels = parts.length === 3 ? parseInt(parts[2], 10) : 1;
	  return parsed;
	};
	
	// Generate an a=rtpmap line from RTCRtpCodecCapability or
	// RTCRtpCodecParameters.
	SDPUtils.writeRtpMap = function(codec) {
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  return 'a=rtpmap:' + pt + ' ' + codec.name + '/' + codec.clockRate +
	      (codec.numChannels !== 1 ? '/' + codec.numChannels : '') + '\r\n';
	};
	
	// Parses an a=extmap line (headerextension from RFC 5285). Sample input:
	// a=extmap:2 urn:ietf:params:rtp-hdrext:toffset
	// a=extmap:2/sendonly urn:ietf:params:rtp-hdrext:toffset
	SDPUtils.parseExtmap = function(line) {
	  var parts = line.substr(9).split(' ');
	  return {
	    id: parseInt(parts[0], 10),
	    direction: parts[0].indexOf('/') > 0 ? parts[0].split('/')[1] : 'sendrecv',
	    uri: parts[1]
	  };
	};
	
	// Generates a=extmap line from RTCRtpHeaderExtensionParameters or
	// RTCRtpHeaderExtension.
	SDPUtils.writeExtmap = function(headerExtension) {
	  return 'a=extmap:' + (headerExtension.id || headerExtension.preferredId) +
	      (headerExtension.direction && headerExtension.direction !== 'sendrecv'
	          ? '/' + headerExtension.direction
	          : '') +
	      ' ' + headerExtension.uri + '\r\n';
	};
	
	// Parses an ftmp line, returns dictionary. Sample input:
	// a=fmtp:96 vbr=on;cng=on
	// Also deals with vbr=on; cng=on
	SDPUtils.parseFmtp = function(line) {
	  var parsed = {};
	  var kv;
	  var parts = line.substr(line.indexOf(' ') + 1).split(';');
	  for (var j = 0; j < parts.length; j++) {
	    kv = parts[j].trim().split('=');
	    parsed[kv[0].trim()] = kv[1];
	  }
	  return parsed;
	};
	
	// Generates an a=ftmp line from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeFmtp = function(codec) {
	  var line = '';
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  if (codec.parameters && Object.keys(codec.parameters).length) {
	    var params = [];
	    Object.keys(codec.parameters).forEach(function(param) {
	      params.push(param + '=' + codec.parameters[param]);
	    });
	    line += 'a=fmtp:' + pt + ' ' + params.join(';') + '\r\n';
	  }
	  return line;
	};
	
	// Parses an rtcp-fb line, returns RTCPRtcpFeedback object. Sample input:
	// a=rtcp-fb:98 nack rpsi
	SDPUtils.parseRtcpFb = function(line) {
	  var parts = line.substr(line.indexOf(' ') + 1).split(' ');
	  return {
	    type: parts.shift(),
	    parameter: parts.join(' ')
	  };
	};
	// Generate a=rtcp-fb lines from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeRtcpFb = function(codec) {
	  var lines = '';
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  if (codec.rtcpFeedback && codec.rtcpFeedback.length) {
	    // FIXME: special handling for trr-int?
	    codec.rtcpFeedback.forEach(function(fb) {
	      lines += 'a=rtcp-fb:' + pt + ' ' + fb.type +
	      (fb.parameter && fb.parameter.length ? ' ' + fb.parameter : '') +
	          '\r\n';
	    });
	  }
	  return lines;
	};
	
	// Parses an RFC 5576 ssrc media attribute. Sample input:
	// a=ssrc:3735928559 cname:something
	SDPUtils.parseSsrcMedia = function(line) {
	  var sp = line.indexOf(' ');
	  var parts = {
	    ssrc: parseInt(line.substr(7, sp - 7), 10)
	  };
	  var colon = line.indexOf(':', sp);
	  if (colon > -1) {
	    parts.attribute = line.substr(sp + 1, colon - sp - 1);
	    parts.value = line.substr(colon + 1);
	  } else {
	    parts.attribute = line.substr(sp + 1);
	  }
	  return parts;
	};
	
	// Extracts the MID (RFC 5888) from a media section.
	// returns the MID or undefined if no mid line was found.
	SDPUtils.getMid = function(mediaSection) {
	  var mid = SDPUtils.matchPrefix(mediaSection, 'a=mid:')[0];
	  if (mid) {
	    return mid.substr(6);
	  }
	}
	
	SDPUtils.parseFingerprint = function(line) {
	  var parts = line.substr(14).split(' ');
	  return {
	    algorithm: parts[0].toLowerCase(), // algorithm is case-sensitive in Edge.
	    value: parts[1]
	  };
	};
	
	// Extracts DTLS parameters from SDP media section or sessionpart.
	// FIXME: for consistency with other functions this should only
	//   get the fingerprint line as input. See also getIceParameters.
	SDPUtils.getDtlsParameters = function(mediaSection, sessionpart) {
	  var lines = SDPUtils.matchPrefix(mediaSection + sessionpart,
	      'a=fingerprint:');
	  // Note: a=setup line is ignored since we use the 'auto' role.
	  // Note2: 'algorithm' is not case sensitive except in Edge.
	  return {
	    role: 'auto',
	    fingerprints: lines.map(SDPUtils.parseFingerprint)
	  };
	};
	
	// Serializes DTLS parameters to SDP.
	SDPUtils.writeDtlsParameters = function(params, setupType) {
	  var sdp = 'a=setup:' + setupType + '\r\n';
	  params.fingerprints.forEach(function(fp) {
	    sdp += 'a=fingerprint:' + fp.algorithm + ' ' + fp.value + '\r\n';
	  });
	  return sdp;
	};
	// Parses ICE information from SDP media section or sessionpart.
	// FIXME: for consistency with other functions this should only
	//   get the ice-ufrag and ice-pwd lines as input.
	SDPUtils.getIceParameters = function(mediaSection, sessionpart) {
	  var lines = SDPUtils.splitLines(mediaSection);
	  // Search in session part, too.
	  lines = lines.concat(SDPUtils.splitLines(sessionpart));
	  var iceParameters = {
	    usernameFragment: lines.filter(function(line) {
	      return line.indexOf('a=ice-ufrag:') === 0;
	    })[0].substr(12),
	    password: lines.filter(function(line) {
	      return line.indexOf('a=ice-pwd:') === 0;
	    })[0].substr(10)
	  };
	  return iceParameters;
	};
	
	// Serializes ICE parameters to SDP.
	SDPUtils.writeIceParameters = function(params) {
	  return 'a=ice-ufrag:' + params.usernameFragment + '\r\n' +
	      'a=ice-pwd:' + params.password + '\r\n';
	};
	
	// Parses the SDP media section and returns RTCRtpParameters.
	SDPUtils.parseRtpParameters = function(mediaSection) {
	  var description = {
	    codecs: [],
	    headerExtensions: [],
	    fecMechanisms: [],
	    rtcp: []
	  };
	  var lines = SDPUtils.splitLines(mediaSection);
	  var mline = lines[0].split(' ');
	  for (var i = 3; i < mline.length; i++) { // find all codecs from mline[3..]
	    var pt = mline[i];
	    var rtpmapline = SDPUtils.matchPrefix(
	        mediaSection, 'a=rtpmap:' + pt + ' ')[0];
	    if (rtpmapline) {
	      var codec = SDPUtils.parseRtpMap(rtpmapline);
	      var fmtps = SDPUtils.matchPrefix(
	          mediaSection, 'a=fmtp:' + pt + ' ');
	      // Only the first a=fmtp:<pt> is considered.
	      codec.parameters = fmtps.length ? SDPUtils.parseFmtp(fmtps[0]) : {};
	      codec.rtcpFeedback = SDPUtils.matchPrefix(
	          mediaSection, 'a=rtcp-fb:' + pt + ' ')
	        .map(SDPUtils.parseRtcpFb);
	      description.codecs.push(codec);
	      // parse FEC mechanisms from rtpmap lines.
	      switch (codec.name.toUpperCase()) {
	        case 'RED':
	        case 'ULPFEC':
	          description.fecMechanisms.push(codec.name.toUpperCase());
	          break;
	        default: // only RED and ULPFEC are recognized as FEC mechanisms.
	          break;
	      }
	    }
	  }
	  SDPUtils.matchPrefix(mediaSection, 'a=extmap:').forEach(function(line) {
	    description.headerExtensions.push(SDPUtils.parseExtmap(line));
	  });
	  // FIXME: parse rtcp.
	  return description;
	};
	
	// Generates parts of the SDP media section describing the capabilities /
	// parameters.
	SDPUtils.writeRtpDescription = function(kind, caps) {
	  var sdp = '';
	
	  // Build the mline.
	  sdp += 'm=' + kind + ' ';
	  sdp += caps.codecs.length > 0 ? '9' : '0'; // reject if no codecs.
	  sdp += ' UDP/TLS/RTP/SAVPF ';
	  sdp += caps.codecs.map(function(codec) {
	    if (codec.preferredPayloadType !== undefined) {
	      return codec.preferredPayloadType;
	    }
	    return codec.payloadType;
	  }).join(' ') + '\r\n';
	
	  sdp += 'c=IN IP4 0.0.0.0\r\n';
	  sdp += 'a=rtcp:9 IN IP4 0.0.0.0\r\n';
	
	  // Add a=rtpmap lines for each codec. Also fmtp and rtcp-fb.
	  caps.codecs.forEach(function(codec) {
	    sdp += SDPUtils.writeRtpMap(codec);
	    sdp += SDPUtils.writeFmtp(codec);
	    sdp += SDPUtils.writeRtcpFb(codec);
	  });
	  var maxptime = 0;
	  caps.codecs.forEach(function(codec) {
	    if (codec.maxptime > maxptime) {
	      maxptime = codec.maxptime;
	    }
	  });
	  if (maxptime > 0) {
	    sdp += 'a=maxptime:' + maxptime + '\r\n';
	  }
	  sdp += 'a=rtcp-mux\r\n';
	
	  caps.headerExtensions.forEach(function(extension) {
	    sdp += SDPUtils.writeExtmap(extension);
	  });
	  // FIXME: write fecMechanisms.
	  return sdp;
	};
	
	// Parses the SDP media section and returns an array of
	// RTCRtpEncodingParameters.
	SDPUtils.parseRtpEncodingParameters = function(mediaSection) {
	  var encodingParameters = [];
	  var description = SDPUtils.parseRtpParameters(mediaSection);
	  var hasRed = description.fecMechanisms.indexOf('RED') !== -1;
	  var hasUlpfec = description.fecMechanisms.indexOf('ULPFEC') !== -1;
	
	  // filter a=ssrc:... cname:, ignore PlanB-msid
	  var ssrcs = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
	  .map(function(line) {
	    return SDPUtils.parseSsrcMedia(line);
	  })
	  .filter(function(parts) {
	    return parts.attribute === 'cname';
	  });
	  var primarySsrc = ssrcs.length > 0 && ssrcs[0].ssrc;
	  var secondarySsrc;
	
	  var flows = SDPUtils.matchPrefix(mediaSection, 'a=ssrc-group:FID')
	  .map(function(line) {
	    var parts = line.split(' ');
	    parts.shift();
	    return parts.map(function(part) {
	      return parseInt(part, 10);
	    });
	  });
	  if (flows.length > 0 && flows[0].length > 1 && flows[0][0] === primarySsrc) {
	    secondarySsrc = flows[0][1];
	  }
	
	  description.codecs.forEach(function(codec) {
	    if (codec.name.toUpperCase() === 'RTX' && codec.parameters.apt) {
	      var encParam = {
	        ssrc: primarySsrc,
	        codecPayloadType: parseInt(codec.parameters.apt, 10),
	        rtx: {
	          ssrc: secondarySsrc
	        }
	      };
	      encodingParameters.push(encParam);
	      if (hasRed) {
	        encParam = JSON.parse(JSON.stringify(encParam));
	        encParam.fec = {
	          ssrc: secondarySsrc,
	          mechanism: hasUlpfec ? 'red+ulpfec' : 'red'
	        };
	        encodingParameters.push(encParam);
	      }
	    }
	  });
	  if (encodingParameters.length === 0 && primarySsrc) {
	    encodingParameters.push({
	      ssrc: primarySsrc
	    });
	  }
	
	  // we support both b=AS and b=TIAS but interpret AS as TIAS.
	  var bandwidth = SDPUtils.matchPrefix(mediaSection, 'b=');
	  if (bandwidth.length) {
	    if (bandwidth[0].indexOf('b=TIAS:') === 0) {
	      bandwidth = parseInt(bandwidth[0].substr(7), 10);
	    } else if (bandwidth[0].indexOf('b=AS:') === 0) {
	      // use formula from JSEP to convert b=AS to TIAS value.
	      bandwidth = parseInt(bandwidth[0].substr(5), 10) * 1000 * 0.95
	          - (50 * 40 * 8);
	    } else {
	      bandwidth = undefined;
	    }
	    encodingParameters.forEach(function(params) {
	      params.maxBitrate = bandwidth;
	    });
	  }
	  return encodingParameters;
	};
	
	// parses http://draft.ortc.org/#rtcrtcpparameters*
	SDPUtils.parseRtcpParameters = function(mediaSection) {
	  var rtcpParameters = {};
	
	  var cname;
	  // Gets the first SSRC. Note that with RTX there might be multiple
	  // SSRCs.
	  var remoteSsrc = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
	      .map(function(line) {
	        return SDPUtils.parseSsrcMedia(line);
	      })
	      .filter(function(obj) {
	        return obj.attribute === 'cname';
	      })[0];
	  if (remoteSsrc) {
	    rtcpParameters.cname = remoteSsrc.value;
	    rtcpParameters.ssrc = remoteSsrc.ssrc;
	  }
	
	  // Edge uses the compound attribute instead of reducedSize
	  // compound is !reducedSize
	  var rsize = SDPUtils.matchPrefix(mediaSection, 'a=rtcp-rsize');
	  rtcpParameters.reducedSize = rsize.length > 0;
	  rtcpParameters.compound = rsize.length === 0;
	
	  // parses the rtcp-mux attrіbute.
	  // Note that Edge does not support unmuxed RTCP.
	  var mux = SDPUtils.matchPrefix(mediaSection, 'a=rtcp-mux');
	  rtcpParameters.mux = mux.length > 0;
	
	  return rtcpParameters;
	};
	
	// parses either a=msid: or a=ssrc:... msid lines and returns
	// the id of the MediaStream and MediaStreamTrack.
	SDPUtils.parseMsid = function(mediaSection) {
	  var parts;
	  var spec = SDPUtils.matchPrefix(mediaSection, 'a=msid:');
	  if (spec.length === 1) {
	    parts = spec[0].substr(7).split(' ');
	    return {stream: parts[0], track: parts[1]};
	  }
	  var planB = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
	  .map(function(line) {
	    return SDPUtils.parseSsrcMedia(line);
	  })
	  .filter(function(parts) {
	    return parts.attribute === 'msid';
	  });
	  if (planB.length > 0) {
	    parts = planB[0].value.split(' ');
	    return {stream: parts[0], track: parts[1]};
	  }
	};
	
	// Generate a session ID for SDP.
	// https://tools.ietf.org/html/draft-ietf-rtcweb-jsep-20#section-5.2.1
	// recommends using a cryptographically random +ve 64-bit value
	// but right now this should be acceptable and within the right range
	SDPUtils.generateSessionId = function() {
	  return Math.random().toString().substr(2, 21);
	};
	
	// Write boilder plate for start of SDP
	// sessId argument is optional - if not supplied it will
	// be generated randomly
	// sessVersion is optional and defaults to 2
	SDPUtils.writeSessionBoilerplate = function(sessId, sessVer) {
	  var sessionId;
	  var version = sessVer !== undefined ? sessVer : 2;
	  if (sessId) {
	    sessionId = sessId;
	  } else {
	    sessionId = SDPUtils.generateSessionId();
	  }
	  // FIXME: sess-id should be an NTP timestamp.
	  return 'v=0\r\n' +
	      'o=thisisadapterortc ' + sessionId + ' ' + version + ' IN IP4 127.0.0.1\r\n' +
	      's=-\r\n' +
	      't=0 0\r\n';
	};
	
	SDPUtils.writeMediaSection = function(transceiver, caps, type, stream) {
	  var sdp = SDPUtils.writeRtpDescription(transceiver.kind, caps);
	
	  // Map ICE parameters (ufrag, pwd) to SDP.
	  sdp += SDPUtils.writeIceParameters(
	      transceiver.iceGatherer.getLocalParameters());
	
	  // Map DTLS parameters to SDP.
	  sdp += SDPUtils.writeDtlsParameters(
	      transceiver.dtlsTransport.getLocalParameters(),
	      type === 'offer' ? 'actpass' : 'active');
	
	  sdp += 'a=mid:' + transceiver.mid + '\r\n';
	
	  if (transceiver.direction) {
	    sdp += 'a=' + transceiver.direction + '\r\n';
	  } else if (transceiver.rtpSender && transceiver.rtpReceiver) {
	    sdp += 'a=sendrecv\r\n';
	  } else if (transceiver.rtpSender) {
	    sdp += 'a=sendonly\r\n';
	  } else if (transceiver.rtpReceiver) {
	    sdp += 'a=recvonly\r\n';
	  } else {
	    sdp += 'a=inactive\r\n';
	  }
	
	  if (transceiver.rtpSender) {
	    // spec.
	    var msid = 'msid:' + stream.id + ' ' +
	        transceiver.rtpSender.track.id + '\r\n';
	    sdp += 'a=' + msid;
	
	    // for Chrome.
	    sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].ssrc +
	        ' ' + msid;
	    if (transceiver.sendEncodingParameters[0].rtx) {
	      sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].rtx.ssrc +
	          ' ' + msid;
	      sdp += 'a=ssrc-group:FID ' +
	          transceiver.sendEncodingParameters[0].ssrc + ' ' +
	          transceiver.sendEncodingParameters[0].rtx.ssrc +
	          '\r\n';
	    }
	  }
	  // FIXME: this should be written by writeRtpDescription.
	  sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].ssrc +
	      ' cname:' + SDPUtils.localCName + '\r\n';
	  if (transceiver.rtpSender && transceiver.sendEncodingParameters[0].rtx) {
	    sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].rtx.ssrc +
	        ' cname:' + SDPUtils.localCName + '\r\n';
	  }
	  return sdp;
	};
	
	// Gets the direction from the mediaSection or the sessionpart.
	SDPUtils.getDirection = function(mediaSection, sessionpart) {
	  // Look for sendrecv, sendonly, recvonly, inactive, default to sendrecv.
	  var lines = SDPUtils.splitLines(mediaSection);
	  for (var i = 0; i < lines.length; i++) {
	    switch (lines[i]) {
	      case 'a=sendrecv':
	      case 'a=sendonly':
	      case 'a=recvonly':
	      case 'a=inactive':
	        return lines[i].substr(2);
	      default:
	        // FIXME: What should happen here?
	    }
	  }
	  if (sessionpart) {
	    return SDPUtils.getDirection(sessionpart);
	  }
	  return 'sendrecv';
	};
	
	SDPUtils.getKind = function(mediaSection) {
	  var lines = SDPUtils.splitLines(mediaSection);
	  var mline = lines[0].split(' ');
	  return mline[0].substr(2);
	};
	
	SDPUtils.isRejected = function(mediaSection) {
	  return mediaSection.split(' ', 2)[1] === '0';
	};
	
	// Expose public methods.
	module.exports = SDPUtils;


/***/ }),
/* 12 */
/***/ (function(module, exports) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	
	// Expose public methods.
	module.exports = function(window) {
	  var navigator = window && window.navigator;
	
	  var shimError_ = function(e) {
	    return {
	      name: {PermissionDeniedError: 'NotAllowedError'}[e.name] || e.name,
	      message: e.message,
	      constraint: e.constraint,
	      toString: function() {
	        return this.name;
	      }
	    };
	  };
	
	  // getUserMedia error shim.
	  var origGetUserMedia = navigator.mediaDevices.getUserMedia.
	      bind(navigator.mediaDevices);
	  navigator.mediaDevices.getUserMedia = function(c) {
	    return origGetUserMedia(c).catch(function(e) {
	      return Promise.reject(shimError_(e));
	    });
	  };
	};


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	
	var utils = __webpack_require__(6);
	
	var firefoxShim = {
	  shimOnTrack: function(window) {
	    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
	        window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
	        get: function() {
	          return this._ontrack;
	        },
	        set: function(f) {
	          if (this._ontrack) {
	            this.removeEventListener('track', this._ontrack);
	            this.removeEventListener('addstream', this._ontrackpoly);
	          }
	          this.addEventListener('track', this._ontrack = f);
	          this.addEventListener('addstream', this._ontrackpoly = function(e) {
	            e.stream.getTracks().forEach(function(track) {
	              var event = new Event('track');
	              event.track = track;
	              event.receiver = {track: track};
	              event.streams = [e.stream];
	              this.dispatchEvent(event);
	            }.bind(this));
	          }.bind(this));
	        }
	      });
	    }
	  },
	
	  shimSourceObject: function(window) {
	    // Firefox has supported mozSrcObject since FF22, unprefixed in 42.
	    if (typeof window === 'object') {
	      if (window.HTMLMediaElement &&
	        !('srcObject' in window.HTMLMediaElement.prototype)) {
	        // Shim the srcObject property, once, when HTMLMediaElement is found.
	        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
	          get: function() {
	            return this.mozSrcObject;
	          },
	          set: function(stream) {
	            this.mozSrcObject = stream;
	          }
	        });
	      }
	    }
	  },
	
	  shimPeerConnection: function(window) {
	    var browserDetails = utils.detectBrowser(window);
	
	    if (typeof window !== 'object' || !(window.RTCPeerConnection ||
	        window.mozRTCPeerConnection)) {
	      return; // probably media.peerconnection.enabled=false in about:config
	    }
	    // The RTCPeerConnection object.
	    if (!window.RTCPeerConnection) {
	      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	        if (browserDetails.version < 38) {
	          // .urls is not supported in FF < 38.
	          // create RTCIceServers with a single url.
	          if (pcConfig && pcConfig.iceServers) {
	            var newIceServers = [];
	            for (var i = 0; i < pcConfig.iceServers.length; i++) {
	              var server = pcConfig.iceServers[i];
	              if (server.hasOwnProperty('urls')) {
	                for (var j = 0; j < server.urls.length; j++) {
	                  var newServer = {
	                    url: server.urls[j]
	                  };
	                  if (server.urls[j].indexOf('turn') === 0) {
	                    newServer.username = server.username;
	                    newServer.credential = server.credential;
	                  }
	                  newIceServers.push(newServer);
	                }
	              } else {
	                newIceServers.push(pcConfig.iceServers[i]);
	              }
	            }
	            pcConfig.iceServers = newIceServers;
	          }
	        }
	        return new window.mozRTCPeerConnection(pcConfig, pcConstraints);
	      };
	      window.RTCPeerConnection.prototype =
	          window.mozRTCPeerConnection.prototype;
	
	      // wrap static methods. Currently just generateCertificate.
	      if (window.mozRTCPeerConnection.generateCertificate) {
	        Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	          get: function() {
	            return window.mozRTCPeerConnection.generateCertificate;
	          }
	        });
	      }
	
	      window.RTCSessionDescription = window.mozRTCSessionDescription;
	      window.RTCIceCandidate = window.mozRTCIceCandidate;
	    }
	
	    // shim away need for obsolete RTCIceCandidate/RTCSessionDescription.
	    ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
	        .forEach(function(method) {
	          var nativeMethod = window.RTCPeerConnection.prototype[method];
	          window.RTCPeerConnection.prototype[method] = function() {
	            arguments[0] = new ((method === 'addIceCandidate') ?
	                window.RTCIceCandidate :
	                window.RTCSessionDescription)(arguments[0]);
	            return nativeMethod.apply(this, arguments);
	          };
	        });
	
	    // support for addIceCandidate(null or undefined)
	    var nativeAddIceCandidate =
	        window.RTCPeerConnection.prototype.addIceCandidate;
	    window.RTCPeerConnection.prototype.addIceCandidate = function() {
	      if (!arguments[0]) {
	        if (arguments[1]) {
	          arguments[1].apply(null);
	        }
	        return Promise.resolve();
	      }
	      return nativeAddIceCandidate.apply(this, arguments);
	    };
	
	    // shim getStats with maplike support
	    var makeMapStats = function(stats) {
	      var map = new Map();
	      Object.keys(stats).forEach(function(key) {
	        map.set(key, stats[key]);
	        map[key] = stats[key];
	      });
	      return map;
	    };
	
	    var modernStatsTypes = {
	      inboundrtp: 'inbound-rtp',
	      outboundrtp: 'outbound-rtp',
	      candidatepair: 'candidate-pair',
	      localcandidate: 'local-candidate',
	      remotecandidate: 'remote-candidate'
	    };
	
	    var nativeGetStats = window.RTCPeerConnection.prototype.getStats;
	    window.RTCPeerConnection.prototype.getStats = function(
	      selector,
	      onSucc,
	      onErr
	    ) {
	      return nativeGetStats.apply(this, [selector || null])
	        .then(function(stats) {
	          if (browserDetails.version < 48) {
	            stats = makeMapStats(stats);
	          }
	          if (browserDetails.version < 53 && !onSucc) {
	            // Shim only promise getStats with spec-hyphens in type names
	            // Leave callback version alone; misc old uses of forEach before Map
	            try {
	              stats.forEach(function(stat) {
	                stat.type = modernStatsTypes[stat.type] || stat.type;
	              });
	            } catch (e) {
	              if (e.name !== 'TypeError') {
	                throw e;
	              }
	              // Avoid TypeError: "type" is read-only, in old versions. 34-43ish
	              stats.forEach(function(stat, i) {
	                stats.set(i, Object.assign({}, stat, {
	                  type: modernStatsTypes[stat.type] || stat.type
	                }));
	              });
	            }
	          }
	          return stats;
	        })
	        .then(onSucc, onErr);
	    };
	  }
	};
	
	// Expose public methods.
	module.exports = {
	  shimOnTrack: firefoxShim.shimOnTrack,
	  shimSourceObject: firefoxShim.shimSourceObject,
	  shimPeerConnection: firefoxShim.shimPeerConnection,
	  shimGetUserMedia: __webpack_require__(14)
	};


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	 /* eslint-env node */
	'use strict';
	
	var utils = __webpack_require__(6);
	var logging = utils.log;
	
	// Expose public methods.
	module.exports = function(window) {
	  var browserDetails = utils.detectBrowser(window);
	  var navigator = window && window.navigator;
	  var MediaStreamTrack = window && window.MediaStreamTrack;
	
	  var shimError_ = function(e) {
	    return {
	      name: {
	        InternalError: 'NotReadableError',
	        NotSupportedError: 'TypeError',
	        PermissionDeniedError: 'NotAllowedError',
	        SecurityError: 'NotAllowedError'
	      }[e.name] || e.name,
	      message: {
	        'The operation is insecure.': 'The request is not allowed by the ' +
	        'user agent or the platform in the current context.'
	      }[e.message] || e.message,
	      constraint: e.constraint,
	      toString: function() {
	        return this.name + (this.message && ': ') + this.message;
	      }
	    };
	  };
	
	  // getUserMedia constraints shim.
	  var getUserMedia_ = function(constraints, onSuccess, onError) {
	    var constraintsToFF37_ = function(c) {
	      if (typeof c !== 'object' || c.require) {
	        return c;
	      }
	      var require = [];
	      Object.keys(c).forEach(function(key) {
	        if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	          return;
	        }
	        var r = c[key] = (typeof c[key] === 'object') ?
	            c[key] : {ideal: c[key]};
	        if (r.min !== undefined ||
	            r.max !== undefined || r.exact !== undefined) {
	          require.push(key);
	        }
	        if (r.exact !== undefined) {
	          if (typeof r.exact === 'number') {
	            r. min = r.max = r.exact;
	          } else {
	            c[key] = r.exact;
	          }
	          delete r.exact;
	        }
	        if (r.ideal !== undefined) {
	          c.advanced = c.advanced || [];
	          var oc = {};
	          if (typeof r.ideal === 'number') {
	            oc[key] = {min: r.ideal, max: r.ideal};
	          } else {
	            oc[key] = r.ideal;
	          }
	          c.advanced.push(oc);
	          delete r.ideal;
	          if (!Object.keys(r).length) {
	            delete c[key];
	          }
	        }
	      });
	      if (require.length) {
	        c.require = require;
	      }
	      return c;
	    };
	    constraints = JSON.parse(JSON.stringify(constraints));
	    if (browserDetails.version < 38) {
	      logging('spec: ' + JSON.stringify(constraints));
	      if (constraints.audio) {
	        constraints.audio = constraintsToFF37_(constraints.audio);
	      }
	      if (constraints.video) {
	        constraints.video = constraintsToFF37_(constraints.video);
	      }
	      logging('ff37: ' + JSON.stringify(constraints));
	    }
	    return navigator.mozGetUserMedia(constraints, onSuccess, function(e) {
	      onError(shimError_(e));
	    });
	  };
	
	  // Returns the result of getUserMedia as a Promise.
	  var getUserMediaPromise_ = function(constraints) {
	    return new Promise(function(resolve, reject) {
	      getUserMedia_(constraints, resolve, reject);
	    });
	  };
	
	  // Shim for mediaDevices on older versions.
	  if (!navigator.mediaDevices) {
	    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	      addEventListener: function() { },
	      removeEventListener: function() { }
	    };
	  }
	  navigator.mediaDevices.enumerateDevices =
	      navigator.mediaDevices.enumerateDevices || function() {
	        return new Promise(function(resolve) {
	          var infos = [
	            {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
	            {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
	          ];
	          resolve(infos);
	        });
	      };
	
	  if (browserDetails.version < 41) {
	    // Work around http://bugzil.la/1169665
	    var orgEnumerateDevices =
	        navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
	    navigator.mediaDevices.enumerateDevices = function() {
	      return orgEnumerateDevices().then(undefined, function(e) {
	        if (e.name === 'NotFoundError') {
	          return [];
	        }
	        throw e;
	      });
	    };
	  }
	  if (browserDetails.version < 49) {
	    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
	        bind(navigator.mediaDevices);
	    navigator.mediaDevices.getUserMedia = function(c) {
	      return origGetUserMedia(c).then(function(stream) {
	        // Work around https://bugzil.la/802326
	        if (c.audio && !stream.getAudioTracks().length ||
	            c.video && !stream.getVideoTracks().length) {
	          stream.getTracks().forEach(function(track) {
	            track.stop();
	          });
	          throw new DOMException('The object can not be found here.',
	                                 'NotFoundError');
	        }
	        return stream;
	      }, function(e) {
	        return Promise.reject(shimError_(e));
	      });
	    };
	  }
	  if (!(browserDetails.version > 55 &&
	      'autoGainControl' in navigator.mediaDevices.getSupportedConstraints())) {
	    var remap = function(obj, a, b) {
	      if (a in obj && !(b in obj)) {
	        obj[b] = obj[a];
	        delete obj[a];
	      }
	    };
	
	    var nativeGetUserMedia = navigator.mediaDevices.getUserMedia.
	        bind(navigator.mediaDevices);
	    navigator.mediaDevices.getUserMedia = function(c) {
	      if (typeof c === 'object' && typeof c.audio === 'object') {
	        c = JSON.parse(JSON.stringify(c));
	        remap(c.audio, 'autoGainControl', 'mozAutoGainControl');
	        remap(c.audio, 'noiseSuppression', 'mozNoiseSuppression');
	      }
	      return nativeGetUserMedia(c);
	    };
	
	    if (MediaStreamTrack && MediaStreamTrack.prototype.getSettings) {
	      var nativeGetSettings = MediaStreamTrack.prototype.getSettings;
	      MediaStreamTrack.prototype.getSettings = function() {
	        var obj = nativeGetSettings.apply(this, arguments);
	        remap(obj, 'mozAutoGainControl', 'autoGainControl');
	        remap(obj, 'mozNoiseSuppression', 'noiseSuppression');
	        return obj;
	      };
	    }
	
	    if (MediaStreamTrack && MediaStreamTrack.prototype.applyConstraints) {
	      var nativeApplyConstraints = MediaStreamTrack.prototype.applyConstraints;
	      MediaStreamTrack.prototype.applyConstraints = function(c) {
	        if (this.kind === 'audio' && typeof c === 'object') {
	          c = JSON.parse(JSON.stringify(c));
	          remap(c, 'autoGainControl', 'mozAutoGainControl');
	          remap(c, 'noiseSuppression', 'mozNoiseSuppression');
	        }
	        return nativeApplyConstraints.apply(this, [c]);
	      };
	    }
	  }
	  navigator.getUserMedia = function(constraints, onSuccess, onError) {
	    if (browserDetails.version < 44) {
	      return getUserMedia_(constraints, onSuccess, onError);
	    }
	    // Replace Firefox 44+'s deprecation warning with unprefixed version.
	    utils.deprecated('navigator.getUserMedia',
	        'navigator.mediaDevices.getUserMedia');
	    navigator.mediaDevices.getUserMedia(constraints).then(onSuccess, onError);
	  };
	};


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	var utils = __webpack_require__(6);
	
	var safariShim = {
	  // TODO: DrAlex, should be here, double check against LayoutTests
	
	  // TODO: once the back-end for the mac port is done, add.
	  // TODO: check for webkitGTK+
	  // shimPeerConnection: function() { },
	
	  shimLocalStreamsAPI: function(window) {
	    if (typeof window !== 'object' || !window.RTCPeerConnection) {
	      return;
	    }
	    if (!('getLocalStreams' in window.RTCPeerConnection.prototype)) {
	      window.RTCPeerConnection.prototype.getLocalStreams = function() {
	        if (!this._localStreams) {
	          this._localStreams = [];
	        }
	        return this._localStreams;
	      };
	    }
	    if (!('getStreamById' in window.RTCPeerConnection.prototype)) {
	      window.RTCPeerConnection.prototype.getStreamById = function(id) {
	        var result = null;
	        if (this._localStreams) {
	          this._localStreams.forEach(function(stream) {
	            if (stream.id === id) {
	              result = stream;
	            }
	          });
	        }
	        if (this._remoteStreams) {
	          this._remoteStreams.forEach(function(stream) {
	            if (stream.id === id) {
	              result = stream;
	            }
	          });
	        }
	        return result;
	      };
	    }
	    if (!('addStream' in window.RTCPeerConnection.prototype)) {
	      var _addTrack = window.RTCPeerConnection.prototype.addTrack;
	      window.RTCPeerConnection.prototype.addStream = function(stream) {
	        if (!this._localStreams) {
	          this._localStreams = [];
	        }
	        if (this._localStreams.indexOf(stream) === -1) {
	          this._localStreams.push(stream);
	        }
	        var self = this;
	        stream.getTracks().forEach(function(track) {
	          _addTrack.call(self, track, stream);
	        });
	      };
	
	      window.RTCPeerConnection.prototype.addTrack = function(track, stream) {
	        if (stream) {
	          if (!this._localStreams) {
	            this._localStreams = [stream];
	          } else if (this._localStreams.indexOf(stream) === -1) {
	            this._localStreams.push(stream);
	          }
	        }
	        _addTrack.call(this, track, stream);
	      };
	    }
	    if (!('removeStream' in window.RTCPeerConnection.prototype)) {
	      window.RTCPeerConnection.prototype.removeStream = function(stream) {
	        if (!this._localStreams) {
	          this._localStreams = [];
	        }
	        var index = this._localStreams.indexOf(stream);
	        if (index === -1) {
	          return;
	        }
	        this._localStreams.splice(index, 1);
	        var self = this;
	        var tracks = stream.getTracks();
	        this.getSenders().forEach(function(sender) {
	          if (tracks.indexOf(sender.track) !== -1) {
	            self.removeTrack(sender);
	          }
	        });
	      };
	    }
	  },
	  shimRemoteStreamsAPI: function(window) {
	    if (typeof window !== 'object' || !window.RTCPeerConnection) {
	      return;
	    }
	    if (!('getRemoteStreams' in window.RTCPeerConnection.prototype)) {
	      window.RTCPeerConnection.prototype.getRemoteStreams = function() {
	        return this._remoteStreams ? this._remoteStreams : [];
	      };
	    }
	    if (!('onaddstream' in window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'onaddstream', {
	        get: function() {
	          return this._onaddstream;
	        },
	        set: function(f) {
	          if (this._onaddstream) {
	            this.removeEventListener('addstream', this._onaddstream);
	            this.removeEventListener('track', this._onaddstreampoly);
	          }
	          this.addEventListener('addstream', this._onaddstream = f);
	          this.addEventListener('track', this._onaddstreampoly = function(e) {
	            var stream = e.streams[0];
	            if (!this._remoteStreams) {
	              this._remoteStreams = [];
	            }
	            if (this._remoteStreams.indexOf(stream) >= 0) {
	              return;
	            }
	            this._remoteStreams.push(stream);
	            var event = new Event('addstream');
	            event.stream = e.streams[0];
	            this.dispatchEvent(event);
	          }.bind(this));
	        }
	      });
	    }
	  },
	  shimCallbacksAPI: function(window) {
	    if (typeof window !== 'object' || !window.RTCPeerConnection) {
	      return;
	    }
	    var prototype = window.RTCPeerConnection.prototype;
	    var createOffer = prototype.createOffer;
	    var createAnswer = prototype.createAnswer;
	    var setLocalDescription = prototype.setLocalDescription;
	    var setRemoteDescription = prototype.setRemoteDescription;
	    var addIceCandidate = prototype.addIceCandidate;
	
	    prototype.createOffer = function(successCallback, failureCallback) {
	      var options = (arguments.length >= 2) ? arguments[2] : arguments[0];
	      var promise = createOffer.apply(this, [options]);
	      if (!failureCallback) {
	        return promise;
	      }
	      promise.then(successCallback, failureCallback);
	      return Promise.resolve();
	    };
	
	    prototype.createAnswer = function(successCallback, failureCallback) {
	      var options = (arguments.length >= 2) ? arguments[2] : arguments[0];
	      var promise = createAnswer.apply(this, [options]);
	      if (!failureCallback) {
	        return promise;
	      }
	      promise.then(successCallback, failureCallback);
	      return Promise.resolve();
	    };
	
	    var withCallback = function(description, successCallback, failureCallback) {
	      var promise = setLocalDescription.apply(this, [description]);
	      if (!failureCallback) {
	        return promise;
	      }
	      promise.then(successCallback, failureCallback);
	      return Promise.resolve();
	    };
	    prototype.setLocalDescription = withCallback;
	
	    withCallback = function(description, successCallback, failureCallback) {
	      var promise = setRemoteDescription.apply(this, [description]);
	      if (!failureCallback) {
	        return promise;
	      }
	      promise.then(successCallback, failureCallback);
	      return Promise.resolve();
	    };
	    prototype.setRemoteDescription = withCallback;
	
	    withCallback = function(candidate, successCallback, failureCallback) {
	      var promise = addIceCandidate.apply(this, [candidate]);
	      if (!failureCallback) {
	        return promise;
	      }
	      promise.then(successCallback, failureCallback);
	      return Promise.resolve();
	    };
	    prototype.addIceCandidate = withCallback;
	  },
	  shimGetUserMedia: function(window) {
	    var navigator = window && window.navigator;
	
	    if (!navigator.getUserMedia) {
	      if (navigator.webkitGetUserMedia) {
	        navigator.getUserMedia = navigator.webkitGetUserMedia.bind(navigator);
	      } else if (navigator.mediaDevices &&
	          navigator.mediaDevices.getUserMedia) {
	        navigator.getUserMedia = function(constraints, cb, errcb) {
	          navigator.mediaDevices.getUserMedia(constraints)
	          .then(cb, errcb);
	        }.bind(navigator);
	      }
	    }
	  },
	  shimRTCIceServerUrls: function(window) {
	    // migrate from non-spec RTCIceServer.url to RTCIceServer.urls
	    var OrigPeerConnection = window.RTCPeerConnection;
	    window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	      if (pcConfig && pcConfig.iceServers) {
	        var newIceServers = [];
	        for (var i = 0; i < pcConfig.iceServers.length; i++) {
	          var server = pcConfig.iceServers[i];
	          if (!server.hasOwnProperty('urls') &&
	              server.hasOwnProperty('url')) {
	            utils.deprecated('RTCIceServer.url', 'RTCIceServer.urls');
	            server = JSON.parse(JSON.stringify(server));
	            server.urls = server.url;
	            delete server.url;
	            newIceServers.push(server);
	          } else {
	            newIceServers.push(pcConfig.iceServers[i]);
	          }
	        }
	        pcConfig.iceServers = newIceServers;
	      }
	      return new OrigPeerConnection(pcConfig, pcConstraints);
	    };
	    window.RTCPeerConnection.prototype = OrigPeerConnection.prototype;
	    // wrap static methods. Currently just generateCertificate.
	    Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	      get: function() {
	        return OrigPeerConnection.generateCertificate;
	      }
	    });
	  }
	};
	
	// Expose public methods.
	module.exports = {
	  shimCallbacksAPI: safariShim.shimCallbacksAPI,
	  shimLocalStreamsAPI: safariShim.shimLocalStreamsAPI,
	  shimRemoteStreamsAPI: safariShim.shimRemoteStreamsAPI,
	  shimGetUserMedia: safariShim.shimGetUserMedia,
	  shimRTCIceServerUrls: safariShim.shimRTCIceServerUrls
	  // TODO
	  // shimPeerConnection: safariShim.shimPeerConnection
	};


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {'use strict'
	
	var MqttClient = __webpack_require__(18)
	var url = __webpack_require__(62)
	var xtend = __webpack_require__(61)
	var protocols = {}
	
	if (process.title !== 'browser') {
	  protocols.mqtt = __webpack_require__(69)
	  protocols.tcp = __webpack_require__(69)
	  protocols.ssl = __webpack_require__(71)
	  protocols.tls = __webpack_require__(71)
	  protocols.mqtts = __webpack_require__(71)
	} else {
	  protocols.wx = __webpack_require__(73)
	  protocols.wxs = __webpack_require__(73)
	}
	
	protocols.ws = __webpack_require__(78)
	protocols.wss = __webpack_require__(78)
	
	/**
	 * Parse the auth attribute and merge username and password in the options object.
	 *
	 * @param {Object} [opts] option object
	 */
	function parseAuthOptions (opts) {
	  var matches
	  if (opts.auth) {
	    matches = opts.auth.match(/^(.+):(.+)$/)
	    if (matches) {
	      opts.username = matches[1]
	      opts.password = matches[2]
	    } else {
	      opts.username = opts.auth
	    }
	  }
	}
	
	/**
	 * connect - connect to an MQTT broker.
	 *
	 * @param {String} [brokerUrl] - url of the broker, optional
	 * @param {Object} opts - see MqttClient#constructor
	 */
	function connect (brokerUrl, opts) {
	  if ((typeof brokerUrl === 'object') && !opts) {
	    opts = brokerUrl
	    brokerUrl = null
	  }
	
	  opts = opts || {}
	
	  if (brokerUrl) {
	    var parsed = url.parse(brokerUrl, true)
	    if (parsed.port != null) {
	      parsed.port = Number(parsed.port)
	    }
	
	    opts = xtend(parsed, opts)
	
	    if (opts.protocol === null) {
	      throw new Error('Missing protocol')
	    }
	    opts.protocol = opts.protocol.replace(/:$/, '')
	  }
	
	  // merge in the auth options if supplied
	  parseAuthOptions(opts)
	
	  // support clientId passed in the query string of the url
	  if (opts.query && typeof opts.query.clientId === 'string') {
	    opts.clientId = opts.query.clientId
	  }
	
	  if (opts.cert && opts.key) {
	    if (opts.protocol) {
	      if (['mqtts', 'wss', 'wxs'].indexOf(opts.protocol) === -1) {
	        switch (opts.protocol) {
	          case 'mqtt':
	            opts.protocol = 'mqtts'
	            break
	          case 'ws':
	            opts.protocol = 'wss'
	            break
	          case 'wx':
	            opts.protocol = 'wxs'
	            break
	          default:
	            throw new Error('Unknown protocol for secure connection: "' + opts.protocol + '"!')
	        }
	      }
	    } else {
	      // don't know what protocol he want to use, mqtts or wss
	      throw new Error('Missing secure protocol key')
	    }
	  }
	
	  if (!protocols[opts.protocol]) {
	    var isSecure = ['mqtts', 'wss'].indexOf(opts.protocol) !== -1
	    opts.protocol = [
	      'mqtt',
	      'mqtts',
	      'ws',
	      'wss',
	      'wx',
	      'wxs'
	    ].filter(function (key, index) {
	      if (isSecure && index % 2 === 0) {
	        // Skip insecure protocols when requesting a secure one.
	        return false
	      }
	      return (typeof protocols[key] === 'function')
	    })[0]
	  }
	
	  if (opts.clean === false && !opts.clientId) {
	    throw new Error('Missing clientId for unclean clients')
	  }
	
	  function wrapper (client) {
	    if (opts.servers) {
	      if (!client._reconnectCount || client._reconnectCount === opts.servers.length) {
	        client._reconnectCount = 0
	      }
	
	      opts.host = opts.servers[client._reconnectCount].host
	      opts.port = opts.servers[client._reconnectCount].port
	      opts.hostname = opts.host
	
	      client._reconnectCount++
	    }
	
	    return protocols[opts.protocol](client, opts)
	  }
	
	  return new MqttClient(wrapper, opts)
	}
	
	module.exports = connect
	module.exports.connect = connect
	module.exports.MqttClient = MqttClient
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

/***/ }),
/* 17 */
/***/ (function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};
	
	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.
	
	var cachedSetTimeout;
	var cachedClearTimeout;
	
	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	(function () {
	    try {
	        if (typeof setTimeout === 'function') {
	            cachedSetTimeout = setTimeout;
	        } else {
	            cachedSetTimeout = defaultSetTimout;
	        }
	    } catch (e) {
	        cachedSetTimeout = defaultSetTimout;
	    }
	    try {
	        if (typeof clearTimeout === 'function') {
	            cachedClearTimeout = clearTimeout;
	        } else {
	            cachedClearTimeout = defaultClearTimeout;
	        }
	    } catch (e) {
	        cachedClearTimeout = defaultClearTimeout;
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }
	
	
	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }
	
	
	
	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;
	
	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}
	
	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;
	
	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	
	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};
	
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};
	
	function noop() {}
	
	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	process.prependListener = noop;
	process.prependOnceListener = noop;
	
	process.listeners = function (name) { return [] }
	
	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};
	
	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {'use strict'
	
	/**
	 * Module dependencies
	 */
	var events = __webpack_require__(19)
	var Store = __webpack_require__(20)
	var eos = __webpack_require__(44)
	var mqttPacket = __webpack_require__(47)
	var Writable = __webpack_require__(21).Writable
	var inherits = __webpack_require__(31)
	var reInterval = __webpack_require__(59)
	var validations = __webpack_require__(60)
	var xtend = __webpack_require__(61)
	var setImmediate = global.setImmediate || function (callback) {
	  // works in node v0.8
	  process.nextTick(callback)
	}
	var defaultConnectOptions = {
	  keepalive: 60,
	  reschedulePings: true,
	  protocolId: 'MQTT',
	  protocolVersion: 4,
	  reconnectPeriod: 1000,
	  connectTimeout: 30 * 1000,
	  clean: true
	}
	
	function defaultId () {
	  return 'mqttjs_' + Math.random().toString(16).substr(2, 8)
	}
	
	function sendPacket (client, packet, cb) {
	  client.emit('packetsend', packet)
	
	  var result = mqttPacket.writeToStream(packet, client.stream)
	
	  if (!result && cb) {
	    client.stream.once('drain', cb)
	  } else if (cb) {
	    cb()
	  }
	}
	
	function storeAndSend (client, packet, cb) {
	  client.outgoingStore.put(packet, function storedPacket (err) {
	    if (err) {
	      return cb && cb(err)
	    }
	    sendPacket(client, packet, cb)
	  })
	}
	
	function nop () {}
	
	/**
	 * MqttClient constructor
	 *
	 * @param {Stream} stream - stream
	 * @param {Object} [options] - connection options
	 * (see Connection#connect)
	 */
	function MqttClient (streamBuilder, options) {
	  var k
	  var that = this
	
	  if (!(this instanceof MqttClient)) {
	    return new MqttClient(streamBuilder, options)
	  }
	
	  this.options = options || {}
	
	  // Defaults
	  for (k in defaultConnectOptions) {
	    if (typeof this.options[k] === 'undefined') {
	      this.options[k] = defaultConnectOptions[k]
	    } else {
	      this.options[k] = options[k]
	    }
	  }
	
	  this.options.clientId = this.options.clientId || defaultId()
	
	  this.streamBuilder = streamBuilder
	
	  // Inflight message storages
	  this.outgoingStore = this.options.outgoingStore || new Store()
	  this.incomingStore = this.options.incomingStore || new Store()
	
	  // Should QoS zero messages be queued when the connection is broken?
	  this.queueQoSZero = this.options.queueQoSZero === undefined ? true : this.options.queueQoSZero
	
	  // map of subscribed topics to support reconnection
	  this._resubscribeTopics = {}
	
	  // Ping timer, setup in _setupPingTimer
	  this.pingTimer = null
	  // Is the client connected?
	  this.connected = false
	  // Are we disconnecting?
	  this.disconnecting = false
	  // Packet queue
	  this.queue = []
	  // connack timer
	  this.connackTimer = null
	  // Reconnect timer
	  this.reconnectTimer = null
	  // MessageIDs starting with 1
	  this.nextId = Math.floor(Math.random() * 65535)
	
	  // Inflight callbacks
	  this.outgoing = {}
	
	  // Mark connected on connect
	  this.on('connect', function () {
	    if (this.disconnected) {
	      return
	    }
	
	    this.connected = true
	    var outStore = null
	    outStore = this.outgoingStore.createStream()
	
	    // Control of stored messages
	    outStore.once('readable', function () {
	      function storeDeliver () {
	        var packet = outStore.read(1)
	        var cb
	
	        if (!packet) {
	          return
	        }
	
	        // Avoid unnecesary stream read operations when disconnected
	        if (!that.disconnecting && !that.reconnectTimer && that.options.reconnectPeriod > 0) {
	          outStore.read(0)
	          cb = that.outgoing[packet.messageId]
	          that.outgoing[packet.messageId] = function (err, status) {
	            // Ensure that the original callback passed in to publish gets invoked
	            if (cb) {
	              cb(err, status)
	            }
	
	            storeDeliver()
	          }
	          that._sendPacket(packet)
	        } else if (outStore.destroy) {
	          outStore.destroy()
	        }
	      }
	      storeDeliver()
	    })
	    .on('error', this.emit.bind(this, 'error'))
	  })
	
	  // Mark disconnected on stream close
	  this.on('close', function () {
	    this.connected = false
	    clearTimeout(this.connackTimer)
	  })
	
	  // Setup ping timer
	  this.on('connect', this._setupPingTimer)
	
	  // Send queued packets
	  this.on('connect', function () {
	    var queue = this.queue
	
	    function deliver () {
	      var entry = queue.shift()
	      var packet = null
	
	      if (!entry) {
	        return
	      }
	
	      packet = entry.packet
	
	      that._sendPacket(
	        packet,
	        function (err) {
	          if (entry.cb) {
	            entry.cb(err)
	          }
	          deliver()
	        }
	      )
	    }
	
	    deliver()
	  })
	
	  var firstConnection = true
	  // resubscribe
	  this.on('connect', function () {
	    if (!firstConnection &&
	        this.options.clean &&
	        Object.keys(this._resubscribeTopics).length > 0) {
	      this._resubscribeTopics.resubscribe = true
	      this.subscribe(this._resubscribeTopics)
	    }
	
	    firstConnection = false
	  })
	
	  // Clear ping timer
	  this.on('close', function () {
	    if (that.pingTimer !== null) {
	      that.pingTimer.clear()
	      that.pingTimer = null
	    }
	  })
	
	  // Setup reconnect timer on disconnect
	  this.on('close', this._setupReconnect)
	
	  events.EventEmitter.call(this)
	
	  this._setupStream()
	}
	inherits(MqttClient, events.EventEmitter)
	
	/**
	 * setup the event handlers in the inner stream.
	 *
	 * @api private
	 */
	MqttClient.prototype._setupStream = function () {
	  var connectPacket
	  var that = this
	  var writable = new Writable()
	  var parser = mqttPacket.parser(this.options)
	  var completeParse = null
	  var packets = []
	
	  this._clearReconnect()
	
	  this.stream = this.streamBuilder(this)
	
	  parser.on('packet', function (packet) {
	    packets.push(packet)
	  })
	
	  function process () {
	    var packet = packets.shift()
	    var done = completeParse
	
	    if (packet) {
	      that._handlePacket(packet, process)
	    } else {
	      completeParse = null
	      done()
	    }
	  }
	
	  writable._write = function (buf, enc, done) {
	    completeParse = done
	    parser.parse(buf)
	    process()
	  }
	
	  this.stream.pipe(writable)
	
	  // Suppress connection errors
	  this.stream.on('error', nop)
	
	  // Echo stream close
	  eos(this.stream, this.emit.bind(this, 'close'))
	
	  // Send a connect packet
	  connectPacket = Object.create(this.options)
	  connectPacket.cmd = 'connect'
	  // avoid message queue
	  sendPacket(this, connectPacket)
	
	  // Echo connection errors
	  parser.on('error', this.emit.bind(this, 'error'))
	
	  // many drain listeners are needed for qos 1 callbacks if the connection is intermittent
	  this.stream.setMaxListeners(1000)
	
	  clearTimeout(this.connackTimer)
	  this.connackTimer = setTimeout(function () {
	    that._cleanUp(true)
	  }, this.options.connectTimeout)
	}
	
	MqttClient.prototype._handlePacket = function (packet, done) {
	  this.emit('packetreceive', packet)
	
	  switch (packet.cmd) {
	    case 'publish':
	      this._handlePublish(packet, done)
	      break
	    case 'puback':
	    case 'pubrec':
	    case 'pubcomp':
	    case 'suback':
	    case 'unsuback':
	      this._handleAck(packet)
	      done()
	      break
	    case 'pubrel':
	      this._handlePubrel(packet, done)
	      break
	    case 'connack':
	      this._handleConnack(packet)
	      done()
	      break
	    case 'pingresp':
	      this._handlePingresp(packet)
	      done()
	      break
	    default:
	      // do nothing
	      // maybe we should do an error handling
	      // or just log it
	      break
	  }
	}
	
	MqttClient.prototype._checkDisconnecting = function (callback) {
	  if (this.disconnecting) {
	    if (callback) {
	      callback(new Error('client disconnecting'))
	    } else {
	      this.emit('error', new Error('client disconnecting'))
	    }
	  }
	  return this.disconnecting
	}
	
	/**
	 * publish - publish <message> to <topic>
	 *
	 * @param {String} topic - topic to publish to
	 * @param {String, Buffer} message - message to publish
	 * @param {Object} [opts] - publish options, includes:
	 *    {Number} qos - qos level to publish on
	 *    {Boolean} retain - whether or not to retain the message
	 *    {Boolean} dup - whether or not mark a message as duplicate
	 * @param {Function} [callback] - function(err){}
	 *    called when publish succeeds or fails
	 * @returns {MqttClient} this - for chaining
	 * @api public
	 *
	 * @example client.publish('topic', 'message');
	 * @example
	 *     client.publish('topic', 'message', {qos: 1, retain: true, dup: true});
	 * @example client.publish('topic', 'message', console.log);
	 */
	MqttClient.prototype.publish = function (topic, message, opts, callback) {
	  var packet
	
	  // .publish(topic, payload, cb);
	  if (typeof opts === 'function') {
	    callback = opts
	    opts = null
	  }
	
	  // default opts
	  var defaultOpts = {qos: 0, retain: false, dup: false}
	  opts = xtend(defaultOpts, opts)
	
	  if (this._checkDisconnecting(callback)) {
	    return this
	  }
	
	  packet = {
	    cmd: 'publish',
	    topic: topic,
	    payload: message,
	    qos: opts.qos,
	    retain: opts.retain,
	    messageId: this._nextId(),
	    dup: opts.dup
	  }
	
	  switch (opts.qos) {
	    case 1:
	    case 2:
	
	      // Add to callbacks
	      this.outgoing[packet.messageId] = callback || nop
	      this._sendPacket(packet)
	      break
	    default:
	      this._sendPacket(packet, callback)
	      break
	  }
	
	  return this
	}
	
	/**
	 * subscribe - subscribe to <topic>
	 *
	 * @param {String, Array, Object} topic - topic(s) to subscribe to, supports objects in the form {'topic': qos}
	 * @param {Object} [opts] - optional subscription options, includes:
	 *    {Number} qos - subscribe qos level
	 * @param {Function} [callback] - function(err, granted){} where:
	 *    {Error} err - subscription error (none at the moment!)
	 *    {Array} granted - array of {topic: 't', qos: 0}
	 * @returns {MqttClient} this - for chaining
	 * @api public
	 * @example client.subscribe('topic');
	 * @example client.subscribe('topic', {qos: 1});
	 * @example client.subscribe({'topic': 0, 'topic2': 1}, console.log);
	 * @example client.subscribe('topic', console.log);
	 */
	MqttClient.prototype.subscribe = function () {
	  var packet
	  var args = Array.prototype.slice.call(arguments)
	  var subs = []
	  var obj = args.shift()
	  var resubscribe = obj.resubscribe
	  var callback = args.pop() || nop
	  var opts = args.pop()
	  var invalidTopic
	  var that = this
	
	  delete obj.resubscribe
	
	  if (typeof obj === 'string') {
	    obj = [obj]
	  }
	
	  if (typeof callback !== 'function') {
	    opts = callback
	    callback = nop
	  }
	
	  invalidTopic = validations.validateTopics(obj)
	  if (invalidTopic !== null) {
	    setImmediate(callback, new Error('Invalid topic ' + invalidTopic))
	    return this
	  }
	
	  if (this._checkDisconnecting(callback)) {
	    return this
	  }
	
	  var defaultOpts = { qos: 0 }
	  opts = xtend(defaultOpts, opts)
	
	  if (Array.isArray(obj)) {
	    obj.forEach(function (topic) {
	      if (that._resubscribeTopics[topic] < opts.qos ||
	          !that._resubscribeTopics.hasOwnProperty(topic) ||
	          resubscribe
	        ) {
	        subs.push({
	          topic: topic,
	          qos: opts.qos
	        })
	      }
	    })
	  } else {
	    Object
	      .keys(obj)
	      .forEach(function (k) {
	        if (that._resubscribeTopics[k] < obj[k] ||
	            !that._resubscribeTopics.hasOwnProperty(k) ||
	            resubscribe
	          ) {
	          subs.push({
	            topic: k,
	            qos: obj[k]
	          })
	        }
	      })
	  }
	
	  packet = {
	    cmd: 'subscribe',
	    subscriptions: subs,
	    qos: 1,
	    retain: false,
	    dup: false,
	    messageId: this._nextId()
	  }
	
	  if (!subs.length) {
	    callback(null, [])
	    return
	  }
	
	  // subscriptions to resubscribe to in case of disconnect
	  subs.forEach(function (sub) {
	    that._resubscribeTopics[sub.topic] = sub.qos
	  })
	
	  this.outgoing[packet.messageId] = function (err, packet) {
	    if (!err) {
	      var granted = packet.granted
	      for (var i = 0; i < granted.length; i += 1) {
	        subs[i].qos = granted[i]
	      }
	    }
	
	    callback(err, subs)
	  }
	
	  this._sendPacket(packet)
	
	  return this
	}
	
	/**
	 * unsubscribe - unsubscribe from topic(s)
	 *
	 * @param {String, Array} topic - topics to unsubscribe from
	 * @param {Function} [callback] - callback fired on unsuback
	 * @returns {MqttClient} this - for chaining
	 * @api public
	 * @example client.unsubscribe('topic');
	 * @example client.unsubscribe('topic', console.log);
	 */
	MqttClient.prototype.unsubscribe = function (topic, callback) {
	  var packet = {
	    cmd: 'unsubscribe',
	    qos: 1,
	    messageId: this._nextId()
	  }
	  var that = this
	
	  callback = callback || nop
	
	  if (this._checkDisconnecting(callback)) {
	    return this
	  }
	
	  if (typeof topic === 'string') {
	    packet.unsubscriptions = [topic]
	  } else if (typeof topic === 'object' && topic.length) {
	    packet.unsubscriptions = topic
	  }
	
	  packet.unsubscriptions.forEach(function (topic) {
	    delete that._resubscribeTopics[topic]
	  })
	
	  this.outgoing[packet.messageId] = callback
	
	  this._sendPacket(packet)
	
	  return this
	}
	
	/**
	 * end - close connection
	 *
	 * @returns {MqttClient} this - for chaining
	 * @param {Boolean} force - do not wait for all in-flight messages to be acked
	 * @param {Function} cb - called when the client has been closed
	 *
	 * @api public
	 */
	MqttClient.prototype.end = function (force, cb) {
	  var that = this
	
	  if (typeof force === 'function') {
	    cb = force
	    force = false
	  }
	
	  function closeStores () {
	    that.disconnected = true
	    that.incomingStore.close(function () {
	      that.outgoingStore.close(cb)
	    })
	  }
	
	  function finish () {
	    // defer closesStores of an I/O cycle,
	    // just to make sure things are
	    // ok for websockets
	    that._cleanUp(force, setImmediate.bind(null, closeStores))
	  }
	
	  if (this.disconnecting) {
	    return this
	  }
	
	  this._clearReconnect()
	
	  this.disconnecting = true
	
	  if (!force && Object.keys(this.outgoing).length > 0) {
	    // wait 10ms, just to be sure we received all of it
	    this.once('outgoingEmpty', setTimeout.bind(null, finish, 10))
	  } else {
	    finish()
	  }
	
	  return this
	}
	
	/**
	 * removeOutgoingMessage - remove a message in outgoing store
	 * the outgoing callback will be called withe Error('Message removed') if the message is removed
	 *
	 * @param {Number} mid - messageId to remove message
	 * @returns {MqttClient} this - for chaining
	 * @api public
	 *
	 * @example client.removeOutgoingMessage(client.getLastMessageId());
	 */
	MqttClient.prototype.removeOutgoingMessage = function (mid) {
	  var cb = this.outgoing[mid]
	  delete this.outgoing[mid]
	  this.outgoingStore.del({messageId: mid}, function () {
	    cb(new Error('Message removed'))
	  })
	  return this
	}
	
	/**
	 * _reconnect - implement reconnection
	 * @api privateish
	 */
	MqttClient.prototype._reconnect = function () {
	  this.emit('reconnect')
	  this._setupStream()
	}
	
	/**
	 * _setupReconnect - setup reconnect timer
	 */
	MqttClient.prototype._setupReconnect = function () {
	  var that = this
	
	  if (!that.disconnecting && !that.reconnectTimer && (that.options.reconnectPeriod > 0)) {
	    if (!this.reconnecting) {
	      this.emit('offline')
	      this.reconnecting = true
	    }
	    that.reconnectTimer = setInterval(function () {
	      that._reconnect()
	    }, that.options.reconnectPeriod)
	  }
	}
	
	/**
	 * _clearReconnect - clear the reconnect timer
	 */
	MqttClient.prototype._clearReconnect = function () {
	  if (this.reconnectTimer) {
	    clearInterval(this.reconnectTimer)
	    this.reconnectTimer = null
	  }
	}
	
	/**
	 * _cleanUp - clean up on connection end
	 * @api private
	 */
	MqttClient.prototype._cleanUp = function (forced, done) {
	  if (done) {
	    this.stream.on('close', done)
	  }
	
	  if (forced) {
	    this.stream.destroy()
	  } else {
	    this._sendPacket(
	      { cmd: 'disconnect' },
	      setImmediate.bind(
	        null,
	        this.stream.end.bind(this.stream)
	      )
	    )
	  }
	
	  if (!this.disconnecting) {
	    this._clearReconnect()
	    this._setupReconnect()
	  }
	
	  if (this.pingTimer !== null) {
	    this.pingTimer.clear()
	    this.pingTimer = null
	  }
	}
	
	/**
	 * _sendPacket - send or queue a packet
	 * @param {String} type - packet type (see `protocol`)
	 * @param {Object} packet - packet options
	 * @param {Function} cb - callback when the packet is sent
	 * @api private
	 */
	MqttClient.prototype._sendPacket = function (packet, cb) {
	  if (!this.connected) {
	    if (((packet.qos || 0) === 0 && this.queueQoSZero) || packet.cmd !== 'publish') {
	      this.queue.push({ packet: packet, cb: cb })
	    } else if (packet.qos > 0) {
	      this.outgoingStore.put(packet, function (err) {
	        if (err) {
	          return cb && cb(err)
	        }
	      })
	    } else if (cb) {
	      cb(new Error('No connection to broker'))
	    }
	
	    return
	  }
	
	  // When sending a packet, reschedule the ping timer
	  this._shiftPingInterval()
	
	  if (packet.cmd !== 'publish') {
	    sendPacket(this, packet, cb)
	    return
	  }
	
	  switch (packet.qos) {
	    case 2:
	    case 1:
	      storeAndSend(this, packet, cb)
	      break
	    /**
	     * no need of case here since it will be caught by default
	     * and jshint comply that before default it must be a break
	     * anyway it will result in -1 evaluation
	     */
	    case 0:
	      /* falls through */
	    default:
	      sendPacket(this, packet, cb)
	      break
	  }
	}
	
	/**
	 * _setupPingTimer - setup the ping timer
	 *
	 * @api private
	 */
	MqttClient.prototype._setupPingTimer = function () {
	  var that = this
	
	  if (!this.pingTimer && this.options.keepalive) {
	    this.pingResp = true
	    this.pingTimer = reInterval(function () {
	      that._checkPing()
	    }, this.options.keepalive * 1000)
	  }
	}
	
	/**
	 * _shiftPingInterval - reschedule the ping interval
	 *
	 * @api private
	 */
	MqttClient.prototype._shiftPingInterval = function () {
	  if (this.pingTimer && this.options.keepalive && this.options.reschedulePings) {
	    this.pingTimer.reschedule(this.options.keepalive * 1000)
	  }
	}
	/**
	 * _checkPing - check if a pingresp has come back, and ping the server again
	 *
	 * @api private
	 */
	MqttClient.prototype._checkPing = function () {
	  if (this.pingResp) {
	    this.pingResp = false
	    this._sendPacket({ cmd: 'pingreq' })
	  } else {
	    // do a forced cleanup since socket will be in bad shape
	    this._cleanUp(true)
	  }
	}
	
	/**
	 * _handlePingresp - handle a pingresp
	 *
	 * @api private
	 */
	MqttClient.prototype._handlePingresp = function () {
	  this.pingResp = true
	}
	
	/**
	 * _handleConnack
	 *
	 * @param {Object} packet
	 * @api private
	 */
	
	MqttClient.prototype._handleConnack = function (packet) {
	  var rc = packet.returnCode
	  var errors = [
	    '',
	    'Unacceptable protocol version',
	    'Identifier rejected',
	    'Server unavailable',
	    'Bad username or password',
	    'Not authorized'
	  ]
	
	  clearTimeout(this.connackTimer)
	
	  if (rc === 0) {
	    this.reconnecting = false
	    this.emit('connect', packet)
	  } else if (rc > 0) {
	    var err = new Error('Connection refused: ' + errors[rc])
	    err.code = rc
	    this.emit('error', err)
	  }
	}
	
	/**
	 * _handlePublish
	 *
	 * @param {Object} packet
	 * @api private
	 */
	/*
	those late 2 case should be rewrite to comply with coding style:
	
	case 1:
	case 0:
	  // do not wait sending a puback
	  // no callback passed
	  if (1 === qos) {
	    this._sendPacket({
	      cmd: 'puback',
	      messageId: mid
	    });
	  }
	  // emit the message event for both qos 1 and 0
	  this.emit('message', topic, message, packet);
	  this.handleMessage(packet, done);
	  break;
	default:
	  // do nothing but every switch mus have a default
	  // log or throw an error about unknown qos
	  break;
	
	for now i just suppressed the warnings
	*/
	MqttClient.prototype._handlePublish = function (packet, done) {
	  var topic = packet.topic.toString()
	  var message = packet.payload
	  var qos = packet.qos
	  var mid = packet.messageId
	  var that = this
	
	  switch (qos) {
	    case 2:
	      this.incomingStore.put(packet, function () {
	        that._sendPacket({cmd: 'pubrec', messageId: mid}, done)
	      })
	      break
	    case 1:
	      // do not wait sending a puback
	      // no callback passed
	      this._sendPacket({
	        cmd: 'puback',
	        messageId: mid
	      })
	      /* falls through */
	    case 0:
	      // emit the message event for both qos 1 and 0
	      this.emit('message', topic, message, packet)
	      this.handleMessage(packet, done)
	      break
	    default:
	      // do nothing
	      // log or throw an error about unknown qos
	      break
	  }
	}
	
	/**
	 * Handle messages with backpressure support, one at a time.
	 * Override at will.
	 *
	 * @param Packet packet the packet
	 * @param Function callback call when finished
	 * @api public
	 */
	MqttClient.prototype.handleMessage = function (packet, callback) {
	  callback()
	}
	
	/**
	 * _handleAck
	 *
	 * @param {Object} packet
	 * @api private
	 */
	
	MqttClient.prototype._handleAck = function (packet) {
	  /* eslint no-fallthrough: "off" */
	  var mid = packet.messageId
	  var type = packet.cmd
	  var response = null
	  var cb = this.outgoing[mid]
	  var that = this
	
	  if (!cb) {
	    // Server sent an ack in error, ignore it.
	    return
	  }
	
	  // Process
	  switch (type) {
	    case 'pubcomp':
	      // same thing as puback for QoS 2
	    case 'puback':
	      // Callback - we're done
	      delete this.outgoing[mid]
	      this.outgoingStore.del(packet, cb)
	      break
	    case 'pubrec':
	      response = {
	        cmd: 'pubrel',
	        qos: 2,
	        messageId: mid
	      }
	
	      this._sendPacket(response)
	      break
	    case 'suback':
	      delete this.outgoing[mid]
	      cb(null, packet)
	      break
	    case 'unsuback':
	      delete this.outgoing[mid]
	      cb(null)
	      break
	    default:
	      that.emit('error', new Error('unrecognized packet type'))
	  }
	
	  if (this.disconnecting &&
	      Object.keys(this.outgoing).length === 0) {
	    this.emit('outgoingEmpty')
	  }
	}
	
	/**
	 * _handlePubrel
	 *
	 * @param {Object} packet
	 * @api private
	 */
	
	MqttClient.prototype._handlePubrel = function (packet, callback) {
	  var mid = packet.messageId
	  var that = this
	
	  that.incomingStore.get(packet, function (err, pub) {
	    if (!err && pub.cmd !== 'pubrel') {
	      that.emit('message', pub.topic, pub.payload, pub)
	      that.incomingStore.put(packet)
	    }
	
	    that._sendPacket({cmd: 'pubcomp', messageId: mid}, callback)
	  })
	}
	
	/**
	 * _nextId
	 */
	MqttClient.prototype._nextId = function () {
	  var id = this.nextId++
	  // Ensure 16 bit unsigned int:
	  if (id === 65535) {
	    this.nextId = 1
	  }
	  return id
	}
	
	/**
	 * getLastMessageId
	 */
	MqttClient.prototype.getLastMessageId = function () {
	  return (this.nextId === 1) ? 65535 : (this.nextId - 1)
	}
	
	module.exports = MqttClient
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(17)))

/***/ }),
/* 19 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	function EventEmitter() {
	  this._events = this._events || {};
	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;
	
	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;
	
	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;
	
	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;
	
	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function(n) {
	  if (!isNumber(n) || n < 0 || isNaN(n))
	    throw TypeError('n must be a positive number');
	  this._maxListeners = n;
	  return this;
	};
	
	EventEmitter.prototype.emit = function(type) {
	  var er, handler, len, args, i, listeners;
	
	  if (!this._events)
	    this._events = {};
	
	  // If there is no 'error' event listener then throw.
	  if (type === 'error') {
	    if (!this._events.error ||
	        (isObject(this._events.error) && !this._events.error.length)) {
	      er = arguments[1];
	      if (er instanceof Error) {
	        throw er; // Unhandled 'error' event
	      } else {
	        // At least give some kind of context to the user
	        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	        err.context = er;
	        throw err;
	      }
	    }
	  }
	
	  handler = this._events[type];
	
	  if (isUndefined(handler))
	    return false;
	
	  if (isFunction(handler)) {
	    switch (arguments.length) {
	      // fast cases
	      case 1:
	        handler.call(this);
	        break;
	      case 2:
	        handler.call(this, arguments[1]);
	        break;
	      case 3:
	        handler.call(this, arguments[1], arguments[2]);
	        break;
	      // slower
	      default:
	        args = Array.prototype.slice.call(arguments, 1);
	        handler.apply(this, args);
	    }
	  } else if (isObject(handler)) {
	    args = Array.prototype.slice.call(arguments, 1);
	    listeners = handler.slice();
	    len = listeners.length;
	    for (i = 0; i < len; i++)
	      listeners[i].apply(this, args);
	  }
	
	  return true;
	};
	
	EventEmitter.prototype.addListener = function(type, listener) {
	  var m;
	
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');
	
	  if (!this._events)
	    this._events = {};
	
	  // To avoid recursion in the case that type === "newListener"! Before
	  // adding it to the listeners, first emit "newListener".
	  if (this._events.newListener)
	    this.emit('newListener', type,
	              isFunction(listener.listener) ?
	              listener.listener : listener);
	
	  if (!this._events[type])
	    // Optimize the case of one listener. Don't need the extra array object.
	    this._events[type] = listener;
	  else if (isObject(this._events[type]))
	    // If we've already got an array, just append.
	    this._events[type].push(listener);
	  else
	    // Adding the second element, need to change to array.
	    this._events[type] = [this._events[type], listener];
	
	  // Check for listener leak
	  if (isObject(this._events[type]) && !this._events[type].warned) {
	    if (!isUndefined(this._maxListeners)) {
	      m = this._maxListeners;
	    } else {
	      m = EventEmitter.defaultMaxListeners;
	    }
	
	    if (m && m > 0 && this._events[type].length > m) {
	      this._events[type].warned = true;
	      console.error('(node) warning: possible EventEmitter memory ' +
	                    'leak detected. %d listeners added. ' +
	                    'Use emitter.setMaxListeners() to increase limit.',
	                    this._events[type].length);
	      if (typeof console.trace === 'function') {
	        // not supported in IE 10
	        console.trace();
	      }
	    }
	  }
	
	  return this;
	};
	
	EventEmitter.prototype.on = EventEmitter.prototype.addListener;
	
	EventEmitter.prototype.once = function(type, listener) {
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');
	
	  var fired = false;
	
	  function g() {
	    this.removeListener(type, g);
	
	    if (!fired) {
	      fired = true;
	      listener.apply(this, arguments);
	    }
	  }
	
	  g.listener = listener;
	  this.on(type, g);
	
	  return this;
	};
	
	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener = function(type, listener) {
	  var list, position, length, i;
	
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');
	
	  if (!this._events || !this._events[type])
	    return this;
	
	  list = this._events[type];
	  length = list.length;
	  position = -1;
	
	  if (list === listener ||
	      (isFunction(list.listener) && list.listener === listener)) {
	    delete this._events[type];
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	
	  } else if (isObject(list)) {
	    for (i = length; i-- > 0;) {
	      if (list[i] === listener ||
	          (list[i].listener && list[i].listener === listener)) {
	        position = i;
	        break;
	      }
	    }
	
	    if (position < 0)
	      return this;
	
	    if (list.length === 1) {
	      list.length = 0;
	      delete this._events[type];
	    } else {
	      list.splice(position, 1);
	    }
	
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	  }
	
	  return this;
	};
	
	EventEmitter.prototype.removeAllListeners = function(type) {
	  var key, listeners;
	
	  if (!this._events)
	    return this;
	
	  // not listening for removeListener, no need to emit
	  if (!this._events.removeListener) {
	    if (arguments.length === 0)
	      this._events = {};
	    else if (this._events[type])
	      delete this._events[type];
	    return this;
	  }
	
	  // emit removeListener for all listeners on all events
	  if (arguments.length === 0) {
	    for (key in this._events) {
	      if (key === 'removeListener') continue;
	      this.removeAllListeners(key);
	    }
	    this.removeAllListeners('removeListener');
	    this._events = {};
	    return this;
	  }
	
	  listeners = this._events[type];
	
	  if (isFunction(listeners)) {
	    this.removeListener(type, listeners);
	  } else if (listeners) {
	    // LIFO order
	    while (listeners.length)
	      this.removeListener(type, listeners[listeners.length - 1]);
	  }
	  delete this._events[type];
	
	  return this;
	};
	
	EventEmitter.prototype.listeners = function(type) {
	  var ret;
	  if (!this._events || !this._events[type])
	    ret = [];
	  else if (isFunction(this._events[type]))
	    ret = [this._events[type]];
	  else
	    ret = this._events[type].slice();
	  return ret;
	};
	
	EventEmitter.prototype.listenerCount = function(type) {
	  if (this._events) {
	    var evlistener = this._events[type];
	
	    if (isFunction(evlistener))
	      return 1;
	    else if (evlistener)
	      return evlistener.length;
	  }
	  return 0;
	};
	
	EventEmitter.listenerCount = function(emitter, type) {
	  return emitter.listenerCount(type);
	};
	
	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	
	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	
	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	
	function isUndefined(arg) {
	  return arg === void 0;
	}


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {'use strict'
	
	var Readable = __webpack_require__(21).Readable
	var streamsOpts = { objectMode: true }
	
	/**
	 * In-memory implementation of the message store
	 * This can actually be saved into files.
	 *
	 */
	function Store () {
	  if (!(this instanceof Store)) {
	    return new Store()
	  }
	
	  this._inflights = {}
	}
	
	/**
	 * Adds a packet to the store, a packet is
	 * anything that has a messageId property.
	 *
	 */
	Store.prototype.put = function (packet, cb) {
	  this._inflights[packet.messageId] = packet
	
	  if (cb) {
	    cb()
	  }
	
	  return this
	}
	
	/**
	 * Creates a stream with all the packets in the store
	 *
	 */
	Store.prototype.createStream = function () {
	  var stream = new Readable(streamsOpts)
	  var inflights = this._inflights
	  var ids = Object.keys(this._inflights)
	  var destroyed = false
	  var i = 0
	
	  stream._read = function () {
	    if (!destroyed && i < ids.length) {
	      this.push(inflights[ids[i++]])
	    } else {
	      this.push(null)
	    }
	  }
	
	  stream.destroy = function () {
	    if (destroyed) {
	      return
	    }
	
	    var self = this
	
	    destroyed = true
	
	    process.nextTick(function () {
	      self.emit('close')
	    })
	  }
	
	  return stream
	}
	
	/**
	 * deletes a packet from the store.
	 */
	Store.prototype.del = function (packet, cb) {
	  packet = this._inflights[packet.messageId]
	  if (packet) {
	    delete this._inflights[packet.messageId]
	    cb(null, packet)
	  } else if (cb) {
	    cb(new Error('missing packet'))
	  }
	
	  return this
	}
	
	/**
	 * get a packet from the store.
	 */
	Store.prototype.get = function (packet, cb) {
	  packet = this._inflights[packet.messageId]
	  if (packet) {
	    cb(null, packet)
	  } else if (cb) {
	    cb(new Error('missing packet'))
	  }
	
	  return this
	}
	
	/**
	 * Close the store
	 */
	Store.prototype.close = function (cb) {
	  this._inflights = null
	  if (cb) {
	    cb()
	  }
	}
	
	module.exports = Store
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(22);
	exports.Stream = exports;
	exports.Readable = exports;
	exports.Writable = __webpack_require__(36);
	exports.Duplex = __webpack_require__(35);
	exports.Transform = __webpack_require__(42);
	exports.PassThrough = __webpack_require__(43);


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	/*<replacement>*/
	
	var processNextTick = __webpack_require__(23);
	/*</replacement>*/
	
	module.exports = Readable;
	
	/*<replacement>*/
	var isArray = __webpack_require__(24);
	/*</replacement>*/
	
	/*<replacement>*/
	var Duplex;
	/*</replacement>*/
	
	Readable.ReadableState = ReadableState;
	
	/*<replacement>*/
	var EE = __webpack_require__(19).EventEmitter;
	
	var EElistenerCount = function (emitter, type) {
	  return emitter.listeners(type).length;
	};
	/*</replacement>*/
	
	/*<replacement>*/
	var Stream = __webpack_require__(25);
	/*</replacement>*/
	
	// TODO(bmeurer): Change this back to const once hole checks are
	// properly optimized away early in Ignition+TurboFan.
	/*<replacement>*/
	var Buffer = __webpack_require__(26).Buffer;
	var OurUint8Array = global.Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}
	/*</replacement>*/
	
	/*<replacement>*/
	var util = __webpack_require__(30);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/
	
	/*<replacement>*/
	var debugUtil = __webpack_require__(32);
	var debug = void 0;
	if (debugUtil && debugUtil.debuglog) {
	  debug = debugUtil.debuglog('stream');
	} else {
	  debug = function () {};
	}
	/*</replacement>*/
	
	var BufferList = __webpack_require__(33);
	var destroyImpl = __webpack_require__(34);
	var StringDecoder;
	
	util.inherits(Readable, Stream);
	
	var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];
	
	function prependListener(emitter, event, fn) {
	  // Sadly this is not cacheable as some libraries bundle their own
	  // event emitter implementation with them.
	  if (typeof emitter.prependListener === 'function') {
	    return emitter.prependListener(event, fn);
	  } else {
	    // This is a hack to make sure that our error handler is attached before any
	    // userland ones.  NEVER DO THIS. This is here only because this code needs
	    // to continue to work with older versions of Node.js that do not include
	    // the prependListener() method. The goal is to eventually remove this hack.
	    if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
	  }
	}
	
	function ReadableState(options, stream) {
	  Duplex = Duplex || __webpack_require__(35);
	
	  options = options || {};
	
	  // object stream flag. Used to make read(n) ignore n and to
	  // make all the buffer merging and length checks go away
	  this.objectMode = !!options.objectMode;
	
	  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.readableObjectMode;
	
	  // the point at which it stops calling _read() to fill the buffer
	  // Note: 0 is a valid value, means "don't call _read preemptively ever"
	  var hwm = options.highWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
	  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;
	
	  // cast to ints.
	  this.highWaterMark = Math.floor(this.highWaterMark);
	
	  // A linked list is used to store data chunks instead of an array because the
	  // linked list can remove elements from the beginning faster than
	  // array.shift()
	  this.buffer = new BufferList();
	  this.length = 0;
	  this.pipes = null;
	  this.pipesCount = 0;
	  this.flowing = null;
	  this.ended = false;
	  this.endEmitted = false;
	  this.reading = false;
	
	  // a flag to be able to tell if the event 'readable'/'data' is emitted
	  // immediately, or on a later tick.  We set this to true at first, because
	  // any actions that shouldn't happen until "later" should generally also
	  // not happen before the first read call.
	  this.sync = true;
	
	  // whenever we return null, then we set a flag to say
	  // that we're awaiting a 'readable' event emission.
	  this.needReadable = false;
	  this.emittedReadable = false;
	  this.readableListening = false;
	  this.resumeScheduled = false;
	
	  // has it been destroyed
	  this.destroyed = false;
	
	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';
	
	  // the number of writers that are awaiting a drain event in .pipe()s
	  this.awaitDrain = 0;
	
	  // if true, a maybeReadMore has been scheduled
	  this.readingMore = false;
	
	  this.decoder = null;
	  this.encoding = null;
	  if (options.encoding) {
	    if (!StringDecoder) StringDecoder = __webpack_require__(41).StringDecoder;
	    this.decoder = new StringDecoder(options.encoding);
	    this.encoding = options.encoding;
	  }
	}
	
	function Readable(options) {
	  Duplex = Duplex || __webpack_require__(35);
	
	  if (!(this instanceof Readable)) return new Readable(options);
	
	  this._readableState = new ReadableState(options, this);
	
	  // legacy
	  this.readable = true;
	
	  if (options) {
	    if (typeof options.read === 'function') this._read = options.read;
	
	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	  }
	
	  Stream.call(this);
	}
	
	Object.defineProperty(Readable.prototype, 'destroyed', {
	  get: function () {
	    if (this._readableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._readableState) {
	      return;
	    }
	
	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	  }
	});
	
	Readable.prototype.destroy = destroyImpl.destroy;
	Readable.prototype._undestroy = destroyImpl.undestroy;
	Readable.prototype._destroy = function (err, cb) {
	  this.push(null);
	  cb(err);
	};
	
	// Manually shove something into the read() buffer.
	// This returns true if the highWaterMark has not been hit yet,
	// similar to how Writable.write() returns true if you should
	// write() some more.
	Readable.prototype.push = function (chunk, encoding) {
	  var state = this._readableState;
	  var skipChunkCheck;
	
	  if (!state.objectMode) {
	    if (typeof chunk === 'string') {
	      encoding = encoding || state.defaultEncoding;
	      if (encoding !== state.encoding) {
	        chunk = Buffer.from(chunk, encoding);
	        encoding = '';
	      }
	      skipChunkCheck = true;
	    }
	  } else {
	    skipChunkCheck = true;
	  }
	
	  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
	};
	
	// Unshift should *always* be something directly out of read()
	Readable.prototype.unshift = function (chunk) {
	  return readableAddChunk(this, chunk, null, true, false);
	};
	
	function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
	  var state = stream._readableState;
	  if (chunk === null) {
	    state.reading = false;
	    onEofChunk(stream, state);
	  } else {
	    var er;
	    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
	    if (er) {
	      stream.emit('error', er);
	    } else if (state.objectMode || chunk && chunk.length > 0) {
	      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
	        chunk = _uint8ArrayToBuffer(chunk);
	      }
	
	      if (addToFront) {
	        if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
	      } else if (state.ended) {
	        stream.emit('error', new Error('stream.push() after EOF'));
	      } else {
	        state.reading = false;
	        if (state.decoder && !encoding) {
	          chunk = state.decoder.write(chunk);
	          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
	        } else {
	          addChunk(stream, state, chunk, false);
	        }
	      }
	    } else if (!addToFront) {
	      state.reading = false;
	    }
	  }
	
	  return needMoreData(state);
	}
	
	function addChunk(stream, state, chunk, addToFront) {
	  if (state.flowing && state.length === 0 && !state.sync) {
	    stream.emit('data', chunk);
	    stream.read(0);
	  } else {
	    // update the buffer info.
	    state.length += state.objectMode ? 1 : chunk.length;
	    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);
	
	    if (state.needReadable) emitReadable(stream);
	  }
	  maybeReadMore(stream, state);
	}
	
	function chunkInvalid(state, chunk) {
	  var er;
	  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  return er;
	}
	
	// if it's past the high water mark, we can push in some more.
	// Also, if we have no data yet, we can stand some
	// more bytes.  This is to work around cases where hwm=0,
	// such as the repl.  Also, if the push() triggered a
	// readable event, and the user called read(largeNumber) such that
	// needReadable was set, then we ought to push more, so that another
	// 'readable' event will be triggered.
	function needMoreData(state) {
	  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
	}
	
	Readable.prototype.isPaused = function () {
	  return this._readableState.flowing === false;
	};
	
	// backwards compatibility.
	Readable.prototype.setEncoding = function (enc) {
	  if (!StringDecoder) StringDecoder = __webpack_require__(41).StringDecoder;
	  this._readableState.decoder = new StringDecoder(enc);
	  this._readableState.encoding = enc;
	  return this;
	};
	
	// Don't raise the hwm > 8MB
	var MAX_HWM = 0x800000;
	function computeNewHighWaterMark(n) {
	  if (n >= MAX_HWM) {
	    n = MAX_HWM;
	  } else {
	    // Get the next highest power of 2 to prevent increasing hwm excessively in
	    // tiny amounts
	    n--;
	    n |= n >>> 1;
	    n |= n >>> 2;
	    n |= n >>> 4;
	    n |= n >>> 8;
	    n |= n >>> 16;
	    n++;
	  }
	  return n;
	}
	
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function howMuchToRead(n, state) {
	  if (n <= 0 || state.length === 0 && state.ended) return 0;
	  if (state.objectMode) return 1;
	  if (n !== n) {
	    // Only flow one buffer at a time
	    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
	  }
	  // If we're asking for more than the current hwm, then raise the hwm.
	  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
	  if (n <= state.length) return n;
	  // Don't have enough
	  if (!state.ended) {
	    state.needReadable = true;
	    return 0;
	  }
	  return state.length;
	}
	
	// you can override either this method, or the async _read(n) below.
	Readable.prototype.read = function (n) {
	  debug('read', n);
	  n = parseInt(n, 10);
	  var state = this._readableState;
	  var nOrig = n;
	
	  if (n !== 0) state.emittedReadable = false;
	
	  // if we're doing read(0) to trigger a readable event, but we
	  // already have a bunch of data in the buffer, then just trigger
	  // the 'readable' event and move on.
	  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
	    debug('read: emitReadable', state.length, state.ended);
	    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
	    return null;
	  }
	
	  n = howMuchToRead(n, state);
	
	  // if we've ended, and we're now clear, then finish it up.
	  if (n === 0 && state.ended) {
	    if (state.length === 0) endReadable(this);
	    return null;
	  }
	
	  // All the actual chunk generation logic needs to be
	  // *below* the call to _read.  The reason is that in certain
	  // synthetic stream cases, such as passthrough streams, _read
	  // may be a completely synchronous operation which may change
	  // the state of the read buffer, providing enough data when
	  // before there was *not* enough.
	  //
	  // So, the steps are:
	  // 1. Figure out what the state of things will be after we do
	  // a read from the buffer.
	  //
	  // 2. If that resulting state will trigger a _read, then call _read.
	  // Note that this may be asynchronous, or synchronous.  Yes, it is
	  // deeply ugly to write APIs this way, but that still doesn't mean
	  // that the Readable class should behave improperly, as streams are
	  // designed to be sync/async agnostic.
	  // Take note if the _read call is sync or async (ie, if the read call
	  // has returned yet), so that we know whether or not it's safe to emit
	  // 'readable' etc.
	  //
	  // 3. Actually pull the requested chunks out of the buffer and return.
	
	  // if we need a readable event, then we need to do some reading.
	  var doRead = state.needReadable;
	  debug('need readable', doRead);
	
	  // if we currently have less than the highWaterMark, then also read some
	  if (state.length === 0 || state.length - n < state.highWaterMark) {
	    doRead = true;
	    debug('length less than watermark', doRead);
	  }
	
	  // however, if we've ended, then there's no point, and if we're already
	  // reading, then it's unnecessary.
	  if (state.ended || state.reading) {
	    doRead = false;
	    debug('reading or ended', doRead);
	  } else if (doRead) {
	    debug('do read');
	    state.reading = true;
	    state.sync = true;
	    // if the length is currently zero, then we *need* a readable event.
	    if (state.length === 0) state.needReadable = true;
	    // call internal read method
	    this._read(state.highWaterMark);
	    state.sync = false;
	    // If _read pushed data synchronously, then `reading` will be false,
	    // and we need to re-evaluate how much data we can return to the user.
	    if (!state.reading) n = howMuchToRead(nOrig, state);
	  }
	
	  var ret;
	  if (n > 0) ret = fromList(n, state);else ret = null;
	
	  if (ret === null) {
	    state.needReadable = true;
	    n = 0;
	  } else {
	    state.length -= n;
	  }
	
	  if (state.length === 0) {
	    // If we have nothing in the buffer, then we want to know
	    // as soon as we *do* get something into the buffer.
	    if (!state.ended) state.needReadable = true;
	
	    // If we tried to read() past the EOF, then emit end on the next tick.
	    if (nOrig !== n && state.ended) endReadable(this);
	  }
	
	  if (ret !== null) this.emit('data', ret);
	
	  return ret;
	};
	
	function onEofChunk(stream, state) {
	  if (state.ended) return;
	  if (state.decoder) {
	    var chunk = state.decoder.end();
	    if (chunk && chunk.length) {
	      state.buffer.push(chunk);
	      state.length += state.objectMode ? 1 : chunk.length;
	    }
	  }
	  state.ended = true;
	
	  // emit 'readable' now to make sure it gets picked up.
	  emitReadable(stream);
	}
	
	// Don't emit readable right away in sync mode, because this can trigger
	// another read() call => stack overflow.  This way, it might trigger
	// a nextTick recursion warning, but that's not so bad.
	function emitReadable(stream) {
	  var state = stream._readableState;
	  state.needReadable = false;
	  if (!state.emittedReadable) {
	    debug('emitReadable', state.flowing);
	    state.emittedReadable = true;
	    if (state.sync) processNextTick(emitReadable_, stream);else emitReadable_(stream);
	  }
	}
	
	function emitReadable_(stream) {
	  debug('emit readable');
	  stream.emit('readable');
	  flow(stream);
	}
	
	// at this point, the user has presumably seen the 'readable' event,
	// and called read() to consume some data.  that may have triggered
	// in turn another _read(n) call, in which case reading = true if
	// it's in progress.
	// However, if we're not ended, or reading, and the length < hwm,
	// then go ahead and try to read some more preemptively.
	function maybeReadMore(stream, state) {
	  if (!state.readingMore) {
	    state.readingMore = true;
	    processNextTick(maybeReadMore_, stream, state);
	  }
	}
	
	function maybeReadMore_(stream, state) {
	  var len = state.length;
	  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
	    debug('maybeReadMore read 0');
	    stream.read(0);
	    if (len === state.length)
	      // didn't get any data, stop spinning.
	      break;else len = state.length;
	  }
	  state.readingMore = false;
	}
	
	// abstract method.  to be overridden in specific implementation classes.
	// call cb(er, data) where data is <= n in length.
	// for virtual (non-string, non-buffer) streams, "length" is somewhat
	// arbitrary, and perhaps not very meaningful.
	Readable.prototype._read = function (n) {
	  this.emit('error', new Error('_read() is not implemented'));
	};
	
	Readable.prototype.pipe = function (dest, pipeOpts) {
	  var src = this;
	  var state = this._readableState;
	
	  switch (state.pipesCount) {
	    case 0:
	      state.pipes = dest;
	      break;
	    case 1:
	      state.pipes = [state.pipes, dest];
	      break;
	    default:
	      state.pipes.push(dest);
	      break;
	  }
	  state.pipesCount += 1;
	  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);
	
	  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
	
	  var endFn = doEnd ? onend : unpipe;
	  if (state.endEmitted) processNextTick(endFn);else src.once('end', endFn);
	
	  dest.on('unpipe', onunpipe);
	  function onunpipe(readable, unpipeInfo) {
	    debug('onunpipe');
	    if (readable === src) {
	      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
	        unpipeInfo.hasUnpiped = true;
	        cleanup();
	      }
	    }
	  }
	
	  function onend() {
	    debug('onend');
	    dest.end();
	  }
	
	  // when the dest drains, it reduces the awaitDrain counter
	  // on the source.  This would be more elegant with a .once()
	  // handler in flow(), but adding and removing repeatedly is
	  // too slow.
	  var ondrain = pipeOnDrain(src);
	  dest.on('drain', ondrain);
	
	  var cleanedUp = false;
	  function cleanup() {
	    debug('cleanup');
	    // cleanup event handlers once the pipe is broken
	    dest.removeListener('close', onclose);
	    dest.removeListener('finish', onfinish);
	    dest.removeListener('drain', ondrain);
	    dest.removeListener('error', onerror);
	    dest.removeListener('unpipe', onunpipe);
	    src.removeListener('end', onend);
	    src.removeListener('end', unpipe);
	    src.removeListener('data', ondata);
	
	    cleanedUp = true;
	
	    // if the reader is waiting for a drain event from this
	    // specific writer, then it would cause it to never start
	    // flowing again.
	    // So, if this is awaiting a drain, then we just call it now.
	    // If we don't know, then assume that we are waiting for one.
	    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
	  }
	
	  // If the user pushes more data while we're writing to dest then we'll end up
	  // in ondata again. However, we only want to increase awaitDrain once because
	  // dest will only emit one 'drain' event for the multiple writes.
	  // => Introduce a guard on increasing awaitDrain.
	  var increasedAwaitDrain = false;
	  src.on('data', ondata);
	  function ondata(chunk) {
	    debug('ondata');
	    increasedAwaitDrain = false;
	    var ret = dest.write(chunk);
	    if (false === ret && !increasedAwaitDrain) {
	      // If the user unpiped during `dest.write()`, it is possible
	      // to get stuck in a permanently paused state if that write
	      // also returned false.
	      // => Check whether `dest` is still a piping destination.
	      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
	        debug('false write response, pause', src._readableState.awaitDrain);
	        src._readableState.awaitDrain++;
	        increasedAwaitDrain = true;
	      }
	      src.pause();
	    }
	  }
	
	  // if the dest has an error, then stop piping into it.
	  // however, don't suppress the throwing behavior for this.
	  function onerror(er) {
	    debug('onerror', er);
	    unpipe();
	    dest.removeListener('error', onerror);
	    if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
	  }
	
	  // Make sure our error handler is attached before userland ones.
	  prependListener(dest, 'error', onerror);
	
	  // Both close and finish should trigger unpipe, but only once.
	  function onclose() {
	    dest.removeListener('finish', onfinish);
	    unpipe();
	  }
	  dest.once('close', onclose);
	  function onfinish() {
	    debug('onfinish');
	    dest.removeListener('close', onclose);
	    unpipe();
	  }
	  dest.once('finish', onfinish);
	
	  function unpipe() {
	    debug('unpipe');
	    src.unpipe(dest);
	  }
	
	  // tell the dest that it's being piped to
	  dest.emit('pipe', src);
	
	  // start the flow if it hasn't been started already.
	  if (!state.flowing) {
	    debug('pipe resume');
	    src.resume();
	  }
	
	  return dest;
	};
	
	function pipeOnDrain(src) {
	  return function () {
	    var state = src._readableState;
	    debug('pipeOnDrain', state.awaitDrain);
	    if (state.awaitDrain) state.awaitDrain--;
	    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
	      state.flowing = true;
	      flow(src);
	    }
	  };
	}
	
	Readable.prototype.unpipe = function (dest) {
	  var state = this._readableState;
	  var unpipeInfo = { hasUnpiped: false };
	
	  // if we're not piping anywhere, then do nothing.
	  if (state.pipesCount === 0) return this;
	
	  // just one destination.  most common case.
	  if (state.pipesCount === 1) {
	    // passed in one, but it's not the right one.
	    if (dest && dest !== state.pipes) return this;
	
	    if (!dest) dest = state.pipes;
	
	    // got a match.
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	    if (dest) dest.emit('unpipe', this, unpipeInfo);
	    return this;
	  }
	
	  // slow case. multiple pipe destinations.
	
	  if (!dest) {
	    // remove all.
	    var dests = state.pipes;
	    var len = state.pipesCount;
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	
	    for (var i = 0; i < len; i++) {
	      dests[i].emit('unpipe', this, unpipeInfo);
	    }return this;
	  }
	
	  // try to find the right one.
	  var index = indexOf(state.pipes, dest);
	  if (index === -1) return this;
	
	  state.pipes.splice(index, 1);
	  state.pipesCount -= 1;
	  if (state.pipesCount === 1) state.pipes = state.pipes[0];
	
	  dest.emit('unpipe', this, unpipeInfo);
	
	  return this;
	};
	
	// set up data events if they are asked for
	// Ensure readable listeners eventually get something
	Readable.prototype.on = function (ev, fn) {
	  var res = Stream.prototype.on.call(this, ev, fn);
	
	  if (ev === 'data') {
	    // Start flowing on next tick if stream isn't explicitly paused
	    if (this._readableState.flowing !== false) this.resume();
	  } else if (ev === 'readable') {
	    var state = this._readableState;
	    if (!state.endEmitted && !state.readableListening) {
	      state.readableListening = state.needReadable = true;
	      state.emittedReadable = false;
	      if (!state.reading) {
	        processNextTick(nReadingNextTick, this);
	      } else if (state.length) {
	        emitReadable(this);
	      }
	    }
	  }
	
	  return res;
	};
	Readable.prototype.addListener = Readable.prototype.on;
	
	function nReadingNextTick(self) {
	  debug('readable nexttick read 0');
	  self.read(0);
	}
	
	// pause() and resume() are remnants of the legacy readable stream API
	// If the user uses them, then switch into old mode.
	Readable.prototype.resume = function () {
	  var state = this._readableState;
	  if (!state.flowing) {
	    debug('resume');
	    state.flowing = true;
	    resume(this, state);
	  }
	  return this;
	};
	
	function resume(stream, state) {
	  if (!state.resumeScheduled) {
	    state.resumeScheduled = true;
	    processNextTick(resume_, stream, state);
	  }
	}
	
	function resume_(stream, state) {
	  if (!state.reading) {
	    debug('resume read 0');
	    stream.read(0);
	  }
	
	  state.resumeScheduled = false;
	  state.awaitDrain = 0;
	  stream.emit('resume');
	  flow(stream);
	  if (state.flowing && !state.reading) stream.read(0);
	}
	
	Readable.prototype.pause = function () {
	  debug('call pause flowing=%j', this._readableState.flowing);
	  if (false !== this._readableState.flowing) {
	    debug('pause');
	    this._readableState.flowing = false;
	    this.emit('pause');
	  }
	  return this;
	};
	
	function flow(stream) {
	  var state = stream._readableState;
	  debug('flow', state.flowing);
	  while (state.flowing && stream.read() !== null) {}
	}
	
	// wrap an old-style stream as the async data source.
	// This is *not* part of the readable stream interface.
	// It is an ugly unfortunate mess of history.
	Readable.prototype.wrap = function (stream) {
	  var state = this._readableState;
	  var paused = false;
	
	  var self = this;
	  stream.on('end', function () {
	    debug('wrapped end');
	    if (state.decoder && !state.ended) {
	      var chunk = state.decoder.end();
	      if (chunk && chunk.length) self.push(chunk);
	    }
	
	    self.push(null);
	  });
	
	  stream.on('data', function (chunk) {
	    debug('wrapped data');
	    if (state.decoder) chunk = state.decoder.write(chunk);
	
	    // don't skip over falsy values in objectMode
	    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;
	
	    var ret = self.push(chunk);
	    if (!ret) {
	      paused = true;
	      stream.pause();
	    }
	  });
	
	  // proxy all the other methods.
	  // important when wrapping filters and duplexes.
	  for (var i in stream) {
	    if (this[i] === undefined && typeof stream[i] === 'function') {
	      this[i] = function (method) {
	        return function () {
	          return stream[method].apply(stream, arguments);
	        };
	      }(i);
	    }
	  }
	
	  // proxy certain important events.
	  for (var n = 0; n < kProxyEvents.length; n++) {
	    stream.on(kProxyEvents[n], self.emit.bind(self, kProxyEvents[n]));
	  }
	
	  // when we try to consume some more bytes, simply unpause the
	  // underlying stream.
	  self._read = function (n) {
	    debug('wrapped _read', n);
	    if (paused) {
	      paused = false;
	      stream.resume();
	    }
	  };
	
	  return self;
	};
	
	// exposed for testing purposes only.
	Readable._fromList = fromList;
	
	// Pluck off n bytes from an array of buffers.
	// Length is the combined lengths of all the buffers in the list.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromList(n, state) {
	  // nothing buffered
	  if (state.length === 0) return null;
	
	  var ret;
	  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
	    // read it all, truncate the list
	    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
	    state.buffer.clear();
	  } else {
	    // read part of list
	    ret = fromListPartial(n, state.buffer, state.decoder);
	  }
	
	  return ret;
	}
	
	// Extracts only enough buffered data to satisfy the amount requested.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromListPartial(n, list, hasStrings) {
	  var ret;
	  if (n < list.head.data.length) {
	    // slice is the same for buffers and strings
	    ret = list.head.data.slice(0, n);
	    list.head.data = list.head.data.slice(n);
	  } else if (n === list.head.data.length) {
	    // first chunk is a perfect match
	    ret = list.shift();
	  } else {
	    // result spans more than one buffer
	    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
	  }
	  return ret;
	}
	
	// Copies a specified amount of characters from the list of buffered data
	// chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBufferString(n, list) {
	  var p = list.head;
	  var c = 1;
	  var ret = p.data;
	  n -= ret.length;
	  while (p = p.next) {
	    var str = p.data;
	    var nb = n > str.length ? str.length : n;
	    if (nb === str.length) ret += str;else ret += str.slice(0, n);
	    n -= nb;
	    if (n === 0) {
	      if (nb === str.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = str.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}
	
	// Copies a specified amount of bytes from the list of buffered data chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBuffer(n, list) {
	  var ret = Buffer.allocUnsafe(n);
	  var p = list.head;
	  var c = 1;
	  p.data.copy(ret);
	  n -= p.data.length;
	  while (p = p.next) {
	    var buf = p.data;
	    var nb = n > buf.length ? buf.length : n;
	    buf.copy(ret, ret.length - n, 0, nb);
	    n -= nb;
	    if (n === 0) {
	      if (nb === buf.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = buf.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}
	
	function endReadable(stream) {
	  var state = stream._readableState;
	
	  // If we get here before consuming all the bytes, then that is a
	  // bug in node.  Should never happen.
	  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');
	
	  if (!state.endEmitted) {
	    state.ended = true;
	    processNextTick(endReadableNT, state, stream);
	  }
	}
	
	function endReadableNT(state, stream) {
	  // Check that we didn't get one last unshift.
	  if (!state.endEmitted && state.length === 0) {
	    state.endEmitted = true;
	    stream.readable = false;
	    stream.emit('end');
	  }
	}
	
	function forEach(xs, f) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    f(xs[i], i);
	  }
	}
	
	function indexOf(xs, x) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    if (xs[i] === x) return i;
	  }
	  return -1;
	}
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(17)))

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {'use strict';
	
	if (!process.version ||
	    process.version.indexOf('v0.') === 0 ||
	    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
	  module.exports = nextTick;
	} else {
	  module.exports = process.nextTick;
	}
	
	function nextTick(fn, arg1, arg2, arg3) {
	  if (typeof fn !== 'function') {
	    throw new TypeError('"callback" argument must be a function');
	  }
	  var len = arguments.length;
	  var args, i;
	  switch (len) {
	  case 0:
	  case 1:
	    return process.nextTick(fn);
	  case 2:
	    return process.nextTick(function afterTickOne() {
	      fn.call(null, arg1);
	    });
	  case 3:
	    return process.nextTick(function afterTickTwo() {
	      fn.call(null, arg1, arg2);
	    });
	  case 4:
	    return process.nextTick(function afterTickThree() {
	      fn.call(null, arg1, arg2, arg3);
	    });
	  default:
	    args = new Array(len - 1);
	    i = 0;
	    while (i < args.length) {
	      args[i++] = arguments[i];
	    }
	    return process.nextTick(function afterTick() {
	      fn.apply(null, args);
	    });
	  }
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

/***/ }),
/* 24 */
/***/ (function(module, exports) {

	var toString = {}.toString;
	
	module.exports = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(19).EventEmitter;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

	/* eslint-disable node/no-deprecated-api */
	var buffer = __webpack_require__(27)
	var Buffer = buffer.Buffer
	
	// alternative to using Object.keys for old browsers
	function copyProps (src, dst) {
	  for (var key in src) {
	    dst[key] = src[key]
	  }
	}
	if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
	  module.exports = buffer
	} else {
	  // Copy properties from require('buffer')
	  copyProps(buffer, exports)
	  exports.Buffer = SafeBuffer
	}
	
	function SafeBuffer (arg, encodingOrOffset, length) {
	  return Buffer(arg, encodingOrOffset, length)
	}
	
	// Copy static methods from Buffer
	copyProps(Buffer, SafeBuffer)
	
	SafeBuffer.from = function (arg, encodingOrOffset, length) {
	  if (typeof arg === 'number') {
	    throw new TypeError('Argument must not be a number')
	  }
	  return Buffer(arg, encodingOrOffset, length)
	}
	
	SafeBuffer.alloc = function (size, fill, encoding) {
	  if (typeof size !== 'number') {
	    throw new TypeError('Argument must be a number')
	  }
	  var buf = Buffer(size)
	  if (fill !== undefined) {
	    if (typeof encoding === 'string') {
	      buf.fill(fill, encoding)
	    } else {
	      buf.fill(fill)
	    }
	  } else {
	    buf.fill(0)
	  }
	  return buf
	}
	
	SafeBuffer.allocUnsafe = function (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('Argument must be a number')
	  }
	  return Buffer(size)
	}
	
	SafeBuffer.allocUnsafeSlow = function (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('Argument must be a number')
	  }
	  return buffer.SlowBuffer(size)
	}


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	/* eslint-disable no-proto */
	
	'use strict'
	
	var base64 = __webpack_require__(28)
	var ieee754 = __webpack_require__(29)
	var isArray = __webpack_require__(24)
	
	exports.Buffer = Buffer
	exports.SlowBuffer = SlowBuffer
	exports.INSPECT_MAX_BYTES = 50
	
	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.
	
	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
	  ? global.TYPED_ARRAY_SUPPORT
	  : typedArraySupport()
	
	/*
	 * Export kMaxLength after typed array support is determined.
	 */
	exports.kMaxLength = kMaxLength()
	
	function typedArraySupport () {
	  try {
	    var arr = new Uint8Array(1)
	    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
	    return arr.foo() === 42 && // typed array instances can be augmented
	        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
	        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
	  } catch (e) {
	    return false
	  }
	}
	
	function kMaxLength () {
	  return Buffer.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}
	
	function createBuffer (that, length) {
	  if (kMaxLength() < length) {
	    throw new RangeError('Invalid typed array length')
	  }
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = new Uint8Array(length)
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    if (that === null) {
	      that = new Buffer(length)
	    }
	    that.length = length
	  }
	
	  return that
	}
	
	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */
	
	function Buffer (arg, encodingOrOffset, length) {
	  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
	    return new Buffer(arg, encodingOrOffset, length)
	  }
	
	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new Error(
	        'If encoding is specified then the first argument must be a string'
	      )
	    }
	    return allocUnsafe(this, arg)
	  }
	  return from(this, arg, encodingOrOffset, length)
	}
	
	Buffer.poolSize = 8192 // not used by this implementation
	
	// TODO: Legacy, not needed anymore. Remove in next major version.
	Buffer._augment = function (arr) {
	  arr.__proto__ = Buffer.prototype
	  return arr
	}
	
	function from (that, value, encodingOrOffset, length) {
	  if (typeof value === 'number') {
	    throw new TypeError('"value" argument must not be a number')
	  }
	
	  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
	    return fromArrayBuffer(that, value, encodingOrOffset, length)
	  }
	
	  if (typeof value === 'string') {
	    return fromString(that, value, encodingOrOffset)
	  }
	
	  return fromObject(that, value)
	}
	
	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer.from = function (value, encodingOrOffset, length) {
	  return from(null, value, encodingOrOffset, length)
	}
	
	if (Buffer.TYPED_ARRAY_SUPPORT) {
	  Buffer.prototype.__proto__ = Uint8Array.prototype
	  Buffer.__proto__ = Uint8Array
	  if (typeof Symbol !== 'undefined' && Symbol.species &&
	      Buffer[Symbol.species] === Buffer) {
	    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
	    Object.defineProperty(Buffer, Symbol.species, {
	      value: null,
	      configurable: true
	    })
	  }
	}
	
	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  } else if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }
	}
	
	function alloc (that, size, fill, encoding) {
	  assertSize(size)
	  if (size <= 0) {
	    return createBuffer(that, size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(that, size).fill(fill, encoding)
	      : createBuffer(that, size).fill(fill)
	  }
	  return createBuffer(that, size)
	}
	
	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer.alloc = function (size, fill, encoding) {
	  return alloc(null, size, fill, encoding)
	}
	
	function allocUnsafe (that, size) {
	  assertSize(size)
	  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < size; ++i) {
	      that[i] = 0
	    }
	  }
	  return that
	}
	
	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer.allocUnsafe = function (size) {
	  return allocUnsafe(null, size)
	}
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer.allocUnsafeSlow = function (size) {
	  return allocUnsafe(null, size)
	}
	
	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8'
	  }
	
	  if (!Buffer.isEncoding(encoding)) {
	    throw new TypeError('"encoding" must be a valid string encoding')
	  }
	
	  var length = byteLength(string, encoding) | 0
	  that = createBuffer(that, length)
	
	  var actual = that.write(string, encoding)
	
	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    that = that.slice(0, actual)
	  }
	
	  return that
	}
	
	function fromArrayLike (that, array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0
	  that = createBuffer(that, length)
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}
	
	function fromArrayBuffer (that, array, byteOffset, length) {
	  array.byteLength // this throws if `array` is not a valid ArrayBuffer
	
	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('\'offset\' is out of bounds')
	  }
	
	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('\'length\' is out of bounds')
	  }
	
	  if (byteOffset === undefined && length === undefined) {
	    array = new Uint8Array(array)
	  } else if (length === undefined) {
	    array = new Uint8Array(array, byteOffset)
	  } else {
	    array = new Uint8Array(array, byteOffset, length)
	  }
	
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = array
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromArrayLike(that, array)
	  }
	  return that
	}
	
	function fromObject (that, obj) {
	  if (Buffer.isBuffer(obj)) {
	    var len = checked(obj.length) | 0
	    that = createBuffer(that, len)
	
	    if (that.length === 0) {
	      return that
	    }
	
	    obj.copy(that, 0, 0, len)
	    return that
	  }
	
	  if (obj) {
	    if ((typeof ArrayBuffer !== 'undefined' &&
	        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
	      if (typeof obj.length !== 'number' || isnan(obj.length)) {
	        return createBuffer(that, 0)
	      }
	      return fromArrayLike(that, obj)
	    }
	
	    if (obj.type === 'Buffer' && isArray(obj.data)) {
	      return fromArrayLike(that, obj.data)
	    }
	  }
	
	  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
	}
	
	function checked (length) {
	  // Note: cannot use `length < kMaxLength()` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}
	
	function SlowBuffer (length) {
	  if (+length != length) { // eslint-disable-line eqeqeq
	    length = 0
	  }
	  return Buffer.alloc(+length)
	}
	
	Buffer.isBuffer = function isBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}
	
	Buffer.compare = function compare (a, b) {
	  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }
	
	  if (a === b) return 0
	
	  var x = a.length
	  var y = b.length
	
	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i]
	      y = b[i]
	      break
	    }
	  }
	
	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}
	
	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	}
	
	Buffer.concat = function concat (list, length) {
	  if (!isArray(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }
	
	  if (list.length === 0) {
	    return Buffer.alloc(0)
	  }
	
	  var i
	  if (length === undefined) {
	    length = 0
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length
	    }
	  }
	
	  var buffer = Buffer.allocUnsafe(length)
	  var pos = 0
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i]
	    if (!Buffer.isBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos)
	    pos += buf.length
	  }
	  return buffer
	}
	
	function byteLength (string, encoding) {
	  if (Buffer.isBuffer(string)) {
	    return string.length
	  }
	  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
	      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    string = '' + string
	  }
	
	  var len = string.length
	  if (len === 0) return 0
	
	  // Use a for loop to avoid recursion
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	      case undefined:
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	Buffer.byteLength = byteLength
	
	function slowToString (encoding, start, end) {
	  var loweredCase = false
	
	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.
	
	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }
	
	  if (end === undefined || end > this.length) {
	    end = this.length
	  }
	
	  if (end <= 0) {
	    return ''
	  }
	
	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0
	  start >>>= 0
	
	  if (end <= start) {
	    return ''
	  }
	
	  if (!encoding) encoding = 'utf8'
	
	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)
	
	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)
	
	      case 'ascii':
	        return asciiSlice(this, start, end)
	
	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)
	
	      case 'base64':
	        return base64Slice(this, start, end)
	
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)
	
	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	
	// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
	// Buffer instances.
	Buffer.prototype._isBuffer = true
	
	function swap (b, n, m) {
	  var i = b[n]
	  b[n] = b[m]
	  b[m] = i
	}
	
	Buffer.prototype.swap16 = function swap16 () {
	  var len = this.length
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1)
	  }
	  return this
	}
	
	Buffer.prototype.swap32 = function swap32 () {
	  var len = this.length
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3)
	    swap(this, i + 1, i + 2)
	  }
	  return this
	}
	
	Buffer.prototype.swap64 = function swap64 () {
	  var len = this.length
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7)
	    swap(this, i + 1, i + 6)
	    swap(this, i + 2, i + 5)
	    swap(this, i + 3, i + 4)
	  }
	  return this
	}
	
	Buffer.prototype.toString = function toString () {
	  var length = this.length | 0
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	}
	
	Buffer.prototype.equals = function equals (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	}
	
	Buffer.prototype.inspect = function inspect () {
	  var str = ''
	  var max = exports.INSPECT_MAX_BYTES
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
	    if (this.length > max) str += ' ... '
	  }
	  return '<Buffer ' + str + '>'
	}
	
	Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (!Buffer.isBuffer(target)) {
	    throw new TypeError('Argument must be a Buffer')
	  }
	
	  if (start === undefined) {
	    start = 0
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0
	  }
	  if (thisStart === undefined) {
	    thisStart = 0
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length
	  }
	
	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }
	
	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }
	
	  start >>>= 0
	  end >>>= 0
	  thisStart >>>= 0
	  thisEnd >>>= 0
	
	  if (this === target) return 0
	
	  var x = thisEnd - thisStart
	  var y = end - start
	  var len = Math.min(x, y)
	
	  var thisCopy = this.slice(thisStart, thisEnd)
	  var targetCopy = target.slice(start, end)
	
	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i]
	      y = targetCopy[i]
	      break
	    }
	  }
	
	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}
	
	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1
	
	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset
	    byteOffset = 0
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff
	  } else if (byteOffset < -0x80000000) {
	    byteOffset = -0x80000000
	  }
	  byteOffset = +byteOffset  // Coerce to Number.
	  if (isNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1)
	  }
	
	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0
	    else return -1
	  }
	
	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer.from(val, encoding)
	  }
	
	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (Buffer.isBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF // Search for a byte value [0-255]
	    if (Buffer.TYPED_ARRAY_SUPPORT &&
	        typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }
	
	  throw new TypeError('val must be string, number or Buffer')
	}
	
	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1
	  var arrLength = arr.length
	  var valLength = val.length
	
	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase()
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2
	      arrLength /= 2
	      valLength /= 2
	      byteOffset /= 2
	    }
	  }
	
	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }
	
	  var i
	  if (dir) {
	    var foundIndex = -1
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex
	        foundIndex = -1
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false
	          break
	        }
	      }
	      if (found) return i
	    }
	  }
	
	  return -1
	}
	
	Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	}
	
	Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	}
	
	Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	}
	
	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0
	  var remaining = buf.length - offset
	  if (!length) {
	    length = remaining
	  } else {
	    length = Number(length)
	    if (length > remaining) {
	      length = remaining
	    }
	  }
	
	  // must be an even number of digits
	  var strLen = string.length
	  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')
	
	  if (length > strLen / 2) {
	    length = strLen / 2
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16)
	    if (isNaN(parsed)) return i
	    buf[offset + i] = parsed
	  }
	  return i
	}
	
	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}
	
	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}
	
	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}
	
	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}
	
	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}
	
	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8'
	    length = this.length
	    offset = 0
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset
	    length = this.length
	    offset = 0
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0
	    if (isFinite(length)) {
	      length = length | 0
	      if (encoding === undefined) encoding = 'utf8'
	    } else {
	      encoding = length
	      length = undefined
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }
	
	  var remaining = this.length - offset
	  if (length === undefined || length > remaining) length = remaining
	
	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }
	
	  if (!encoding) encoding = 'utf8'
	
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)
	
	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)
	
	      case 'ascii':
	        return asciiWrite(this, string, offset, length)
	
	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)
	
	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)
	
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)
	
	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	
	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	}
	
	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return base64.fromByteArray(buf)
	  } else {
	    return base64.fromByteArray(buf.slice(start, end))
	  }
	}
	
	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end)
	  var res = []
	
	  var i = start
	  while (i < end) {
	    var firstByte = buf[i]
	    var codePoint = null
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1
	
	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint
	
	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1]
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          fourthByte = buf[i + 3]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint
	            }
	          }
	      }
	    }
	
	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD
	      bytesPerSequence = 1
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
	      codePoint = 0xDC00 | codePoint & 0x3FF
	    }
	
	    res.push(codePoint)
	    i += bytesPerSequence
	  }
	
	  return decodeCodePointsArray(res)
	}
	
	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000
	
	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }
	
	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = ''
	  var i = 0
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    )
	  }
	  return res
	}
	
	function asciiSlice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)
	
	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F)
	  }
	  return ret
	}
	
	function latin1Slice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)
	
	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i])
	  }
	  return ret
	}
	
	function hexSlice (buf, start, end) {
	  var len = buf.length
	
	  if (!start || start < 0) start = 0
	  if (!end || end < 0 || end > len) end = len
	
	  var out = ''
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i])
	  }
	  return out
	}
	
	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end)
	  var res = ''
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
	  }
	  return res
	}
	
	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length
	  start = ~~start
	  end = end === undefined ? len : ~~end
	
	  if (start < 0) {
	    start += len
	    if (start < 0) start = 0
	  } else if (start > len) {
	    start = len
	  }
	
	  if (end < 0) {
	    end += len
	    if (end < 0) end = 0
	  } else if (end > len) {
	    end = len
	  }
	
	  if (end < start) end = start
	
	  var newBuf
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    newBuf = this.subarray(start, end)
	    newBuf.__proto__ = Buffer.prototype
	  } else {
	    var sliceLen = end - start
	    newBuf = new Buffer(sliceLen, undefined)
	    for (var i = 0; i < sliceLen; ++i) {
	      newBuf[i] = this[i + start]
	    }
	  }
	
	  return newBuf
	}
	
	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}
	
	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	
	  return val
	}
	
	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length)
	  }
	
	  var val = this[offset + --byteLength]
	  var mul = 1
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul
	  }
	
	  return val
	}
	
	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  return this[offset]
	}
	
	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return this[offset] | (this[offset + 1] << 8)
	}
	
	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return (this[offset] << 8) | this[offset + 1]
	}
	
	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	}
	
	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	}
	
	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	  mul *= 0x80
	
	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)
	
	  return val
	}
	
	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var i = byteLength
	  var mul = 1
	  var val = this[offset + --i]
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul
	  }
	  mul *= 0x80
	
	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)
	
	  return val
	}
	
	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	}
	
	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset] | (this[offset + 1] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}
	
	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset + 1] | (this[offset] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}
	
	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	}
	
	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	}
	
	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, true, 23, 4)
	}
	
	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, false, 23, 4)
	}
	
	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, true, 52, 8)
	}
	
	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, false, 52, 8)
	}
	
	function checkInt (buf, value, offset, ext, max, min) {
	  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}
	
	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }
	
	  var mul = 1
	  var i = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }
	
	  var i = byteLength - 1
	  var mul = 1
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  this[offset] = (value & 0xff)
	  return offset + 1
	}
	
	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8
	  }
	}
	
	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}
	
	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
	  }
	}
	
	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 1] = (value >>> 8)
	    this[offset] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)
	
	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }
	
	  var i = 0
	  var mul = 1
	  var sub = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)
	
	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }
	
	  var i = byteLength - 1
	  var mul = 1
	  var sub = 0
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  if (value < 0) value = 0xff + value + 1
	  this[offset] = (value & 0xff)
	  return offset + 1
	}
	
	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 3] = (value >>> 24)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (value < 0) value = 0xffffffff + value + 1
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}
	
	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}
	
	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 23, 4)
	  return offset + 4
	}
	
	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	}
	
	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	}
	
	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 52, 8)
	  return offset + 8
	}
	
	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	}
	
	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	}
	
	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0
	  if (!end && end !== 0) end = this.length
	  if (targetStart >= target.length) targetStart = target.length
	  if (!targetStart) targetStart = 0
	  if (end > 0 && end < start) end = start
	
	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0
	
	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')
	
	  // Are we oob?
	  if (end > this.length) end = this.length
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start
	  }
	
	  var len = end - start
	  var i
	
	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; ++i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, start + len),
	      targetStart
	    )
	  }
	
	  return len
	}
	
	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start
	      start = 0
	      end = this.length
	    } else if (typeof end === 'string') {
	      encoding = end
	      end = this.length
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0)
	      if (code < 256) {
	        val = code
	      }
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255
	  }
	
	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }
	
	  if (end <= start) {
	    return this
	  }
	
	  start = start >>> 0
	  end = end === undefined ? this.length : end >>> 0
	
	  if (!val) val = 0
	
	  var i
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val
	    }
	  } else {
	    var bytes = Buffer.isBuffer(val)
	      ? val
	      : utf8ToBytes(new Buffer(val, encoding).toString())
	    var len = bytes.length
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len]
	    }
	  }
	
	  return this
	}
	
	// HELPER FUNCTIONS
	// ================
	
	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g
	
	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '='
	  }
	  return str
	}
	
	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}
	
	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}
	
	function utf8ToBytes (string, units) {
	  units = units || Infinity
	  var codePoint
	  var length = string.length
	  var leadSurrogate = null
	  var bytes = []
	
	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i)
	
	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        }
	
	        // valid lead
	        leadSurrogate = codePoint
	
	        continue
	      }
	
	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	        leadSurrogate = codePoint
	        continue
	      }
	
	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	    }
	
	    leadSurrogate = null
	
	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint)
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }
	
	  return bytes
	}
	
	function asciiToBytes (str) {
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF)
	  }
	  return byteArray
	}
	
	function utf16leToBytes (str, units) {
	  var c, hi, lo
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break
	
	    c = str.charCodeAt(i)
	    hi = c >> 8
	    lo = c % 256
	    byteArray.push(lo)
	    byteArray.push(hi)
	  }
	
	  return byteArray
	}
	
	function base64ToBytes (str) {
	  return base64.toByteArray(base64clean(str))
	}
	
	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i]
	  }
	  return i
	}
	
	function isnan (val) {
	  return val !== val // eslint-disable-line no-self-compare
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 28 */
/***/ (function(module, exports) {

	'use strict'
	
	exports.byteLength = byteLength
	exports.toByteArray = toByteArray
	exports.fromByteArray = fromByteArray
	
	var lookup = []
	var revLookup = []
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array
	
	var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
	for (var i = 0, len = code.length; i < len; ++i) {
	  lookup[i] = code[i]
	  revLookup[code.charCodeAt(i)] = i
	}
	
	revLookup['-'.charCodeAt(0)] = 62
	revLookup['_'.charCodeAt(0)] = 63
	
	function placeHoldersCount (b64) {
	  var len = b64.length
	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }
	
	  // the number of equal signs (place holders)
	  // if there are two placeholders, than the two characters before it
	  // represent one byte
	  // if there is only one, then the three characters before it represent 2 bytes
	  // this is just a cheap hack to not do indexOf twice
	  return b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0
	}
	
	function byteLength (b64) {
	  // base64 is 4/3 + up to two characters of the original data
	  return (b64.length * 3 / 4) - placeHoldersCount(b64)
	}
	
	function toByteArray (b64) {
	  var i, l, tmp, placeHolders, arr
	  var len = b64.length
	  placeHolders = placeHoldersCount(b64)
	
	  arr = new Arr((len * 3 / 4) - placeHolders)
	
	  // if there are placeholders, only get up to the last complete 4 chars
	  l = placeHolders > 0 ? len - 4 : len
	
	  var L = 0
	
	  for (i = 0; i < l; i += 4) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)]
	    arr[L++] = (tmp >> 16) & 0xFF
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }
	
	  if (placeHolders === 2) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4)
	    arr[L++] = tmp & 0xFF
	  } else if (placeHolders === 1) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2)
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }
	
	  return arr
	}
	
	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
	}
	
	function encodeChunk (uint8, start, end) {
	  var tmp
	  var output = []
	  for (var i = start; i < end; i += 3) {
	    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
	    output.push(tripletToBase64(tmp))
	  }
	  return output.join('')
	}
	
	function fromByteArray (uint8) {
	  var tmp
	  var len = uint8.length
	  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
	  var output = ''
	  var parts = []
	  var maxChunkLength = 16383 // must be multiple of 3
	
	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
	  }
	
	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1]
	    output += lookup[tmp >> 2]
	    output += lookup[(tmp << 4) & 0x3F]
	    output += '=='
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + (uint8[len - 1])
	    output += lookup[tmp >> 10]
	    output += lookup[(tmp >> 4) & 0x3F]
	    output += lookup[(tmp << 2) & 0x3F]
	    output += '='
	  }
	
	  parts.push(output)
	
	  return parts.join('')
	}


/***/ }),
/* 29 */
/***/ (function(module, exports) {

	exports.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var nBits = -7
	  var i = isLE ? (nBytes - 1) : 0
	  var d = isLE ? -1 : 1
	  var s = buffer[offset + i]
	
	  i += d
	
	  e = s & ((1 << (-nBits)) - 1)
	  s >>= (-nBits)
	  nBits += eLen
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}
	
	  m = e & ((1 << (-nBits)) - 1)
	  e >>= (-nBits)
	  nBits += mLen
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}
	
	  if (e === 0) {
	    e = 1 - eBias
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen)
	    e = e - eBias
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}
	
	exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
	  var i = isLE ? 0 : (nBytes - 1)
	  var d = isLE ? 1 : -1
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0
	
	  value = Math.abs(value)
	
	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0
	    e = eMax
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2)
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--
	      c *= 2
	    }
	    if (e + eBias >= 1) {
	      value += rt / c
	    } else {
	      value += rt * Math.pow(2, 1 - eBias)
	    }
	    if (value * c >= 2) {
	      e++
	      c /= 2
	    }
	
	    if (e + eBias >= eMax) {
	      m = 0
	      e = eMax
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen)
	      e = e + eBias
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
	      e = 0
	    }
	  }
	
	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}
	
	  e = (e << mLen) | m
	  eLen += mLen
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}
	
	  buffer[offset + i - d] |= s * 128
	}


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	
	function isArray(arg) {
	  if (Array.isArray) {
	    return Array.isArray(arg);
	  }
	  return objectToString(arg) === '[object Array]';
	}
	exports.isArray = isArray;
	
	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;
	
	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;
	
	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;
	
	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;
	
	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;
	
	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;
	
	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;
	
	function isRegExp(re) {
	  return objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;
	
	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;
	
	function isDate(d) {
	  return objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;
	
	function isError(e) {
	  return (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;
	
	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;
	
	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;
	
	exports.isBuffer = Buffer.isBuffer;
	
	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(27).Buffer))

/***/ }),
/* 31 */
/***/ (function(module, exports) {

	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    var TempCtor = function () {}
	    TempCtor.prototype = superCtor.prototype
	    ctor.prototype = new TempCtor()
	    ctor.prototype.constructor = ctor
	  }
	}


/***/ }),
/* 32 */
/***/ (function(module, exports) {

	/* (ignored) */

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	/*<replacement>*/
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	var Buffer = __webpack_require__(26).Buffer;
	/*</replacement>*/
	
	function copyBuffer(src, target, offset) {
	  src.copy(target, offset);
	}
	
	module.exports = function () {
	  function BufferList() {
	    _classCallCheck(this, BufferList);
	
	    this.head = null;
	    this.tail = null;
	    this.length = 0;
	  }
	
	  BufferList.prototype.push = function push(v) {
	    var entry = { data: v, next: null };
	    if (this.length > 0) this.tail.next = entry;else this.head = entry;
	    this.tail = entry;
	    ++this.length;
	  };
	
	  BufferList.prototype.unshift = function unshift(v) {
	    var entry = { data: v, next: this.head };
	    if (this.length === 0) this.tail = entry;
	    this.head = entry;
	    ++this.length;
	  };
	
	  BufferList.prototype.shift = function shift() {
	    if (this.length === 0) return;
	    var ret = this.head.data;
	    if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
	    --this.length;
	    return ret;
	  };
	
	  BufferList.prototype.clear = function clear() {
	    this.head = this.tail = null;
	    this.length = 0;
	  };
	
	  BufferList.prototype.join = function join(s) {
	    if (this.length === 0) return '';
	    var p = this.head;
	    var ret = '' + p.data;
	    while (p = p.next) {
	      ret += s + p.data;
	    }return ret;
	  };
	
	  BufferList.prototype.concat = function concat(n) {
	    if (this.length === 0) return Buffer.alloc(0);
	    if (this.length === 1) return this.head.data;
	    var ret = Buffer.allocUnsafe(n >>> 0);
	    var p = this.head;
	    var i = 0;
	    while (p) {
	      copyBuffer(p.data, ret, i);
	      i += p.data.length;
	      p = p.next;
	    }
	    return ret;
	  };
	
	  return BufferList;
	}();

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	/*<replacement>*/
	
	var processNextTick = __webpack_require__(23);
	/*</replacement>*/
	
	// undocumented cb() API, needed for core, not for public API
	function destroy(err, cb) {
	  var _this = this;
	
	  var readableDestroyed = this._readableState && this._readableState.destroyed;
	  var writableDestroyed = this._writableState && this._writableState.destroyed;
	
	  if (readableDestroyed || writableDestroyed) {
	    if (cb) {
	      cb(err);
	    } else if (err && (!this._writableState || !this._writableState.errorEmitted)) {
	      processNextTick(emitErrorNT, this, err);
	    }
	    return;
	  }
	
	  // we set destroyed to true before firing error callbacks in order
	  // to make it re-entrance safe in case destroy() is called within callbacks
	
	  if (this._readableState) {
	    this._readableState.destroyed = true;
	  }
	
	  // if this is a duplex stream mark the writable part as destroyed as well
	  if (this._writableState) {
	    this._writableState.destroyed = true;
	  }
	
	  this._destroy(err || null, function (err) {
	    if (!cb && err) {
	      processNextTick(emitErrorNT, _this, err);
	      if (_this._writableState) {
	        _this._writableState.errorEmitted = true;
	      }
	    } else if (cb) {
	      cb(err);
	    }
	  });
	}
	
	function undestroy() {
	  if (this._readableState) {
	    this._readableState.destroyed = false;
	    this._readableState.reading = false;
	    this._readableState.ended = false;
	    this._readableState.endEmitted = false;
	  }
	
	  if (this._writableState) {
	    this._writableState.destroyed = false;
	    this._writableState.ended = false;
	    this._writableState.ending = false;
	    this._writableState.finished = false;
	    this._writableState.errorEmitted = false;
	  }
	}
	
	function emitErrorNT(self, err) {
	  self.emit('error', err);
	}
	
	module.exports = {
	  destroy: destroy,
	  undestroy: undestroy
	};

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	// a duplex stream is just a stream that is both readable and writable.
	// Since JS doesn't have multiple prototypal inheritance, this class
	// prototypally inherits from Readable, and then parasitically from
	// Writable.
	
	'use strict';
	
	/*<replacement>*/
	
	var processNextTick = __webpack_require__(23);
	/*</replacement>*/
	
	/*<replacement>*/
	var objectKeys = Object.keys || function (obj) {
	  var keys = [];
	  for (var key in obj) {
	    keys.push(key);
	  }return keys;
	};
	/*</replacement>*/
	
	module.exports = Duplex;
	
	/*<replacement>*/
	var util = __webpack_require__(30);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/
	
	var Readable = __webpack_require__(22);
	var Writable = __webpack_require__(36);
	
	util.inherits(Duplex, Readable);
	
	var keys = objectKeys(Writable.prototype);
	for (var v = 0; v < keys.length; v++) {
	  var method = keys[v];
	  if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
	}
	
	function Duplex(options) {
	  if (!(this instanceof Duplex)) return new Duplex(options);
	
	  Readable.call(this, options);
	  Writable.call(this, options);
	
	  if (options && options.readable === false) this.readable = false;
	
	  if (options && options.writable === false) this.writable = false;
	
	  this.allowHalfOpen = true;
	  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;
	
	  this.once('end', onend);
	}
	
	// the no-half-open enforcer
	function onend() {
	  // if we allow half-open state, or if the writable side ended,
	  // then we're ok.
	  if (this.allowHalfOpen || this._writableState.ended) return;
	
	  // no more data can be written.
	  // But allow more writes to happen in this tick.
	  processNextTick(onEndNT, this);
	}
	
	function onEndNT(self) {
	  self.end();
	}
	
	Object.defineProperty(Duplex.prototype, 'destroyed', {
	  get: function () {
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed && this._writableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return;
	    }
	
	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	    this._writableState.destroyed = value;
	  }
	});
	
	Duplex.prototype._destroy = function (err, cb) {
	  this.push(null);
	  this.end();
	
	  processNextTick(cb, err);
	};
	
	function forEach(xs, f) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    f(xs[i], i);
	  }
	}

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process, setImmediate, global) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	// A bit simpler than readable streams.
	// Implement an async ._write(chunk, encoding, cb), and it'll handle all
	// the drain event emission and buffering.
	
	'use strict';
	
	/*<replacement>*/
	
	var processNextTick = __webpack_require__(23);
	/*</replacement>*/
	
	module.exports = Writable;
	
	/* <replacement> */
	function WriteReq(chunk, encoding, cb) {
	  this.chunk = chunk;
	  this.encoding = encoding;
	  this.callback = cb;
	  this.next = null;
	}
	
	// It seems a linked list but it is not
	// there will be only 2 of these for each stream
	function CorkedRequest(state) {
	  var _this = this;
	
	  this.next = null;
	  this.entry = null;
	  this.finish = function () {
	    onCorkedFinish(_this, state);
	  };
	}
	/* </replacement> */
	
	/*<replacement>*/
	var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : processNextTick;
	/*</replacement>*/
	
	/*<replacement>*/
	var Duplex;
	/*</replacement>*/
	
	Writable.WritableState = WritableState;
	
	/*<replacement>*/
	var util = __webpack_require__(30);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/
	
	/*<replacement>*/
	var internalUtil = {
	  deprecate: __webpack_require__(40)
	};
	/*</replacement>*/
	
	/*<replacement>*/
	var Stream = __webpack_require__(25);
	/*</replacement>*/
	
	/*<replacement>*/
	var Buffer = __webpack_require__(26).Buffer;
	var OurUint8Array = global.Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}
	/*</replacement>*/
	
	var destroyImpl = __webpack_require__(34);
	
	util.inherits(Writable, Stream);
	
	function nop() {}
	
	function WritableState(options, stream) {
	  Duplex = Duplex || __webpack_require__(35);
	
	  options = options || {};
	
	  // object stream flag to indicate whether or not this stream
	  // contains buffers or objects.
	  this.objectMode = !!options.objectMode;
	
	  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;
	
	  // the point at which write() starts returning false
	  // Note: 0 is a valid value, means that we always return false if
	  // the entire buffer is not flushed immediately on write()
	  var hwm = options.highWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
	  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;
	
	  // cast to ints.
	  this.highWaterMark = Math.floor(this.highWaterMark);
	
	  // if _final has been called
	  this.finalCalled = false;
	
	  // drain event flag.
	  this.needDrain = false;
	  // at the start of calling end()
	  this.ending = false;
	  // when end() has been called, and returned
	  this.ended = false;
	  // when 'finish' is emitted
	  this.finished = false;
	
	  // has it been destroyed
	  this.destroyed = false;
	
	  // should we decode strings into buffers before passing to _write?
	  // this is here so that some node-core streams can optimize string
	  // handling at a lower level.
	  var noDecode = options.decodeStrings === false;
	  this.decodeStrings = !noDecode;
	
	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';
	
	  // not an actual buffer we keep track of, but a measurement
	  // of how much we're waiting to get pushed to some underlying
	  // socket or file.
	  this.length = 0;
	
	  // a flag to see when we're in the middle of a write.
	  this.writing = false;
	
	  // when true all writes will be buffered until .uncork() call
	  this.corked = 0;
	
	  // a flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;
	
	  // a flag to know if we're processing previously buffered items, which
	  // may call the _write() callback in the same tick, so that we don't
	  // end up in an overlapped onwrite situation.
	  this.bufferProcessing = false;
	
	  // the callback that's passed to _write(chunk,cb)
	  this.onwrite = function (er) {
	    onwrite(stream, er);
	  };
	
	  // the callback that the user supplies to write(chunk,encoding,cb)
	  this.writecb = null;
	
	  // the amount that is being written when _write is called.
	  this.writelen = 0;
	
	  this.bufferedRequest = null;
	  this.lastBufferedRequest = null;
	
	  // number of pending user-supplied write callbacks
	  // this must be 0 before 'finish' can be emitted
	  this.pendingcb = 0;
	
	  // emit prefinish if the only thing we're waiting for is _write cbs
	  // This is relevant for synchronous Transform streams
	  this.prefinished = false;
	
	  // True if the error was already emitted and should not be thrown again
	  this.errorEmitted = false;
	
	  // count buffered requests
	  this.bufferedRequestCount = 0;
	
	  // allocate the first CorkedRequest, there is always
	  // one allocated and free to use, and we maintain at most two
	  this.corkedRequestsFree = new CorkedRequest(this);
	}
	
	WritableState.prototype.getBuffer = function getBuffer() {
	  var current = this.bufferedRequest;
	  var out = [];
	  while (current) {
	    out.push(current);
	    current = current.next;
	  }
	  return out;
	};
	
	(function () {
	  try {
	    Object.defineProperty(WritableState.prototype, 'buffer', {
	      get: internalUtil.deprecate(function () {
	        return this.getBuffer();
	      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
	    });
	  } catch (_) {}
	})();
	
	// Test _writableState for inheritance to account for Duplex streams,
	// whose prototype chain only points to Readable.
	var realHasInstance;
	if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
	  realHasInstance = Function.prototype[Symbol.hasInstance];
	  Object.defineProperty(Writable, Symbol.hasInstance, {
	    value: function (object) {
	      if (realHasInstance.call(this, object)) return true;
	
	      return object && object._writableState instanceof WritableState;
	    }
	  });
	} else {
	  realHasInstance = function (object) {
	    return object instanceof this;
	  };
	}
	
	function Writable(options) {
	  Duplex = Duplex || __webpack_require__(35);
	
	  // Writable ctor is applied to Duplexes, too.
	  // `realHasInstance` is necessary because using plain `instanceof`
	  // would return false, as no `_writableState` property is attached.
	
	  // Trying to use the custom `instanceof` for Writable here will also break the
	  // Node.js LazyTransform implementation, which has a non-trivial getter for
	  // `_writableState` that would lead to infinite recursion.
	  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
	    return new Writable(options);
	  }
	
	  this._writableState = new WritableState(options, this);
	
	  // legacy.
	  this.writable = true;
	
	  if (options) {
	    if (typeof options.write === 'function') this._write = options.write;
	
	    if (typeof options.writev === 'function') this._writev = options.writev;
	
	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	
	    if (typeof options.final === 'function') this._final = options.final;
	  }
	
	  Stream.call(this);
	}
	
	// Otherwise people can pipe Writable streams, which is just wrong.
	Writable.prototype.pipe = function () {
	  this.emit('error', new Error('Cannot pipe, not readable'));
	};
	
	function writeAfterEnd(stream, cb) {
	  var er = new Error('write after end');
	  // TODO: defer error events consistently everywhere, not just the cb
	  stream.emit('error', er);
	  processNextTick(cb, er);
	}
	
	// Checks that a user-supplied chunk is valid, especially for the particular
	// mode the stream is in. Currently this means that `null` is never accepted
	// and undefined/non-string values are only allowed in object mode.
	function validChunk(stream, state, chunk, cb) {
	  var valid = true;
	  var er = false;
	
	  if (chunk === null) {
	    er = new TypeError('May not write null values to stream');
	  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  if (er) {
	    stream.emit('error', er);
	    processNextTick(cb, er);
	    valid = false;
	  }
	  return valid;
	}
	
	Writable.prototype.write = function (chunk, encoding, cb) {
	  var state = this._writableState;
	  var ret = false;
	  var isBuf = _isUint8Array(chunk) && !state.objectMode;
	
	  if (isBuf && !Buffer.isBuffer(chunk)) {
	    chunk = _uint8ArrayToBuffer(chunk);
	  }
	
	  if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }
	
	  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;
	
	  if (typeof cb !== 'function') cb = nop;
	
	  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
	    state.pendingcb++;
	    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
	  }
	
	  return ret;
	};
	
	Writable.prototype.cork = function () {
	  var state = this._writableState;
	
	  state.corked++;
	};
	
	Writable.prototype.uncork = function () {
	  var state = this._writableState;
	
	  if (state.corked) {
	    state.corked--;
	
	    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
	  }
	};
	
	Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
	  // node::ParseEncoding() requires lower case.
	  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
	  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
	  this._writableState.defaultEncoding = encoding;
	  return this;
	};
	
	function decodeChunk(state, chunk, encoding) {
	  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
	    chunk = Buffer.from(chunk, encoding);
	  }
	  return chunk;
	}
	
	// if we're already writing something, then just put this
	// in the queue, and wait our turn.  Otherwise, call _write
	// If we return false, then we need a drain event, so set that flag.
	function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
	  if (!isBuf) {
	    var newChunk = decodeChunk(state, chunk, encoding);
	    if (chunk !== newChunk) {
	      isBuf = true;
	      encoding = 'buffer';
	      chunk = newChunk;
	    }
	  }
	  var len = state.objectMode ? 1 : chunk.length;
	
	  state.length += len;
	
	  var ret = state.length < state.highWaterMark;
	  // we must ensure that previous needDrain will not be reset to false.
	  if (!ret) state.needDrain = true;
	
	  if (state.writing || state.corked) {
	    var last = state.lastBufferedRequest;
	    state.lastBufferedRequest = {
	      chunk: chunk,
	      encoding: encoding,
	      isBuf: isBuf,
	      callback: cb,
	      next: null
	    };
	    if (last) {
	      last.next = state.lastBufferedRequest;
	    } else {
	      state.bufferedRequest = state.lastBufferedRequest;
	    }
	    state.bufferedRequestCount += 1;
	  } else {
	    doWrite(stream, state, false, len, chunk, encoding, cb);
	  }
	
	  return ret;
	}
	
	function doWrite(stream, state, writev, len, chunk, encoding, cb) {
	  state.writelen = len;
	  state.writecb = cb;
	  state.writing = true;
	  state.sync = true;
	  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
	  state.sync = false;
	}
	
	function onwriteError(stream, state, sync, er, cb) {
	  --state.pendingcb;
	
	  if (sync) {
	    // defer the callback if we are being called synchronously
	    // to avoid piling up things on the stack
	    processNextTick(cb, er);
	    // this can emit finish, and it will always happen
	    // after error
	    processNextTick(finishMaybe, stream, state);
	    stream._writableState.errorEmitted = true;
	    stream.emit('error', er);
	  } else {
	    // the caller expect this to happen before if
	    // it is async
	    cb(er);
	    stream._writableState.errorEmitted = true;
	    stream.emit('error', er);
	    // this can emit finish, but finish must
	    // always follow error
	    finishMaybe(stream, state);
	  }
	}
	
	function onwriteStateUpdate(state) {
	  state.writing = false;
	  state.writecb = null;
	  state.length -= state.writelen;
	  state.writelen = 0;
	}
	
	function onwrite(stream, er) {
	  var state = stream._writableState;
	  var sync = state.sync;
	  var cb = state.writecb;
	
	  onwriteStateUpdate(state);
	
	  if (er) onwriteError(stream, state, sync, er, cb);else {
	    // Check if we're actually ready to finish, but don't emit yet
	    var finished = needFinish(state);
	
	    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
	      clearBuffer(stream, state);
	    }
	
	    if (sync) {
	      /*<replacement>*/
	      asyncWrite(afterWrite, stream, state, finished, cb);
	      /*</replacement>*/
	    } else {
	      afterWrite(stream, state, finished, cb);
	    }
	  }
	}
	
	function afterWrite(stream, state, finished, cb) {
	  if (!finished) onwriteDrain(stream, state);
	  state.pendingcb--;
	  cb();
	  finishMaybe(stream, state);
	}
	
	// Must force callback to be called on nextTick, so that we don't
	// emit 'drain' before the write() consumer gets the 'false' return
	// value, and has a chance to attach a 'drain' listener.
	function onwriteDrain(stream, state) {
	  if (state.length === 0 && state.needDrain) {
	    state.needDrain = false;
	    stream.emit('drain');
	  }
	}
	
	// if there's something in the buffer waiting, then process it
	function clearBuffer(stream, state) {
	  state.bufferProcessing = true;
	  var entry = state.bufferedRequest;
	
	  if (stream._writev && entry && entry.next) {
	    // Fast case, write everything using _writev()
	    var l = state.bufferedRequestCount;
	    var buffer = new Array(l);
	    var holder = state.corkedRequestsFree;
	    holder.entry = entry;
	
	    var count = 0;
	    var allBuffers = true;
	    while (entry) {
	      buffer[count] = entry;
	      if (!entry.isBuf) allBuffers = false;
	      entry = entry.next;
	      count += 1;
	    }
	    buffer.allBuffers = allBuffers;
	
	    doWrite(stream, state, true, state.length, buffer, '', holder.finish);
	
	    // doWrite is almost always async, defer these to save a bit of time
	    // as the hot path ends with doWrite
	    state.pendingcb++;
	    state.lastBufferedRequest = null;
	    if (holder.next) {
	      state.corkedRequestsFree = holder.next;
	      holder.next = null;
	    } else {
	      state.corkedRequestsFree = new CorkedRequest(state);
	    }
	  } else {
	    // Slow case, write chunks one-by-one
	    while (entry) {
	      var chunk = entry.chunk;
	      var encoding = entry.encoding;
	      var cb = entry.callback;
	      var len = state.objectMode ? 1 : chunk.length;
	
	      doWrite(stream, state, false, len, chunk, encoding, cb);
	      entry = entry.next;
	      // if we didn't call the onwrite immediately, then
	      // it means that we need to wait until it does.
	      // also, that means that the chunk and cb are currently
	      // being processed, so move the buffer counter past them.
	      if (state.writing) {
	        break;
	      }
	    }
	
	    if (entry === null) state.lastBufferedRequest = null;
	  }
	
	  state.bufferedRequestCount = 0;
	  state.bufferedRequest = entry;
	  state.bufferProcessing = false;
	}
	
	Writable.prototype._write = function (chunk, encoding, cb) {
	  cb(new Error('_write() is not implemented'));
	};
	
	Writable.prototype._writev = null;
	
	Writable.prototype.end = function (chunk, encoding, cb) {
	  var state = this._writableState;
	
	  if (typeof chunk === 'function') {
	    cb = chunk;
	    chunk = null;
	    encoding = null;
	  } else if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }
	
	  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);
	
	  // .end() fully uncorks
	  if (state.corked) {
	    state.corked = 1;
	    this.uncork();
	  }
	
	  // ignore unnecessary end() calls.
	  if (!state.ending && !state.finished) endWritable(this, state, cb);
	};
	
	function needFinish(state) {
	  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
	}
	function callFinal(stream, state) {
	  stream._final(function (err) {
	    state.pendingcb--;
	    if (err) {
	      stream.emit('error', err);
	    }
	    state.prefinished = true;
	    stream.emit('prefinish');
	    finishMaybe(stream, state);
	  });
	}
	function prefinish(stream, state) {
	  if (!state.prefinished && !state.finalCalled) {
	    if (typeof stream._final === 'function') {
	      state.pendingcb++;
	      state.finalCalled = true;
	      processNextTick(callFinal, stream, state);
	    } else {
	      state.prefinished = true;
	      stream.emit('prefinish');
	    }
	  }
	}
	
	function finishMaybe(stream, state) {
	  var need = needFinish(state);
	  if (need) {
	    prefinish(stream, state);
	    if (state.pendingcb === 0) {
	      state.finished = true;
	      stream.emit('finish');
	    }
	  }
	  return need;
	}
	
	function endWritable(stream, state, cb) {
	  state.ending = true;
	  finishMaybe(stream, state);
	  if (cb) {
	    if (state.finished) processNextTick(cb);else stream.once('finish', cb);
	  }
	  state.ended = true;
	  stream.writable = false;
	}
	
	function onCorkedFinish(corkReq, state, err) {
	  var entry = corkReq.entry;
	  corkReq.entry = null;
	  while (entry) {
	    var cb = entry.callback;
	    state.pendingcb--;
	    cb(err);
	    entry = entry.next;
	  }
	  if (state.corkedRequestsFree) {
	    state.corkedRequestsFree.next = corkReq;
	  } else {
	    state.corkedRequestsFree = corkReq;
	  }
	}
	
	Object.defineProperty(Writable.prototype, 'destroyed', {
	  get: function () {
	    if (this._writableState === undefined) {
	      return false;
	    }
	    return this._writableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._writableState) {
	      return;
	    }
	
	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._writableState.destroyed = value;
	  }
	});
	
	Writable.prototype.destroy = destroyImpl.destroy;
	Writable.prototype._undestroy = destroyImpl.undestroy;
	Writable.prototype._destroy = function (err, cb) {
	  this.end();
	  cb(err);
	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17), __webpack_require__(37).setImmediate, (function() { return this; }())))

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

	var apply = Function.prototype.apply;
	
	// DOM APIs, for completeness
	
	exports.setTimeout = function() {
	  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
	};
	exports.setInterval = function() {
	  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
	};
	exports.clearTimeout =
	exports.clearInterval = function(timeout) {
	  if (timeout) {
	    timeout.close();
	  }
	};
	
	function Timeout(id, clearFn) {
	  this._id = id;
	  this._clearFn = clearFn;
	}
	Timeout.prototype.unref = Timeout.prototype.ref = function() {};
	Timeout.prototype.close = function() {
	  this._clearFn.call(window, this._id);
	};
	
	// Does not start the time, just sets up the members needed.
	exports.enroll = function(item, msecs) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = msecs;
	};
	
	exports.unenroll = function(item) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = -1;
	};
	
	exports._unrefActive = exports.active = function(item) {
	  clearTimeout(item._idleTimeoutId);
	
	  var msecs = item._idleTimeout;
	  if (msecs >= 0) {
	    item._idleTimeoutId = setTimeout(function onTimeout() {
	      if (item._onTimeout)
	        item._onTimeout();
	    }, msecs);
	  }
	};
	
	// setimmediate attaches itself to the global object
	__webpack_require__(38);
	var global = __webpack_require__(39);
	exports.setImmediate = global.setImmediate;
	exports.clearImmediate = global.clearImmediate;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {(function (global, undefined) {
	    "use strict";
	
	    if (global.setImmediate) {
	        return;
	    }
	
	    var nextHandle = 1; // Spec says greater than zero
	    var tasksByHandle = {};
	    var currentlyRunningATask = false;
	    var doc = global.document;
	    var registerImmediate;
	
	    function setImmediate(callback) {
	      // Callback can either be a function or a string
	      if (typeof callback !== "function") {
	        callback = new Function("" + callback);
	      }
	      // Copy function arguments
	      var args = new Array(arguments.length - 1);
	      for (var i = 0; i < args.length; i++) {
	          args[i] = arguments[i + 1];
	      }
	      // Store and register the task
	      var task = { callback: callback, args: args };
	      tasksByHandle[nextHandle] = task;
	      registerImmediate(nextHandle);
	      return nextHandle++;
	    }
	
	    function clearImmediate(handle) {
	        delete tasksByHandle[handle];
	    }
	
	    function run(task) {
	        var callback = task.callback;
	        var args = task.args;
	        switch (args.length) {
	        case 0:
	            callback();
	            break;
	        case 1:
	            callback(args[0]);
	            break;
	        case 2:
	            callback(args[0], args[1]);
	            break;
	        case 3:
	            callback(args[0], args[1], args[2]);
	            break;
	        default:
	            callback.apply(undefined, args);
	            break;
	        }
	    }
	
	    function runIfPresent(handle) {
	        // From the spec: "Wait until any invocations of this algorithm started before this one have completed."
	        // So if we're currently running a task, we'll need to delay this invocation.
	        if (currentlyRunningATask) {
	            // Delay by doing a setTimeout. setImmediate was tried instead, but in Firefox 7 it generated a
	            // "too much recursion" error.
	            setTimeout(runIfPresent, 0, handle);
	        } else {
	            var task = tasksByHandle[handle];
	            if (task) {
	                currentlyRunningATask = true;
	                try {
	                    run(task);
	                } finally {
	                    clearImmediate(handle);
	                    currentlyRunningATask = false;
	                }
	            }
	        }
	    }
	
	    function installNextTickImplementation() {
	        registerImmediate = function(handle) {
	            process.nextTick(function () { runIfPresent(handle); });
	        };
	    }
	
	    function canUsePostMessage() {
	        // The test against `importScripts` prevents this implementation from being installed inside a web worker,
	        // where `global.postMessage` means something completely different and can't be used for this purpose.
	        if (global.postMessage && !global.importScripts) {
	            var postMessageIsAsynchronous = true;
	            var oldOnMessage = global.onmessage;
	            global.onmessage = function() {
	                postMessageIsAsynchronous = false;
	            };
	            global.postMessage("", "*");
	            global.onmessage = oldOnMessage;
	            return postMessageIsAsynchronous;
	        }
	    }
	
	    function installPostMessageImplementation() {
	        // Installs an event handler on `global` for the `message` event: see
	        // * https://developer.mozilla.org/en/DOM/window.postMessage
	        // * http://www.whatwg.org/specs/web-apps/current-work/multipage/comms.html#crossDocumentMessages
	
	        var messagePrefix = "setImmediate$" + Math.random() + "$";
	        var onGlobalMessage = function(event) {
	            if (event.source === global &&
	                typeof event.data === "string" &&
	                event.data.indexOf(messagePrefix) === 0) {
	                runIfPresent(+event.data.slice(messagePrefix.length));
	            }
	        };
	
	        if (global.addEventListener) {
	            global.addEventListener("message", onGlobalMessage, false);
	        } else {
	            global.attachEvent("onmessage", onGlobalMessage);
	        }
	
	        registerImmediate = function(handle) {
	            global.postMessage(messagePrefix + handle, "*");
	        };
	    }
	
	    function installMessageChannelImplementation() {
	        var channel = new MessageChannel();
	        channel.port1.onmessage = function(event) {
	            var handle = event.data;
	            runIfPresent(handle);
	        };
	
	        registerImmediate = function(handle) {
	            channel.port2.postMessage(handle);
	        };
	    }
	
	    function installReadyStateChangeImplementation() {
	        var html = doc.documentElement;
	        registerImmediate = function(handle) {
	            // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
	            // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
	            var script = doc.createElement("script");
	            script.onreadystatechange = function () {
	                runIfPresent(handle);
	                script.onreadystatechange = null;
	                html.removeChild(script);
	                script = null;
	            };
	            html.appendChild(script);
	        };
	    }
	
	    function installSetTimeoutImplementation() {
	        registerImmediate = function(handle) {
	            setTimeout(runIfPresent, 0, handle);
	        };
	    }
	
	    // If supported, we should attach to the prototype of global, since that is where setTimeout et al. live.
	    var attachTo = Object.getPrototypeOf && Object.getPrototypeOf(global);
	    attachTo = attachTo && attachTo.setTimeout ? attachTo : global;
	
	    // Don't get fooled by e.g. browserify environments.
	    if ({}.toString.call(global.process) === "[object process]") {
	        // For Node.js before 0.9
	        installNextTickImplementation();
	
	    } else if (canUsePostMessage()) {
	        // For non-IE10 modern browsers
	        installPostMessageImplementation();
	
	    } else if (global.MessageChannel) {
	        // For web workers, where supported
	        installMessageChannelImplementation();
	
	    } else if (doc && "onreadystatechange" in doc.createElement("script")) {
	        // For IE 6–8
	        installReadyStateChangeImplementation();
	
	    } else {
	        // For older browsers
	        installSetTimeoutImplementation();
	    }
	
	    attachTo.setImmediate = setImmediate;
	    attachTo.clearImmediate = clearImmediate;
	}(typeof self === "undefined" ? typeof global === "undefined" ? this : global : self));
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(17)))

/***/ }),
/* 39 */
/***/ (function(module, exports) {

	/* WEBPACK VAR INJECTION */(function(global) {var win;
	
	if (typeof window !== "undefined") {
	    win = window;
	} else if (typeof global !== "undefined") {
	    win = global;
	} else if (typeof self !== "undefined"){
	    win = self;
	} else {
	    win = {};
	}
	
	module.exports = win;
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 40 */
/***/ (function(module, exports) {

	/* WEBPACK VAR INJECTION */(function(global) {
	/**
	 * Module exports.
	 */
	
	module.exports = deprecate;
	
	/**
	 * Mark that a method should not be used.
	 * Returns a modified function which warns once by default.
	 *
	 * If `localStorage.noDeprecation = true` is set, then it is a no-op.
	 *
	 * If `localStorage.throwDeprecation = true` is set, then deprecated functions
	 * will throw an Error when invoked.
	 *
	 * If `localStorage.traceDeprecation = true` is set, then deprecated functions
	 * will invoke `console.trace()` instead of `console.error()`.
	 *
	 * @param {Function} fn - the function to deprecate
	 * @param {String} msg - the string to print to the console when `fn` is invoked
	 * @returns {Function} a new "deprecated" version of `fn`
	 * @api public
	 */
	
	function deprecate (fn, msg) {
	  if (config('noDeprecation')) {
	    return fn;
	  }
	
	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (config('throwDeprecation')) {
	        throw new Error(msg);
	      } else if (config('traceDeprecation')) {
	        console.trace(msg);
	      } else {
	        console.warn(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }
	
	  return deprecated;
	}
	
	/**
	 * Checks `localStorage` for boolean values for the given `name`.
	 *
	 * @param {String} name
	 * @returns {Boolean}
	 * @api private
	 */
	
	function config (name) {
	  // accessing global.localStorage can trigger a DOMException in sandboxed iframes
	  try {
	    if (!global.localStorage) return false;
	  } catch (_) {
	    return false;
	  }
	  var val = global.localStorage[name];
	  if (null == val) return false;
	  return String(val).toLowerCase() === 'true';
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	var Buffer = __webpack_require__(26).Buffer;
	
	var isEncoding = Buffer.isEncoding || function (encoding) {
	  encoding = '' + encoding;
	  switch (encoding && encoding.toLowerCase()) {
	    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
	      return true;
	    default:
	      return false;
	  }
	};
	
	function _normalizeEncoding(enc) {
	  if (!enc) return 'utf8';
	  var retried;
	  while (true) {
	    switch (enc) {
	      case 'utf8':
	      case 'utf-8':
	        return 'utf8';
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return 'utf16le';
	      case 'latin1':
	      case 'binary':
	        return 'latin1';
	      case 'base64':
	      case 'ascii':
	      case 'hex':
	        return enc;
	      default:
	        if (retried) return; // undefined
	        enc = ('' + enc).toLowerCase();
	        retried = true;
	    }
	  }
	};
	
	// Do not cache `Buffer.isEncoding` when checking encoding names as some
	// modules monkey-patch it to support additional encodings
	function normalizeEncoding(enc) {
	  var nenc = _normalizeEncoding(enc);
	  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
	  return nenc || enc;
	}
	
	// StringDecoder provides an interface for efficiently splitting a series of
	// buffers into a series of JS strings without breaking apart multi-byte
	// characters.
	exports.StringDecoder = StringDecoder;
	function StringDecoder(encoding) {
	  this.encoding = normalizeEncoding(encoding);
	  var nb;
	  switch (this.encoding) {
	    case 'utf16le':
	      this.text = utf16Text;
	      this.end = utf16End;
	      nb = 4;
	      break;
	    case 'utf8':
	      this.fillLast = utf8FillLast;
	      nb = 4;
	      break;
	    case 'base64':
	      this.text = base64Text;
	      this.end = base64End;
	      nb = 3;
	      break;
	    default:
	      this.write = simpleWrite;
	      this.end = simpleEnd;
	      return;
	  }
	  this.lastNeed = 0;
	  this.lastTotal = 0;
	  this.lastChar = Buffer.allocUnsafe(nb);
	}
	
	StringDecoder.prototype.write = function (buf) {
	  if (buf.length === 0) return '';
	  var r;
	  var i;
	  if (this.lastNeed) {
	    r = this.fillLast(buf);
	    if (r === undefined) return '';
	    i = this.lastNeed;
	    this.lastNeed = 0;
	  } else {
	    i = 0;
	  }
	  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
	  return r || '';
	};
	
	StringDecoder.prototype.end = utf8End;
	
	// Returns only complete characters in a Buffer
	StringDecoder.prototype.text = utf8Text;
	
	// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
	StringDecoder.prototype.fillLast = function (buf) {
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
	  this.lastNeed -= buf.length;
	};
	
	// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
	// continuation byte.
	function utf8CheckByte(byte) {
	  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
	  return -1;
	}
	
	// Checks at most 3 bytes at the end of a Buffer in order to detect an
	// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
	// needed to complete the UTF-8 character (if applicable) are returned.
	function utf8CheckIncomplete(self, buf, i) {
	  var j = buf.length - 1;
	  if (j < i) return 0;
	  var nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 1;
	    return nb;
	  }
	  if (--j < i) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 2;
	    return nb;
	  }
	  if (--j < i) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) {
	      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
	    }
	    return nb;
	  }
	  return 0;
	}
	
	// Validates as many continuation bytes for a multi-byte UTF-8 character as
	// needed or are available. If we see a non-continuation byte where we expect
	// one, we "replace" the validated continuation bytes we've seen so far with
	// UTF-8 replacement characters ('\ufffd'), to match v8's UTF-8 decoding
	// behavior. The continuation byte check is included three times in the case
	// where all of the continuation bytes for a character exist in the same buffer.
	// It is also done this way as a slight performance increase instead of using a
	// loop.
	function utf8CheckExtraBytes(self, buf, p) {
	  if ((buf[0] & 0xC0) !== 0x80) {
	    self.lastNeed = 0;
	    return '\ufffd'.repeat(p);
	  }
	  if (self.lastNeed > 1 && buf.length > 1) {
	    if ((buf[1] & 0xC0) !== 0x80) {
	      self.lastNeed = 1;
	      return '\ufffd'.repeat(p + 1);
	    }
	    if (self.lastNeed > 2 && buf.length > 2) {
	      if ((buf[2] & 0xC0) !== 0x80) {
	        self.lastNeed = 2;
	        return '\ufffd'.repeat(p + 2);
	      }
	    }
	  }
	}
	
	// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
	function utf8FillLast(buf) {
	  var p = this.lastTotal - this.lastNeed;
	  var r = utf8CheckExtraBytes(this, buf, p);
	  if (r !== undefined) return r;
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, p, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, p, 0, buf.length);
	  this.lastNeed -= buf.length;
	}
	
	// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
	// partial character, the character's bytes are buffered until the required
	// number of bytes are available.
	function utf8Text(buf, i) {
	  var total = utf8CheckIncomplete(this, buf, i);
	  if (!this.lastNeed) return buf.toString('utf8', i);
	  this.lastTotal = total;
	  var end = buf.length - (total - this.lastNeed);
	  buf.copy(this.lastChar, 0, end);
	  return buf.toString('utf8', i, end);
	}
	
	// For UTF-8, a replacement character for each buffered byte of a (partial)
	// character needs to be added to the output.
	function utf8End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + '\ufffd'.repeat(this.lastTotal - this.lastNeed);
	  return r;
	}
	
	// UTF-16LE typically needs two bytes per character, but even if we have an even
	// number of bytes available, we need to check if we end on a leading/high
	// surrogate. In that case, we need to wait for the next two bytes in order to
	// decode the last character properly.
	function utf16Text(buf, i) {
	  if ((buf.length - i) % 2 === 0) {
	    var r = buf.toString('utf16le', i);
	    if (r) {
	      var c = r.charCodeAt(r.length - 1);
	      if (c >= 0xD800 && c <= 0xDBFF) {
	        this.lastNeed = 2;
	        this.lastTotal = 4;
	        this.lastChar[0] = buf[buf.length - 2];
	        this.lastChar[1] = buf[buf.length - 1];
	        return r.slice(0, -1);
	      }
	    }
	    return r;
	  }
	  this.lastNeed = 1;
	  this.lastTotal = 2;
	  this.lastChar[0] = buf[buf.length - 1];
	  return buf.toString('utf16le', i, buf.length - 1);
	}
	
	// For UTF-16LE we do not explicitly append special replacement characters if we
	// end on a partial character, we simply let v8 handle that.
	function utf16End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) {
	    var end = this.lastTotal - this.lastNeed;
	    return r + this.lastChar.toString('utf16le', 0, end);
	  }
	  return r;
	}
	
	function base64Text(buf, i) {
	  var n = (buf.length - i) % 3;
	  if (n === 0) return buf.toString('base64', i);
	  this.lastNeed = 3 - n;
	  this.lastTotal = 3;
	  if (n === 1) {
	    this.lastChar[0] = buf[buf.length - 1];
	  } else {
	    this.lastChar[0] = buf[buf.length - 2];
	    this.lastChar[1] = buf[buf.length - 1];
	  }
	  return buf.toString('base64', i, buf.length - n);
	}
	
	function base64End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
	  return r;
	}
	
	// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
	function simpleWrite(buf) {
	  return buf.toString(this.encoding);
	}
	
	function simpleEnd(buf) {
	  return buf && buf.length ? this.write(buf) : '';
	}

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	// a transform stream is a readable/writable stream where you do
	// something with the data.  Sometimes it's called a "filter",
	// but that's not a great name for it, since that implies a thing where
	// some bits pass through, and others are simply ignored.  (That would
	// be a valid example of a transform, of course.)
	//
	// While the output is causally related to the input, it's not a
	// necessarily symmetric or synchronous transformation.  For example,
	// a zlib stream might take multiple plain-text writes(), and then
	// emit a single compressed chunk some time in the future.
	//
	// Here's how this works:
	//
	// The Transform stream has all the aspects of the readable and writable
	// stream classes.  When you write(chunk), that calls _write(chunk,cb)
	// internally, and returns false if there's a lot of pending writes
	// buffered up.  When you call read(), that calls _read(n) until
	// there's enough pending readable data buffered up.
	//
	// In a transform stream, the written data is placed in a buffer.  When
	// _read(n) is called, it transforms the queued up data, calling the
	// buffered _write cb's as it consumes chunks.  If consuming a single
	// written chunk would result in multiple output chunks, then the first
	// outputted bit calls the readcb, and subsequent chunks just go into
	// the read buffer, and will cause it to emit 'readable' if necessary.
	//
	// This way, back-pressure is actually determined by the reading side,
	// since _read has to be called to start processing a new chunk.  However,
	// a pathological inflate type of transform can cause excessive buffering
	// here.  For example, imagine a stream where every byte of input is
	// interpreted as an integer from 0-255, and then results in that many
	// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
	// 1kb of data being output.  In this case, you could write a very small
	// amount of input, and end up with a very large amount of output.  In
	// such a pathological inflating mechanism, there'd be no way to tell
	// the system to stop doing the transform.  A single 4MB write could
	// cause the system to run out of memory.
	//
	// However, even in such a pathological case, only a single written chunk
	// would be consumed, and then the rest would wait (un-transformed) until
	// the results of the previous transformed chunk were consumed.
	
	'use strict';
	
	module.exports = Transform;
	
	var Duplex = __webpack_require__(35);
	
	/*<replacement>*/
	var util = __webpack_require__(30);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/
	
	util.inherits(Transform, Duplex);
	
	function TransformState(stream) {
	  this.afterTransform = function (er, data) {
	    return afterTransform(stream, er, data);
	  };
	
	  this.needTransform = false;
	  this.transforming = false;
	  this.writecb = null;
	  this.writechunk = null;
	  this.writeencoding = null;
	}
	
	function afterTransform(stream, er, data) {
	  var ts = stream._transformState;
	  ts.transforming = false;
	
	  var cb = ts.writecb;
	
	  if (!cb) {
	    return stream.emit('error', new Error('write callback called multiple times'));
	  }
	
	  ts.writechunk = null;
	  ts.writecb = null;
	
	  if (data !== null && data !== undefined) stream.push(data);
	
	  cb(er);
	
	  var rs = stream._readableState;
	  rs.reading = false;
	  if (rs.needReadable || rs.length < rs.highWaterMark) {
	    stream._read(rs.highWaterMark);
	  }
	}
	
	function Transform(options) {
	  if (!(this instanceof Transform)) return new Transform(options);
	
	  Duplex.call(this, options);
	
	  this._transformState = new TransformState(this);
	
	  var stream = this;
	
	  // start out asking for a readable event once data is transformed.
	  this._readableState.needReadable = true;
	
	  // we have implemented the _read method, and done the other things
	  // that Readable wants before the first _read call, so unset the
	  // sync guard flag.
	  this._readableState.sync = false;
	
	  if (options) {
	    if (typeof options.transform === 'function') this._transform = options.transform;
	
	    if (typeof options.flush === 'function') this._flush = options.flush;
	  }
	
	  // When the writable side finishes, then flush out anything remaining.
	  this.once('prefinish', function () {
	    if (typeof this._flush === 'function') this._flush(function (er, data) {
	      done(stream, er, data);
	    });else done(stream);
	  });
	}
	
	Transform.prototype.push = function (chunk, encoding) {
	  this._transformState.needTransform = false;
	  return Duplex.prototype.push.call(this, chunk, encoding);
	};
	
	// This is the part where you do stuff!
	// override this function in implementation classes.
	// 'chunk' is an input chunk.
	//
	// Call `push(newChunk)` to pass along transformed output
	// to the readable side.  You may call 'push' zero or more times.
	//
	// Call `cb(err)` when you are done with this chunk.  If you pass
	// an error, then that'll put the hurt on the whole operation.  If you
	// never call cb(), then you'll never get another chunk.
	Transform.prototype._transform = function (chunk, encoding, cb) {
	  throw new Error('_transform() is not implemented');
	};
	
	Transform.prototype._write = function (chunk, encoding, cb) {
	  var ts = this._transformState;
	  ts.writecb = cb;
	  ts.writechunk = chunk;
	  ts.writeencoding = encoding;
	  if (!ts.transforming) {
	    var rs = this._readableState;
	    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
	  }
	};
	
	// Doesn't matter what the args are here.
	// _transform does all the work.
	// That we got here means that the readable side wants more data.
	Transform.prototype._read = function (n) {
	  var ts = this._transformState;
	
	  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
	    ts.transforming = true;
	    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
	  } else {
	    // mark that we need a transform, so that any data that comes in
	    // will get processed, now that we've asked for it.
	    ts.needTransform = true;
	  }
	};
	
	Transform.prototype._destroy = function (err, cb) {
	  var _this = this;
	
	  Duplex.prototype._destroy.call(this, err, function (err2) {
	    cb(err2);
	    _this.emit('close');
	  });
	};
	
	function done(stream, er, data) {
	  if (er) return stream.emit('error', er);
	
	  if (data !== null && data !== undefined) stream.push(data);
	
	  // if there's nothing in the write buffer, then that means
	  // that nothing more will ever be provided
	  var ws = stream._writableState;
	  var ts = stream._transformState;
	
	  if (ws.length) throw new Error('Calling transform done when ws.length != 0');
	
	  if (ts.transforming) throw new Error('Calling transform done when still transforming');
	
	  return stream.push(null);
	}

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	// a passthrough stream.
	// basically just the most minimal sort of Transform stream.
	// Every written chunk gets output as-is.
	
	'use strict';
	
	module.exports = PassThrough;
	
	var Transform = __webpack_require__(42);
	
	/*<replacement>*/
	var util = __webpack_require__(30);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/
	
	util.inherits(PassThrough, Transform);
	
	function PassThrough(options) {
	  if (!(this instanceof PassThrough)) return new PassThrough(options);
	
	  Transform.call(this, options);
	}
	
	PassThrough.prototype._transform = function (chunk, encoding, cb) {
	  cb(null, chunk);
	};

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

	var once = __webpack_require__(45);
	
	var noop = function() {};
	
	var isRequest = function(stream) {
		return stream.setHeader && typeof stream.abort === 'function';
	};
	
	var isChildProcess = function(stream) {
		return stream.stdio && Array.isArray(stream.stdio) && stream.stdio.length === 3
	};
	
	var eos = function(stream, opts, callback) {
		if (typeof opts === 'function') return eos(stream, null, opts);
		if (!opts) opts = {};
	
		callback = once(callback || noop);
	
		var ws = stream._writableState;
		var rs = stream._readableState;
		var readable = opts.readable || (opts.readable !== false && stream.readable);
		var writable = opts.writable || (opts.writable !== false && stream.writable);
	
		var onlegacyfinish = function() {
			if (!stream.writable) onfinish();
		};
	
		var onfinish = function() {
			writable = false;
			if (!readable) callback.call(stream);
		};
	
		var onend = function() {
			readable = false;
			if (!writable) callback.call(stream);
		};
	
		var onexit = function(exitCode) {
			callback.call(stream, exitCode ? new Error('exited with error code: ' + exitCode) : null);
		};
	
		var onclose = function() {
			if (readable && !(rs && rs.ended)) return callback.call(stream, new Error('premature close'));
			if (writable && !(ws && ws.ended)) return callback.call(stream, new Error('premature close'));
		};
	
		var onrequest = function() {
			stream.req.on('finish', onfinish);
		};
	
		if (isRequest(stream)) {
			stream.on('complete', onfinish);
			stream.on('abort', onclose);
			if (stream.req) onrequest();
			else stream.on('request', onrequest);
		} else if (writable && !ws) { // legacy streams
			stream.on('end', onlegacyfinish);
			stream.on('close', onlegacyfinish);
		}
	
		if (isChildProcess(stream)) stream.on('exit', onexit);
	
		stream.on('end', onend);
		stream.on('finish', onfinish);
		if (opts.error !== false) stream.on('error', callback);
		stream.on('close', onclose);
	
		return function() {
			stream.removeListener('complete', onfinish);
			stream.removeListener('abort', onclose);
			stream.removeListener('request', onrequest);
			if (stream.req) stream.req.removeListener('finish', onfinish);
			stream.removeListener('end', onlegacyfinish);
			stream.removeListener('close', onlegacyfinish);
			stream.removeListener('finish', onfinish);
			stream.removeListener('exit', onexit);
			stream.removeListener('end', onend);
			stream.removeListener('error', callback);
			stream.removeListener('close', onclose);
		};
	};
	
	module.exports = eos;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

	var wrappy = __webpack_require__(46)
	module.exports = wrappy(once)
	module.exports.strict = wrappy(onceStrict)
	
	once.proto = once(function () {
	  Object.defineProperty(Function.prototype, 'once', {
	    value: function () {
	      return once(this)
	    },
	    configurable: true
	  })
	
	  Object.defineProperty(Function.prototype, 'onceStrict', {
	    value: function () {
	      return onceStrict(this)
	    },
	    configurable: true
	  })
	})
	
	function once (fn) {
	  var f = function () {
	    if (f.called) return f.value
	    f.called = true
	    return f.value = fn.apply(this, arguments)
	  }
	  f.called = false
	  return f
	}
	
	function onceStrict (fn) {
	  var f = function () {
	    if (f.called)
	      throw new Error(f.onceError)
	    f.called = true
	    return f.value = fn.apply(this, arguments)
	  }
	  var name = fn.name || 'Function wrapped with `once`'
	  f.onceError = name + " shouldn't be called more than once"
	  f.called = false
	  return f
	}


/***/ }),
/* 46 */
/***/ (function(module, exports) {

	// Returns a wrapper function that returns a wrapped callback
	// The wrapper function should do some stuff, and return a
	// presumably different callback function.
	// This makes sure that own properties are retained, so that
	// decorations and such are not lost along the way.
	module.exports = wrappy
	function wrappy (fn, cb) {
	  if (fn && cb) return wrappy(fn)(cb)
	
	  if (typeof fn !== 'function')
	    throw new TypeError('need wrapper function')
	
	  Object.keys(fn).forEach(function (k) {
	    wrapper[k] = fn[k]
	  })
	
	  return wrapper
	
	  function wrapper() {
	    var args = new Array(arguments.length)
	    for (var i = 0; i < args.length; i++) {
	      args[i] = arguments[i]
	    }
	    var ret = fn.apply(this, args)
	    var cb = args[args.length-1]
	    if (typeof ret === 'function' && ret !== cb) {
	      Object.keys(cb).forEach(function (k) {
	        ret[k] = cb[k]
	      })
	    }
	    return ret
	  }
	}


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	exports.parser = __webpack_require__(48)
	exports.generate = __webpack_require__(56)
	exports.writeToStream = __webpack_require__(57)


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	var bl = __webpack_require__(49)
	var inherits = __webpack_require__(31)
	var EE = __webpack_require__(19).EventEmitter
	var Packet = __webpack_require__(54)
	var constants = __webpack_require__(55)
	
	function Parser () {
	  if (!(this instanceof Parser)) return new Parser()
	
	  this._states = [
	    '_parseHeader',
	    '_parseLength',
	    '_parsePayload',
	    '_newPacket'
	  ]
	
	  this._resetState()
	}
	
	inherits(Parser, EE)
	
	Parser.prototype._resetState = function () {
	  this.packet = new Packet()
	  this.error = null
	  this._list = bl()
	  this._stateCounter = 0
	}
	
	Parser.prototype.parse = function (buf) {
	  if (this.error) this._resetState()
	
	  this._list.append(buf)
	
	  while ((this.packet.length !== -1 || this._list.length > 0) &&
	         this[this._states[this._stateCounter]]() &&
	         !this.error) {
	    this._stateCounter++
	
	    if (this._stateCounter >= this._states.length) this._stateCounter = 0
	  }
	
	  return this._list.length
	}
	
	Parser.prototype._parseHeader = function () {
	  // There is at least one byte in the buffer
	  var zero = this._list.readUInt8(0)
	  this.packet.cmd = constants.types[zero >> constants.CMD_SHIFT]
	  this.packet.retain = (zero & constants.RETAIN_MASK) !== 0
	  this.packet.qos = (zero >> constants.QOS_SHIFT) & constants.QOS_MASK
	  this.packet.dup = (zero & constants.DUP_MASK) !== 0
	
	  this._list.consume(1)
	
	  return true
	}
	
	Parser.prototype._parseLength = function () {
	  // There is at least one byte in the list
	  var bytes = 0
	  var mul = 1
	  var length = 0
	  var result = true
	  var current
	
	  while (bytes < 5) {
	    current = this._list.readUInt8(bytes++)
	    length += mul * (current & constants.LENGTH_MASK)
	    mul *= 0x80
	
	    if ((current & constants.LENGTH_FIN_MASK) === 0) break
	    if (this._list.length <= bytes) {
	      result = false
	      break
	    }
	  }
	
	  if (result) {
	    this.packet.length = length
	    this._list.consume(bytes)
	  }
	
	  return result
	}
	
	Parser.prototype._parsePayload = function () {
	  var result = false
	
	  // Do we have a payload? Do we have enough data to complete the payload?
	  // PINGs have no payload
	  if (this.packet.length === 0 || this._list.length >= this.packet.length) {
	    this._pos = 0
	
	    switch (this.packet.cmd) {
	      case 'connect':
	        this._parseConnect()
	        break
	      case 'connack':
	        this._parseConnack()
	        break
	      case 'publish':
	        this._parsePublish()
	        break
	      case 'puback':
	      case 'pubrec':
	      case 'pubrel':
	      case 'pubcomp':
	        this._parseMessageId()
	        break
	      case 'subscribe':
	        this._parseSubscribe()
	        break
	      case 'suback':
	        this._parseSuback()
	        break
	      case 'unsubscribe':
	        this._parseUnsubscribe()
	        break
	      case 'unsuback':
	        this._parseUnsuback()
	        break
	      case 'pingreq':
	      case 'pingresp':
	      case 'disconnect':
	        // These are empty, nothing to do
	        break
	      default:
	        this._emitError(new Error('Not supported'))
	    }
	
	    result = true
	  }
	
	  return result
	}
	
	Parser.prototype._parseConnect = function () {
	  var protocolId // Protocol ID
	  var clientId // Client ID
	  var topic // Will topic
	  var payload // Will payload
	  var password // Password
	  var username // Username
	  var flags = {}
	  var packet = this.packet
	
	  // Parse protocolId
	  protocolId = this._parseString()
	
	  if (protocolId === null) return this._emitError(new Error('Cannot parse protocolId'))
	  if (protocolId !== 'MQTT' && protocolId !== 'MQIsdp') {
	    return this._emitError(new Error('Invalid protocolId'))
	  }
	
	  packet.protocolId = protocolId
	
	  // Parse constants version number
	  if (this._pos >= this._list.length) return this._emitError(new Error('Packet too short'))
	
	  packet.protocolVersion = this._list.readUInt8(this._pos)
	
	  if (packet.protocolVersion !== 3 && packet.protocolVersion !== 4) {
	    return this._emitError(new Error('Invalid protocol version'))
	  }
	
	  this._pos++
	
	  if (this._pos >= this._list.length) {
	    return this._emitError(new Error('Packet too short'))
	  }
	
	  // Parse connect flags
	  flags.username = (this._list.readUInt8(this._pos) & constants.USERNAME_MASK)
	  flags.password = (this._list.readUInt8(this._pos) & constants.PASSWORD_MASK)
	  flags.will = (this._list.readUInt8(this._pos) & constants.WILL_FLAG_MASK)
	
	  if (flags.will) {
	    packet.will = {}
	    packet.will.retain = (this._list.readUInt8(this._pos) & constants.WILL_RETAIN_MASK) !== 0
	    packet.will.qos = (this._list.readUInt8(this._pos) &
	                          constants.WILL_QOS_MASK) >> constants.WILL_QOS_SHIFT
	  }
	
	  packet.clean = (this._list.readUInt8(this._pos) & constants.CLEAN_SESSION_MASK) !== 0
	  this._pos++
	
	  // Parse keepalive
	  packet.keepalive = this._parseNum()
	  if (packet.keepalive === -1) return this._emitError(new Error('Packet too short'))
	
	  // Parse clientId
	  clientId = this._parseString()
	  if (clientId === null) return this._emitError(new Error('Packet too short'))
	  packet.clientId = clientId
	
	  if (flags.will) {
	    // Parse will topic
	    topic = this._parseString()
	    if (topic === null) return this._emitError(new Error('Cannot parse will topic'))
	    packet.will.topic = topic
	
	    // Parse will payload
	    payload = this._parseBuffer()
	    if (payload === null) return this._emitError(new Error('Cannot parse will payload'))
	    packet.will.payload = payload
	  }
	
	  // Parse username
	  if (flags.username) {
	    username = this._parseString()
	    if (username === null) return this._emitError(new Error('Cannot parse username'))
	    packet.username = username
	  }
	
	  // Parse password
	  if (flags.password) {
	    password = this._parseBuffer()
	    if (password === null) return this._emitError(new Error('Cannot parse password'))
	    packet.password = password
	  }
	
	  return packet
	}
	
	Parser.prototype._parseConnack = function () {
	  var packet = this.packet
	
	  if (this._list.length < 2) return null
	
	  packet.sessionPresent = !!(this._list.readUInt8(this._pos++) & constants.SESSIONPRESENT_MASK)
	  packet.returnCode = this._list.readUInt8(this._pos)
	
	  if (packet.returnCode === -1) return this._emitError(new Error('Cannot parse return code'))
	}
	
	Parser.prototype._parsePublish = function () {
	  var packet = this.packet
	  packet.topic = this._parseString()
	
	  if (packet.topic === null) return this._emitError(new Error('Cannot parse topic'))
	
	  // Parse messageId
	  if (packet.qos > 0) if (!this._parseMessageId()) { return }
	
	  packet.payload = this._list.slice(this._pos, packet.length)
	}
	
	Parser.prototype._parseSubscribe = function () {
	  var packet = this.packet
	  var topic
	  var qos
	
	  if (packet.qos !== 1) {
	    return this._emitError(new Error('Wrong subscribe header'))
	  }
	
	  packet.subscriptions = []
	
	  if (!this._parseMessageId()) { return }
	
	  while (this._pos < packet.length) {
	    // Parse topic
	    topic = this._parseString()
	    if (topic === null) return this._emitError(new Error('Cannot parse topic'))
	
	    qos = this._list.readUInt8(this._pos++)
	
	    // Push pair to subscriptions
	    packet.subscriptions.push({ topic: topic, qos: qos })
	  }
	}
	
	Parser.prototype._parseSuback = function () {
	  this.packet.granted = []
	
	  if (!this._parseMessageId()) { return }
	
	  // Parse granted QoSes
	  while (this._pos < this.packet.length) {
	    this.packet.granted.push(this._list.readUInt8(this._pos++))
	  }
	}
	
	Parser.prototype._parseUnsubscribe = function () {
	  var packet = this.packet
	
	  packet.unsubscriptions = []
	
	  // Parse messageId
	  if (!this._parseMessageId()) { return }
	
	  while (this._pos < packet.length) {
	    var topic
	
	    // Parse topic
	    topic = this._parseString()
	    if (topic === null) return this._emitError(new Error('Cannot parse topic'))
	
	    // Push topic to unsubscriptions
	    packet.unsubscriptions.push(topic)
	  }
	}
	
	Parser.prototype._parseUnsuback = function () {
	  if (!this._parseMessageId()) return this._emitError(new Error('Cannot parse messageId'))
	}
	
	Parser.prototype._parseMessageId = function () {
	  var packet = this.packet
	
	  packet.messageId = this._parseNum()
	
	  if (packet.messageId === null) {
	    this._emitError(new Error('Cannot parse messageId'))
	    return false
	  }
	
	  return true
	}
	
	Parser.prototype._parseString = function (maybeBuffer) {
	  var length = this._parseNum()
	  var result
	  var end = length + this._pos
	
	  if (length === -1 || end > this._list.length || end > this.packet.length) return null
	
	  result = this._list.toString('utf8', this._pos, end)
	  this._pos += length
	
	  return result
	}
	
	Parser.prototype._parseBuffer = function () {
	  var length = this._parseNum()
	  var result
	  var end = length + this._pos
	
	  if (length === -1 || end > this._list.length || end > this.packet.length) return null
	
	  result = this._list.slice(this._pos, end)
	
	  this._pos += length
	
	  return result
	}
	
	Parser.prototype._parseNum = function () {
	  if (this._list.length - this._pos < 2) return -1
	
	  var result = this._list.readUInt16BE(this._pos)
	  this._pos += 2
	
	  return result
	}
	
	Parser.prototype._newPacket = function () {
	  if (this.packet) {
	    this._list.consume(this.packet.length)
	    this.emit('packet', this.packet)
	  }
	
	  this.packet = new Packet()
	
	  return true
	}
	
	Parser.prototype._emitError = function (err) {
	  this.error = err
	  this.emit('error', err)
	}
	
	module.exports = Parser


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {var DuplexStream = __webpack_require__(50)
	  , util         = __webpack_require__(51)
	
	
	function BufferList (callback) {
	  if (!(this instanceof BufferList))
	    return new BufferList(callback)
	
	  this._bufs  = []
	  this.length = 0
	
	  if (typeof callback == 'function') {
	    this._callback = callback
	
	    var piper = function piper (err) {
	      if (this._callback) {
	        this._callback(err)
	        this._callback = null
	      }
	    }.bind(this)
	
	    this.on('pipe', function onPipe (src) {
	      src.on('error', piper)
	    })
	    this.on('unpipe', function onUnpipe (src) {
	      src.removeListener('error', piper)
	    })
	  } else {
	    this.append(callback)
	  }
	
	  DuplexStream.call(this)
	}
	
	
	util.inherits(BufferList, DuplexStream)
	
	
	BufferList.prototype._offset = function _offset (offset) {
	  var tot = 0, i = 0, _t
	  if (offset === 0) return [ 0, 0 ]
	  for (; i < this._bufs.length; i++) {
	    _t = tot + this._bufs[i].length
	    if (offset < _t || i == this._bufs.length - 1)
	      return [ i, offset - tot ]
	    tot = _t
	  }
	}
	
	
	BufferList.prototype.append = function append (buf) {
	  var i = 0
	
	  if (Buffer.isBuffer(buf)) {
	    this._appendBuffer(buf);
	  } else if (Array.isArray(buf)) {
	    for (; i < buf.length; i++)
	      this.append(buf[i])
	  } else if (buf instanceof BufferList) {
	    // unwrap argument into individual BufferLists
	    for (; i < buf._bufs.length; i++)
	      this.append(buf._bufs[i])
	  } else if (buf != null) {
	    // coerce number arguments to strings, since Buffer(number) does
	    // uninitialized memory allocation
	    if (typeof buf == 'number')
	      buf = buf.toString()
	
	    this._appendBuffer(new Buffer(buf));
	  }
	
	  return this
	}
	
	
	BufferList.prototype._appendBuffer = function appendBuffer (buf) {
	  this._bufs.push(buf)
	  this.length += buf.length
	}
	
	
	BufferList.prototype._write = function _write (buf, encoding, callback) {
	  this._appendBuffer(buf)
	
	  if (typeof callback == 'function')
	    callback()
	}
	
	
	BufferList.prototype._read = function _read (size) {
	  if (!this.length)
	    return this.push(null)
	
	  size = Math.min(size, this.length)
	  this.push(this.slice(0, size))
	  this.consume(size)
	}
	
	
	BufferList.prototype.end = function end (chunk) {
	  DuplexStream.prototype.end.call(this, chunk)
	
	  if (this._callback) {
	    this._callback(null, this.slice())
	    this._callback = null
	  }
	}
	
	
	BufferList.prototype.get = function get (index) {
	  return this.slice(index, index + 1)[0]
	}
	
	
	BufferList.prototype.slice = function slice (start, end) {
	  if (typeof start == 'number' && start < 0)
	    start += this.length
	  if (typeof end == 'number' && end < 0)
	    end += this.length
	  return this.copy(null, 0, start, end)
	}
	
	
	BufferList.prototype.copy = function copy (dst, dstStart, srcStart, srcEnd) {
	  if (typeof srcStart != 'number' || srcStart < 0)
	    srcStart = 0
	  if (typeof srcEnd != 'number' || srcEnd > this.length)
	    srcEnd = this.length
	  if (srcStart >= this.length)
	    return dst || new Buffer(0)
	  if (srcEnd <= 0)
	    return dst || new Buffer(0)
	
	  var copy   = !!dst
	    , off    = this._offset(srcStart)
	    , len    = srcEnd - srcStart
	    , bytes  = len
	    , bufoff = (copy && dstStart) || 0
	    , start  = off[1]
	    , l
	    , i
	
	  // copy/slice everything
	  if (srcStart === 0 && srcEnd == this.length) {
	    if (!copy) { // slice, but full concat if multiple buffers
	      return this._bufs.length === 1
	        ? this._bufs[0]
	        : Buffer.concat(this._bufs, this.length)
	    }
	
	    // copy, need to copy individual buffers
	    for (i = 0; i < this._bufs.length; i++) {
	      this._bufs[i].copy(dst, bufoff)
	      bufoff += this._bufs[i].length
	    }
	
	    return dst
	  }
	
	  // easy, cheap case where it's a subset of one of the buffers
	  if (bytes <= this._bufs[off[0]].length - start) {
	    return copy
	      ? this._bufs[off[0]].copy(dst, dstStart, start, start + bytes)
	      : this._bufs[off[0]].slice(start, start + bytes)
	  }
	
	  if (!copy) // a slice, we need something to copy in to
	    dst = new Buffer(len)
	
	  for (i = off[0]; i < this._bufs.length; i++) {
	    l = this._bufs[i].length - start
	
	    if (bytes > l) {
	      this._bufs[i].copy(dst, bufoff, start)
	    } else {
	      this._bufs[i].copy(dst, bufoff, start, start + bytes)
	      break
	    }
	
	    bufoff += l
	    bytes -= l
	
	    if (start)
	      start = 0
	  }
	
	  return dst
	}
	
	BufferList.prototype.shallowSlice = function shallowSlice (start, end) {
	  start = start || 0
	  end = end || this.length
	
	  if (start < 0)
	    start += this.length
	  if (end < 0)
	    end += this.length
	
	  var startOffset = this._offset(start)
	    , endOffset = this._offset(end)
	    , buffers = this._bufs.slice(startOffset[0], endOffset[0] + 1)
	
	  if (endOffset[1] == 0)
	    buffers.pop()
	  else
	    buffers[buffers.length-1] = buffers[buffers.length-1].slice(0, endOffset[1])
	
	  if (startOffset[1] != 0)
	    buffers[0] = buffers[0].slice(startOffset[1])
	
	  return new BufferList(buffers)
	}
	
	BufferList.prototype.toString = function toString (encoding, start, end) {
	  return this.slice(start, end).toString(encoding)
	}
	
	BufferList.prototype.consume = function consume (bytes) {
	  while (this._bufs.length) {
	    if (bytes >= this._bufs[0].length) {
	      bytes -= this._bufs[0].length
	      this.length -= this._bufs[0].length
	      this._bufs.shift()
	    } else {
	      this._bufs[0] = this._bufs[0].slice(bytes)
	      this.length -= bytes
	      break
	    }
	  }
	  return this
	}
	
	
	BufferList.prototype.duplicate = function duplicate () {
	  var i = 0
	    , copy = new BufferList()
	
	  for (; i < this._bufs.length; i++)
	    copy.append(this._bufs[i])
	
	  return copy
	}
	
	
	BufferList.prototype.destroy = function destroy () {
	  this._bufs.length = 0
	  this.length = 0
	  this.push(null)
	}
	
	
	;(function () {
	  var methods = {
	      'readDoubleBE' : 8
	    , 'readDoubleLE' : 8
	    , 'readFloatBE'  : 4
	    , 'readFloatLE'  : 4
	    , 'readInt32BE'  : 4
	    , 'readInt32LE'  : 4
	    , 'readUInt32BE' : 4
	    , 'readUInt32LE' : 4
	    , 'readInt16BE'  : 2
	    , 'readInt16LE'  : 2
	    , 'readUInt16BE' : 2
	    , 'readUInt16LE' : 2
	    , 'readInt8'     : 1
	    , 'readUInt8'    : 1
	  }
	
	  for (var m in methods) {
	    (function (m) {
	      BufferList.prototype[m] = function (offset) {
	        return this.slice(offset, offset + methods[m])[m](0)
	      }
	    }(m))
	  }
	}())
	
	
	module.exports = BufferList
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(27).Buffer))

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(35);


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	var formatRegExp = /%[sdj%]/g;
	exports.format = function(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }
	
	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	};
	
	
	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	exports.deprecate = function(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global.process)) {
	    return function() {
	      return exports.deprecate(fn, msg).apply(this, arguments);
	    };
	  }
	
	  if (process.noDeprecation === true) {
	    return fn;
	  }
	
	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }
	
	  return deprecated;
	};
	
	
	var debugs = {};
	var debugEnviron;
	exports.debuglog = function(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = process.pid;
	      debugs[set] = function() {
	        var msg = exports.format.apply(exports, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	};
	
	
	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    exports._extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}
	exports.inspect = inspect;
	
	
	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};
	
	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};
	
	
	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];
	
	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}
	
	
	function stylizeNoColor(str, styleType) {
	  return str;
	}
	
	
	function arrayToHash(array) {
	  var hash = {};
	
	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });
	
	  return hash;
	}
	
	
	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== exports.inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }
	
	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }
	
	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);
	
	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }
	
	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }
	
	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }
	
	  var base = '', array = false, braces = ['{', '}'];
	
	  // Make Array say that they are Array
	  if (isArray(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }
	
	  // Make functions say that they are functions
	  if (isFunction(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }
	
	  // Make RegExps say that they are RegExps
	  if (isRegExp(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }
	
	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }
	
	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }
	
	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }
	
	  if (recurseTimes < 0) {
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }
	
	  ctx.seen.push(value);
	
	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }
	
	  ctx.seen.pop();
	
	  return reduceToSingleString(output, base, braces);
	}
	
	
	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}
	
	
	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}
	
	
	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}
	
	
	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }
	
	  return name + ': ' + str;
	}
	
	
	function reduceToSingleString(output, base, braces) {
	  var numLinesEst = 0;
	  var length = output.reduce(function(prev, cur) {
	    numLinesEst++;
	    if (cur.indexOf('\n') >= 0) numLinesEst++;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);
	
	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }
	
	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}
	
	
	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray(ar) {
	  return Array.isArray(ar);
	}
	exports.isArray = isArray;
	
	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;
	
	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;
	
	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;
	
	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;
	
	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;
	
	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;
	
	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;
	
	function isRegExp(re) {
	  return isObject(re) && objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;
	
	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;
	
	function isDate(d) {
	  return isObject(d) && objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;
	
	function isError(e) {
	  return isObject(e) &&
	      (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;
	
	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;
	
	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;
	
	exports.isBuffer = __webpack_require__(52);
	
	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}
	
	
	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}
	
	
	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];
	
	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}
	
	
	// log is just a thin wrapper to console.log that prepends a timestamp
	exports.log = function() {
	  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
	};
	
	
	/**
	 * Inherit the prototype methods from one constructor into another.
	 *
	 * The Function.prototype.inherits from lang.js rewritten as a standalone
	 * function (not on Function.prototype). NOTE: If this file is to be loaded
	 * during bootstrapping this function needs to be rewritten using some native
	 * functions as prototype setup using normal JavaScript does not work as
	 * expected during bootstrapping (see mirror.js in r114903).
	 *
	 * @param {function} ctor Constructor function which needs to inherit the
	 *     prototype.
	 * @param {function} superCtor Constructor function to inherit prototype from.
	 */
	exports.inherits = __webpack_require__(53);
	
	exports._extend = function(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;
	
	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	};
	
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(17)))

/***/ }),
/* 52 */
/***/ (function(module, exports) {

	module.exports = function isBuffer(arg) {
	  return arg && typeof arg === 'object'
	    && typeof arg.copy === 'function'
	    && typeof arg.fill === 'function'
	    && typeof arg.readUInt8 === 'function';
	}

/***/ }),
/* 53 */
/***/ (function(module, exports) {

	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    var TempCtor = function () {}
	    TempCtor.prototype = superCtor.prototype
	    ctor.prototype = new TempCtor()
	    ctor.prototype.constructor = ctor
	  }
	}


/***/ }),
/* 54 */
/***/ (function(module, exports) {

	
	function Packet () {
	  this.cmd = null
	  this.retain = false
	  this.qos = 0
	  this.dup = false
	  this.length = -1
	  this.topic = null
	  this.payload = null
	}
	
	module.exports = Packet


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	var Buffer = __webpack_require__(26).Buffer
	
	/* Protocol - protocol constants */
	var protocol = module.exports
	
	/* Command code => mnemonic */
	protocol.types = {
	  0: 'reserved',
	  1: 'connect',
	  2: 'connack',
	  3: 'publish',
	  4: 'puback',
	  5: 'pubrec',
	  6: 'pubrel',
	  7: 'pubcomp',
	  8: 'subscribe',
	  9: 'suback',
	  10: 'unsubscribe',
	  11: 'unsuback',
	  12: 'pingreq',
	  13: 'pingresp',
	  14: 'disconnect',
	  15: 'reserved'
	}
	
	/* Mnemonic => Command code */
	protocol.codes = {}
	for (var k in protocol.types) {
	  var v = protocol.types[k]
	  protocol.codes[v] = k
	}
	
	/* Header */
	protocol.CMD_SHIFT = 4
	protocol.CMD_MASK = 0xF0
	protocol.DUP_MASK = 0x08
	protocol.QOS_MASK = 0x03
	protocol.QOS_SHIFT = 1
	protocol.RETAIN_MASK = 0x01
	
	/* Length */
	protocol.LENGTH_MASK = 0x7F
	protocol.LENGTH_FIN_MASK = 0x80
	
	/* Connack */
	protocol.SESSIONPRESENT_MASK = 0x01
	protocol.SESSIONPRESENT_HEADER = Buffer.from([protocol.SESSIONPRESENT_MASK])
	protocol.CONNACK_HEADER = Buffer.from([protocol.codes['connack'] << protocol.CMD_SHIFT])
	
	/* Connect */
	protocol.USERNAME_MASK = 0x80
	protocol.PASSWORD_MASK = 0x40
	protocol.WILL_RETAIN_MASK = 0x20
	protocol.WILL_QOS_MASK = 0x18
	protocol.WILL_QOS_SHIFT = 3
	protocol.WILL_FLAG_MASK = 0x04
	protocol.CLEAN_SESSION_MASK = 0x02
	protocol.CONNECT_HEADER = Buffer.from([protocol.codes['connect'] << protocol.CMD_SHIFT])
	
	function genHeader (type) {
	  return [0, 1, 2].map(function (qos) {
	    return [0, 1].map(function (dup) {
	      return [0, 1].map(function (retain) {
	        var buf = new Buffer(1)
	        buf.writeUInt8(
	          protocol.codes[type] << protocol.CMD_SHIFT |
	          (dup ? protocol.DUP_MASK : 0) |
	          qos << protocol.QOS_SHIFT | retain, 0, true)
	        return buf
	      })
	    })
	  })
	}
	
	/* Publish */
	protocol.PUBLISH_HEADER = genHeader('publish')
	
	/* Subscribe */
	protocol.SUBSCRIBE_HEADER = genHeader('subscribe')
	
	/* Unsubscribe */
	protocol.UNSUBSCRIBE_HEADER = genHeader('unsubscribe')
	
	/* Confirmations */
	protocol.ACKS = {
	  unsuback: genHeader('unsuback'),
	  puback: genHeader('puback'),
	  pubcomp: genHeader('pubcomp'),
	  pubrel: genHeader('pubrel'),
	  pubrec: genHeader('pubrec')
	}
	
	protocol.SUBACK_HEADER = Buffer.from([protocol.codes['suback'] << protocol.CMD_SHIFT])
	
	/* Protocol versions */
	protocol.VERSION3 = Buffer.from([3])
	protocol.VERSION4 = Buffer.from([4])
	
	/* QoS */
	protocol.QOS = [0, 1, 2].map(function (qos) {
	  return Buffer.from([qos])
	})
	
	/* Empty packets */
	protocol.EMPTY = {
	  pingreq: Buffer.from([protocol.codes['pingreq'] << 4, 0]),
	  pingresp: Buffer.from([protocol.codes['pingresp'] << 4, 0]),
	  disconnect: Buffer.from([protocol.codes['disconnect'] << 4, 0])
	}


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	var Buffer = __webpack_require__(26).Buffer
	var writeToStream = __webpack_require__(57)
	var EE = __webpack_require__(19).EventEmitter
	var inherits = __webpack_require__(31)
	
	function generate (packet) {
	  var stream = new Accumulator()
	  writeToStream(packet, stream)
	  return stream.concat()
	}
	
	function Accumulator () {
	  this._array = new Array(20)
	  this._i = 0
	}
	
	inherits(Accumulator, EE)
	
	Accumulator.prototype.write = function (chunk) {
	  this._array[this._i++] = chunk
	  return true
	}
	
	Accumulator.prototype.concat = function () {
	  var length = 0
	  var lengths = new Array(this._array.length)
	  var list = this._array
	  var pos = 0
	  var i
	  var result
	
	  for (i = 0; i < list.length && list[i]; i++) {
	    if (typeof list[i] !== 'string') lengths[i] = list[i].length
	    else lengths[i] = Buffer.byteLength(list[i])
	
	    length += lengths[i]
	  }
	
	  result = Buffer.allocUnsafe(length)
	
	  for (i = 0; i < list.length && list[i]; i++) {
	    if (typeof list[i] !== 'string') {
	      list[i].copy(result, pos)
	      pos += lengths[i]
	    } else {
	      result.write(list[i], pos)
	      pos += lengths[i]
	    }
	  }
	
	  return result
	}
	
	module.exports = generate


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	var protocol = __webpack_require__(55)
	var Buffer = __webpack_require__(26).Buffer
	var empty = Buffer.allocUnsafe(0)
	var zeroBuf = Buffer.from([0])
	var numbers = __webpack_require__(58)
	var nextTick = __webpack_require__(23)
	
	var numCache = numbers.cache
	var generateNumber = numbers.generateNumber
	var generateCache = numbers.generateCache
	var writeNumber = writeNumberCached
	var toGenerate = true
	
	function generate (packet, stream) {
	  if (stream.cork) {
	    stream.cork()
	    nextTick(uncork, stream)
	  }
	
	  if (toGenerate) {
	    toGenerate = false
	    generateCache()
	  }
	
	  switch (packet.cmd) {
	    case 'connect':
	      return connect(packet, stream)
	    case 'connack':
	      return connack(packet, stream)
	    case 'publish':
	      return publish(packet, stream)
	    case 'puback':
	    case 'pubrec':
	    case 'pubrel':
	    case 'pubcomp':
	    case 'unsuback':
	      return confirmation(packet, stream)
	    case 'subscribe':
	      return subscribe(packet, stream)
	    case 'suback':
	      return suback(packet, stream)
	    case 'unsubscribe':
	      return unsubscribe(packet, stream)
	    case 'pingreq':
	    case 'pingresp':
	    case 'disconnect':
	      return emptyPacket(packet, stream)
	    default:
	      stream.emit('error', new Error('Unknown command'))
	      return false
	  }
	}
	/**
	 * Controls numbers cache.
	 * Set to "false" to allocate buffers on-the-flight instead of pre-generated cache
	 */
	Object.defineProperty(generate, 'cacheNumbers', {
	  get: function () {
	    return writeNumber === writeNumberCached
	  },
	  set: function (value) {
	    if (value) {
	      if (!numCache || Object.keys(numCache).length === 0) toGenerate = true
	      writeNumber = writeNumberCached
	    } else {
	      toGenerate = false
	      writeNumber = writeNumberGenerated
	    }
	  }
	})
	
	function uncork (stream) {
	  stream.uncork()
	}
	
	function connect (opts, stream) {
	  var settings = opts || {}
	  var protocolId = settings.protocolId || 'MQTT'
	  var protocolVersion = settings.protocolVersion || 4
	  var will = settings.will
	  var clean = settings.clean
	  var keepalive = settings.keepalive || 0
	  var clientId = settings.clientId || ''
	  var username = settings.username
	  var password = settings.password
	
	  if (clean === undefined) clean = true
	
	  var length = 0
	
	  // Must be a string and non-falsy
	  if (!protocolId ||
	     (typeof protocolId !== 'string' && !Buffer.isBuffer(protocolId))) {
	    stream.emit('error', new Error('Invalid protocolId'))
	    return false
	  } else length += protocolId.length + 2
	
	  // Must be 3 or 4
	  if (protocolVersion !== 3 && protocolVersion !== 4) {
	    stream.emit('error', new Error('Invalid protocol version'))
	    return false
	  } else length += 1
	
	  // ClientId might be omitted in 3.1.1, but only if cleanSession is set to 1
	  if ((typeof clientId === 'string' || Buffer.isBuffer(clientId)) &&
	     (clientId || protocolVersion === 4) && (clientId || clean)) {
	    length += clientId.length + 2
	  } else {
	    if (protocolVersion < 4) {
	      stream.emit('error', new Error('clientId must be supplied before 3.1.1'))
	      return false
	    }
	    if ((clean * 1) === 0) {
	      stream.emit('error', new Error('clientId must be given if cleanSession set to 0'))
	      return false
	    }
	  }
	
	  // Must be a two byte number
	  if (typeof keepalive !== 'number' ||
	      keepalive < 0 ||
	      keepalive > 65535 ||
	      keepalive % 1 !== 0) {
	    stream.emit('error', new Error('Invalid keepalive'))
	    return false
	  } else length += 2
	
	  // Connect flags
	  length += 1
	
	  // If will exists...
	  if (will) {
	    // It must be an object
	    if (typeof will !== 'object') {
	      stream.emit('error', new Error('Invalid will'))
	      return false
	    }
	    // It must have topic typeof string
	    if (!will.topic || typeof will.topic !== 'string') {
	      stream.emit('error', new Error('Invalid will topic'))
	      return false
	    } else {
	      length += Buffer.byteLength(will.topic) + 2
	    }
	
	    // Payload
	    if (will.payload && will.payload) {
	      if (will.payload.length >= 0) {
	        if (typeof will.payload === 'string') {
	          length += Buffer.byteLength(will.payload) + 2
	        } else {
	          length += will.payload.length + 2
	        }
	      } else {
	        stream.emit('error', new Error('Invalid will payload'))
	        return false
	      }
	    } else {
	      length += 2
	    }
	  }
	
	  // Username
	  if (username) {
	    if (username.length) {
	      length += Buffer.byteLength(username) + 2
	    } else {
	      stream.emit('error', new Error('Invalid username'))
	      return false
	    }
	  }
	
	  // Password
	  if (password) {
	    if (password.length) {
	      length += byteLength(password) + 2
	    } else {
	      stream.emit('error', new Error('Invalid password'))
	      return false
	    }
	  }
	
	  // Generate header
	  stream.write(protocol.CONNECT_HEADER)
	
	  // Generate length
	  writeLength(stream, length)
	
	  // Generate protocol ID
	  writeStringOrBuffer(stream, protocolId)
	  stream.write(
	    protocolVersion === 4 ? protocol.VERSION4 : protocol.VERSION3
	  )
	
	  // Connect flags
	  var flags = 0
	  flags |= username ? protocol.USERNAME_MASK : 0
	  flags |= password ? protocol.PASSWORD_MASK : 0
	  flags |= (will && will.retain) ? protocol.WILL_RETAIN_MASK : 0
	  flags |= (will && will.qos) ? will.qos << protocol.WILL_QOS_SHIFT : 0
	  flags |= will ? protocol.WILL_FLAG_MASK : 0
	  flags |= clean ? protocol.CLEAN_SESSION_MASK : 0
	
	  stream.write(Buffer.from([flags]))
	
	  // Keepalive
	  writeNumber(stream, keepalive)
	
	  // Client ID
	  writeStringOrBuffer(stream, clientId)
	
	  // Will
	  if (will) {
	    writeString(stream, will.topic)
	    writeStringOrBuffer(stream, will.payload)
	  }
	
	  // Username and password
	  if (username) writeStringOrBuffer(stream, username)
	  if (password) writeStringOrBuffer(stream, password)
	
	  // This is a small packet that happens only once on a stream
	  // We assume the stream is always free to receive more data after this
	  return true
	}
	
	function connack (opts, stream) {
	  var settings = opts || {}
	  var rc = settings.returnCode
	
	  // Check return code
	  if (typeof rc !== 'number') {
	    stream.emit('error', new Error('Invalid return code'))
	    return false
	  }
	
	  stream.write(protocol.CONNACK_HEADER)
	  writeLength(stream, 2)
	  stream.write(opts.sessionPresent ? protocol.SESSIONPRESENT_HEADER : zeroBuf)
	
	  return stream.write(Buffer.from([rc]))
	}
	
	function publish (opts, stream) {
	  var settings = opts || {}
	  var qos = settings.qos || 0
	  var retain = settings.retain ? protocol.RETAIN_MASK : 0
	  var topic = settings.topic
	  var payload = settings.payload || empty
	  var id = settings.messageId
	
	  var length = 0
	
	  // Topic must be a non-empty string or Buffer
	  if (typeof topic === 'string') length += Buffer.byteLength(topic) + 2
	  else if (Buffer.isBuffer(topic)) length += topic.length + 2
	  else {
	    stream.emit('error', new Error('Invalid topic'))
	    return false
	  }
	
	  // Get the payload length
	  if (!Buffer.isBuffer(payload)) length += Buffer.byteLength(payload)
	  else length += payload.length
	
	  // Message ID must a number if qos > 0
	  if (qos && typeof id !== 'number') {
	    stream.emit('error', new Error('Invalid messageId'))
	    return false
	  } else if (qos) length += 2
	
	  // Header
	  stream.write(protocol.PUBLISH_HEADER[qos][opts.dup ? 1 : 0][retain ? 1 : 0])
	
	  // Remaining length
	  writeLength(stream, length)
	
	  // Topic
	  writeNumber(stream, byteLength(topic))
	  stream.write(topic)
	
	  // Message ID
	  if (qos > 0) writeNumber(stream, id)
	
	  // Payload
	  return stream.write(payload)
	}
	
	/* Puback, pubrec, pubrel and pubcomp */
	function confirmation (opts, stream) {
	  var settings = opts || {}
	  var type = settings.cmd || 'puback'
	  var id = settings.messageId
	  var dup = (settings.dup && type === 'pubrel') ? protocol.DUP_MASK : 0
	  var qos = 0
	
	  if (type === 'pubrel') qos = 1
	
	  // Check message ID
	  if (typeof id !== 'number') {
	    stream.emit('error', new Error('Invalid messageId'))
	    return false
	  }
	
	  // Header
	  stream.write(protocol.ACKS[type][qos][dup][0])
	
	  // Length
	  writeLength(stream, 2)
	
	  // Message ID
	  return writeNumber(stream, id)
	}
	
	function subscribe (opts, stream) {
	  var settings = opts || {}
	  var dup = settings.dup ? protocol.DUP_MASK : 0
	  var id = settings.messageId
	  var subs = settings.subscriptions
	
	  var length = 0
	
	  // Check message ID
	  if (typeof id !== 'number') {
	    stream.emit('error', new Error('Invalid messageId'))
	    return false
	  } else length += 2
	
	  // Check subscriptions
	  if (typeof subs === 'object' && subs.length) {
	    for (var i = 0; i < subs.length; i += 1) {
	      var itopic = subs[i].topic
	      var iqos = subs[i].qos
	
	      if (typeof itopic !== 'string') {
	        stream.emit('error', new Error('Invalid subscriptions - invalid topic'))
	        return false
	      }
	      if (typeof iqos !== 'number') {
	        stream.emit('error', new Error('Invalid subscriptions - invalid qos'))
	        return false
	      }
	
	      length += Buffer.byteLength(itopic) + 2 + 1
	    }
	  } else {
	    stream.emit('error', new Error('Invalid subscriptions'))
	    return false
	  }
	
	  // Generate header
	  stream.write(protocol.SUBSCRIBE_HEADER[1][dup ? 1 : 0][0])
	
	  // Generate length
	  writeLength(stream, length)
	
	  // Generate message ID
	  writeNumber(stream, id)
	
	  var result = true
	
	  // Generate subs
	  for (var j = 0; j < subs.length; j++) {
	    var sub = subs[j]
	    var jtopic = sub.topic
	    var jqos = sub.qos
	
	    // Write topic string
	    writeString(stream, jtopic)
	
	    // Write qos
	    result = stream.write(protocol.QOS[jqos])
	  }
	
	  return result
	}
	
	function suback (opts, stream) {
	  var settings = opts || {}
	  var id = settings.messageId
	  var granted = settings.granted
	
	  var length = 0
	
	  // Check message ID
	  if (typeof id !== 'number') {
	    stream.emit('error', new Error('Invalid messageId'))
	    return false
	  } else length += 2
	
	  // Check granted qos vector
	  if (typeof granted === 'object' && granted.length) {
	    for (var i = 0; i < granted.length; i += 1) {
	      if (typeof granted[i] !== 'number') {
	        stream.emit('error', new Error('Invalid qos vector'))
	        return false
	      }
	      length += 1
	    }
	  } else {
	    stream.emit('error', new Error('Invalid qos vector'))
	    return false
	  }
	
	  // header
	  stream.write(protocol.SUBACK_HEADER)
	
	  // Length
	  writeLength(stream, length)
	
	  // Message ID
	  writeNumber(stream, id)
	
	  return stream.write(Buffer.from(granted))
	}
	
	function unsubscribe (opts, stream) {
	  var settings = opts || {}
	  var id = settings.messageId
	  var dup = settings.dup ? protocol.DUP_MASK : 0
	  var unsubs = settings.unsubscriptions
	
	  var length = 0
	
	  // Check message ID
	  if (typeof id !== 'number') {
	    stream.emit('error', new Error('Invalid messageId'))
	    return false
	  } else {
	    length += 2
	  }
	  // Check unsubs
	  if (typeof unsubs === 'object' && unsubs.length) {
	    for (var i = 0; i < unsubs.length; i += 1) {
	      if (typeof unsubs[i] !== 'string') {
	        stream.emit('error', new Error('Invalid unsubscriptions'))
	        return false
	      }
	      length += Buffer.byteLength(unsubs[i]) + 2
	    }
	  } else {
	    stream.emit('error', new Error('Invalid unsubscriptions'))
	    return false
	  }
	
	  // Header
	  stream.write(protocol.UNSUBSCRIBE_HEADER[1][dup ? 1 : 0][0])
	
	  // Length
	  writeLength(stream, length)
	
	  // Message ID
	  writeNumber(stream, id)
	
	  // Unsubs
	  var result = true
	  for (var j = 0; j < unsubs.length; j++) {
	    result = writeString(stream, unsubs[j])
	  }
	
	  return result
	}
	
	function emptyPacket (opts, stream) {
	  return stream.write(protocol.EMPTY[opts.cmd])
	}
	
	/**
	 * calcLengthLength - calculate the length of the remaining
	 * length field
	 *
	 * @api private
	 */
	function calcLengthLength (length) {
	  if (length >= 0 && length < 128) return 1
	  else if (length >= 128 && length < 16384) return 2
	  else if (length >= 16384 && length < 2097152) return 3
	  else if (length >= 2097152 && length < 268435456) return 4
	  else return 0
	}
	
	function genBufLength (length) {
	  var digit = 0
	  var pos = 0
	  var buffer = Buffer.allocUnsafe(calcLengthLength(length))
	
	  do {
	    digit = length % 128 | 0
	    length = length / 128 | 0
	    if (length > 0) digit = digit | 0x80
	
	    buffer.writeUInt8(digit, pos++, true)
	  } while (length > 0)
	
	  return buffer
	}
	
	/**
	 * writeLength - write an MQTT style length field to the buffer
	 *
	 * @param <Buffer> buffer - destination
	 * @param <Number> pos - offset
	 * @param <Number> length - length (>0)
	 * @returns <Number> number of bytes written
	 *
	 * @api private
	 */
	
	var lengthCache = {}
	function writeLength (stream, length) {
	  var buffer = lengthCache[length]
	
	  if (!buffer) {
	    buffer = genBufLength(length)
	    if (length < 16384) lengthCache[length] = buffer
	  }
	
	  stream.write(buffer)
	}
	
	/**
	 * writeString - write a utf8 string to the buffer
	 *
	 * @param <Buffer> buffer - destination
	 * @param <Number> pos - offset
	 * @param <String> string - string to write
	 * @return <Number> number of bytes written
	 *
	 * @api private
	 */
	
	function writeString (stream, string) {
	  var strlen = Buffer.byteLength(string)
	  writeNumber(stream, strlen)
	
	  stream.write(string, 'utf8')
	}
	
	/**
	 * writeNumber - write a two byte number to the buffer
	 *
	 * @param <Buffer> buffer - destination
	 * @param <Number> pos - offset
	 * @param <String> number - number to write
	 * @return <Number> number of bytes written
	 *
	 * @api private
	 */
	function writeNumberCached (stream, number) {
	  return stream.write(numCache[number])
	}
	function writeNumberGenerated (stream, number) {
	  return stream.write(generateNumber(number))
	}
	
	/**
	 * writeStringOrBuffer - write a String or Buffer with the its length prefix
	 *
	 * @param <Buffer> buffer - destination
	 * @param <Number> pos - offset
	 * @param <String> toWrite - String or Buffer
	 * @return <Number> number of bytes written
	 */
	function writeStringOrBuffer (stream, toWrite) {
	  if (toWrite && typeof toWrite === 'string') writeString(stream, toWrite)
	  else if (toWrite) {
	    writeNumber(stream, toWrite.length)
	    stream.write(toWrite)
	  } else writeNumber(stream, 0)
	}
	
	function byteLength (bufOrString) {
	  if (!bufOrString) return 0
	  else if (Buffer.isBuffer(bufOrString)) return bufOrString.length
	  else return Buffer.byteLength(bufOrString)
	}
	
	module.exports = generate


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	var Buffer = __webpack_require__(26).Buffer
	var max = 65536
	var cache = {}
	
	function generateBuffer (i) {
	  var buffer = Buffer.allocUnsafe(2)
	  buffer.writeUInt8(i >> 8, 0, true)
	  buffer.writeUInt8(i & 0x00FF, 0 + 1, true)
	
	  return buffer
	}
	
	function generateCache () {
	  for (var i = 0; i < max; i++) {
	    cache[i] = generateBuffer(i)
	  }
	}
	
	module.exports = {
	  cache: cache,
	  generateCache: generateCache,
	  generateNumber: generateBuffer
	}


/***/ }),
/* 59 */
/***/ (function(module, exports) {

	'use strict'
	
	function ReInterval (callback, interval, args) {
	  var self = this;
	
	  this._callback = callback;
	  this._args = args;
	
	  this._interval = setInterval(callback, interval, this._args);
	
	  this.reschedule = function (interval) {
	    // if no interval entered, use the interval passed in on creation
	    if (!interval)
	      interval = self._interval;
	
	    if (self._interval)
	      clearInterval(self._interval);
	    self._interval = setInterval(self._callback, interval, self._args);
	  };
	
	  this.clear = function () {
	    if (self._interval) {
	      clearInterval(self._interval);
	      self._interval = undefined;
	    }
	  };
	  
	  this.destroy = function () {
	    if (self._interval) {
	      clearInterval(self._interval);
	    }
	    self._callback = undefined;
	    self._interval = undefined;
	    self._args = undefined;
	  };
	}
	
	function reInterval () {
	  if (typeof arguments[0] !== 'function')
	    throw new Error('callback needed');
	  if (typeof arguments[1] !== 'number')
	    throw new Error('interval needed');
	
	  var args;
	
	  if (arguments.length > 0) {
	    args = new Array(arguments.length - 2);
	
	    for (var i = 0; i < args.length; i++) {
	      args[i] = arguments[i + 2];
	    }
	  }
	
	  return new ReInterval(arguments[0], arguments[1], args);
	}
	
	module.exports = reInterval;


/***/ }),
/* 60 */
/***/ (function(module, exports) {

	'use strict'
	
	/**
	 * Validate a topic to see if it's valid or not.
	 * A topic is valid if it follow below rules:
	 * - Rule #1: If any part of the topic is not `+` or `#`, then it must not contain `+` and '#'
	 * - Rule #2: Part `#` must be located at the end of the mailbox
	 *
	 * @param {String} topic - A topic
	 * @returns {Boolean} If the topic is valid, returns true. Otherwise, returns false.
	 */
	function validateTopic (topic) {
	  var parts = topic.split('/')
	
	  for (var i = 0; i < parts.length; i++) {
	    if (parts[i] === '+') {
	      continue
	    }
	
	    if (parts[i] === '#') {
	      // for Rule #2
	      return i === parts.length - 1
	    }
	
	    if (parts[i].indexOf('+') !== -1 || parts[i].indexOf('#') !== -1) {
	      return false
	    }
	  }
	
	  return true
	}
	
	/**
	 * Validate an array of topics to see if any of them is valid or not
	  * @param {Array} topics - Array of topics
	 * @returns {String} If the topics is valid, returns null. Otherwise, returns the invalid one
	 */
	function validateTopics (topics) {
	  if (topics.length === 0) {
	    return 'empty_topic_list'
	  }
	  for (var i = 0; i < topics.length; i++) {
	    if (!validateTopic(topics[i])) {
	      return topics[i]
	    }
	  }
	  return null
	}
	
	module.exports = {
	  validateTopics: validateTopics
	}


/***/ }),
/* 61 */
/***/ (function(module, exports) {

	module.exports = extend
	
	var hasOwnProperty = Object.prototype.hasOwnProperty;
	
	function extend() {
	    var target = {}
	
	    for (var i = 0; i < arguments.length; i++) {
	        var source = arguments[i]
	
	        for (var key in source) {
	            if (hasOwnProperty.call(source, key)) {
	                target[key] = source[key]
	            }
	        }
	    }
	
	    return target
	}


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	var punycode = __webpack_require__(63);
	var util = __webpack_require__(65);
	
	exports.parse = urlParse;
	exports.resolve = urlResolve;
	exports.resolveObject = urlResolveObject;
	exports.format = urlFormat;
	
	exports.Url = Url;
	
	function Url() {
	  this.protocol = null;
	  this.slashes = null;
	  this.auth = null;
	  this.host = null;
	  this.port = null;
	  this.hostname = null;
	  this.hash = null;
	  this.search = null;
	  this.query = null;
	  this.pathname = null;
	  this.path = null;
	  this.href = null;
	}
	
	// Reference: RFC 3986, RFC 1808, RFC 2396
	
	// define these here so at least they only have to be
	// compiled once on the first module load.
	var protocolPattern = /^([a-z0-9.+-]+:)/i,
	    portPattern = /:[0-9]*$/,
	
	    // Special case for a simple path URL
	    simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,
	
	    // RFC 2396: characters reserved for delimiting URLs.
	    // We actually just auto-escape these.
	    delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],
	
	    // RFC 2396: characters not allowed for various reasons.
	    unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),
	
	    // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
	    autoEscape = ['\''].concat(unwise),
	    // Characters that are never ever allowed in a hostname.
	    // Note that any invalid chars are also handled, but these
	    // are the ones that are *expected* to be seen, so we fast-path
	    // them.
	    nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
	    hostEndingChars = ['/', '?', '#'],
	    hostnameMaxLen = 255,
	    hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
	    hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
	    // protocols that can allow "unsafe" and "unwise" chars.
	    unsafeProtocol = {
	      'javascript': true,
	      'javascript:': true
	    },
	    // protocols that never have a hostname.
	    hostlessProtocol = {
	      'javascript': true,
	      'javascript:': true
	    },
	    // protocols that always contain a // bit.
	    slashedProtocol = {
	      'http': true,
	      'https': true,
	      'ftp': true,
	      'gopher': true,
	      'file': true,
	      'http:': true,
	      'https:': true,
	      'ftp:': true,
	      'gopher:': true,
	      'file:': true
	    },
	    querystring = __webpack_require__(66);
	
	function urlParse(url, parseQueryString, slashesDenoteHost) {
	  if (url && util.isObject(url) && url instanceof Url) return url;
	
	  var u = new Url;
	  u.parse(url, parseQueryString, slashesDenoteHost);
	  return u;
	}
	
	Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
	  if (!util.isString(url)) {
	    throw new TypeError("Parameter 'url' must be a string, not " + typeof url);
	  }
	
	  // Copy chrome, IE, opera backslash-handling behavior.
	  // Back slashes before the query string get converted to forward slashes
	  // See: https://code.google.com/p/chromium/issues/detail?id=25916
	  var queryIndex = url.indexOf('?'),
	      splitter =
	          (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
	      uSplit = url.split(splitter),
	      slashRegex = /\\/g;
	  uSplit[0] = uSplit[0].replace(slashRegex, '/');
	  url = uSplit.join(splitter);
	
	  var rest = url;
	
	  // trim before proceeding.
	  // This is to support parse stuff like "  http://foo.com  \n"
	  rest = rest.trim();
	
	  if (!slashesDenoteHost && url.split('#').length === 1) {
	    // Try fast path regexp
	    var simplePath = simplePathPattern.exec(rest);
	    if (simplePath) {
	      this.path = rest;
	      this.href = rest;
	      this.pathname = simplePath[1];
	      if (simplePath[2]) {
	        this.search = simplePath[2];
	        if (parseQueryString) {
	          this.query = querystring.parse(this.search.substr(1));
	        } else {
	          this.query = this.search.substr(1);
	        }
	      } else if (parseQueryString) {
	        this.search = '';
	        this.query = {};
	      }
	      return this;
	    }
	  }
	
	  var proto = protocolPattern.exec(rest);
	  if (proto) {
	    proto = proto[0];
	    var lowerProto = proto.toLowerCase();
	    this.protocol = lowerProto;
	    rest = rest.substr(proto.length);
	  }
	
	  // figure out if it's got a host
	  // user@server is *always* interpreted as a hostname, and url
	  // resolution will treat //foo/bar as host=foo,path=bar because that's
	  // how the browser resolves relative URLs.
	  if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
	    var slashes = rest.substr(0, 2) === '//';
	    if (slashes && !(proto && hostlessProtocol[proto])) {
	      rest = rest.substr(2);
	      this.slashes = true;
	    }
	  }
	
	  if (!hostlessProtocol[proto] &&
	      (slashes || (proto && !slashedProtocol[proto]))) {
	
	    // there's a hostname.
	    // the first instance of /, ?, ;, or # ends the host.
	    //
	    // If there is an @ in the hostname, then non-host chars *are* allowed
	    // to the left of the last @ sign, unless some host-ending character
	    // comes *before* the @-sign.
	    // URLs are obnoxious.
	    //
	    // ex:
	    // http://a@b@c/ => user:a@b host:c
	    // http://a@b?@c => user:a host:c path:/?@c
	
	    // v0.12 TODO(isaacs): This is not quite how Chrome does things.
	    // Review our test case against browsers more comprehensively.
	
	    // find the first instance of any hostEndingChars
	    var hostEnd = -1;
	    for (var i = 0; i < hostEndingChars.length; i++) {
	      var hec = rest.indexOf(hostEndingChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }
	
	    // at this point, either we have an explicit point where the
	    // auth portion cannot go past, or the last @ char is the decider.
	    var auth, atSign;
	    if (hostEnd === -1) {
	      // atSign can be anywhere.
	      atSign = rest.lastIndexOf('@');
	    } else {
	      // atSign must be in auth portion.
	      // http://a@b/c@d => host:b auth:a path:/c@d
	      atSign = rest.lastIndexOf('@', hostEnd);
	    }
	
	    // Now we have a portion which is definitely the auth.
	    // Pull that off.
	    if (atSign !== -1) {
	      auth = rest.slice(0, atSign);
	      rest = rest.slice(atSign + 1);
	      this.auth = decodeURIComponent(auth);
	    }
	
	    // the host is the remaining to the left of the first non-host char
	    hostEnd = -1;
	    for (var i = 0; i < nonHostChars.length; i++) {
	      var hec = rest.indexOf(nonHostChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }
	    // if we still have not hit it, then the entire thing is a host.
	    if (hostEnd === -1)
	      hostEnd = rest.length;
	
	    this.host = rest.slice(0, hostEnd);
	    rest = rest.slice(hostEnd);
	
	    // pull out port.
	    this.parseHost();
	
	    // we've indicated that there is a hostname,
	    // so even if it's empty, it has to be present.
	    this.hostname = this.hostname || '';
	
	    // if hostname begins with [ and ends with ]
	    // assume that it's an IPv6 address.
	    var ipv6Hostname = this.hostname[0] === '[' &&
	        this.hostname[this.hostname.length - 1] === ']';
	
	    // validate a little.
	    if (!ipv6Hostname) {
	      var hostparts = this.hostname.split(/\./);
	      for (var i = 0, l = hostparts.length; i < l; i++) {
	        var part = hostparts[i];
	        if (!part) continue;
	        if (!part.match(hostnamePartPattern)) {
	          var newpart = '';
	          for (var j = 0, k = part.length; j < k; j++) {
	            if (part.charCodeAt(j) > 127) {
	              // we replace non-ASCII char with a temporary placeholder
	              // we need this to make sure size of hostname is not
	              // broken by replacing non-ASCII by nothing
	              newpart += 'x';
	            } else {
	              newpart += part[j];
	            }
	          }
	          // we test again with ASCII char only
	          if (!newpart.match(hostnamePartPattern)) {
	            var validParts = hostparts.slice(0, i);
	            var notHost = hostparts.slice(i + 1);
	            var bit = part.match(hostnamePartStart);
	            if (bit) {
	              validParts.push(bit[1]);
	              notHost.unshift(bit[2]);
	            }
	            if (notHost.length) {
	              rest = '/' + notHost.join('.') + rest;
	            }
	            this.hostname = validParts.join('.');
	            break;
	          }
	        }
	      }
	    }
	
	    if (this.hostname.length > hostnameMaxLen) {
	      this.hostname = '';
	    } else {
	      // hostnames are always lower case.
	      this.hostname = this.hostname.toLowerCase();
	    }
	
	    if (!ipv6Hostname) {
	      // IDNA Support: Returns a punycoded representation of "domain".
	      // It only converts parts of the domain name that
	      // have non-ASCII characters, i.e. it doesn't matter if
	      // you call it with a domain that already is ASCII-only.
	      this.hostname = punycode.toASCII(this.hostname);
	    }
	
	    var p = this.port ? ':' + this.port : '';
	    var h = this.hostname || '';
	    this.host = h + p;
	    this.href += this.host;
	
	    // strip [ and ] from the hostname
	    // the host field still retains them, though
	    if (ipv6Hostname) {
	      this.hostname = this.hostname.substr(1, this.hostname.length - 2);
	      if (rest[0] !== '/') {
	        rest = '/' + rest;
	      }
	    }
	  }
	
	  // now rest is set to the post-host stuff.
	  // chop off any delim chars.
	  if (!unsafeProtocol[lowerProto]) {
	
	    // First, make 100% sure that any "autoEscape" chars get
	    // escaped, even if encodeURIComponent doesn't think they
	    // need to be.
	    for (var i = 0, l = autoEscape.length; i < l; i++) {
	      var ae = autoEscape[i];
	      if (rest.indexOf(ae) === -1)
	        continue;
	      var esc = encodeURIComponent(ae);
	      if (esc === ae) {
	        esc = escape(ae);
	      }
	      rest = rest.split(ae).join(esc);
	    }
	  }
	
	
	  // chop off from the tail first.
	  var hash = rest.indexOf('#');
	  if (hash !== -1) {
	    // got a fragment string.
	    this.hash = rest.substr(hash);
	    rest = rest.slice(0, hash);
	  }
	  var qm = rest.indexOf('?');
	  if (qm !== -1) {
	    this.search = rest.substr(qm);
	    this.query = rest.substr(qm + 1);
	    if (parseQueryString) {
	      this.query = querystring.parse(this.query);
	    }
	    rest = rest.slice(0, qm);
	  } else if (parseQueryString) {
	    // no query string, but parseQueryString still requested
	    this.search = '';
	    this.query = {};
	  }
	  if (rest) this.pathname = rest;
	  if (slashedProtocol[lowerProto] &&
	      this.hostname && !this.pathname) {
	    this.pathname = '/';
	  }
	
	  //to support http.request
	  if (this.pathname || this.search) {
	    var p = this.pathname || '';
	    var s = this.search || '';
	    this.path = p + s;
	  }
	
	  // finally, reconstruct the href based on what has been validated.
	  this.href = this.format();
	  return this;
	};
	
	// format a parsed object into a url string
	function urlFormat(obj) {
	  // ensure it's an object, and not a string url.
	  // If it's an obj, this is a no-op.
	  // this way, you can call url_format() on strings
	  // to clean up potentially wonky urls.
	  if (util.isString(obj)) obj = urlParse(obj);
	  if (!(obj instanceof Url)) return Url.prototype.format.call(obj);
	  return obj.format();
	}
	
	Url.prototype.format = function() {
	  var auth = this.auth || '';
	  if (auth) {
	    auth = encodeURIComponent(auth);
	    auth = auth.replace(/%3A/i, ':');
	    auth += '@';
	  }
	
	  var protocol = this.protocol || '',
	      pathname = this.pathname || '',
	      hash = this.hash || '',
	      host = false,
	      query = '';
	
	  if (this.host) {
	    host = auth + this.host;
	  } else if (this.hostname) {
	    host = auth + (this.hostname.indexOf(':') === -1 ?
	        this.hostname :
	        '[' + this.hostname + ']');
	    if (this.port) {
	      host += ':' + this.port;
	    }
	  }
	
	  if (this.query &&
	      util.isObject(this.query) &&
	      Object.keys(this.query).length) {
	    query = querystring.stringify(this.query);
	  }
	
	  var search = this.search || (query && ('?' + query)) || '';
	
	  if (protocol && protocol.substr(-1) !== ':') protocol += ':';
	
	  // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
	  // unless they had them to begin with.
	  if (this.slashes ||
	      (!protocol || slashedProtocol[protocol]) && host !== false) {
	    host = '//' + (host || '');
	    if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
	  } else if (!host) {
	    host = '';
	  }
	
	  if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
	  if (search && search.charAt(0) !== '?') search = '?' + search;
	
	  pathname = pathname.replace(/[?#]/g, function(match) {
	    return encodeURIComponent(match);
	  });
	  search = search.replace('#', '%23');
	
	  return protocol + host + pathname + search + hash;
	};
	
	function urlResolve(source, relative) {
	  return urlParse(source, false, true).resolve(relative);
	}
	
	Url.prototype.resolve = function(relative) {
	  return this.resolveObject(urlParse(relative, false, true)).format();
	};
	
	function urlResolveObject(source, relative) {
	  if (!source) return relative;
	  return urlParse(source, false, true).resolveObject(relative);
	}
	
	Url.prototype.resolveObject = function(relative) {
	  if (util.isString(relative)) {
	    var rel = new Url();
	    rel.parse(relative, false, true);
	    relative = rel;
	  }
	
	  var result = new Url();
	  var tkeys = Object.keys(this);
	  for (var tk = 0; tk < tkeys.length; tk++) {
	    var tkey = tkeys[tk];
	    result[tkey] = this[tkey];
	  }
	
	  // hash is always overridden, no matter what.
	  // even href="" will remove it.
	  result.hash = relative.hash;
	
	  // if the relative url is empty, then there's nothing left to do here.
	  if (relative.href === '') {
	    result.href = result.format();
	    return result;
	  }
	
	  // hrefs like //foo/bar always cut to the protocol.
	  if (relative.slashes && !relative.protocol) {
	    // take everything except the protocol from relative
	    var rkeys = Object.keys(relative);
	    for (var rk = 0; rk < rkeys.length; rk++) {
	      var rkey = rkeys[rk];
	      if (rkey !== 'protocol')
	        result[rkey] = relative[rkey];
	    }
	
	    //urlParse appends trailing / to urls like http://www.example.com
	    if (slashedProtocol[result.protocol] &&
	        result.hostname && !result.pathname) {
	      result.path = result.pathname = '/';
	    }
	
	    result.href = result.format();
	    return result;
	  }
	
	  if (relative.protocol && relative.protocol !== result.protocol) {
	    // if it's a known url protocol, then changing
	    // the protocol does weird things
	    // first, if it's not file:, then we MUST have a host,
	    // and if there was a path
	    // to begin with, then we MUST have a path.
	    // if it is file:, then the host is dropped,
	    // because that's known to be hostless.
	    // anything else is assumed to be absolute.
	    if (!slashedProtocol[relative.protocol]) {
	      var keys = Object.keys(relative);
	      for (var v = 0; v < keys.length; v++) {
	        var k = keys[v];
	        result[k] = relative[k];
	      }
	      result.href = result.format();
	      return result;
	    }
	
	    result.protocol = relative.protocol;
	    if (!relative.host && !hostlessProtocol[relative.protocol]) {
	      var relPath = (relative.pathname || '').split('/');
	      while (relPath.length && !(relative.host = relPath.shift()));
	      if (!relative.host) relative.host = '';
	      if (!relative.hostname) relative.hostname = '';
	      if (relPath[0] !== '') relPath.unshift('');
	      if (relPath.length < 2) relPath.unshift('');
	      result.pathname = relPath.join('/');
	    } else {
	      result.pathname = relative.pathname;
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    result.host = relative.host || '';
	    result.auth = relative.auth;
	    result.hostname = relative.hostname || relative.host;
	    result.port = relative.port;
	    // to support http.request
	    if (result.pathname || result.search) {
	      var p = result.pathname || '';
	      var s = result.search || '';
	      result.path = p + s;
	    }
	    result.slashes = result.slashes || relative.slashes;
	    result.href = result.format();
	    return result;
	  }
	
	  var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
	      isRelAbs = (
	          relative.host ||
	          relative.pathname && relative.pathname.charAt(0) === '/'
	      ),
	      mustEndAbs = (isRelAbs || isSourceAbs ||
	                    (result.host && relative.pathname)),
	      removeAllDots = mustEndAbs,
	      srcPath = result.pathname && result.pathname.split('/') || [],
	      relPath = relative.pathname && relative.pathname.split('/') || [],
	      psychotic = result.protocol && !slashedProtocol[result.protocol];
	
	  // if the url is a non-slashed url, then relative
	  // links like ../.. should be able
	  // to crawl up to the hostname, as well.  This is strange.
	  // result.protocol has already been set by now.
	  // Later on, put the first path part into the host field.
	  if (psychotic) {
	    result.hostname = '';
	    result.port = null;
	    if (result.host) {
	      if (srcPath[0] === '') srcPath[0] = result.host;
	      else srcPath.unshift(result.host);
	    }
	    result.host = '';
	    if (relative.protocol) {
	      relative.hostname = null;
	      relative.port = null;
	      if (relative.host) {
	        if (relPath[0] === '') relPath[0] = relative.host;
	        else relPath.unshift(relative.host);
	      }
	      relative.host = null;
	    }
	    mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
	  }
	
	  if (isRelAbs) {
	    // it's absolute.
	    result.host = (relative.host || relative.host === '') ?
	                  relative.host : result.host;
	    result.hostname = (relative.hostname || relative.hostname === '') ?
	                      relative.hostname : result.hostname;
	    result.search = relative.search;
	    result.query = relative.query;
	    srcPath = relPath;
	    // fall through to the dot-handling below.
	  } else if (relPath.length) {
	    // it's relative
	    // throw away the existing file, and take the new path instead.
	    if (!srcPath) srcPath = [];
	    srcPath.pop();
	    srcPath = srcPath.concat(relPath);
	    result.search = relative.search;
	    result.query = relative.query;
	  } else if (!util.isNullOrUndefined(relative.search)) {
	    // just pull out the search.
	    // like href='?foo'.
	    // Put this after the other two cases because it simplifies the booleans
	    if (psychotic) {
	      result.hostname = result.host = srcPath.shift();
	      //occationaly the auth can get stuck only in host
	      //this especially happens in cases like
	      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	      var authInHost = result.host && result.host.indexOf('@') > 0 ?
	                       result.host.split('@') : false;
	      if (authInHost) {
	        result.auth = authInHost.shift();
	        result.host = result.hostname = authInHost.shift();
	      }
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    //to support http.request
	    if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
	      result.path = (result.pathname ? result.pathname : '') +
	                    (result.search ? result.search : '');
	    }
	    result.href = result.format();
	    return result;
	  }
	
	  if (!srcPath.length) {
	    // no path at all.  easy.
	    // we've already handled the other stuff above.
	    result.pathname = null;
	    //to support http.request
	    if (result.search) {
	      result.path = '/' + result.search;
	    } else {
	      result.path = null;
	    }
	    result.href = result.format();
	    return result;
	  }
	
	  // if a url ENDs in . or .., then it must get a trailing slash.
	  // however, if it ends in anything else non-slashy,
	  // then it must NOT get a trailing slash.
	  var last = srcPath.slice(-1)[0];
	  var hasTrailingSlash = (
	      (result.host || relative.host || srcPath.length > 1) &&
	      (last === '.' || last === '..') || last === '');
	
	  // strip single dots, resolve double dots to parent dir
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = srcPath.length; i >= 0; i--) {
	    last = srcPath[i];
	    if (last === '.') {
	      srcPath.splice(i, 1);
	    } else if (last === '..') {
	      srcPath.splice(i, 1);
	      up++;
	    } else if (up) {
	      srcPath.splice(i, 1);
	      up--;
	    }
	  }
	
	  // if the path is allowed to go above the root, restore leading ..s
	  if (!mustEndAbs && !removeAllDots) {
	    for (; up--; up) {
	      srcPath.unshift('..');
	    }
	  }
	
	  if (mustEndAbs && srcPath[0] !== '' &&
	      (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
	    srcPath.unshift('');
	  }
	
	  if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
	    srcPath.push('');
	  }
	
	  var isAbsolute = srcPath[0] === '' ||
	      (srcPath[0] && srcPath[0].charAt(0) === '/');
	
	  // put the host back
	  if (psychotic) {
	    result.hostname = result.host = isAbsolute ? '' :
	                                    srcPath.length ? srcPath.shift() : '';
	    //occationaly the auth can get stuck only in host
	    //this especially happens in cases like
	    //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	    var authInHost = result.host && result.host.indexOf('@') > 0 ?
	                     result.host.split('@') : false;
	    if (authInHost) {
	      result.auth = authInHost.shift();
	      result.host = result.hostname = authInHost.shift();
	    }
	  }
	
	  mustEndAbs = mustEndAbs || (result.host && srcPath.length);
	
	  if (mustEndAbs && !isAbsolute) {
	    srcPath.unshift('');
	  }
	
	  if (!srcPath.length) {
	    result.pathname = null;
	    result.path = null;
	  } else {
	    result.pathname = srcPath.join('/');
	  }
	
	  //to support request.http
	  if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
	    result.path = (result.pathname ? result.pathname : '') +
	                  (result.search ? result.search : '');
	  }
	  result.auth = relative.auth || result.auth;
	  result.slashes = result.slashes || relative.slashes;
	  result.href = result.format();
	  return result;
	};
	
	Url.prototype.parseHost = function() {
	  var host = this.host;
	  var port = portPattern.exec(host);
	  if (port) {
	    port = port[0];
	    if (port !== ':') {
	      this.port = port.substr(1);
	    }
	    host = host.substr(0, host.length - port.length);
	  }
	  if (host) this.hostname = host;
	};


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(module, global) {/*! https://mths.be/punycode v1.3.2 by @mathias */
	;(function(root) {
	
		/** Detect free variables */
		var freeExports = typeof exports == 'object' && exports &&
			!exports.nodeType && exports;
		var freeModule = typeof module == 'object' && module &&
			!module.nodeType && module;
		var freeGlobal = typeof global == 'object' && global;
		if (
			freeGlobal.global === freeGlobal ||
			freeGlobal.window === freeGlobal ||
			freeGlobal.self === freeGlobal
		) {
			root = freeGlobal;
		}
	
		/**
		 * The `punycode` object.
		 * @name punycode
		 * @type Object
		 */
		var punycode,
	
		/** Highest positive signed 32-bit float value */
		maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1
	
		/** Bootstring parameters */
		base = 36,
		tMin = 1,
		tMax = 26,
		skew = 38,
		damp = 700,
		initialBias = 72,
		initialN = 128, // 0x80
		delimiter = '-', // '\x2D'
	
		/** Regular expressions */
		regexPunycode = /^xn--/,
		regexNonASCII = /[^\x20-\x7E]/, // unprintable ASCII chars + non-ASCII chars
		regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, // RFC 3490 separators
	
		/** Error messages */
		errors = {
			'overflow': 'Overflow: input needs wider integers to process',
			'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
			'invalid-input': 'Invalid input'
		},
	
		/** Convenience shortcuts */
		baseMinusTMin = base - tMin,
		floor = Math.floor,
		stringFromCharCode = String.fromCharCode,
	
		/** Temporary variable */
		key;
	
		/*--------------------------------------------------------------------------*/
	
		/**
		 * A generic error utility function.
		 * @private
		 * @param {String} type The error type.
		 * @returns {Error} Throws a `RangeError` with the applicable error message.
		 */
		function error(type) {
			throw RangeError(errors[type]);
		}
	
		/**
		 * A generic `Array#map` utility function.
		 * @private
		 * @param {Array} array The array to iterate over.
		 * @param {Function} callback The function that gets called for every array
		 * item.
		 * @returns {Array} A new array of values returned by the callback function.
		 */
		function map(array, fn) {
			var length = array.length;
			var result = [];
			while (length--) {
				result[length] = fn(array[length]);
			}
			return result;
		}
	
		/**
		 * A simple `Array#map`-like wrapper to work with domain name strings or email
		 * addresses.
		 * @private
		 * @param {String} domain The domain name or email address.
		 * @param {Function} callback The function that gets called for every
		 * character.
		 * @returns {Array} A new string of characters returned by the callback
		 * function.
		 */
		function mapDomain(string, fn) {
			var parts = string.split('@');
			var result = '';
			if (parts.length > 1) {
				// In email addresses, only the domain name should be punycoded. Leave
				// the local part (i.e. everything up to `@`) intact.
				result = parts[0] + '@';
				string = parts[1];
			}
			// Avoid `split(regex)` for IE8 compatibility. See #17.
			string = string.replace(regexSeparators, '\x2E');
			var labels = string.split('.');
			var encoded = map(labels, fn).join('.');
			return result + encoded;
		}
	
		/**
		 * Creates an array containing the numeric code points of each Unicode
		 * character in the string. While JavaScript uses UCS-2 internally,
		 * this function will convert a pair of surrogate halves (each of which
		 * UCS-2 exposes as separate characters) into a single code point,
		 * matching UTF-16.
		 * @see `punycode.ucs2.encode`
		 * @see <https://mathiasbynens.be/notes/javascript-encoding>
		 * @memberOf punycode.ucs2
		 * @name decode
		 * @param {String} string The Unicode input string (UCS-2).
		 * @returns {Array} The new array of code points.
		 */
		function ucs2decode(string) {
			var output = [],
			    counter = 0,
			    length = string.length,
			    value,
			    extra;
			while (counter < length) {
				value = string.charCodeAt(counter++);
				if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
					// high surrogate, and there is a next character
					extra = string.charCodeAt(counter++);
					if ((extra & 0xFC00) == 0xDC00) { // low surrogate
						output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
					} else {
						// unmatched surrogate; only append this code unit, in case the next
						// code unit is the high surrogate of a surrogate pair
						output.push(value);
						counter--;
					}
				} else {
					output.push(value);
				}
			}
			return output;
		}
	
		/**
		 * Creates a string based on an array of numeric code points.
		 * @see `punycode.ucs2.decode`
		 * @memberOf punycode.ucs2
		 * @name encode
		 * @param {Array} codePoints The array of numeric code points.
		 * @returns {String} The new Unicode string (UCS-2).
		 */
		function ucs2encode(array) {
			return map(array, function(value) {
				var output = '';
				if (value > 0xFFFF) {
					value -= 0x10000;
					output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
					value = 0xDC00 | value & 0x3FF;
				}
				output += stringFromCharCode(value);
				return output;
			}).join('');
		}
	
		/**
		 * Converts a basic code point into a digit/integer.
		 * @see `digitToBasic()`
		 * @private
		 * @param {Number} codePoint The basic numeric code point value.
		 * @returns {Number} The numeric value of a basic code point (for use in
		 * representing integers) in the range `0` to `base - 1`, or `base` if
		 * the code point does not represent a value.
		 */
		function basicToDigit(codePoint) {
			if (codePoint - 48 < 10) {
				return codePoint - 22;
			}
			if (codePoint - 65 < 26) {
				return codePoint - 65;
			}
			if (codePoint - 97 < 26) {
				return codePoint - 97;
			}
			return base;
		}
	
		/**
		 * Converts a digit/integer into a basic code point.
		 * @see `basicToDigit()`
		 * @private
		 * @param {Number} digit The numeric value of a basic code point.
		 * @returns {Number} The basic code point whose value (when used for
		 * representing integers) is `digit`, which needs to be in the range
		 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
		 * used; else, the lowercase form is used. The behavior is undefined
		 * if `flag` is non-zero and `digit` has no uppercase form.
		 */
		function digitToBasic(digit, flag) {
			//  0..25 map to ASCII a..z or A..Z
			// 26..35 map to ASCII 0..9
			return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
		}
	
		/**
		 * Bias adaptation function as per section 3.4 of RFC 3492.
		 * http://tools.ietf.org/html/rfc3492#section-3.4
		 * @private
		 */
		function adapt(delta, numPoints, firstTime) {
			var k = 0;
			delta = firstTime ? floor(delta / damp) : delta >> 1;
			delta += floor(delta / numPoints);
			for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
				delta = floor(delta / baseMinusTMin);
			}
			return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
		}
	
		/**
		 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
		 * symbols.
		 * @memberOf punycode
		 * @param {String} input The Punycode string of ASCII-only symbols.
		 * @returns {String} The resulting string of Unicode symbols.
		 */
		function decode(input) {
			// Don't use UCS-2
			var output = [],
			    inputLength = input.length,
			    out,
			    i = 0,
			    n = initialN,
			    bias = initialBias,
			    basic,
			    j,
			    index,
			    oldi,
			    w,
			    k,
			    digit,
			    t,
			    /** Cached calculation results */
			    baseMinusT;
	
			// Handle the basic code points: let `basic` be the number of input code
			// points before the last delimiter, or `0` if there is none, then copy
			// the first basic code points to the output.
	
			basic = input.lastIndexOf(delimiter);
			if (basic < 0) {
				basic = 0;
			}
	
			for (j = 0; j < basic; ++j) {
				// if it's not a basic code point
				if (input.charCodeAt(j) >= 0x80) {
					error('not-basic');
				}
				output.push(input.charCodeAt(j));
			}
	
			// Main decoding loop: start just after the last delimiter if any basic code
			// points were copied; start at the beginning otherwise.
	
			for (index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {
	
				// `index` is the index of the next character to be consumed.
				// Decode a generalized variable-length integer into `delta`,
				// which gets added to `i`. The overflow checking is easier
				// if we increase `i` as we go, then subtract off its starting
				// value at the end to obtain `delta`.
				for (oldi = i, w = 1, k = base; /* no condition */; k += base) {
	
					if (index >= inputLength) {
						error('invalid-input');
					}
	
					digit = basicToDigit(input.charCodeAt(index++));
	
					if (digit >= base || digit > floor((maxInt - i) / w)) {
						error('overflow');
					}
	
					i += digit * w;
					t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
	
					if (digit < t) {
						break;
					}
	
					baseMinusT = base - t;
					if (w > floor(maxInt / baseMinusT)) {
						error('overflow');
					}
	
					w *= baseMinusT;
	
				}
	
				out = output.length + 1;
				bias = adapt(i - oldi, out, oldi == 0);
	
				// `i` was supposed to wrap around from `out` to `0`,
				// incrementing `n` each time, so we'll fix that now:
				if (floor(i / out) > maxInt - n) {
					error('overflow');
				}
	
				n += floor(i / out);
				i %= out;
	
				// Insert `n` at position `i` of the output
				output.splice(i++, 0, n);
	
			}
	
			return ucs2encode(output);
		}
	
		/**
		 * Converts a string of Unicode symbols (e.g. a domain name label) to a
		 * Punycode string of ASCII-only symbols.
		 * @memberOf punycode
		 * @param {String} input The string of Unicode symbols.
		 * @returns {String} The resulting Punycode string of ASCII-only symbols.
		 */
		function encode(input) {
			var n,
			    delta,
			    handledCPCount,
			    basicLength,
			    bias,
			    j,
			    m,
			    q,
			    k,
			    t,
			    currentValue,
			    output = [],
			    /** `inputLength` will hold the number of code points in `input`. */
			    inputLength,
			    /** Cached calculation results */
			    handledCPCountPlusOne,
			    baseMinusT,
			    qMinusT;
	
			// Convert the input in UCS-2 to Unicode
			input = ucs2decode(input);
	
			// Cache the length
			inputLength = input.length;
	
			// Initialize the state
			n = initialN;
			delta = 0;
			bias = initialBias;
	
			// Handle the basic code points
			for (j = 0; j < inputLength; ++j) {
				currentValue = input[j];
				if (currentValue < 0x80) {
					output.push(stringFromCharCode(currentValue));
				}
			}
	
			handledCPCount = basicLength = output.length;
	
			// `handledCPCount` is the number of code points that have been handled;
			// `basicLength` is the number of basic code points.
	
			// Finish the basic string - if it is not empty - with a delimiter
			if (basicLength) {
				output.push(delimiter);
			}
	
			// Main encoding loop:
			while (handledCPCount < inputLength) {
	
				// All non-basic code points < n have been handled already. Find the next
				// larger one:
				for (m = maxInt, j = 0; j < inputLength; ++j) {
					currentValue = input[j];
					if (currentValue >= n && currentValue < m) {
						m = currentValue;
					}
				}
	
				// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
				// but guard against overflow
				handledCPCountPlusOne = handledCPCount + 1;
				if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
					error('overflow');
				}
	
				delta += (m - n) * handledCPCountPlusOne;
				n = m;
	
				for (j = 0; j < inputLength; ++j) {
					currentValue = input[j];
	
					if (currentValue < n && ++delta > maxInt) {
						error('overflow');
					}
	
					if (currentValue == n) {
						// Represent delta as a generalized variable-length integer
						for (q = delta, k = base; /* no condition */; k += base) {
							t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
							if (q < t) {
								break;
							}
							qMinusT = q - t;
							baseMinusT = base - t;
							output.push(
								stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
							);
							q = floor(qMinusT / baseMinusT);
						}
	
						output.push(stringFromCharCode(digitToBasic(q, 0)));
						bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
						delta = 0;
						++handledCPCount;
					}
				}
	
				++delta;
				++n;
	
			}
			return output.join('');
		}
	
		/**
		 * Converts a Punycode string representing a domain name or an email address
		 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
		 * it doesn't matter if you call it on a string that has already been
		 * converted to Unicode.
		 * @memberOf punycode
		 * @param {String} input The Punycoded domain name or email address to
		 * convert to Unicode.
		 * @returns {String} The Unicode representation of the given Punycode
		 * string.
		 */
		function toUnicode(input) {
			return mapDomain(input, function(string) {
				return regexPunycode.test(string)
					? decode(string.slice(4).toLowerCase())
					: string;
			});
		}
	
		/**
		 * Converts a Unicode string representing a domain name or an email address to
		 * Punycode. Only the non-ASCII parts of the domain name will be converted,
		 * i.e. it doesn't matter if you call it with a domain that's already in
		 * ASCII.
		 * @memberOf punycode
		 * @param {String} input The domain name or email address to convert, as a
		 * Unicode string.
		 * @returns {String} The Punycode representation of the given domain name or
		 * email address.
		 */
		function toASCII(input) {
			return mapDomain(input, function(string) {
				return regexNonASCII.test(string)
					? 'xn--' + encode(string)
					: string;
			});
		}
	
		/*--------------------------------------------------------------------------*/
	
		/** Define the public API */
		punycode = {
			/**
			 * A string representing the current Punycode.js version number.
			 * @memberOf punycode
			 * @type String
			 */
			'version': '1.3.2',
			/**
			 * An object of methods to convert from JavaScript's internal character
			 * representation (UCS-2) to Unicode code points, and back.
			 * @see <https://mathiasbynens.be/notes/javascript-encoding>
			 * @memberOf punycode
			 * @type Object
			 */
			'ucs2': {
				'decode': ucs2decode,
				'encode': ucs2encode
			},
			'decode': decode,
			'encode': encode,
			'toASCII': toASCII,
			'toUnicode': toUnicode
		};
	
		/** Expose `punycode` */
		// Some AMD build optimizers, like r.js, check for specific condition patterns
		// like the following:
		if (
			true
		) {
			!(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
				return punycode;
			}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
		} else if (freeExports && freeModule) {
			if (module.exports == freeExports) { // in Node.js or RingoJS v0.8.0+
				freeModule.exports = punycode;
			} else { // in Narwhal or RingoJS v0.7.0-
				for (key in punycode) {
					punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
				}
			}
		} else { // in Rhino or a web browser
			root.punycode = punycode;
		}
	
	}(this));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(64)(module), (function() { return this; }())))

/***/ }),
/* 64 */
/***/ (function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ }),
/* 65 */
/***/ (function(module, exports) {

	'use strict';
	
	module.exports = {
	  isString: function(arg) {
	    return typeof(arg) === 'string';
	  },
	  isObject: function(arg) {
	    return typeof(arg) === 'object' && arg !== null;
	  },
	  isNull: function(arg) {
	    return arg === null;
	  },
	  isNullOrUndefined: function(arg) {
	    return arg == null;
	  }
	};


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.decode = exports.parse = __webpack_require__(67);
	exports.encode = exports.stringify = __webpack_require__(68);


/***/ }),
/* 67 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	// If obj.hasOwnProperty has been overridden, then calling
	// obj.hasOwnProperty(prop) will break.
	// See: https://github.com/joyent/node/issues/1707
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}
	
	module.exports = function(qs, sep, eq, options) {
	  sep = sep || '&';
	  eq = eq || '=';
	  var obj = {};
	
	  if (typeof qs !== 'string' || qs.length === 0) {
	    return obj;
	  }
	
	  var regexp = /\+/g;
	  qs = qs.split(sep);
	
	  var maxKeys = 1000;
	  if (options && typeof options.maxKeys === 'number') {
	    maxKeys = options.maxKeys;
	  }
	
	  var len = qs.length;
	  // maxKeys <= 0 means that we should not limit keys count
	  if (maxKeys > 0 && len > maxKeys) {
	    len = maxKeys;
	  }
	
	  for (var i = 0; i < len; ++i) {
	    var x = qs[i].replace(regexp, '%20'),
	        idx = x.indexOf(eq),
	        kstr, vstr, k, v;
	
	    if (idx >= 0) {
	      kstr = x.substr(0, idx);
	      vstr = x.substr(idx + 1);
	    } else {
	      kstr = x;
	      vstr = '';
	    }
	
	    k = decodeURIComponent(kstr);
	    v = decodeURIComponent(vstr);
	
	    if (!hasOwnProperty(obj, k)) {
	      obj[k] = v;
	    } else if (Array.isArray(obj[k])) {
	      obj[k].push(v);
	    } else {
	      obj[k] = [obj[k], v];
	    }
	  }
	
	  return obj;
	};


/***/ }),
/* 68 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	var stringifyPrimitive = function(v) {
	  switch (typeof v) {
	    case 'string':
	      return v;
	
	    case 'boolean':
	      return v ? 'true' : 'false';
	
	    case 'number':
	      return isFinite(v) ? v : '';
	
	    default:
	      return '';
	  }
	};
	
	module.exports = function(obj, sep, eq, name) {
	  sep = sep || '&';
	  eq = eq || '=';
	  if (obj === null) {
	    obj = undefined;
	  }
	
	  if (typeof obj === 'object') {
	    return Object.keys(obj).map(function(k) {
	      var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
	      if (Array.isArray(obj[k])) {
	        return obj[k].map(function(v) {
	          return ks + encodeURIComponent(stringifyPrimitive(v));
	        }).join(sep);
	      } else {
	        return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
	      }
	    }).join(sep);
	
	  }
	
	  if (!name) return '';
	  return encodeURIComponent(stringifyPrimitive(name)) + eq +
	         encodeURIComponent(stringifyPrimitive(obj));
	};


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	var net = __webpack_require__(70)
	
	/*
	  variables port and host can be removed since
	  you have all required information in opts object
	*/
	function buildBuilder (client, opts) {
	  var port, host
	  opts.port = opts.port || 1883
	  opts.hostname = opts.hostname || opts.host || 'localhost'
	
	  port = opts.port
	  host = opts.hostname
	
	  return net.createConnection(port, host)
	}
	
	module.exports = buildBuilder


/***/ }),
/* 70 */
/***/ (function(module, exports) {

	/* (ignored) */

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	var tls = __webpack_require__(72)
	
	function buildBuilder (mqttClient, opts) {
	  var connection
	  opts.port = opts.port || 8883
	  opts.host = opts.hostname || opts.host || 'localhost'
	
	  opts.rejectUnauthorized = opts.rejectUnauthorized !== false
	
	  connection = tls.connect(opts)
	  /* eslint no-use-before-define: [2, "nofunc"] */
	  connection.on('secureConnect', function () {
	    if (opts.rejectUnauthorized && !connection.authorized) {
	      connection.emit('error', new Error('TLS not authorized'))
	    } else {
	      connection.removeListener('error', handleTLSerrors)
	    }
	  })
	
	  function handleTLSerrors (err) {
	    // How can I get verify this error is a tls error?
	    if (opts.rejectUnauthorized) {
	      mqttClient.emit('error', err)
	    }
	
	    // close this connection to match the behaviour of net
	    // otherwise all we get is an error from the connection
	    // and close event doesn't fire. This is a work around
	    // to enable the reconnect code to work the same as with
	    // net.createConnection
	    connection.end()
	  }
	
	  connection.on('error', handleTLSerrors)
	  return connection
	}
	
	module.exports = buildBuilder


/***/ }),
/* 72 */
/***/ (function(module, exports) {

	/* (ignored) */

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict'
	
	/* global wx */
	var socketOpen = false
	var socketMsgQueue = []
	
	function sendSocketMessage (msg) {
	  if (socketOpen) {
	    wx.sendSocketMessage({
	      data: msg
	    })
	  } else {
	    socketMsgQueue.push(msg)
	  }
	}
	
	function WebSocket (url, protocols) {
	  console.log('creating WebSocket...', arguments)
	
	  var ws = {
	    OPEN: 1,
	    CLOSING: 2,
	    CLOSED: 3,
	    readyState: socketOpen ? 1 : 0,
	    send: sendSocketMessage,
	    close: wx.closeSocket,
	    onopen: null,
	    onmessage: null,
	    onclose: null,
	    onerror: null
	  }
	
	  wx.connectSocket({
	    url: url,
	    protocols: protocols
	  })
	  wx.onSocketOpen(function (res) {
	    ws.readyState = ws.OPEN
	    socketOpen = true
	    for (var i = 0; i < socketMsgQueue.length; i++) {
	      sendSocketMessage(socketMsgQueue[i])
	    }
	    socketMsgQueue = []
	
	    ws.onopen && ws.onopen.apply(ws, arguments)
	  })
	  wx.onSocketMessage(function (res) {
	    ws.onmessage && ws.onmessage.apply(ws, arguments)
	  })
	  wx.onSocketClose(function () {
	    ws.readyState = ws.CLOSED
	    ws.onclose && ws.onclose.apply(ws, arguments)
	  })
	  wx.onSocketError(function () {
	    ws.onerror && ws.onerror.apply(ws, arguments)
	  })
	
	  return ws
	}
	
	var websocket = __webpack_require__(74)
	var urlModule = __webpack_require__(62)
	
	function buildUrl (opts, client) {
	  var protocol = opts.protocol === 'wxs' ? 'wss' : 'ws'
	  var url = protocol + '://' + opts.hostname + ':' + opts.port + opts.path
	  if (typeof (opts.transformWsUrl) === 'function') {
	    url = opts.transformWsUrl(url, opts, client)
	  }
	  return url
	}
	
	function setDefaultOpts (opts) {
	  if (!opts.hostname) {
	    opts.hostname = 'localhost'
	  }
	  if (!opts.port) {
	    if (opts.protocol === 'wss') {
	      opts.port = 443
	    } else {
	      opts.port = 80
	    }
	  }
	  if (!opts.path) {
	    opts.path = '/'
	  }
	
	  if (!opts.wsOptions) {
	    opts.wsOptions = {}
	  }
	}
	
	function createWebSocket (client, opts) {
	  var websocketSubProtocol =
	    (opts.protocolId === 'MQIsdp') && (opts.protocolVersion === 3)
	      ? 'mqttv3.1'
	      : 'mqtt'
	
	  setDefaultOpts(opts)
	  var url = buildUrl(opts, client)
	  return websocket(WebSocket(url, [websocketSubProtocol]))
	}
	
	function buildBuilder (client, opts) {
	  if (!opts.hostname) {
	    opts.hostname = opts.host
	  }
	
	  if (!opts.hostname) {
	    // Throwing an error in a Web Worker if no `hostname` is given, because we
	    // can not determine the `hostname` automatically.  If connecting to
	    // localhost, please supply the `hostname` as an argument.
	    if (typeof (document) === 'undefined') {
	      throw new Error('Could not determine host. Specify host manually.')
	    }
	    var parsed = urlModule.parse(document.URL)
	    opts.hostname = parsed.hostname
	
	    if (!opts.port) {
	      opts.port = parsed.port
	    }
	  }
	  return createWebSocket(client, opts)
	}
	
	module.exports = buildBuilder


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process, global) {'use strict'
	
	var Transform = __webpack_require__(21).Transform
	var duplexify = __webpack_require__(75)
	var WS = __webpack_require__(77)
	var Buffer = __webpack_require__(26).Buffer
	
	module.exports = WebSocketStream
	
	function buildProxy (options, socketWrite, socketEnd) {
	  var proxy = new Transform({
	    objectMode: options.objectMode
	  })
	
	  proxy._destroyed = false
	  proxy._write = socketWrite
	  proxy._flush = socketEnd
	
	  proxy.destroy = function(err) {
	    if (this._destroyed) return
	      this._destroyed = true
	
	    var self = this
	    process.nextTick(function() {
	      if (err)
	        self.emit('error', err)
	      self.emit('close')
	    })
	  }
	
	  return proxy
	}
	
	function WebSocketStream(target, protocols, options) {
	  var stream, socket
	
	  var isBrowser = process.title === 'browser'
	  var isNative = !!global.WebSocket
	  var socketWrite = isBrowser ? socketWriteBrowser : socketWriteNode
	
	  if (protocols && !Array.isArray(protocols) && 'object' === typeof protocols) {
	    // accept the "options" Object as the 2nd argument
	    options = protocols
	    protocols = null
	
	    if (typeof options.protocol === 'string' || Array.isArray(options.protocol)) {
	      protocols = options.protocol;
	    }
	  }
	
	  if (!options) options = {}
	
	  if (options.objectMode === undefined) {
	    options.objectMode = !(options.binary === true || options.binary === undefined)
	  }
	
	  var proxy = buildProxy(options, socketWrite, socketEnd)
	
	  if (!options.objectMode) {
	    proxy._writev = writev
	  }
	
	  // browser only: sets the maximum socket buffer size before throttling
	  var bufferSize = options.browserBufferSize || 1024 * 512
	
	  // browser only: how long to wait when throttling
	  var bufferTimeout = options.browserBufferTimeout || 1000
	
	  // use existing WebSocket object that was passed in
	  if (typeof target === 'object') {
	    socket = target
	  // otherwise make a new one
	  } else {
	    // special constructor treatment for native websockets in browsers, see
	    // https://github.com/maxogden/websocket-stream/issues/82
	    if (isNative && isBrowser) {
	      socket = new WS(target, protocols)
	    } else {
	      socket = new WS(target, protocols, options)
	    }
	
	    socket.binaryType = 'arraybuffer'
	  }
	
	  // was already open when passed in
	  if (socket.readyState === socket.OPEN) {
	    stream = proxy
	  } else {
	    stream = duplexify.obj()
	    socket.onopen = onopen
	  }
	
	  stream.socket = socket
	
	  socket.onclose = onclose
	  socket.onerror = onerror
	  socket.onmessage = onmessage
	
	  proxy.on('close', destroy)
	
	  var coerceToBuffer = !options.objectMode
	
	  function socketWriteNode(chunk, enc, next) {
	    // avoid errors, this never happens unless
	    // destroy() is called
	    if (socket.readyState !== socket.OPEN) {
	      next()
	      return
	    }
	
	    if (coerceToBuffer && typeof chunk === 'string') {
	      chunk = new Buffer(chunk, 'utf8')
	    }
	    socket.send(chunk, next)
	  }
	
	  function socketWriteBrowser(chunk, enc, next) {
	    if (socket.bufferedAmount > bufferSize) {
	      setTimeout(socketWriteBrowser, bufferTimeout, chunk, enc, next)
	      return
	    }
	
	    if (coerceToBuffer && typeof chunk === 'string') {
	      chunk = new Buffer(chunk, 'utf8')
	    }
	
	    try {
	      socket.send(chunk)
	    } catch(err) {
	      return next(err)
	    }
	
	    next()
	  }
	
	  function socketEnd(done) {
	    socket.close()
	    done()
	  }
	
	  function onopen() {
	    stream.setReadable(proxy)
	    stream.setWritable(proxy)
	    stream.emit('connect')
	  }
	
	  function onclose() {
	    stream.end()
	    stream.destroy()
	  }
	
	  function onerror(err) {
	    stream.destroy(err)
	  }
	
	  function onmessage(event) {
	    var data = event.data
	    if (data instanceof ArrayBuffer) data = Buffer.from(new Uint8Array(data))
	    else data = Buffer.from(data, 'utf8')
	    proxy.push(data)
	  }
	
	  function destroy() {
	    socket.close()
	  }
	
	  // this is to be enabled only if objectMode is false
	  function writev (chunks, cb) {
	    var buffers = new Array(chunks.length)
	    for (var i = 0; i < chunks.length; i++) {
	      if (typeof chunks[i].chunk === 'string') {
	        buffers[i] = Buffer.from(chunks[i], 'utf8')
	      } else {
	        buffers[i] = chunks[i].chunk
	      }
	    }
	
	    this._write(Buffer.concat(buffers), 'binary', cb)
	  }
	
	  return stream
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17), (function() { return this; }())))

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, process) {var stream = __webpack_require__(21)
	var eos = __webpack_require__(44)
	var inherits = __webpack_require__(31)
	var shift = __webpack_require__(76)
	
	var SIGNAL_FLUSH = new Buffer([0])
	
	var onuncork = function(self, fn) {
	  if (self._corked) self.once('uncork', fn)
	  else fn()
	}
	
	var destroyer = function(self, end) {
	  return function(err) {
	    if (err) self.destroy(err.message === 'premature close' ? null : err)
	    else if (end && !self._ended) self.end()
	  }
	}
	
	var end = function(ws, fn) {
	  if (!ws) return fn()
	  if (ws._writableState && ws._writableState.finished) return fn()
	  if (ws._writableState) return ws.end(fn)
	  ws.end()
	  fn()
	}
	
	var toStreams2 = function(rs) {
	  return new (stream.Readable)({objectMode:true, highWaterMark:16}).wrap(rs)
	}
	
	var Duplexify = function(writable, readable, opts) {
	  if (!(this instanceof Duplexify)) return new Duplexify(writable, readable, opts)
	  stream.Duplex.call(this, opts)
	
	  this._writable = null
	  this._readable = null
	  this._readable2 = null
	
	  this._forwardDestroy = !opts || opts.destroy !== false
	  this._forwardEnd = !opts || opts.end !== false
	  this._corked = 1 // start corked
	  this._ondrain = null
	  this._drained = false
	  this._forwarding = false
	  this._unwrite = null
	  this._unread = null
	  this._ended = false
	
	  this.destroyed = false
	
	  if (writable) this.setWritable(writable)
	  if (readable) this.setReadable(readable)
	}
	
	inherits(Duplexify, stream.Duplex)
	
	Duplexify.obj = function(writable, readable, opts) {
	  if (!opts) opts = {}
	  opts.objectMode = true
	  opts.highWaterMark = 16
	  return new Duplexify(writable, readable, opts)
	}
	
	Duplexify.prototype.cork = function() {
	  if (++this._corked === 1) this.emit('cork')
	}
	
	Duplexify.prototype.uncork = function() {
	  if (this._corked && --this._corked === 0) this.emit('uncork')
	}
	
	Duplexify.prototype.setWritable = function(writable) {
	  if (this._unwrite) this._unwrite()
	
	  if (this.destroyed) {
	    if (writable && writable.destroy) writable.destroy()
	    return
	  }
	
	  if (writable === null || writable === false) {
	    this.end()
	    return
	  }
	
	  var self = this
	  var unend = eos(writable, {writable:true, readable:false}, destroyer(this, this._forwardEnd))
	
	  var ondrain = function() {
	    var ondrain = self._ondrain
	    self._ondrain = null
	    if (ondrain) ondrain()
	  }
	
	  var clear = function() {
	    self._writable.removeListener('drain', ondrain)
	    unend()
	  }
	
	  if (this._unwrite) process.nextTick(ondrain) // force a drain on stream reset to avoid livelocks
	
	  this._writable = writable
	  this._writable.on('drain', ondrain)
	  this._unwrite = clear
	
	  this.uncork() // always uncork setWritable
	}
	
	Duplexify.prototype.setReadable = function(readable) {
	  if (this._unread) this._unread()
	
	  if (this.destroyed) {
	    if (readable && readable.destroy) readable.destroy()
	    return
	  }
	
	  if (readable === null || readable === false) {
	    this.push(null)
	    this.resume()
	    return
	  }
	
	  var self = this
	  var unend = eos(readable, {writable:false, readable:true}, destroyer(this))
	
	  var onreadable = function() {
	    self._forward()
	  }
	
	  var onend = function() {
	    self.push(null)
	  }
	
	  var clear = function() {
	    self._readable2.removeListener('readable', onreadable)
	    self._readable2.removeListener('end', onend)
	    unend()
	  }
	
	  this._drained = true
	  this._readable = readable
	  this._readable2 = readable._readableState ? readable : toStreams2(readable)
	  this._readable2.on('readable', onreadable)
	  this._readable2.on('end', onend)
	  this._unread = clear
	
	  this._forward()
	}
	
	Duplexify.prototype._read = function() {
	  this._drained = true
	  this._forward()
	}
	
	Duplexify.prototype._forward = function() {
	  if (this._forwarding || !this._readable2 || !this._drained) return
	  this._forwarding = true
	
	  var data
	
	  while (this._drained && (data = shift(this._readable2)) !== null) {
	    if (this.destroyed) continue
	    this._drained = this.push(data)
	  }
	
	  this._forwarding = false
	}
	
	Duplexify.prototype.destroy = function(err) {
	  if (this.destroyed) return
	  this.destroyed = true
	
	  var self = this
	  process.nextTick(function() {
	    self._destroy(err)
	  })
	}
	
	Duplexify.prototype._destroy = function(err) {
	  if (err) {
	    var ondrain = this._ondrain
	    this._ondrain = null
	    if (ondrain) ondrain(err)
	    else this.emit('error', err)
	  }
	
	  if (this._forwardDestroy) {
	    if (this._readable && this._readable.destroy) this._readable.destroy()
	    if (this._writable && this._writable.destroy) this._writable.destroy()
	  }
	
	  this.emit('close')
	}
	
	Duplexify.prototype._write = function(data, enc, cb) {
	  if (this.destroyed) return cb()
	  if (this._corked) return onuncork(this, this._write.bind(this, data, enc, cb))
	  if (data === SIGNAL_FLUSH) return this._finish(cb)
	  if (!this._writable) return cb()
	
	  if (this._writable.write(data) === false) this._ondrain = cb
	  else cb()
	}
	
	
	Duplexify.prototype._finish = function(cb) {
	  var self = this
	  this.emit('preend')
	  onuncork(this, function() {
	    end(self._forwardEnd && self._writable, function() {
	      // haxx to not emit prefinish twice
	      if (self._writableState.prefinished === false) self._writableState.prefinished = true
	      self.emit('prefinish')
	      onuncork(self, cb)
	    })
	  })
	}
	
	Duplexify.prototype.end = function(data, enc, cb) {
	  if (typeof data === 'function') return this.end(null, null, data)
	  if (typeof enc === 'function') return this.end(data, null, enc)
	  this._ended = true
	  if (data) this.write(data)
	  if (!this._writableState.ending) this.write(SIGNAL_FLUSH)
	  return stream.Writable.prototype.end.call(this, cb)
	}
	
	module.exports = Duplexify
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(27).Buffer, __webpack_require__(17)))

/***/ }),
/* 76 */
/***/ (function(module, exports) {

	module.exports = shift
	
	function shift (stream) {
	  var rs = stream._readableState
	  if (!rs) return null
	  return rs.objectMode ? stream.read() : stream.read(getStateLength(rs))
	}
	
	function getStateLength (state) {
	  if (state.buffer.length) {
	    // Since node 6.3.0 state.buffer is a BufferList not an array
	    if (state.buffer.head) {
	      return state.buffer.head.data.length
	    }
	
	    return state.buffer[0].length
	  }
	
	  return state.length
	}


/***/ }),
/* 77 */
/***/ (function(module, exports) {

	
	var ws = null
	
	if (typeof WebSocket !== 'undefined') {
	  ws = WebSocket
	} else if (typeof MozWebSocket !== 'undefined') {
	  ws = MozWebSocket
	} else if (typeof window !== 'undefined') {
	  ws = window.WebSocket || window.MozWebSocket
	}
	
	module.exports = ws


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {'use strict'
	
	var websocket = __webpack_require__(74)
	var urlModule = __webpack_require__(62)
	var WSS_OPTIONS = [
	  'rejectUnauthorized',
	  'ca',
	  'cert',
	  'key',
	  'pfx',
	  'passphrase'
	]
	var IS_BROWSER = process.title === 'browser'
	
	function buildUrl (opts, client) {
	  var url = opts.protocol + '://' + opts.hostname + ':' + opts.port + opts.path
	  if (typeof (opts.transformWsUrl) === 'function') {
	    url = opts.transformWsUrl(url, opts, client)
	  }
	  return url
	}
	
	function setDefaultOpts (opts) {
	  if (!opts.hostname) {
	    opts.hostname = 'localhost'
	  }
	  if (!opts.port) {
	    if (opts.protocol === 'wss') {
	      opts.port = 443
	    } else {
	      opts.port = 80
	    }
	  }
	  if (!opts.path) {
	    opts.path = '/'
	  }
	
	  if (!opts.wsOptions) {
	    opts.wsOptions = {}
	  }
	  if (!IS_BROWSER && opts.protocol === 'wss') {
	    // Add cert/key/ca etc options
	    WSS_OPTIONS.forEach(function (prop) {
	      if (opts.hasOwnProperty(prop) && !opts.wsOptions.hasOwnProperty(prop)) {
	        opts.wsOptions[prop] = opts[prop]
	      }
	    })
	  }
	}
	
	function createWebSocket (client, opts) {
	  var websocketSubProtocol =
	    (opts.protocolId === 'MQIsdp') && (opts.protocolVersion === 3)
	      ? 'mqttv3.1'
	      : 'mqtt'
	
	  setDefaultOpts(opts)
	  var url = buildUrl(opts, client)
	  return websocket(url, [websocketSubProtocol], opts.wsOptions)
	}
	
	function buildBuilder (client, opts) {
	  return createWebSocket(client, opts)
	}
	
	function buildBuilderBrowser (client, opts) {
	  if (!opts.hostname) {
	    opts.hostname = opts.host
	  }
	
	  if (!opts.hostname) {
	    // Throwing an error in a Web Worker if no `hostname` is given, because we
	    // can not determine the `hostname` automatically.  If connecting to
	    // localhost, please supply the `hostname` as an argument.
	    if (typeof (document) === 'undefined') {
	      throw new Error('Could not determine host. Specify host manually.')
	    }
	    var parsed = urlModule.parse(document.URL)
	    opts.hostname = parsed.hostname
	
	    if (!opts.port) {
	      opts.port = parsed.port
	    }
	  }
	  return createWebSocket(client, opts)
	}
	
	if (IS_BROWSER) {
	  module.exports = buildBuilderBrowser
	} else {
	  module.exports = buildBuilder
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

/***/ }),
/* 79 */
/***/ (function(module, exports) {

	module.exports = {"name":"jupyter-webrtc","version":"0.3.0","description":"WebRTC for Jupyter notebook/lab","author":"Maarten Breddels","main":"src/index.js","repository":{"type":"git","url":"https://github.com/maartenbreddels/ipywebrtc.git"},"keywords":["jupyter","widgets","ipython","ipywidgets"],"scripts":{"prepublish":"webpack","test":"echo \"Error: no test specified\" && exit 1"},"devDependencies":{"json-loader":"^0.5.4","webpack":"^1.12.14"},"dependencies":{"@jupyter-widgets/base":"^0.6.4","mqtt":"^2.11.0","underscore":"^1.8.3","webrtc-adapter":"^4.2.2"}}

/***/ })
/******/ ])});;
//# sourceMappingURL=index.js.map