// Autogenerated by tools\build\make_containers.py
// from tools\build\container_templates\kernel\ClassnameModifier.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/TripletModifier.h
 *  \brief A Modifier on ParticleTripletsTemp
 *
 *  Copyright 2007-2022 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_TRIPLET_MODIFIER_H
#define IMPKERNEL_TRIPLET_MODIFIER_H

#include <IMP/kernel_config.h>
#include "DerivativeAccumulator.h"
#include "base_types.h"
#include "internal/container_helpers.h"
#include "model_object_helpers.h"

IMPKERNEL_BEGIN_NAMESPACE

//! A base class for modifiers of ParticleTripletsTemp
/** The primary function of such a class is to change
    the passed particles.

    \see IMP::TripletPredicate

    Implementers should see IMP_TRIPLET_MODIFIER(). Also see
    TripletDerivativeModifier.
 */
class IMPKERNELEXPORT TripletModifier : public ParticleInputs,
                                          public ParticleOutputs,
                                          public Object {
 public:
  typedef ParticleTriplet Argument;
  typedef ParticleIndexTriplet IndexArgument;
  TripletModifier(std::string name = "TripletModifier %1%");

  /** Apply the function to a single value*/
  virtual void apply_index(Model *m, const ParticleIndexTriplet& v) const = 0;

  /** Apply the function to a collection of ParticleTripletsTemp */
  /** If bounds are passed, only apply to ones between the upper and
      lower bounds.*/
  virtual void apply_indexes(Model *m, const ParticleIndexTriplets &o,
                             unsigned int lower_bound,
                             unsigned int upper_bound) const {
    for (unsigned int i = lower_bound; i < upper_bound; ++i) {
      apply_index(m, o[i]);
    }
  }

  /** Apply the function to a collection of ParticleTripletsTemp */
  /** Information on particles that moved since the last scoring function
      evaluation is also passed, which may be used to accelerate the
      computation. */
  virtual void apply_indexes_moved(
              Model *m, const ParticleIndexTriplets &o,
              unsigned int lower_bound, unsigned int upper_bound,
              const ParticleIndexes &moved_pis,
              const ParticleIndexes &reset_pis) const {
    IMP_UNUSED(moved_pis);
    IMP_UNUSED(reset_pis);
    apply_indexes(m, o, lower_bound, upper_bound);
  }
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_TRIPLET_MODIFIER_H */
