# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


# This wrapper is part of IMP,
# Copyright 2007-2022 IMP Inventors. All rights reserved.

from __future__ import print_function, division, absolute_import



from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

import _IMP_isd

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class IMP_ISD_SwigPyIterator(object):
    r"""Proxy of C++ swig::IMP_ISD_SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_isd.delete_IMP_ISD_SwigPyIterator

    def value(self):
        r"""value(IMP_ISD_SwigPyIterator self) -> PyObject *"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(IMP_ISD_SwigPyIterator self, size_t n=1) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(IMP_ISD_SwigPyIterator self, size_t n=1) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(IMP_ISD_SwigPyIterator self, IMP_ISD_SwigPyIterator x) -> ptrdiff_t"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(IMP_ISD_SwigPyIterator self, IMP_ISD_SwigPyIterator x) -> bool"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(IMP_ISD_SwigPyIterator self) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_copy(self)

    def next(self):
        r"""next(IMP_ISD_SwigPyIterator self) -> PyObject *"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(IMP_ISD_SwigPyIterator self) -> PyObject *"""
        return _IMP_isd.IMP_ISD_SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(IMP_ISD_SwigPyIterator self) -> PyObject *"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(IMP_ISD_SwigPyIterator self, ptrdiff_t n) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(IMP_ISD_SwigPyIterator self, IMP_ISD_SwigPyIterator x) -> bool"""
        return _IMP_isd.IMP_ISD_SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(IMP_ISD_SwigPyIterator self, IMP_ISD_SwigPyIterator x) -> bool"""
        return _IMP_isd.IMP_ISD_SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(IMP_ISD_SwigPyIterator self, ptrdiff_t n) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(IMP_ISD_SwigPyIterator self, ptrdiff_t n) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(IMP_ISD_SwigPyIterator self, ptrdiff_t n) -> IMP_ISD_SwigPyIterator"""
        return _IMP_isd.IMP_ISD_SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(IMP_ISD_SwigPyIterator self, ptrdiff_t n) -> IMP_ISD_SwigPyIterator
        __sub__(IMP_ISD_SwigPyIterator self, IMP_ISD_SwigPyIterator x) -> ptrdiff_t
        """
        return _IMP_isd.IMP_ISD_SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register IMP_ISD_SwigPyIterator in _IMP_isd:
_IMP_isd.IMP_ISD_SwigPyIterator_swigregister(IMP_ISD_SwigPyIterator)


_value_types=[]
_object_types=[]
_raii_types=[]
_plural_types=[]

IMP_DEBUG = _IMP_isd.IMP_DEBUG

IMP_RELEASE = _IMP_isd.IMP_RELEASE

IMP_SILENT = _IMP_isd.IMP_SILENT

IMP_PROGRESS = _IMP_isd.IMP_PROGRESS

IMP_TERSE = _IMP_isd.IMP_TERSE

IMP_VERBOSE = _IMP_isd.IMP_VERBOSE

IMP_MEMORY = _IMP_isd.IMP_MEMORY

IMP_NONE = _IMP_isd.IMP_NONE

IMP_USAGE = _IMP_isd.IMP_USAGE

IMP_INTERNAL = _IMP_isd.IMP_INTERNAL

IMP_KERNEL_HAS_LOG4CXX = _IMP_isd.IMP_KERNEL_HAS_LOG4CXX

IMP_COMPILER_HAS_DEBUG_VECTOR = _IMP_isd.IMP_COMPILER_HAS_DEBUG_VECTOR

IMP_COMPILER_HAS_RANDOM_SHUFFLE = _IMP_isd.IMP_COMPILER_HAS_RANDOM_SHUFFLE

IMP_COMPILER_HAS_THREE_WAY = _IMP_isd.IMP_COMPILER_HAS_THREE_WAY

IMP_KERNEL_HAS_BOOST_RANDOM = _IMP_isd.IMP_KERNEL_HAS_BOOST_RANDOM

IMP_KERNEL_HAS_NUMPY = _IMP_isd.IMP_KERNEL_HAS_NUMPY

IMP_KERNEL_HAS_GPERFTOOLS = _IMP_isd.IMP_KERNEL_HAS_GPERFTOOLS

IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER = _IMP_isd.IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER

IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER = _IMP_isd.IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER

IMPKERNEL_SHOW_WARNINGS = _IMP_isd.IMPKERNEL_SHOW_WARNINGS


import sys
class _DirectorObjects(object):
    """@internal Simple class to keep references to director objects
       to prevent premature deletion."""
    def __init__(self):
        self._objects = []
    def register(self, obj):
        """Take a reference to a director object; will only work for
           refcounted C++ classes"""
        if hasattr(obj, 'get_ref_count'):
            self._objects.append(obj)
    def cleanup(self):
        """Only drop our reference and allow cleanup by Python if no other
           Python references exist (we hold 3 references: one in self._objects,
           one in x, and one in the argument list for getrefcount) *and* no
           other C++ references exist (the Python object always holds one)"""
        objs = [x for x in self._objects if sys.getrefcount(x) > 3 \
                                         or x.get_ref_count() > 1]
# Do in two steps so the references are kept until the end of the
# function (deleting references may trigger a fresh call to this method)
        self._objects = objs
    def get_object_count(self):
        """Get number of director objects (useful for testing only)"""
        return len(self._objects)
_director_objects = _DirectorObjects()

class _ostream(object):
    r"""Proxy of C++ std::ostream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def write(self, osa_buf):
        r"""write(_ostream self, char const * osa_buf)"""
        return _IMP_isd._ostream_write(self, osa_buf)

# Register _ostream in _IMP_isd:
_IMP_isd._ostream_swigregister(_ostream)

IMP_HAS_NOEXCEPT = _IMP_isd.IMP_HAS_NOEXCEPT

IMP_C_OPEN_BINARY = _IMP_isd.IMP_C_OPEN_BINARY

import IMP
IMP_CGAL_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_CGAL_HAS_BOOST_FILESYSTEM

IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS

IMP_CGAL_HAS_BOOST_RANDOM = _IMP_isd.IMP_CGAL_HAS_BOOST_RANDOM

IMP_CGAL_HAS_BOOST_SYSTEM = _IMP_isd.IMP_CGAL_HAS_BOOST_SYSTEM

IMP_CGAL_HAS_NUMPY = _IMP_isd.IMP_CGAL_HAS_NUMPY

IMPCGAL_SHOW_WARNINGS = _IMP_isd.IMPCGAL_SHOW_WARNINGS

import IMP.cgal
IMP_ALGEBRA_HAS_IMP_CGAL = _IMP_isd.IMP_ALGEBRA_HAS_IMP_CGAL

IMP_ALGEBRA_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_ALGEBRA_HAS_BOOST_FILESYSTEM

IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS

IMP_ALGEBRA_HAS_BOOST_RANDOM = _IMP_isd.IMP_ALGEBRA_HAS_BOOST_RANDOM

IMP_ALGEBRA_HAS_BOOST_SYSTEM = _IMP_isd.IMP_ALGEBRA_HAS_BOOST_SYSTEM

IMP_ALGEBRA_HAS_CGAL = _IMP_isd.IMP_ALGEBRA_HAS_CGAL

IMP_ALGEBRA_HAS_NUMPY = _IMP_isd.IMP_ALGEBRA_HAS_NUMPY

IMP_ALGEBRA_HAS_ANN = _IMP_isd.IMP_ALGEBRA_HAS_ANN

IMPALGEBRA_SHOW_WARNINGS = _IMP_isd.IMPALGEBRA_SHOW_WARNINGS

import IMP.algebra
IMP_DISPLAY_HAS_IMP_CGAL = _IMP_isd.IMP_DISPLAY_HAS_IMP_CGAL

IMP_DISPLAY_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_DISPLAY_HAS_BOOST_FILESYSTEM

IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS

IMP_DISPLAY_HAS_BOOST_RANDOM = _IMP_isd.IMP_DISPLAY_HAS_BOOST_RANDOM

IMP_DISPLAY_HAS_BOOST_SYSTEM = _IMP_isd.IMP_DISPLAY_HAS_BOOST_SYSTEM

IMP_DISPLAY_HAS_CGAL = _IMP_isd.IMP_DISPLAY_HAS_CGAL

IMP_DISPLAY_HAS_NUMPY = _IMP_isd.IMP_DISPLAY_HAS_NUMPY

IMPDISPLAY_SHOW_WARNINGS = _IMP_isd.IMPDISPLAY_SHOW_WARNINGS

import IMP.display
IMP_SCORE_FUNCTOR_HAS_IMP_CGAL = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_IMP_CGAL

IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM

IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS

IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM

IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM

IMP_SCORE_FUNCTOR_HAS_CGAL = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_CGAL

IMP_SCORE_FUNCTOR_HAS_HDF5 = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_HDF5

IMP_SCORE_FUNCTOR_HAS_NUMPY = _IMP_isd.IMP_SCORE_FUNCTOR_HAS_NUMPY

IMPSCOREFUNCTOR_SHOW_WARNINGS = _IMP_isd.IMPSCOREFUNCTOR_SHOW_WARNINGS

import IMP.score_functor
IMP_STATISTICS_HAS_IMP_CGAL = _IMP_isd.IMP_STATISTICS_HAS_IMP_CGAL

IMP_STATISTICS_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_STATISTICS_HAS_BOOST_FILESYSTEM

IMP_STATISTICS_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_STATISTICS_HAS_BOOST_PROGRAMOPTIONS

IMP_STATISTICS_HAS_BOOST_RANDOM = _IMP_isd.IMP_STATISTICS_HAS_BOOST_RANDOM

IMP_STATISTICS_HAS_BOOST_SYSTEM = _IMP_isd.IMP_STATISTICS_HAS_BOOST_SYSTEM

IMP_STATISTICS_HAS_CGAL = _IMP_isd.IMP_STATISTICS_HAS_CGAL

IMP_STATISTICS_HAS_NUMPY = _IMP_isd.IMP_STATISTICS_HAS_NUMPY

IMPSTATISTICS_SHOW_WARNINGS = _IMP_isd.IMPSTATISTICS_SHOW_WARNINGS

import IMP.statistics
IMP_CORE_HAS_IMP_CGAL = _IMP_isd.IMP_CORE_HAS_IMP_CGAL

IMP_CORE_HAS_IMP_KERNEL = _IMP_isd.IMP_CORE_HAS_IMP_KERNEL

IMP_CORE_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_CORE_HAS_BOOST_FILESYSTEM

IMP_CORE_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_CORE_HAS_BOOST_PROGRAMOPTIONS

IMP_CORE_HAS_BOOST_RANDOM = _IMP_isd.IMP_CORE_HAS_BOOST_RANDOM

IMP_CORE_HAS_BOOST_SYSTEM = _IMP_isd.IMP_CORE_HAS_BOOST_SYSTEM

IMP_CORE_HAS_CGAL = _IMP_isd.IMP_CORE_HAS_CGAL

IMP_CORE_HAS_HDF5 = _IMP_isd.IMP_CORE_HAS_HDF5

IMP_CORE_HAS_NUMPY = _IMP_isd.IMP_CORE_HAS_NUMPY

IMPCORE_SHOW_WARNINGS = _IMP_isd.IMPCORE_SHOW_WARNINGS

import IMP.core
IMP_CONTAINER_HAS_IMP_ALGEBRA = _IMP_isd.IMP_CONTAINER_HAS_IMP_ALGEBRA

IMP_CONTAINER_HAS_IMP_CGAL = _IMP_isd.IMP_CONTAINER_HAS_IMP_CGAL

IMP_CONTAINER_HAS_IMP_DISPLAY = _IMP_isd.IMP_CONTAINER_HAS_IMP_DISPLAY

IMP_CONTAINER_HAS_IMP_KERNEL = _IMP_isd.IMP_CONTAINER_HAS_IMP_KERNEL

IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR = _IMP_isd.IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR

IMP_CONTAINER_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_CONTAINER_HAS_BOOST_FILESYSTEM

IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS

IMP_CONTAINER_HAS_BOOST_RANDOM = _IMP_isd.IMP_CONTAINER_HAS_BOOST_RANDOM

IMP_CONTAINER_HAS_BOOST_SYSTEM = _IMP_isd.IMP_CONTAINER_HAS_BOOST_SYSTEM

IMP_CONTAINER_HAS_CGAL = _IMP_isd.IMP_CONTAINER_HAS_CGAL

IMP_CONTAINER_HAS_HDF5 = _IMP_isd.IMP_CONTAINER_HAS_HDF5

IMP_CONTAINER_HAS_NUMPY = _IMP_isd.IMP_CONTAINER_HAS_NUMPY

IMP_CONTAINER_HAS_PYTHON_IHM = _IMP_isd.IMP_CONTAINER_HAS_PYTHON_IHM

IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP = _IMP_isd.IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP

IMP_CONTAINER_HAS_ROBIN_MAP = _IMP_isd.IMP_CONTAINER_HAS_ROBIN_MAP

IMPCONTAINER_SHOW_WARNINGS = _IMP_isd.IMPCONTAINER_SHOW_WARNINGS

import IMP.container
IMP_ATOM_HAS_IMP_CGAL = _IMP_isd.IMP_ATOM_HAS_IMP_CGAL

IMP_ATOM_HAS_IMP_KERNEL = _IMP_isd.IMP_ATOM_HAS_IMP_KERNEL

IMP_ATOM_HAS_IMP_SCORE_FUNCTOR = _IMP_isd.IMP_ATOM_HAS_IMP_SCORE_FUNCTOR

IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS

IMP_ATOM_HAS_BOOST_RANDOM = _IMP_isd.IMP_ATOM_HAS_BOOST_RANDOM

IMP_ATOM_HAS_BOOST_REGEX = _IMP_isd.IMP_ATOM_HAS_BOOST_REGEX

IMP_ATOM_HAS_BOOST_SYSTEM = _IMP_isd.IMP_ATOM_HAS_BOOST_SYSTEM

IMP_ATOM_HAS_CGAL = _IMP_isd.IMP_ATOM_HAS_CGAL

IMP_ATOM_HAS_HDF5 = _IMP_isd.IMP_ATOM_HAS_HDF5

IMP_ATOM_HAS_NUMPY = _IMP_isd.IMP_ATOM_HAS_NUMPY

IMP_ATOM_HAS_PYTHON_IHM = _IMP_isd.IMP_ATOM_HAS_PYTHON_IHM

IMPATOM_SHOW_WARNINGS = _IMP_isd.IMPATOM_SHOW_WARNINGS

IMP_ATOM_TYPE_INDEX = _IMP_isd.IMP_ATOM_TYPE_INDEX

IMP_RESIDUE_TYPE_INDEX = _IMP_isd.IMP_RESIDUE_TYPE_INDEX

IMP_HIERARCHY_TYPE_INDEX = _IMP_isd.IMP_HIERARCHY_TYPE_INDEX

IMP_CHAIN_TYPE_INDEX = _IMP_isd.IMP_CHAIN_TYPE_INDEX

import IMP.atom
IMP_EM_HAS_IMP_CGAL = _IMP_isd.IMP_EM_HAS_IMP_CGAL

IMP_EM_HAS_IMP_CONTAINER = _IMP_isd.IMP_EM_HAS_IMP_CONTAINER

IMP_EM_HAS_IMP_DISPLAY = _IMP_isd.IMP_EM_HAS_IMP_DISPLAY

IMP_EM_HAS_IMP_SCORE_FUNCTOR = _IMP_isd.IMP_EM_HAS_IMP_SCORE_FUNCTOR

IMP_EM_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_EM_HAS_BOOST_FILESYSTEM

IMP_EM_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_EM_HAS_BOOST_PROGRAMOPTIONS

IMP_EM_HAS_BOOST_RANDOM = _IMP_isd.IMP_EM_HAS_BOOST_RANDOM

IMP_EM_HAS_BOOST_REGEX = _IMP_isd.IMP_EM_HAS_BOOST_REGEX

IMP_EM_HAS_BOOST_SYSTEM = _IMP_isd.IMP_EM_HAS_BOOST_SYSTEM

IMP_EM_HAS_CGAL = _IMP_isd.IMP_EM_HAS_CGAL

IMP_EM_HAS_HDF5 = _IMP_isd.IMP_EM_HAS_HDF5

IMP_EM_HAS_NUMPY = _IMP_isd.IMP_EM_HAS_NUMPY

IMP_EM_HAS_PYTHON_IHM = _IMP_isd.IMP_EM_HAS_PYTHON_IHM

IMPEM_SHOW_WARNINGS = _IMP_isd.IMPEM_SHOW_WARNINGS

import IMP.em
IMP_SAXS_HAS_IMP_CGAL = _IMP_isd.IMP_SAXS_HAS_IMP_CGAL

IMP_SAXS_HAS_IMP_CONTAINER = _IMP_isd.IMP_SAXS_HAS_IMP_CONTAINER

IMP_SAXS_HAS_IMP_DISPLAY = _IMP_isd.IMP_SAXS_HAS_IMP_DISPLAY

IMP_SAXS_HAS_IMP_KERNEL = _IMP_isd.IMP_SAXS_HAS_IMP_KERNEL

IMP_SAXS_HAS_IMP_SCORE_FUNCTOR = _IMP_isd.IMP_SAXS_HAS_IMP_SCORE_FUNCTOR

IMP_SAXS_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_SAXS_HAS_BOOST_FILESYSTEM

IMP_SAXS_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_SAXS_HAS_BOOST_PROGRAMOPTIONS

IMP_SAXS_HAS_BOOST_RANDOM = _IMP_isd.IMP_SAXS_HAS_BOOST_RANDOM

IMP_SAXS_HAS_BOOST_REGEX = _IMP_isd.IMP_SAXS_HAS_BOOST_REGEX

IMP_SAXS_HAS_BOOST_SYSTEM = _IMP_isd.IMP_SAXS_HAS_BOOST_SYSTEM

IMP_SAXS_HAS_CGAL = _IMP_isd.IMP_SAXS_HAS_CGAL

IMP_SAXS_HAS_HDF5 = _IMP_isd.IMP_SAXS_HAS_HDF5

IMP_SAXS_HAS_NUMPY = _IMP_isd.IMP_SAXS_HAS_NUMPY

IMP_SAXS_HAS_PYTHON_IHM = _IMP_isd.IMP_SAXS_HAS_PYTHON_IHM

IMPSAXS_SHOW_WARNINGS = _IMP_isd.IMPSAXS_SHOW_WARNINGS

import IMP.saxs
IMP_ISD_HAS_IMP_CGAL = _IMP_isd.IMP_ISD_HAS_IMP_CGAL

IMP_ISD_HAS_IMP_DISPLAY = _IMP_isd.IMP_ISD_HAS_IMP_DISPLAY

IMP_ISD_HAS_IMP_SCORE_FUNCTOR = _IMP_isd.IMP_ISD_HAS_IMP_SCORE_FUNCTOR

IMP_ISD_HAS_BOOST_FILESYSTEM = _IMP_isd.IMP_ISD_HAS_BOOST_FILESYSTEM

IMP_ISD_HAS_BOOST_PROGRAMOPTIONS = _IMP_isd.IMP_ISD_HAS_BOOST_PROGRAMOPTIONS

IMP_ISD_HAS_BOOST_RANDOM = _IMP_isd.IMP_ISD_HAS_BOOST_RANDOM

IMP_ISD_HAS_BOOST_REGEX = _IMP_isd.IMP_ISD_HAS_BOOST_REGEX

IMP_ISD_HAS_BOOST_SYSTEM = _IMP_isd.IMP_ISD_HAS_BOOST_SYSTEM

IMP_ISD_HAS_CGAL = _IMP_isd.IMP_ISD_HAS_CGAL

IMP_ISD_HAS_HDF5 = _IMP_isd.IMP_ISD_HAS_HDF5

IMP_ISD_HAS_NUMPY = _IMP_isd.IMP_ISD_HAS_NUMPY

IMP_ISD_HAS_PYTHON_IHM = _IMP_isd.IMP_ISD_HAS_PYTHON_IHM

IMPISD_SHOW_WARNINGS = _IMP_isd.IMPISD_SHOW_WARNINGS


_object_types.append("ISDRestraint")


def _object_cast_to_ISDRestraint(o):
    r"""_object_cast_to_ISDRestraint(Object o) -> ISDRestraint"""
    return _IMP_isd._object_cast_to_ISDRestraint(o)

_object_types.append("CrossLinkMSRestraint")


def _object_cast_to_CrossLinkMSRestraint(o):
    r"""_object_cast_to_CrossLinkMSRestraint(Object o) -> CrossLinkMSRestraint"""
    return _IMP_isd._object_cast_to_CrossLinkMSRestraint(o)

_object_types.append("LogWrapper")


def _object_cast_to_LogWrapper(o):
    r"""_object_cast_to_LogWrapper(Object o) -> LogWrapper"""
    return _IMP_isd._object_cast_to_LogWrapper(o)

_object_types.append("UniformPrior")


def _object_cast_to_UniformPrior(o):
    r"""_object_cast_to_UniformPrior(Object o) -> UniformPrior"""
    return _IMP_isd._object_cast_to_UniformPrior(o)

_object_types.append("JeffreysRestraint")


def _object_cast_to_JeffreysRestraint(o):
    r"""_object_cast_to_JeffreysRestraint(Object o) -> JeffreysRestraint"""
    return _IMP_isd._object_cast_to_JeffreysRestraint(o)

_object_types.append("NormalSigmaPCRestraint")


def _object_cast_to_NormalSigmaPCRestraint(o):
    r"""_object_cast_to_NormalSigmaPCRestraint(Object o) -> NormalSigmaPCRestraint"""
    return _IMP_isd._object_cast_to_NormalSigmaPCRestraint(o)

_object_types.append("vonMisesKappaJeffreysRestraint")


def _object_cast_to_vonMisesKappaJeffreysRestraint(o):
    r"""_object_cast_to_vonMisesKappaJeffreysRestraint(Object o) -> vonMisesKappaJeffreysRestraint"""
    return _IMP_isd._object_cast_to_vonMisesKappaJeffreysRestraint(o)

_object_types.append("vonMisesKappaConjugateRestraint")


def _object_cast_to_vonMisesKappaConjugateRestraint(o):
    r"""_object_cast_to_vonMisesKappaConjugateRestraint(Object o) -> vonMisesKappaConjugateRestraint"""
    return _IMP_isd._object_cast_to_vonMisesKappaConjugateRestraint(o)

_object_types.append("Distribution")


def _object_cast_to_Distribution(o):
    r"""_object_cast_to_Distribution(Object o) -> Distribution"""
    return _IMP_isd._object_cast_to_Distribution(o)

_object_types.append("OneDimensionalDistribution")


def _object_cast_to_OneDimensionalDistribution(o):
    r"""_object_cast_to_OneDimensionalDistribution(Object o) -> OneDimensionalDistribution"""
    return _IMP_isd._object_cast_to_OneDimensionalDistribution(o)

_object_types.append("OneDimensionalSufficientDistribution")


def _object_cast_to_OneDimensionalSufficientDistribution(o):
    r"""_object_cast_to_OneDimensionalSufficientDistribution(Object o) -> OneDimensionalSufficientDistribution"""
    return _IMP_isd._object_cast_to_OneDimensionalSufficientDistribution(o)

_object_types.append("FNormal")


def _object_cast_to_FNormal(o):
    r"""_object_cast_to_FNormal(Object o) -> FNormal"""
    return _IMP_isd._object_cast_to_FNormal(o)

_object_types.append("FStudentT")


def _object_cast_to_FStudentT(o):
    r"""_object_cast_to_FStudentT(Object o) -> FStudentT"""
    return _IMP_isd._object_cast_to_FStudentT(o)

_object_types.append("vonMises")


def _object_cast_to_vonMises(o):
    r"""_object_cast_to_vonMises(Object o) -> vonMises"""
    return _IMP_isd._object_cast_to_vonMises(o)

_object_types.append("vonMisesSufficient")


def _object_cast_to_vonMisesSufficient(o):
    r"""_object_cast_to_vonMisesSufficient(Object o) -> vonMisesSufficient"""
    return _IMP_isd._object_cast_to_vonMisesSufficient(o)

_object_types.append("PenalizedComplexityPrior")


def _object_cast_to_PenalizedComplexityPrior(o):
    r"""_object_cast_to_PenalizedComplexityPrior(Object o) -> PenalizedComplexityPrior"""
    return _IMP_isd._object_cast_to_PenalizedComplexityPrior(o)

def Nuisances(l=[]):
    return [Nuisance(x) for x in l]
_plural_types.append("Nuisances")


_value_types.append("Nuisance")


def Scales(l=[]):
    return [Scale(x) for x in l]
_plural_types.append("Scales")


_value_types.append("Scale")


def Switchings(l=[]):
    return [Switching(x) for x in l]
_plural_types.append("Switchings")


_value_types.append("Switching")


_object_types.append("NOERestraint")


def _object_cast_to_NOERestraint(o):
    r"""_object_cast_to_NOERestraint(Object o) -> NOERestraint"""
    return _IMP_isd._object_cast_to_NOERestraint(o)

def Weights(l=[]):
    return [Weight(x) for x in l]
_plural_types.append("Weights")


_value_types.append("Weight")


_object_types.append("GaussianRestraint")


def _object_cast_to_GaussianRestraint(o):
    r"""_object_cast_to_GaussianRestraint(Object o) -> GaussianRestraint"""
    return _IMP_isd._object_cast_to_GaussianRestraint(o)

_object_types.append("StudentTRestraint")


def _object_cast_to_StudentTRestraint(o):
    r"""_object_cast_to_StudentTRestraint(Object o) -> StudentTRestraint"""
    return _IMP_isd._object_cast_to_StudentTRestraint(o)

_object_types.append("LognormalRestraint")


def _object_cast_to_LognormalRestraint(o):
    r"""_object_cast_to_LognormalRestraint(Object o) -> LognormalRestraint"""
    return _IMP_isd._object_cast_to_LognormalRestraint(o)

_object_types.append("LognormalAmbiguousRestraint")


def _object_cast_to_LognormalAmbiguousRestraint(o):
    r"""_object_cast_to_LognormalAmbiguousRestraint(Object o) -> LognormalAmbiguousRestraint"""
    return _IMP_isd._object_cast_to_LognormalAmbiguousRestraint(o)

_object_types.append("AmbiguousNOERestraint")


def _object_cast_to_AmbiguousNOERestraint(o):
    r"""_object_cast_to_AmbiguousNOERestraint(Object o) -> AmbiguousNOERestraint"""
    return _IMP_isd._object_cast_to_AmbiguousNOERestraint(o)

_object_types.append("MarginalNOERestraint")


def _object_cast_to_MarginalNOERestraint(o):
    r"""_object_cast_to_MarginalNOERestraint(Object o) -> MarginalNOERestraint"""
    return _IMP_isd._object_cast_to_MarginalNOERestraint(o)

_object_types.append("MarginalHBondRestraint")


def _object_cast_to_MarginalHBondRestraint(o):
    r"""_object_cast_to_MarginalHBondRestraint(Object o) -> MarginalHBondRestraint"""
    return _IMP_isd._object_cast_to_MarginalHBondRestraint(o)

_object_types.append("TALOSRestraint")


def _object_cast_to_TALOSRestraint(o):
    r"""_object_cast_to_TALOSRestraint(Object o) -> TALOSRestraint"""
    return _IMP_isd._object_cast_to_TALOSRestraint(o)

_object_types.append("RepulsiveDistancePairScore")


def _object_cast_to_RepulsiveDistancePairScore(o):
    r"""_object_cast_to_RepulsiveDistancePairScore(Object o) -> RepulsiveDistancePairScore"""
    return _IMP_isd._object_cast_to_RepulsiveDistancePairScore(o)

_object_types.append("AmbiguousRestraint")


def _object_cast_to_AmbiguousRestraint(o):
    r"""_object_cast_to_AmbiguousRestraint(Object o) -> AmbiguousRestraint"""
    return _IMP_isd._object_cast_to_AmbiguousRestraint(o)

_object_types.append("UnivariateFunction")


def _object_cast_to_UnivariateFunction(o):
    r"""_object_cast_to_UnivariateFunction(Object o) -> UnivariateFunction"""
    return _IMP_isd._object_cast_to_UnivariateFunction(o)

_object_types.append("Linear1DFunction")


def _object_cast_to_Linear1DFunction(o):
    r"""_object_cast_to_Linear1DFunction(Object o) -> Linear1DFunction"""
    return _IMP_isd._object_cast_to_Linear1DFunction(o)

_object_types.append("GeneralizedGuinierPorodFunction")


def _object_cast_to_GeneralizedGuinierPorodFunction(o):
    r"""_object_cast_to_GeneralizedGuinierPorodFunction(Object o) -> GeneralizedGuinierPorodFunction"""
    return _IMP_isd._object_cast_to_GeneralizedGuinierPorodFunction(o)

_object_types.append("BivariateFunction")


def _object_cast_to_BivariateFunction(o):
    r"""_object_cast_to_BivariateFunction(Object o) -> BivariateFunction"""
    return _IMP_isd._object_cast_to_BivariateFunction(o)

_object_types.append("Covariance1DFunction")


def _object_cast_to_Covariance1DFunction(o):
    r"""_object_cast_to_Covariance1DFunction(Object o) -> Covariance1DFunction"""
    return _IMP_isd._object_cast_to_Covariance1DFunction(o)

_object_types.append("GaussianProcessInterpolation")


def _object_cast_to_GaussianProcessInterpolation(o):
    r"""_object_cast_to_GaussianProcessInterpolation(Object o) -> GaussianProcessInterpolation"""
    return _IMP_isd._object_cast_to_GaussianProcessInterpolation(o)

_object_types.append("GaussianProcessInterpolationRestraint")


def _object_cast_to_GaussianProcessInterpolationRestraint(o):
    r"""_object_cast_to_GaussianProcessInterpolationRestraint(Object o) -> GaussianProcessInterpolationRestraint"""
    return _IMP_isd._object_cast_to_GaussianProcessInterpolationRestraint(o)

_object_types.append("MolecularDynamics")


_object_types.append("MolecularDynamicsMover")


def _object_cast_to_MolecularDynamicsMover(o):
    r"""_object_cast_to_MolecularDynamicsMover(Object o) -> MolecularDynamicsMover"""
    return _IMP_isd._object_cast_to_MolecularDynamicsMover(o)

_object_types.append("HybridMonteCarlo")


def _object_cast_to_HybridMonteCarlo(o):
    r"""_object_cast_to_HybridMonteCarlo(Object o) -> HybridMonteCarlo"""
    return _IMP_isd._object_cast_to_HybridMonteCarlo(o)

_object_types.append("FretData")


def _object_cast_to_FretData(o):
    r"""_object_cast_to_FretData(Object o) -> FretData"""
    return _IMP_isd._object_cast_to_FretData(o)

_object_types.append("FretRestraint")


def _object_cast_to_FretRestraint(o):
    r"""_object_cast_to_FretRestraint(Object o) -> FretRestraint"""
    return _IMP_isd._object_cast_to_FretRestraint(o)

_object_types.append("CrossLinkData")


def _object_cast_to_CrossLinkData(o):
    r"""_object_cast_to_CrossLinkData(Object o) -> CrossLinkData"""
    return _IMP_isd._object_cast_to_CrossLinkData(o)

_object_types.append("CysteineCrossLinkData")


def _object_cast_to_CysteineCrossLinkData(o):
    r"""_object_cast_to_CysteineCrossLinkData(Object o) -> CysteineCrossLinkData"""
    return _IMP_isd._object_cast_to_CysteineCrossLinkData(o)

_object_types.append("CysteineCrossLinkRestraint")


def _object_cast_to_CysteineCrossLinkRestraint(o):
    r"""_object_cast_to_CysteineCrossLinkRestraint(Object o) -> CysteineCrossLinkRestraint"""
    return _IMP_isd._object_cast_to_CysteineCrossLinkRestraint(o)

_object_types.append("WeightMover")


def _object_cast_to_WeightMover(o):
    r"""_object_cast_to_WeightMover(Object o) -> WeightMover"""
    return _IMP_isd._object_cast_to_WeightMover(o)

_object_types.append("WeightRestraint")


def _object_cast_to_WeightRestraint(o):
    r"""_object_cast_to_WeightRestraint(Object o) -> WeightRestraint"""
    return _IMP_isd._object_cast_to_WeightRestraint(o)

_object_types.append("AtomicCrossLinkMSRestraint")


def _object_cast_to_AtomicCrossLinkMSRestraint(o):
    r"""_object_cast_to_AtomicCrossLinkMSRestraint(Object o) -> AtomicCrossLinkMSRestraint"""
    return _IMP_isd._object_cast_to_AtomicCrossLinkMSRestraint(o)

_object_types.append("GaussianEMRestraint")


def _object_cast_to_GaussianEMRestraint(o):
    r"""_object_cast_to_GaussianEMRestraint(Object o) -> GaussianEMRestraint"""
    return _IMP_isd._object_cast_to_GaussianEMRestraint(o)

_object_types.append("GaussianAnchorEMRestraint")


def _object_cast_to_GaussianAnchorEMRestraint(o):
    r"""_object_cast_to_GaussianAnchorEMRestraint(Object o) -> GaussianAnchorEMRestraint"""
    return _IMP_isd._object_cast_to_GaussianAnchorEMRestraint(o)

_object_types.append("GammaPrior")


def _object_cast_to_GammaPrior(o):
    r"""_object_cast_to_GammaPrior(Object o) -> GammaPrior"""
    return _IMP_isd._object_cast_to_GammaPrior(o)

def create_model_and_particles():
  m= IMP.Model()
  sc= IMP.container.ListSingletonContainer(m)
  b= IMP.algebra.BoundingBox3D(IMP.algebra.Vector3D(0,0,0),
                               IMP.algebra.Vector3D(10,10,10))
  for i in range(0,100):
     p= IMP.Particle(m)
     sc.add_particle(p)
     d=IMP.core.XYZR.setup_particle(p, IMP.algebra.Sphere3D(IMP.algebra.get_random_vector_in(b), 1))
     d.set_coordinates_are_optimized(True)
  return (m, sc)

class ISDRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::ISDRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, name):
        r"""__init__(ISDRestraint self, Model m, std::string name) -> ISDRestraint"""
        if self.__class__ == ISDRestraint:
            _self = None
        else:
            _self = self
        _IMP_isd.ISDRestraint_swiginit(self, _IMP_isd.new_ISDRestraint(_self, m, name))

        if self.__class__ != ISDRestraint:
            _director_objects.register(self)




    def get_probability(self):
        r"""get_probability(ISDRestraint self) -> double"""
        return _IMP_isd.ISDRestraint_get_probability(self)

    def unprotected_evaluate(self, accum):
        r"""unprotected_evaluate(ISDRestraint self, DerivativeAccumulator accum) -> double"""
        return _IMP_isd.ISDRestraint_unprotected_evaluate(self, accum)

    def do_get_inputs(self):
        r"""do_get_inputs(ISDRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.ISDRestraint_do_get_inputs(self)

    def get_type_name(self):
        r"""get_type_name(ISDRestraint self) -> std::string"""
        return _IMP_isd.ISDRestraint_get_type_name(self)

    def get_version_info(self):
        r"""get_version_info(ISDRestraint self) -> VersionInfo"""
        return _IMP_isd.ISDRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(ISDRestraint self) -> std::string"""
        return _IMP_isd.ISDRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(ISDRestraint self) -> std::string"""
        return _IMP_isd.ISDRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ISDRestraint(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP::isd" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_ISDRestraint(o)

    def __disown__(self):
        self.this.disown()
        _IMP_isd.disown_ISDRestraint(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(ISDRestraint self)"""
        return _IMP_isd.ISDRestraint_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(ISDRestraint self, bool arg0)"""
        return _IMP_isd.ISDRestraint_handle_set_has_required_score_states(self, arg0)

    def do_get_outputs(self):
        r"""do_get_outputs(ISDRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.ISDRestraint_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(ISDRestraint self) -> IMP::ModelObjectsTemps"""
        return _IMP_isd.ISDRestraint_do_get_interactions(self)

    def do_create_decomposition(self):
        r"""do_create_decomposition(ISDRestraint self) -> IMP::Restraints"""
        return _IMP_isd.ISDRestraint_do_create_decomposition(self)

    def do_create_current_decomposition(self):
        r"""do_create_current_decomposition(ISDRestraint self) -> IMP::Restraints"""
        return _IMP_isd.ISDRestraint_do_create_current_decomposition(self)

    def do_add_score_and_derivatives(self, sa):
        r"""do_add_score_and_derivatives(ISDRestraint self, ScoreAccumulator sa)"""
        return _IMP_isd.ISDRestraint_do_add_score_and_derivatives(self, sa)

    def do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis):
        r"""do_add_score_and_derivatives_moved(ISDRestraint self, ScoreAccumulator sa, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_isd.ISDRestraint_do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis)

# Register ISDRestraint in _IMP_isd:
_IMP_isd.ISDRestraint_swigregister(ISDRestraint)

class CrossLinkMSRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::CrossLinkMSRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CrossLinkMSRestraint self, Model m, double length, bool get_log_prob=False, std::string name="CrossLinkMSRestraint%1%") -> CrossLinkMSRestraint
        __init__(CrossLinkMSRestraint self, Model m, _ParticleIndexAdaptor lengthi, bool get_log_prob=False, std::string name="CrossLinkMSRestraint%1%") -> CrossLinkMSRestraint
        __init__(CrossLinkMSRestraint self, Model m, double length, double slope, bool get_log_prob=False, std::string name="CrossLinkMSRestraint%1%") -> CrossLinkMSRestraint
        """
        _IMP_isd.CrossLinkMSRestraint_swiginit(self, _IMP_isd.new_CrossLinkMSRestraint(*args))

    def add_contribution(self, pps, sigmas, psi):
        r"""add_contribution(CrossLinkMSRestraint self, IMP::ParticleIndexPair const & pps, IMP::ParticleIndexPair const & sigmas, ParticleIndex psi)"""
        return _IMP_isd.CrossLinkMSRestraint_add_contribution(self, pps, sigmas, psi)

    def get_probability(self):
        r"""get_probability(CrossLinkMSRestraint self) -> double"""
        return _IMP_isd.CrossLinkMSRestraint_get_probability(self)

    def get_length(self):
        r"""get_length(CrossLinkMSRestraint self) -> double"""
        return _IMP_isd.CrossLinkMSRestraint_get_length(self)

    def get_slope(self):
        r"""get_slope(CrossLinkMSRestraint self) -> double"""
        return _IMP_isd.CrossLinkMSRestraint_get_slope(self)

    def get_contribution_sigma_indexes(self, i):
        r"""get_contribution_sigma_indexes(CrossLinkMSRestraint self, int i) -> IMP::ParticleIndexPair"""
        return _IMP_isd.CrossLinkMSRestraint_get_contribution_sigma_indexes(self, i)

    def get_contribution_psi_index(self, i):
        r"""get_contribution_psi_index(CrossLinkMSRestraint self, int i) -> ParticleIndex"""
        return _IMP_isd.CrossLinkMSRestraint_get_contribution_psi_index(self, i)

    def get_contribution_particle_indexes(self, i):
        r"""get_contribution_particle_indexes(CrossLinkMSRestraint self, int i) -> IMP::ParticleIndexPair"""
        return _IMP_isd.CrossLinkMSRestraint_get_contribution_particle_indexes(self, i)

    def get_number_of_contributions(self):
        r"""get_number_of_contributions(CrossLinkMSRestraint self) -> unsigned int"""
        return _IMP_isd.CrossLinkMSRestraint_get_number_of_contributions(self)

    def do_get_inputs(self):
        r"""do_get_inputs(CrossLinkMSRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.CrossLinkMSRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(CrossLinkMSRestraint self) -> VersionInfo"""
        return _IMP_isd.CrossLinkMSRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(CrossLinkMSRestraint self) -> std::string"""
        return _IMP_isd.CrossLinkMSRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(CrossLinkMSRestraint self) -> std::string"""
        return _IMP_isd.CrossLinkMSRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CrossLinkMSRestraint(o)


# Register CrossLinkMSRestraint in _IMP_isd:
_IMP_isd.CrossLinkMSRestraint_swigregister(CrossLinkMSRestraint)

class LogWrapper(IMP.RestraintSet):
    r"""Proxy of C++ IMP::isd::LogWrapper class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(LogWrapper self, Model m, double weight, std::string const & name="LogWrapper %1%") -> LogWrapper
        __init__(LogWrapper self, Model m, std::string const & name="LogWrapper %1%") -> LogWrapper
        __init__(LogWrapper self, IMP::RestraintsTemp const & rs, double weight, std::string const & name="LogWrapper %1%") -> LogWrapper
        """
        _IMP_isd.LogWrapper_swiginit(self, _IMP_isd.new_LogWrapper(*args))

    def do_add_score_and_derivatives(self, sa):
        r"""do_add_score_and_derivatives(LogWrapper self, ScoreAccumulator sa)"""
        return _IMP_isd.LogWrapper_do_add_score_and_derivatives(self, sa)

    def do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis):
        r"""do_add_score_and_derivatives_moved(LogWrapper self, ScoreAccumulator sa, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_isd.LogWrapper_do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis)

    def __str__(self):
        r"""__str__(LogWrapper self) -> std::string"""
        return _IMP_isd.LogWrapper___str__(self)

    def __repr__(self):
        r"""__repr__(LogWrapper self) -> std::string"""
        return _IMP_isd.LogWrapper___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_LogWrapper(o)


# Register LogWrapper in _IMP_isd:
_IMP_isd.LogWrapper_swigregister(LogWrapper)

class UniformPrior(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::UniformPrior class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(UniformPrior self, Model m, Particle p, IMP::Float k, IMP::Float upperb, IMP::Float lowerb, std::string name="UniformPrior%1%") -> UniformPrior"""
        _IMP_isd.UniformPrior_swiginit(self, _IMP_isd.new_UniformPrior(*args))

    def do_get_inputs(self):
        r"""do_get_inputs(UniformPrior self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.UniformPrior_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(UniformPrior self) -> VersionInfo"""
        return _IMP_isd.UniformPrior_get_version_info(self)

    def get_probability(self):
        r"""get_probability(UniformPrior self) -> double"""
        return _IMP_isd.UniformPrior_get_probability(self)

    def __str__(self):
        r"""__str__(UniformPrior self) -> std::string"""
        return _IMP_isd.UniformPrior___str__(self)

    def __repr__(self):
        r"""__repr__(UniformPrior self) -> std::string"""
        return _IMP_isd.UniformPrior___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_UniformPrior(o)


# Register UniformPrior in _IMP_isd:
_IMP_isd.UniformPrior_swigregister(UniformPrior)

class Nuisance(IMP.Decorator):
    r"""Proxy of C++ IMP::isd::Nuisance class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Nuisance self) -> Nuisance
        __init__(Nuisance self, Model m, ParticleIndex id) -> Nuisance
        __init__(Nuisance self, _ParticleAdaptor d) -> Nuisance
        """
        _IMP_isd.Nuisance_swiginit(self, _IMP_isd.new_Nuisance(*args))

    def show(self, *args):
        r"""show(Nuisance self, _ostream out=std::cout)"""
        return _IMP_isd.Nuisance_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Nuisance
        setup_particle(_ParticleAdaptor decorator) -> Nuisance
        setup_particle(Model m, ParticleIndex pi, double nuisance) -> Nuisance
        setup_particle(_ParticleAdaptor decorator, double nuisance) -> Nuisance
        """
        return _IMP_isd.Nuisance_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_isd.Nuisance_get_is_setup(*args)

    @staticmethod
    def get_nuisance_key():
        r"""get_nuisance_key() -> FloatKey"""
        return _IMP_isd.Nuisance_get_nuisance_key()

    def get_nuisance(self):
        r"""get_nuisance(Nuisance self) -> IMP::Float"""
        return _IMP_isd.Nuisance_get_nuisance(self)

    def set_nuisance(self, d):
        r"""set_nuisance(Nuisance self, IMP::Float d)"""
        return _IMP_isd.Nuisance_set_nuisance(self, d)

    def get_has_lower(self):
        r"""get_has_lower(Nuisance self) -> bool"""
        return _IMP_isd.Nuisance_get_has_lower(self)

    def get_lower(self):
        r"""get_lower(Nuisance self) -> IMP::Float"""
        return _IMP_isd.Nuisance_get_lower(self)

    @staticmethod
    def get_lower_key():
        r"""get_lower_key() -> FloatKey"""
        return _IMP_isd.Nuisance_get_lower_key()

    @staticmethod
    def get_lower_particle_key():
        r"""get_lower_particle_key() -> ParticleIndexKey"""
        return _IMP_isd.Nuisance_get_lower_particle_key()

    def set_lower(self, *args):
        r"""
        set_lower(Nuisance self, IMP::Float d)
        set_lower(Nuisance self, Particle d)
        """
        return _IMP_isd.Nuisance_set_lower(self, *args)

    def remove_lower(self):
        r"""remove_lower(Nuisance self)"""
        return _IMP_isd.Nuisance_remove_lower(self)

    def get_has_upper(self):
        r"""get_has_upper(Nuisance self) -> bool"""
        return _IMP_isd.Nuisance_get_has_upper(self)

    def get_upper(self):
        r"""get_upper(Nuisance self) -> IMP::Float"""
        return _IMP_isd.Nuisance_get_upper(self)

    @staticmethod
    def get_upper_key():
        r"""get_upper_key() -> FloatKey"""
        return _IMP_isd.Nuisance_get_upper_key()

    @staticmethod
    def get_upper_particle_key():
        r"""get_upper_particle_key() -> ParticleIndexKey"""
        return _IMP_isd.Nuisance_get_upper_particle_key()

    def set_upper(self, *args):
        r"""
        set_upper(Nuisance self, IMP::Float d)
        set_upper(Nuisance self, Particle d)
        """
        return _IMP_isd.Nuisance_set_upper(self, *args)

    def remove_upper(self):
        r"""remove_upper(Nuisance self)"""
        return _IMP_isd.Nuisance_remove_upper(self)

    def get_nuisance_derivative(self):
        r"""get_nuisance_derivative(Nuisance self) -> IMP::Float"""
        return _IMP_isd.Nuisance_get_nuisance_derivative(self)

    def add_to_nuisance_derivative(self, d, accum):
        r"""add_to_nuisance_derivative(Nuisance self, IMP::Float d, DerivativeAccumulator accum)"""
        return _IMP_isd.Nuisance_add_to_nuisance_derivative(self, d, accum)

    def get_nuisance_is_optimized(self):
        r"""get_nuisance_is_optimized(Nuisance self) -> bool"""
        return _IMP_isd.Nuisance_get_nuisance_is_optimized(self)

    def set_nuisance_is_optimized(self, val):
        r"""set_nuisance_is_optimized(Nuisance self, bool val)"""
        return _IMP_isd.Nuisance_set_nuisance_is_optimized(self, val)

    def add_attribute(self, *args):
        r"""
        add_attribute(Nuisance self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Nuisance self, FloatKey a0, IMP::Float a1)
        add_attribute(Nuisance self, IntKey a0, IMP::Int a1)
        add_attribute(Nuisance self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Nuisance self, IntsKey a0, IMP::Ints a1)
        add_attribute(Nuisance self, StringKey a0, IMP::String a1)
        add_attribute(Nuisance self, ParticleIndexKey a0, Particle a1)
        add_attribute(Nuisance self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Nuisance_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Nuisance self, FloatKey a0) -> IMP::Float
        get_value(Nuisance self, IntKey a0) -> IMP::Int
        get_value(Nuisance self, FloatsKey a0) -> IMP::Floats
        get_value(Nuisance self, IntsKey a0) -> IMP::Ints
        get_value(Nuisance self, StringKey a0) -> IMP::String
        get_value(Nuisance self, ParticleIndexKey a0) -> Particle
        get_value(Nuisance self, ObjectKey a0) -> Object
        """
        return _IMP_isd.Nuisance_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Nuisance self, FloatKey a0, IMP::Float a1)
        set_value(Nuisance self, IntKey a0, IMP::Int a1)
        set_value(Nuisance self, FloatsKey a0, IMP::Floats a1)
        set_value(Nuisance self, IntsKey a0, IMP::Ints a1)
        set_value(Nuisance self, StringKey a0, IMP::String a1)
        set_value(Nuisance self, ParticleIndexKey a0, Particle a1)
        set_value(Nuisance self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Nuisance_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Nuisance self, FloatKey a0)
        remove_attribute(Nuisance self, IntKey a0)
        remove_attribute(Nuisance self, FloatsKey a0)
        remove_attribute(Nuisance self, IntsKey a0)
        remove_attribute(Nuisance self, StringKey a0)
        remove_attribute(Nuisance self, ParticleIndexKey a0)
        remove_attribute(Nuisance self, ObjectKey a0)
        """
        return _IMP_isd.Nuisance_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Nuisance self, FloatKey a0) -> bool
        has_attribute(Nuisance self, IntKey a0) -> bool
        has_attribute(Nuisance self, FloatsKey a0) -> bool
        has_attribute(Nuisance self, IntsKey a0) -> bool
        has_attribute(Nuisance self, StringKey a0) -> bool
        has_attribute(Nuisance self, ParticleIndexKey a0) -> bool
        has_attribute(Nuisance self, ObjectKey a0) -> bool
        """
        return _IMP_isd.Nuisance_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Nuisance self, FloatKey a0) -> double"""
        return _IMP_isd.Nuisance_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Nuisance self) -> std::string"""
        return _IMP_isd.Nuisance_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Nuisance self)"""
        return _IMP_isd.Nuisance_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Nuisance self, std::string a0)"""
        return _IMP_isd.Nuisance_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Nuisance self, IMP::CheckLevel a0)"""
        return _IMP_isd.Nuisance_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Nuisance self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_isd.Nuisance_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Nuisance self, FloatKey a0, bool a1)"""
        return _IMP_isd.Nuisance_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Nuisance self, FloatKey a0) -> bool"""
        return _IMP_isd.Nuisance_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Nuisance self) -> IMP::CheckLevel"""
        return _IMP_isd.Nuisance_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Nuisance self, Nuisance o) -> bool
        __eq__(Nuisance self, Particle d) -> bool
        """
        return _IMP_isd.Nuisance___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Nuisance self, Nuisance o) -> bool
        __ne__(Nuisance self, Particle d) -> bool
        """
        return _IMP_isd.Nuisance___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Nuisance self, Nuisance o) -> bool
        __le__(Nuisance self, Particle d) -> bool
        """
        return _IMP_isd.Nuisance___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Nuisance self, Nuisance o) -> bool
        __lt__(Nuisance self, Particle d) -> bool
        """
        return _IMP_isd.Nuisance___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Nuisance self, Nuisance o) -> bool
        __ge__(Nuisance self, Particle d) -> bool
        """
        return _IMP_isd.Nuisance___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Nuisance self, Nuisance o) -> bool
        __gt__(Nuisance self, Particle d) -> bool
        """
        return _IMP_isd.Nuisance___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Nuisance self) -> std::size_t"""
        return _IMP_isd.Nuisance___hash__(self)

    def __str__(self):
        r"""__str__(Nuisance self) -> std::string"""
        return _IMP_isd.Nuisance___str__(self)

    def __repr__(self):
        r"""__repr__(Nuisance self) -> std::string"""
        return _IMP_isd.Nuisance___repr__(self)
    __swig_destroy__ = _IMP_isd.delete_Nuisance

# Register Nuisance in _IMP_isd:
_IMP_isd.Nuisance_swigregister(Nuisance)

def Nuisance_setup_particle(*args):
    r"""
    Nuisance_setup_particle(Model m, ParticleIndex pi) -> Nuisance
    Nuisance_setup_particle(_ParticleAdaptor decorator) -> Nuisance
    Nuisance_setup_particle(Model m, ParticleIndex pi, double nuisance) -> Nuisance
    Nuisance_setup_particle(_ParticleAdaptor decorator, double nuisance) -> Nuisance
    """
    return _IMP_isd.Nuisance_setup_particle(*args)

def Nuisance_get_is_setup(*args):
    r"""
    Nuisance_get_is_setup(_ParticleAdaptor p) -> bool
    Nuisance_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_isd.Nuisance_get_is_setup(*args)

def Nuisance_get_nuisance_key():
    r"""Nuisance_get_nuisance_key() -> FloatKey"""
    return _IMP_isd.Nuisance_get_nuisance_key()

def Nuisance_get_lower_key():
    r"""Nuisance_get_lower_key() -> FloatKey"""
    return _IMP_isd.Nuisance_get_lower_key()

def Nuisance_get_lower_particle_key():
    r"""Nuisance_get_lower_particle_key() -> ParticleIndexKey"""
    return _IMP_isd.Nuisance_get_lower_particle_key()

def Nuisance_get_upper_key():
    r"""Nuisance_get_upper_key() -> FloatKey"""
    return _IMP_isd.Nuisance_get_upper_key()

def Nuisance_get_upper_particle_key():
    r"""Nuisance_get_upper_particle_key() -> ParticleIndexKey"""
    return _IMP_isd.Nuisance_get_upper_particle_key()

class Scale(Nuisance):
    r"""Proxy of C++ IMP::isd::Scale class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Scale self) -> Scale
        __init__(Scale self, Model m, ParticleIndex id) -> Scale
        __init__(Scale self, _ParticleAdaptor d) -> Scale
        """
        _IMP_isd.Scale_swiginit(self, _IMP_isd.new_Scale(*args))

    def show(self, *args):
        r"""show(Scale self, _ostream out=std::cout)"""
        return _IMP_isd.Scale_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Scale
        setup_particle(_ParticleAdaptor decorator) -> Scale
        setup_particle(Model m, ParticleIndex pi, double scale) -> Scale
        setup_particle(_ParticleAdaptor decorator, double scale) -> Scale
        """
        return _IMP_isd.Scale_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_isd.Scale_get_is_setup(*args)

    def get_scale(self):
        r"""get_scale(Scale self) -> IMP::Float"""
        return _IMP_isd.Scale_get_scale(self)

    def set_scale(self, d):
        r"""set_scale(Scale self, IMP::Float d)"""
        return _IMP_isd.Scale_set_scale(self, d)

    def add_to_scale_derivative(self, d, accum):
        r"""add_to_scale_derivative(Scale self, IMP::Float d, DerivativeAccumulator accum)"""
        return _IMP_isd.Scale_add_to_scale_derivative(self, d, accum)

    def get_scale_derivative(self):
        r"""get_scale_derivative(Scale self) -> IMP::Float"""
        return _IMP_isd.Scale_get_scale_derivative(self)

    @staticmethod
    def get_scale_key():
        r"""get_scale_key() -> FloatKey"""
        return _IMP_isd.Scale_get_scale_key()

    def get_scale_is_optimized(self):
        r"""get_scale_is_optimized(Scale self) -> bool"""
        return _IMP_isd.Scale_get_scale_is_optimized(self)

    def set_scale_is_optimized(self, val):
        r"""set_scale_is_optimized(Scale self, bool val)"""
        return _IMP_isd.Scale_set_scale_is_optimized(self, val)

    def add_attribute(self, *args):
        r"""
        add_attribute(Scale self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Scale self, FloatKey a0, IMP::Float a1)
        add_attribute(Scale self, IntKey a0, IMP::Int a1)
        add_attribute(Scale self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Scale self, IntsKey a0, IMP::Ints a1)
        add_attribute(Scale self, StringKey a0, IMP::String a1)
        add_attribute(Scale self, ParticleIndexKey a0, Particle a1)
        add_attribute(Scale self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Scale_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Scale self, FloatKey a0) -> IMP::Float
        get_value(Scale self, IntKey a0) -> IMP::Int
        get_value(Scale self, FloatsKey a0) -> IMP::Floats
        get_value(Scale self, IntsKey a0) -> IMP::Ints
        get_value(Scale self, StringKey a0) -> IMP::String
        get_value(Scale self, ParticleIndexKey a0) -> Particle
        get_value(Scale self, ObjectKey a0) -> Object
        """
        return _IMP_isd.Scale_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Scale self, FloatKey a0, IMP::Float a1)
        set_value(Scale self, IntKey a0, IMP::Int a1)
        set_value(Scale self, FloatsKey a0, IMP::Floats a1)
        set_value(Scale self, IntsKey a0, IMP::Ints a1)
        set_value(Scale self, StringKey a0, IMP::String a1)
        set_value(Scale self, ParticleIndexKey a0, Particle a1)
        set_value(Scale self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Scale_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Scale self, FloatKey a0)
        remove_attribute(Scale self, IntKey a0)
        remove_attribute(Scale self, FloatsKey a0)
        remove_attribute(Scale self, IntsKey a0)
        remove_attribute(Scale self, StringKey a0)
        remove_attribute(Scale self, ParticleIndexKey a0)
        remove_attribute(Scale self, ObjectKey a0)
        """
        return _IMP_isd.Scale_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Scale self, FloatKey a0) -> bool
        has_attribute(Scale self, IntKey a0) -> bool
        has_attribute(Scale self, FloatsKey a0) -> bool
        has_attribute(Scale self, IntsKey a0) -> bool
        has_attribute(Scale self, StringKey a0) -> bool
        has_attribute(Scale self, ParticleIndexKey a0) -> bool
        has_attribute(Scale self, ObjectKey a0) -> bool
        """
        return _IMP_isd.Scale_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Scale self, FloatKey a0) -> double"""
        return _IMP_isd.Scale_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Scale self) -> std::string"""
        return _IMP_isd.Scale_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Scale self)"""
        return _IMP_isd.Scale_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Scale self, std::string a0)"""
        return _IMP_isd.Scale_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Scale self, IMP::CheckLevel a0)"""
        return _IMP_isd.Scale_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Scale self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_isd.Scale_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Scale self, FloatKey a0, bool a1)"""
        return _IMP_isd.Scale_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Scale self, FloatKey a0) -> bool"""
        return _IMP_isd.Scale_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Scale self) -> IMP::CheckLevel"""
        return _IMP_isd.Scale_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Scale self, Scale o) -> bool
        __eq__(Scale self, Particle d) -> bool
        """
        return _IMP_isd.Scale___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Scale self, Scale o) -> bool
        __ne__(Scale self, Particle d) -> bool
        """
        return _IMP_isd.Scale___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Scale self, Scale o) -> bool
        __le__(Scale self, Particle d) -> bool
        """
        return _IMP_isd.Scale___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Scale self, Scale o) -> bool
        __lt__(Scale self, Particle d) -> bool
        """
        return _IMP_isd.Scale___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Scale self, Scale o) -> bool
        __ge__(Scale self, Particle d) -> bool
        """
        return _IMP_isd.Scale___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Scale self, Scale o) -> bool
        __gt__(Scale self, Particle d) -> bool
        """
        return _IMP_isd.Scale___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Scale self) -> std::size_t"""
        return _IMP_isd.Scale___hash__(self)

    def __str__(self):
        r"""__str__(Scale self) -> std::string"""
        return _IMP_isd.Scale___str__(self)

    def __repr__(self):
        r"""__repr__(Scale self) -> std::string"""
        return _IMP_isd.Scale___repr__(self)
    __swig_destroy__ = _IMP_isd.delete_Scale

# Register Scale in _IMP_isd:
_IMP_isd.Scale_swigregister(Scale)

def Scale_setup_particle(*args):
    r"""
    Scale_setup_particle(Model m, ParticleIndex pi) -> Scale
    Scale_setup_particle(_ParticleAdaptor decorator) -> Scale
    Scale_setup_particle(Model m, ParticleIndex pi, double scale) -> Scale
    Scale_setup_particle(_ParticleAdaptor decorator, double scale) -> Scale
    """
    return _IMP_isd.Scale_setup_particle(*args)

def Scale_get_is_setup(*args):
    r"""
    Scale_get_is_setup(_ParticleAdaptor p) -> bool
    Scale_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_isd.Scale_get_is_setup(*args)

def Scale_get_scale_key():
    r"""Scale_get_scale_key() -> FloatKey"""
    return _IMP_isd.Scale_get_scale_key()

class Switching(Nuisance):
    r"""Proxy of C++ IMP::isd::Switching class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Switching self) -> Switching
        __init__(Switching self, Model m, ParticleIndex id) -> Switching
        __init__(Switching self, _ParticleAdaptor d) -> Switching
        """
        _IMP_isd.Switching_swiginit(self, _IMP_isd.new_Switching(*args))

    def show(self, *args):
        r"""show(Switching self, _ostream out=std::cout)"""
        return _IMP_isd.Switching_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Switching
        setup_particle(_ParticleAdaptor decorator) -> Switching
        setup_particle(Model m, ParticleIndex pi, double switching) -> Switching
        setup_particle(_ParticleAdaptor decorator, double switching) -> Switching
        """
        return _IMP_isd.Switching_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_isd.Switching_get_is_setup(*args)

    def get_switching(self):
        r"""get_switching(Switching self) -> IMP::Float"""
        return _IMP_isd.Switching_get_switching(self)

    def set_switching(self, d):
        r"""set_switching(Switching self, IMP::Float d)"""
        return _IMP_isd.Switching_set_switching(self, d)

    def add_to_switching_derivative(self, d, accum):
        r"""add_to_switching_derivative(Switching self, IMP::Float d, DerivativeAccumulator accum)"""
        return _IMP_isd.Switching_add_to_switching_derivative(self, d, accum)

    def get_switching_derivative(self):
        r"""get_switching_derivative(Switching self) -> IMP::Float"""
        return _IMP_isd.Switching_get_switching_derivative(self)

    @staticmethod
    def get_switching_key():
        r"""get_switching_key() -> FloatKey"""
        return _IMP_isd.Switching_get_switching_key()

    def get_switching_is_optimized(self):
        r"""get_switching_is_optimized(Switching self) -> bool"""
        return _IMP_isd.Switching_get_switching_is_optimized(self)

    def set_switching_is_optimized(self, val):
        r"""set_switching_is_optimized(Switching self, bool val)"""
        return _IMP_isd.Switching_set_switching_is_optimized(self, val)

    def add_attribute(self, *args):
        r"""
        add_attribute(Switching self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Switching self, FloatKey a0, IMP::Float a1)
        add_attribute(Switching self, IntKey a0, IMP::Int a1)
        add_attribute(Switching self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Switching self, IntsKey a0, IMP::Ints a1)
        add_attribute(Switching self, StringKey a0, IMP::String a1)
        add_attribute(Switching self, ParticleIndexKey a0, Particle a1)
        add_attribute(Switching self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Switching_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Switching self, FloatKey a0) -> IMP::Float
        get_value(Switching self, IntKey a0) -> IMP::Int
        get_value(Switching self, FloatsKey a0) -> IMP::Floats
        get_value(Switching self, IntsKey a0) -> IMP::Ints
        get_value(Switching self, StringKey a0) -> IMP::String
        get_value(Switching self, ParticleIndexKey a0) -> Particle
        get_value(Switching self, ObjectKey a0) -> Object
        """
        return _IMP_isd.Switching_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Switching self, FloatKey a0, IMP::Float a1)
        set_value(Switching self, IntKey a0, IMP::Int a1)
        set_value(Switching self, FloatsKey a0, IMP::Floats a1)
        set_value(Switching self, IntsKey a0, IMP::Ints a1)
        set_value(Switching self, StringKey a0, IMP::String a1)
        set_value(Switching self, ParticleIndexKey a0, Particle a1)
        set_value(Switching self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Switching_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Switching self, FloatKey a0)
        remove_attribute(Switching self, IntKey a0)
        remove_attribute(Switching self, FloatsKey a0)
        remove_attribute(Switching self, IntsKey a0)
        remove_attribute(Switching self, StringKey a0)
        remove_attribute(Switching self, ParticleIndexKey a0)
        remove_attribute(Switching self, ObjectKey a0)
        """
        return _IMP_isd.Switching_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Switching self, FloatKey a0) -> bool
        has_attribute(Switching self, IntKey a0) -> bool
        has_attribute(Switching self, FloatsKey a0) -> bool
        has_attribute(Switching self, IntsKey a0) -> bool
        has_attribute(Switching self, StringKey a0) -> bool
        has_attribute(Switching self, ParticleIndexKey a0) -> bool
        has_attribute(Switching self, ObjectKey a0) -> bool
        """
        return _IMP_isd.Switching_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Switching self, FloatKey a0) -> double"""
        return _IMP_isd.Switching_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Switching self) -> std::string"""
        return _IMP_isd.Switching_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Switching self)"""
        return _IMP_isd.Switching_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Switching self, std::string a0)"""
        return _IMP_isd.Switching_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Switching self, IMP::CheckLevel a0)"""
        return _IMP_isd.Switching_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Switching self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_isd.Switching_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Switching self, FloatKey a0, bool a1)"""
        return _IMP_isd.Switching_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Switching self, FloatKey a0) -> bool"""
        return _IMP_isd.Switching_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Switching self) -> IMP::CheckLevel"""
        return _IMP_isd.Switching_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Switching self, Switching o) -> bool
        __eq__(Switching self, Particle d) -> bool
        """
        return _IMP_isd.Switching___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Switching self, Switching o) -> bool
        __ne__(Switching self, Particle d) -> bool
        """
        return _IMP_isd.Switching___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Switching self, Switching o) -> bool
        __le__(Switching self, Particle d) -> bool
        """
        return _IMP_isd.Switching___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Switching self, Switching o) -> bool
        __lt__(Switching self, Particle d) -> bool
        """
        return _IMP_isd.Switching___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Switching self, Switching o) -> bool
        __ge__(Switching self, Particle d) -> bool
        """
        return _IMP_isd.Switching___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Switching self, Switching o) -> bool
        __gt__(Switching self, Particle d) -> bool
        """
        return _IMP_isd.Switching___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Switching self) -> std::size_t"""
        return _IMP_isd.Switching___hash__(self)

    def __str__(self):
        r"""__str__(Switching self) -> std::string"""
        return _IMP_isd.Switching___str__(self)

    def __repr__(self):
        r"""__repr__(Switching self) -> std::string"""
        return _IMP_isd.Switching___repr__(self)
    __swig_destroy__ = _IMP_isd.delete_Switching

# Register Switching in _IMP_isd:
_IMP_isd.Switching_swigregister(Switching)

def Switching_setup_particle(*args):
    r"""
    Switching_setup_particle(Model m, ParticleIndex pi) -> Switching
    Switching_setup_particle(_ParticleAdaptor decorator) -> Switching
    Switching_setup_particle(Model m, ParticleIndex pi, double switching) -> Switching
    Switching_setup_particle(_ParticleAdaptor decorator, double switching) -> Switching
    """
    return _IMP_isd.Switching_setup_particle(*args)

def Switching_get_is_setup(*args):
    r"""
    Switching_get_is_setup(_ParticleAdaptor p) -> bool
    Switching_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_isd.Switching_get_is_setup(*args)

def Switching_get_switching_key():
    r"""Switching_get_switching_key() -> FloatKey"""
    return _IMP_isd.Switching_get_switching_key()

class Weight(IMP.Decorator):
    r"""Proxy of C++ IMP::isd::Weight class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Weight self) -> Weight
        __init__(Weight self, Model m, ParticleIndex id) -> Weight
        __init__(Weight self, _ParticleAdaptor d) -> Weight
        """
        _IMP_isd.Weight_swiginit(self, _IMP_isd.new_Weight(*args))

    def show(self, *args):
        r"""show(Weight self, _ostream out=std::cout)"""
        return _IMP_isd.Weight_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Weight
        setup_particle(_ParticleAdaptor decorator) -> Weight
        setup_particle(Model m, ParticleIndex pi, IMP::Int nweights) -> Weight
        setup_particle(_ParticleAdaptor decorator, IMP::Int nweights) -> Weight
        setup_particle(Model m, ParticleIndex pi, VectorKD w) -> Weight
        setup_particle(_ParticleAdaptor decorator, VectorKD w) -> Weight
        """
        return _IMP_isd.Weight_setup_particle(*args)

    @staticmethod
    def get_nstates_key():
        r"""get_nstates_key() -> IntKey"""
        return _IMP_isd.Weight_get_nstates_key()

    @staticmethod
    def get_number_of_weights_key():
        r"""get_number_of_weights_key() -> IntKey"""
        return _IMP_isd.Weight_get_number_of_weights_key()

    @staticmethod
    def get_weight_key(i):
        r"""get_weight_key(int i) -> FloatKey"""
        return _IMP_isd.Weight_get_weight_key(i)

    def get_weight_keys(self):
        r"""get_weight_keys(Weight self) -> IMP::FloatKeys"""
        return _IMP_isd.Weight_get_weight_keys(self)

    def get_weight(self, i):
        r"""get_weight(Weight self, int i) -> IMP::Float"""
        return _IMP_isd.Weight_get_weight(self, i)

    def get_weights(self):
        r"""get_weights(Weight self) -> VectorKD"""
        return _IMP_isd.Weight_get_weights(self)

    def set_weight_lazy(self, i, wi):
        r"""set_weight_lazy(Weight self, int i, IMP::Float wi)"""
        return _IMP_isd.Weight_set_weight_lazy(self, i, wi)

    def set_weights_lazy(self, w):
        r"""set_weights_lazy(Weight self, VectorKD w)"""
        return _IMP_isd.Weight_set_weights_lazy(self, w)

    def set_weights(self, w):
        r"""set_weights(Weight self, VectorKD w)"""
        return _IMP_isd.Weight_set_weights(self, w)

    def get_weights_are_optimized(self):
        r"""get_weights_are_optimized(Weight self) -> bool"""
        return _IMP_isd.Weight_get_weights_are_optimized(self)

    def set_weights_are_optimized(self, tf):
        r"""set_weights_are_optimized(Weight self, bool tf)"""
        return _IMP_isd.Weight_set_weights_are_optimized(self, tf)

    def get_weight_derivative(self, i):
        r"""get_weight_derivative(Weight self, int i) -> IMP::Float"""
        return _IMP_isd.Weight_get_weight_derivative(self, i)

    def get_weights_derivatives(self):
        r"""get_weights_derivatives(Weight self) -> VectorKD"""
        return _IMP_isd.Weight_get_weights_derivatives(self)

    def add_to_weight_derivative(self, i, dwi, da):
        r"""add_to_weight_derivative(Weight self, int i, IMP::Float dwi, DerivativeAccumulator da)"""
        return _IMP_isd.Weight_add_to_weight_derivative(self, i, dwi, da)

    def add_to_weights_derivatives(self, dw, da):
        r"""add_to_weights_derivatives(Weight self, VectorKD dw, DerivativeAccumulator da)"""
        return _IMP_isd.Weight_add_to_weights_derivatives(self, dw, da)

    def add_weight_lazy(self, wi=0):
        r"""add_weight_lazy(Weight self, IMP::Float wi=0)"""
        return _IMP_isd.Weight_add_weight_lazy(self, wi)

    def add_weight(self, wi=0):
        r"""add_weight(Weight self, IMP::Float wi=0)"""
        return _IMP_isd.Weight_add_weight(self, wi)

    def get_number_of_weights(self):
        r"""get_number_of_weights(Weight self) -> IMP::Int"""
        return _IMP_isd.Weight_get_number_of_weights(self)

    def get_unit_simplex(self):
        r"""get_unit_simplex(Weight self) -> UnitSimplexKD"""
        return _IMP_isd.Weight_get_unit_simplex(self)

    def set_number_of_weights_lazy(self, nweights):
        r"""set_number_of_weights_lazy(Weight self, IMP::Int nweights)"""
        return _IMP_isd.Weight_set_number_of_weights_lazy(self, nweights)

    def set_number_of_weights(self, nweights):
        r"""set_number_of_weights(Weight self, IMP::Int nweights)"""
        return _IMP_isd.Weight_set_number_of_weights(self, nweights)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_isd.Weight_get_is_setup(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(Weight self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Weight self, FloatKey a0, IMP::Float a1)
        add_attribute(Weight self, IntKey a0, IMP::Int a1)
        add_attribute(Weight self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Weight self, IntsKey a0, IMP::Ints a1)
        add_attribute(Weight self, StringKey a0, IMP::String a1)
        add_attribute(Weight self, ParticleIndexKey a0, Particle a1)
        add_attribute(Weight self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Weight_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Weight self, FloatKey a0) -> IMP::Float
        get_value(Weight self, IntKey a0) -> IMP::Int
        get_value(Weight self, FloatsKey a0) -> IMP::Floats
        get_value(Weight self, IntsKey a0) -> IMP::Ints
        get_value(Weight self, StringKey a0) -> IMP::String
        get_value(Weight self, ParticleIndexKey a0) -> Particle
        get_value(Weight self, ObjectKey a0) -> Object
        """
        return _IMP_isd.Weight_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Weight self, FloatKey a0, IMP::Float a1)
        set_value(Weight self, IntKey a0, IMP::Int a1)
        set_value(Weight self, FloatsKey a0, IMP::Floats a1)
        set_value(Weight self, IntsKey a0, IMP::Ints a1)
        set_value(Weight self, StringKey a0, IMP::String a1)
        set_value(Weight self, ParticleIndexKey a0, Particle a1)
        set_value(Weight self, ObjectKey a0, Object a1)
        """
        return _IMP_isd.Weight_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Weight self, FloatKey a0)
        remove_attribute(Weight self, IntKey a0)
        remove_attribute(Weight self, FloatsKey a0)
        remove_attribute(Weight self, IntsKey a0)
        remove_attribute(Weight self, StringKey a0)
        remove_attribute(Weight self, ParticleIndexKey a0)
        remove_attribute(Weight self, ObjectKey a0)
        """
        return _IMP_isd.Weight_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Weight self, FloatKey a0) -> bool
        has_attribute(Weight self, IntKey a0) -> bool
        has_attribute(Weight self, FloatsKey a0) -> bool
        has_attribute(Weight self, IntsKey a0) -> bool
        has_attribute(Weight self, StringKey a0) -> bool
        has_attribute(Weight self, ParticleIndexKey a0) -> bool
        has_attribute(Weight self, ObjectKey a0) -> bool
        """
        return _IMP_isd.Weight_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Weight self, FloatKey a0) -> double"""
        return _IMP_isd.Weight_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Weight self) -> std::string"""
        return _IMP_isd.Weight_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Weight self)"""
        return _IMP_isd.Weight_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Weight self, std::string a0)"""
        return _IMP_isd.Weight_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Weight self, IMP::CheckLevel a0)"""
        return _IMP_isd.Weight_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Weight self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_isd.Weight_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Weight self, FloatKey a0, bool a1)"""
        return _IMP_isd.Weight_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Weight self, FloatKey a0) -> bool"""
        return _IMP_isd.Weight_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Weight self) -> IMP::CheckLevel"""
        return _IMP_isd.Weight_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Weight self, Weight o) -> bool
        __eq__(Weight self, Particle d) -> bool
        """
        return _IMP_isd.Weight___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Weight self, Weight o) -> bool
        __ne__(Weight self, Particle d) -> bool
        """
        return _IMP_isd.Weight___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Weight self, Weight o) -> bool
        __le__(Weight self, Particle d) -> bool
        """
        return _IMP_isd.Weight___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Weight self, Weight o) -> bool
        __lt__(Weight self, Particle d) -> bool
        """
        return _IMP_isd.Weight___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Weight self, Weight o) -> bool
        __ge__(Weight self, Particle d) -> bool
        """
        return _IMP_isd.Weight___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Weight self, Weight o) -> bool
        __gt__(Weight self, Particle d) -> bool
        """
        return _IMP_isd.Weight___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Weight self) -> std::size_t"""
        return _IMP_isd.Weight___hash__(self)

    def __str__(self):
        r"""__str__(Weight self) -> std::string"""
        return _IMP_isd.Weight___str__(self)

    def __repr__(self):
        r"""__repr__(Weight self) -> std::string"""
        return _IMP_isd.Weight___repr__(self)
    __swig_destroy__ = _IMP_isd.delete_Weight

# Register Weight in _IMP_isd:
_IMP_isd.Weight_swigregister(Weight)
cvar = _IMP_isd.cvar
IMPISD_MAX_WEIGHTS = cvar.IMPISD_MAX_WEIGHTS

def Weight_setup_particle(*args):
    r"""
    Weight_setup_particle(Model m, ParticleIndex pi) -> Weight
    Weight_setup_particle(_ParticleAdaptor decorator) -> Weight
    Weight_setup_particle(Model m, ParticleIndex pi, IMP::Int nweights) -> Weight
    Weight_setup_particle(_ParticleAdaptor decorator, IMP::Int nweights) -> Weight
    Weight_setup_particle(Model m, ParticleIndex pi, VectorKD w) -> Weight
    Weight_setup_particle(_ParticleAdaptor decorator, VectorKD w) -> Weight
    """
    return _IMP_isd.Weight_setup_particle(*args)

def Weight_get_nstates_key():
    r"""Weight_get_nstates_key() -> IntKey"""
    return _IMP_isd.Weight_get_nstates_key()

def Weight_get_number_of_weights_key():
    r"""Weight_get_number_of_weights_key() -> IntKey"""
    return _IMP_isd.Weight_get_number_of_weights_key()

def Weight_get_weight_key(i):
    r"""Weight_get_weight_key(int i) -> FloatKey"""
    return _IMP_isd.Weight_get_weight_key(i)

def Weight_get_is_setup(*args):
    r"""
    Weight_get_is_setup(_ParticleAdaptor p) -> bool
    Weight_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_isd.Weight_get_is_setup(*args)


def __lshift__(*args):
    r"""
    __lshift__(_ostream out, Nuisance n) -> _ostream
    __lshift__(_ostream out, Scale n) -> _ostream
    __lshift__(_ostream out, Switching n) -> _ostream
    __lshift__(_ostream out, Weight n) -> _ostream
    """
    return _IMP_isd.__lshift__(*args)
class JeffreysRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::JeffreysRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, p):
        r"""__init__(JeffreysRestraint self, Model m, Particle p) -> JeffreysRestraint"""
        _IMP_isd.JeffreysRestraint_swiginit(self, _IMP_isd.new_JeffreysRestraint(m, p))

    def do_get_inputs(self):
        r"""do_get_inputs(JeffreysRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.JeffreysRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(JeffreysRestraint self) -> VersionInfo"""
        return _IMP_isd.JeffreysRestraint_get_version_info(self)

    def get_probability(self):
        r"""get_probability(JeffreysRestraint self) -> double"""
        return _IMP_isd.JeffreysRestraint_get_probability(self)

    def __str__(self):
        r"""__str__(JeffreysRestraint self) -> std::string"""
        return _IMP_isd.JeffreysRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(JeffreysRestraint self) -> std::string"""
        return _IMP_isd.JeffreysRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_JeffreysRestraint(o)


# Register JeffreysRestraint in _IMP_isd:
_IMP_isd.JeffreysRestraint_swigregister(JeffreysRestraint)

class NormalSigmaPCRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::NormalSigmaPCRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(NormalSigmaPCRestraint self, Model m, ParticleIndex spi, double su, double alpha, std::string name="NormalSigmaPCRestraint%1%") -> NormalSigmaPCRestraint
        __init__(NormalSigmaPCRestraint self, Scale s, double su, double alpha, std::string name="NormalSigmaPCRestraint%1%") -> NormalSigmaPCRestraint
        """
        _IMP_isd.NormalSigmaPCRestraint_swiginit(self, _IMP_isd.new_NormalSigmaPCRestraint(*args))

    def get_sigma(self):
        r"""get_sigma(NormalSigmaPCRestraint self) -> Scale"""
        return _IMP_isd.NormalSigmaPCRestraint_get_sigma(self)

    def get_alpha(self):
        r"""get_alpha(NormalSigmaPCRestraint self) -> double"""
        return _IMP_isd.NormalSigmaPCRestraint_get_alpha(self)

    def get_sigma_upper(self):
        r"""get_sigma_upper(NormalSigmaPCRestraint self) -> double"""
        return _IMP_isd.NormalSigmaPCRestraint_get_sigma_upper(self)

    def get_probability(self):
        r"""get_probability(NormalSigmaPCRestraint self) -> double"""
        return _IMP_isd.NormalSigmaPCRestraint_get_probability(self)

    def do_get_inputs(self):
        r"""do_get_inputs(NormalSigmaPCRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.NormalSigmaPCRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(NormalSigmaPCRestraint self) -> VersionInfo"""
        return _IMP_isd.NormalSigmaPCRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(NormalSigmaPCRestraint self) -> std::string"""
        return _IMP_isd.NormalSigmaPCRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(NormalSigmaPCRestraint self) -> std::string"""
        return _IMP_isd.NormalSigmaPCRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NormalSigmaPCRestraint(o)


# Register NormalSigmaPCRestraint in _IMP_isd:
_IMP_isd.NormalSigmaPCRestraint_swigregister(NormalSigmaPCRestraint)

class Distribution(IMP.Object):
    r"""Proxy of C++ IMP::isd::Distribution class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Distribution self, std::string name="Distribution %1%") -> Distribution"""
        if self.__class__ == Distribution:
            _self = None
        else:
            _self = self
        _IMP_isd.Distribution_swiginit(self, _IMP_isd.new_Distribution(_self, *args))

        if self.__class__ != Distribution:
            _director_objects.register(self)




    def get_type_name(self):
        r"""get_type_name(Distribution self) -> std::string"""
        return _IMP_isd.Distribution_get_type_name(self)

    def get_version_info(self):
        r"""get_version_info(Distribution self) -> VersionInfo"""
        return _IMP_isd.Distribution_get_version_info(self)

    def __str__(self):
        r"""__str__(Distribution self) -> std::string"""
        return _IMP_isd.Distribution___str__(self)

    def __repr__(self):
        r"""__repr__(Distribution self) -> std::string"""
        return _IMP_isd.Distribution___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Distribution(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP::isd" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Distribution(o)

    def __disown__(self):
        self.this.disown()
        _IMP_isd.disown_Distribution(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Distribution self)"""
        return _IMP_isd.Distribution_do_destroy(self)

# Register Distribution in _IMP_isd:
_IMP_isd.Distribution_swigregister(Distribution)

class OneDimensionalDistribution(Distribution):
    r"""Proxy of C++ IMP::isd::OneDimensionalDistribution class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def do_evaluate(self, *args):
        r"""
        do_evaluate(OneDimensionalDistribution self, double v) -> double
        do_evaluate(OneDimensionalDistribution self, IMP::Floats const & vs) -> IMP::Floats
        """
        return _IMP_isd.OneDimensionalDistribution_do_evaluate(self, *args)

    def do_get_density(self, *args):
        r"""
        do_get_density(OneDimensionalDistribution self, double v) -> double
        do_get_density(OneDimensionalDistribution self, IMP::Floats const & vs) -> IMP::Floats
        """
        return _IMP_isd.OneDimensionalDistribution_do_get_density(self, *args)

    def __init__(self, *args):
        r"""__init__(OneDimensionalDistribution self, std::string name="OneDimensionalDistribution %1%") -> OneDimensionalDistribution"""
        if self.__class__ == OneDimensionalDistribution:
            _self = None
        else:
            _self = self
        _IMP_isd.OneDimensionalDistribution_swiginit(self, _IMP_isd.new_OneDimensionalDistribution(_self, *args))

        if self.__class__ != OneDimensionalDistribution:
            _director_objects.register(self)




    def evaluate(self, *args):
        r"""
        evaluate(OneDimensionalDistribution self, double v) -> double
        evaluate(OneDimensionalDistribution self, IMP::Floats const & vs) -> IMP::Floats
        """
        return _IMP_isd.OneDimensionalDistribution_evaluate(self, *args)

    def get_density(self, *args):
        r"""
        get_density(OneDimensionalDistribution self, double v) -> double
        get_density(OneDimensionalDistribution self, IMP::Floats const & vs) -> IMP::Floats
        """
        return _IMP_isd.OneDimensionalDistribution_get_density(self, *args)

    def get_type_name(self):
        r"""get_type_name(OneDimensionalDistribution self) -> std::string"""
        return _IMP_isd.OneDimensionalDistribution_get_type_name(self)

    def get_version_info(self):
        r"""get_version_info(OneDimensionalDistribution self) -> VersionInfo"""
        return _IMP_isd.OneDimensionalDistribution_get_version_info(self)

    def __str__(self):
        r"""__str__(OneDimensionalDistribution self) -> std::string"""
        return _IMP_isd.OneDimensionalDistribution___str__(self)

    def __repr__(self):
        r"""__repr__(OneDimensionalDistribution self) -> std::string"""
        return _IMP_isd.OneDimensionalDistribution___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_OneDimensionalDistribution(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP::isd" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_OneDimensionalDistribution(o)

    def __disown__(self):
        self.this.disown()
        _IMP_isd.disown_OneDimensionalDistribution(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(OneDimensionalDistribution self)"""
        return _IMP_isd.OneDimensionalDistribution_do_destroy(self)

# Register OneDimensionalDistribution in _IMP_isd:
_IMP_isd.OneDimensionalDistribution_swigregister(OneDimensionalDistribution)

class OneDimensionalSufficientDistribution(Distribution):
    r"""Proxy of C++ IMP::isd::OneDimensionalSufficientDistribution class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def do_update_sufficient_statistics(self, vs):
        r"""do_update_sufficient_statistics(OneDimensionalSufficientDistribution self, IMP::Floats vs)"""
        return _IMP_isd.OneDimensionalSufficientDistribution_do_update_sufficient_statistics(self, vs)

    def do_get_sufficient_statistics(self):
        r"""do_get_sufficient_statistics(OneDimensionalSufficientDistribution self) -> IMP::Floats"""
        return _IMP_isd.OneDimensionalSufficientDistribution_do_get_sufficient_statistics(self)

    def do_evaluate(self):
        r"""do_evaluate(OneDimensionalSufficientDistribution self) -> double"""
        return _IMP_isd.OneDimensionalSufficientDistribution_do_evaluate(self)

    def do_get_density(self):
        r"""do_get_density(OneDimensionalSufficientDistribution self) -> double"""
        return _IMP_isd.OneDimensionalSufficientDistribution_do_get_density(self)

    def __init__(self, *args):
        r"""__init__(OneDimensionalSufficientDistribution self, std::string name="OneDimensionalSufficientDistribution %1%") -> OneDimensionalSufficientDistribution"""
        if self.__class__ == OneDimensionalSufficientDistribution:
            _self = None
        else:
            _self = self
        _IMP_isd.OneDimensionalSufficientDistribution_swiginit(self, _IMP_isd.new_OneDimensionalSufficientDistribution(_self, *args))

        if self.__class__ != OneDimensionalSufficientDistribution:
            _director_objects.register(self)




    def update_sufficient_statistics(self, vs):
        r"""update_sufficient_statistics(OneDimensionalSufficientDistribution self, IMP::Floats vs)"""
        return _IMP_isd.OneDimensionalSufficientDistribution_update_sufficient_statistics(self, vs)

    def get_sufficient_statistics(self):
        r"""get_sufficient_statistics(OneDimensionalSufficientDistribution self) -> IMP::Floats"""
        return _IMP_isd.OneDimensionalSufficientDistribution_get_sufficient_statistics(self)

    def evaluate(self):
        r"""evaluate(OneDimensionalSufficientDistribution self) -> double"""
        return _IMP_isd.OneDimensionalSufficientDistribution_evaluate(self)

    def get_density(self):
        r"""get_density(OneDimensionalSufficientDistribution self) -> double"""
        return _IMP_isd.OneDimensionalSufficientDistribution_get_density(self)

    def get_type_name(self):
        r"""get_type_name(OneDimensionalSufficientDistribution self) -> std::string"""
        return _IMP_isd.OneDimensionalSufficientDistribution_get_type_name(self)

    def get_version_info(self):
        r"""get_version_info(OneDimensionalSufficientDistribution self) -> VersionInfo"""
        return _IMP_isd.OneDimensionalSufficientDistribution_get_version_info(self)

    def __str__(self):
        r"""__str__(OneDimensionalSufficientDistribution self) -> std::string"""
        return _IMP_isd.OneDimensionalSufficientDistribution___str__(self)

    def __repr__(self):
        r"""__repr__(OneDimensionalSufficientDistribution self) -> std::string"""
        return _IMP_isd.OneDimensionalSufficientDistribution___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_OneDimensionalSufficientDistribution(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP::isd" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_OneDimensionalSufficientDistribution(o)

    def __disown__(self):
        self.this.disown()
        _IMP_isd.disown_OneDimensionalSufficientDistribution(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(OneDimensionalSufficientDistribution self)"""
        return _IMP_isd.OneDimensionalSufficientDistribution_do_destroy(self)

# Register OneDimensionalSufficientDistribution in _IMP_isd:
_IMP_isd.OneDimensionalSufficientDistribution_swigregister(OneDimensionalSufficientDistribution)

class FNormal(OneDimensionalSufficientDistribution):
    r"""Proxy of C++ IMP::isd::FNormal class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, FA, JA, FM, sigma):
        r"""__init__(FNormal self, double FA, double JA, double FM, double sigma) -> FNormal"""
        _IMP_isd.FNormal_swiginit(self, _IMP_isd.new_FNormal(FA, JA, FM, sigma))

    def update_sufficient_statistics(self, FA):
        r"""update_sufficient_statistics(FNormal self, double FA)"""
        return _IMP_isd.FNormal_update_sufficient_statistics(self, FA)

    def do_update_sufficient_statistics(self, data):
        r"""do_update_sufficient_statistics(FNormal self, IMP::Floats data)"""
        return _IMP_isd.FNormal_do_update_sufficient_statistics(self, data)

    def do_get_sufficient_statistics(self):
        r"""do_get_sufficient_statistics(FNormal self) -> IMP::Floats"""
        return _IMP_isd.FNormal_do_get_sufficient_statistics(self)

    def do_evaluate(self):
        r"""do_evaluate(FNormal self) -> double"""
        return _IMP_isd.FNormal_do_evaluate(self)

    def evaluate_derivative_FA(self):
        r"""evaluate_derivative_FA(FNormal self) -> double"""
        return _IMP_isd.FNormal_evaluate_derivative_FA(self)

    def evaluate_derivative_JA(self):
        r"""evaluate_derivative_JA(FNormal self) -> double"""
        return _IMP_isd.FNormal_evaluate_derivative_JA(self)

    def evaluate_derivative_FM(self):
        r"""evaluate_derivative_FM(FNormal self) -> double"""
        return _IMP_isd.FNormal_evaluate_derivative_FM(self)

    def evaluate_derivative_sigma(self):
        r"""evaluate_derivative_sigma(FNormal self) -> double"""
        return _IMP_isd.FNormal_evaluate_derivative_sigma(self)

    def do_get_density(self):
        r"""do_get_density(FNormal self) -> double"""
        return _IMP_isd.FNormal_do_get_density(self)

    def set_FA(self, f):
        r"""set_FA(FNormal self, double f)"""
        return _IMP_isd.FNormal_set_FA(self, f)

    def set_JA(self, f):
        r"""set_JA(FNormal self, double f)"""
        return _IMP_isd.FNormal_set_JA(self, f)

    def set_FM(self, f):
        r"""set_FM(FNormal self, double f)"""
        return _IMP_isd.FNormal_set_FM(self, f)

    def set_sigma(self, f):
        r"""set_sigma(FNormal self, double f)"""
        return _IMP_isd.FNormal_set_sigma(self, f)

    def __str__(self):
        r"""__str__(FNormal self) -> std::string"""
        return _IMP_isd.FNormal___str__(self)

    def __repr__(self):
        r"""__repr__(FNormal self) -> std::string"""
        return _IMP_isd.FNormal___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_FNormal(o)


# Register FNormal in _IMP_isd:
_IMP_isd.FNormal_swigregister(FNormal)

class FStudentT(OneDimensionalSufficientDistribution):
    r"""Proxy of C++ IMP::isd::FStudentT class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(FStudentT self, IMP::Floats FXs, IMP::Floats JXs, double FM, double sigma, double nu, std::string name="FStudentT %1%") -> FStudentT
        __init__(FStudentT self, double sumFX, double sumFX2, unsigned int N, double LogJX, double FM, double sigma, double nu, std::string name="FStudentT %1%") -> FStudentT
        """
        _IMP_isd.FStudentT_swiginit(self, _IMP_isd.new_FStudentT(*args))

    def update_sufficient_statistics(self, FXs, JXs):
        r"""update_sufficient_statistics(FStudentT self, IMP::Floats FXs, IMP::Floats JXs)"""
        return _IMP_isd.FStudentT_update_sufficient_statistics(self, FXs, JXs)

    def evaluate_derivative_Fx(self, Fx):
        r"""evaluate_derivative_Fx(FStudentT self, double Fx) -> double"""
        return _IMP_isd.FStudentT_evaluate_derivative_Fx(self, Fx)

    def evaluate_derivative_FX(self, FXs):
        r"""evaluate_derivative_FX(FStudentT self, IMP::Floats const FXs) -> IMP::Floats"""
        return _IMP_isd.FStudentT_evaluate_derivative_FX(self, FXs)

    def evaluate_derivative_LogJX(self):
        r"""evaluate_derivative_LogJX(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_evaluate_derivative_LogJX(self)

    def evaluate_derivative_FM(self):
        r"""evaluate_derivative_FM(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_evaluate_derivative_FM(self)

    def evaluate_derivative_sigma(self):
        r"""evaluate_derivative_sigma(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_evaluate_derivative_sigma(self)

    def evaluate_derivative_nu(self):
        r"""evaluate_derivative_nu(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_evaluate_derivative_nu(self)

    def update_cached_values(self):
        r"""update_cached_values(FStudentT self)"""
        return _IMP_isd.FStudentT_update_cached_values(self)

    def set_sumFX(self, v):
        r"""set_sumFX(FStudentT self, double v)"""
        return _IMP_isd.FStudentT_set_sumFX(self, v)

    def set_sumFX2(self, v):
        r"""set_sumFX2(FStudentT self, double v)"""
        return _IMP_isd.FStudentT_set_sumFX2(self, v)

    def set_N(self, v):
        r"""set_N(FStudentT self, unsigned int v)"""
        return _IMP_isd.FStudentT_set_N(self, v)

    def set_LogJX(self, v):
        r"""set_LogJX(FStudentT self, double v)"""
        return _IMP_isd.FStudentT_set_LogJX(self, v)

    def set_FM(self, v):
        r"""set_FM(FStudentT self, double v)"""
        return _IMP_isd.FStudentT_set_FM(self, v)

    def set_sigma(self, v):
        r"""set_sigma(FStudentT self, double v)"""
        return _IMP_isd.FStudentT_set_sigma(self, v)

    def set_nu(self, v):
        r"""set_nu(FStudentT self, double v)"""
        return _IMP_isd.FStudentT_set_nu(self, v)

    def get_sumFX(self):
        r"""get_sumFX(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_get_sumFX(self)

    def get_sumFX2(self):
        r"""get_sumFX2(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_get_sumFX2(self)

    def get_N(self):
        r"""get_N(FStudentT self) -> unsigned int"""
        return _IMP_isd.FStudentT_get_N(self)

    def get_LogJX(self):
        r"""get_LogJX(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_get_LogJX(self)

    def get_FM(self):
        r"""get_FM(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_get_FM(self)

    def get_sigma(self):
        r"""get_sigma(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_get_sigma(self)

    def get_nu(self):
        r"""get_nu(FStudentT self) -> double"""
        return _IMP_isd.FStudentT_get_nu(self)

    def __str__(self):
        r"""__str__(FStudentT self) -> std::string"""
        return _IMP_isd.FStudentT___str__(self)

    def __repr__(self):
        r"""__repr__(FStudentT self) -> std::string"""
        return _IMP_isd.FStudentT___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_FStudentT(o)


# Register FStudentT in _IMP_isd:
_IMP_isd.FStudentT_swigregister(FStudentT)

class vonMises(IMP.Object):
    r"""Proxy of C++ IMP::isd::vonMises class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, x, mu, kappa):
        r"""__init__(vonMises self, double x, double mu, double kappa) -> vonMises"""
        _IMP_isd.vonMises_swiginit(self, _IMP_isd.new_vonMises(x, mu, kappa))

    def evaluate(self):
        r"""evaluate(vonMises self) -> double"""
        return _IMP_isd.vonMises_evaluate(self)

    def evaluate_derivative_x(self):
        r"""evaluate_derivative_x(vonMises self) -> double"""
        return _IMP_isd.vonMises_evaluate_derivative_x(self)

    def evaluate_derivative_mu(self):
        r"""evaluate_derivative_mu(vonMises self) -> double"""
        return _IMP_isd.vonMises_evaluate_derivative_mu(self)

    def evaluate_derivative_kappa(self):
        r"""evaluate_derivative_kappa(vonMises self) -> double"""
        return _IMP_isd.vonMises_evaluate_derivative_kappa(self)

    def density(self):
        r"""density(vonMises self) -> double"""
        return _IMP_isd.vonMises_density(self)

    def set_x(self, x):
        r"""set_x(vonMises self, double x)"""
        return _IMP_isd.vonMises_set_x(self, x)

    def set_mu(self, mu):
        r"""set_mu(vonMises self, double mu)"""
        return _IMP_isd.vonMises_set_mu(self, mu)

    def set_kappa(self, kappa):
        r"""set_kappa(vonMises self, double kappa)"""
        return _IMP_isd.vonMises_set_kappa(self, kappa)

    def get_version_info(self):
        r"""get_version_info(vonMises self) -> VersionInfo"""
        return _IMP_isd.vonMises_get_version_info(self)

    def __str__(self):
        r"""__str__(vonMises self) -> std::string"""
        return _IMP_isd.vonMises___str__(self)

    def __repr__(self):
        r"""__repr__(vonMises self) -> std::string"""
        return _IMP_isd.vonMises___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_vonMises(o)


# Register vonMises in _IMP_isd:
_IMP_isd.vonMises_swigregister(vonMises)

class vonMisesSufficient(IMP.Object):
    r"""Proxy of C++ IMP::isd::vonMisesSufficient class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(vonMisesSufficient self, double chi, unsigned int N, double R0, double chiexp, double kappa) -> vonMisesSufficient
        __init__(vonMisesSufficient self, double chi, IMP::Floats obs, double kappa) -> vonMisesSufficient
        """
        _IMP_isd.vonMisesSufficient_swiginit(self, _IMP_isd.new_vonMisesSufficient(*args))

    def evaluate(self):
        r"""evaluate(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_evaluate(self)

    def evaluate_derivative_x(self):
        r"""evaluate_derivative_x(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_evaluate_derivative_x(self)

    def evaluate_derivative_kappa(self):
        r"""evaluate_derivative_kappa(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_evaluate_derivative_kappa(self)

    def density(self):
        r"""density(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_density(self)

    def get_x(self):
        r"""get_x(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_get_x(self)

    def get_R0(self):
        r"""get_R0(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_get_R0(self)

    def get_chiexp(self):
        r"""get_chiexp(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_get_chiexp(self)

    def get_N(self):
        r"""get_N(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_get_N(self)

    def get_kappa(self):
        r"""get_kappa(vonMisesSufficient self) -> double"""
        return _IMP_isd.vonMisesSufficient_get_kappa(self)

    def set_x(self, x):
        r"""set_x(vonMisesSufficient self, double x)"""
        return _IMP_isd.vonMisesSufficient_set_x(self, x)

    def set_R0(self, R0):
        r"""set_R0(vonMisesSufficient self, double R0)"""
        return _IMP_isd.vonMisesSufficient_set_R0(self, R0)

    def set_chiexp(self, chiexp):
        r"""set_chiexp(vonMisesSufficient self, double chiexp)"""
        return _IMP_isd.vonMisesSufficient_set_chiexp(self, chiexp)

    def set_N(self, N):
        r"""set_N(vonMisesSufficient self, unsigned int N)"""
        return _IMP_isd.vonMisesSufficient_set_N(self, N)

    def set_kappa(self, kappa):
        r"""set_kappa(vonMisesSufficient self, double kappa)"""
        return _IMP_isd.vonMisesSufficient_set_kappa(self, kappa)

    @staticmethod
    def get_sufficient_statistics(data):
        r"""get_sufficient_statistics(IMP::Floats data) -> IMP::Floats"""
        return _IMP_isd.vonMisesSufficient_get_sufficient_statistics(data)

    def get_version_info(self):
        r"""get_version_info(vonMisesSufficient self) -> VersionInfo"""
        return _IMP_isd.vonMisesSufficient_get_version_info(self)

    def __str__(self):
        r"""__str__(vonMisesSufficient self) -> std::string"""
        return _IMP_isd.vonMisesSufficient___str__(self)

    def __repr__(self):
        r"""__repr__(vonMisesSufficient self) -> std::string"""
        return _IMP_isd.vonMisesSufficient___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_vonMisesSufficient(o)


# Register vonMisesSufficient in _IMP_isd:
_IMP_isd.vonMisesSufficient_swigregister(vonMisesSufficient)

def vonMisesSufficient_get_sufficient_statistics(data):
    r"""vonMisesSufficient_get_sufficient_statistics(IMP::Floats data) -> IMP::Floats"""
    return _IMP_isd.vonMisesSufficient_get_sufficient_statistics(data)

class PenalizedComplexityPrior(OneDimensionalSufficientDistribution):
    r"""Proxy of C++ IMP::isd::PenalizedComplexityPrior class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(PenalizedComplexityPrior self, double Dxi, double Jxi, double alpha, std::string name="PenalizedComplexityPrior %1%") -> PenalizedComplexityPrior"""
        _IMP_isd.PenalizedComplexityPrior_swiginit(self, _IMP_isd.new_PenalizedComplexityPrior(*args))

    def update_sufficient_statistics(self, Dxis, Jxis):
        r"""update_sufficient_statistics(PenalizedComplexityPrior self, IMP::Floats Dxis, IMP::Floats Jxis)"""
        return _IMP_isd.PenalizedComplexityPrior_update_sufficient_statistics(self, Dxis, Jxis)

    def evaluate_derivative_Dxi(self):
        r"""evaluate_derivative_Dxi(PenalizedComplexityPrior self) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_evaluate_derivative_Dxi(self)

    def evaluate_derivative_Jxi(self):
        r"""evaluate_derivative_Jxi(PenalizedComplexityPrior self) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_evaluate_derivative_Jxi(self)

    def evaluate_derivative_alpha(self):
        r"""evaluate_derivative_alpha(PenalizedComplexityPrior self) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_evaluate_derivative_alpha(self)

    def evaluate_derivative_xi(self, JJxi):
        r"""evaluate_derivative_xi(PenalizedComplexityPrior self, double JJxi) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_evaluate_derivative_xi(self, JJxi)

    def set_Dxi(self, v):
        r"""set_Dxi(PenalizedComplexityPrior self, double v)"""
        return _IMP_isd.PenalizedComplexityPrior_set_Dxi(self, v)

    def set_Jxi(self, v):
        r"""set_Jxi(PenalizedComplexityPrior self, double v)"""
        return _IMP_isd.PenalizedComplexityPrior_set_Jxi(self, v)

    def set_alpha(self, v):
        r"""set_alpha(PenalizedComplexityPrior self, double v)"""
        return _IMP_isd.PenalizedComplexityPrior_set_alpha(self, v)

    def get_Dxi(self):
        r"""get_Dxi(PenalizedComplexityPrior self) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_get_Dxi(self)

    def get_Jxi(self):
        r"""get_Jxi(PenalizedComplexityPrior self) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_get_Jxi(self)

    def get_alpha(self):
        r"""get_alpha(PenalizedComplexityPrior self) -> double"""
        return _IMP_isd.PenalizedComplexityPrior_get_alpha(self)

    def __str__(self):
        r"""__str__(PenalizedComplexityPrior self) -> std::string"""
        return _IMP_isd.PenalizedComplexityPrior___str__(self)

    def __repr__(self):
        r"""__repr__(PenalizedComplexityPrior self) -> std::string"""
        return _IMP_isd.PenalizedComplexityPrior___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PenalizedComplexityPrior(o)


# Register PenalizedComplexityPrior in _IMP_isd:
_IMP_isd.PenalizedComplexityPrior_swigregister(PenalizedComplexityPrior)

class vonMisesKappaJeffreysRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::vonMisesKappaJeffreysRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, kappa):
        r"""__init__(vonMisesKappaJeffreysRestraint self, Model m, Particle kappa) -> vonMisesKappaJeffreysRestraint"""
        _IMP_isd.vonMisesKappaJeffreysRestraint_swiginit(self, _IMP_isd.new_vonMisesKappaJeffreysRestraint(m, kappa))

    def do_get_inputs(self):
        r"""do_get_inputs(vonMisesKappaJeffreysRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.vonMisesKappaJeffreysRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(vonMisesKappaJeffreysRestraint self) -> VersionInfo"""
        return _IMP_isd.vonMisesKappaJeffreysRestraint_get_version_info(self)

    def get_probability(self):
        r"""get_probability(vonMisesKappaJeffreysRestraint self) -> double"""
        return _IMP_isd.vonMisesKappaJeffreysRestraint_get_probability(self)

    def __str__(self):
        r"""__str__(vonMisesKappaJeffreysRestraint self) -> std::string"""
        return _IMP_isd.vonMisesKappaJeffreysRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(vonMisesKappaJeffreysRestraint self) -> std::string"""
        return _IMP_isd.vonMisesKappaJeffreysRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_vonMisesKappaJeffreysRestraint(o)


# Register vonMisesKappaJeffreysRestraint in _IMP_isd:
_IMP_isd.vonMisesKappaJeffreysRestraint_swigregister(vonMisesKappaJeffreysRestraint)

class vonMisesKappaConjugateRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::vonMisesKappaConjugateRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, kappa, c=10.0, R0=0.0):
        r"""__init__(vonMisesKappaConjugateRestraint self, Model m, Particle kappa, double c=10.0, double R0=0.0) -> vonMisesKappaConjugateRestraint"""
        _IMP_isd.vonMisesKappaConjugateRestraint_swiginit(self, _IMP_isd.new_vonMisesKappaConjugateRestraint(m, kappa, c, R0))

    def do_get_inputs(self):
        r"""do_get_inputs(vonMisesKappaConjugateRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.vonMisesKappaConjugateRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(vonMisesKappaConjugateRestraint self) -> VersionInfo"""
        return _IMP_isd.vonMisesKappaConjugateRestraint_get_version_info(self)

    def get_probability(self):
        r"""get_probability(vonMisesKappaConjugateRestraint self) -> double"""
        return _IMP_isd.vonMisesKappaConjugateRestraint_get_probability(self)

    def __str__(self):
        r"""__str__(vonMisesKappaConjugateRestraint self) -> std::string"""
        return _IMP_isd.vonMisesKappaConjugateRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(vonMisesKappaConjugateRestraint self) -> std::string"""
        return _IMP_isd.vonMisesKappaConjugateRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_vonMisesKappaConjugateRestraint(o)


# Register vonMisesKappaConjugateRestraint in _IMP_isd:
_IMP_isd.vonMisesKappaConjugateRestraint_swigregister(vonMisesKappaConjugateRestraint)

class NOERestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::NOERestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, p0, p1, sigma, gamma, Iexp):
        r"""__init__(NOERestraint self, Model m, Particle p0, Particle p1, Particle sigma, Particle gamma, double Iexp) -> NOERestraint"""
        _IMP_isd.NOERestraint_swiginit(self, _IMP_isd.new_NOERestraint(m, p0, p1, sigma, gamma, Iexp))

    def get_probability(self):
        r"""get_probability(NOERestraint self) -> double"""
        return _IMP_isd.NOERestraint_get_probability(self)

    def get_chi(self):
        r"""get_chi(NOERestraint self) -> double"""
        return _IMP_isd.NOERestraint_get_chi(self)

    def do_get_inputs(self):
        r"""do_get_inputs(NOERestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.NOERestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(NOERestraint self) -> VersionInfo"""
        return _IMP_isd.NOERestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(NOERestraint self) -> std::string"""
        return _IMP_isd.NOERestraint___str__(self)

    def __repr__(self):
        r"""__repr__(NOERestraint self) -> std::string"""
        return _IMP_isd.NOERestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NOERestraint(o)


# Register NOERestraint in _IMP_isd:
_IMP_isd.NOERestraint_swigregister(NOERestraint)

class GaussianRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::GaussianRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(GaussianRestraint self, Particle x, Particle mu, Particle sigma) -> GaussianRestraint
        __init__(GaussianRestraint self, double x, Particle mu, Particle sigma) -> GaussianRestraint
        __init__(GaussianRestraint self, Particle x, double mu, Particle sigma) -> GaussianRestraint
        __init__(GaussianRestraint self, Particle x, Particle mu, double sigma) -> GaussianRestraint
        __init__(GaussianRestraint self, double x, double mu, Particle sigma) -> GaussianRestraint
        __init__(GaussianRestraint self, Particle x, double mu, double sigma) -> GaussianRestraint
        __init__(GaussianRestraint self, double x, Particle mu, double sigma) -> GaussianRestraint
        """
        _IMP_isd.GaussianRestraint_swiginit(self, _IMP_isd.new_GaussianRestraint(*args))

    def get_probability(self):
        r"""get_probability(GaussianRestraint self) -> double"""
        return _IMP_isd.GaussianRestraint_get_probability(self)

    def get_chi(self):
        r"""get_chi(GaussianRestraint self) -> double"""
        return _IMP_isd.GaussianRestraint_get_chi(self)

    def do_get_inputs(self):
        r"""do_get_inputs(GaussianRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.GaussianRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(GaussianRestraint self) -> VersionInfo"""
        return _IMP_isd.GaussianRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(GaussianRestraint self) -> std::string"""
        return _IMP_isd.GaussianRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(GaussianRestraint self) -> std::string"""
        return _IMP_isd.GaussianRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GaussianRestraint(o)


# Register GaussianRestraint in _IMP_isd:
_IMP_isd.GaussianRestraint_swigregister(GaussianRestraint)

class StudentTRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::StudentTRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, _ParticleIndexAdaptor mu, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, double mu, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, _ParticleIndexAdaptor mu, double sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, _ParticleIndexAdaptor mu, _ParticleIndexAdaptor sigma, double nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, double mu, double sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, double mu, _ParticleIndexAdaptor sigma, double nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, _ParticleIndexAdaptor mu, double sigma, double nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, _ParticleIndexAdaptor x, double mu, double sigma, double nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, _ParticleIndexAdaptor mu, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, double mu, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, _ParticleIndexAdaptor mu, double sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, _ParticleIndexAdaptor mu, _ParticleIndexAdaptor sigma, double nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, double mu, double sigma, _ParticleIndexAdaptor nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, double mu, _ParticleIndexAdaptor sigma, double nu) -> StudentTRestraint
        __init__(StudentTRestraint self, Model m, double x, _ParticleIndexAdaptor mu, double sigma, double nu) -> StudentTRestraint
        """
        _IMP_isd.StudentTRestraint_swiginit(self, _IMP_isd.new_StudentTRestraint(*args))

    def get_probability(self):
        r"""get_probability(StudentTRestraint self) -> double"""
        return _IMP_isd.StudentTRestraint_get_probability(self)

    def do_get_inputs(self):
        r"""do_get_inputs(StudentTRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.StudentTRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(StudentTRestraint self) -> VersionInfo"""
        return _IMP_isd.StudentTRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(StudentTRestraint self) -> std::string"""
        return _IMP_isd.StudentTRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(StudentTRestraint self) -> std::string"""
        return _IMP_isd.StudentTRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_StudentTRestraint(o)


# Register StudentTRestraint in _IMP_isd:
_IMP_isd.StudentTRestraint_swigregister(StudentTRestraint)

class LognormalRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::LognormalRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(LognormalRestraint self, Particle x, Particle mu, Particle sigma) -> LognormalRestraint
        __init__(LognormalRestraint self, double x, Particle mu, Particle sigma) -> LognormalRestraint
        __init__(LognormalRestraint self, Particle x, double mu, Particle sigma) -> LognormalRestraint
        __init__(LognormalRestraint self, Particle x, Particle mu, double sigma) -> LognormalRestraint
        __init__(LognormalRestraint self, double x, double mu, Particle sigma) -> LognormalRestraint
        __init__(LognormalRestraint self, Particle x, double mu, double sigma) -> LognormalRestraint
        __init__(LognormalRestraint self, double x, Particle mu, double sigma) -> LognormalRestraint
        """
        _IMP_isd.LognormalRestraint_swiginit(self, _IMP_isd.new_LognormalRestraint(*args))

    def get_probability(self):
        r"""get_probability(LognormalRestraint self) -> double"""
        return _IMP_isd.LognormalRestraint_get_probability(self)

    def get_chi(self):
        r"""get_chi(LognormalRestraint self) -> double"""
        return _IMP_isd.LognormalRestraint_get_chi(self)

    def do_get_inputs(self):
        r"""do_get_inputs(LognormalRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.LognormalRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(LognormalRestraint self) -> VersionInfo"""
        return _IMP_isd.LognormalRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(LognormalRestraint self) -> std::string"""
        return _IMP_isd.LognormalRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(LognormalRestraint self) -> std::string"""
        return _IMP_isd.LognormalRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_LognormalRestraint(o)


# Register LognormalRestraint in _IMP_isd:
_IMP_isd.LognormalRestraint_swigregister(LognormalRestraint)

class LognormalAmbiguousRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::LognormalAmbiguousRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, p1, p2, ki, sigmaG):
        r"""__init__(LognormalAmbiguousRestraint self, Particle p1, Particle p2, Particle ki, Particle sigmaG) -> LognormalAmbiguousRestraint"""
        _IMP_isd.LognormalAmbiguousRestraint_swiginit(self, _IMP_isd.new_LognormalAmbiguousRestraint(p1, p2, ki, sigmaG))

    def add_contribution(self, lexp, omega):
        r"""add_contribution(LognormalAmbiguousRestraint self, double lexp, Particle omega)"""
        return _IMP_isd.LognormalAmbiguousRestraint_add_contribution(self, lexp, omega)

    def get_number_of_contributions(self):
        r"""get_number_of_contributions(LognormalAmbiguousRestraint self) -> unsigned int"""
        return _IMP_isd.LognormalAmbiguousRestraint_get_number_of_contributions(self)

    def draw_k_from_posterior(self, kt):
        r"""draw_k_from_posterior(LognormalAmbiguousRestraint self, double kt)"""
        return _IMP_isd.LognormalAmbiguousRestraint_draw_k_from_posterior(self, kt)

    def get_probability(self):
        r"""get_probability(LognormalAmbiguousRestraint self) -> double"""
        return _IMP_isd.LognormalAmbiguousRestraint_get_probability(self)

    def do_get_inputs(self):
        r"""do_get_inputs(LognormalAmbiguousRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.LognormalAmbiguousRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(LognormalAmbiguousRestraint self) -> VersionInfo"""
        return _IMP_isd.LognormalAmbiguousRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(LognormalAmbiguousRestraint self) -> std::string"""
        return _IMP_isd.LognormalAmbiguousRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(LognormalAmbiguousRestraint self) -> std::string"""
        return _IMP_isd.LognormalAmbiguousRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_LognormalAmbiguousRestraint(o)


# Register LognormalAmbiguousRestraint in _IMP_isd:
_IMP_isd.LognormalAmbiguousRestraint_swigregister(LognormalAmbiguousRestraint)

class AmbiguousNOERestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::AmbiguousNOERestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, pc, sigma, gamma, Iexp):
        r"""__init__(AmbiguousNOERestraint self, Model m, PairContainer pc, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor gamma, double Iexp) -> AmbiguousNOERestraint"""
        _IMP_isd.AmbiguousNOERestraint_swiginit(self, _IMP_isd.new_AmbiguousNOERestraint(m, pc, sigma, gamma, Iexp))

    def get_probability(self):
        r"""get_probability(AmbiguousNOERestraint self) -> double"""
        return _IMP_isd.AmbiguousNOERestraint_get_probability(self)

    def get_chi(self):
        r"""get_chi(AmbiguousNOERestraint self) -> double"""
        return _IMP_isd.AmbiguousNOERestraint_get_chi(self)

    def do_get_inputs(self):
        r"""do_get_inputs(AmbiguousNOERestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.AmbiguousNOERestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(AmbiguousNOERestraint self) -> VersionInfo"""
        return _IMP_isd.AmbiguousNOERestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(AmbiguousNOERestraint self) -> std::string"""
        return _IMP_isd.AmbiguousNOERestraint___str__(self)

    def __repr__(self):
        r"""__repr__(AmbiguousNOERestraint self) -> std::string"""
        return _IMP_isd.AmbiguousNOERestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AmbiguousNOERestraint(o)


# Register AmbiguousNOERestraint in _IMP_isd:
_IMP_isd.AmbiguousNOERestraint_swigregister(AmbiguousNOERestraint)

class MarginalNOERestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::MarginalNOERestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m):
        r"""__init__(MarginalNOERestraint self, Model m) -> MarginalNOERestraint"""
        _IMP_isd.MarginalNOERestraint_swiginit(self, _IMP_isd.new_MarginalNOERestraint(m))

    def add_contribution(self, *args):
        r"""
        add_contribution(MarginalNOERestraint self, Particle p1, Particle p2, double Iexp)
        add_contribution(MarginalNOERestraint self, PairContainer pc, double Iexp)
        """
        return _IMP_isd.MarginalNOERestraint_add_contribution(self, *args)

    def get_log_gammahat(self):
        r"""get_log_gammahat(MarginalNOERestraint self) -> double"""
        return _IMP_isd.MarginalNOERestraint_get_log_gammahat(self)

    def get_SS(self):
        r"""get_SS(MarginalNOERestraint self) -> double"""
        return _IMP_isd.MarginalNOERestraint_get_SS(self)

    def get_number_of_contributions(self):
        r"""get_number_of_contributions(MarginalNOERestraint self) -> unsigned int"""
        return _IMP_isd.MarginalNOERestraint_get_number_of_contributions(self)

    def get_probability(self):
        r"""get_probability(MarginalNOERestraint self) -> double"""
        return _IMP_isd.MarginalNOERestraint_get_probability(self)

    def do_get_inputs(self):
        r"""do_get_inputs(MarginalNOERestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.MarginalNOERestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(MarginalNOERestraint self) -> VersionInfo"""
        return _IMP_isd.MarginalNOERestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(MarginalNOERestraint self) -> std::string"""
        return _IMP_isd.MarginalNOERestraint___str__(self)

    def __repr__(self):
        r"""__repr__(MarginalNOERestraint self) -> std::string"""
        return _IMP_isd.MarginalNOERestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MarginalNOERestraint(o)


# Register MarginalNOERestraint in _IMP_isd:
_IMP_isd.MarginalNOERestraint_swigregister(MarginalNOERestraint)

class MarginalHBondRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::MarginalHBondRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m):
        r"""__init__(MarginalHBondRestraint self, Model m) -> MarginalHBondRestraint"""
        _IMP_isd.MarginalHBondRestraint_swiginit(self, _IMP_isd.new_MarginalHBondRestraint(m))

    def add_contribution(self, *args):
        r"""
        add_contribution(MarginalHBondRestraint self, Particle p1, Particle p2, double Iexp)
        add_contribution(MarginalHBondRestraint self, PairContainer pc, double Iexp)
        """
        return _IMP_isd.MarginalHBondRestraint_add_contribution(self, *args)

    def get_logsquares(self):
        r"""get_logsquares(MarginalHBondRestraint self) -> double"""
        return _IMP_isd.MarginalHBondRestraint_get_logsquares(self)

    def get_number_of_contributions(self):
        r"""get_number_of_contributions(MarginalHBondRestraint self) -> unsigned int"""
        return _IMP_isd.MarginalHBondRestraint_get_number_of_contributions(self)

    def get_probability(self):
        r"""get_probability(MarginalHBondRestraint self) -> double"""
        return _IMP_isd.MarginalHBondRestraint_get_probability(self)

    def do_get_inputs(self):
        r"""do_get_inputs(MarginalHBondRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.MarginalHBondRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(MarginalHBondRestraint self) -> VersionInfo"""
        return _IMP_isd.MarginalHBondRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(MarginalHBondRestraint self) -> std::string"""
        return _IMP_isd.MarginalHBondRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(MarginalHBondRestraint self) -> std::string"""
        return _IMP_isd.MarginalHBondRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MarginalHBondRestraint(o)


# Register MarginalHBondRestraint in _IMP_isd:
_IMP_isd.MarginalHBondRestraint_swigregister(MarginalHBondRestraint)

class TALOSRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::TALOSRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(TALOSRestraint self, Model m, IMP::Particles p, IMP::Floats data, Particle kappa) -> TALOSRestraint
        __init__(TALOSRestraint self, Model m, Particle p1, Particle p2, Particle p3, Particle p4, IMP::Floats data, Particle kappa) -> TALOSRestraint
        __init__(TALOSRestraint self, Model m, IMP::Particles p, unsigned int N, double R0, double chiexp, Particle kappa) -> TALOSRestraint
        __init__(TALOSRestraint self, Model m, Particle p1, Particle p2, Particle p3, Particle p4, unsigned int N, double R0, double chiexp, Particle kappa) -> TALOSRestraint
        """
        _IMP_isd.TALOSRestraint_swiginit(self, _IMP_isd.new_TALOSRestraint(*args))

    def get_probability(self):
        r"""get_probability(TALOSRestraint self) -> double"""
        return _IMP_isd.TALOSRestraint_get_probability(self)

    def get_R0(self):
        r"""get_R0(TALOSRestraint self) -> double"""
        return _IMP_isd.TALOSRestraint_get_R0(self)

    def get_chiexp(self):
        r"""get_chiexp(TALOSRestraint self) -> double"""
        return _IMP_isd.TALOSRestraint_get_chiexp(self)

    def do_get_inputs(self):
        r"""do_get_inputs(TALOSRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.TALOSRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(TALOSRestraint self) -> VersionInfo"""
        return _IMP_isd.TALOSRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(TALOSRestraint self) -> std::string"""
        return _IMP_isd.TALOSRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(TALOSRestraint self) -> std::string"""
        return _IMP_isd.TALOSRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_TALOSRestraint(o)


# Register TALOSRestraint in _IMP_isd:
_IMP_isd.TALOSRestraint_swigregister(TALOSRestraint)

class RepulsiveDistancePairScore(IMP.PairScore):
    r"""Proxy of C++ IMP::isd::RepulsiveDistancePairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, d0, k):
        r"""__init__(RepulsiveDistancePairScore self, double d0, double k) -> RepulsiveDistancePairScore"""
        _IMP_isd.RepulsiveDistancePairScore_swiginit(self, _IMP_isd.new_RepulsiveDistancePairScore(d0, k))

    def get_rest_length(self):
        r"""get_rest_length(RepulsiveDistancePairScore self) -> double"""
        return _IMP_isd.RepulsiveDistancePairScore_get_rest_length(self)

    def get_stiffness(self):
        r"""get_stiffness(RepulsiveDistancePairScore self) -> double"""
        return _IMP_isd.RepulsiveDistancePairScore_get_stiffness(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(RepulsiveDistancePairScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.RepulsiveDistancePairScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(RepulsiveDistancePairScore self) -> VersionInfo"""
        return _IMP_isd.RepulsiveDistancePairScore_get_version_info(self)

    def __str__(self):
        r"""__str__(RepulsiveDistancePairScore self) -> std::string"""
        return _IMP_isd.RepulsiveDistancePairScore___str__(self)

    def __repr__(self):
        r"""__repr__(RepulsiveDistancePairScore self) -> std::string"""
        return _IMP_isd.RepulsiveDistancePairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_RepulsiveDistancePairScore(o)


# Register RepulsiveDistancePairScore in _IMP_isd:
_IMP_isd.RepulsiveDistancePairScore_swigregister(RepulsiveDistancePairScore)

class AmbiguousRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::AmbiguousRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(AmbiguousRestraint self, Model m, int d, Restraint r0, Restraint r1) -> AmbiguousRestraint
        __init__(AmbiguousRestraint self, Model m, int d, IMP::Restraints rs) -> AmbiguousRestraint
        """
        _IMP_isd.AmbiguousRestraint_swiginit(self, _IMP_isd.new_AmbiguousRestraint(*args))

    def get_probability(self):
        r"""get_probability(AmbiguousRestraint self) -> double"""
        return _IMP_isd.AmbiguousRestraint_get_probability(self)

    def do_get_inputs(self):
        r"""do_get_inputs(AmbiguousRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.AmbiguousRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(AmbiguousRestraint self) -> VersionInfo"""
        return _IMP_isd.AmbiguousRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(AmbiguousRestraint self) -> std::string"""
        return _IMP_isd.AmbiguousRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(AmbiguousRestraint self) -> std::string"""
        return _IMP_isd.AmbiguousRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AmbiguousRestraint(o)


# Register AmbiguousRestraint in _IMP_isd:
_IMP_isd.AmbiguousRestraint_swigregister(AmbiguousRestraint)

IMP_ISD_UNIVARIATE_FUNCTIONS_MINIMUM = _IMP_isd.IMP_ISD_UNIVARIATE_FUNCTIONS_MINIMUM

class UnivariateFunction(IMP.Object):
    r"""Proxy of C++ IMP::isd::UnivariateFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def __call__(self, *args):
        r"""
        __call__(UnivariateFunction self, IMP::Floats const & x) -> IMP::Floats
        __call__(UnivariateFunction self, IMP::FloatsList const & xlist) -> Eigen::VectorXd
        __call__(UnivariateFunction self, IMP::FloatsList const & xlist, bool stupid) -> IMP::FloatsList
        """
        return _IMP_isd.UnivariateFunction___call__(self, *args)

    def has_changed(self):
        r"""has_changed(UnivariateFunction self) -> bool"""
        return _IMP_isd.UnivariateFunction_has_changed(self)

    def update(self):
        r"""update(UnivariateFunction self)"""
        return _IMP_isd.UnivariateFunction_update(self)

    def add_to_derivatives(self, x, accum):
        r"""add_to_derivatives(UnivariateFunction self, IMP::Floats const & x, DerivativeAccumulator accum)"""
        return _IMP_isd.UnivariateFunction_add_to_derivatives(self, x, accum)

    def add_to_particle_derivative(self, particle_no, value, accum):
        r"""add_to_particle_derivative(UnivariateFunction self, unsigned int particle_no, double value, DerivativeAccumulator accum)"""
        return _IMP_isd.UnivariateFunction_add_to_particle_derivative(self, particle_no, value, accum)

    def get_derivative_vector(self, particle_no, xlist):
        r"""get_derivative_vector(UnivariateFunction self, unsigned int particle_no, IMP::FloatsList const & xlist) -> Eigen::VectorXd"""
        return _IMP_isd.UnivariateFunction_get_derivative_vector(self, particle_no, xlist)

    def get_derivative_matrix(self, xlist, stupid):
        r"""get_derivative_matrix(UnivariateFunction self, IMP::FloatsList const & xlist, bool stupid) -> IMP::FloatsList"""
        return _IMP_isd.UnivariateFunction_get_derivative_matrix(self, xlist, stupid)

    def get_second_derivative_vector(self, *args):
        r"""
        get_second_derivative_vector(UnivariateFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist) -> Eigen::VectorXd
        get_second_derivative_vector(UnivariateFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist, bool stupid) -> IMP::FloatsList
        """
        return _IMP_isd.UnivariateFunction_get_second_derivative_vector(self, *args)

    def get_ndims_x(self):
        r"""get_ndims_x(UnivariateFunction self) -> unsigned int"""
        return _IMP_isd.UnivariateFunction_get_ndims_x(self)

    def get_ndims_y(self):
        r"""get_ndims_y(UnivariateFunction self) -> unsigned int"""
        return _IMP_isd.UnivariateFunction_get_ndims_y(self)

    def get_number_of_particles(self):
        r"""get_number_of_particles(UnivariateFunction self) -> unsigned int"""
        return _IMP_isd.UnivariateFunction_get_number_of_particles(self)

    def get_particle_is_optimized(self, particle_no):
        r"""get_particle_is_optimized(UnivariateFunction self, unsigned int particle_no) -> bool"""
        return _IMP_isd.UnivariateFunction_get_particle_is_optimized(self, particle_no)

    def get_number_of_optimized_particles(self):
        r"""get_number_of_optimized_particles(UnivariateFunction self) -> unsigned int"""
        return _IMP_isd.UnivariateFunction_get_number_of_optimized_particles(self)

    def get_inputs(self):
        r"""get_inputs(UnivariateFunction self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.UnivariateFunction_get_inputs(self)
    __swig_destroy__ = _IMP_isd.delete_UnivariateFunction

    def __str__(self):
        r"""__str__(UnivariateFunction self) -> std::string"""
        return _IMP_isd.UnivariateFunction___str__(self)

    def __repr__(self):
        r"""__repr__(UnivariateFunction self) -> std::string"""
        return _IMP_isd.UnivariateFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_UnivariateFunction(o)


# Register UnivariateFunction in _IMP_isd:
_IMP_isd.UnivariateFunction_swigregister(UnivariateFunction)

class Linear1DFunction(UnivariateFunction):
    r"""Proxy of C++ IMP::isd::Linear1DFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, a, b):
        r"""__init__(Linear1DFunction self, Particle a, Particle b) -> Linear1DFunction"""
        _IMP_isd.Linear1DFunction_swiginit(self, _IMP_isd.new_Linear1DFunction(a, b))

    def __call__(self, *args):
        r"""
        __call__(Linear1DFunction self, IMP::Floats const & x) -> IMP::Floats
        __call__(Linear1DFunction self, IMP::FloatsList const & xlist) -> Eigen::VectorXd
        __call__(Linear1DFunction self, IMP::FloatsList const & xlist, bool arg3) -> IMP::FloatsList
        """
        return _IMP_isd.Linear1DFunction___call__(self, *args)

    def get_second_derivative_vector(self, *args):
        r"""
        get_second_derivative_vector(Linear1DFunction self, unsigned int arg2, unsigned int arg3, IMP::FloatsList const & xlist) -> Eigen::VectorXd
        get_second_derivative_vector(Linear1DFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist, bool arg5) -> IMP::FloatsList
        """
        return _IMP_isd.Linear1DFunction_get_second_derivative_vector(self, *args)

    def get_version_info(self):
        r"""get_version_info(Linear1DFunction self) -> VersionInfo"""
        return _IMP_isd.Linear1DFunction_get_version_info(self)

    def __str__(self):
        r"""__str__(Linear1DFunction self) -> std::string"""
        return _IMP_isd.Linear1DFunction___str__(self)

    def __repr__(self):
        r"""__repr__(Linear1DFunction self) -> std::string"""
        return _IMP_isd.Linear1DFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Linear1DFunction(o)


# Register Linear1DFunction in _IMP_isd:
_IMP_isd.Linear1DFunction_swigregister(Linear1DFunction)

class GeneralizedGuinierPorodFunction(UnivariateFunction):
    r"""Proxy of C++ IMP::isd::GeneralizedGuinierPorodFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, G, Rg, d, s, A):
        r"""__init__(GeneralizedGuinierPorodFunction self, Particle G, Particle Rg, Particle d, Particle s, Particle A) -> GeneralizedGuinierPorodFunction"""
        _IMP_isd.GeneralizedGuinierPorodFunction_swiginit(self, _IMP_isd.new_GeneralizedGuinierPorodFunction(G, Rg, d, s, A))

    def __call__(self, *args):
        r"""
        __call__(GeneralizedGuinierPorodFunction self, IMP::Floats const & x) -> IMP::Floats
        __call__(GeneralizedGuinierPorodFunction self, IMP::FloatsList const & xlist) -> Eigen::VectorXd
        __call__(GeneralizedGuinierPorodFunction self, IMP::FloatsList const & xlist, bool arg3) -> IMP::FloatsList
        """
        return _IMP_isd.GeneralizedGuinierPorodFunction___call__(self, *args)

    def get_second_derivative_vector(self, *args):
        r"""
        get_second_derivative_vector(GeneralizedGuinierPorodFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist) -> Eigen::VectorXd
        get_second_derivative_vector(GeneralizedGuinierPorodFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist, bool arg5) -> IMP::FloatsList
        """
        return _IMP_isd.GeneralizedGuinierPorodFunction_get_second_derivative_vector(self, *args)

    def get_version_info(self):
        r"""get_version_info(GeneralizedGuinierPorodFunction self) -> VersionInfo"""
        return _IMP_isd.GeneralizedGuinierPorodFunction_get_version_info(self)

    def __str__(self):
        r"""__str__(GeneralizedGuinierPorodFunction self) -> std::string"""
        return _IMP_isd.GeneralizedGuinierPorodFunction___str__(self)

    def __repr__(self):
        r"""__repr__(GeneralizedGuinierPorodFunction self) -> std::string"""
        return _IMP_isd.GeneralizedGuinierPorodFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GeneralizedGuinierPorodFunction(o)


# Register GeneralizedGuinierPorodFunction in _IMP_isd:
_IMP_isd.GeneralizedGuinierPorodFunction_swigregister(GeneralizedGuinierPorodFunction)

IMP_ISD_BIVARIATE_FUNCTIONS_MINIMUM = _IMP_isd.IMP_ISD_BIVARIATE_FUNCTIONS_MINIMUM

class BivariateFunction(IMP.Object):
    r"""Proxy of C++ IMP::isd::BivariateFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def __call__(self, *args):
        r"""
        __call__(BivariateFunction self, IMP::Floats const & x1, IMP::Floats const & x2) -> IMP::Floats
        __call__(BivariateFunction self, IMP::FloatsList const & xlist) -> Eigen::MatrixXd
        __call__(BivariateFunction self, IMP::FloatsList const & xlist, bool stupid) -> IMP::FloatsList
        """
        return _IMP_isd.BivariateFunction___call__(self, *args)

    def has_changed(self):
        r"""has_changed(BivariateFunction self) -> bool"""
        return _IMP_isd.BivariateFunction_has_changed(self)

    def update(self):
        r"""update(BivariateFunction self)"""
        return _IMP_isd.BivariateFunction_update(self)

    def add_to_derivatives(self, x1, x2, accum):
        r"""add_to_derivatives(BivariateFunction self, IMP::Floats const & x1, IMP::Floats const & x2, DerivativeAccumulator accum)"""
        return _IMP_isd.BivariateFunction_add_to_derivatives(self, x1, x2, accum)

    def add_to_particle_derivative(self, particle_no, value, accum):
        r"""add_to_particle_derivative(BivariateFunction self, unsigned int particle_no, double value, DerivativeAccumulator accum)"""
        return _IMP_isd.BivariateFunction_add_to_particle_derivative(self, particle_no, value, accum)

    def get_derivative_matrix(self, *args):
        r"""
        get_derivative_matrix(BivariateFunction self, unsigned int particle_no, IMP::FloatsList const & xlist) -> Eigen::MatrixXd
        get_derivative_matrix(BivariateFunction self, unsigned int particle_no, IMP::FloatsList const & xlist, bool stupid) -> IMP::FloatsList
        """
        return _IMP_isd.BivariateFunction_get_derivative_matrix(self, *args)

    def get_second_derivative_matrix(self, *args):
        r"""
        get_second_derivative_matrix(BivariateFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist) -> Eigen::MatrixXd
        get_second_derivative_matrix(BivariateFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist, bool stupid) -> IMP::FloatsList
        """
        return _IMP_isd.BivariateFunction_get_second_derivative_matrix(self, *args)

    def get_ndims_x1(self):
        r"""get_ndims_x1(BivariateFunction self) -> unsigned int"""
        return _IMP_isd.BivariateFunction_get_ndims_x1(self)

    def get_ndims_x2(self):
        r"""get_ndims_x2(BivariateFunction self) -> unsigned int"""
        return _IMP_isd.BivariateFunction_get_ndims_x2(self)

    def get_ndims_y(self):
        r"""get_ndims_y(BivariateFunction self) -> unsigned int"""
        return _IMP_isd.BivariateFunction_get_ndims_y(self)

    def get_number_of_particles(self):
        r"""get_number_of_particles(BivariateFunction self) -> unsigned int"""
        return _IMP_isd.BivariateFunction_get_number_of_particles(self)

    def get_particle_is_optimized(self, particle_no):
        r"""get_particle_is_optimized(BivariateFunction self, unsigned int particle_no) -> bool"""
        return _IMP_isd.BivariateFunction_get_particle_is_optimized(self, particle_no)

    def get_number_of_optimized_particles(self):
        r"""get_number_of_optimized_particles(BivariateFunction self) -> unsigned int"""
        return _IMP_isd.BivariateFunction_get_number_of_optimized_particles(self)

    def get_inputs(self):
        r"""get_inputs(BivariateFunction self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.BivariateFunction_get_inputs(self)
    __swig_destroy__ = _IMP_isd.delete_BivariateFunction

    def __str__(self):
        r"""__str__(BivariateFunction self) -> std::string"""
        return _IMP_isd.BivariateFunction___str__(self)

    def __repr__(self):
        r"""__repr__(BivariateFunction self) -> std::string"""
        return _IMP_isd.BivariateFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BivariateFunction(o)


# Register BivariateFunction in _IMP_isd:
_IMP_isd.BivariateFunction_swigregister(BivariateFunction)

class Covariance1DFunction(BivariateFunction):
    r"""Proxy of C++ IMP::isd::Covariance1DFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, tau, ilambda, alpha=2.0, jitter=0.0, cutoff=1e-7):
        r"""__init__(Covariance1DFunction self, Particle tau, Particle ilambda, double alpha=2.0, double jitter=0.0, double cutoff=1e-7) -> Covariance1DFunction"""
        _IMP_isd.Covariance1DFunction_swiginit(self, _IMP_isd.new_Covariance1DFunction(tau, ilambda, alpha, jitter, cutoff))

    def __call__(self, *args):
        r"""
        __call__(Covariance1DFunction self, IMP::Floats const & x1, IMP::Floats const & x2) -> IMP::Floats
        __call__(Covariance1DFunction self, IMP::FloatsList const & xlist) -> Eigen::MatrixXd
        __call__(Covariance1DFunction self, IMP::FloatsList const & xlist, bool arg3) -> IMP::FloatsList
        """
        return _IMP_isd.Covariance1DFunction___call__(self, *args)

    def get_derivative_matrix(self, *args):
        r"""
        get_derivative_matrix(Covariance1DFunction self, unsigned int particle_no, IMP::FloatsList const & xlist) -> Eigen::MatrixXd
        get_derivative_matrix(Covariance1DFunction self, unsigned int particle_no, IMP::FloatsList const & xlist, bool arg4) -> IMP::FloatsList
        """
        return _IMP_isd.Covariance1DFunction_get_derivative_matrix(self, *args)

    def get_second_derivative_matrix(self, *args):
        r"""
        get_second_derivative_matrix(Covariance1DFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist) -> Eigen::MatrixXd
        get_second_derivative_matrix(Covariance1DFunction self, unsigned int particle_a, unsigned int particle_b, IMP::FloatsList const & xlist, bool arg5) -> IMP::FloatsList
        """
        return _IMP_isd.Covariance1DFunction_get_second_derivative_matrix(self, *args)

    def get_version_info(self):
        r"""get_version_info(Covariance1DFunction self) -> VersionInfo"""
        return _IMP_isd.Covariance1DFunction_get_version_info(self)

    def __str__(self):
        r"""__str__(Covariance1DFunction self) -> std::string"""
        return _IMP_isd.Covariance1DFunction___str__(self)

    def __repr__(self):
        r"""__repr__(Covariance1DFunction self) -> std::string"""
        return _IMP_isd.Covariance1DFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Covariance1DFunction(o)


# Register Covariance1DFunction in _IMP_isd:
_IMP_isd.Covariance1DFunction_swigregister(Covariance1DFunction)

class GaussianProcessInterpolation(IMP.Object):
    r"""Proxy of C++ IMP::isd::GaussianProcessInterpolation class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, x, sample_mean, sample_std, n_obs, mean_function, covariance_function, sigma, sparse_cutoff=1e-7):
        r"""__init__(GaussianProcessInterpolation self, IMP::FloatsList x, IMP::Floats sample_mean, IMP::Floats sample_std, unsigned int n_obs, UnivariateFunction mean_function, BivariateFunction covariance_function, Particle sigma, double sparse_cutoff=1e-7) -> GaussianProcessInterpolation"""
        _IMP_isd.GaussianProcessInterpolation_swiginit(self, _IMP_isd.new_GaussianProcessInterpolation(x, sample_mean, sample_std, n_obs, mean_function, covariance_function, sigma, sparse_cutoff))

    def get_posterior_mean(self, x):
        r"""get_posterior_mean(GaussianProcessInterpolation self, IMP::Floats x) -> double"""
        return _IMP_isd.GaussianProcessInterpolation_get_posterior_mean(self, x)

    def get_posterior_covariance(self, x1, x2):
        r"""get_posterior_covariance(GaussianProcessInterpolation self, IMP::Floats x1, IMP::Floats x2) -> double"""
        return _IMP_isd.GaussianProcessInterpolation_get_posterior_covariance(self, x1, x2)

    def get_posterior_covariance_matrix(self, x, arg3):
        r"""get_posterior_covariance_matrix(GaussianProcessInterpolation self, IMP::FloatsList x, bool arg3) -> IMP::FloatsList"""
        return _IMP_isd.GaussianProcessInterpolation_get_posterior_covariance_matrix(self, x, arg3)

    def get_posterior_covariance_derivative(self, x, arg3):
        r"""get_posterior_covariance_derivative(GaussianProcessInterpolation self, IMP::Floats x, bool arg3) -> IMP::Floats"""
        return _IMP_isd.GaussianProcessInterpolation_get_posterior_covariance_derivative(self, x, arg3)

    def get_posterior_covariance_hessian(self, x, arg3):
        r"""get_posterior_covariance_hessian(GaussianProcessInterpolation self, IMP::Floats x, bool arg3) -> IMP::FloatsList"""
        return _IMP_isd.GaussianProcessInterpolation_get_posterior_covariance_hessian(self, x, arg3)

    def get_inputs(self):
        r"""get_inputs(GaussianProcessInterpolation self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.GaussianProcessInterpolation_get_inputs(self)

    def force_mean_update(self):
        r"""force_mean_update(GaussianProcessInterpolation self)"""
        return _IMP_isd.GaussianProcessInterpolation_force_mean_update(self)

    def force_covariance_update(self):
        r"""force_covariance_update(GaussianProcessInterpolation self)"""
        return _IMP_isd.GaussianProcessInterpolation_force_covariance_update(self)

    def get_number_of_m_particles(self):
        r"""get_number_of_m_particles(GaussianProcessInterpolation self) -> unsigned int"""
        return _IMP_isd.GaussianProcessInterpolation_get_number_of_m_particles(self)

    def get_m_particle_is_optimized(self, i):
        r"""get_m_particle_is_optimized(GaussianProcessInterpolation self, unsigned int i) -> bool"""
        return _IMP_isd.GaussianProcessInterpolation_get_m_particle_is_optimized(self, i)

    def get_number_of_Omega_particles(self):
        r"""get_number_of_Omega_particles(GaussianProcessInterpolation self) -> unsigned int"""
        return _IMP_isd.GaussianProcessInterpolation_get_number_of_Omega_particles(self)

    def get_Omega_particle_is_optimized(self, i):
        r"""get_Omega_particle_is_optimized(GaussianProcessInterpolation self, unsigned int i) -> bool"""
        return _IMP_isd.GaussianProcessInterpolation_get_Omega_particle_is_optimized(self, i)

    def get_data_abscissa(self):
        r"""get_data_abscissa(GaussianProcessInterpolation self) -> IMP::FloatsList"""
        return _IMP_isd.GaussianProcessInterpolation_get_data_abscissa(self)

    def get_data_mean(self):
        r"""get_data_mean(GaussianProcessInterpolation self) -> IMP::Floats"""
        return _IMP_isd.GaussianProcessInterpolation_get_data_mean(self)

    def get_data_variance(self):
        r"""get_data_variance(GaussianProcessInterpolation self) -> IMP::FloatsList"""
        return _IMP_isd.GaussianProcessInterpolation_get_data_variance(self)

    def get_version_info(self):
        r"""get_version_info(GaussianProcessInterpolation self) -> VersionInfo"""
        return _IMP_isd.GaussianProcessInterpolation_get_version_info(self)

    def __str__(self):
        r"""__str__(GaussianProcessInterpolation self) -> std::string"""
        return _IMP_isd.GaussianProcessInterpolation___str__(self)

    def __repr__(self):
        r"""__repr__(GaussianProcessInterpolation self) -> std::string"""
        return _IMP_isd.GaussianProcessInterpolation___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GaussianProcessInterpolation(o)


# Register GaussianProcessInterpolation in _IMP_isd:
_IMP_isd.GaussianProcessInterpolation_swigregister(GaussianProcessInterpolation)

class GaussianProcessInterpolationRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::GaussianProcessInterpolationRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, gpi):
        r"""__init__(GaussianProcessInterpolationRestraint self, Model m, GaussianProcessInterpolation gpi) -> GaussianProcessInterpolationRestraint"""
        _IMP_isd.GaussianProcessInterpolationRestraint_swiginit(self, _IMP_isd.new_GaussianProcessInterpolationRestraint(m, gpi))

    def get_probability(self):
        r"""get_probability(GaussianProcessInterpolationRestraint self) -> double"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_get_probability(self)

    def set_use_cg(self, use, tol):
        r"""set_use_cg(GaussianProcessInterpolationRestraint self, bool use, double tol)"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_set_use_cg(self, use, tol)

    def get_minus_log_normalization(self):
        r"""get_minus_log_normalization(GaussianProcessInterpolationRestraint self) -> double"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_get_minus_log_normalization(self)

    def get_minus_exponent(self):
        r"""get_minus_exponent(GaussianProcessInterpolationRestraint self) -> double"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_get_minus_exponent(self)

    def get_logdet_hessian(self):
        r"""get_logdet_hessian(GaussianProcessInterpolationRestraint self) -> double"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_get_logdet_hessian(self)

    def get_hessian(self, *args):
        r"""
        get_hessian(GaussianProcessInterpolationRestraint self) -> Eigen::MatrixXd
        get_hessian(GaussianProcessInterpolationRestraint self, bool unused) -> IMP::FloatsList
        """
        return _IMP_isd.GaussianProcessInterpolationRestraint_get_hessian(self, *args)

    def do_get_inputs(self):
        r"""do_get_inputs(GaussianProcessInterpolationRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(GaussianProcessInterpolationRestraint self) -> VersionInfo"""
        return _IMP_isd.GaussianProcessInterpolationRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(GaussianProcessInterpolationRestraint self) -> std::string"""
        return _IMP_isd.GaussianProcessInterpolationRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(GaussianProcessInterpolationRestraint self) -> std::string"""
        return _IMP_isd.GaussianProcessInterpolationRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GaussianProcessInterpolationRestraint(o)


# Register GaussianProcessInterpolationRestraint in _IMP_isd:
_IMP_isd.GaussianProcessInterpolationRestraint_swigregister(GaussianProcessInterpolationRestraint)

class MolecularDynamics(IMP.atom.MolecularDynamics):
    r"""Proxy of C++ IMP::isd::MolecularDynamics class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m=None):
        r"""__init__(MolecularDynamics self, Model m=None) -> MolecularDynamics"""
        _IMP_isd.MolecularDynamics_swiginit(self, _IMP_isd.new_MolecularDynamics(m))

    def __str__(self):
        r"""__str__(MolecularDynamics self) -> std::string"""
        return _IMP_isd.MolecularDynamics___str__(self)

    def __repr__(self):
        r"""__repr__(MolecularDynamics self) -> std::string"""
        return _IMP_isd.MolecularDynamics___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MolecularDynamics(o)

    __swig_destroy__ = _IMP_isd.delete_MolecularDynamics

# Register MolecularDynamics in _IMP_isd:
_IMP_isd.MolecularDynamics_swigregister(MolecularDynamics)

class MolecularDynamicsMover(IMP.core.MonteCarloMover):
    r"""Proxy of C++ IMP::isd::MolecularDynamicsMover class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, nsteps=100, timestep=1.):
        r"""__init__(MolecularDynamicsMover self, Model m, unsigned int nsteps=100, IMP::Float timestep=1.) -> MolecularDynamicsMover"""
        _IMP_isd.MolecularDynamicsMover_swiginit(self, _IMP_isd.new_MolecularDynamicsMover(m, nsteps, timestep))

    def get_md(self):
        r"""get_md(MolecularDynamicsMover self) -> MolecularDynamics"""
        return _IMP_isd.MolecularDynamicsMover_get_md(self)

    def get_number_of_md_steps(self):
        r"""get_number_of_md_steps(MolecularDynamicsMover self) -> unsigned int"""
        return _IMP_isd.MolecularDynamicsMover_get_number_of_md_steps(self)

    def set_number_of_md_steps(self, nsteps):
        r"""set_number_of_md_steps(MolecularDynamicsMover self, unsigned int nsteps)"""
        return _IMP_isd.MolecularDynamicsMover_set_number_of_md_steps(self, nsteps)

    def get_version_info(self):
        r"""get_version_info(MolecularDynamicsMover self) -> VersionInfo"""
        return _IMP_isd.MolecularDynamicsMover_get_version_info(self)

    def __str__(self):
        r"""__str__(MolecularDynamicsMover self) -> std::string"""
        return _IMP_isd.MolecularDynamicsMover___str__(self)

    def __repr__(self):
        r"""__repr__(MolecularDynamicsMover self) -> std::string"""
        return _IMP_isd.MolecularDynamicsMover___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MolecularDynamicsMover(o)


# Register MolecularDynamicsMover in _IMP_isd:
_IMP_isd.MolecularDynamicsMover_swigregister(MolecularDynamicsMover)

class HybridMonteCarlo(IMP.core.MonteCarlo):
    r"""Proxy of C++ IMP::isd::HybridMonteCarlo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, kT=1.0, steps=100, timestep=1.0, persistence=1):
        r"""__init__(HybridMonteCarlo self, Model m, IMP::Float kT=1.0, unsigned int steps=100, IMP::Float timestep=1.0, unsigned int persistence=1) -> HybridMonteCarlo"""
        _IMP_isd.HybridMonteCarlo_swiginit(self, _IMP_isd.new_HybridMonteCarlo(m, kT, steps, timestep, persistence))

    def get_kinetic_energy(self):
        r"""get_kinetic_energy(HybridMonteCarlo self) -> IMP::Float"""
        return _IMP_isd.HybridMonteCarlo_get_kinetic_energy(self)

    def get_potential_energy(self):
        r"""get_potential_energy(HybridMonteCarlo self) -> IMP::Float"""
        return _IMP_isd.HybridMonteCarlo_get_potential_energy(self)

    def get_total_energy(self):
        r"""get_total_energy(HybridMonteCarlo self) -> IMP::Float"""
        return _IMP_isd.HybridMonteCarlo_get_total_energy(self)

    def set_timestep(self, ts):
        r"""set_timestep(HybridMonteCarlo self, IMP::Float ts)"""
        return _IMP_isd.HybridMonteCarlo_set_timestep(self, ts)

    def get_timestep(self):
        r"""get_timestep(HybridMonteCarlo self) -> double"""
        return _IMP_isd.HybridMonteCarlo_get_timestep(self)

    def set_number_of_md_steps(self, nsteps):
        r"""set_number_of_md_steps(HybridMonteCarlo self, unsigned int nsteps)"""
        return _IMP_isd.HybridMonteCarlo_set_number_of_md_steps(self, nsteps)

    def get_number_of_md_steps(self):
        r"""get_number_of_md_steps(HybridMonteCarlo self) -> unsigned int"""
        return _IMP_isd.HybridMonteCarlo_get_number_of_md_steps(self)

    def set_persistence(self, persistence=1):
        r"""set_persistence(HybridMonteCarlo self, unsigned int persistence=1)"""
        return _IMP_isd.HybridMonteCarlo_set_persistence(self, persistence)

    def get_persistence(self):
        r"""get_persistence(HybridMonteCarlo self) -> unsigned int"""
        return _IMP_isd.HybridMonteCarlo_get_persistence(self)

    def get_md(self):
        r"""get_md(HybridMonteCarlo self) -> MolecularDynamics"""
        return _IMP_isd.HybridMonteCarlo_get_md(self)

    def do_evaluate(self, arg2, arg3):
        r"""do_evaluate(HybridMonteCarlo self, IMP::ParticleIndexes const & arg2, bool arg3) -> double"""
        return _IMP_isd.HybridMonteCarlo_do_evaluate(self, arg2, arg3)

    def do_step(self):
        r"""do_step(HybridMonteCarlo self)"""
        return _IMP_isd.HybridMonteCarlo_do_step(self)

    def __str__(self):
        r"""__str__(HybridMonteCarlo self) -> std::string"""
        return _IMP_isd.HybridMonteCarlo___str__(self)

    def __repr__(self):
        r"""__repr__(HybridMonteCarlo self) -> std::string"""
        return _IMP_isd.HybridMonteCarlo___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_HybridMonteCarlo(o)


# Register HybridMonteCarlo in _IMP_isd:
_IMP_isd.HybridMonteCarlo_swigregister(HybridMonteCarlo)

class FretData(IMP.Object):
    r"""Proxy of C++ IMP::isd::FretData class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, d_term, d_center, d_int, s_grid, R0, Rmin, Rmax, do_limit=True):
        r"""__init__(FretData self, IMP::Floats d_term, IMP::Floats d_center, IMP::Floats d_int, IMP::Floats s_grid, IMP::Float R0, IMP::Float Rmin, IMP::Float Rmax, bool do_limit=True) -> FretData"""
        _IMP_isd.FretData_swiginit(self, _IMP_isd.new_FretData(d_term, d_center, d_int, s_grid, R0, Rmin, Rmax, do_limit))

    def get_closest(self, vec, value):
        r"""get_closest(FretData self, DistBase vec, double value) -> int"""
        return _IMP_isd.FretData_get_closest(self, vec, value)

    def get_probability(self, distn, dist, sigma):
        r"""get_probability(FretData self, IMP::Float distn, IMP::Float dist, IMP::Float sigma) -> IMP::Float"""
        return _IMP_isd.FretData_get_probability(self, distn, dist, sigma)

    def get_kernel(self, dist, R0):
        r"""get_kernel(FretData self, IMP::Float dist, IMP::Float R0) -> IMP::Float"""
        return _IMP_isd.FretData_get_kernel(self, dist, R0)

    def get_marginal_element(self, d_term, d_center, sigma):
        r"""get_marginal_element(FretData self, IMP::Float d_term, IMP::Float d_center, IMP::Float sigma) -> IMP::FloatPair"""
        return _IMP_isd.FretData_get_marginal_element(self, d_term, d_center, sigma)

    def get_version_info(self):
        r"""get_version_info(FretData self) -> VersionInfo"""
        return _IMP_isd.FretData_get_version_info(self)

    def __str__(self):
        r"""__str__(FretData self) -> std::string"""
        return _IMP_isd.FretData___str__(self)

    def __repr__(self):
        r"""__repr__(FretData self) -> std::string"""
        return _IMP_isd.FretData___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_FretData(o)


# Register FretData in _IMP_isd:
_IMP_isd.FretData_swigregister(FretData)

class FretRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::FretRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(FretRestraint self, IMP::Particles pd, IMP::Particles pa, Particle kda, Particle Ida, Particle R0, Particle sigma0, Particle Pbl, double fexp, double m_d=1.0, double m_a=1.0) -> FretRestraint
        __init__(FretRestraint self, Particle kda, Particle Ida, Particle sumFi, Particle sigma0, Particle Pbl, double fexp) -> FretRestraint
        __init__(FretRestraint self, Particle prd, Vector3D GMMterd, IMP::algebra::Vector3Ds GMMctrd, IMP::Floats GMMwd, IMP::Floats GMMsigd, Particle pra, Vector3D GMMtera, IMP::algebra::Vector3Ds GMMctra, IMP::Floats GMMwa, IMP::Floats GMMsiga, Particle kda, Particle Ida, Particle sigma0, Particle Pbl, FretData data, double fexp) -> FretRestraint
        """
        _IMP_isd.FretRestraint_swiginit(self, _IMP_isd.new_FretRestraint(*args))

    def get_sumFi(self):
        r"""get_sumFi(FretRestraint self) -> double"""
        return _IMP_isd.FretRestraint_get_sumFi(self)

    def get_average_sigma(self, fmod):
        r"""get_average_sigma(FretRestraint self, double fmod) -> double"""
        return _IMP_isd.FretRestraint_get_average_sigma(self, fmod)

    def get_standard_error(self):
        r"""get_standard_error(FretRestraint self) -> double"""
        return _IMP_isd.FretRestraint_get_standard_error(self)

    def get_model_fretr(self):
        r"""get_model_fretr(FretRestraint self) -> double"""
        return _IMP_isd.FretRestraint_get_model_fretr(self)

    def get_probability(self):
        r"""get_probability(FretRestraint self) -> double"""
        return _IMP_isd.FretRestraint_get_probability(self)

    def get_experimental_value(self):
        r"""get_experimental_value(FretRestraint self) -> double"""
        return _IMP_isd.FretRestraint_get_experimental_value(self)

    def set_experimental_value(self, fexp):
        r"""set_experimental_value(FretRestraint self, double fexp)"""
        return _IMP_isd.FretRestraint_set_experimental_value(self, fexp)

    def do_get_inputs(self):
        r"""do_get_inputs(FretRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.FretRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(FretRestraint self) -> VersionInfo"""
        return _IMP_isd.FretRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(FretRestraint self) -> std::string"""
        return _IMP_isd.FretRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(FretRestraint self) -> std::string"""
        return _IMP_isd.FretRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_FretRestraint(o)


# Register FretRestraint in _IMP_isd:
_IMP_isd.FretRestraint_swigregister(FretRestraint)

class CysteineCrossLinkData(IMP.Object):
    r"""Proxy of C++ IMP::isd::CysteineCrossLinkData class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, fexp, fmod_grid, omega_grid, omega0_grid, prior_type=3):
        r"""__init__(CysteineCrossLinkData self, double fexp, IMP::Floats fmod_grid, IMP::Floats omega_grid, IMP::Floats omega0_grid, int prior_type=3) -> CysteineCrossLinkData"""
        _IMP_isd.CysteineCrossLinkData_swiginit(self, _IMP_isd.new_CysteineCrossLinkData(fexp, fmod_grid, omega_grid, omega0_grid, prior_type))

    def get_closest(self, vec, value):
        r"""get_closest(CysteineCrossLinkData self, DistBase vec, double value) -> int"""
        return _IMP_isd.CysteineCrossLinkData_get_closest(self, vec, value)

    def get_omegas(self, fmods, omega0):
        r"""get_omegas(CysteineCrossLinkData self, IMP::Floats fmods, double omega0) -> IMP::Floats"""
        return _IMP_isd.CysteineCrossLinkData_get_omegas(self, fmods, omega0)

    def get_nonmarginal_elements(self, fexp, fmods, omega):
        r"""get_nonmarginal_elements(CysteineCrossLinkData self, double fexp, IMP::Floats fmods, double omega) -> IMP::Floats"""
        return _IMP_isd.CysteineCrossLinkData_get_nonmarginal_elements(self, fexp, fmods, omega)

    def get_marginal_elements(self, fmods, omega0):
        r"""get_marginal_elements(CysteineCrossLinkData self, IMP::Floats fmods, double omega0) -> IMP::Floats"""
        return _IMP_isd.CysteineCrossLinkData_get_marginal_elements(self, fmods, omega0)

    def get_omega(self, fmod, omega0):
        r"""get_omega(CysteineCrossLinkData self, double fmod, double omega0) -> double"""
        return _IMP_isd.CysteineCrossLinkData_get_omega(self, fmod, omega0)

    def get_standard_deviation(self, fmod, omega0):
        r"""get_standard_deviation(CysteineCrossLinkData self, double fmod, double omega0) -> double"""
        return _IMP_isd.CysteineCrossLinkData_get_standard_deviation(self, fmod, omega0)

    def get_nonmarginal_element(self, fexp, fmod, omega):
        r"""get_nonmarginal_element(CysteineCrossLinkData self, double fexp, double fmod, double omega) -> double"""
        return _IMP_isd.CysteineCrossLinkData_get_nonmarginal_element(self, fexp, fmod, omega)

    def get_marginal_element(self, fmod, omega0):
        r"""get_marginal_element(CysteineCrossLinkData self, double fmod, double omega0) -> double"""
        return _IMP_isd.CysteineCrossLinkData_get_marginal_element(self, fmod, omega0)

    def get_version_info(self):
        r"""get_version_info(CysteineCrossLinkData self) -> VersionInfo"""
        return _IMP_isd.CysteineCrossLinkData_get_version_info(self)

    def __str__(self):
        r"""__str__(CysteineCrossLinkData self) -> std::string"""
        return _IMP_isd.CysteineCrossLinkData___str__(self)

    def __repr__(self):
        r"""__repr__(CysteineCrossLinkData self) -> std::string"""
        return _IMP_isd.CysteineCrossLinkData___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CysteineCrossLinkData(o)


# Register CysteineCrossLinkData in _IMP_isd:
_IMP_isd.CysteineCrossLinkData_swigregister(CysteineCrossLinkData)

class CrossLinkData(IMP.Object):
    r"""Proxy of C++ IMP::isd::CrossLinkData class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CrossLinkData self, IMP::Floats dist_grid, IMP::Floats omega_grid, IMP::Floats sigma_grid, double lexp_, double don=std::numeric_limits< double >::max(), double doff=std::numeric_limits< double >::max(), int prior_type=0) -> CrossLinkData
        __init__(CrossLinkData self, IMP::Floats dist_grid, IMP::Floats omega_grid, IMP::Floats sigma_grid, IMP::Floats pot_x_grid, IMP::Floats pot_value_grid, double don=std::numeric_limits< double >::max(), double doff=std::numeric_limits< double >::max(), int prior_type=0) -> CrossLinkData
        """
        _IMP_isd.CrossLinkData_swiginit(self, _IMP_isd.new_CrossLinkData(*args))

    def get_closest(self, vec, value):
        r"""get_closest(CrossLinkData self, DistBase vec, double value) -> int"""
        return _IMP_isd.CrossLinkData_get_closest(self, vec, value)

    def get_omegas(self, sigma, dists):
        r"""get_omegas(CrossLinkData self, double sigma, IMP::Floats dists) -> IMP::Floats"""
        return _IMP_isd.CrossLinkData_get_omegas(self, sigma, dists)

    def get_omega_prior(self, omega, omega0):
        r"""get_omega_prior(CrossLinkData self, double omega, double omega0) -> double"""
        return _IMP_isd.CrossLinkData_get_omega_prior(self, omega, omega0)

    def get_nonmarginal_elements(self, sigmai, dists):
        r"""get_nonmarginal_elements(CrossLinkData self, double sigmai, IMP::Floats dists) -> IMP::Floats"""
        return _IMP_isd.CrossLinkData_get_nonmarginal_elements(self, sigmai, dists)

    def get_marginal_elements(self, sigma, dists):
        r"""get_marginal_elements(CrossLinkData self, double sigma, IMP::Floats dists) -> IMP::Floats"""
        return _IMP_isd.CrossLinkData_get_marginal_elements(self, sigma, dists)

    def get_marginal_maximum(self, *args):
        r"""
        get_marginal_maximum(CrossLinkData self, double sigma) -> double
        get_marginal_maximum(CrossLinkData self) -> double
        """
        return _IMP_isd.CrossLinkData_get_marginal_maximum(self, *args)

    def get_version_info(self):
        r"""get_version_info(CrossLinkData self) -> VersionInfo"""
        return _IMP_isd.CrossLinkData_get_version_info(self)

    def __str__(self):
        r"""__str__(CrossLinkData self) -> std::string"""
        return _IMP_isd.CrossLinkData___str__(self)

    def __repr__(self):
        r"""__repr__(CrossLinkData self) -> std::string"""
        return _IMP_isd.CrossLinkData___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CrossLinkData(o)


# Register CrossLinkData in _IMP_isd:
_IMP_isd.CrossLinkData_swigregister(CrossLinkData)

class CysteineCrossLinkRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::CysteineCrossLinkRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CysteineCrossLinkRestraint self, Model m, _ParticleIndexAdaptor beta, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor epsilon, _ParticleIndexAdaptor weight, CrossLinkData data, double fexp) -> CysteineCrossLinkRestraint
        __init__(CysteineCrossLinkRestraint self, Model m, _ParticleIndexAdaptor beta, _ParticleIndexAdaptor sigma, _ParticleIndexAdaptor epsilon, _ParticleIndexAdaptor weight, CrossLinkData data, CysteineCrossLinkData ccldata) -> CysteineCrossLinkRestraint
        """
        _IMP_isd.CysteineCrossLinkRestraint_swiginit(self, _IMP_isd.new_CysteineCrossLinkRestraint(*args))

    def get_probability(self):
        r"""get_probability(CysteineCrossLinkRestraint self) -> double"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_probability(self)

    def get_standard_error(self):
        r"""get_standard_error(CysteineCrossLinkRestraint self) -> double"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_standard_error(self)

    def get_frequencies(self):
        r"""get_frequencies(CysteineCrossLinkRestraint self) -> IMP::Floats"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_frequencies(self)

    def get_model_frequency(self):
        r"""get_model_frequency(CysteineCrossLinkRestraint self) -> double"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_model_frequency(self)

    def get_distances(self):
        r"""get_distances(CysteineCrossLinkRestraint self) -> IMP::Floats"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_distances(self)

    def get_truncated_normalization(self, mean, sigma):
        r"""get_truncated_normalization(CysteineCrossLinkRestraint self, double mean, double sigma) -> double"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_truncated_normalization(self, mean, sigma)

    def get_normal_pdf(self, mean, sigma, x):
        r"""get_normal_pdf(CysteineCrossLinkRestraint self, double mean, double sigma, double x) -> double"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_normal_pdf(self, mean, sigma, x)

    def add_contribution(self, *args):
        r"""
        add_contribution(CysteineCrossLinkRestraint self, _ParticleIndexAdaptor p1, _ParticleIndexAdaptor p2)
        add_contribution(CysteineCrossLinkRestraint self, IMP::ParticleIndexes p1, IMP::ParticleIndexes p2)
        """
        return _IMP_isd.CysteineCrossLinkRestraint_add_contribution(self, *args)

    def get_CB_coordinates(self, ps):
        r"""get_CB_coordinates(CysteineCrossLinkRestraint self, IMP::ParticleIndexes const & ps) -> Vector3D"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_CB_coordinates(self, ps)

    def get_number_of_contributions(self):
        r"""get_number_of_contributions(CysteineCrossLinkRestraint self) -> unsigned int"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_number_of_contributions(self)

    def do_get_inputs(self):
        r"""do_get_inputs(CysteineCrossLinkRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.CysteineCrossLinkRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(CysteineCrossLinkRestraint self) -> VersionInfo"""
        return _IMP_isd.CysteineCrossLinkRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(CysteineCrossLinkRestraint self) -> std::string"""
        return _IMP_isd.CysteineCrossLinkRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(CysteineCrossLinkRestraint self) -> std::string"""
        return _IMP_isd.CysteineCrossLinkRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CysteineCrossLinkRestraint(o)


# Register CysteineCrossLinkRestraint in _IMP_isd:
_IMP_isd.CysteineCrossLinkRestraint_swigregister(CysteineCrossLinkRestraint)

class WeightMover(IMP.core.MonteCarloMover):
    r"""Proxy of C++ IMP::isd::WeightMover class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, w, radius):
        r"""__init__(WeightMover self, Particle w, IMP::Float radius) -> WeightMover"""
        _IMP_isd.WeightMover_swiginit(self, _IMP_isd.new_WeightMover(w, radius))

    def set_radius(self, radius):
        r"""set_radius(WeightMover self, IMP::Float radius)"""
        return _IMP_isd.WeightMover_set_radius(self, radius)

    def get_radius(self):
        r"""get_radius(WeightMover self) -> IMP::Float"""
        return _IMP_isd.WeightMover_get_radius(self)

    def get_version_info(self):
        r"""get_version_info(WeightMover self) -> VersionInfo"""
        return _IMP_isd.WeightMover_get_version_info(self)

    def __str__(self):
        r"""__str__(WeightMover self) -> std::string"""
        return _IMP_isd.WeightMover___str__(self)

    def __repr__(self):
        r"""__repr__(WeightMover self) -> std::string"""
        return _IMP_isd.WeightMover___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_WeightMover(o)


# Register WeightMover in _IMP_isd:
_IMP_isd.WeightMover_swigregister(WeightMover)

class WeightRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::WeightRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, w, wmin, wmax, kappa):
        r"""__init__(WeightRestraint self, Particle w, IMP::Float wmin, IMP::Float wmax, IMP::Float kappa) -> WeightRestraint"""
        _IMP_isd.WeightRestraint_swiginit(self, _IMP_isd.new_WeightRestraint(w, wmin, wmax, kappa))

    def do_get_inputs(self):
        r"""do_get_inputs(WeightRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.WeightRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(WeightRestraint self) -> VersionInfo"""
        return _IMP_isd.WeightRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(WeightRestraint self) -> std::string"""
        return _IMP_isd.WeightRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(WeightRestraint self) -> std::string"""
        return _IMP_isd.WeightRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_WeightRestraint(o)


# Register WeightRestraint in _IMP_isd:
_IMP_isd.WeightRestraint_swigregister(WeightRestraint)

class AtomicCrossLinkMSRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::AtomicCrossLinkMSRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(AtomicCrossLinkMSRestraint self, Model m, double length, ParticleIndex psi, IMP::Float slope=0.0, bool part_of_log_score=False, std::string name="AtomicCrossLinkMSRestraint%1%") -> AtomicCrossLinkMSRestraint"""
        _IMP_isd.AtomicCrossLinkMSRestraint_swiginit(self, _IMP_isd.new_AtomicCrossLinkMSRestraint(*args))

    def add_contribution(self, ppi, sigmas):
        r"""add_contribution(AtomicCrossLinkMSRestraint self, IMP::ParticleIndexPair const & ppi, IMP::ParticleIndexPair const & sigmas)"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_add_contribution(self, ppi, sigmas)

    def evaluate_for_contributions(self, c, accum):
        r"""evaluate_for_contributions(AtomicCrossLinkMSRestraint self, IMP::Ints c, DerivativeAccumulator accum) -> IMP::Float"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_evaluate_for_contributions(self, c, accum)

    def get_number_of_contributions(self):
        r"""get_number_of_contributions(AtomicCrossLinkMSRestraint self) -> unsigned int"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_get_number_of_contributions(self)

    def get_contribution(self, i):
        r"""get_contribution(AtomicCrossLinkMSRestraint self, int i) -> IMP::ParticleIndexPair"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_get_contribution(self, i)

    def get_contribution_sigmas(self, i):
        r"""get_contribution_sigmas(AtomicCrossLinkMSRestraint self, int i) -> IMP::ParticleIndexPair"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_get_contribution_sigmas(self, i)

    def get_psi(self):
        r"""get_psi(AtomicCrossLinkMSRestraint self) -> ParticleIndex"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_get_psi(self)

    def do_get_inputs(self):
        r"""do_get_inputs(AtomicCrossLinkMSRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_do_get_inputs(self)

    def show(self, out):
        r"""show(AtomicCrossLinkMSRestraint self, _ostream out)"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_show(self, out)

    def set_slope(self, slope):
        r"""set_slope(AtomicCrossLinkMSRestraint self, IMP::Float slope)"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_set_slope(self, slope)

    def set_part_of_log_score(self, hey):
        r"""set_part_of_log_score(AtomicCrossLinkMSRestraint self, bool hey)"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_set_part_of_log_score(self, hey)

    def get_version_info(self):
        r"""get_version_info(AtomicCrossLinkMSRestraint self) -> VersionInfo"""
        return _IMP_isd.AtomicCrossLinkMSRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(AtomicCrossLinkMSRestraint self) -> std::string"""
        return _IMP_isd.AtomicCrossLinkMSRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(AtomicCrossLinkMSRestraint self) -> std::string"""
        return _IMP_isd.AtomicCrossLinkMSRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AtomicCrossLinkMSRestraint(o)


# Register AtomicCrossLinkMSRestraint in _IMP_isd:
_IMP_isd.AtomicCrossLinkMSRestraint_swigregister(AtomicCrossLinkMSRestraint)

class GaussianEMRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::GaussianEMRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(GaussianEMRestraint self, Model mdl, IMP::ParticleIndexes model_ps, IMP::ParticleIndexes density_ps, ParticleIndex global_sigma, IMP::Float model_cutoff_dist, IMP::Float density_cutoff_dist, IMP::Float slope, bool update_model=True, bool backbone_slope=False, bool local=False, std::string name="GaussianEMRestraint%1%") -> GaussianEMRestraint"""
        _IMP_isd.GaussianEMRestraint_swiginit(self, _IMP_isd.new_GaussianEMRestraint(*args))

    def get_probability(self):
        r"""get_probability(GaussianEMRestraint self) -> double"""
        return _IMP_isd.GaussianEMRestraint_get_probability(self)

    def get_cross_correlation_coefficient(self):
        r"""get_cross_correlation_coefficient(GaussianEMRestraint self) -> double"""
        return _IMP_isd.GaussianEMRestraint_get_cross_correlation_coefficient(self)

    def set_density_filename(self, density_fn):
        r"""set_density_filename(GaussianEMRestraint self, std::string density_fn)"""
        return _IMP_isd.GaussianEMRestraint_set_density_filename(self, density_fn)

    def compute_initial_scores(self):
        r"""compute_initial_scores(GaussianEMRestraint self)"""
        return _IMP_isd.GaussianEMRestraint_compute_initial_scores(self)

    def set_slope(self, s):
        r"""set_slope(GaussianEMRestraint self, IMP::Float s)"""
        return _IMP_isd.GaussianEMRestraint_set_slope(self, s)

    def get_slope(self):
        r"""get_slope(GaussianEMRestraint self) -> IMP::Float"""
        return _IMP_isd.GaussianEMRestraint_get_slope(self)

    def do_get_inputs(self):
        r"""do_get_inputs(GaussianEMRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.GaussianEMRestraint_do_get_inputs(self)

    def show(self, out):
        r"""show(GaussianEMRestraint self, _ostream out)"""
        return _IMP_isd.GaussianEMRestraint_show(self, out)

    def get_version_info(self):
        r"""get_version_info(GaussianEMRestraint self) -> VersionInfo"""
        return _IMP_isd.GaussianEMRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(GaussianEMRestraint self) -> std::string"""
        return _IMP_isd.GaussianEMRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(GaussianEMRestraint self) -> std::string"""
        return _IMP_isd.GaussianEMRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GaussianEMRestraint(o)


# Register GaussianEMRestraint in _IMP_isd:
_IMP_isd.GaussianEMRestraint_swigregister(GaussianEMRestraint)

class GaussianAnchorEMRestraint(ISDRestraint):
    r"""Proxy of C++ IMP::isd::GaussianAnchorEMRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(GaussianAnchorEMRestraint self, IMP::ParticlesTemp model_ps, IMP::Floats model_sigs, IMP::Floats model_weights, IMP::ParticlesTemp density_ps, IMP::Floats density_sigs, IMP::Floats density_weights, Particle global_sigma, IMP::Float cutoff_dist, bool rigid, bool tabexp, std::string name="GaussianAnchorEMRestraint%1%") -> GaussianAnchorEMRestraint"""
        _IMP_isd.GaussianAnchorEMRestraint_swiginit(self, _IMP_isd.new_GaussianAnchorEMRestraint(*args))

    def get_density_particles(self):
        r"""get_density_particles(GaussianAnchorEMRestraint self) -> IMP::ParticlesTemp"""
        return _IMP_isd.GaussianAnchorEMRestraint_get_density_particles(self)

    def __str__(self):
        r"""__str__(GaussianAnchorEMRestraint self) -> std::string"""
        return _IMP_isd.GaussianAnchorEMRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(GaussianAnchorEMRestraint self) -> std::string"""
        return _IMP_isd.GaussianAnchorEMRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GaussianAnchorEMRestraint(o)


# Register GaussianAnchorEMRestraint in _IMP_isd:
_IMP_isd.GaussianAnchorEMRestraint_swigregister(GaussianAnchorEMRestraint)

class GammaPrior(IMP.Restraint):
    r"""Proxy of C++ IMP::isd::GammaPrior class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(GammaPrior self, Model m, Particle p, IMP::Float k, IMP::Float theta, std::string name="GammaPrior%1%") -> GammaPrior"""
        _IMP_isd.GammaPrior_swiginit(self, _IMP_isd.new_GammaPrior(*args))

    def evaluate_at(self, val):
        r"""evaluate_at(GammaPrior self, IMP::Float val) -> double"""
        return _IMP_isd.GammaPrior_evaluate_at(self, val)

    def do_get_inputs(self):
        r"""do_get_inputs(GammaPrior self) -> IMP::ModelObjectsTemp"""
        return _IMP_isd.GammaPrior_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(GammaPrior self) -> VersionInfo"""
        return _IMP_isd.GammaPrior_get_version_info(self)

    def get_probability(self):
        r"""get_probability(GammaPrior self) -> double"""
        return _IMP_isd.GammaPrior_get_probability(self)

    def __str__(self):
        r"""__str__(GammaPrior self) -> std::string"""
        return _IMP_isd.GammaPrior___str__(self)

    def __repr__(self):
        r"""__repr__(GammaPrior self) -> std::string"""
        return _IMP_isd.GammaPrior___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_GammaPrior(o)


# Register GammaPrior in _IMP_isd:
_IMP_isd.GammaPrior_swigregister(GammaPrior)


def sample_points_from_density(dmap_orig, npoints, threshold=0.0):
    r"""sample_points_from_density(DensityMap dmap_orig, int npoints, IMP::Float threshold=0.0) -> IMP::FloatsList"""
    return _IMP_isd.sample_points_from_density(dmap_orig, npoints, threshold)

def get_module_version():
    r"""get_module_version() -> std::string const"""
    return _IMP_isd.get_module_version()

def get_example_path(fname):
    r"""get_example_path(std::string fname) -> std::string"""
    return _IMP_isd.get_example_path(fname)

def get_data_path(fname):
    r"""get_data_path(std::string fname) -> std::string"""
    return _IMP_isd.get_data_path(fname)

from . import _version_check
_version_check.check_version(get_module_version())
__version__ = get_module_version()



