/* Tell SWIG how to treat various types when moving them to and from Python.
   Among other things, they tell SWIG how to convert collections of C++ objects
   (eg ExampleRestraints) to and from Python lists.

   IMP_SWIG_OBJECT, IMP_SWIG_VALUE and IMP_SWIG_DECORATOR lines need to appear
   before any %include lines as well as any inline C++ code (or at least
   any such code which uses the types in question).
 */
%import "RMF.i"
%{
#include "RMF.h"
%}
IMP_SWIG_OBJECT(IMP::example, ExampleRestraint, ExampleRestraints);
IMP_SWIG_DECORATOR(IMP::example, ExampleDecorator, ExampleDecorators);
IMP_SWIG_OBJECT(IMP::example, ExampleUnaryFunction, ExampleUnaryFunctions);
IMP_SWIG_OBJECT(IMP::example, ExampleSingletonModifier, ExampleSingletonModifiers);
IMP_SWIG_OBJECT(IMP::example, ExamplePairScore, ExamplePairScores);
IMP_SWIG_OBJECT(IMP::example, ExampleSubsetFilterTable, ExampleSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::example, ExampleConstraint, ExampleConstraints);
IMP_SWIG_OBJECT(IMP::example, ExampleObject, ExampleObjects);
IMP_SWIG_VALUE_INSTANCE(IMP::example, ExampleTemplateClass3D, ExampleTemplateClassD, ExampleTemplateClass3Ds);
IMP_SWIG_VALUE_TEMPLATE(IMP::example, ExampleTemplateClassD);


/* One can add Python functions to your module by putting code in
   %pythoncode blocks.

   This function can be called as IMP.example.create_model_and_particles().

   (Alternatively, functions and classes can be placed in subpackages by
   putting them in the pyext/src directory.)
 */
%pythoncode %{
def create_model_and_particles():
    m = IMP.Model()
    sc = IMP.container.ListSingletonContainer(m)
    b = IMP.algebra.BoundingBox3D(IMP.algebra.Vector3D(0,0,0),
                                 IMP.algebra.Vector3D(10,10,10))
    for i in range(0,100):
        p = m.add_particle("p")
        sc.add(p)
        d = IMP.core.XYZR.setup_particle(m, p,
                  IMP.algebra.Sphere3D(IMP.algebra.get_random_vector_in(b), 1))
        d.set_coordinates_are_optimized(True)
    return (m, sc)
%}

/* If you have lots of Python code, you can use SWIG's
   %include directive and put it in a separate file.
 */
%include "IMP_example.restraint.i"
%include "IMP_example.pairscore.i"
%include "IMP_example.unaryfunc.i"
%include "IMP_example.constraint.i"
%include "IMP_example.modifier.i"

/* Wrap our own classes. Each header in the module should be listed here with a
   %include line. */
%include "IMP/example/ExampleRestraint.h"
%include "IMP/example/ExampleDecorator.h"
%include "IMP/example/ExampleUnaryFunction.h"
%include "IMP/example/ExampleObject.h"
%include "IMP/example/ExampleSingletonModifier.h"
%include "IMP/example/ExampleTemplateClass.h"
%include "IMP/example/ExamplePairScore.h"
%include "IMP/example/ExampleSubsetFilterTable.h"
%include "IMP/example/ExampleConstraint.h"

%include "IMP/example/randomizing.h"
%include "IMP/example/counting.h"
%include "IMP/example/creating_restraints.h"

namespace IMP {
  namespace example {
  /* Python doesn't natively support C++ templates, so you have to manually
     choose which template parameters you want to intantiate a template with.
   */
   %template(ExampleTemplateClass3D) ExampleTemplateClassD<3>;
  }
}
