# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


# This wrapper is part of IMP,
# Copyright 2007-2022 IMP Inventors. All rights reserved.

from __future__ import print_function, division, absolute_import



from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

import _IMP_saxs

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class IMP_SAXS_SwigPyIterator(object):
    r"""Proxy of C++ swig::IMP_SAXS_SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_saxs.delete_IMP_SAXS_SwigPyIterator

    def value(self):
        r"""value(IMP_SAXS_SwigPyIterator self) -> PyObject *"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(IMP_SAXS_SwigPyIterator self, size_t n=1) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(IMP_SAXS_SwigPyIterator self, size_t n=1) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(IMP_SAXS_SwigPyIterator self, IMP_SAXS_SwigPyIterator x) -> ptrdiff_t"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(IMP_SAXS_SwigPyIterator self, IMP_SAXS_SwigPyIterator x) -> bool"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(IMP_SAXS_SwigPyIterator self) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_copy(self)

    def next(self):
        r"""next(IMP_SAXS_SwigPyIterator self) -> PyObject *"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(IMP_SAXS_SwigPyIterator self) -> PyObject *"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(IMP_SAXS_SwigPyIterator self) -> PyObject *"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(IMP_SAXS_SwigPyIterator self, ptrdiff_t n) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(IMP_SAXS_SwigPyIterator self, IMP_SAXS_SwigPyIterator x) -> bool"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(IMP_SAXS_SwigPyIterator self, IMP_SAXS_SwigPyIterator x) -> bool"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(IMP_SAXS_SwigPyIterator self, ptrdiff_t n) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(IMP_SAXS_SwigPyIterator self, ptrdiff_t n) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(IMP_SAXS_SwigPyIterator self, ptrdiff_t n) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(IMP_SAXS_SwigPyIterator self, ptrdiff_t n) -> IMP_SAXS_SwigPyIterator
        __sub__(IMP_SAXS_SwigPyIterator self, IMP_SAXS_SwigPyIterator x) -> ptrdiff_t
        """
        return _IMP_saxs.IMP_SAXS_SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register IMP_SAXS_SwigPyIterator in _IMP_saxs:
_IMP_saxs.IMP_SAXS_SwigPyIterator_swigregister(IMP_SAXS_SwigPyIterator)


_value_types=[]
_object_types=[]
_raii_types=[]
_plural_types=[]

IMP_DEBUG = _IMP_saxs.IMP_DEBUG

IMP_RELEASE = _IMP_saxs.IMP_RELEASE

IMP_SILENT = _IMP_saxs.IMP_SILENT

IMP_PROGRESS = _IMP_saxs.IMP_PROGRESS

IMP_TERSE = _IMP_saxs.IMP_TERSE

IMP_VERBOSE = _IMP_saxs.IMP_VERBOSE

IMP_MEMORY = _IMP_saxs.IMP_MEMORY

IMP_NONE = _IMP_saxs.IMP_NONE

IMP_USAGE = _IMP_saxs.IMP_USAGE

IMP_INTERNAL = _IMP_saxs.IMP_INTERNAL

IMP_KERNEL_HAS_LOG4CXX = _IMP_saxs.IMP_KERNEL_HAS_LOG4CXX

IMP_COMPILER_HAS_DEBUG_VECTOR = _IMP_saxs.IMP_COMPILER_HAS_DEBUG_VECTOR

IMP_COMPILER_HAS_RANDOM_SHUFFLE = _IMP_saxs.IMP_COMPILER_HAS_RANDOM_SHUFFLE

IMP_COMPILER_HAS_THREE_WAY = _IMP_saxs.IMP_COMPILER_HAS_THREE_WAY

IMP_KERNEL_HAS_BOOST_RANDOM = _IMP_saxs.IMP_KERNEL_HAS_BOOST_RANDOM

IMP_KERNEL_HAS_NUMPY = _IMP_saxs.IMP_KERNEL_HAS_NUMPY

IMP_KERNEL_HAS_GPERFTOOLS = _IMP_saxs.IMP_KERNEL_HAS_GPERFTOOLS

IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER = _IMP_saxs.IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER

IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER = _IMP_saxs.IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER

IMPKERNEL_SHOW_WARNINGS = _IMP_saxs.IMPKERNEL_SHOW_WARNINGS


import sys
class _DirectorObjects(object):
    """@internal Simple class to keep references to director objects
       to prevent premature deletion."""
    def __init__(self):
        self._objects = []
    def register(self, obj):
        """Take a reference to a director object; will only work for
           refcounted C++ classes"""
        if hasattr(obj, 'get_ref_count'):
            self._objects.append(obj)
    def cleanup(self):
        """Only drop our reference and allow cleanup by Python if no other
           Python references exist (we hold 3 references: one in self._objects,
           one in x, and one in the argument list for getrefcount) *and* no
           other C++ references exist (the Python object always holds one)"""
        objs = [x for x in self._objects if sys.getrefcount(x) > 3 \
                                         or x.get_ref_count() > 1]
# Do in two steps so the references are kept until the end of the
# function (deleting references may trigger a fresh call to this method)
        self._objects = objs
    def get_object_count(self):
        """Get number of director objects (useful for testing only)"""
        return len(self._objects)
_director_objects = _DirectorObjects()

class _ostream(object):
    r"""Proxy of C++ std::ostream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def write(self, osa_buf):
        r"""write(_ostream self, char const * osa_buf)"""
        return _IMP_saxs._ostream_write(self, osa_buf)

# Register _ostream in _IMP_saxs:
_IMP_saxs._ostream_swigregister(_ostream)

IMP_HAS_NOEXCEPT = _IMP_saxs.IMP_HAS_NOEXCEPT

IMP_C_OPEN_BINARY = _IMP_saxs.IMP_C_OPEN_BINARY

import IMP
IMP_CGAL_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_CGAL_HAS_BOOST_FILESYSTEM

IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS

IMP_CGAL_HAS_BOOST_RANDOM = _IMP_saxs.IMP_CGAL_HAS_BOOST_RANDOM

IMP_CGAL_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_CGAL_HAS_BOOST_SYSTEM

IMP_CGAL_HAS_NUMPY = _IMP_saxs.IMP_CGAL_HAS_NUMPY

IMPCGAL_SHOW_WARNINGS = _IMP_saxs.IMPCGAL_SHOW_WARNINGS

import IMP.cgal
IMP_ALGEBRA_HAS_IMP_CGAL = _IMP_saxs.IMP_ALGEBRA_HAS_IMP_CGAL

IMP_ALGEBRA_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_ALGEBRA_HAS_BOOST_FILESYSTEM

IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS

IMP_ALGEBRA_HAS_BOOST_RANDOM = _IMP_saxs.IMP_ALGEBRA_HAS_BOOST_RANDOM

IMP_ALGEBRA_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_ALGEBRA_HAS_BOOST_SYSTEM

IMP_ALGEBRA_HAS_CGAL = _IMP_saxs.IMP_ALGEBRA_HAS_CGAL

IMP_ALGEBRA_HAS_NUMPY = _IMP_saxs.IMP_ALGEBRA_HAS_NUMPY

IMP_ALGEBRA_HAS_ANN = _IMP_saxs.IMP_ALGEBRA_HAS_ANN

IMPALGEBRA_SHOW_WARNINGS = _IMP_saxs.IMPALGEBRA_SHOW_WARNINGS

import IMP.algebra
IMP_DISPLAY_HAS_IMP_CGAL = _IMP_saxs.IMP_DISPLAY_HAS_IMP_CGAL

IMP_DISPLAY_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_DISPLAY_HAS_BOOST_FILESYSTEM

IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS

IMP_DISPLAY_HAS_BOOST_RANDOM = _IMP_saxs.IMP_DISPLAY_HAS_BOOST_RANDOM

IMP_DISPLAY_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_DISPLAY_HAS_BOOST_SYSTEM

IMP_DISPLAY_HAS_CGAL = _IMP_saxs.IMP_DISPLAY_HAS_CGAL

IMP_DISPLAY_HAS_NUMPY = _IMP_saxs.IMP_DISPLAY_HAS_NUMPY

IMPDISPLAY_SHOW_WARNINGS = _IMP_saxs.IMPDISPLAY_SHOW_WARNINGS

import IMP.display
IMP_SCORE_FUNCTOR_HAS_IMP_CGAL = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_IMP_CGAL

IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM

IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS

IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM

IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM

IMP_SCORE_FUNCTOR_HAS_CGAL = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_CGAL

IMP_SCORE_FUNCTOR_HAS_HDF5 = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_HDF5

IMP_SCORE_FUNCTOR_HAS_NUMPY = _IMP_saxs.IMP_SCORE_FUNCTOR_HAS_NUMPY

IMPSCOREFUNCTOR_SHOW_WARNINGS = _IMP_saxs.IMPSCOREFUNCTOR_SHOW_WARNINGS

import IMP.score_functor
IMP_CORE_HAS_IMP_CGAL = _IMP_saxs.IMP_CORE_HAS_IMP_CGAL

IMP_CORE_HAS_IMP_KERNEL = _IMP_saxs.IMP_CORE_HAS_IMP_KERNEL

IMP_CORE_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_CORE_HAS_BOOST_FILESYSTEM

IMP_CORE_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_CORE_HAS_BOOST_PROGRAMOPTIONS

IMP_CORE_HAS_BOOST_RANDOM = _IMP_saxs.IMP_CORE_HAS_BOOST_RANDOM

IMP_CORE_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_CORE_HAS_BOOST_SYSTEM

IMP_CORE_HAS_CGAL = _IMP_saxs.IMP_CORE_HAS_CGAL

IMP_CORE_HAS_HDF5 = _IMP_saxs.IMP_CORE_HAS_HDF5

IMP_CORE_HAS_NUMPY = _IMP_saxs.IMP_CORE_HAS_NUMPY

IMPCORE_SHOW_WARNINGS = _IMP_saxs.IMPCORE_SHOW_WARNINGS

import IMP.core
IMP_CONTAINER_HAS_IMP_ALGEBRA = _IMP_saxs.IMP_CONTAINER_HAS_IMP_ALGEBRA

IMP_CONTAINER_HAS_IMP_CGAL = _IMP_saxs.IMP_CONTAINER_HAS_IMP_CGAL

IMP_CONTAINER_HAS_IMP_DISPLAY = _IMP_saxs.IMP_CONTAINER_HAS_IMP_DISPLAY

IMP_CONTAINER_HAS_IMP_KERNEL = _IMP_saxs.IMP_CONTAINER_HAS_IMP_KERNEL

IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR = _IMP_saxs.IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR

IMP_CONTAINER_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_CONTAINER_HAS_BOOST_FILESYSTEM

IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS

IMP_CONTAINER_HAS_BOOST_RANDOM = _IMP_saxs.IMP_CONTAINER_HAS_BOOST_RANDOM

IMP_CONTAINER_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_CONTAINER_HAS_BOOST_SYSTEM

IMP_CONTAINER_HAS_CGAL = _IMP_saxs.IMP_CONTAINER_HAS_CGAL

IMP_CONTAINER_HAS_HDF5 = _IMP_saxs.IMP_CONTAINER_HAS_HDF5

IMP_CONTAINER_HAS_NUMPY = _IMP_saxs.IMP_CONTAINER_HAS_NUMPY

IMP_CONTAINER_HAS_PYTHON_IHM = _IMP_saxs.IMP_CONTAINER_HAS_PYTHON_IHM

IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP = _IMP_saxs.IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP

IMP_CONTAINER_HAS_ROBIN_MAP = _IMP_saxs.IMP_CONTAINER_HAS_ROBIN_MAP

IMPCONTAINER_SHOW_WARNINGS = _IMP_saxs.IMPCONTAINER_SHOW_WARNINGS

import IMP.container
IMP_ATOM_HAS_IMP_CGAL = _IMP_saxs.IMP_ATOM_HAS_IMP_CGAL

IMP_ATOM_HAS_IMP_KERNEL = _IMP_saxs.IMP_ATOM_HAS_IMP_KERNEL

IMP_ATOM_HAS_IMP_SCORE_FUNCTOR = _IMP_saxs.IMP_ATOM_HAS_IMP_SCORE_FUNCTOR

IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS

IMP_ATOM_HAS_BOOST_RANDOM = _IMP_saxs.IMP_ATOM_HAS_BOOST_RANDOM

IMP_ATOM_HAS_BOOST_REGEX = _IMP_saxs.IMP_ATOM_HAS_BOOST_REGEX

IMP_ATOM_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_ATOM_HAS_BOOST_SYSTEM

IMP_ATOM_HAS_CGAL = _IMP_saxs.IMP_ATOM_HAS_CGAL

IMP_ATOM_HAS_HDF5 = _IMP_saxs.IMP_ATOM_HAS_HDF5

IMP_ATOM_HAS_NUMPY = _IMP_saxs.IMP_ATOM_HAS_NUMPY

IMP_ATOM_HAS_PYTHON_IHM = _IMP_saxs.IMP_ATOM_HAS_PYTHON_IHM

IMPATOM_SHOW_WARNINGS = _IMP_saxs.IMPATOM_SHOW_WARNINGS

IMP_ATOM_TYPE_INDEX = _IMP_saxs.IMP_ATOM_TYPE_INDEX

IMP_RESIDUE_TYPE_INDEX = _IMP_saxs.IMP_RESIDUE_TYPE_INDEX

IMP_HIERARCHY_TYPE_INDEX = _IMP_saxs.IMP_HIERARCHY_TYPE_INDEX

IMP_CHAIN_TYPE_INDEX = _IMP_saxs.IMP_CHAIN_TYPE_INDEX

import IMP.atom
IMP_SAXS_HAS_IMP_CGAL = _IMP_saxs.IMP_SAXS_HAS_IMP_CGAL

IMP_SAXS_HAS_IMP_CONTAINER = _IMP_saxs.IMP_SAXS_HAS_IMP_CONTAINER

IMP_SAXS_HAS_IMP_DISPLAY = _IMP_saxs.IMP_SAXS_HAS_IMP_DISPLAY

IMP_SAXS_HAS_IMP_KERNEL = _IMP_saxs.IMP_SAXS_HAS_IMP_KERNEL

IMP_SAXS_HAS_IMP_SCORE_FUNCTOR = _IMP_saxs.IMP_SAXS_HAS_IMP_SCORE_FUNCTOR

IMP_SAXS_HAS_BOOST_FILESYSTEM = _IMP_saxs.IMP_SAXS_HAS_BOOST_FILESYSTEM

IMP_SAXS_HAS_BOOST_PROGRAMOPTIONS = _IMP_saxs.IMP_SAXS_HAS_BOOST_PROGRAMOPTIONS

IMP_SAXS_HAS_BOOST_RANDOM = _IMP_saxs.IMP_SAXS_HAS_BOOST_RANDOM

IMP_SAXS_HAS_BOOST_REGEX = _IMP_saxs.IMP_SAXS_HAS_BOOST_REGEX

IMP_SAXS_HAS_BOOST_SYSTEM = _IMP_saxs.IMP_SAXS_HAS_BOOST_SYSTEM

IMP_SAXS_HAS_CGAL = _IMP_saxs.IMP_SAXS_HAS_CGAL

IMP_SAXS_HAS_HDF5 = _IMP_saxs.IMP_SAXS_HAS_HDF5

IMP_SAXS_HAS_NUMPY = _IMP_saxs.IMP_SAXS_HAS_NUMPY

IMP_SAXS_HAS_PYTHON_IHM = _IMP_saxs.IMP_SAXS_HAS_PYTHON_IHM

IMPSAXS_SHOW_WARNINGS = _IMP_saxs.IMPSAXS_SHOW_WARNINGS

class DistBase(object):
    r"""Proxy of C++ std::vector< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(DistBase self) -> IMP_SAXS_SwigPyIterator"""
        return _IMP_saxs.DistBase_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(DistBase self) -> bool"""
        return _IMP_saxs.DistBase___nonzero__(self)

    def __bool__(self):
        r"""__bool__(DistBase self) -> bool"""
        return _IMP_saxs.DistBase___bool__(self)

    def __len__(self):
        r"""__len__(DistBase self) -> std::vector< double >::size_type"""
        return _IMP_saxs.DistBase___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(DistBase self, std::vector< double >::difference_type i, std::vector< double >::difference_type j) -> DistBase"""
        return _IMP_saxs.DistBase___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(DistBase self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)
        __setslice__(DistBase self, std::vector< double >::difference_type i, std::vector< double >::difference_type j, DistBase v)
        """
        return _IMP_saxs.DistBase___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(DistBase self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)"""
        return _IMP_saxs.DistBase___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(DistBase self, std::vector< double >::difference_type i)
        __delitem__(DistBase self, PySliceObject * slice)
        """
        return _IMP_saxs.DistBase___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(DistBase self, PySliceObject * slice) -> DistBase
        __getitem__(DistBase self, std::vector< double >::difference_type i) -> std::vector< double >::value_type const &
        """
        return _IMP_saxs.DistBase___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(DistBase self, PySliceObject * slice, DistBase v)
        __setitem__(DistBase self, PySliceObject * slice)
        __setitem__(DistBase self, std::vector< double >::difference_type i, std::vector< double >::value_type const & x)
        """
        return _IMP_saxs.DistBase___setitem__(self, *args)

    def pop(self):
        r"""pop(DistBase self) -> std::vector< double >::value_type"""
        return _IMP_saxs.DistBase_pop(self)

    def append(self, x):
        r"""append(DistBase self, std::vector< double >::value_type const & x)"""
        return _IMP_saxs.DistBase_append(self, x)

    def empty(self):
        r"""empty(DistBase self) -> bool"""
        return _IMP_saxs.DistBase_empty(self)

    def size(self):
        r"""size(DistBase self) -> std::vector< double >::size_type"""
        return _IMP_saxs.DistBase_size(self)

    def swap(self, v):
        r"""swap(DistBase self, DistBase v)"""
        return _IMP_saxs.DistBase_swap(self, v)

    def begin(self):
        r"""begin(DistBase self) -> std::vector< double >::iterator"""
        return _IMP_saxs.DistBase_begin(self)

    def end(self):
        r"""end(DistBase self) -> std::vector< double >::iterator"""
        return _IMP_saxs.DistBase_end(self)

    def rbegin(self):
        r"""rbegin(DistBase self) -> std::vector< double >::reverse_iterator"""
        return _IMP_saxs.DistBase_rbegin(self)

    def rend(self):
        r"""rend(DistBase self) -> std::vector< double >::reverse_iterator"""
        return _IMP_saxs.DistBase_rend(self)

    def clear(self):
        r"""clear(DistBase self)"""
        return _IMP_saxs.DistBase_clear(self)

    def get_allocator(self):
        r"""get_allocator(DistBase self) -> std::vector< double >::allocator_type"""
        return _IMP_saxs.DistBase_get_allocator(self)

    def pop_back(self):
        r"""pop_back(DistBase self)"""
        return _IMP_saxs.DistBase_pop_back(self)

    def erase(self, *args):
        r"""
        erase(DistBase self, std::vector< double >::iterator pos) -> std::vector< double >::iterator
        erase(DistBase self, std::vector< double >::iterator first, std::vector< double >::iterator last) -> std::vector< double >::iterator
        """
        return _IMP_saxs.DistBase_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(DistBase self) -> DistBase
        __init__(DistBase self, DistBase other) -> DistBase
        __init__(DistBase self, std::vector< double >::size_type size) -> DistBase
        __init__(DistBase self, std::vector< double >::size_type size, std::vector< double >::value_type const & value) -> DistBase
        """
        _IMP_saxs.DistBase_swiginit(self, _IMP_saxs.new_DistBase(*args))

    def push_back(self, x):
        r"""push_back(DistBase self, std::vector< double >::value_type const & x)"""
        return _IMP_saxs.DistBase_push_back(self, x)

    def front(self):
        r"""front(DistBase self) -> std::vector< double >::value_type const &"""
        return _IMP_saxs.DistBase_front(self)

    def back(self):
        r"""back(DistBase self) -> std::vector< double >::value_type const &"""
        return _IMP_saxs.DistBase_back(self)

    def assign(self, n, x):
        r"""assign(DistBase self, std::vector< double >::size_type n, std::vector< double >::value_type const & x)"""
        return _IMP_saxs.DistBase_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(DistBase self, std::vector< double >::size_type new_size)
        resize(DistBase self, std::vector< double >::size_type new_size, std::vector< double >::value_type const & x)
        """
        return _IMP_saxs.DistBase_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(DistBase self, std::vector< double >::iterator pos, std::vector< double >::value_type const & x) -> std::vector< double >::iterator
        insert(DistBase self, std::vector< double >::iterator pos, std::vector< double >::size_type n, std::vector< double >::value_type const & x)
        """
        return _IMP_saxs.DistBase_insert(self, *args)

    def reserve(self, n):
        r"""reserve(DistBase self, std::vector< double >::size_type n)"""
        return _IMP_saxs.DistBase_reserve(self, n)

    def capacity(self):
        r"""capacity(DistBase self) -> std::vector< double >::size_type"""
        return _IMP_saxs.DistBase_capacity(self)
    __swig_destroy__ = _IMP_saxs.delete_DistBase

# Register DistBase in _IMP_saxs:
_IMP_saxs.DistBase_swigregister(DistBase)


_object_types.append("Profile")


def _object_cast_to_Profile(o):
    r"""_object_cast_to_Profile(Object o) -> Profile"""
    return _IMP_saxs._object_cast_to_Profile(o)

_object_types.append("ChiScore")


def _object_cast_to_ChiScore(o):
    r"""_object_cast_to_ChiScore(Object o) -> ChiScore"""
    return _IMP_saxs._object_cast_to_ChiScore(o)

_object_types.append("ChiScoreLog")


def _object_cast_to_ChiScoreLog(o):
    r"""_object_cast_to_ChiScoreLog(Object o) -> ChiScoreLog"""
    return _IMP_saxs._object_cast_to_ChiScoreLog(o)
ALL_ATOMS = _IMP_saxs.ALL_ATOMS

HEAVY_ATOMS = _IMP_saxs.HEAVY_ATOMS

CA_ATOMS = _IMP_saxs.CA_ATOMS

RESIDUES = _IMP_saxs.RESIDUES

class FormFactorTable(object):
    r"""Proxy of C++ IMP::saxs::FormFactorTable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(FormFactorTable self) -> FormFactorTable
        __init__(FormFactorTable self, std::string const & table_name, double min_q, double max_q, double delta_q) -> FormFactorTable
        """
        _IMP_saxs.FormFactorTable_swiginit(self, _IMP_saxs.new_FormFactorTable(*args))

    def get_form_factor(self, *args):
        r"""get_form_factor(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> double"""
        return _IMP_saxs.FormFactorTable_get_form_factor(self, *args)

    def get_vacuum_form_factor(self, *args):
        r"""get_vacuum_form_factor(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> double"""
        return _IMP_saxs.FormFactorTable_get_vacuum_form_factor(self, *args)

    def get_dummy_form_factor(self, *args):
        r"""get_dummy_form_factor(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> double"""
        return _IMP_saxs.FormFactorTable_get_dummy_form_factor(self, *args)

    def get_water_form_factor(self):
        r"""get_water_form_factor(FormFactorTable self) -> double"""
        return _IMP_saxs.FormFactorTable_get_water_form_factor(self)

    def get_vacuum_water_form_factor(self):
        r"""get_vacuum_water_form_factor(FormFactorTable self) -> double"""
        return _IMP_saxs.FormFactorTable_get_vacuum_water_form_factor(self)

    def get_dummy_water_form_factor(self):
        r"""get_dummy_water_form_factor(FormFactorTable self) -> double"""
        return _IMP_saxs.FormFactorTable_get_dummy_water_form_factor(self)

    def get_form_factors(self, *args):
        r"""get_form_factors(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> IMP::Vector< double > const"""
        return _IMP_saxs.FormFactorTable_get_form_factors(self, *args)

    def get_vacuum_form_factors(self, *args):
        r"""get_vacuum_form_factors(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> IMP::Vector< double > const"""
        return _IMP_saxs.FormFactorTable_get_vacuum_form_factors(self, *args)

    def get_dummy_form_factors(self, *args):
        r"""get_dummy_form_factors(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> IMP::Vector< double > const"""
        return _IMP_saxs.FormFactorTable_get_dummy_form_factors(self, *args)

    def get_water_form_factors(self):
        r"""get_water_form_factors(FormFactorTable self) -> IMP::Vector< double > const &"""
        return _IMP_saxs.FormFactorTable_get_water_form_factors(self)

    def get_water_vacuum_form_factors(self):
        r"""get_water_vacuum_form_factors(FormFactorTable self) -> IMP::Vector< double > const &"""
        return _IMP_saxs.FormFactorTable_get_water_vacuum_form_factors(self)

    def get_water_dummy_form_factors(self):
        r"""get_water_dummy_form_factors(FormFactorTable self) -> IMP::Vector< double > const &"""
        return _IMP_saxs.FormFactorTable_get_water_dummy_form_factors(self)

    def get_radius(self, *args):
        r"""get_radius(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> double"""
        return _IMP_saxs.FormFactorTable_get_radius(self, *args)

    def get_volume(self, *args):
        r"""get_volume(FormFactorTable self, Particle p, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> double"""
        return _IMP_saxs.FormFactorTable_get_volume(self, *args)

    def show(self, *args):
        r"""show(FormFactorTable self, _ostream out=std::cout, std::string prefix="")"""
        return _IMP_saxs.FormFactorTable_show(self, *args)
    rho_ = property(_IMP_saxs.FormFactorTable_rho__get, _IMP_saxs.FormFactorTable_rho__set, doc=r"""rho_ : double""")
    __swig_destroy__ = _IMP_saxs.delete_FormFactorTable

# Register FormFactorTable in _IMP_saxs:
_IMP_saxs.FormFactorTable_swigregister(FormFactorTable)
cvar = _IMP_saxs.cvar


def get_default_form_factor_table():
    r"""get_default_form_factor_table() -> FormFactorTable"""
    return _IMP_saxs.get_default_form_factor_table()
class Profile(IMP.Object):
    r"""Proxy of C++ IMP::saxs::Profile class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Profile self, std::string const & file_name, bool fit_file=False, double max_q=0.0, int units=1) -> Profile
        __init__(Profile self, double qmin=0.0, double qmax=0.5, double delta=0.005) -> Profile
        """
        _IMP_saxs.Profile_swiginit(self, _IMP_saxs.new_Profile(*args))

    def calculate_profile_partial(self, *args):
        r"""
        calculate_profile_partial(Profile self, IMP::Particles const & particles, IMP::Vector< double > const & surface=IMP::Vector< double >(), IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS)
        calculate_profile_partial(Profile self, IMP::Particles const & particles1, IMP::Particles const & particles2, IMP::Vector< double > const & surface1=IMP::Vector< double >(), IMP::Vector< double > const & surface2=IMP::Vector< double >(), IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS)
        """
        return _IMP_saxs.Profile_calculate_profile_partial(self, *args)

    def calculate_profile_reciprocal_partial(self, *args):
        r"""calculate_profile_reciprocal_partial(Profile self, IMP::Particles const & particles, IMP::Vector< double > const & surface=IMP::Vector< double >(), IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS)"""
        return _IMP_saxs.Profile_calculate_profile_reciprocal_partial(self, *args)

    def calculate_profile(self, *args):
        r"""
        calculate_profile(Profile self, IMP::Particles const & particles, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS, bool reciprocal=False)
        calculate_profile(Profile self, IMP::Particles const & particles1, IMP::Particles const & particles2, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS)
        """
        return _IMP_saxs.Profile_calculate_profile(self, *args)

    def calculate_I0(self, *args):
        r"""calculate_I0(Profile self, IMP::Particles const & particles, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> double"""
        return _IMP_saxs.Profile_calculate_I0(self, *args)

    def calculate_profile_constant_form_factor(self, particles, form_factor=1.0):
        r"""calculate_profile_constant_form_factor(Profile self, IMP::Particles const & particles, double form_factor=1.0)"""
        return _IMP_saxs.Profile_calculate_profile_constant_form_factor(self, particles, form_factor)

    def calculate_profile_symmetric(self, *args):
        r"""calculate_profile_symmetric(Profile self, IMP::Particles const & particles, unsigned int n, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS)"""
        return _IMP_saxs.Profile_calculate_profile_symmetric(self, *args)

    def profile_2_distribution(self, rd, max_distance):
        r"""profile_2_distribution(Profile self, RadialDistributionFunction rd, double max_distance)"""
        return _IMP_saxs.Profile_profile_2_distribution(self, rd, max_distance)

    def distribution_2_profile(self, r_dist):
        r"""distribution_2_profile(Profile self, RadialDistributionFunction r_dist)"""
        return _IMP_saxs.Profile_distribution_2_profile(self, r_dist)

    def resample(self, exp_profile, resampled_profile):
        r"""resample(Profile self, Profile exp_profile, Profile resampled_profile)"""
        return _IMP_saxs.Profile_resample(self, exp_profile, resampled_profile)

    def downsample(self, downsampled_profile, point_number):
        r"""downsample(Profile self, Profile downsampled_profile, unsigned int point_number)"""
        return _IMP_saxs.Profile_downsample(self, downsampled_profile, point_number)

    def radius_of_gyration(self, end_q_rg=1.3):
        r"""radius_of_gyration(Profile self, double end_q_rg=1.3) -> double"""
        return _IMP_saxs.Profile_radius_of_gyration(self, end_q_rg)

    def mean_intensity(self):
        r"""mean_intensity(Profile self) -> double"""
        return _IMP_saxs.Profile_mean_intensity(self)

    def read_SAXS_file(self, file_name, fit_file=False, max_q=0.0, units=1):
        r"""read_SAXS_file(Profile self, std::string const & file_name, bool fit_file=False, double max_q=0.0, int units=1)"""
        return _IMP_saxs.Profile_read_SAXS_file(self, file_name, fit_file, max_q, units)

    def write_SAXS_file(self, file_name, max_q=0.0):
        r"""write_SAXS_file(Profile self, std::string const & file_name, double max_q=0.0)"""
        return _IMP_saxs.Profile_write_SAXS_file(self, file_name, max_q)

    def read_partial_profiles(self, file_name):
        r"""read_partial_profiles(Profile self, std::string const & file_name)"""
        return _IMP_saxs.Profile_read_partial_profiles(self, file_name)

    def write_partial_profiles(self, file_name):
        r"""write_partial_profiles(Profile self, std::string const & file_name)"""
        return _IMP_saxs.Profile_write_partial_profiles(self, file_name)

    def get_delta_q(self):
        r"""get_delta_q(Profile self) -> double"""
        return _IMP_saxs.Profile_get_delta_q(self)

    def get_min_q(self):
        r"""get_min_q(Profile self) -> double"""
        return _IMP_saxs.Profile_get_min_q(self)

    def get_max_q(self):
        r"""get_max_q(Profile self) -> double"""
        return _IMP_saxs.Profile_get_max_q(self)

    def get_intensity(self, i):
        r"""get_intensity(Profile self, unsigned int i) -> double"""
        return _IMP_saxs.Profile_get_intensity(self, i)

    def get_q(self, i):
        r"""get_q(Profile self, unsigned int i) -> double"""
        return _IMP_saxs.Profile_get_q(self, i)

    def get_error(self, i):
        r"""get_error(Profile self, unsigned int i) -> double"""
        return _IMP_saxs.Profile_get_error(self, i)

    def get_weight(self, i):
        r"""get_weight(Profile self, unsigned int i) -> double"""
        return _IMP_saxs.Profile_get_weight(self, i)

    def get_qs(self):
        r"""get_qs(Profile self) -> Eigen::VectorXf const &"""
        return _IMP_saxs.Profile_get_qs(self)

    def get_intensities(self):
        r"""get_intensities(Profile self) -> Eigen::VectorXf const &"""
        return _IMP_saxs.Profile_get_intensities(self)

    def get_errors(self):
        r"""get_errors(Profile self) -> Eigen::VectorXf const &"""
        return _IMP_saxs.Profile_get_errors(self)

    def get_average_radius(self):
        r"""get_average_radius(Profile self) -> double"""
        return _IMP_saxs.Profile_get_average_radius(self)

    def size(self):
        r"""size(Profile self) -> unsigned int"""
        return _IMP_saxs.Profile_size(self)

    def is_uniform_sampling(self):
        r"""is_uniform_sampling(Profile self) -> bool"""
        return _IMP_saxs.Profile_is_uniform_sampling(self)

    def is_partial_profile(self):
        r"""is_partial_profile(Profile self) -> bool"""
        return _IMP_saxs.Profile_is_partial_profile(self)

    def get_name(self):
        r"""get_name(Profile self) -> std::string"""
        return _IMP_saxs.Profile_get_name(self)

    def get_id(self):
        r"""get_id(Profile self) -> unsigned int"""
        return _IMP_saxs.Profile_get_id(self)

    def set_qs(self, q):
        r"""set_qs(Profile self, Eigen::VectorXf const & q)"""
        return _IMP_saxs.Profile_set_qs(self, q)

    def set_intensities(self, i):
        r"""set_intensities(Profile self, Eigen::VectorXf const & i)"""
        return _IMP_saxs.Profile_set_intensities(self, i)

    def set_errors(self, e):
        r"""set_errors(Profile self, Eigen::VectorXf const & e)"""
        return _IMP_saxs.Profile_set_errors(self, e)

    def set_intensity(self, i, iq):
        r"""set_intensity(Profile self, unsigned int i, double iq)"""
        return _IMP_saxs.Profile_set_intensity(self, i, iq)

    def set_ff_table(self, ff_table):
        r"""set_ff_table(Profile self, FormFactorTable ff_table)"""
        return _IMP_saxs.Profile_set_ff_table(self, ff_table)

    def set_average_radius(self, r):
        r"""set_average_radius(Profile self, double r)"""
        return _IMP_saxs.Profile_set_average_radius(self, r)

    def set_average_volume(self, v):
        r"""set_average_volume(Profile self, double v)"""
        return _IMP_saxs.Profile_set_average_volume(self, v)

    def set_name(self, name):
        r"""set_name(Profile self, std::string name)"""
        return _IMP_saxs.Profile_set_name(self, name)

    def set_id(self, id):
        r"""set_id(Profile self, unsigned int id)"""
        return _IMP_saxs.Profile_set_id(self, id)

    def set_beam_profile(self, beam_profile_file):
        r"""set_beam_profile(Profile self, std::string beam_profile_file)"""
        return _IMP_saxs.Profile_set_beam_profile(self, beam_profile_file)

    def add_errors(self):
        r"""add_errors(Profile self)"""
        return _IMP_saxs.Profile_add_errors(self)

    def add_noise(self, percentage=0.03):
        r"""add_noise(Profile self, double percentage=0.03)"""
        return _IMP_saxs.Profile_add_noise(self, percentage)

    def sum_partial_profiles(self, c1, c2, check_cashed=True):
        r"""sum_partial_profiles(Profile self, double c1, double c2, bool check_cashed=True)"""
        return _IMP_saxs.Profile_sum_partial_profiles(self, c1, c2, check_cashed)

    def add(self, *args):
        r"""
        add(Profile self, Profile other_profile, double weight=1.0)
        add(Profile self, IMP::Vector< IMP::saxs::Profile * > const & profiles, IMP::Vector< double > const & weights=IMP::Vector< double >())
        """
        return _IMP_saxs.Profile_add(self, *args)

    def add_partial_profiles(self, *args):
        r"""
        add_partial_profiles(Profile self, Profile other_profile, double weight=1.0)
        add_partial_profiles(Profile self, IMP::Vector< IMP::saxs::Profile * > const & profiles, IMP::Vector< double > const & weights=IMP::Vector< double >())
        """
        return _IMP_saxs.Profile_add_partial_profiles(self, *args)

    def background_adjust(self, start_q):
        r"""background_adjust(Profile self, double start_q)"""
        return _IMP_saxs.Profile_background_adjust(self, start_q)

    def scale(self, c):
        r"""scale(Profile self, double c)"""
        return _IMP_saxs.Profile_scale(self, c)

    def offset(self, c):
        r"""offset(Profile self, double c)"""
        return _IMP_saxs.Profile_offset(self, c)

    def copy_errors(self, exp_profile):
        r"""copy_errors(Profile self, Profile exp_profile)"""
        return _IMP_saxs.Profile_copy_errors(self, exp_profile)

    def get_version_info(self):
        r"""get_version_info(Profile self) -> VersionInfo"""
        return _IMP_saxs.Profile_get_version_info(self)

    def __str__(self):
        r"""__str__(Profile self) -> std::string"""
        return _IMP_saxs.Profile___str__(self)

    def __repr__(self):
        r"""__repr__(Profile self) -> std::string"""
        return _IMP_saxs.Profile___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Profile(o)


# Register Profile in _IMP_saxs:
_IMP_saxs.Profile_swigregister(Profile)
Profile.modulation_function_parameter_ = _IMP_saxs.cvar.Profile_modulation_function_parameter_

class FitParameters(object):
    r"""Proxy of C++ IMP::saxs::FitParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(FitParameters self) -> FitParameters
        __init__(FitParameters self, double chi_square, double c1, double c2, double c, double o) -> FitParameters
        __init__(FitParameters self, double chi_square, double c1, double c2) -> FitParameters
        """
        _IMP_saxs.FitParameters_swiginit(self, _IMP_saxs.new_FitParameters(*args))

    def get_score(self):
        r"""get_score(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_score(self)

    def get_chi_square(self):
        r"""get_chi_square(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_chi_square(self)

    def get_c1(self):
        r"""get_c1(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_c1(self)

    def get_c2(self):
        r"""get_c2(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_c2(self)

    def get_scale(self):
        r"""get_scale(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_scale(self)

    def get_offset(self):
        r"""get_offset(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_offset(self)

    def get_default_chi_square(self):
        r"""get_default_chi_square(FitParameters self) -> double"""
        return _IMP_saxs.FitParameters_get_default_chi_square(self)

    def get_pdb_file_name(self):
        r"""get_pdb_file_name(FitParameters self) -> std::string"""
        return _IMP_saxs.FitParameters_get_pdb_file_name(self)

    def get_profile_file_name(self):
        r"""get_profile_file_name(FitParameters self) -> std::string"""
        return _IMP_saxs.FitParameters_get_profile_file_name(self)

    def get_mol_index(self):
        r"""get_mol_index(FitParameters self) -> int"""
        return _IMP_saxs.FitParameters_get_mol_index(self)

    def set_score(self, score):
        r"""set_score(FitParameters self, double score)"""
        return _IMP_saxs.FitParameters_set_score(self, score)

    def set_chi_square(self, chi_square):
        r"""set_chi_square(FitParameters self, double chi_square)"""
        return _IMP_saxs.FitParameters_set_chi_square(self, chi_square)

    def set_default_chi_square(self, chi_square):
        r"""set_default_chi_square(FitParameters self, double chi_square)"""
        return _IMP_saxs.FitParameters_set_default_chi_square(self, chi_square)

    def set_profile_file_name(self, file_name):
        r"""set_profile_file_name(FitParameters self, std::string file_name)"""
        return _IMP_saxs.FitParameters_set_profile_file_name(self, file_name)

    def set_pdb_file_name(self, file_name):
        r"""set_pdb_file_name(FitParameters self, std::string file_name)"""
        return _IMP_saxs.FitParameters_set_pdb_file_name(self, file_name)

    def set_mol_index(self, index):
        r"""set_mol_index(FitParameters self, int index)"""
        return _IMP_saxs.FitParameters_set_mol_index(self, index)

    def show(self, s):
        r"""show(FitParameters self, _ostream s)"""
        return _IMP_saxs.FitParameters_show(self, s)
    __swig_destroy__ = _IMP_saxs.delete_FitParameters

# Register FitParameters in _IMP_saxs:
_IMP_saxs.FitParameters_swigregister(FitParameters)

class WeightedFitParameters(FitParameters):
    r"""Proxy of C++ IMP::saxs::WeightedFitParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(WeightedFitParameters self) -> WeightedFitParameters
        __init__(WeightedFitParameters self, double chi_square, double c1, double c2, IMP::Vector< double > const & weights) -> WeightedFitParameters
        """
        _IMP_saxs.WeightedFitParameters_swiginit(self, _IMP_saxs.new_WeightedFitParameters(*args))

    def get_weights(self):
        r"""get_weights(WeightedFitParameters self) -> IMP::Vector< double > const &"""
        return _IMP_saxs.WeightedFitParameters_get_weights(self)

    def set_weights(self, weights):
        r"""set_weights(WeightedFitParameters self, IMP::Vector< double > const & weights)"""
        return _IMP_saxs.WeightedFitParameters_set_weights(self, weights)

    def show(self, s):
        r"""show(WeightedFitParameters self, _ostream s)"""
        return _IMP_saxs.WeightedFitParameters_show(self, s)
    __swig_destroy__ = _IMP_saxs.delete_WeightedFitParameters

# Register WeightedFitParameters in _IMP_saxs:
_IMP_saxs.WeightedFitParameters_swigregister(WeightedFitParameters)

class ChiScore(IMP.Object):
    r"""Proxy of C++ IMP::saxs::ChiScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(ChiScore self) -> ChiScore"""
        _IMP_saxs.ChiScore_swiginit(self, _IMP_saxs.new_ChiScore())

    def compute_score(self, exp_profile, model_profile, use_offset=False):
        r"""compute_score(ChiScore self, Profile exp_profile, Profile model_profile, bool use_offset=False) -> double"""
        return _IMP_saxs.ChiScore_compute_score(self, exp_profile, model_profile, use_offset)

    def compute_scale_factor(self, exp_profile, model_profile, offset=0.0):
        r"""compute_scale_factor(ChiScore self, Profile exp_profile, Profile model_profile, double offset=0.0) -> double"""
        return _IMP_saxs.ChiScore_compute_scale_factor(self, exp_profile, model_profile, offset)

    def compute_offset(self, exp_profile, model_profile):
        r"""compute_offset(ChiScore self, Profile exp_profile, Profile model_profile) -> double"""
        return _IMP_saxs.ChiScore_compute_offset(self, exp_profile, model_profile)

    def get_version_info(self):
        r"""get_version_info(ChiScore self) -> VersionInfo"""
        return _IMP_saxs.ChiScore_get_version_info(self)

    def __str__(self):
        r"""__str__(ChiScore self) -> std::string"""
        return _IMP_saxs.ChiScore___str__(self)

    def __repr__(self):
        r"""__repr__(ChiScore self) -> std::string"""
        return _IMP_saxs.ChiScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ChiScore(o)


# Register ChiScore in _IMP_saxs:
_IMP_saxs.ChiScore_swigregister(ChiScore)

class ChiScoreLog(IMP.Object):
    r"""Proxy of C++ IMP::saxs::ChiScoreLog class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(ChiScoreLog self) -> ChiScoreLog"""
        _IMP_saxs.ChiScoreLog_swiginit(self, _IMP_saxs.new_ChiScoreLog())

    def compute_score(self, *args):
        r"""
        compute_score(ChiScoreLog self, Profile exp_profile, Profile model_profile, bool use_offset=False) -> double
        compute_score(ChiScoreLog self, Profile exp_profile, Profile model_profile, double min_q, double max_q) -> double
        """
        return _IMP_saxs.ChiScoreLog_compute_score(self, *args)

    def compute_scale_factor(self, exp_profile, model_profile, offset=0.0):
        r"""compute_scale_factor(ChiScoreLog self, Profile exp_profile, Profile model_profile, double offset=0.0) -> double"""
        return _IMP_saxs.ChiScoreLog_compute_scale_factor(self, exp_profile, model_profile, offset)

    def compute_offset(self, exp_profile, model_profile):
        r"""compute_offset(ChiScoreLog self, Profile exp_profile, Profile model_profile) -> double"""
        return _IMP_saxs.ChiScoreLog_compute_offset(self, exp_profile, model_profile)

    def get_version_info(self):
        r"""get_version_info(ChiScoreLog self) -> VersionInfo"""
        return _IMP_saxs.ChiScoreLog_get_version_info(self)

    def __str__(self):
        r"""__str__(ChiScoreLog self) -> std::string"""
        return _IMP_saxs.ChiScoreLog___str__(self)

    def __repr__(self):
        r"""__repr__(ChiScoreLog self) -> std::string"""
        return _IMP_saxs.ChiScoreLog___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ChiScoreLog(o)


# Register ChiScoreLog in _IMP_saxs:
_IMP_saxs.ChiScoreLog_swigregister(ChiScoreLog)

class ProfileFitterChi(IMP.Object):
    r"""Proxy of C++ IMP::saxs::ProfileFitter< IMP::saxs::ChiScore > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ProfileFitterChi self, Profile exp_profile) -> ProfileFitterChi
        __init__(ProfileFitterChi self, Profile exp_profile, ChiScore sf) -> ProfileFitterChi
        """
        _IMP_saxs.ProfileFitterChi_swiginit(self, _IMP_saxs.new_ProfileFitterChi(*args))

    def compute_score(self, *args):
        r"""compute_score(ProfileFitterChi self, Profile model_profile, bool use_offset=False, std::string const fit_file_name="") -> double"""
        return _IMP_saxs.ProfileFitterChi_compute_score(self, *args)

    def fit_profile(self, *args):
        r"""fit_profile(ProfileFitterChi self, Profile partial_profile, double min_c1=0.95, double max_c1=1.05, double min_c2=-2.0, double max_c2=4.0, bool use_offset=False, std::string const fit_file_name="") -> FitParameters"""
        return _IMP_saxs.ProfileFitterChi_fit_profile(self, *args)

    def compute_scale_factor(self, model_profile, offset=0.0):
        r"""compute_scale_factor(ProfileFitterChi self, Profile model_profile, double offset=0.0) -> double"""
        return _IMP_saxs.ProfileFitterChi_compute_scale_factor(self, model_profile, offset)

    def compute_offset(self, model_profile):
        r"""compute_offset(ProfileFitterChi self, Profile model_profile) -> double"""
        return _IMP_saxs.ProfileFitterChi_compute_offset(self, model_profile)

    def resample(self, model_profile, resampled_profile):
        r"""resample(ProfileFitterChi self, Profile model_profile, Profile resampled_profile)"""
        return _IMP_saxs.ProfileFitterChi_resample(self, model_profile, resampled_profile)

    def write_SAXS_fit_file(self, file_name, model_profile, chi_square, c=1, offset=0):
        r"""write_SAXS_fit_file(ProfileFitterChi self, std::string const & file_name, Profile model_profile, double const chi_square, double const c=1, double const offset=0)"""
        return _IMP_saxs.ProfileFitterChi_write_SAXS_fit_file(self, file_name, model_profile, chi_square, c, offset)

    def get_profile(self):
        r"""get_profile(ProfileFitterChi self) -> Profile"""
        return _IMP_saxs.ProfileFitterChi_get_profile(self)
    __swig_destroy__ = _IMP_saxs.delete_ProfileFitterChi

# Register ProfileFitterChi in _IMP_saxs:
_IMP_saxs.ProfileFitterChi_swigregister(ProfileFitterChi)

class WeightedProfileFitterChi(ProfileFitterChi):
    r"""Proxy of C++ IMP::saxs::WeightedProfileFitter< IMP::saxs::ChiScore > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, exp_profile):
        r"""__init__(WeightedProfileFitterChi self, Profile exp_profile) -> WeightedProfileFitterChi"""
        _IMP_saxs.WeightedProfileFitterChi_swiginit(self, _IMP_saxs.new_WeightedProfileFitterChi(exp_profile))

    def compute_score(self, profiles, weights, use_offset=False, NNLS=True):
        r"""compute_score(WeightedProfileFitterChi self, IMP::saxs::ProfilesTemp const & profiles, IMP::Vector< double > & weights, bool use_offset=False, bool NNLS=True) -> double"""
        return _IMP_saxs.WeightedProfileFitterChi_compute_score(self, profiles, weights, use_offset, NNLS)

    def fit_profile(self, partial_profiles, min_c1=0.95, max_c1=1.05, min_c2=-2.0, max_c2=4.0, use_offset=False):
        r"""fit_profile(WeightedProfileFitterChi self, IMP::saxs::ProfilesTemp partial_profiles, double min_c1=0.95, double max_c1=1.05, double min_c2=-2.0, double max_c2=4.0, bool use_offset=False) -> WeightedFitParameters"""
        return _IMP_saxs.WeightedProfileFitterChi_fit_profile(self, partial_profiles, min_c1, max_c1, min_c2, max_c2, use_offset)

    def write_fit_file(self, partial_profiles, fp, fit_file_name, use_offset=False):
        r"""write_fit_file(WeightedProfileFitterChi self, IMP::saxs::ProfilesTemp partial_profiles, WeightedFitParameters fp, std::string const fit_file_name, bool use_offset=False)"""
        return _IMP_saxs.WeightedProfileFitterChi_write_fit_file(self, partial_profiles, fp, fit_file_name, use_offset)
    __swig_destroy__ = _IMP_saxs.delete_WeightedProfileFitterChi

# Register WeightedProfileFitterChi in _IMP_saxs:
_IMP_saxs.WeightedProfileFitterChi_swigregister(WeightedProfileFitterChi)

class Restraint(IMP.Restraint):
    r"""Proxy of C++ IMP::saxs::Restraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(Restraint self, IMP::Particles const & particles, Profile exp_profile, IMP::saxs::FormFactorType ff_type=HEAVY_ATOMS) -> Restraint"""
        _IMP_saxs.Restraint_swiginit(self, _IMP_saxs.new_Restraint(*args))

        if self.__class__ != Restraint:
            _director_objects.register(self)




    def do_get_inputs(self):
        r"""do_get_inputs(Restraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_saxs.Restraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(Restraint self) -> VersionInfo"""
        return _IMP_saxs.Restraint_get_version_info(self)

# Register Restraint in _IMP_saxs:
_IMP_saxs.Restraint_swigregister(Restraint)

class RadiusOfGyrationRestraint(Restraint):
    r"""Proxy of C++ IMP::saxs::RadiusOfGyrationRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, particles, exp_profile, end_q_rg=1.3):
        r"""__init__(RadiusOfGyrationRestraint self, IMP::Particles const & particles, Profile exp_profile, double const end_q_rg=1.3) -> RadiusOfGyrationRestraint"""
        _IMP_saxs.RadiusOfGyrationRestraint_swiginit(self, _IMP_saxs.new_RadiusOfGyrationRestraint(particles, exp_profile, end_q_rg))

# Register RadiusOfGyrationRestraint in _IMP_saxs:
_IMP_saxs.RadiusOfGyrationRestraint_swigregister(RadiusOfGyrationRestraint)

class FloatDistribution(DistBase):
    r"""Proxy of C++ IMP::saxs::Distribution< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(FloatDistribution self, double bin_size=pr_resolution) -> FloatDistribution"""
        _IMP_saxs.FloatDistribution_swiginit(self, _IMP_saxs.new_FloatDistribution(*args))

    def get_max_distance(self):
        r"""get_max_distance(FloatDistribution self) -> double"""
        return _IMP_saxs.FloatDistribution_get_max_distance(self)

    def get_bin_size(self):
        r"""get_bin_size(FloatDistribution self) -> double"""
        return _IMP_saxs.FloatDistribution_get_bin_size(self)

    def get_index_from_distance(self, dist):
        r"""get_index_from_distance(FloatDistribution self, double dist) -> unsigned int"""
        return _IMP_saxs.FloatDistribution_get_index_from_distance(self, dist)

    def get_distance_from_index(self, index):
        r"""get_distance_from_index(FloatDistribution self, unsigned int index) -> double"""
        return _IMP_saxs.FloatDistribution_get_distance_from_index(self, index)
    __swig_destroy__ = _IMP_saxs.delete_FloatDistribution

# Register FloatDistribution in _IMP_saxs:
_IMP_saxs.FloatDistribution_swigregister(FloatDistribution)

class VectorDistribution(object):
    r"""Proxy of C++ IMP::saxs::Distribution< IMP::algebra::Vector3D > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(VectorDistribution self, double bin_size=pr_resolution) -> VectorDistribution"""
        _IMP_saxs.VectorDistribution_swiginit(self, _IMP_saxs.new_VectorDistribution(*args))

    def get_max_distance(self):
        r"""get_max_distance(VectorDistribution self) -> double"""
        return _IMP_saxs.VectorDistribution_get_max_distance(self)

    def get_bin_size(self):
        r"""get_bin_size(VectorDistribution self) -> double"""
        return _IMP_saxs.VectorDistribution_get_bin_size(self)

    def get_index_from_distance(self, dist):
        r"""get_index_from_distance(VectorDistribution self, double dist) -> unsigned int"""
        return _IMP_saxs.VectorDistribution_get_index_from_distance(self, dist)

    def get_distance_from_index(self, index):
        r"""get_distance_from_index(VectorDistribution self, unsigned int index) -> double"""
        return _IMP_saxs.VectorDistribution_get_distance_from_index(self, index)
    __swig_destroy__ = _IMP_saxs.delete_VectorDistribution

# Register VectorDistribution in _IMP_saxs:
_IMP_saxs.VectorDistribution_swigregister(VectorDistribution)

class RadialDistributionFunction(FloatDistribution):
    r"""Proxy of C++ IMP::saxs::RadialDistributionFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(RadialDistributionFunction self, double bin_size=pr_resolution) -> RadialDistributionFunction
        __init__(RadialDistributionFunction self, std::string const & file_name) -> RadialDistributionFunction
        """
        _IMP_saxs.RadialDistributionFunction_swiginit(self, _IMP_saxs.new_RadialDistributionFunction(*args))

    def scale(self, c):
        r"""scale(RadialDistributionFunction self, double c)"""
        return _IMP_saxs.RadialDistributionFunction_scale(self, c)

    def add(self, model_pr):
        r"""add(RadialDistributionFunction self, RadialDistributionFunction model_pr)"""
        return _IMP_saxs.RadialDistributionFunction_add(self, model_pr)

    def show(self, *args):
        r"""show(RadialDistributionFunction self, _ostream out=std::cout)"""
        return _IMP_saxs.RadialDistributionFunction_show(self, *args)

    def R_factor_score(self, *args):
        r"""R_factor_score(RadialDistributionFunction self, RadialDistributionFunction model_pr, std::string const & file_name="") -> double"""
        return _IMP_saxs.RadialDistributionFunction_R_factor_score(self, *args)

    def fit(self, *args):
        r"""fit(RadialDistributionFunction self, RadialDistributionFunction model_pr, std::string const & file_name="") -> double"""
        return _IMP_saxs.RadialDistributionFunction_fit(self, *args)

    def normalize(self):
        r"""normalize(RadialDistributionFunction self)"""
        return _IMP_saxs.RadialDistributionFunction_normalize(self)

    def add_to_distribution(self, dist, value):
        r"""add_to_distribution(RadialDistributionFunction self, double dist, double value)"""
        return _IMP_saxs.RadialDistributionFunction_add_to_distribution(self, dist, value)
    __swig_destroy__ = _IMP_saxs.delete_RadialDistributionFunction

# Register RadialDistributionFunction in _IMP_saxs:
_IMP_saxs.RadialDistributionFunction_swigregister(RadialDistributionFunction)

class DeltaDistributionFunction(VectorDistribution):
    r"""Proxy of C++ IMP::saxs::DeltaDistributionFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(DeltaDistributionFunction self, IMP::Particles const & particles, double max_distance=0.0, double bin_size=pr_resolution) -> DeltaDistributionFunction"""
        _IMP_saxs.DeltaDistributionFunction_swiginit(self, _IMP_saxs.new_DeltaDistributionFunction(*args))

    def calculate_derivative_distribution(self, particle):
        r"""calculate_derivative_distribution(DeltaDistributionFunction self, Particle particle)"""
        return _IMP_saxs.DeltaDistributionFunction_calculate_derivative_distribution(self, particle)

    def show(self, *args):
        r"""show(DeltaDistributionFunction self, _ostream out=std::cout, std::string prefix="")"""
        return _IMP_saxs.DeltaDistributionFunction_show(self, *args)
    __swig_destroy__ = _IMP_saxs.delete_DeltaDistributionFunction

# Register DeltaDistributionFunction in _IMP_saxs:
_IMP_saxs.DeltaDistributionFunction_swigregister(DeltaDistributionFunction)

class SolventAccessibleSurface(object):
    r"""Proxy of C++ IMP::saxs::SolventAccessibleSurface class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def get_solvent_accessibility(self, points, probe_radius=1.8, density=5.0):
        r"""get_solvent_accessibility(SolventAccessibleSurface self, IMP::core::XYZRs const & points, double probe_radius=1.8, double density=5.0) -> IMP::Vector< double >"""
        return _IMP_saxs.SolventAccessibleSurface_get_solvent_accessibility(self, points, probe_radius, density)

    def __init__(self):
        r"""__init__(SolventAccessibleSurface self) -> SolventAccessibleSurface"""
        _IMP_saxs.SolventAccessibleSurface_swiginit(self, _IMP_saxs.new_SolventAccessibleSurface())
    __swig_destroy__ = _IMP_saxs.delete_SolventAccessibleSurface

# Register SolventAccessibleSurface in _IMP_saxs:
_IMP_saxs.SolventAccessibleSurface_swigregister(SolventAccessibleSurface)

class ProfileFitterChiLog(IMP.Object):
    r"""Proxy of C++ IMP::saxs::ProfileFitter< IMP::saxs::ChiScoreLog > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ProfileFitterChiLog self, Profile exp_profile) -> ProfileFitterChiLog
        __init__(ProfileFitterChiLog self, Profile exp_profile, ChiScoreLog sf) -> ProfileFitterChiLog
        """
        _IMP_saxs.ProfileFitterChiLog_swiginit(self, _IMP_saxs.new_ProfileFitterChiLog(*args))

    def compute_score(self, *args):
        r"""compute_score(ProfileFitterChiLog self, Profile model_profile, bool use_offset=False, std::string const fit_file_name="") -> double"""
        return _IMP_saxs.ProfileFitterChiLog_compute_score(self, *args)

    def fit_profile(self, *args):
        r"""fit_profile(ProfileFitterChiLog self, Profile partial_profile, double min_c1=0.95, double max_c1=1.05, double min_c2=-2.0, double max_c2=4.0, bool use_offset=False, std::string const fit_file_name="") -> FitParameters"""
        return _IMP_saxs.ProfileFitterChiLog_fit_profile(self, *args)

    def compute_scale_factor(self, model_profile, offset=0.0):
        r"""compute_scale_factor(ProfileFitterChiLog self, Profile model_profile, double offset=0.0) -> double"""
        return _IMP_saxs.ProfileFitterChiLog_compute_scale_factor(self, model_profile, offset)

    def compute_offset(self, model_profile):
        r"""compute_offset(ProfileFitterChiLog self, Profile model_profile) -> double"""
        return _IMP_saxs.ProfileFitterChiLog_compute_offset(self, model_profile)

    def resample(self, model_profile, resampled_profile):
        r"""resample(ProfileFitterChiLog self, Profile model_profile, Profile resampled_profile)"""
        return _IMP_saxs.ProfileFitterChiLog_resample(self, model_profile, resampled_profile)

    def write_SAXS_fit_file(self, file_name, model_profile, chi_square, c=1, offset=0):
        r"""write_SAXS_fit_file(ProfileFitterChiLog self, std::string const & file_name, Profile model_profile, double const chi_square, double const c=1, double const offset=0)"""
        return _IMP_saxs.ProfileFitterChiLog_write_SAXS_fit_file(self, file_name, model_profile, chi_square, c, offset)

    def get_profile(self):
        r"""get_profile(ProfileFitterChiLog self) -> Profile"""
        return _IMP_saxs.ProfileFitterChiLog_get_profile(self)
    __swig_destroy__ = _IMP_saxs.delete_ProfileFitterChiLog

# Register ProfileFitterChiLog in _IMP_saxs:
_IMP_saxs.ProfileFitterChiLog_swigregister(ProfileFitterChiLog)

class ProfileFitterRatioVolatility(IMP.Object):
    r"""Proxy of C++ IMP::saxs::ProfileFitter< IMP::saxs::RatioVolatilityScore > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ProfileFitterRatioVolatility self, Profile exp_profile) -> ProfileFitterRatioVolatility
        __init__(ProfileFitterRatioVolatility self, Profile exp_profile, IMP::saxs::RatioVolatilityScore * sf) -> ProfileFitterRatioVolatility
        """
        _IMP_saxs.ProfileFitterRatioVolatility_swiginit(self, _IMP_saxs.new_ProfileFitterRatioVolatility(*args))

    def compute_score(self, *args):
        r"""compute_score(ProfileFitterRatioVolatility self, Profile model_profile, bool use_offset=False, std::string const fit_file_name="") -> double"""
        return _IMP_saxs.ProfileFitterRatioVolatility_compute_score(self, *args)

    def fit_profile(self, *args):
        r"""fit_profile(ProfileFitterRatioVolatility self, Profile partial_profile, double min_c1=0.95, double max_c1=1.05, double min_c2=-2.0, double max_c2=4.0, bool use_offset=False, std::string const fit_file_name="") -> FitParameters"""
        return _IMP_saxs.ProfileFitterRatioVolatility_fit_profile(self, *args)

    def compute_scale_factor(self, model_profile, offset=0.0):
        r"""compute_scale_factor(ProfileFitterRatioVolatility self, Profile model_profile, double offset=0.0) -> double"""
        return _IMP_saxs.ProfileFitterRatioVolatility_compute_scale_factor(self, model_profile, offset)

    def compute_offset(self, model_profile):
        r"""compute_offset(ProfileFitterRatioVolatility self, Profile model_profile) -> double"""
        return _IMP_saxs.ProfileFitterRatioVolatility_compute_offset(self, model_profile)

    def resample(self, model_profile, resampled_profile):
        r"""resample(ProfileFitterRatioVolatility self, Profile model_profile, Profile resampled_profile)"""
        return _IMP_saxs.ProfileFitterRatioVolatility_resample(self, model_profile, resampled_profile)

    def write_SAXS_fit_file(self, file_name, model_profile, chi_square, c=1, offset=0):
        r"""write_SAXS_fit_file(ProfileFitterRatioVolatility self, std::string const & file_name, Profile model_profile, double const chi_square, double const c=1, double const offset=0)"""
        return _IMP_saxs.ProfileFitterRatioVolatility_write_SAXS_fit_file(self, file_name, model_profile, chi_square, c, offset)

    def get_profile(self):
        r"""get_profile(ProfileFitterRatioVolatility self) -> Profile"""
        return _IMP_saxs.ProfileFitterRatioVolatility_get_profile(self)
    __swig_destroy__ = _IMP_saxs.delete_ProfileFitterRatioVolatility

# Register ProfileFitterRatioVolatility in _IMP_saxs:
_IMP_saxs.ProfileFitterRatioVolatility_swigregister(ProfileFitterRatioVolatility)


def get_module_version():
    r"""get_module_version() -> std::string const"""
    return _IMP_saxs.get_module_version()

def get_example_path(fname):
    r"""get_example_path(std::string fname) -> std::string"""
    return _IMP_saxs.get_example_path(fname)

def get_data_path(fname):
    r"""get_data_path(std::string fname) -> std::string"""
    return _IMP_saxs.get_data_path(fname)

from . import _version_check
_version_check.check_version(get_module_version())
__version__ = get_module_version()



